from typing import Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.role_binding_create_role_name import RoleBindingCreateRoleName

T = TypeVar("T", bound="RoleBindingCreate")


@_attrs_define
class RoleBindingCreate:
    """
    Attributes:
        user_id (str):
        role_name (RoleBindingCreateRoleName):
        related_id (str):
    """

    user_id: str
    role_name: RoleBindingCreateRoleName
    related_id: str
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        user_id = self.user_id

        role_name = self.role_name.value

        related_id = self.related_id

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "user_id": user_id,
                "role_name": role_name,
                "related_id": related_id,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        user_id = d.pop("user_id")

        role_name = RoleBindingCreateRoleName(d.pop("role_name"))

        related_id = d.pop("related_id")

        role_binding_create = cls(
            user_id=user_id,
            role_name=role_name,
            related_id=related_id,
        )

        role_binding_create.additional_properties = d
        return role_binding_create

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
