class Pattern:
  # 身份证号
  ID_number_15 = r'^[1-9]\d{5}\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{2}$'
  ID_number = '^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$'

  # 护照
  passport = r'^[a-zA-Z0-9]{5,17}$'

  # 电话号码
  phone_number = r'^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\d{8}$'


class AddressPattern:
  cities = [
    # 普通市
    '(?:自治区|省|新疆|西藏|广西|内蒙古|宁夏)([\\u4e00-\\u9fa5]{1,4}?市)',
    '^[\\u4e00-\\u9fa5]{1,4}?市',
    # 盟
    '(?:内蒙古自治区|内蒙古)((?:锡林郭勒|阿拉善|兴安)盟)',
    '^(?:锡林郭勒|阿拉善|兴安)盟',
    # 自治州
    '(?:自治区|省|新疆)([\\u4e00-\\u9fa5]{4,8}?自治州)',
    '^[\\u4e00-\\u9fa5]{4,8}?自治州',
    # 地区
    '(?:自治区|省|黑龙江|西藏|新疆)([\\u4e00-\\u9fa5]{2,4}?地区)',
    '^[\\u4e00-\\u9fa5]{2,4}?地区',
  ]
  regions = [
    # 省、市及直接到自治县
    '(?:自治区|省|新疆|广西)([\\u4e00-\\u9fa5]{3,8}?自治县)',
    '(?:自治州|市)([\\u4e00-\\u9fa5]{3,8}?自治县)',
    '^[\\u4e00-\\u9fa5]{3,8}?自治县',
    # 少量长度过长的自治县
    '(?:省|云南|甘肃)((?:元江哈尼族彝族傣族|镇沅彝族哈尼族拉祜族|孟连傣族拉祜族佤族|双江拉祜族佤族布朗族傣族|积石山保安族东乡族撒拉族)自治县)',
    '(?:自治州|市)((?:元江哈尼族彝族傣族|镇沅彝族哈尼族拉祜族|孟连傣族拉祜族佤族|双江拉祜族佤族布朗族傣族|积石山保安族东乡族撒拉族)自治县)',
    '^(?:元江哈尼族彝族傣族|镇沅彝族哈尼族拉祜族|孟连傣族拉祜族佤族|双江拉祜族佤族布朗族傣族|积石山保安族东乡族撒拉族)自治县',
    # 省、市及直接到区县
    '(?:自治区|省|新疆|西藏|广西|内蒙古|宁夏)([\\u4e00-\\u9fa5]{1,4}?(?:矿区|园区|区|县|市))',
    '(?:自治州|市|盟)([\\u4e00-\\u9fa5]{1,4}?(?:矿区|园区|区|县|市))',
    '^[\\u4e00-\\u9fa5]{1,4}?(?:矿区|园区|区|县)',
    # 省、市及直接到旗
    '(?:内蒙古自治区|内蒙古)([\\u4e00-\\u9fa5]{2,6}?旗)',
    '[市|盟]([\\u4e00-\\u9fa5]{2,6}?旗)',
    '^[\\u4e00-\\u9fa5]{2,6}?旗',
  ]
