# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/08_commands.ipynb.

# %% auto 0
__all__ = ['make_env_file', 'run_make_env_file']

# %% ../nbs/08_commands.ipynb 3
import os, yaml
from rich.prompt import Prompt
from questionary import Choice, checkbox, Style
from rich.panel import Panel
from rich.prompt import Prompt
from rich.pretty import pprint, Pretty
from rich.panel import Panel
from rich import print
import configparser
import typer
from rich.table import Table
from rich.console import Console
from rich.repr import auto as rich_auto
from rich.pretty import pprint
from dataclasses import dataclass, field
import questionary
from typing import (
    ClassVar, List, Dict, Union, Optional, Tuple, Sequence, Set,
    Any, TypeVar, Type, Callable, cast, no_type_check
)

import subprocess



# %% ../nbs/08_commands.ipynb 4
from .constants import DEFAULT_STYLE, ACCELERATORS, DEFAULT_ACCELERATORS
from .rich import console, cprint, swrap, clist, c_strs
from .typer import app
from .dataclasses import EnvSpec

from litenv.constants import (
    DEP_SEP, HEADER_LINE, HEADER_SEP, HEADER_LEN,
    NAME, NOTE, LEVEL, ALWAYS, PYTHON, CHECKED,
    VERSION, CHANNEL, CHANNELS, PIP_ONLY, 
    CATEGORY, PYPI_NAME, CUDA_ONLY, CATEGORIES,
    DEPENDENCIES, SUBCATEGORIES, NO_ARM_SUPPORT,
    DEFAULT_STYLE, DEFAULT_SPEC_FILE,
    FUCHSIA, BLUE_NIGHT, GOLDEN_SHINE, GREEN_LEAF, RED_VELVET
)

from litenv.themes import (
    THEMES, 
)

# %% ../nbs/08_commands.ipynb 5
@app.command()
def make_env_file(
    name: str = typer.Option(
        'litenv', '--name', '-n',
        help='The name of the environment you want to make.',
    ),

    file: Optional[str] = typer.Option(
        'env.yml', '--file', '-f',
        help='The YAML file to save the environment specifications to.',
    ),

    theme: Optional[str] = typer.Option(
        BLUE_NIGHT, '--theme', '-t',
        help='The theme from which to style choices.',
    ),

    template_file: Optional[str] = typer.Option(
        DEFAULT_SPEC_FILE, '--specification-file', '-s',
        help='The template file from which to generate choices.',
    ),

    prefix_name: Optional[bool] = typer.Option(
        True, '--prefix-name', '-p',
        help='Prefix the environment name to the YAML file.',
    ),

    print_tree: Optional[bool] = typer.Option(
        False, '--print-tree', '-r',
        help='Print the dependency tree.',
    ),

    use_conda: Optional[bool] = typer.Option(
        False, '--conda', '-c',
        help='Use conda to create the environment. Otherwise, use mamba.',
    ),

    make_env: Optional[bool] = typer.Option(
        False, '--make-env', '-m', help='Create the environment.',
    ),

):
    
    if prefix_name:
        file = os.path.join(os.path.dirname(file), name + '.' + os.path.basename(file))
    
    if theme not in THEMES:
        theme = BLUE_NIGHT

    spec = EnvSpec(template_file, theme)

    accel = spec.select_accelerator()
    if accel is None:
        return
    
    selected_catkeys = spec.select_categories()
    if selected_catkeys is None:
        return

    catkey_subkeys = {}
    for catkey in selected_catkeys:                
        selected_subkeys = spec.select_subcategories(catkey)
        if selected_subkeys is None:
            return
        catkey_subkeys[catkey] = selected_subkeys

    env_dict = spec.to_dict(name, catkey_subkeys, accel)
    env_str = spec.dict_to_str(env_dict)    

    if print_tree:
        spec.print_selected(catkey_subkeys)    
        
    with open(file, 'w') as f:
        f.write(env_str)

        
    print(f'Environment saved to [bold]{file}[/bold].')

    command = f"{'conda' if use_conda else 'mamba'} env create -f {file}"
    if make_env:
        confirmed = questionary.confirm('Run {command}?').ask()
        if confirmed:
            subprocess.run(command, shell=True)

# %% ../nbs/08_commands.ipynb 6
def run_make_env_file():     
    app()    
    make_env_file()
