# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_constants.ipynb.

# %% auto 0
__all__ = ['DEFAULT_SPEC_FILENAME', 'DEFAULT_SPEC_FILE', 'HEADER_SEP', 'HEADER_LEN', 'HEADER_LINE', 'DEP_SEP', 'NAME', 'NOTE',
           'LEVEL', 'ALWAYS', 'PYTHON', 'CHECKED', 'VERSION', 'CHANNEL', 'CHANNELS', 'PIP_ONLY', 'CATEGORY',
           'PYPI_NAME', 'CUDA_ONLY', 'CATEGORIES', 'DEPENDENCIES', 'SUBCATEGORIES', 'NO_ARM_SUPPORT', 'DEFAULT_STYLE',
           'FUCHSIA', 'BLUE_NIGHT', 'GOLDEN_SHINE', 'GREEN_LEAF', 'RED_VELVET', 'ACCELERATORS', 'DEFAULT_ACCELERATORS']

# %% ../nbs/02_constants.ipynb 3
import pkg_resources
from questionary import Style

# %% ../nbs/02_constants.ipynb 4
DEFAULT_SPEC_FILENAME = '../data/litenv.yml'
DEFAULT_SPEC_FILE = pkg_resources.resource_filename('litenv', DEFAULT_SPEC_FILENAME)

HEADER_SEP = '-'
HEADER_LEN = 80
HEADER_LINE = HEADER_SEP * HEADER_LEN

DEP_SEP = '::'

# %% ../nbs/02_constants.ipynb 5
NAME = 'name'
NOTE = 'note'
LEVEL = 'level'
ALWAYS = 'always'
PYTHON = 'python'
CHECKED = 'checked'
VERSION = 'version'
CHANNEL = 'channel'
CHANNELS = 'channels'
PIP_ONLY = 'pip_only'
CATEGORY = 'category'
PYPI_NAME = 'pypi_name'
CUDA_ONLY = 'cuda_only'
CATEGORIES = 'categories'
DEPENDENCIES = 'dependencies'
SUBCATEGORIES = 'subcategories'
NO_ARM_SUPPORT = 'no_arm_support'

# %% ../nbs/02_constants.ipynb 6
DEFAULT_STYLE = Style([
    ('qmark', 'fg:#673ab7 bold'),       # token in front of the question
    ('question', 'bold'),               # question text
    ('answer', 'fg:#f44336 bold'),      # submitted answer text behind the question
    ('pointer', 'fg:#673ab7 bold'),     # pointer used in select and checkbox prompts
    ('highlighted', 'fg:#673ab7 bold'), # pointed-at choice in select and checkbox prompts
    ('selected', 'fg:#cc5454'),         # style for a selected item of a checkbox
    ('separator', 'fg:#cc5454'),        # separator in lists
    ('instruction', ''),                # user instructions for select, rawselect, checkbox
    ('text', ''),                       # plain text
    ('disabled', 'fg:#858585 italic')   # disabled choices for select and checkbox prompts
])

# %% ../nbs/02_constants.ipynb 7
FUCHSIA = "fuchsia"
BLUE_NIGHT = "blue_night"
GOLDEN_SHINE = "golden_shine"
GREEN_LEAF = "green_leaf"
RED_VELVET = "red_velvet"

# %% ../nbs/02_constants.ipynb 8
ACCELERATORS = 'accelerators'
DEFAULT_ACCELERATORS = ['mps', 'cpu', 'cuda']
