# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_defaults.ipynb.

# %% auto 0
__all__ = ['TAG_torch', 'TAG_data', 'TAG_utils', 'TAG_sc', 'TAG_nbdev', 'TAG_gnn', 'TAG_cuda', 'TAG_scripts', 'TAG_krishnaswamy',
           'TAG_ode', 'TAG_de', 'TAG_gse', 'TAG_me', 'TAG_test', 'TAG_pkg', 'TAG_misc', 'TAG_extras', 'TAG_jupyter',
           'TAG_favorite', 'TAG_always', 'TAG_plots', 'TAG_optimal_transport', 'TAG_conda', 'TAGS', 'CNL_pytorch',
           'CNL_conda_forge', 'CNL_fastai', 'CNL_bioconda', 'CNL_dglteam', 'CNL_nvidia', 'CHANNELS', 'DEP_python',
           'DEP_pip', 'DEP_tqdm', 'DEP_pyyaml', 'DEP_rich', 'DEP_typer', 'DEP_conda', 'DEP_twine',
           'DEP_anaconda_client', 'DEP_packaging', 'DEP_pytest', 'DEP_notebook', 'DEP_ipykernel', 'DEP_ipywidgets',
           'DEP_jupyter_contrib_nbextensions', 'DEP_nbdev', 'DEP_pytorch', 'DEP_pytorch_cuda', 'DEP_pytorch_lightning',
           'DEP_torchdiffeq', 'DEP_pot', 'DEP_torchdyn', 'DEP_dgl', 'DEP_scikit_learn', 'DEP_pandas', 'DEP_numpy',
           'DEP_scipy', 'DEP_matplotlib', 'DEP_seaborn', 'DEP_scanpy', 'DEP_anndata', 'DEP_scrublet', 'DEP_leidenalg',
           'DEP_gseapy', 'DEP_graphtools', 'DEP_scprep', 'DEP_phate', 'DEP_ms_phate', 'DEP_magic_imput', 'DEP_meld',
           'DEP_diffusion_emd', 'DEP_degex', 'DEP_diffxpy', 'DEP_batchglm', 'DEPS', 'SEC_pip', 'SEC_utils',
           'SEC_scripts', 'SEC_pkg', 'SEC_test', 'SEC_jupyter', 'SEC_nbdev', 'SEC_torch', 'SEC_data', 'SEC_plots',
           'SEC_sc', 'SEC_krishnaswamy', 'SEC_de', 'SECTIONS']

# %% ../nbs/10_defaults.ipynb 3
from .dataclasses import Tag, Channel, YmlEnvDependency, PackageMatchSpecifications, YmlNote, YmlDependencySection

# %% ../nbs/10_defaults.ipynb 5
TAG_torch = Tag('torch', ['pytorch'])

TAG_data = Tag('data-science', ['data-analysis', 'data'])

TAG_utils = Tag('utilities', ['utils'])

TAG_sc = Tag('single-cell', ['sc', 'singlecell'])

TAG_nbdev = Tag('nbdev', ['fastai'])

TAG_gnn = Tag('graph-neural-networks', ['gnn'])

TAG_cuda = Tag('nvidia', ['cuda'])

TAG_scripts = Tag('scripts', ['command-line-interface', 'cli'])

TAG_krishnaswamy = Tag('krishnaswamy-lab', ['kl-lab', 'kllab'])

TAG_ode = Tag('neural-odes', ['ode', 'mioflow'])

TAG_de = Tag('differential-expression', ['de-analysis', 'de'])

TAG_gse = Tag('gene-set-enrichment', ['gse', 'gene-set'])

TAG_me = Tag('personal', ['me'])

TAG_test = Tag('testing', ['test'])

TAG_pkg = Tag('packaging', ['packaging'])

TAG_misc = Tag('miscellaneous', ['misc', ])

TAG_extras = Tag('extras', ['extras', 'extra'])

TAG_jupyter = Tag('jupyter', ['notebook', 'ipy'])

TAG_favorite = Tag('favorite', ['favorite', 'fav'])

TAG_always = Tag('always', [])

TAG_plots = Tag('plotting', ['plots'])

TAG_optimal_transport = Tag('optimal-transport', ['ot', 'optimal-transport'])

TAG_conda = Tag('conda', ['conda', 'conda-plugins'])

TAGS = [
    TAG_torch, TAG_data, TAG_utils, 
    TAG_sc, TAG_nbdev, TAG_gnn, TAG_cuda,
    TAG_scripts, TAG_krishnaswamy, TAG_ode, TAG_de, 
    TAG_gse, TAG_me, TAG_test, TAG_pkg, 
    TAG_misc, TAG_extras, TAG_jupyter, 
    TAG_always, TAG_favorite, TAG_plots, TAG_optimal_transport, TAG_conda
]

# %% ../nbs/10_defaults.ipynb 7
CNL_pytorch = Channel('pytorch', tags=[TAG_torch])

CNL_conda_forge = Channel('conda-forge', tags=[TAG_torch, TAG_data, TAG_sc])

CNL_fastai = Channel('fastai', tags=[TAG_nbdev])

CNL_bioconda = Channel('bioconda', tags=[TAG_sc])

CNL_dglteam = Channel('dglteam', tags=[TAG_gnn])

CNL_nvidia = Channel('nvidia', tags=[TAG_cuda], cuda_only=True)

CHANNELS = [
    CNL_pytorch, CNL_conda_forge, CNL_fastai, CNL_bioconda, CNL_dglteam, CNL_nvidia
]

# %% ../nbs/10_defaults.ipynb 10
## always
DEP_python = YmlEnvDependency('python', '>3.10', tags=[TAG_always])

## only if there are pip packages
DEP_pip = YmlEnvDependency('pip', tags=[], section='pip')

## Utilities
DEP_tqdm = YmlEnvDependency('tqdm', tags=[TAG_always, TAG_utils], section='utilities',)
DEP_pyyaml = YmlEnvDependency('pyyaml',  tags=[TAG_utils, TAG_extras], section='utilities',)

## Scripting
DEP_rich = YmlEnvDependency('rich',  tags=[TAG_scripts], section='scripting',)
DEP_typer = YmlEnvDependency('typer',  tags=[TAG_scripts], section='scripting',)

## Packaging
DEP_conda = YmlEnvDependency('conda', tags=[TAG_conda], section='packaging', notes=[YmlNote('for conda plugins')])
DEP_twine = YmlEnvDependency('twine', tags=[TAG_pkg], section='packaging', notes=[YmlNote('for publishing to pypi')])
DEP_anaconda_client = YmlEnvDependency('anaconda-client', tags=[TAG_pkg], section='packaging', notes=[YmlNote('for publishing to conda')], )
DEP_packaging = YmlEnvDependency('packaging', tags=[TAG_pkg, TAG_extras], section='packaging',)

## Testing
DEP_pytest = YmlEnvDependency('pytest', tags=[TAG_test], section='testing',)

## Jupyter
DEP_notebook = YmlEnvDependency('notebook', tags=[TAG_always, TAG_jupyter], channel=CNL_conda_forge, section='jupyter')
DEP_ipykernel = YmlEnvDependency('ipykernel',  tags=[TAG_always, TAG_jupyter], channel=CNL_conda_forge, section='jupyter')
DEP_ipywidgets = YmlEnvDependency('ipywidgets',  tags=[TAG_always, TAG_jupyter], channel=CNL_conda_forge, section='jupyter')
DEP_jupyter_contrib_nbextensions = YmlEnvDependency('jupyter_contrib_nbextensions',  tags=[TAG_always, TAG_jupyter], channel=CNL_conda_forge, section='jupyter')

## nbdev
DEP_nbdev = YmlEnvDependency('nbdev', '>=2.3.12', tags=[TAG_always, TAG_nbdev], channel=CNL_fastai, section='nbdev')

## PyTorch
DEP_pytorch = YmlEnvDependency('pytorch', pypi_name='torch', tags=[TAG_torch], section='torch')
DEP_pytorch_cuda = YmlEnvDependency(
    'pytorch-cuda', cuda_only=True, conda_only=True, channel=CNL_pytorch, tags=[TAG_cuda, TAG_torch],  section='torch',
    notes=[YmlNote('add pytorch-cuda if using a CUDA enabled GPU. You will need to remove this if you are on Apple Silicon')]
)
DEP_pytorch_lightning = YmlEnvDependency('pytorch-lightning', tags=[TAG_torch], section='torch')
DEP_torchdiffeq = YmlEnvDependency('torchdiffeq', tags=[TAG_ode], section='torch')
DEP_pot = YmlEnvDependency('pot', pip_only=True, tags=[TAG_optimal_transport], section='torch')
DEP_torchdyn = YmlEnvDependency('torchdyn', '==1.0.3', pip_only=True, tags=[TAG_ode], section='torch')
DEP_dgl = YmlEnvDependency(
    'dgl', no_arm_support=True, tags=[TAG_gnn], channel=CNL_dglteam, section='torch',
    notes=[YmlNote('dgl is not built for ARM (e.g. Apple Silicon) on dglteam. You can install it via pip.')]
)

## Data Science
DEP_scikit_learn = YmlEnvDependency('scikit-learn', tags=[TAG_data], channel=CNL_conda_forge, section='data-science')
DEP_pandas = YmlEnvDependency('pandas', tags=[TAG_data], section='data-science')
DEP_numpy = YmlEnvDependency('numpy', tags=[TAG_data], section='data-science')
DEP_scipy = YmlEnvDependency('scipy', tags=[TAG_data], section='data-science')

## Plotting
DEP_matplotlib = YmlEnvDependency('matplotlib', tags=[TAG_plots], channel=CNL_conda_forge, section='plotting')
DEP_seaborn = YmlEnvDependency('seaborn', tags=[TAG_plots], channel=CNL_conda_forge, section='plotting')

## Single Cell
DEP_scanpy = YmlEnvDependency('scanpy', tags=[TAG_sc], channel=CNL_conda_forge, section='single-cell')
DEP_anndata = YmlEnvDependency('anndata', tags=[TAG_sc], channel=CNL_conda_forge, section='single-cell')
DEP_scrublet = YmlEnvDependency('scrublet', pip_only=True, tags=[TAG_sc, TAG_extras], section='single-cell')
DEP_leidenalg = YmlEnvDependency('leidenalg', tags=[TAG_sc, TAG_extras], section='single-cell')
DEP_gseapy = YmlEnvDependency('gseapy', tags=[TAG_sc, TAG_gse, TAG_extras], notes=[YmlNote('for gene set enrichment analysis')], section='single-cell')

## Krishnaswamy Lab
DEP_graphtools = YmlEnvDependency('graphtools', tags=[TAG_krishnaswamy, TAG_extras], section='krishnaswamy-lab')
DEP_scprep = YmlEnvDependency('scprep', tags=[TAG_krishnaswamy, TAG_sc], channel=CNL_bioconda, section='krishnaswamy-lab')
DEP_phate = YmlEnvDependency(
    'phate', tags=[], section='krishnaswamy-lab',
    notes=[YmlNote('phate requires s_gd2 which is not built for ARM (e.g. Apple Silicon) on conda-forge. You can install it via pip.')]
)
DEP_ms_phate = YmlEnvDependency(
    'git+https://github.com/KrishnaswamyLab/Multiscale_PHATE', pip_only=True, 
    tags=[TAG_krishnaswamy, TAG_extras], section='krishnaswamy-lab'
)
DEP_magic_imput = YmlEnvDependency('magic-imput', pip_only=True, tags=[TAG_krishnaswamy, TAG_extras], section='Krishnaswamy Lab')
DEP_meld = YmlEnvDependency('meld', pip_only=True, tags=[TAG_krishnaswamy, TAG_extras], section='Krishnaswamy Lab')
DEP_diffusion_emd = YmlEnvDependency('DiffusionEMD', pip_only=True, tags=[TAG_krishnaswamy, TAG_optimal_transport, TAG_extras], section='krishnaswamy-lab')
DEP_degex = YmlEnvDependency(
    'degex', pip_only=True, tags=[TAG_sc, TAG_extras, TAG_me, TAG_krishnaswamy], 
    notes=[YmlNote('personal collection of utility functions developed with Scott Youlten')],
    section='krishnaswamy-lab'
)

## DE
DEP_diffxpy = YmlEnvDependency('diffxpy', pip_only=True, tags=[TAG_de], 
                               notes=[YmlNote('requires batchglm')], section='differential-expression')
DEP_batchglm = YmlEnvDependency('batchglm', pip_only=True, tags=[TAG_de], 
                                notes=[YmlNote('requires tensorflow and tensorflow probability')], section='differential-expression')


# %% ../nbs/10_defaults.ipynb 11
DEPS = [
    DEP_python,
    DEP_pip,
    DEP_tqdm,
    DEP_rich,
    DEP_typer,
    DEP_notebook,
    DEP_ipykernel,
    DEP_ipywidgets,
    DEP_jupyter_contrib_nbextensions,
    DEP_nbdev,
    DEP_pytorch,
    DEP_pytorch_cuda,
    DEP_pytorch_lightning,
    DEP_torchdiffeq,
    DEP_dgl,
    DEP_matplotlib,
    DEP_seaborn,
    DEP_scikit_learn,
    DEP_pandas,
    DEP_numpy,
    DEP_scipy,
    DEP_scanpy,
    DEP_anndata,
    DEP_leidenalg,
    DEP_gseapy,
    DEP_graphtools,
    DEP_scprep,
    DEP_phate,
    DEP_pot,
    DEP_torchdyn,
    DEP_scrublet,
    DEP_magic_imput,
    DEP_meld,
    DEP_diffusion_emd,
    DEP_degex,
    DEP_diffxpy,
    DEP_batchglm,
    DEP_conda,
    DEP_twine,
    DEP_anaconda_client,
    DEP_packaging,
    DEP_pyyaml,
    DEP_pytest,
]

# %% ../nbs/10_defaults.ipynb 14
# DEP_python,
SEC_pip = YmlDependencySection('Pip / non-conda packages', [DEP_pip])

SEC_utils = YmlDependencySection('Utilities', [DEP_tqdm, DEP_pyyaml])

SEC_scripts = YmlDependencySection('Scripting', [DEP_rich, DEP_typer])

SEC_pkg = YmlDependencySection('Packaging', [DEP_conda, DEP_twine, DEP_anaconda_client, DEP_packaging,])

SEC_test = YmlDependencySection('Testing', [DEP_pytest])

SEC_jupyter = YmlDependencySection('Jupyter Notebook', [
    DEP_notebook, DEP_ipykernel, DEP_ipywidgets, DEP_jupyter_contrib_nbextensions
])

SEC_nbdev = YmlDependencySection('nbdev', [DEP_nbdev])

SEC_torch = YmlDependencySection('PyTorch & Deep Learning', [
    DEP_pytorch, DEP_pytorch_cuda, DEP_pytorch_lightning, 
    DEP_torchdiffeq, DEP_dgl, DEP_pot, DEP_torchdyn
])

SEC_data = YmlDependencySection('Data Science', [
    DEP_scikit_learn, DEP_pandas, DEP_numpy, DEP_scipy,
])

SEC_plots = YmlDependencySection('Plotting', [DEP_matplotlib, DEP_seaborn,])

SEC_sc = YmlDependencySection('Single-Cell', [
    DEP_scanpy, DEP_anndata, DEP_leidenalg, DEP_gseapy,
    DEP_scrublet,
])

SEC_krishnaswamy = YmlDependencySection('Krishnaswamy Lab', [
    DEP_graphtools, DEP_scprep, DEP_phate,
    DEP_magic_imput, DEP_meld, DEP_diffusion_emd,
    DEP_degex,
])

SEC_de = YmlDependencySection('Differential Expression', [DEP_diffxpy, DEP_batchglm,])

# %% ../nbs/10_defaults.ipynb 15
SECTIONS = [
    SEC_pip,
    SEC_utils, SEC_scripts, SEC_pkg, SEC_test, SEC_jupyter, SEC_nbdev,
    SEC_torch, SEC_data, SEC_plots, SEC_sc, SEC_krishnaswamy, SEC_de, 
]
