# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_rich.ipynb.

# %% auto 0
__all__ = ['console', 'swrap', 'cprint', 'clist', 'c_strs']

# %% ../nbs/06_rich.ipynb 3
from rich.table import Table
from rich.console import Console

# %% ../nbs/06_rich.ipynb 4
console = Console()

# %% ../nbs/06_rich.ipynb 5
def swrap(style:str, text:str) -> str:
    return f'[{style}]{text}[/{style}]'

def cprint(style:str, text:str) -> None:
    console.print(swrap(style, text))

def clist(style:str, items:list) -> str:
    list_str = '['
    for i, item in enumerate(items):
        item_str = swrap(style, str(item))
        list_str += f'{item_str}'
        list_str += ', ' if i < len(items) - 1 else ']'
    return list_str

def c_strs(style:str, items:list) -> str:
    list_str = '['
    for i, item in enumerate(items):
        item_str = swrap(style, f'"{item}"')
        list_str += f'{item_str}'
        list_str += ', ' if i < len(items) - 1 else ']'
    
    return list_str
