# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/09_themes.ipynb.

# %% auto 0
__all__ = ['cyan_focused_theme', 'cyan_dark_theme', 'soft_cyan_theme', 'fuchsia_focus_theme', 'blue_night_theme',
           'golden_shine_theme', 'green_leaf_theme', 'red_velvet_theme', 'fuchsia_choice_theme',
           'blue_night_choice_theme', 'golden_shine_choice_theme', 'green_leaf_choice_theme', 'red_velvet_choice_theme',
           'themes', 'THEMES', 'Theme']

# %% ../nbs/09_themes.ipynb 3
import os, yaml
from typing import Dict, List, Union, Optional, Any
from questionary import Style
from dataclasses import dataclass, field
from rich.repr import auto as rich_auto, Result as RichReprResult

# %% ../nbs/09_themes.ipynb 4
from litenv.constants import (
    FUCHSIA, BLUE_NIGHT, GOLDEN_SHINE, GREEN_LEAF, RED_VELVET
)

# %% ../nbs/09_themes.ipynb 5
'''
"qmark"       = token in front of the question
"question"    = question text
"answer"      = submitted answer text behind the question
"pointer"     = pointer used in select and checkbox prompts
"highlighted" = pointed-at choice in select and checkbox prompts
"selected"    = pointer used in select and checkbox prompts
"separator"   = separator in lists
"instruction" = user instructions for select, rawselect, checkbox
"text"        = plain text
"disabled"    = disabled choices for select and checkbox prompts
'''

cyan_focused_theme = Style([
    ("qmark", "fg:cyan"),
    ("question", "bold"),
    ("selected", "fg:white bg:cyan"),
    ("pointer", "fg:cyan bold"),
    ("instruction", ""),
    ("answer", "fg:cyan bold"),
])

cyan_dark_theme = Style([
    ("qmark", "fg:cyan"),
    ("question", "bold"),
    ("selected", "fg:white bg:black"),
    ("pointer", "fg:cyan bold"),
    ("instruction", ""),
    ("answer", "fg:cyan bold"),
])


soft_cyan_theme = Style([
    ("qmark", "fg:#00ffff"),
    ("question", "bold"),
    ("selected", "fg:#ffffff bg:#00ffff"),
    ("pointer", "fg:#00ffff bold"),
    ("instruction", ""),
    ("answer", "fg:#00ffff bold"),
])


fuchsia_focus_theme = Style([
    ("qmark", "fg:#FF00FF"), 
    ("question", "bold"),  
    ("selected", "fg:white bg:#FF00FF"),  
    ("pointer", "fg:#FF00FF bold"),  
    ("instruction", ""),  
    ("answer", "fg:#FF00FF bold"),  
])

blue_night_theme = Style([
    ("qmark", "fg:#0000FF"), 
    ("question", "bold"),  
    ("selected", "fg:white bg:#0000FF"),  
    ("pointer", "fg:#0000FF bold"),  
    ("instruction", ""),  
    ("answer", "fg:#0000FF bold"),  
])

golden_shine_theme = Style([
    ("qmark", "fg:#FFD700"), 
    ("question", "bold"),  
    ("selected", "fg:black bg:#FFD700"),  
    ("pointer", "fg:#FFD700 bold"),  
    ("instruction", ""),  
    ("answer", "fg:#FFD700 bold"),  
])

green_leaf_theme = Style([
    ("qmark", "fg:#008000"), 
    ("question", "bold"),  
    ("selected", "fg:white bg:#008000"),  
    ("pointer", "fg:#008000 bold"),  
    ("instruction", ""),  
    ("answer", "fg:#008000 bold"),  
])

red_velvet_theme = Style([
    ("qmark", "fg:#B22222"), 
    ("question", "bold"),  
    ("selected", "fg:white bg:#B22222"),  
    ("pointer", "fg:#B22222 bold"),  
    ("instruction", ""),  
    ("answer", "fg:#B22222 bold"),  
])

fuchsia_choice_theme = Style([
    ("text", "fg:#FF00FF"), 
])

blue_night_choice_theme = Style([
    ("text", "fg:#0000FF"), 
])

golden_shine_choice_theme = Style([
    ("text", "fg:#FFD700"), 
])

green_leaf_choice_theme = Style([
    ("text", "fg:#008000"), 
])

red_velvet_choice_theme = Style([
    ("text", "fg:#B22222"), 
])

# %% ../nbs/09_themes.ipynb 6
@dataclass
@rich_auto(angular=True)
class Theme:
    name: str
    choice: Optional[Style]
    checkbox: Optional[Style]

# %% ../nbs/09_themes.ipynb 7
themes = [
    Theme(FUCHSIA, fuchsia_focus_theme, fuchsia_choice_theme),
    Theme(BLUE_NIGHT, blue_night_theme, blue_night_choice_theme),
    Theme(GOLDEN_SHINE, golden_shine_theme, golden_shine_choice_theme),
    Theme(GREEN_LEAF, green_leaf_theme, green_leaf_choice_theme),
    Theme(RED_VELVET, red_velvet_theme, red_velvet_choice_theme),
]
THEMES = {theme.name: theme for theme in themes}
