# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/11_yml.ipynb.

# %% auto 0
__all__ = ['NAME', 'NOTE', 'ALWAYS', 'PYTHON', 'CHECKED', 'VERSION', 'CHANNEL', 'CHANNELS', 'PIP_ONLY', 'CATEGORY', 'PYPI_NAME',
           'CUDA_ONLY', 'CATEGORIES', 'DEPENDECIES', 'SUBCATEGORIES', 'NO_ARM_SUPPORT', 'LitEnvYamlSpecification']

# %% ../nbs/11_yml.ipynb 3
import os, yaml
import re, textwrap
from typing import List, Optional, Set, Union, Dict
from dataclasses import dataclass, field
from rich.repr import auto as rich_auto, Result as RichReprResult

# %% ../nbs/11_yml.ipynb 4
from .constants import DEFAULT_SPEC_FILE, HEADER_LINE, DEP_SEP
from .paths import ROOT_DIR
from .dataclasses import  Accelerator

# %% ../nbs/11_yml.ipynb 6
NAME = 'name'
NOTE = 'note'
ALWAYS = 'always'
PYTHON = 'python'
CHECKED = 'checked'
VERSION = 'version'
CHANNEL = 'channel'
CHANNELS = 'channels'
PIP_ONLY = 'pip_only'
CATEGORY = 'category'
PYPI_NAME = 'pypi_name'
CUDA_ONLY = 'cuda_only'
CATEGORIES = 'categories'
DEPENDECIES = 'dependencies'
SUBCATEGORIES = 'subcategories'
NO_ARM_SUPPORT = 'no_arm_support'

@dataclass
@rich_auto(angular=True)
class LitEnvYamlSpecification:
    filename: str = DEFAULT_SPEC_FILE

    def __post_init__(self):
        with open(self.filename, 'r') as file:
            self.data = yaml.safe_load(file)
        
        self.python_version = self.data.get(PYTHON, None)
        self.channels = self.data.get(CHANNELS, [])
        
        self.categories = self.data.get(CATEGORIES, {})
        self.category_keys = self.get_all_category_keys()
        self.category_names = self.get_all_category_names()
        self.catkeys_to_subkeys = self.make_catkeys_to_subkeys()
        self.dependecies = self.get_all_dependencies()
        

    
    def get_name_of_subdict(self, key:str, data:dict):
        return data.get(NAME, key)
    
    def get_category(self, catkey:str) -> dict:
        return self.categories[catkey]
    
    def get_subcategories(self, catkey:str) -> dict:
        return self.get_category(catkey).get(SUBCATEGORIES, {})
    
    def get_subcategory(self, catkey:str, subkey:str) -> dict:
        return self.get_subcategories(catkey).get(subkey, {})
    
    def get_subcategory_name(self, catkey:str, subkey:str) -> dict:
        return self.get_name_of_subdict(subkey, self.get_subcategory(catkey, subkey))
        
    def get_all_category_keys(self) -> List[str]:
        return list(self.categories.keys())
    
    def get_subcategories_keys(self, catkey:str) -> List[str]:
        return list(self.get_subcategories(catkey).keys())
    
    def get_category_name(self, catkey:str) -> str:
        return self.get_name_of_subdict(catkey, self.categories[catkey])

    def is_category_checked(self, catkey:str) -> str:
        return self.get_category(catkey).get(CHECKED, False)
    
    def is_subcategory_checked(self, catkey:str, subkey:str) -> str:
        return self.get_subcategory(catkey, subkey).get(CHECKED, False)
    
    def get_subcategory_name(self, catkey:str, subkey:str) -> str:        
        return self.get_name_of_subdict(subkey, self.get_subcategory(catkey, subkey))
    
    def get_all_category_names(self) -> List[str]:        
        return [self.get_category_name(catkey) for catkey in self.category_keys]

    
    def make_catkeys_to_subkeys(self) -> Dict[str, List[str]]:
        catkey_map = dict()
        for catkey in self.category_keys:
            subkeys = self.get_subcategories_keys(catkey)
            catkey_map[catkey] = subkeys
        return catkey_map
    
    def get_all_subcategories_keys(self) -> List[str]:
        results = []
        for catkey, subkeys in self.catkeys_to_subkeys.items():
            results.extend(subkeys)
        return results
    
    def get_all_subcategory_names(self) -> List[str]:  
        results = []
        for catkey, subkeys in self.catkeys_to_subcatkeys.items():
            for subkey in subkeys:
                results.append(self.get_subcategory_name(catkey, subkey))
        return results      

    def get_all_keys(self):
        return self.category_keys + self.get_all_subcategories_keys()
    
    def get_all_names(self):
        return self.category_names + self.get_all_subcategory_names()
    
    def get_category_dependencies(self, catkey:str) -> List[str]:
        return self.get_category(catkey).get(DEPENDECIES, {})
    
    def get_subcategory_dependencies(self, catkey:str, subkey:str) -> List[str]:
        return self.get_subcategory(catkey, subkey).get(DEPENDECIES, {})

    def get_all_dependencies(self) -> List[str]:
        dependencies = []
        for catkey, subkeys in self.catkeys_to_subkeys.items():
            deps = self.get_category_dependencies(catkey)
            dependencies += list(deps.keys())
            for subkey in subkeys:
                deps = self.get_subcategory_dependencies(catkey, subkey)
                dependencies += list(deps.keys())                
        return dependencies



    def to_dict(
        self, 
        key_subs:Dict[str, List[str]],
        accelerator:str='cpu',
    ) -> dict:
        accel = Accelerator(accelerator)        
        cnd_deps = list([f'{PYTHON}{self.python_version}'])
        pip_deps = list()
                
        for catkey, subkeys in key_subs.items():
            cnd_deps, pip_deps = handle_category(
                cnd_deps, pip_deps, accel,
                catkey, self.get_category(catkey),                
                subcategories_to_include=subkeys
            )
            
        if len(pip_deps) > 0:
            cnd_deps.append('pip')
            cnd_deps.append(dict(pip=pip_deps))

        res = dict(dependecies=cnd_deps)

        with open('output.yml', 'w') as file:
            yaml.dump(res, file)

        return res
