(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(exports, require("react"), require("@darajs/core"), require("styled-components"), require("react-dom")) : typeof define === "function" && define.amd ? define(["exports", "react", "@darajs/core", "styled-components", "react-dom"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory((global2.dara = global2.dara || {}, global2.dara.components = {}), global2.React, global2.dara.core, global2.styled, global2.ReactDOM));
})(this, function(exports2, React, core$2, styled, ReactDOM) {
  var _a2;
  "use strict";
  const _interopDefaultLegacy = (e3) => e3 && typeof e3 === "object" && "default" in e3 ? e3 : { default: e3 };
  function _interopNamespace(e3) {
    if (e3 && e3.__esModule)
      return e3;
    const n2 = Object.create(null, { [Symbol.toStringTag]: { value: "Module" } });
    if (e3) {
      for (const k2 in e3) {
        if (k2 !== "default") {
          const d2 = Object.getOwnPropertyDescriptor(e3, k2);
          Object.defineProperty(n2, k2, d2.get ? d2 : {
            enumerable: true,
            get: () => e3[k2]
          });
        }
      }
    }
    n2.default = e3;
    return Object.freeze(n2);
  }
  const React__default = /* @__PURE__ */ _interopDefaultLegacy(React);
  const React__namespace = /* @__PURE__ */ _interopNamespace(React);
  const styled__default = /* @__PURE__ */ _interopDefaultLegacy(styled);
  const ReactDOM__default = /* @__PURE__ */ _interopDefaultLegacy(ReactDOM);
  const theme$3 = {
    colors: {
      primary: "#3796F6",
      primaryHover: "#0079D4",
      primaryDown: "#0060AA",
      secondary: "#434B87",
      secondaryHover: "#4E568E",
      secondaryDown: "#5A629C",
      background: "#F8F9FF",
      text: "#1E244D",
      grey1: "#EEF1FA",
      grey2: "#DFE2EB",
      grey3: "#C3C6CF",
      grey4: "#8D9199",
      grey5: "#5B5E66",
      grey6: "#43474E",
      blue1: "#FBFCFF",
      blue2: "#ECF2FD",
      blue3: "#E1EEFD",
      blue4: "#C4DFFC",
      violet: "#5E62E2",
      turquoise: "#2CB85C",
      purple: "#E28FFF",
      teal: "#0790AE",
      orange: "#FF8F80",
      plum: "#BA3C8B",
      error: "#DA6087",
      errorHover: "#D14975",
      errorDown: "#C33462",
      success: "#2DB3BF",
      successHover: "#1CA6B2",
      successDown: "#149AA7",
      warning: "#DCB016",
      warningHover: "#D0A406",
      warningDown: "#C39800",
      modalBg: "rgba(19, 25, 35, 0.5)",
      shadowLight: "rgba(0, 0, 0, 0.1)",
      shadowMedium: "rgba(0, 0, 0, 0.1)"
    },
    font: {
      size: "16px"
    },
    shadow: {
      light: "0px 2px 4px rgba(0, 0, 0, 0.1)",
      medium: "0px 2px 10px rgba(0, 0, 0, 0.1)"
    },
    themeType: "light"
  };
  const darkTheme$1 = {
    colors: {
      primary: "#2485E8",
      primaryHover: "#4799EB",
      primaryDown: "#5EA3E9",
      secondary: "#BEC5EE",
      secondaryHover: "#CAD0F4",
      secondaryDown: "#D3D8F4",
      background: "#111314",
      text: "#EDEEFA",
      grey1: "#32373D",
      grey2: "#43474E",
      grey3: "#5B5E66",
      grey4: "#8D9199",
      grey5: "#C3C6CF",
      grey6: "#DFE2EB",
      blue1: "#252A31",
      blue2: "#25323F",
      blue3: "#203750",
      blue4: "#204368",
      violet: "#5E31DC",
      turquoise: "#109C41",
      purple: "#D96FFF",
      teal: "#00849F",
      orange: "#DB6D5E",
      plum: "#AB2178",
      error: "#CA456F",
      errorHover: "#D1567E",
      errorDown: "#D7688B",
      success: "#1A9FAC",
      successHover: "#27A9B6",
      successDown: "#34B4C0",
      warning: "#C8981F",
      warningHover: "#D7A526",
      warningDown: "#E2B235",
      modalBg: "rgba(19, 25, 35, 0.5)",
      shadowLight: "rgba(0, 0, 0, 0.1)",
      shadowMedium: "rgba(0, 0, 0, 0.1)"
    },
    font: {
      size: "16px"
    },
    shadow: {
      light: "0px 2px 4px rgba(0, 0, 0, 0.1)",
      medium: "0px 2px 10px rgba(0, 0, 0, 0.1)"
    },
    themeType: "dark"
  };
  function useClTheme() {
    return styled.useTheme();
  }
  var Key;
  (function(Key2) {
    Key2["BACKSPACE"] = "Backspace";
    Key2["CTRL"] = "Control";
    Key2["DOWN"] = "ArrowDown";
    Key2["ENTER"] = "Enter";
    Key2["ESCAPE"] = "Escape";
    Key2["LEFT"] = "ArrowLeft";
    Key2["META"] = "Meta";
    Key2["MINUS"] = "-";
    Key2["PERIOD"] = ".";
    Key2["RIGHT"] = "ArrowRight";
    Key2["SHIFT"] = "Shift";
    Key2["TAB"] = "Tab";
    Key2["UP"] = "ArrowUp";
  })(Key || (Key = {}));
  const CONTROL_KEYS = [
    Key.ESCAPE,
    Key.TAB,
    Key.ENTER,
    Key.BACKSPACE,
    Key.CTRL,
    Key.SHIFT,
    Key.UP,
    Key.DOWN,
    Key.LEFT,
    Key.RIGHT,
    Key.META
  ];
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  function getAugmentedNamespace$1(n2) {
    var f2 = n2.default;
    if (typeof f2 == "function") {
      var a2 = function() {
        return f2.apply(this, arguments);
      };
      a2.prototype = f2.prototype;
    } else
      a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n2).forEach(function(k2) {
      var d2 = Object.getOwnPropertyDescriptor(n2, k2);
      Object.defineProperty(a2, k2, d2.get ? d2 : {
        enumerable: true,
        get: function() {
          return n2[k2];
        }
      });
    });
    return a2;
  }
  var jsxRuntime = { exports: {} };
  var reactJsxRuntime_production_min = {};
  /**
   * @license React
   * react-jsx-runtime.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var f$5 = React__default.default, k$5 = Symbol.for("react.element"), l$5 = Symbol.for("react.fragment"), m$4 = Object.prototype.hasOwnProperty, n$6 = f$5.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, p$6 = { key: true, ref: true, __self: true, __source: true };
  function q$4(c2, a2, g2) {
    var b2, d2 = {}, e3 = null, h2 = null;
    void 0 !== g2 && (e3 = "" + g2);
    void 0 !== a2.key && (e3 = "" + a2.key);
    void 0 !== a2.ref && (h2 = a2.ref);
    for (b2 in a2)
      m$4.call(a2, b2) && !p$6.hasOwnProperty(b2) && (d2[b2] = a2[b2]);
    if (c2 && c2.defaultProps)
      for (b2 in a2 = c2.defaultProps, a2)
        void 0 === d2[b2] && (d2[b2] = a2[b2]);
    return { $$typeof: k$5, type: c2, key: e3, ref: h2, props: d2, _owner: n$6.current };
  }
  reactJsxRuntime_production_min.Fragment = l$5;
  reactJsxRuntime_production_min.jsx = q$4;
  reactJsxRuntime_production_min.jsxs = q$4;
  (function(module2) {
    {
      module2.exports = reactJsxRuntime_production_min;
    }
  })(jsxRuntime);
  var Collapse$2 = {};
  function _typeof$a(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$a = function _typeof2(obj2) {
        return typeof obj2;
      };
    } else {
      _typeof$a = function _typeof2(obj2) {
        return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      };
    }
    return _typeof$a(obj);
  }
  Object.defineProperty(Collapse$2, "__esModule", {
    value: true
  });
  Collapse$2.Collapse = void 0;
  var _react$1 = _interopRequireDefault$1(React__default.default);
  function _interopRequireDefault$1(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }
  function _classCallCheck$j(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$j(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$j(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$j(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$j(Constructor, staticProps);
    return Constructor;
  }
  function _inherits$3(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
    if (superClass)
      _setPrototypeOf$4(subClass, superClass);
  }
  function _setPrototypeOf$4(o2, p2) {
    _setPrototypeOf$4 = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$4(o2, p2);
  }
  function _createSuper$3(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$3();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf$3(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf$3(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn$3(this, result);
    };
  }
  function _possibleConstructorReturn$3(self2, call) {
    if (call && (_typeof$a(call) === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized$4(self2);
  }
  function _assertThisInitialized$4(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  function _isNativeReflectConstruct$3() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e3) {
      return false;
    }
  }
  function _getPrototypeOf$3(o2) {
    _getPrototypeOf$3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
      return o3.__proto__ || Object.getPrototypeOf(o3);
    };
    return _getPrototypeOf$3(o2);
  }
  function _defineProperty$t(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var Collapse$1 = /* @__PURE__ */ function(_React$Component) {
    _inherits$3(Collapse2, _React$Component);
    var _super = _createSuper$3(Collapse2);
    function Collapse2(props) {
      var _this;
      _classCallCheck$j(this, Collapse2);
      _this = _super.call(this, props);
      _defineProperty$t(_assertThisInitialized$4(_this), "timeout", void 0);
      _defineProperty$t(_assertThisInitialized$4(_this), "container", void 0);
      _defineProperty$t(_assertThisInitialized$4(_this), "content", void 0);
      _defineProperty$t(_assertThisInitialized$4(_this), "onResize", function() {
        clearTimeout(_this.timeout);
        if (!_this.container || !_this.content) {
          return;
        }
        var _this$props = _this.props, isOpened = _this$props.isOpened, checkTimeout = _this$props.checkTimeout;
        var containerHeight = Math.floor(_this.container.clientHeight);
        var contentHeight = Math.floor(_this.content.clientHeight);
        var isFullyOpened = isOpened && Math.abs(contentHeight - containerHeight) <= 1;
        var isFullyClosed = !isOpened && Math.abs(containerHeight) <= 1;
        if (isFullyOpened || isFullyClosed) {
          _this.onRest({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
        } else {
          _this.onWork({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
          _this.timeout = setTimeout(function() {
            return _this.onResize();
          }, checkTimeout);
        }
      });
      _defineProperty$t(_assertThisInitialized$4(_this), "onRest", function(_ref2) {
        var isFullyOpened = _ref2.isFullyOpened, isFullyClosed = _ref2.isFullyClosed, isOpened = _ref2.isOpened, containerHeight = _ref2.containerHeight, contentHeight = _ref2.contentHeight;
        if (!_this.container || !_this.content) {
          return;
        }
        var hasOpened = isOpened && _this.container.style.height === "".concat(contentHeight, "px");
        var hasClosed = !isOpened && _this.container.style.height === "0px";
        if (hasOpened || hasClosed) {
          _this.container.style.overflow = isOpened ? "initial" : "hidden";
          _this.container.style.height = isOpened ? "auto" : "0px";
          var onRest = _this.props.onRest;
          if (onRest) {
            onRest({
              isFullyOpened,
              isFullyClosed,
              isOpened,
              containerHeight,
              contentHeight
            });
          }
        }
      });
      _defineProperty$t(_assertThisInitialized$4(_this), "onWork", function(_ref2) {
        var isFullyOpened = _ref2.isFullyOpened, isFullyClosed = _ref2.isFullyClosed, isOpened = _ref2.isOpened, containerHeight = _ref2.containerHeight, contentHeight = _ref2.contentHeight;
        if (!_this.container || !_this.content) {
          return;
        }
        var isOpenining = isOpened && _this.container.style.height === "".concat(contentHeight, "px");
        var isClosing = !isOpened && _this.container.style.height === "0px";
        if (isOpenining || isClosing) {
          return;
        }
        _this.container.style.overflow = "hidden";
        _this.container.style.height = isOpened ? "".concat(contentHeight, "px") : "0px";
        var onWork = _this.props.onWork;
        if (onWork) {
          onWork({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
        }
      });
      _defineProperty$t(_assertThisInitialized$4(_this), "onRefContainer", function(container) {
        _this.container = container;
      });
      _defineProperty$t(_assertThisInitialized$4(_this), "onRefContent", function(content2) {
        _this.content = content2;
      });
      if (props.initialStyle) {
        _this.initialStyle = props.initialStyle;
      } else {
        _this.initialStyle = props.isOpened ? {
          height: "auto",
          overflow: "initial"
        } : {
          height: "0px",
          overflow: "hidden"
        };
      }
      return _this;
    }
    _createClass$j(Collapse2, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.onResize();
      }
    }, {
      key: "shouldComponentUpdate",
      value: function shouldComponentUpdate(nextProps) {
        var _this$props2 = this.props, theme2 = _this$props2.theme, isOpened = _this$props2.isOpened, children2 = _this$props2.children;
        return children2 !== nextProps.children || isOpened !== nextProps.isOpened || Object.keys(theme2).some(function(c2) {
          return theme2[c2] !== nextProps.theme[c2];
        });
      }
    }, {
      key: "getSnapshotBeforeUpdate",
      value: function getSnapshotBeforeUpdate() {
        if (!this.container || !this.content) {
          return null;
        }
        if (this.container.style.height === "auto") {
          var contentHeight = this.content.clientHeight;
          this.container.style.height = "".concat(contentHeight, "px");
        }
        return null;
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        this.onResize();
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.timeout);
      }
    }, {
      key: "render",
      value: function render2() {
        var _this$props3 = this.props, theme2 = _this$props3.theme, children2 = _this$props3.children, isOpened = _this$props3.isOpened;
        return /* @__PURE__ */ _react$1["default"].createElement("div", {
          ref: this.onRefContainer,
          className: theme2.collapse,
          style: this.initialStyle,
          "aria-hidden": !isOpened
        }, /* @__PURE__ */ _react$1["default"].createElement("div", {
          ref: this.onRefContent,
          className: theme2.content
        }, children2));
      }
    }]);
    return Collapse2;
  }(_react$1["default"].Component);
  Collapse$2.Collapse = Collapse$1;
  _defineProperty$t(Collapse$1, "defaultProps", {
    theme: {
      collapse: "ReactCollapse--collapse",
      content: "ReactCollapse--content"
    },
    initialStyle: void 0,
    onRest: void 0,
    onWork: void 0,
    checkTimeout: 50
  });
  var UnmountClosed$2 = {};
  function _typeof$9(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$9 = function _typeof2(obj2) {
        return typeof obj2;
      };
    } else {
      _typeof$9 = function _typeof2(obj2) {
        return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      };
    }
    return _typeof$9(obj);
  }
  Object.defineProperty(UnmountClosed$2, "__esModule", {
    value: true
  });
  UnmountClosed$2.UnmountClosed = void 0;
  var _react = _interopRequireDefault(React__default.default);
  var _Collapse = Collapse$2;
  var _excluded$6 = ["isOpened"], _excluded2$3 = ["isOpened"];
  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }
  function _extends$3() {
    _extends$3 = Object.assign || function(target) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        var source = arguments[i2];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends$3.apply(this, arguments);
  }
  function ownKeys$a(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      if (enumerableOnly) {
        symbols = symbols.filter(function(sym) {
          return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
        });
      }
      keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread$6(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = arguments[i2] != null ? arguments[i2] : {};
      if (i2 % 2) {
        ownKeys$a(Object(source), true).forEach(function(key) {
          _defineProperty$s(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$a(Object(source)).forEach(function(key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _objectWithoutProperties$4(source, excluded) {
    if (source == null)
      return {};
    var target = _objectWithoutPropertiesLoose$7(source, excluded);
    var key, i2;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
        key = sourceSymbolKeys[i2];
        if (excluded.indexOf(key) >= 0)
          continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key))
          continue;
        target[key] = source[key];
      }
    }
    return target;
  }
  function _objectWithoutPropertiesLoose$7(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  function _classCallCheck$i(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$i(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$i(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$i(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$i(Constructor, staticProps);
    return Constructor;
  }
  function _inherits$2(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
    if (superClass)
      _setPrototypeOf$3(subClass, superClass);
  }
  function _setPrototypeOf$3(o2, p2) {
    _setPrototypeOf$3 = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$3(o2, p2);
  }
  function _createSuper$2(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$2();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf$2(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf$2(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn$2(this, result);
    };
  }
  function _possibleConstructorReturn$2(self2, call) {
    if (call && (_typeof$9(call) === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized$3(self2);
  }
  function _assertThisInitialized$3(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  function _isNativeReflectConstruct$2() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e3) {
      return false;
    }
  }
  function _getPrototypeOf$2(o2) {
    _getPrototypeOf$2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
      return o3.__proto__ || Object.getPrototypeOf(o3);
    };
    return _getPrototypeOf$2(o2);
  }
  function _defineProperty$s(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var UnmountClosed$1 = /* @__PURE__ */ function(_React$PureComponent) {
    _inherits$2(UnmountClosed2, _React$PureComponent);
    var _super = _createSuper$2(UnmountClosed2);
    function UnmountClosed2(props) {
      var _this;
      _classCallCheck$i(this, UnmountClosed2);
      _this = _super.call(this, props);
      _defineProperty$s(_assertThisInitialized$3(_this), "onWork", function(_ref2) {
        var isOpened = _ref2.isOpened, rest = _objectWithoutProperties$4(_ref2, _excluded$6);
        _this.setState({
          isResting: false,
          isOpened
        });
        var onWork = _this.props.onWork;
        if (onWork) {
          onWork(_objectSpread$6({
            isOpened
          }, rest));
        }
      });
      _defineProperty$s(_assertThisInitialized$3(_this), "onRest", function(_ref2) {
        var isOpened = _ref2.isOpened, rest = _objectWithoutProperties$4(_ref2, _excluded2$3);
        _this.setState({
          isResting: true,
          isOpened,
          isInitialRender: false
        });
        var onRest = _this.props.onRest;
        if (onRest) {
          onRest(_objectSpread$6({
            isOpened
          }, rest));
        }
      });
      _defineProperty$s(_assertThisInitialized$3(_this), "getInitialStyle", function() {
        var _this$state = _this.state, isOpened = _this$state.isOpened, isInitialRender = _this$state.isInitialRender;
        if (isInitialRender) {
          return isOpened ? {
            height: "auto",
            overflow: "initial"
          } : {
            height: "0px",
            overflow: "hidden"
          };
        }
        return {
          height: "0px",
          overflow: "hidden"
        };
      });
      _this.state = {
        isResting: true,
        isOpened: props.isOpened,
        isInitialRender: true
      };
      return _this;
    }
    _createClass$i(UnmountClosed2, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var isOpened = this.props.isOpened;
        if (prevProps.isOpened !== isOpened) {
          this.setState({
            isResting: false,
            isOpened,
            isInitialRender: false
          });
        }
      }
    }, {
      key: "render",
      value: function render2() {
        var _this$state2 = this.state, isResting = _this$state2.isResting, isOpened = _this$state2.isOpened;
        return isResting && !isOpened ? null : /* @__PURE__ */ _react["default"].createElement(_Collapse.Collapse, _extends$3({}, this.props, {
          initialStyle: this.getInitialStyle(),
          onWork: this.onWork,
          onRest: this.onRest
        }));
      }
    }]);
    return UnmountClosed2;
  }(_react["default"].PureComponent);
  UnmountClosed$2.UnmountClosed = UnmountClosed$1;
  _defineProperty$s(UnmountClosed$1, "defaultProps", {
    onWork: void 0,
    onRest: void 0
  });
  var _require = Collapse$2, Collapse = _require.Collapse;
  var _require2 = UnmountClosed$2, UnmountClosed = _require2.UnmountClosed;
  var lib$2 = UnmountClosed;
  UnmountClosed.Collapse = Collapse;
  UnmountClosed.UnmountClosed = UnmountClosed;
  var faTrashCan = {
    prefix: "fas",
    iconName: "trash-can",
    icon: [448, 512, [61460, "trash-alt"], "f2ed", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z"]
  };
  var faTrashAlt = faTrashCan;
  var faToggleOff = {
    prefix: "fas",
    iconName: "toggle-off",
    icon: [576, 512, [], "f204", "M384 128c70.7 0 128 57.3 128 128s-57.3 128-128 128H192c-70.7 0-128-57.3-128-128s57.3-128 128-128H384zM576 256c0-106-86-192-192-192H192C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192zM192 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"]
  };
  var faSquareCheck = {
    prefix: "fas",
    iconName: "square-check",
    icon: [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM337 209L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
  };
  var faCheckSquare = faSquareCheck;
  var faList = {
    prefix: "fas",
    iconName: "list",
    icon: [512, 512, ["list-squares"], "f03a", "M40 48C26.7 48 16 58.7 16 72v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V72c0-13.3-10.7-24-24-24H40zM192 64c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zM16 232v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V232c0-13.3-10.7-24-24-24H40c-13.3 0-24 10.7-24 24zM40 368c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V392c0-13.3-10.7-24-24-24H40z"]
  };
  var faChevronUp = {
    prefix: "fas",
    iconName: "chevron-up",
    icon: [512, 512, [], "f077", "M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"]
  };
  var faBan = {
    prefix: "fas",
    iconName: "ban",
    icon: [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8C77.1 176.1 64 214.5 64 256c0 106 86 192 192 192c41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3C434.9 335.9 448 297.5 448 256c0-106-86-192-192-192c-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"]
  };
  var faToggleOn = {
    prefix: "fas",
    iconName: "toggle-on",
    icon: [576, 512, [], "f205", "M192 64C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192s-86-192-192-192H192zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]
  };
  var faLeftRight = {
    prefix: "fas",
    iconName: "left-right",
    icon: [512, 512, [8596, "arrows-alt-h"], "f337", "M504.3 273.6c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 56-192 0 0-56c0-9.5-5.7-18.2-14.4-22s-18.9-2.1-25.9 4.4l-112 104C2.8 243 0 249.3 0 256s2.8 13 7.7 17.6l112 104c7 6.5 17.2 8.2 25.9 4.4s14.4-12.5 14.4-22l0-56 192 0 0 56c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104z"]
  };
  var faArrowsAltH = faLeftRight;
  var faArrowsRotate = {
    prefix: "fas",
    iconName: "arrows-rotate",
    icon: [512, 512, [128472, "refresh", "sync"], "f021", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160H336c-17.7 0-32 14.3-32 32s14.3 32 32 32H463.5c0 0 0 0 0 0h.4c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32s-32 14.3-32 32v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4c-5.9 16.7 2.9 34.9 19.5 40.8s34.9-2.9 40.8-19.5zM39 289.3c-5 1.5-9.8 4.2-13.7 8.2c-4 4-6.7 8.8-8.1 14c-.3 1.2-.6 2.5-.8 3.8c-.3 1.7-.4 3.4-.4 5.1V448c0 17.7 14.3 32 32 32s32-14.3 32-32V396.9l17.6 17.5 0 0c87.5 87.4 229.3 87.4 316.7 0c24.4-24.4 42.1-53.1 52.9-83.7c5.9-16.7-2.9-34.9-19.5-40.8s-34.9 2.9-40.8 19.5c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0l-.1-.1L125.6 352H176c17.7 0 32-14.3 32-32s-14.3-32-32-32H48.4c-1.6 0-3.2 .1-4.8 .3s-3.1 .5-4.6 1z"]
  };
  var faRefresh = faArrowsRotate;
  var faFilter = {
    prefix: "fas",
    iconName: "filter",
    icon: [512, 512, [], "f0b0", "M3.9 54.9C10.5 40.9 24.5 32 40 32H472c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L320 320.9V448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6V320.9L9 97.3C-.7 85.4-2.8 68.8 3.9 54.9z"]
  };
  var faArrowRight = {
    prefix: "fas",
    iconName: "arrow-right",
    icon: [448, 512, [8594], "f061", "M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"]
  };
  var faCircle = {
    prefix: "fas",
    iconName: "circle",
    icon: [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"]
  };
  var faTrash = {
    prefix: "fas",
    iconName: "trash",
    icon: [448, 512, [], "f1f8", "M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z"]
  };
  var faArrowLeft = {
    prefix: "fas",
    iconName: "arrow-left",
    icon: [448, 512, [8592], "f060", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"]
  };
  var faEllipsisVertical = {
    prefix: "fas",
    iconName: "ellipsis-vertical",
    icon: [128, 512, ["ellipsis-v"], "f142", "M64 360a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm0-160a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM120 96A56 56 0 1 0 8 96a56 56 0 1 0 112 0z"]
  };
  var faEllipsisV = faEllipsisVertical;
  var faArrowRightLong = {
    prefix: "fas",
    iconName: "arrow-right-long",
    icon: [512, 512, ["long-arrow-right"], "f178", "M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l370.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"]
  };
  var faArrowDown = {
    prefix: "fas",
    iconName: "arrow-down",
    icon: [384, 512, [8595], "f063", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"]
  };
  var faMagnifyingGlass = {
    prefix: "fas",
    iconName: "magnifying-glass",
    icon: [512, 512, [128269, "search"], "f002", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"]
  };
  var faSearch = faMagnifyingGlass;
  var faChevronDown = {
    prefix: "fas",
    iconName: "chevron-down",
    icon: [512, 512, [], "f078", "M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z"]
  };
  var faArrowUp = {
    prefix: "fas",
    iconName: "arrow-up",
    icon: [384, 512, [8593], "f062", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2V448c0 17.7 14.3 32 32 32s32-14.3 32-32V141.2L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z"]
  };
  var faPlus = {
    prefix: "fas",
    iconName: "plus",
    icon: [448, 512, [10133, 61543, "add"], "2b", "M256 80c0-17.7-14.3-32-32-32s-32 14.3-32 32V224H48c-17.7 0-32 14.3-32 32s14.3 32 32 32H192V432c0 17.7 14.3 32 32 32s32-14.3 32-32V288H400c17.7 0 32-14.3 32-32s-14.3-32-32-32H256V80z"]
  };
  var faXmark = {
    prefix: "fas",
    iconName: "xmark",
    icon: [384, 512, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"]
  };
  var faTimes = faXmark;
  var faArrowsUpDownLeftRight = {
    prefix: "fas",
    iconName: "arrows-up-down-left-right",
    icon: [512, 512, ["arrows"], "f047", "M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4V224H109.3l9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4H224V402.7l-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-9.4 9.4V288H402.7l-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4H288V109.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64z"]
  };
  var faArrows = faArrowsUpDownLeftRight;
  var faChevronLeft = {
    prefix: "fas",
    iconName: "chevron-left",
    icon: [320, 512, [9001], "f053", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192z"]
  };
  var faChevronRight = {
    prefix: "fas",
    iconName: "chevron-right",
    icon: [320, 512, [9002], "f054", "M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z"]
  };
  var faMoon = {
    prefix: "fas",
    iconName: "moon",
    icon: [384, 512, [127769, 9214], "f186", "M223.5 32C100 32 0 132.3 0 256S100 480 223.5 480c60.6 0 115.5-24.2 155.8-63.4c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-9.8 1.7-19.8 2.6-30.1 2.6c-96.9 0-175.5-78.8-175.5-176c0-65.8 36-123.1 89.3-153.3c6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-6.3-.5-12.6-.8-19-.8z"]
  };
  var faCheck = {
    prefix: "fas",
    iconName: "check",
    icon: [448, 512, [10003, 10004], "f00c", "M438.6 105.4c12.5 12.5 12.5 32.8 0 45.3l-256 256c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 338.7 393.4 105.4c12.5-12.5 32.8-12.5 45.3 0z"]
  };
  function ownKeys$9(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      enumerableOnly && (symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
      })), keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread2$3(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = null != arguments[i2] ? arguments[i2] : {};
      i2 % 2 ? ownKeys$9(Object(source), true).forEach(function(key) {
        _defineProperty$r(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$9(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
    return target;
  }
  function _typeof$8(obj) {
    "@babel/helpers - typeof";
    return _typeof$8 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$8(obj);
  }
  function _classCallCheck$h(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$h(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$h(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$h(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$h(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _defineProperty$r(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _slicedToArray$a(arr, i2) {
    return _arrayWithHoles$a(arr) || _iterableToArrayLimit$a(arr, i2) || _unsupportedIterableToArray$c(arr, i2) || _nonIterableRest$a();
  }
  function _toConsumableArray$5(arr) {
    return _arrayWithoutHoles$5(arr) || _iterableToArray$5(arr) || _unsupportedIterableToArray$c(arr) || _nonIterableSpread$5();
  }
  function _arrayWithoutHoles$5(arr) {
    if (Array.isArray(arr))
      return _arrayLikeToArray$c(arr);
  }
  function _arrayWithHoles$a(arr) {
    if (Array.isArray(arr))
      return arr;
  }
  function _iterableToArray$5(iter2) {
    if (typeof Symbol !== "undefined" && iter2[Symbol.iterator] != null || iter2["@@iterator"] != null)
      return Array.from(iter2);
  }
  function _iterableToArrayLimit$a(arr, i2) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
    if (_i == null)
      return;
    var _arr = [];
    var _n = true;
    var _d = false;
    var _s, _e2;
    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);
        if (i2 && _arr.length === i2)
          break;
      }
    } catch (err) {
      _d = true;
      _e2 = err;
    } finally {
      try {
        if (!_n && _i["return"] != null)
          _i["return"]();
      } finally {
        if (_d)
          throw _e2;
      }
    }
    return _arr;
  }
  function _unsupportedIterableToArray$c(o2, minLen) {
    if (!o2)
      return;
    if (typeof o2 === "string")
      return _arrayLikeToArray$c(o2, minLen);
    var n2 = Object.prototype.toString.call(o2).slice(8, -1);
    if (n2 === "Object" && o2.constructor)
      n2 = o2.constructor.name;
    if (n2 === "Map" || n2 === "Set")
      return Array.from(o2);
    if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
      return _arrayLikeToArray$c(o2, minLen);
  }
  function _arrayLikeToArray$c(arr, len) {
    if (len == null || len > arr.length)
      len = arr.length;
    for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
      arr2[i2] = arr[i2];
    return arr2;
  }
  function _nonIterableSpread$5() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _nonIterableRest$a() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var noop$6 = function noop2() {
  };
  var _WINDOW = {};
  var _DOCUMENT = {};
  var _MUTATION_OBSERVER = null;
  var _PERFORMANCE = {
    mark: noop$6,
    measure: noop$6
  };
  try {
    if (typeof window !== "undefined")
      _WINDOW = window;
    if (typeof document !== "undefined")
      _DOCUMENT = document;
    if (typeof MutationObserver !== "undefined")
      _MUTATION_OBSERVER = MutationObserver;
    if (typeof performance !== "undefined")
      _PERFORMANCE = performance;
  } catch (e3) {
  }
  var _ref = _WINDOW.navigator || {}, _ref$userAgent = _ref.userAgent, userAgent = _ref$userAgent === void 0 ? "" : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var MUTATION_OBSERVER = _MUTATION_OBSERVER;
  var PERFORMANCE = _PERFORMANCE;
  !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === "function" && typeof DOCUMENT.createElement === "function";
  var IS_IE = ~userAgent.indexOf("MSIE") || ~userAgent.indexOf("Trident/");
  var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;
  var NAMESPACE_IDENTIFIER = "___FONT_AWESOME___";
  var UNITS_IN_GRID = 16;
  var DEFAULT_CSS_PREFIX = "fa";
  var DEFAULT_REPLACEMENT_CLASS = "svg-inline--fa";
  var DATA_FA_I2SVG = "data-fa-i2svg";
  var DATA_FA_PSEUDO_ELEMENT = "data-fa-pseudo-element";
  var DATA_FA_PSEUDO_ELEMENT_PENDING = "data-fa-pseudo-element-pending";
  var DATA_PREFIX = "data-prefix";
  var DATA_ICON = "data-icon";
  var HTML_CLASS_I2SVG_BASE_CLASS = "fontawesome-i2svg";
  var MUTATION_APPROACH_ASYNC = "async";
  var TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ["HTML", "HEAD", "STYLE", "SCRIPT"];
  var PRODUCTION$2 = function() {
    try {
      return true;
    } catch (e3) {
      return false;
    }
  }();
  var FAMILY_CLASSIC = "classic";
  var FAMILY_SHARP = "sharp";
  var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];
  function familyProxy(obj) {
    return new Proxy(obj, {
      get: function get2(target, prop) {
        return prop in target ? target[prop] : target[FAMILY_CLASSIC];
      }
    });
  }
  var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty$r(_familyProxy, FAMILY_CLASSIC, {
    "fa": "solid",
    "fas": "solid",
    "fa-solid": "solid",
    "far": "regular",
    "fa-regular": "regular",
    "fal": "light",
    "fa-light": "light",
    "fat": "thin",
    "fa-thin": "thin",
    "fad": "duotone",
    "fa-duotone": "duotone",
    "fab": "brands",
    "fa-brands": "brands",
    "fak": "kit",
    "fa-kit": "kit"
  }), _defineProperty$r(_familyProxy, FAMILY_SHARP, {
    "fa": "solid",
    "fass": "solid",
    "fa-solid": "solid",
    "fasr": "regular",
    "fa-regular": "regular",
    "fasl": "light",
    "fa-light": "light"
  }), _familyProxy));
  var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty$r(_familyProxy2, FAMILY_CLASSIC, {
    "solid": "fas",
    "regular": "far",
    "light": "fal",
    "thin": "fat",
    "duotone": "fad",
    "brands": "fab",
    "kit": "fak"
  }), _defineProperty$r(_familyProxy2, FAMILY_SHARP, {
    "solid": "fass",
    "regular": "fasr",
    "light": "fasl"
  }), _familyProxy2));
  var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty$r(_familyProxy3, FAMILY_CLASSIC, {
    "fab": "fa-brands",
    "fad": "fa-duotone",
    "fak": "fa-kit",
    "fal": "fa-light",
    "far": "fa-regular",
    "fas": "fa-solid",
    "fat": "fa-thin"
  }), _defineProperty$r(_familyProxy3, FAMILY_SHARP, {
    "fass": "fa-solid",
    "fasr": "fa-regular",
    "fasl": "fa-light"
  }), _familyProxy3));
  var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty$r(_familyProxy4, FAMILY_CLASSIC, {
    "fa-brands": "fab",
    "fa-duotone": "fad",
    "fa-kit": "fak",
    "fa-light": "fal",
    "fa-regular": "far",
    "fa-solid": "fas",
    "fa-thin": "fat"
  }), _defineProperty$r(_familyProxy4, FAMILY_SHARP, {
    "fa-solid": "fass",
    "fa-regular": "fasr",
    "fa-light": "fasl"
  }), _familyProxy4));
  var ICON_SELECTION_SYNTAX_PATTERN = /fa(s|r|l|t|d|b|k|ss|sr|sl)?[\-\ ]/;
  var LAYERS_TEXT_CLASSNAME = "fa-layers-text";
  var FONT_FAMILY_PATTERN = /Font ?Awesome ?([56 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp|Kit)?.*/i;
  var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty$r(_familyProxy5, FAMILY_CLASSIC, {
    "900": "fas",
    "400": "far",
    "normal": "far",
    "300": "fal",
    "100": "fat"
  }), _defineProperty$r(_familyProxy5, FAMILY_SHARP, {
    "900": "fass",
    "400": "fasr",
    "300": "fasl"
  }), _familyProxy5));
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var ATTRIBUTES_WATCHED_FOR_MUTATION = ["class", "data-prefix", "data-icon", "data-fa-transform", "data-fa-mask"];
  var DUOTONE_CLASSES = {
    GROUP: "duotone-group",
    SWAP_OPACITY: "swap-opacity",
    PRIMARY: "primary",
    SECONDARY: "secondary"
  };
  var prefixes = /* @__PURE__ */ new Set();
  Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
  Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
  var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray$5(prefixes), ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "fw", "inverse", "layers-counter", "layers-text", "layers", "li", "pull-left", "pull-right", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function(n2) {
    return "".concat(n2, "x");
  })).concat(oneToTwenty.map(function(n2) {
    return "w-".concat(n2);
  }));
  var initial = WINDOW.FontAwesomeConfig || {};
  function getAttrConfig(attr) {
    var element2 = DOCUMENT.querySelector("script[" + attr + "]");
    if (element2) {
      return element2.getAttribute(attr);
    }
  }
  function coerce(val) {
    if (val === "")
      return true;
    if (val === "false")
      return false;
    if (val === "true")
      return true;
    return val;
  }
  if (DOCUMENT && typeof DOCUMENT.querySelector === "function") {
    var attrs = [["data-family-prefix", "familyPrefix"], ["data-css-prefix", "cssPrefix"], ["data-family-default", "familyDefault"], ["data-style-default", "styleDefault"], ["data-replacement-class", "replacementClass"], ["data-auto-replace-svg", "autoReplaceSvg"], ["data-auto-add-css", "autoAddCss"], ["data-auto-a11y", "autoA11y"], ["data-search-pseudo-elements", "searchPseudoElements"], ["data-observe-mutations", "observeMutations"], ["data-mutate-approach", "mutateApproach"], ["data-keep-original-source", "keepOriginalSource"], ["data-measure-performance", "measurePerformance"], ["data-show-missing-icons", "showMissingIcons"]];
    attrs.forEach(function(_ref2) {
      var _ref22 = _slicedToArray$a(_ref2, 2), attr = _ref22[0], key = _ref22[1];
      var val = coerce(getAttrConfig(attr));
      if (val !== void 0 && val !== null) {
        initial[key] = val;
      }
    });
  }
  var _default$2 = {
    styleDefault: "solid",
    familyDefault: "classic",
    cssPrefix: DEFAULT_CSS_PREFIX,
    replacementClass: DEFAULT_REPLACEMENT_CLASS,
    autoReplaceSvg: true,
    autoAddCss: true,
    autoA11y: true,
    searchPseudoElements: false,
    observeMutations: true,
    mutateApproach: "async",
    keepOriginalSource: true,
    measurePerformance: false,
    showMissingIcons: true
  };
  if (initial.familyPrefix) {
    initial.cssPrefix = initial.familyPrefix;
  }
  var _config = _objectSpread2$3(_objectSpread2$3({}, _default$2), initial);
  if (!_config.autoReplaceSvg)
    _config.observeMutations = false;
  var config$1 = {};
  Object.keys(_default$2).forEach(function(key) {
    Object.defineProperty(config$1, key, {
      enumerable: true,
      set: function set2(val) {
        _config[key] = val;
        _onChangeCb.forEach(function(cb) {
          return cb(config$1);
        });
      },
      get: function get2() {
        return _config[key];
      }
    });
  });
  Object.defineProperty(config$1, "familyPrefix", {
    enumerable: true,
    set: function set2(val) {
      _config.cssPrefix = val;
      _onChangeCb.forEach(function(cb) {
        return cb(config$1);
      });
    },
    get: function get2() {
      return _config.cssPrefix;
    }
  });
  WINDOW.FontAwesomeConfig = config$1;
  var _onChangeCb = [];
  function onChange(cb) {
    _onChangeCb.push(cb);
    return function() {
      _onChangeCb.splice(_onChangeCb.indexOf(cb), 1);
    };
  }
  var d$4 = UNITS_IN_GRID;
  var meaninglessTransform = {
    size: 16,
    x: 0,
    y: 0,
    rotate: 0,
    flipX: false,
    flipY: false
  };
  function insertCss(css2) {
    if (!css2 || !IS_DOM) {
      return;
    }
    var style2 = DOCUMENT.createElement("style");
    style2.setAttribute("type", "text/css");
    style2.innerHTML = css2;
    var headChildren = DOCUMENT.head.childNodes;
    var beforeChild = null;
    for (var i2 = headChildren.length - 1; i2 > -1; i2--) {
      var child = headChildren[i2];
      var tagName = (child.tagName || "").toUpperCase();
      if (["STYLE", "LINK"].indexOf(tagName) > -1) {
        beforeChild = child;
      }
    }
    DOCUMENT.head.insertBefore(style2, beforeChild);
    return css2;
  }
  var idPool = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  function nextUniqueId$1() {
    var size = 12;
    var id2 = "";
    while (size-- > 0) {
      id2 += idPool[Math.random() * 62 | 0];
    }
    return id2;
  }
  function toArray(obj) {
    var array2 = [];
    for (var i2 = (obj || []).length >>> 0; i2--; ) {
      array2[i2] = obj[i2];
    }
    return array2;
  }
  function classArray$1(node2) {
    if (node2.classList) {
      return toArray(node2.classList);
    } else {
      return (node2.getAttribute("class") || "").split(" ").filter(function(i2) {
        return i2;
      });
    }
  }
  function htmlEscape(str) {
    return "".concat(str).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
  }
  function joinAttributes(attributes2) {
    return Object.keys(attributes2 || {}).reduce(function(acc, attributeName) {
      return acc + "".concat(attributeName, '="').concat(htmlEscape(attributes2[attributeName]), '" ');
    }, "").trim();
  }
  function joinStyles(styles2) {
    return Object.keys(styles2 || {}).reduce(function(acc, styleName) {
      return acc + "".concat(styleName, ": ").concat(styles2[styleName].trim(), ";");
    }, "");
  }
  function transformIsMeaningful(transform) {
    return transform.size !== meaninglessTransform.size || transform.x !== meaninglessTransform.x || transform.y !== meaninglessTransform.y || transform.rotate !== meaninglessTransform.rotate || transform.flipX || transform.flipY;
  }
  function transformForSvg(_ref2) {
    var transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
    var outer = {
      transform: "translate(".concat(containerWidth / 2, " 256)")
    };
    var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
    var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
    var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
    var inner = {
      transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
    };
    var path2 = {
      transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
    };
    return {
      outer,
      inner,
      path: path2
    };
  }
  function transformForCss(_ref2) {
    var transform = _ref2.transform, _ref2$width = _ref2.width, width = _ref2$width === void 0 ? UNITS_IN_GRID : _ref2$width, _ref2$height = _ref2.height, height = _ref2$height === void 0 ? UNITS_IN_GRID : _ref2$height, _ref2$startCentered = _ref2.startCentered, startCentered = _ref2$startCentered === void 0 ? false : _ref2$startCentered;
    var val = "";
    if (startCentered && IS_IE) {
      val += "translate(".concat(transform.x / d$4 - width / 2, "em, ").concat(transform.y / d$4 - height / 2, "em) ");
    } else if (startCentered) {
      val += "translate(calc(-50% + ".concat(transform.x / d$4, "em), calc(-50% + ").concat(transform.y / d$4, "em)) ");
    } else {
      val += "translate(".concat(transform.x / d$4, "em, ").concat(transform.y / d$4, "em) ");
    }
    val += "scale(".concat(transform.size / d$4 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / d$4 * (transform.flipY ? -1 : 1), ") ");
    val += "rotate(".concat(transform.rotate, "deg) ");
    return val;
  }
  var baseStyles = ':root, :host {\n  --fa-font-solid: normal 900 1em/1 "Font Awesome 6 Solid";\n  --fa-font-regular: normal 400 1em/1 "Font Awesome 6 Regular";\n  --fa-font-light: normal 300 1em/1 "Font Awesome 6 Light";\n  --fa-font-thin: normal 100 1em/1 "Font Awesome 6 Thin";\n  --fa-font-duotone: normal 900 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-brands: normal 400 1em/1 "Font Awesome 6 Brands";\n}\n\nsvg:not(:root).svg-inline--fa, svg:not(:host).svg-inline--fa {\n  overflow: visible;\n  box-sizing: content-box;\n}\n\n.svg-inline--fa {\n  display: var(--fa-display, inline-block);\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-2xs {\n  vertical-align: 0.1em;\n}\n.svg-inline--fa.fa-xs {\n  vertical-align: 0em;\n}\n.svg-inline--fa.fa-sm {\n  vertical-align: -0.0714285705em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.2em;\n}\n.svg-inline--fa.fa-xl {\n  vertical-align: -0.25em;\n}\n.svg-inline--fa.fa-2xl {\n  vertical-align: -0.3125em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-li {\n  width: var(--fa-li-width, 2em);\n  top: 0.25em;\n}\n.svg-inline--fa.fa-fw {\n  width: var(--fa-fw-width, 1.25em);\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  -webkit-transform: translate(-50%, -50%);\n          transform: translate(-50%, -50%);\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: var(--fa-counter-background-color, #ff253a);\n  border-radius: var(--fa-counter-border-radius, 1em);\n  box-sizing: border-box;\n  color: var(--fa-inverse, #fff);\n  line-height: var(--fa-counter-line-height, 1);\n  max-width: var(--fa-counter-max-width, 5em);\n  min-width: var(--fa-counter-min-width, 1.5em);\n  overflow: hidden;\n  padding: var(--fa-counter-padding, 0.25em 0.5em);\n  right: var(--fa-right, 0);\n  text-overflow: ellipsis;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-counter-scale, 0.25));\n          transform: scale(var(--fa-counter-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: var(--fa-bottom, 0);\n  right: var(--fa-right, 0);\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom right;\n          transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: var(--fa-bottom, 0);\n  left: var(--fa-left, 0);\n  right: auto;\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom left;\n          transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  top: var(--fa-top, 0);\n  right: var(--fa-right, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: var(--fa-left, 0);\n  right: auto;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top left;\n          transform-origin: top left;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-2xs {\n  font-size: 0.625em;\n  line-height: 0.1em;\n  vertical-align: 0.225em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n  line-height: 0.0833333337em;\n  vertical-align: 0.125em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n  line-height: 0.0714285718em;\n  vertical-align: 0.0535714295em;\n}\n\n.fa-lg {\n  font-size: 1.25em;\n  line-height: 0.05em;\n  vertical-align: -0.075em;\n}\n\n.fa-xl {\n  font-size: 1.5em;\n  line-height: 0.0416666682em;\n  vertical-align: -0.125em;\n}\n\n.fa-2xl {\n  font-size: 2em;\n  line-height: 0.03125em;\n  vertical-align: -0.1875em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: var(--fa-li-margin, 2.5em);\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: calc(var(--fa-li-width, 2em) * -1);\n  position: absolute;\n  text-align: center;\n  width: var(--fa-li-width, 2em);\n  line-height: inherit;\n}\n\n.fa-border {\n  border-color: var(--fa-border-color, #eee);\n  border-radius: var(--fa-border-radius, 0.1em);\n  border-style: var(--fa-border-style, solid);\n  border-width: var(--fa-border-width, 0.08em);\n  padding: var(--fa-border-padding, 0.2em 0.25em 0.15em);\n}\n\n.fa-pull-left {\n  float: left;\n  margin-right: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-pull-right {\n  float: right;\n  margin-left: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-beat {\n  -webkit-animation-name: fa-beat;\n          animation-name: fa-beat;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-bounce {\n  -webkit-animation-name: fa-bounce;\n          animation-name: fa-bounce;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n}\n\n.fa-fade {\n  -webkit-animation-name: fa-fade;\n          animation-name: fa-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-beat-fade {\n  -webkit-animation-name: fa-beat-fade;\n          animation-name: fa-beat-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-flip {\n  -webkit-animation-name: fa-flip;\n          animation-name: fa-flip;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-shake {\n  -webkit-animation-name: fa-shake;\n          animation-name: fa-shake;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 2s);\n          animation-duration: var(--fa-animation-duration, 2s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin-reverse {\n  --fa-animation-direction: reverse;\n}\n\n.fa-pulse,\n.fa-spin-pulse {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, steps(8));\n          animation-timing-function: var(--fa-animation-timing, steps(8));\n}\n\n@media (prefers-reduced-motion: reduce) {\n  .fa-beat,\n.fa-bounce,\n.fa-fade,\n.fa-beat-fade,\n.fa-flip,\n.fa-pulse,\n.fa-shake,\n.fa-spin,\n.fa-spin-pulse {\n    -webkit-animation-delay: -1ms;\n            animation-delay: -1ms;\n    -webkit-animation-duration: 1ms;\n            animation-duration: 1ms;\n    -webkit-animation-iteration-count: 1;\n            animation-iteration-count: 1;\n    -webkit-transition-delay: 0s;\n            transition-delay: 0s;\n    -webkit-transition-duration: 0s;\n            transition-duration: 0s;\n  }\n}\n@-webkit-keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@-webkit-keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@-webkit-keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@-webkit-keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@-webkit-keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@-webkit-keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  -webkit-transform: rotate(90deg);\n          transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  -webkit-transform: scale(-1, 1);\n          transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  -webkit-transform: scale(1, -1);\n          transform: scale(1, -1);\n}\n\n.fa-flip-both,\n.fa-flip-horizontal.fa-flip-vertical {\n  -webkit-transform: scale(-1, -1);\n          transform: scale(-1, -1);\n}\n\n.fa-rotate-by {\n  -webkit-transform: rotate(var(--fa-rotate-angle, none));\n          transform: rotate(var(--fa-rotate-angle, none));\n}\n\n.fa-stack {\n  display: inline-block;\n  vertical-align: middle;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n  z-index: var(--fa-stack-z-index, auto);\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}\n\n.sr-only,\n.fa-sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.sr-only-focusable:not(:focus),\n.fa-sr-only-focusable:not(:focus) {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.svg-inline--fa .fa-primary {\n  fill: var(--fa-primary-color, currentColor);\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa .fa-secondary {\n  fill: var(--fa-secondary-color, currentColor);\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-primary {\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-secondary {\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa mask .fa-primary,\n.svg-inline--fa mask .fa-secondary {\n  fill: black;\n}\n\n.fad.fa-inverse,\n.fa-duotone.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}';
  function css() {
    var dcp = DEFAULT_CSS_PREFIX;
    var drc = DEFAULT_REPLACEMENT_CLASS;
    var fp = config$1.cssPrefix;
    var rc = config$1.replacementClass;
    var s2 = baseStyles;
    if (fp !== dcp || rc !== drc) {
      var dPatt = new RegExp("\\.".concat(dcp, "\\-"), "g");
      var customPropPatt = new RegExp("\\--".concat(dcp, "\\-"), "g");
      var rPatt = new RegExp("\\.".concat(drc), "g");
      s2 = s2.replace(dPatt, ".".concat(fp, "-")).replace(customPropPatt, "--".concat(fp, "-")).replace(rPatt, ".".concat(rc));
    }
    return s2;
  }
  var _cssInserted = false;
  function ensureCss() {
    if (config$1.autoAddCss && !_cssInserted) {
      insertCss(css());
      _cssInserted = true;
    }
  }
  var InjectCSS = {
    mixout: function mixout() {
      return {
        dom: {
          css,
          insertCss: ensureCss
        }
      };
    },
    hooks: function hooks() {
      return {
        beforeDOMElementCreation: function beforeDOMElementCreation() {
          ensureCss();
        },
        beforeI2svg: function beforeI2svg() {
          ensureCss();
        }
      };
    }
  };
  var w$5 = WINDOW || {};
  if (!w$5[NAMESPACE_IDENTIFIER])
    w$5[NAMESPACE_IDENTIFIER] = {};
  if (!w$5[NAMESPACE_IDENTIFIER].styles)
    w$5[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$5[NAMESPACE_IDENTIFIER].hooks)
    w$5[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$5[NAMESPACE_IDENTIFIER].shims)
    w$5[NAMESPACE_IDENTIFIER].shims = [];
  var namespace$1 = w$5[NAMESPACE_IDENTIFIER];
  var functions = [];
  var listener = function listener2() {
    DOCUMENT.removeEventListener("DOMContentLoaded", listener2);
    loaded = 1;
    functions.map(function(fn2) {
      return fn2();
    });
  };
  var loaded = false;
  if (IS_DOM) {
    loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState);
    if (!loaded)
      DOCUMENT.addEventListener("DOMContentLoaded", listener);
  }
  function domready(fn2) {
    if (!IS_DOM)
      return;
    loaded ? setTimeout(fn2, 0) : functions.push(fn2);
  }
  function toHtml(abstractNodes) {
    var tag = abstractNodes.tag, _abstractNodes$attrib = abstractNodes.attributes, attributes2 = _abstractNodes$attrib === void 0 ? {} : _abstractNodes$attrib, _abstractNodes$childr = abstractNodes.children, children2 = _abstractNodes$childr === void 0 ? [] : _abstractNodes$childr;
    if (typeof abstractNodes === "string") {
      return htmlEscape(abstractNodes);
    } else {
      return "<".concat(tag, " ").concat(joinAttributes(attributes2), ">").concat(children2.map(toHtml).join(""), "</").concat(tag, ">");
    }
  }
  function iconFromMapping(mapping, prefix, iconName) {
    if (mapping && mapping[prefix] && mapping[prefix][iconName]) {
      return {
        prefix,
        iconName,
        icon: mapping[prefix][iconName]
      };
    }
  }
  var bindInternal4 = function bindInternal42(func, thisContext) {
    return function(a2, b2, c2, d2) {
      return func.call(thisContext, a2, b2, c2, d2);
    };
  };
  var reduce$7 = function fastReduceObject(subject, fn2, initialValue, thisContext) {
    var keys2 = Object.keys(subject), length2 = keys2.length, iterator2 = thisContext !== void 0 ? bindInternal4(fn2, thisContext) : fn2, i2, key, result;
    if (initialValue === void 0) {
      i2 = 1;
      result = subject[keys2[0]];
    } else {
      i2 = 0;
      result = initialValue;
    }
    for (; i2 < length2; i2++) {
      key = keys2[i2];
      result = iterator2(result, subject[key], key, subject);
    }
    return result;
  };
  function ucs2decode(string2) {
    var output2 = [];
    var counter2 = 0;
    var length2 = string2.length;
    while (counter2 < length2) {
      var value = string2.charCodeAt(counter2++);
      if (value >= 55296 && value <= 56319 && counter2 < length2) {
        var extra = string2.charCodeAt(counter2++);
        if ((extra & 64512) == 56320) {
          output2.push(((value & 1023) << 10) + (extra & 1023) + 65536);
        } else {
          output2.push(value);
          counter2--;
        }
      } else {
        output2.push(value);
      }
    }
    return output2;
  }
  function toHex(unicode2) {
    var decoded = ucs2decode(unicode2);
    return decoded.length === 1 ? decoded[0].toString(16) : null;
  }
  function codePointAt$1(string2, index2) {
    var size = string2.length;
    var first = string2.charCodeAt(index2);
    var second;
    if (first >= 55296 && first <= 56319 && size > index2 + 1) {
      second = string2.charCodeAt(index2 + 1);
      if (second >= 56320 && second <= 57343) {
        return (first - 55296) * 1024 + second - 56320 + 65536;
      }
    }
    return first;
  }
  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function(acc, iconName) {
      var icon2 = icons[iconName];
      var expanded = !!icon2.icon;
      if (expanded) {
        acc[icon2.iconName] = icon2.icon;
      } else {
        acc[iconName] = icon2;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks, skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized2 = normalizeIcons(icons);
    if (typeof namespace$1.hooks.addPack === "function" && !skipHooks) {
      namespace$1.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace$1.styles[prefix] = _objectSpread2$3(_objectSpread2$3({}, namespace$1.styles[prefix] || {}), normalized2);
    }
    if (prefix === "fas") {
      defineIcons("fa", icons);
    }
  }
  var _LONG_STYLE, _PREFIXES, _PREFIXES_FOR_FAMILY;
  var styles = namespace$1.styles, shims = namespace$1.shims;
  var LONG_STYLE = (_LONG_STYLE = {}, _defineProperty$r(_LONG_STYLE, FAMILY_CLASSIC, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$r(_LONG_STYLE, FAMILY_SHARP, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _LONG_STYLE);
  var _defaultUsablePrefix = null;
  var _byUnicode = {};
  var _byLigature = {};
  var _byOldName = {};
  var _byOldUnicode = {};
  var _byAlias = {};
  var PREFIXES = (_PREFIXES = {}, _defineProperty$r(_PREFIXES, FAMILY_CLASSIC, Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC])), _defineProperty$r(_PREFIXES, FAMILY_SHARP, Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP])), _PREFIXES);
  function isReserved(name2) {
    return ~RESERVED_CLASSES.indexOf(name2);
  }
  function getIconName(cssPrefix, cls) {
    var parts = cls.split("-");
    var prefix = parts[0];
    var iconName = parts.slice(1).join("-");
    if (prefix === cssPrefix && iconName !== "" && !isReserved(iconName)) {
      return iconName;
    } else {
      return null;
    }
  }
  var build$2 = function build2() {
    var lookup2 = function lookup3(reducer2) {
      return reduce$7(styles, function(o2, style2, prefix) {
        o2[prefix] = reduce$7(style2, reducer2, {});
        return o2;
      }, {});
    };
    _byUnicode = lookup2(function(acc, icon2, iconName) {
      if (icon2[3]) {
        acc[icon2[3]] = iconName;
      }
      if (icon2[2]) {
        var aliases = icon2[2].filter(function(a2) {
          return typeof a2 === "number";
        });
        aliases.forEach(function(alias) {
          acc[alias.toString(16)] = iconName;
        });
      }
      return acc;
    });
    _byLigature = lookup2(function(acc, icon2, iconName) {
      acc[iconName] = iconName;
      if (icon2[2]) {
        var aliases = icon2[2].filter(function(a2) {
          return typeof a2 === "string";
        });
        aliases.forEach(function(alias) {
          acc[alias] = iconName;
        });
      }
      return acc;
    });
    _byAlias = lookup2(function(acc, icon2, iconName) {
      var aliases = icon2[2];
      acc[iconName] = iconName;
      aliases.forEach(function(alias) {
        acc[alias] = iconName;
      });
      return acc;
    });
    var hasRegular = "far" in styles || config$1.autoFetchSvg;
    var shimLookups = reduce$7(shims, function(acc, shim) {
      var maybeNameMaybeUnicode = shim[0];
      var prefix = shim[1];
      var iconName = shim[2];
      if (prefix === "far" && !hasRegular) {
        prefix = "fas";
      }
      if (typeof maybeNameMaybeUnicode === "string") {
        acc.names[maybeNameMaybeUnicode] = {
          prefix,
          iconName
        };
      }
      if (typeof maybeNameMaybeUnicode === "number") {
        acc.unicodes[maybeNameMaybeUnicode.toString(16)] = {
          prefix,
          iconName
        };
      }
      return acc;
    }, {
      names: {},
      unicodes: {}
    });
    _byOldName = shimLookups.names;
    _byOldUnicode = shimLookups.unicodes;
    _defaultUsablePrefix = getCanonicalPrefix(config$1.styleDefault, {
      family: config$1.familyDefault
    });
  };
  onChange(function(c2) {
    _defaultUsablePrefix = getCanonicalPrefix(c2.styleDefault, {
      family: config$1.familyDefault
    });
  });
  build$2();
  function byUnicode(prefix, unicode2) {
    return (_byUnicode[prefix] || {})[unicode2];
  }
  function byLigature(prefix, ligature) {
    return (_byLigature[prefix] || {})[ligature];
  }
  function byAlias(prefix, alias) {
    return (_byAlias[prefix] || {})[alias];
  }
  function byOldName(name2) {
    return _byOldName[name2] || {
      prefix: null,
      iconName: null
    };
  }
  function byOldUnicode(unicode2) {
    var oldUnicode = _byOldUnicode[unicode2];
    var newUnicode = byUnicode("fas", unicode2);
    return oldUnicode || (newUnicode ? {
      prefix: "fas",
      iconName: newUnicode
    } : null) || {
      prefix: null,
      iconName: null
    };
  }
  function getDefaultUsablePrefix() {
    return _defaultUsablePrefix;
  }
  var emptyCanonicalIcon = function emptyCanonicalIcon2() {
    return {
      prefix: null,
      iconName: null,
      rest: []
    };
  };
  function getCanonicalPrefix(styleOrPrefix) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$family = params.family, family = _params$family === void 0 ? FAMILY_CLASSIC : _params$family;
    var style2 = PREFIX_TO_STYLE[family][styleOrPrefix];
    var prefix = STYLE_TO_PREFIX[family][styleOrPrefix] || STYLE_TO_PREFIX[family][style2];
    var defined = styleOrPrefix in namespace$1.styles ? styleOrPrefix : null;
    return prefix || defined || null;
  }
  var PREFIXES_FOR_FAMILY = (_PREFIXES_FOR_FAMILY = {}, _defineProperty$r(_PREFIXES_FOR_FAMILY, FAMILY_CLASSIC, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$r(_PREFIXES_FOR_FAMILY, FAMILY_SHARP, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _PREFIXES_FOR_FAMILY);
  function getCanonicalIcon(values) {
    var _famProps;
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$skipLookups = params.skipLookups, skipLookups = _params$skipLookups === void 0 ? false : _params$skipLookups;
    var famProps = (_famProps = {}, _defineProperty$r(_famProps, FAMILY_CLASSIC, "".concat(config$1.cssPrefix, "-").concat(FAMILY_CLASSIC)), _defineProperty$r(_famProps, FAMILY_SHARP, "".concat(config$1.cssPrefix, "-").concat(FAMILY_SHARP)), _famProps);
    var givenPrefix = null;
    var family = FAMILY_CLASSIC;
    if (values.includes(famProps[FAMILY_CLASSIC]) || values.some(function(v2) {
      return PREFIXES_FOR_FAMILY[FAMILY_CLASSIC].includes(v2);
    })) {
      family = FAMILY_CLASSIC;
    }
    if (values.includes(famProps[FAMILY_SHARP]) || values.some(function(v2) {
      return PREFIXES_FOR_FAMILY[FAMILY_SHARP].includes(v2);
    })) {
      family = FAMILY_SHARP;
    }
    var canonical = values.reduce(function(acc, cls) {
      var iconName = getIconName(config$1.cssPrefix, cls);
      if (styles[cls]) {
        cls = LONG_STYLE[family].includes(cls) ? LONG_STYLE_TO_PREFIX[family][cls] : cls;
        givenPrefix = cls;
        acc.prefix = cls;
      } else if (PREFIXES[family].indexOf(cls) > -1) {
        givenPrefix = cls;
        acc.prefix = getCanonicalPrefix(cls, {
          family
        });
      } else if (iconName) {
        acc.iconName = iconName;
      } else if (cls !== config$1.replacementClass && cls !== famProps[FAMILY_CLASSIC] && cls !== famProps[FAMILY_SHARP]) {
        acc.rest.push(cls);
      }
      if (!skipLookups && acc.prefix && acc.iconName) {
        var shim = givenPrefix === "fa" ? byOldName(acc.iconName) : {};
        var aliasIconName = byAlias(acc.prefix, acc.iconName);
        if (shim.prefix) {
          givenPrefix = null;
        }
        acc.iconName = shim.iconName || aliasIconName || acc.iconName;
        acc.prefix = shim.prefix || acc.prefix;
        if (acc.prefix === "far" && !styles["far"] && styles["fas"] && !config$1.autoFetchSvg) {
          acc.prefix = "fas";
        }
      }
      return acc;
    }, emptyCanonicalIcon());
    if (values.includes("fa-brands") || values.includes("fab")) {
      canonical.prefix = "fab";
    }
    if (values.includes("fa-duotone") || values.includes("fad")) {
      canonical.prefix = "fad";
    }
    if (!canonical.prefix && family === FAMILY_SHARP && (styles["fass"] || config$1.autoFetchSvg)) {
      canonical.prefix = "fass";
      canonical.iconName = byAlias(canonical.prefix, canonical.iconName) || canonical.iconName;
    }
    if (canonical.prefix === "fa" || givenPrefix === "fa") {
      canonical.prefix = getDefaultUsablePrefix() || "fas";
    }
    return canonical;
  }
  var Library = /* @__PURE__ */ function() {
    function Library2() {
      _classCallCheck$h(this, Library2);
      this.definitions = {};
    }
    _createClass$h(Library2, [{
      key: "add",
      value: function add2() {
        var _this = this;
        for (var _len = arguments.length, definitions2 = new Array(_len), _key = 0; _key < _len; _key++) {
          definitions2[_key] = arguments[_key];
        }
        var additions = definitions2.reduce(this._pullDefinitions, {});
        Object.keys(additions).forEach(function(key) {
          _this.definitions[key] = _objectSpread2$3(_objectSpread2$3({}, _this.definitions[key] || {}), additions[key]);
          defineIcons(key, additions[key]);
          var longPrefix = PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC][key];
          if (longPrefix)
            defineIcons(longPrefix, additions[key]);
          build$2();
        });
      }
    }, {
      key: "reset",
      value: function reset2() {
        this.definitions = {};
      }
    }, {
      key: "_pullDefinitions",
      value: function _pullDefinitions(additions, definition2) {
        var normalized2 = definition2.prefix && definition2.iconName && definition2.icon ? {
          0: definition2
        } : definition2;
        Object.keys(normalized2).map(function(key) {
          var _normalized$key = normalized2[key], prefix = _normalized$key.prefix, iconName = _normalized$key.iconName, icon2 = _normalized$key.icon;
          var aliases = icon2[2];
          if (!additions[prefix])
            additions[prefix] = {};
          if (aliases.length > 0) {
            aliases.forEach(function(alias) {
              if (typeof alias === "string") {
                additions[prefix][alias] = icon2;
              }
            });
          }
          additions[prefix][iconName] = icon2;
        });
        return additions;
      }
    }]);
    return Library2;
  }();
  var _plugins = [];
  var _hooks = {};
  var providers = {};
  var defaultProviderKeys = Object.keys(providers);
  function registerPlugins(nextPlugins, _ref2) {
    var obj = _ref2.mixoutsTo;
    _plugins = nextPlugins;
    _hooks = {};
    Object.keys(providers).forEach(function(k2) {
      if (defaultProviderKeys.indexOf(k2) === -1) {
        delete providers[k2];
      }
    });
    _plugins.forEach(function(plugin) {
      var mixout = plugin.mixout ? plugin.mixout() : {};
      Object.keys(mixout).forEach(function(tk) {
        if (typeof mixout[tk] === "function") {
          obj[tk] = mixout[tk];
        }
        if (_typeof$8(mixout[tk]) === "object") {
          Object.keys(mixout[tk]).forEach(function(sk) {
            if (!obj[tk]) {
              obj[tk] = {};
            }
            obj[tk][sk] = mixout[tk][sk];
          });
        }
      });
      if (plugin.hooks) {
        var hooks = plugin.hooks();
        Object.keys(hooks).forEach(function(hook) {
          if (!_hooks[hook]) {
            _hooks[hook] = [];
          }
          _hooks[hook].push(hooks[hook]);
        });
      }
      if (plugin.provides) {
        plugin.provides(providers);
      }
    });
    return obj;
  }
  function chainHooks(hook, accumulator) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    var hookFns = _hooks[hook] || [];
    hookFns.forEach(function(hookFn) {
      accumulator = hookFn.apply(null, [accumulator].concat(args));
    });
    return accumulator;
  }
  function callHooks(hook) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }
    var hookFns = _hooks[hook] || [];
    hookFns.forEach(function(hookFn) {
      hookFn.apply(null, args);
    });
    return void 0;
  }
  function callProvided() {
    var hook = arguments[0];
    var args = Array.prototype.slice.call(arguments, 1);
    return providers[hook] ? providers[hook].apply(null, args) : void 0;
  }
  function findIconDefinition(iconLookup) {
    if (iconLookup.prefix === "fa") {
      iconLookup.prefix = "fas";
    }
    var iconName = iconLookup.iconName;
    var prefix = iconLookup.prefix || getDefaultUsablePrefix();
    if (!iconName)
      return;
    iconName = byAlias(prefix, iconName) || iconName;
    return iconFromMapping(library.definitions, prefix, iconName) || iconFromMapping(namespace$1.styles, prefix, iconName);
  }
  var library = new Library();
  var noAuto = function noAuto2() {
    config$1.autoReplaceSvg = false;
    config$1.observeMutations = false;
    callHooks("noAuto");
  };
  var dom = {
    i2svg: function i2svg() {
      var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      if (IS_DOM) {
        callHooks("beforeI2svg", params);
        callProvided("pseudoElements2svg", params);
        return callProvided("i2svg", params);
      } else {
        return Promise.reject("Operation requires a DOM of some kind.");
      }
    },
    watch: function watch() {
      var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      var autoReplaceSvgRoot = params.autoReplaceSvgRoot;
      if (config$1.autoReplaceSvg === false) {
        config$1.autoReplaceSvg = true;
      }
      config$1.observeMutations = true;
      domready(function() {
        autoReplace({
          autoReplaceSvgRoot
        });
        callHooks("watch", params);
      });
    }
  };
  var parse$b = {
    icon: function icon2(_icon) {
      if (_icon === null) {
        return null;
      }
      if (_typeof$8(_icon) === "object" && _icon.prefix && _icon.iconName) {
        return {
          prefix: _icon.prefix,
          iconName: byAlias(_icon.prefix, _icon.iconName) || _icon.iconName
        };
      }
      if (Array.isArray(_icon) && _icon.length === 2) {
        var iconName = _icon[1].indexOf("fa-") === 0 ? _icon[1].slice(3) : _icon[1];
        var prefix = getCanonicalPrefix(_icon[0]);
        return {
          prefix,
          iconName: byAlias(prefix, iconName) || iconName
        };
      }
      if (typeof _icon === "string" && (_icon.indexOf("".concat(config$1.cssPrefix, "-")) > -1 || _icon.match(ICON_SELECTION_SYNTAX_PATTERN))) {
        var canonicalIcon = getCanonicalIcon(_icon.split(" "), {
          skipLookups: true
        });
        return {
          prefix: canonicalIcon.prefix || getDefaultUsablePrefix(),
          iconName: byAlias(canonicalIcon.prefix, canonicalIcon.iconName) || canonicalIcon.iconName
        };
      }
      if (typeof _icon === "string") {
        var _prefix = getDefaultUsablePrefix();
        return {
          prefix: _prefix,
          iconName: byAlias(_prefix, _icon) || _icon
        };
      }
    }
  };
  var api$1 = {
    noAuto,
    config: config$1,
    dom,
    parse: parse$b,
    library,
    findIconDefinition,
    toHtml
  };
  var autoReplace = function autoReplace2() {
    var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var _params$autoReplaceSv = params.autoReplaceSvgRoot, autoReplaceSvgRoot = _params$autoReplaceSv === void 0 ? DOCUMENT : _params$autoReplaceSv;
    if ((Object.keys(namespace$1.styles).length > 0 || config$1.autoFetchSvg) && IS_DOM && config$1.autoReplaceSvg)
      api$1.dom.i2svg({
        node: autoReplaceSvgRoot
      });
  };
  function domVariants(val, abstractCreator) {
    Object.defineProperty(val, "abstract", {
      get: abstractCreator
    });
    Object.defineProperty(val, "html", {
      get: function get2() {
        return val.abstract.map(function(a2) {
          return toHtml(a2);
        });
      }
    });
    Object.defineProperty(val, "node", {
      get: function get2() {
        if (!IS_DOM)
          return;
        var container = DOCUMENT.createElement("div");
        container.innerHTML = val.html;
        return container.children;
      }
    });
    return val;
  }
  function asIcon(_ref2) {
    var children2 = _ref2.children, main2 = _ref2.main, mask = _ref2.mask, attributes2 = _ref2.attributes, styles2 = _ref2.styles, transform = _ref2.transform;
    if (transformIsMeaningful(transform) && main2.found && !mask.found) {
      var width = main2.width, height = main2.height;
      var offset2 = {
        x: width / height / 2,
        y: 0.5
      };
      attributes2["style"] = joinStyles(_objectSpread2$3(_objectSpread2$3({}, styles2), {}, {
        "transform-origin": "".concat(offset2.x + transform.x / 16, "em ").concat(offset2.y + transform.y / 16, "em")
      }));
    }
    return [{
      tag: "svg",
      attributes: attributes2,
      children: children2
    }];
  }
  function asSymbol(_ref2) {
    var prefix = _ref2.prefix, iconName = _ref2.iconName, children2 = _ref2.children, attributes2 = _ref2.attributes, symbol = _ref2.symbol;
    var id2 = symbol === true ? "".concat(prefix, "-").concat(config$1.cssPrefix, "-").concat(iconName) : symbol;
    return [{
      tag: "svg",
      attributes: {
        style: "display: none;"
      },
      children: [{
        tag: "symbol",
        attributes: _objectSpread2$3(_objectSpread2$3({}, attributes2), {}, {
          id: id2
        }),
        children: children2
      }]
    }];
  }
  function makeInlineSvgAbstract(params) {
    var _params$icons = params.icons, main2 = _params$icons.main, mask = _params$icons.mask, prefix = params.prefix, iconName = params.iconName, transform = params.transform, symbol = params.symbol, title = params.title, maskId = params.maskId, titleId = params.titleId, extra = params.extra, _params$watchable = params.watchable, watchable = _params$watchable === void 0 ? false : _params$watchable;
    var _ref2 = mask.found ? mask : main2, width = _ref2.width, height = _ref2.height;
    var isUploadedIcon = prefix === "fak";
    var attrClass = [config$1.replacementClass, iconName ? "".concat(config$1.cssPrefix, "-").concat(iconName) : ""].filter(function(c2) {
      return extra.classes.indexOf(c2) === -1;
    }).filter(function(c2) {
      return c2 !== "" || !!c2;
    }).concat(extra.classes).join(" ");
    var content2 = {
      children: [],
      attributes: _objectSpread2$3(_objectSpread2$3({}, extra.attributes), {}, {
        "data-prefix": prefix,
        "data-icon": iconName,
        "class": attrClass,
        "role": extra.attributes.role || "img",
        "xmlns": "http://www.w3.org/2000/svg",
        "viewBox": "0 0 ".concat(width, " ").concat(height)
      })
    };
    var uploadedIconWidthStyle = isUploadedIcon && !~extra.classes.indexOf("fa-fw") ? {
      width: "".concat(width / height * 16 * 0.0625, "em")
    } : {};
    if (watchable) {
      content2.attributes[DATA_FA_I2SVG] = "";
    }
    if (title) {
      content2.children.push({
        tag: "title",
        attributes: {
          id: content2.attributes["aria-labelledby"] || "title-".concat(titleId || nextUniqueId$1())
        },
        children: [title]
      });
      delete content2.attributes.title;
    }
    var args = _objectSpread2$3(_objectSpread2$3({}, content2), {}, {
      prefix,
      iconName,
      main: main2,
      mask,
      maskId,
      transform,
      symbol,
      styles: _objectSpread2$3(_objectSpread2$3({}, uploadedIconWidthStyle), extra.styles)
    });
    var _ref22 = mask.found && main2.found ? callProvided("generateAbstractMask", args) || {
      children: [],
      attributes: {}
    } : callProvided("generateAbstractIcon", args) || {
      children: [],
      attributes: {}
    }, children2 = _ref22.children, attributes2 = _ref22.attributes;
    args.children = children2;
    args.attributes = attributes2;
    if (symbol) {
      return asSymbol(args);
    } else {
      return asIcon(args);
    }
  }
  function makeLayersTextAbstract(params) {
    var content2 = params.content, width = params.width, height = params.height, transform = params.transform, title = params.title, extra = params.extra, _params$watchable2 = params.watchable, watchable = _params$watchable2 === void 0 ? false : _params$watchable2;
    var attributes2 = _objectSpread2$3(_objectSpread2$3(_objectSpread2$3({}, extra.attributes), title ? {
      "title": title
    } : {}), {}, {
      "class": extra.classes.join(" ")
    });
    if (watchable) {
      attributes2[DATA_FA_I2SVG] = "";
    }
    var styles2 = _objectSpread2$3({}, extra.styles);
    if (transformIsMeaningful(transform)) {
      styles2["transform"] = transformForCss({
        transform,
        startCentered: true,
        width,
        height
      });
      styles2["-webkit-transform"] = styles2["transform"];
    }
    var styleString = joinStyles(styles2);
    if (styleString.length > 0) {
      attributes2["style"] = styleString;
    }
    var val = [];
    val.push({
      tag: "span",
      attributes: attributes2,
      children: [content2]
    });
    if (title) {
      val.push({
        tag: "span",
        attributes: {
          class: "sr-only"
        },
        children: [title]
      });
    }
    return val;
  }
  function makeLayersCounterAbstract(params) {
    var content2 = params.content, title = params.title, extra = params.extra;
    var attributes2 = _objectSpread2$3(_objectSpread2$3(_objectSpread2$3({}, extra.attributes), title ? {
      "title": title
    } : {}), {}, {
      "class": extra.classes.join(" ")
    });
    var styleString = joinStyles(extra.styles);
    if (styleString.length > 0) {
      attributes2["style"] = styleString;
    }
    var val = [];
    val.push({
      tag: "span",
      attributes: attributes2,
      children: [content2]
    });
    if (title) {
      val.push({
        tag: "span",
        attributes: {
          class: "sr-only"
        },
        children: [title]
      });
    }
    return val;
  }
  var styles$1 = namespace$1.styles;
  function asFoundIcon(icon2) {
    var width = icon2[0];
    var height = icon2[1];
    var _icon$slice = icon2.slice(4), _icon$slice2 = _slicedToArray$a(_icon$slice, 1), vectorData = _icon$slice2[0];
    var element2 = null;
    if (Array.isArray(vectorData)) {
      element2 = {
        tag: "g",
        attributes: {
          class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.GROUP)
        },
        children: [{
          tag: "path",
          attributes: {
            class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.SECONDARY),
            fill: "currentColor",
            d: vectorData[0]
          }
        }, {
          tag: "path",
          attributes: {
            class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.PRIMARY),
            fill: "currentColor",
            d: vectorData[1]
          }
        }]
      };
    } else {
      element2 = {
        tag: "path",
        attributes: {
          fill: "currentColor",
          d: vectorData
        }
      };
    }
    return {
      found: true,
      width,
      height,
      icon: element2
    };
  }
  var missingIconResolutionMixin = {
    found: false,
    width: 512,
    height: 512
  };
  function maybeNotifyMissing(iconName, prefix) {
    if (!PRODUCTION$2 && !config$1.showMissingIcons && iconName) {
      console.error('Icon with name "'.concat(iconName, '" and prefix "').concat(prefix, '" is missing.'));
    }
  }
  function findIcon(iconName, prefix) {
    var givenPrefix = prefix;
    if (prefix === "fa" && config$1.styleDefault !== null) {
      prefix = getDefaultUsablePrefix();
    }
    return new Promise(function(resolve2, reject) {
      ({
        found: false,
        width: 512,
        height: 512,
        icon: callProvided("missingIconAbstract") || {}
      });
      if (givenPrefix === "fa") {
        var shim = byOldName(iconName) || {};
        iconName = shim.iconName || iconName;
        prefix = shim.prefix || prefix;
      }
      if (iconName && prefix && styles$1[prefix] && styles$1[prefix][iconName]) {
        var icon2 = styles$1[prefix][iconName];
        return resolve2(asFoundIcon(icon2));
      }
      maybeNotifyMissing(iconName, prefix);
      resolve2(_objectSpread2$3(_objectSpread2$3({}, missingIconResolutionMixin), {}, {
        icon: config$1.showMissingIcons && iconName ? callProvided("missingIconAbstract") || {} : {}
      }));
    });
  }
  var noop$1$1 = function noop2() {
  };
  var p$5 = config$1.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : {
    mark: noop$1$1,
    measure: noop$1$1
  };
  var preamble = 'FA "6.4.0"';
  var begin = function begin2(name2) {
    p$5.mark("".concat(preamble, " ").concat(name2, " begins"));
    return function() {
      return end$2(name2);
    };
  };
  var end$2 = function end2(name2) {
    p$5.mark("".concat(preamble, " ").concat(name2, " ends"));
    p$5.measure("".concat(preamble, " ").concat(name2), "".concat(preamble, " ").concat(name2, " begins"), "".concat(preamble, " ").concat(name2, " ends"));
  };
  var perf = {
    begin,
    end: end$2
  };
  var noop$2$1 = function noop2() {
  };
  function isWatched(node2) {
    var i2svg = node2.getAttribute ? node2.getAttribute(DATA_FA_I2SVG) : null;
    return typeof i2svg === "string";
  }
  function hasPrefixAndIcon(node2) {
    var prefix = node2.getAttribute ? node2.getAttribute(DATA_PREFIX) : null;
    var icon2 = node2.getAttribute ? node2.getAttribute(DATA_ICON) : null;
    return prefix && icon2;
  }
  function hasBeenReplaced(node2) {
    return node2 && node2.classList && node2.classList.contains && node2.classList.contains(config$1.replacementClass);
  }
  function getMutator() {
    if (config$1.autoReplaceSvg === true) {
      return mutators.replace;
    }
    var mutator = mutators[config$1.autoReplaceSvg];
    return mutator || mutators.replace;
  }
  function createElementNS(tag) {
    return DOCUMENT.createElementNS("http://www.w3.org/2000/svg", tag);
  }
  function createElement(tag) {
    return DOCUMENT.createElement(tag);
  }
  function convertSVG(abstractObj) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$ceFn = params.ceFn, ceFn = _params$ceFn === void 0 ? abstractObj.tag === "svg" ? createElementNS : createElement : _params$ceFn;
    if (typeof abstractObj === "string") {
      return DOCUMENT.createTextNode(abstractObj);
    }
    var tag = ceFn(abstractObj.tag);
    Object.keys(abstractObj.attributes || []).forEach(function(key) {
      tag.setAttribute(key, abstractObj.attributes[key]);
    });
    var children2 = abstractObj.children || [];
    children2.forEach(function(child) {
      tag.appendChild(convertSVG(child, {
        ceFn
      }));
    });
    return tag;
  }
  function nodeAsComment(node2) {
    var comment2 = " ".concat(node2.outerHTML, " ");
    comment2 = "".concat(comment2, "Font Awesome fontawesome.com ");
    return comment2;
  }
  var mutators = {
    replace: function replace2(mutation) {
      var node2 = mutation[0];
      if (node2.parentNode) {
        mutation[1].forEach(function(_abstract) {
          node2.parentNode.insertBefore(convertSVG(_abstract), node2);
        });
        if (node2.getAttribute(DATA_FA_I2SVG) === null && config$1.keepOriginalSource) {
          var comment2 = DOCUMENT.createComment(nodeAsComment(node2));
          node2.parentNode.replaceChild(comment2, node2);
        } else {
          node2.remove();
        }
      }
    },
    nest: function nest2(mutation) {
      var node2 = mutation[0];
      var _abstract2 = mutation[1];
      if (~classArray$1(node2).indexOf(config$1.replacementClass)) {
        return mutators.replace(mutation);
      }
      var forSvg = new RegExp("".concat(config$1.cssPrefix, "-.*"));
      delete _abstract2[0].attributes.id;
      if (_abstract2[0].attributes.class) {
        var splitClasses = _abstract2[0].attributes.class.split(" ").reduce(function(acc, cls) {
          if (cls === config$1.replacementClass || cls.match(forSvg)) {
            acc.toSvg.push(cls);
          } else {
            acc.toNode.push(cls);
          }
          return acc;
        }, {
          toNode: [],
          toSvg: []
        });
        _abstract2[0].attributes.class = splitClasses.toSvg.join(" ");
        if (splitClasses.toNode.length === 0) {
          node2.removeAttribute("class");
        } else {
          node2.setAttribute("class", splitClasses.toNode.join(" "));
        }
      }
      var newInnerHTML = _abstract2.map(function(a2) {
        return toHtml(a2);
      }).join("\n");
      node2.setAttribute(DATA_FA_I2SVG, "");
      node2.innerHTML = newInnerHTML;
    }
  };
  function performOperationSync(op) {
    op();
  }
  function perform(mutations, callback) {
    var callbackFunction = typeof callback === "function" ? callback : noop$2$1;
    if (mutations.length === 0) {
      callbackFunction();
    } else {
      var frame2 = performOperationSync;
      if (config$1.mutateApproach === MUTATION_APPROACH_ASYNC) {
        frame2 = WINDOW.requestAnimationFrame || performOperationSync;
      }
      frame2(function() {
        var mutator = getMutator();
        var mark2 = perf.begin("mutate");
        mutations.map(mutator);
        mark2();
        callbackFunction();
      });
    }
  }
  var disabled = false;
  function disableObservation() {
    disabled = true;
  }
  function enableObservation() {
    disabled = false;
  }
  var mo = null;
  function observe(options) {
    if (!MUTATION_OBSERVER) {
      return;
    }
    if (!config$1.observeMutations) {
      return;
    }
    var _options$treeCallback = options.treeCallback, treeCallback = _options$treeCallback === void 0 ? noop$2$1 : _options$treeCallback, _options$nodeCallback = options.nodeCallback, nodeCallback = _options$nodeCallback === void 0 ? noop$2$1 : _options$nodeCallback, _options$pseudoElemen = options.pseudoElementsCallback, pseudoElementsCallback = _options$pseudoElemen === void 0 ? noop$2$1 : _options$pseudoElemen, _options$observeMutat = options.observeMutationsRoot, observeMutationsRoot = _options$observeMutat === void 0 ? DOCUMENT : _options$observeMutat;
    mo = new MUTATION_OBSERVER(function(objects) {
      if (disabled)
        return;
      var defaultPrefix = getDefaultUsablePrefix();
      toArray(objects).forEach(function(mutationRecord) {
        if (mutationRecord.type === "childList" && mutationRecord.addedNodes.length > 0 && !isWatched(mutationRecord.addedNodes[0])) {
          if (config$1.searchPseudoElements) {
            pseudoElementsCallback(mutationRecord.target);
          }
          treeCallback(mutationRecord.target);
        }
        if (mutationRecord.type === "attributes" && mutationRecord.target.parentNode && config$1.searchPseudoElements) {
          pseudoElementsCallback(mutationRecord.target.parentNode);
        }
        if (mutationRecord.type === "attributes" && isWatched(mutationRecord.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(mutationRecord.attributeName)) {
          if (mutationRecord.attributeName === "class" && hasPrefixAndIcon(mutationRecord.target)) {
            var _getCanonicalIcon = getCanonicalIcon(classArray$1(mutationRecord.target)), prefix = _getCanonicalIcon.prefix, iconName = _getCanonicalIcon.iconName;
            mutationRecord.target.setAttribute(DATA_PREFIX, prefix || defaultPrefix);
            if (iconName)
              mutationRecord.target.setAttribute(DATA_ICON, iconName);
          } else if (hasBeenReplaced(mutationRecord.target)) {
            nodeCallback(mutationRecord.target);
          }
        }
      });
    });
    if (!IS_DOM)
      return;
    mo.observe(observeMutationsRoot, {
      childList: true,
      attributes: true,
      characterData: true,
      subtree: true
    });
  }
  function disconnect() {
    if (!mo)
      return;
    mo.disconnect();
  }
  function styleParser(node2) {
    var style2 = node2.getAttribute("style");
    var val = [];
    if (style2) {
      val = style2.split(";").reduce(function(acc, style3) {
        var styles2 = style3.split(":");
        var prop = styles2[0];
        var value = styles2.slice(1);
        if (prop && value.length > 0) {
          acc[prop] = value.join(":").trim();
        }
        return acc;
      }, {});
    }
    return val;
  }
  function classParser(node2) {
    var existingPrefix = node2.getAttribute("data-prefix");
    var existingIconName = node2.getAttribute("data-icon");
    var innerText = node2.innerText !== void 0 ? node2.innerText.trim() : "";
    var val = getCanonicalIcon(classArray$1(node2));
    if (!val.prefix) {
      val.prefix = getDefaultUsablePrefix();
    }
    if (existingPrefix && existingIconName) {
      val.prefix = existingPrefix;
      val.iconName = existingIconName;
    }
    if (val.iconName && val.prefix) {
      return val;
    }
    if (val.prefix && innerText.length > 0) {
      val.iconName = byLigature(val.prefix, node2.innerText) || byUnicode(val.prefix, toHex(node2.innerText));
    }
    if (!val.iconName && config$1.autoFetchSvg && node2.firstChild && node2.firstChild.nodeType === Node.TEXT_NODE) {
      val.iconName = node2.firstChild.data;
    }
    return val;
  }
  function attributesParser(node2) {
    var extraAttributes = toArray(node2.attributes).reduce(function(acc, attr) {
      if (acc.name !== "class" && acc.name !== "style") {
        acc[attr.name] = attr.value;
      }
      return acc;
    }, {});
    var title = node2.getAttribute("title");
    var titleId = node2.getAttribute("data-fa-title-id");
    if (config$1.autoA11y) {
      if (title) {
        extraAttributes["aria-labelledby"] = "".concat(config$1.replacementClass, "-title-").concat(titleId || nextUniqueId$1());
      } else {
        extraAttributes["aria-hidden"] = "true";
        extraAttributes["focusable"] = "false";
      }
    }
    return extraAttributes;
  }
  function blankMeta() {
    return {
      iconName: null,
      title: null,
      titleId: null,
      prefix: null,
      transform: meaninglessTransform,
      symbol: false,
      mask: {
        iconName: null,
        prefix: null,
        rest: []
      },
      maskId: null,
      extra: {
        classes: [],
        styles: {},
        attributes: {}
      }
    };
  }
  function parseMeta(node2) {
    var parser2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {
      styleParser: true
    };
    var _classParser = classParser(node2), iconName = _classParser.iconName, prefix = _classParser.prefix, extraClasses = _classParser.rest;
    var extraAttributes = attributesParser(node2);
    var pluginMeta = chainHooks("parseNodeAttributes", {}, node2);
    var extraStyles = parser2.styleParser ? styleParser(node2) : [];
    return _objectSpread2$3({
      iconName,
      title: node2.getAttribute("title"),
      titleId: node2.getAttribute("data-fa-title-id"),
      prefix,
      transform: meaninglessTransform,
      mask: {
        iconName: null,
        prefix: null,
        rest: []
      },
      maskId: null,
      symbol: false,
      extra: {
        classes: extraClasses,
        styles: extraStyles,
        attributes: extraAttributes
      }
    }, pluginMeta);
  }
  var styles$2 = namespace$1.styles;
  function generateMutation(node2) {
    var nodeMeta = config$1.autoReplaceSvg === "nest" ? parseMeta(node2, {
      styleParser: false
    }) : parseMeta(node2);
    if (~nodeMeta.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME)) {
      return callProvided("generateLayersText", node2, nodeMeta);
    } else {
      return callProvided("generateSvgReplacementMutation", node2, nodeMeta);
    }
  }
  var knownPrefixes = /* @__PURE__ */ new Set();
  FAMILIES.map(function(family) {
    knownPrefixes.add("fa-".concat(family));
  });
  Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC]).map(knownPrefixes.add.bind(knownPrefixes));
  Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP]).map(knownPrefixes.add.bind(knownPrefixes));
  knownPrefixes = _toConsumableArray$5(knownPrefixes);
  function onTree(root2) {
    var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
    if (!IS_DOM)
      return Promise.resolve();
    var htmlClassList = DOCUMENT.documentElement.classList;
    var hclAdd = function hclAdd2(suffix) {
      return htmlClassList.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
    };
    var hclRemove = function hclRemove2(suffix) {
      return htmlClassList.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
    };
    var prefixes2 = config$1.autoFetchSvg ? knownPrefixes : FAMILIES.map(function(f2) {
      return "fa-".concat(f2);
    }).concat(Object.keys(styles$2));
    if (!prefixes2.includes("fa")) {
      prefixes2.push("fa");
    }
    var prefixesDomQuery = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(prefixes2.map(function(p2) {
      return ".".concat(p2, ":not([").concat(DATA_FA_I2SVG, "])");
    })).join(", ");
    if (prefixesDomQuery.length === 0) {
      return Promise.resolve();
    }
    var candidates = [];
    try {
      candidates = toArray(root2.querySelectorAll(prefixesDomQuery));
    } catch (e3) {
    }
    if (candidates.length > 0) {
      hclAdd("pending");
      hclRemove("complete");
    } else {
      return Promise.resolve();
    }
    var mark2 = perf.begin("onTree");
    var mutations = candidates.reduce(function(acc, node2) {
      try {
        var mutation = generateMutation(node2);
        if (mutation) {
          acc.push(mutation);
        }
      } catch (e3) {
        if (!PRODUCTION$2) {
          if (e3.name === "MissingIcon") {
            console.error(e3);
          }
        }
      }
      return acc;
    }, []);
    return new Promise(function(resolve2, reject) {
      Promise.all(mutations).then(function(resolvedMutations) {
        perform(resolvedMutations, function() {
          hclAdd("active");
          hclAdd("complete");
          hclRemove("pending");
          if (typeof callback === "function")
            callback();
          mark2();
          resolve2();
        });
      }).catch(function(e3) {
        mark2();
        reject(e3);
      });
    });
  }
  function onNode(node2) {
    var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
    generateMutation(node2).then(function(mutation) {
      if (mutation) {
        perform([mutation], callback);
      }
    });
  }
  function resolveIcons(next2) {
    return function(maybeIconDefinition) {
      var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      var iconDefinition = (maybeIconDefinition || {}).icon ? maybeIconDefinition : findIconDefinition(maybeIconDefinition || {});
      var mask = params.mask;
      if (mask) {
        mask = (mask || {}).icon ? mask : findIconDefinition(mask || {});
      }
      return next2(iconDefinition, _objectSpread2$3(_objectSpread2$3({}, params), {}, {
        mask
      }));
    };
  }
  var render$1 = function render2(iconDefinition) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$symbol = params.symbol, symbol = _params$symbol === void 0 ? false : _params$symbol, _params$mask = params.mask, mask = _params$mask === void 0 ? null : _params$mask, _params$maskId = params.maskId, maskId = _params$maskId === void 0 ? null : _params$maskId, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$titleId = params.titleId, titleId = _params$titleId === void 0 ? null : _params$titleId, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
    if (!iconDefinition)
      return;
    var prefix = iconDefinition.prefix, iconName = iconDefinition.iconName, icon2 = iconDefinition.icon;
    return domVariants(_objectSpread2$3({
      type: "icon"
    }, iconDefinition), function() {
      callHooks("beforeDOMElementCreation", {
        iconDefinition,
        params
      });
      if (config$1.autoA11y) {
        if (title) {
          attributes2["aria-labelledby"] = "".concat(config$1.replacementClass, "-title-").concat(titleId || nextUniqueId$1());
        } else {
          attributes2["aria-hidden"] = "true";
          attributes2["focusable"] = "false";
        }
      }
      return makeInlineSvgAbstract({
        icons: {
          main: asFoundIcon(icon2),
          mask: mask ? asFoundIcon(mask.icon) : {
            found: false,
            width: null,
            height: null,
            icon: {}
          }
        },
        prefix,
        iconName,
        transform: _objectSpread2$3(_objectSpread2$3({}, meaninglessTransform), transform),
        symbol,
        title,
        maskId,
        titleId,
        extra: {
          attributes: attributes2,
          styles: styles2,
          classes
        }
      });
    });
  };
  var ReplaceElements = {
    mixout: function mixout() {
      return {
        icon: resolveIcons(render$1)
      };
    },
    hooks: function hooks() {
      return {
        mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
          accumulator.treeCallback = onTree;
          accumulator.nodeCallback = onNode;
          return accumulator;
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.i2svg = function(params) {
        var _params$node = params.node, node2 = _params$node === void 0 ? DOCUMENT : _params$node, _params$callback = params.callback, callback = _params$callback === void 0 ? function() {
        } : _params$callback;
        return onTree(node2, callback);
      };
      providers$$1.generateSvgReplacementMutation = function(node2, nodeMeta) {
        var iconName = nodeMeta.iconName, title = nodeMeta.title, titleId = nodeMeta.titleId, prefix = nodeMeta.prefix, transform = nodeMeta.transform, symbol = nodeMeta.symbol, mask = nodeMeta.mask, maskId = nodeMeta.maskId, extra = nodeMeta.extra;
        return new Promise(function(resolve2, reject) {
          Promise.all([findIcon(iconName, prefix), mask.iconName ? findIcon(mask.iconName, mask.prefix) : Promise.resolve({
            found: false,
            width: 512,
            height: 512,
            icon: {}
          })]).then(function(_ref2) {
            var _ref22 = _slicedToArray$a(_ref2, 2), main2 = _ref22[0], mask2 = _ref22[1];
            resolve2([node2, makeInlineSvgAbstract({
              icons: {
                main: main2,
                mask: mask2
              },
              prefix,
              iconName,
              transform,
              symbol,
              maskId,
              title,
              titleId,
              extra,
              watchable: true
            })]);
          }).catch(reject);
        });
      };
      providers$$1.generateAbstractIcon = function(_ref3) {
        var children2 = _ref3.children, attributes2 = _ref3.attributes, main2 = _ref3.main, transform = _ref3.transform, styles2 = _ref3.styles;
        var styleString = joinStyles(styles2);
        if (styleString.length > 0) {
          attributes2["style"] = styleString;
        }
        var nextChild;
        if (transformIsMeaningful(transform)) {
          nextChild = callProvided("generateAbstractTransformGrouping", {
            main: main2,
            transform,
            containerWidth: main2.width,
            iconWidth: main2.width
          });
        }
        children2.push(nextChild || main2.icon);
        return {
          children: children2,
          attributes: attributes2
        };
      };
    }
  };
  var Layers = {
    mixout: function mixout() {
      return {
        layer: function layer(assembler) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes;
          return domVariants({
            type: "layer"
          }, function() {
            callHooks("beforeDOMElementCreation", {
              assembler,
              params
            });
            var children2 = [];
            assembler(function(args) {
              Array.isArray(args) ? args.map(function(a2) {
                children2 = children2.concat(a2.abstract);
              }) : children2 = children2.concat(args.abstract);
            });
            return [{
              tag: "span",
              attributes: {
                class: ["".concat(config$1.cssPrefix, "-layers")].concat(_toConsumableArray$5(classes)).join(" ")
              },
              children: children2
            }];
          });
        }
      };
    }
  };
  var LayersCounter = {
    mixout: function mixout() {
      return {
        counter: function counter2(content2) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
          return domVariants({
            type: "counter",
            content: content2
          }, function() {
            callHooks("beforeDOMElementCreation", {
              content: content2,
              params
            });
            return makeLayersCounterAbstract({
              content: content2.toString(),
              title,
              extra: {
                attributes: attributes2,
                styles: styles2,
                classes: ["".concat(config$1.cssPrefix, "-layers-counter")].concat(_toConsumableArray$5(classes))
              }
            });
          });
        }
      };
    }
  };
  var LayersText = {
    mixout: function mixout() {
      return {
        text: function text2(content2) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
          return domVariants({
            type: "text",
            content: content2
          }, function() {
            callHooks("beforeDOMElementCreation", {
              content: content2,
              params
            });
            return makeLayersTextAbstract({
              content: content2,
              transform: _objectSpread2$3(_objectSpread2$3({}, meaninglessTransform), transform),
              title,
              extra: {
                attributes: attributes2,
                styles: styles2,
                classes: ["".concat(config$1.cssPrefix, "-layers-text")].concat(_toConsumableArray$5(classes))
              }
            });
          });
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.generateLayersText = function(node2, nodeMeta) {
        var title = nodeMeta.title, transform = nodeMeta.transform, extra = nodeMeta.extra;
        var width = null;
        var height = null;
        if (IS_IE) {
          var computedFontSize = parseInt(getComputedStyle(node2).fontSize, 10);
          var boundingClientRect = node2.getBoundingClientRect();
          width = boundingClientRect.width / computedFontSize;
          height = boundingClientRect.height / computedFontSize;
        }
        if (config$1.autoA11y && !title) {
          extra.attributes["aria-hidden"] = "true";
        }
        return Promise.resolve([node2, makeLayersTextAbstract({
          content: node2.innerHTML,
          width,
          height,
          transform,
          title,
          extra,
          watchable: true
        })]);
      };
    }
  };
  var CLEAN_CONTENT_PATTERN = new RegExp('"', "ug");
  var SECONDARY_UNICODE_RANGE = [1105920, 1112319];
  function hexValueFromContent(content2) {
    var cleaned = content2.replace(CLEAN_CONTENT_PATTERN, "");
    var codePoint = codePointAt$1(cleaned, 0);
    var isPrependTen = codePoint >= SECONDARY_UNICODE_RANGE[0] && codePoint <= SECONDARY_UNICODE_RANGE[1];
    var isDoubled = cleaned.length === 2 ? cleaned[0] === cleaned[1] : false;
    return {
      value: isDoubled ? toHex(cleaned[0]) : toHex(cleaned),
      isSecondary: isPrependTen || isDoubled
    };
  }
  function replaceForPosition(node2, position2) {
    var pendingAttribute = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(position2.replace(":", "-"));
    return new Promise(function(resolve2, reject) {
      if (node2.getAttribute(pendingAttribute) !== null) {
        return resolve2();
      }
      var children2 = toArray(node2.children);
      var alreadyProcessedPseudoElement = children2.filter(function(c2) {
        return c2.getAttribute(DATA_FA_PSEUDO_ELEMENT) === position2;
      })[0];
      var styles2 = WINDOW.getComputedStyle(node2, position2);
      var fontFamily = styles2.getPropertyValue("font-family").match(FONT_FAMILY_PATTERN);
      var fontWeight = styles2.getPropertyValue("font-weight");
      var content2 = styles2.getPropertyValue("content");
      if (alreadyProcessedPseudoElement && !fontFamily) {
        node2.removeChild(alreadyProcessedPseudoElement);
        return resolve2();
      } else if (fontFamily && content2 !== "none" && content2 !== "") {
        var _content = styles2.getPropertyValue("content");
        var family = ~["Sharp"].indexOf(fontFamily[2]) ? FAMILY_SHARP : FAMILY_CLASSIC;
        var prefix = ~["Solid", "Regular", "Light", "Thin", "Duotone", "Brands", "Kit"].indexOf(fontFamily[2]) ? STYLE_TO_PREFIX[family][fontFamily[2].toLowerCase()] : FONT_WEIGHT_TO_PREFIX[family][fontWeight];
        var _hexValueFromContent = hexValueFromContent(_content), hexValue = _hexValueFromContent.value, isSecondary = _hexValueFromContent.isSecondary;
        var isV4 = fontFamily[0].startsWith("FontAwesome");
        var iconName = byUnicode(prefix, hexValue);
        var iconIdentifier = iconName;
        if (isV4) {
          var iconName4 = byOldUnicode(hexValue);
          if (iconName4.iconName && iconName4.prefix) {
            iconName = iconName4.iconName;
            prefix = iconName4.prefix;
          }
        }
        if (iconName && !isSecondary && (!alreadyProcessedPseudoElement || alreadyProcessedPseudoElement.getAttribute(DATA_PREFIX) !== prefix || alreadyProcessedPseudoElement.getAttribute(DATA_ICON) !== iconIdentifier)) {
          node2.setAttribute(pendingAttribute, iconIdentifier);
          if (alreadyProcessedPseudoElement) {
            node2.removeChild(alreadyProcessedPseudoElement);
          }
          var meta2 = blankMeta();
          var extra = meta2.extra;
          extra.attributes[DATA_FA_PSEUDO_ELEMENT] = position2;
          findIcon(iconName, prefix).then(function(main2) {
            var _abstract = makeInlineSvgAbstract(_objectSpread2$3(_objectSpread2$3({}, meta2), {}, {
              icons: {
                main: main2,
                mask: emptyCanonicalIcon()
              },
              prefix,
              iconName: iconIdentifier,
              extra,
              watchable: true
            }));
            var element2 = DOCUMENT.createElement("svg");
            if (position2 === "::before") {
              node2.insertBefore(element2, node2.firstChild);
            } else {
              node2.appendChild(element2);
            }
            element2.outerHTML = _abstract.map(function(a2) {
              return toHtml(a2);
            }).join("\n");
            node2.removeAttribute(pendingAttribute);
            resolve2();
          }).catch(reject);
        } else {
          resolve2();
        }
      } else {
        resolve2();
      }
    });
  }
  function replace$2(node2) {
    return Promise.all([replaceForPosition(node2, "::before"), replaceForPosition(node2, "::after")]);
  }
  function processable(node2) {
    return node2.parentNode !== document.head && !~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(node2.tagName.toUpperCase()) && !node2.getAttribute(DATA_FA_PSEUDO_ELEMENT) && (!node2.parentNode || node2.parentNode.tagName !== "svg");
  }
  function searchPseudoElements(root2) {
    if (!IS_DOM)
      return;
    return new Promise(function(resolve2, reject) {
      var operations = toArray(root2.querySelectorAll("*")).filter(processable).map(replace$2);
      var end2 = perf.begin("searchPseudoElements");
      disableObservation();
      Promise.all(operations).then(function() {
        end2();
        enableObservation();
        resolve2();
      }).catch(function() {
        end2();
        enableObservation();
        reject();
      });
    });
  }
  var PseudoElements = {
    hooks: function hooks() {
      return {
        mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
          accumulator.pseudoElementsCallback = searchPseudoElements;
          return accumulator;
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.pseudoElements2svg = function(params) {
        var _params$node = params.node, node2 = _params$node === void 0 ? DOCUMENT : _params$node;
        if (config$1.searchPseudoElements) {
          searchPseudoElements(node2);
        }
      };
    }
  };
  var _unwatched = false;
  var MutationObserver$1 = {
    mixout: function mixout() {
      return {
        dom: {
          unwatch: function unwatch() {
            disableObservation();
            _unwatched = true;
          }
        }
      };
    },
    hooks: function hooks() {
      return {
        bootstrap: function bootstrap() {
          observe(chainHooks("mutationObserverCallbacks", {}));
        },
        noAuto: function noAuto2() {
          disconnect();
        },
        watch: function watch(params) {
          var observeMutationsRoot = params.observeMutationsRoot;
          if (_unwatched) {
            enableObservation();
          } else {
            observe(chainHooks("mutationObserverCallbacks", {
              observeMutationsRoot
            }));
          }
        }
      };
    }
  };
  var parseTransformString = function parseTransformString2(transformString) {
    var transform = {
      size: 16,
      x: 0,
      y: 0,
      flipX: false,
      flipY: false,
      rotate: 0
    };
    return transformString.toLowerCase().split(" ").reduce(function(acc, n2) {
      var parts = n2.toLowerCase().split("-");
      var first = parts[0];
      var rest = parts.slice(1).join("-");
      if (first && rest === "h") {
        acc.flipX = true;
        return acc;
      }
      if (first && rest === "v") {
        acc.flipY = true;
        return acc;
      }
      rest = parseFloat(rest);
      if (isNaN(rest)) {
        return acc;
      }
      switch (first) {
        case "grow":
          acc.size = acc.size + rest;
          break;
        case "shrink":
          acc.size = acc.size - rest;
          break;
        case "left":
          acc.x = acc.x - rest;
          break;
        case "right":
          acc.x = acc.x + rest;
          break;
        case "up":
          acc.y = acc.y - rest;
          break;
        case "down":
          acc.y = acc.y + rest;
          break;
        case "rotate":
          acc.rotate = acc.rotate + rest;
          break;
      }
      return acc;
    }, transform);
  };
  var PowerTransforms = {
    mixout: function mixout() {
      return {
        parse: {
          transform: function transform(transformString) {
            return parseTransformString(transformString);
          }
        }
      };
    },
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var transformString = node2.getAttribute("data-fa-transform");
          if (transformString) {
            accumulator.transform = parseTransformString(transformString);
          }
          return accumulator;
        }
      };
    },
    provides: function provides(providers2) {
      providers2.generateAbstractTransformGrouping = function(_ref2) {
        var main2 = _ref2.main, transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
        var outer = {
          transform: "translate(".concat(containerWidth / 2, " 256)")
        };
        var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
        var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
        var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
        var inner = {
          transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
        };
        var path2 = {
          transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
        };
        var operations = {
          outer,
          inner,
          path: path2
        };
        return {
          tag: "g",
          attributes: _objectSpread2$3({}, operations.outer),
          children: [{
            tag: "g",
            attributes: _objectSpread2$3({}, operations.inner),
            children: [{
              tag: main2.icon.tag,
              children: main2.icon.children,
              attributes: _objectSpread2$3(_objectSpread2$3({}, main2.icon.attributes), operations.path)
            }]
          }]
        };
      };
    }
  };
  var ALL_SPACE = {
    x: 0,
    y: 0,
    width: "100%",
    height: "100%"
  };
  function fillBlack(_abstract) {
    var force = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
    if (_abstract.attributes && (_abstract.attributes.fill || force)) {
      _abstract.attributes.fill = "black";
    }
    return _abstract;
  }
  function deGroup(_abstract2) {
    if (_abstract2.tag === "g") {
      return _abstract2.children;
    } else {
      return [_abstract2];
    }
  }
  var Masks = {
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var maskData = node2.getAttribute("data-fa-mask");
          var mask = !maskData ? emptyCanonicalIcon() : getCanonicalIcon(maskData.split(" ").map(function(i2) {
            return i2.trim();
          }));
          if (!mask.prefix) {
            mask.prefix = getDefaultUsablePrefix();
          }
          accumulator.mask = mask;
          accumulator.maskId = node2.getAttribute("data-fa-mask-id");
          return accumulator;
        }
      };
    },
    provides: function provides(providers2) {
      providers2.generateAbstractMask = function(_ref2) {
        var children2 = _ref2.children, attributes2 = _ref2.attributes, main2 = _ref2.main, mask = _ref2.mask, explicitMaskId = _ref2.maskId, transform = _ref2.transform;
        var mainWidth = main2.width, mainPath = main2.icon;
        var maskWidth = mask.width, maskPath = mask.icon;
        var trans = transformForSvg({
          transform,
          containerWidth: maskWidth,
          iconWidth: mainWidth
        });
        var maskRect = {
          tag: "rect",
          attributes: _objectSpread2$3(_objectSpread2$3({}, ALL_SPACE), {}, {
            fill: "white"
          })
        };
        var maskInnerGroupChildrenMixin = mainPath.children ? {
          children: mainPath.children.map(fillBlack)
        } : {};
        var maskInnerGroup = {
          tag: "g",
          attributes: _objectSpread2$3({}, trans.inner),
          children: [fillBlack(_objectSpread2$3({
            tag: mainPath.tag,
            attributes: _objectSpread2$3(_objectSpread2$3({}, mainPath.attributes), trans.path)
          }, maskInnerGroupChildrenMixin))]
        };
        var maskOuterGroup = {
          tag: "g",
          attributes: _objectSpread2$3({}, trans.outer),
          children: [maskInnerGroup]
        };
        var maskId = "mask-".concat(explicitMaskId || nextUniqueId$1());
        var clipId = "clip-".concat(explicitMaskId || nextUniqueId$1());
        var maskTag = {
          tag: "mask",
          attributes: _objectSpread2$3(_objectSpread2$3({}, ALL_SPACE), {}, {
            id: maskId,
            maskUnits: "userSpaceOnUse",
            maskContentUnits: "userSpaceOnUse"
          }),
          children: [maskRect, maskOuterGroup]
        };
        var defs2 = {
          tag: "defs",
          children: [{
            tag: "clipPath",
            attributes: {
              id: clipId
            },
            children: deGroup(maskPath)
          }, maskTag]
        };
        children2.push(defs2, {
          tag: "rect",
          attributes: _objectSpread2$3({
            fill: "currentColor",
            "clip-path": "url(#".concat(clipId, ")"),
            mask: "url(#".concat(maskId, ")")
          }, ALL_SPACE)
        });
        return {
          children: children2,
          attributes: attributes2
        };
      };
    }
  };
  var MissingIconIndicator = {
    provides: function provides(providers2) {
      var reduceMotion = false;
      if (WINDOW.matchMedia) {
        reduceMotion = WINDOW.matchMedia("(prefers-reduced-motion: reduce)").matches;
      }
      providers2.missingIconAbstract = function() {
        var gChildren = [];
        var FILL = {
          fill: "currentColor"
        };
        var ANIMATION_BASE = {
          attributeType: "XML",
          repeatCount: "indefinite",
          dur: "2s"
        };
        gChildren.push({
          tag: "path",
          attributes: _objectSpread2$3(_objectSpread2$3({}, FILL), {}, {
            d: "M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z"
          })
        });
        var OPACITY_ANIMATE = _objectSpread2$3(_objectSpread2$3({}, ANIMATION_BASE), {}, {
          attributeName: "opacity"
        });
        var dot2 = {
          tag: "circle",
          attributes: _objectSpread2$3(_objectSpread2$3({}, FILL), {}, {
            cx: "256",
            cy: "364",
            r: "28"
          }),
          children: []
        };
        if (!reduceMotion) {
          dot2.children.push({
            tag: "animate",
            attributes: _objectSpread2$3(_objectSpread2$3({}, ANIMATION_BASE), {}, {
              attributeName: "r",
              values: "28;14;28;28;14;28;"
            })
          }, {
            tag: "animate",
            attributes: _objectSpread2$3(_objectSpread2$3({}, OPACITY_ANIMATE), {}, {
              values: "1;0;1;1;0;1;"
            })
          });
        }
        gChildren.push(dot2);
        gChildren.push({
          tag: "path",
          attributes: _objectSpread2$3(_objectSpread2$3({}, FILL), {}, {
            opacity: "1",
            d: "M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z"
          }),
          children: reduceMotion ? [] : [{
            tag: "animate",
            attributes: _objectSpread2$3(_objectSpread2$3({}, OPACITY_ANIMATE), {}, {
              values: "1;0;0;0;0;1;"
            })
          }]
        });
        if (!reduceMotion) {
          gChildren.push({
            tag: "path",
            attributes: _objectSpread2$3(_objectSpread2$3({}, FILL), {}, {
              opacity: "0",
              d: "M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z"
            }),
            children: [{
              tag: "animate",
              attributes: _objectSpread2$3(_objectSpread2$3({}, OPACITY_ANIMATE), {}, {
                values: "0;0;1;1;0;0;"
              })
            }]
          });
        }
        return {
          tag: "g",
          attributes: {
            "class": "missing"
          },
          children: gChildren
        };
      };
    }
  };
  var SvgSymbols = {
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var symbolData = node2.getAttribute("data-fa-symbol");
          var symbol = symbolData === null ? false : symbolData === "" ? true : symbolData;
          accumulator["symbol"] = symbol;
          return accumulator;
        }
      };
    }
  };
  var plugins = [InjectCSS, ReplaceElements, Layers, LayersCounter, LayersText, PseudoElements, MutationObserver$1, PowerTransforms, Masks, MissingIconIndicator, SvgSymbols];
  registerPlugins(plugins, {
    mixoutsTo: api$1
  });
  api$1.noAuto;
  api$1.config;
  api$1.library;
  api$1.dom;
  var parse$1$1 = api$1.parse;
  api$1.findIconDefinition;
  api$1.toHtml;
  var icon = api$1.icon;
  api$1.layer;
  api$1.text;
  api$1.counter;
  var propTypes = { exports: {} };
  var ReactPropTypesSecret$1 = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
  var ReactPropTypesSecret_1 = ReactPropTypesSecret$1;
  var ReactPropTypesSecret = ReactPropTypesSecret_1;
  function emptyFunction() {
  }
  function emptyFunctionWithReset() {
  }
  emptyFunctionWithReset.resetWarningCache = emptyFunction;
  var factoryWithThrowingShims = function() {
    function shim(props, propName, componentName, location2, propFullName, secret) {
      if (secret === ReactPropTypesSecret) {
        return;
      }
      var err = new Error(
        "Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types"
      );
      err.name = "Invariant Violation";
      throw err;
    }
    shim.isRequired = shim;
    function getShim() {
      return shim;
    }
    var ReactPropTypes = {
      array: shim,
      bigint: shim,
      bool: shim,
      func: shim,
      number: shim,
      object: shim,
      string: shim,
      symbol: shim,
      any: shim,
      arrayOf: getShim,
      element: shim,
      elementType: shim,
      instanceOf: getShim,
      node: shim,
      objectOf: getShim,
      oneOf: getShim,
      oneOfType: getShim,
      shape: getShim,
      exact: getShim,
      checkPropTypes: emptyFunctionWithReset,
      resetWarningCache: emptyFunction
    };
    ReactPropTypes.PropTypes = ReactPropTypes;
    return ReactPropTypes;
  };
  {
    propTypes.exports = factoryWithThrowingShims();
  }
  function ownKeys$8(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      enumerableOnly && (symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
      })), keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread2$2(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = null != arguments[i2] ? arguments[i2] : {};
      i2 % 2 ? ownKeys$8(Object(source), true).forEach(function(key) {
        _defineProperty$q(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$8(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
    return target;
  }
  function _typeof$7(obj) {
    "@babel/helpers - typeof";
    return _typeof$7 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$7(obj);
  }
  function _defineProperty$q(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _objectWithoutPropertiesLoose$6(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  function _objectWithoutProperties$3(source, excluded) {
    if (source == null)
      return {};
    var target = _objectWithoutPropertiesLoose$6(source, excluded);
    var key, i2;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
        key = sourceSymbolKeys[i2];
        if (excluded.indexOf(key) >= 0)
          continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key))
          continue;
        target[key] = source[key];
      }
    }
    return target;
  }
  function _toConsumableArray$4(arr) {
    return _arrayWithoutHoles$4(arr) || _iterableToArray$4(arr) || _unsupportedIterableToArray$b(arr) || _nonIterableSpread$4();
  }
  function _arrayWithoutHoles$4(arr) {
    if (Array.isArray(arr))
      return _arrayLikeToArray$b(arr);
  }
  function _iterableToArray$4(iter2) {
    if (typeof Symbol !== "undefined" && iter2[Symbol.iterator] != null || iter2["@@iterator"] != null)
      return Array.from(iter2);
  }
  function _unsupportedIterableToArray$b(o2, minLen) {
    if (!o2)
      return;
    if (typeof o2 === "string")
      return _arrayLikeToArray$b(o2, minLen);
    var n2 = Object.prototype.toString.call(o2).slice(8, -1);
    if (n2 === "Object" && o2.constructor)
      n2 = o2.constructor.name;
    if (n2 === "Map" || n2 === "Set")
      return Array.from(o2);
    if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
      return _arrayLikeToArray$b(o2, minLen);
  }
  function _arrayLikeToArray$b(arr, len) {
    if (len == null || len > arr.length)
      len = arr.length;
    for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
      arr2[i2] = arr[i2];
    return arr2;
  }
  function _nonIterableSpread$4() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function classList$2(props) {
    var _classes;
    var beat = props.beat, fade = props.fade, beatFade = props.beatFade, bounce = props.bounce, shake = props.shake, flash = props.flash, spin = props.spin, spinPulse = props.spinPulse, spinReverse = props.spinReverse, pulse = props.pulse, fixedWidth = props.fixedWidth, inverse = props.inverse, border = props.border, listItem2 = props.listItem, flip2 = props.flip, size = props.size, rotation2 = props.rotation, pull = props.pull;
    var classes = (_classes = {
      "fa-beat": beat,
      "fa-fade": fade,
      "fa-beat-fade": beatFade,
      "fa-bounce": bounce,
      "fa-shake": shake,
      "fa-flash": flash,
      "fa-spin": spin,
      "fa-spin-reverse": spinReverse,
      "fa-spin-pulse": spinPulse,
      "fa-pulse": pulse,
      "fa-fw": fixedWidth,
      "fa-inverse": inverse,
      "fa-border": border,
      "fa-li": listItem2,
      "fa-flip": flip2 === true,
      "fa-flip-horizontal": flip2 === "horizontal" || flip2 === "both",
      "fa-flip-vertical": flip2 === "vertical" || flip2 === "both"
    }, _defineProperty$q(_classes, "fa-".concat(size), typeof size !== "undefined" && size !== null), _defineProperty$q(_classes, "fa-rotate-".concat(rotation2), typeof rotation2 !== "undefined" && rotation2 !== null && rotation2 !== 0), _defineProperty$q(_classes, "fa-pull-".concat(pull), typeof pull !== "undefined" && pull !== null), _defineProperty$q(_classes, "fa-swap-opacity", props.swapOpacity), _classes);
    return Object.keys(classes).map(function(key) {
      return classes[key] ? key : null;
    }).filter(function(key) {
      return key;
    });
  }
  function _isNumerical$1(obj) {
    obj = obj - 0;
    return obj === obj;
  }
  function camelize$1(string2) {
    if (_isNumerical$1(string2)) {
      return string2;
    }
    string2 = string2.replace(/[\-_\s]+(.)?/g, function(match2, chr) {
      return chr ? chr.toUpperCase() : "";
    });
    return string2.substr(0, 1).toLowerCase() + string2.substr(1);
  }
  var _excluded$5 = ["style"];
  function capitalize$2(val) {
    return val.charAt(0).toUpperCase() + val.slice(1);
  }
  function styleToObject$2(style2) {
    return style2.split(";").map(function(s2) {
      return s2.trim();
    }).filter(function(s2) {
      return s2;
    }).reduce(function(acc, pair2) {
      var i2 = pair2.indexOf(":");
      var prop = camelize$1(pair2.slice(0, i2));
      var value = pair2.slice(i2 + 1).trim();
      prop.startsWith("webkit") ? acc[capitalize$2(prop)] = value : acc[prop] = value;
      return acc;
    }, {});
  }
  function convert$2(createElement2, element2) {
    var extraProps = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    if (typeof element2 === "string") {
      return element2;
    }
    var children2 = (element2.children || []).map(function(child) {
      return convert$2(createElement2, child);
    });
    var mixins = Object.keys(element2.attributes || {}).reduce(function(acc, key) {
      var val = element2.attributes[key];
      switch (key) {
        case "class":
          acc.attrs["className"] = val;
          delete element2.attributes["class"];
          break;
        case "style":
          acc.attrs["style"] = styleToObject$2(val);
          break;
        default:
          if (key.indexOf("aria-") === 0 || key.indexOf("data-") === 0) {
            acc.attrs[key.toLowerCase()] = val;
          } else {
            acc.attrs[camelize$1(key)] = val;
          }
      }
      return acc;
    }, {
      attrs: {}
    });
    var _extraProps$style = extraProps.style, existingStyle = _extraProps$style === void 0 ? {} : _extraProps$style, remaining = _objectWithoutProperties$3(extraProps, _excluded$5);
    mixins.attrs["style"] = _objectSpread2$2(_objectSpread2$2({}, mixins.attrs["style"]), existingStyle);
    return createElement2.apply(void 0, [element2.tag, _objectSpread2$2(_objectSpread2$2({}, mixins.attrs), remaining)].concat(_toConsumableArray$4(children2)));
  }
  var PRODUCTION$1 = false;
  try {
    PRODUCTION$1 = true;
  } catch (e3) {
  }
  function log$1() {
    if (!PRODUCTION$1 && console && typeof console.error === "function") {
      var _console;
      (_console = console).error.apply(_console, arguments);
    }
  }
  function normalizeIconArgs$1(icon2) {
    if (icon2 && _typeof$7(icon2) === "object" && icon2.prefix && icon2.iconName && icon2.icon) {
      return icon2;
    }
    if (parse$1$1.icon) {
      return parse$1$1.icon(icon2);
    }
    if (icon2 === null) {
      return null;
    }
    if (icon2 && _typeof$7(icon2) === "object" && icon2.prefix && icon2.iconName) {
      return icon2;
    }
    if (Array.isArray(icon2) && icon2.length === 2) {
      return {
        prefix: icon2[0],
        iconName: icon2[1]
      };
    }
    if (typeof icon2 === "string") {
      return {
        prefix: "fas",
        iconName: icon2
      };
    }
  }
  function objectWithKey$1(key, value) {
    return Array.isArray(value) && value.length > 0 || !Array.isArray(value) && value ? _defineProperty$q({}, key, value) : {};
  }
  var FontAwesomeIcon$1 = /* @__PURE__ */ React__default.default.forwardRef(function(props, ref) {
    var iconArgs = props.icon, maskArgs = props.mask, symbol = props.symbol, className = props.className, title = props.title, titleId = props.titleId, maskId = props.maskId;
    var iconLookup = normalizeIconArgs$1(iconArgs);
    var classes = objectWithKey$1("classes", [].concat(_toConsumableArray$4(classList$2(props)), _toConsumableArray$4(className.split(" "))));
    var transform = objectWithKey$1("transform", typeof props.transform === "string" ? parse$1$1.transform(props.transform) : props.transform);
    var mask = objectWithKey$1("mask", normalizeIconArgs$1(maskArgs));
    var renderedIcon = icon(iconLookup, _objectSpread2$2(_objectSpread2$2(_objectSpread2$2(_objectSpread2$2({}, classes), transform), mask), {}, {
      symbol,
      title,
      titleId,
      maskId
    }));
    if (!renderedIcon) {
      log$1("Could not find icon", iconLookup);
      return null;
    }
    var abstract = renderedIcon.abstract;
    var extraProps = {
      ref
    };
    Object.keys(props).forEach(function(key) {
      if (!FontAwesomeIcon$1.defaultProps.hasOwnProperty(key)) {
        extraProps[key] = props[key];
      }
    });
    return convertCurry$1(abstract[0], extraProps);
  });
  FontAwesomeIcon$1.displayName = "FontAwesomeIcon";
  FontAwesomeIcon$1.propTypes = {
    beat: propTypes.exports.bool,
    border: propTypes.exports.bool,
    beatFade: propTypes.exports.bool,
    bounce: propTypes.exports.bool,
    className: propTypes.exports.string,
    fade: propTypes.exports.bool,
    flash: propTypes.exports.bool,
    mask: propTypes.exports.oneOfType([propTypes.exports.object, propTypes.exports.array, propTypes.exports.string]),
    maskId: propTypes.exports.string,
    fixedWidth: propTypes.exports.bool,
    inverse: propTypes.exports.bool,
    flip: propTypes.exports.oneOf([true, false, "horizontal", "vertical", "both"]),
    icon: propTypes.exports.oneOfType([propTypes.exports.object, propTypes.exports.array, propTypes.exports.string]),
    listItem: propTypes.exports.bool,
    pull: propTypes.exports.oneOf(["right", "left"]),
    pulse: propTypes.exports.bool,
    rotation: propTypes.exports.oneOf([0, 90, 180, 270]),
    shake: propTypes.exports.bool,
    size: propTypes.exports.oneOf(["2xs", "xs", "sm", "lg", "xl", "2xl", "1x", "2x", "3x", "4x", "5x", "6x", "7x", "8x", "9x", "10x"]),
    spin: propTypes.exports.bool,
    spinPulse: propTypes.exports.bool,
    spinReverse: propTypes.exports.bool,
    symbol: propTypes.exports.oneOfType([propTypes.exports.bool, propTypes.exports.string]),
    title: propTypes.exports.string,
    titleId: propTypes.exports.string,
    transform: propTypes.exports.oneOfType([propTypes.exports.string, propTypes.exports.object]),
    swapOpacity: propTypes.exports.bool
  };
  FontAwesomeIcon$1.defaultProps = {
    border: false,
    className: "",
    mask: null,
    maskId: null,
    fixedWidth: false,
    inverse: false,
    flip: false,
    icon: null,
    listItem: false,
    pull: null,
    pulse: false,
    rotation: null,
    size: null,
    spin: false,
    spinPulse: false,
    spinReverse: false,
    beat: false,
    fade: false,
    beatFade: false,
    bounce: false,
    shake: false,
    symbol: false,
    title: "",
    titleId: null,
    transform: null,
    swapOpacity: false
  };
  var convertCurry$1 = convert$2.bind(null, React__default.default.createElement);
  var Icon$2 = function(e3) {
    var t2 = {};
    function r2(n2) {
      if (t2[n2])
        return t2[n2].exports;
      var o2 = t2[n2] = { i: n2, l: false, exports: {} };
      return e3[n2].call(o2.exports, o2, o2.exports, r2), o2.l = true, o2.exports;
    }
    return r2.m = e3, r2.c = t2, r2.d = function(e4, t3, n2) {
      r2.o(e4, t3) || Object.defineProperty(e4, t3, { enumerable: true, get: n2 });
    }, r2.r = function(e4) {
      "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e4, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(e4, "__esModule", { value: true });
    }, r2.t = function(e4, t3) {
      if (1 & t3 && (e4 = r2(e4)), 8 & t3)
        return e4;
      if (4 & t3 && "object" == typeof e4 && e4 && e4.__esModule)
        return e4;
      var n2 = /* @__PURE__ */ Object.create(null);
      if (r2.r(n2), Object.defineProperty(n2, "default", { enumerable: true, value: e4 }), 2 & t3 && "string" != typeof e4)
        for (var o2 in e4)
          r2.d(n2, o2, function(t4) {
            return e4[t4];
          }.bind(null, o2));
      return n2;
    }, r2.n = function(e4) {
      var t3 = e4 && e4.__esModule ? function() {
        return e4.default;
      } : function() {
        return e4;
      };
      return r2.d(t3, "a", t3), t3;
    }, r2.o = function(e4, t3) {
      return Object.prototype.hasOwnProperty.call(e4, t3);
    }, r2.p = "", r2(r2.s = 2);
  }([function(e3, t2) {
    e3.exports = propTypes.exports;
  }, function(e3, t2) {
    e3.exports = React__default.default;
  }, function(e3, t2, r2) {
    r2.r(t2);
    var n2 = r2(1), o2 = r2(0), l2 = function() {
      return (l2 = Object.assign || function(e4) {
        for (var t3, r3 = 1, n3 = arguments.length; r3 < n3; r3++)
          for (var o3 in t3 = arguments[r3])
            Object.prototype.hasOwnProperty.call(t3, o3) && (e4[o3] = t3[o3]);
        return e4;
      }).apply(this, arguments);
    }, i2 = function(e4, t3) {
      var r3 = {};
      for (var n3 in e4)
        Object.prototype.hasOwnProperty.call(e4, n3) && t3.indexOf(n3) < 0 && (r3[n3] = e4[n3]);
      if (null != e4 && "function" == typeof Object.getOwnPropertySymbols) {
        var o3 = 0;
        for (n3 = Object.getOwnPropertySymbols(e4); o3 < n3.length; o3++)
          t3.indexOf(n3[o3]) < 0 && Object.prototype.propertyIsEnumerable.call(e4, n3[o3]) && (r3[n3[o3]] = e4[n3[o3]]);
      }
      return r3;
    }, a2 = 0, s2 = n2.forwardRef(function(e4, t3) {
      var r3 = e4.title, o3 = void 0 === r3 ? null : r3, s3 = e4.description, c3 = void 0 === s3 ? null : s3, u3 = e4.size, p3 = void 0 === u3 ? null : u3, f3 = e4.color, d3 = void 0 === f3 ? "currentColor" : f3, y2 = e4.horizontal, v2 = void 0 === y2 ? null : y2, b2 = e4.vertical, m2 = void 0 === b2 ? null : b2, h2 = e4.rotate, g2 = void 0 === h2 ? null : h2, O2 = e4.spin, w2 = void 0 === O2 ? null : O2, j2 = e4.style, z2 = void 0 === j2 ? {} : j2, E2 = e4.children, P2 = i2(e4, ["title", "description", "size", "color", "horizontal", "vertical", "rotate", "spin", "style", "children"]);
      a2++;
      var S2, x2 = null !== w2 && w2, _2 = n2.Children.map(E2, function(e6) {
        var t4 = e6;
        true !== x2 && (x2 = true === (null === w2 ? t4.props.spin : w2));
        var r4 = t4.props.size;
        "number" == typeof p3 && "number" == typeof t4.props.size && (r4 = t4.props.size / p3);
        var o4 = { size: r4, color: null === d3 ? t4.props.color : d3, horizontal: null === v2 ? t4.props.horizontal : v2, vertical: null === m2 ? t4.props.vertical : m2, rotate: null === g2 ? t4.props.rotate : g2, spin: null === w2 ? t4.props.spin : w2, inStack: true };
        return n2.cloneElement(t4, o4);
      });
      null !== p3 && (z2.width = "string" == typeof p3 ? p3 : 1.5 * p3 + "rem");
      var k2, T2 = "stack_labelledby_" + a2, q2 = "stack_describedby_" + a2;
      if (o3)
        S2 = c3 ? T2 + " " + q2 : T2;
      else if (k2 = "presentation", c3)
        throw new Error("title attribute required when description is set");
      return n2.createElement("svg", l2({ ref: t3, viewBox: "0 0 24 24", style: z2, role: k2, "aria-labelledby": S2 }, P2), o3 && n2.createElement("title", { id: T2 }, o3), c3 && n2.createElement("desc", { id: q2 }, c3), x2 && n2.createElement("style", null, "@keyframes spin { to { transform: rotate(360deg) } }", "@keyframes spin-inverse { to { transform: rotate(-360deg) } }"), _2);
    });
    s2.displayName = "Stack", s2.propTypes = { size: o2.oneOfType([o2.number, o2.string]), color: o2.string, horizontal: o2.bool, vertical: o2.bool, rotate: o2.number, spin: o2.oneOfType([o2.bool, o2.number]), children: o2.oneOfType([o2.arrayOf(o2.node), o2.node]).isRequired, className: o2.string, style: o2.object }, s2.defaultProps = { size: null, color: null, horizontal: null, vertical: null, rotate: null, spin: null };
    var c2 = s2;
    r2.d(t2, "Icon", function() {
      return d2;
    }), r2.d(t2, "Stack", function() {
      return c2;
    });
    var u2 = function() {
      return (u2 = Object.assign || function(e4) {
        for (var t3, r3 = 1, n3 = arguments.length; r3 < n3; r3++)
          for (var o3 in t3 = arguments[r3])
            Object.prototype.hasOwnProperty.call(t3, o3) && (e4[o3] = t3[o3]);
        return e4;
      }).apply(this, arguments);
    }, p2 = function(e4, t3) {
      var r3 = {};
      for (var n3 in e4)
        Object.prototype.hasOwnProperty.call(e4, n3) && t3.indexOf(n3) < 0 && (r3[n3] = e4[n3]);
      if (null != e4 && "function" == typeof Object.getOwnPropertySymbols) {
        var o3 = 0;
        for (n3 = Object.getOwnPropertySymbols(e4); o3 < n3.length; o3++)
          t3.indexOf(n3[o3]) < 0 && Object.prototype.propertyIsEnumerable.call(e4, n3[o3]) && (r3[n3[o3]] = e4[n3[o3]]);
      }
      return r3;
    }, f2 = 0, d2 = n2.forwardRef(function(e4, t3) {
      var r3 = e4.path, o3 = e4.title, l3 = void 0 === o3 ? null : o3, i3 = e4.description, a3 = void 0 === i3 ? null : i3, s3 = e4.size, c3 = void 0 === s3 ? null : s3, d3 = e4.color, y2 = void 0 === d3 ? "currentColor" : d3, v2 = e4.horizontal, b2 = void 0 !== v2 && v2, m2 = e4.vertical, h2 = void 0 !== m2 && m2, g2 = e4.rotate, O2 = void 0 === g2 ? 0 : g2, w2 = e4.spin, j2 = void 0 !== w2 && w2, z2 = e4.style, E2 = void 0 === z2 ? {} : z2, P2 = e4.inStack, S2 = void 0 !== P2 && P2, x2 = p2(e4, ["path", "title", "description", "size", "color", "horizontal", "vertical", "rotate", "spin", "style", "inStack"]);
      f2++;
      var _2 = {}, k2 = [];
      null !== c3 && (S2 ? k2.push("scale(" + c3 + ")") : (E2.width = "string" == typeof c3 ? c3 : 1.5 * c3 + "rem", E2.height = E2.width)), b2 && k2.push("scaleX(-1)"), h2 && k2.push("scaleY(-1)"), 0 !== O2 && k2.push("rotate(" + O2 + "deg)"), null !== y2 && (_2.fill = y2);
      var T2 = n2.createElement("path", u2({ d: r3, style: _2 }, S2 ? x2 : {})), q2 = T2;
      k2.length > 0 && (E2.transform = k2.join(" "), E2.transformOrigin = "center", S2 && (q2 = n2.createElement("g", { style: E2 }, T2, n2.createElement("rect", { width: "24", height: "24", fill: "transparent" }))));
      var M2, C2 = q2, I2 = true === j2 || "number" != typeof j2 ? 2 : j2, N2 = !S2 && (b2 || h2);
      if (I2 < 0 && (N2 = !N2), j2 && (C2 = n2.createElement("g", { style: { animation: "spin" + (N2 ? "-inverse" : "") + " linear " + Math.abs(I2) + "s infinite", transformOrigin: "center" } }, q2, !(b2 || h2 || 0 !== O2) && n2.createElement("rect", { width: "24", height: "24", fill: "transparent" }))), S2)
        return C2;
      var R2, B2 = "icon_labelledby_" + f2, X2 = "icon_describedby_" + f2;
      if (l3)
        M2 = a3 ? B2 + " " + X2 : B2;
      else if (R2 = "presentation", a3)
        throw new Error("title attribute required when description is set");
      return n2.createElement("svg", u2({ ref: t3, viewBox: "0 0 24 24", style: E2, role: R2, "aria-labelledby": M2 }, x2), l3 && n2.createElement("title", { id: B2 }, l3), a3 && n2.createElement("desc", { id: X2 }, a3), !S2 && j2 && (N2 ? n2.createElement("style", null, "@keyframes spin-inverse { to { transform: rotate(-360deg) } }") : n2.createElement("style", null, "@keyframes spin { to { transform: rotate(360deg) } }")), C2);
    });
    d2.displayName = "Icon", d2.propTypes = { path: o2.string.isRequired, size: o2.oneOfType([o2.number, o2.string]), color: o2.string, horizontal: o2.bool, vertical: o2.bool, rotate: o2.number, spin: o2.oneOfType([o2.bool, o2.number]), style: o2.object, inStack: o2.bool, className: o2.string }, d2.defaultProps = { size: null, color: "currentColor", horizontal: false, vertical: false, rotate: 0, spin: false };
    t2.default = d2;
  }]);
  const shouldForwardProp$4 = (prop) => !["asButton"].includes(prop);
  const StyledFAIcon = styled__default.default(FontAwesomeIcon$1).withConfig({ shouldForwardProp: shouldForwardProp$4 })`
    cursor: ${(props) => props.asButton ? "pointer" : "inherit"};
    color: inherit;
    ${(props) => props.asButton ? `:hover { color: ${props.theme.colors.grey6}; }` : ""}
`;
  const mapFASizeToMD = {
    "10x": "120px",
    "1x": "12px",
    "2x": "24px",
    "3x": "36px",
    "4x": "48px",
    "5x": "60px",
    "6x": "72px",
    "7x": "84px",
    "8x": "96px",
    "9x": "108px",
    lg: "24px",
    sm: "12px",
    xs: "6px"
  };
  const SizeMappedMDIcon = (props) => {
    if (props.size) {
      return jsxRuntime.exports.jsx(Icon$2.Icon, Object.assign({}, props, { size: mapFASizeToMD[props.size] }));
    }
    return jsxRuntime.exports.jsx(Icon$2.Icon, Object.assign({}, props));
  };
  const StyledMDIcon = styled__default.default(SizeMappedMDIcon).withConfig({ shouldForwardProp: shouldForwardProp$4 })`
    cursor: ${(props) => props.asButton ? "pointer" : "default"};
    color: inherit;
    ${(props) => props.asButton ? `:hover { color: ${props.theme.colors.grey6}; }` : ""}
`;
  var mdiSwapHorizontal = "M21,9L17,5V8H10V10H17V13M7,11L3,15L7,19V16H14V14H7V11Z";
  const ArrowDown = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowDown }, props));
  };
  const ArrowLeft = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowLeft }, props));
  };
  const ArrowRight = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowRight }, props));
  };
  const ArrowRightLong = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowRightLong }, props));
  };
  const ArrowUp = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowUp }, props));
  };
  const ArrowsHorizontal = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowsAltH }, props));
  };
  const Arrows$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrows }, props));
  };
  const Ban = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faBan }, props));
  };
  const Check = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCheck }, props));
  };
  const CheckSquare = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCheckSquare }, props));
  };
  const ChevronLeft = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronLeft }, props));
  };
  const ChevronRight = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronRight }, props));
  };
  const Circle$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCircle }, props));
  };
  var faSquare = {
    prefix: "far",
    iconName: "square",
    icon: [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M384 80c8.8 0 16 7.2 16 16V416c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V96c0-8.8 7.2-16 16-16H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z"]
  };
  var faCircleQuestion = {
    prefix: "far",
    iconName: "circle-question",
    icon: [512, 512, [62108, "question-circle"], "f059", "M464 256A208 208 0 1 0 48 256a208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm169.8-90.7c7.9-22.3 29.1-37.3 52.8-37.3h58.3c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L280 264.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24V250.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H222.6c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
  };
  var faCopy = {
    prefix: "far",
    iconName: "copy",
    icon: [512, 512, [], "f0c5", "M448 384H256c-35.3 0-64-28.7-64-64V64c0-35.3 28.7-64 64-64H396.1c12.7 0 24.9 5.1 33.9 14.1l67.9 67.9c9 9 14.1 21.2 14.1 33.9V320c0 35.3-28.7 64-64 64zM64 128h96v48H64c-8.8 0-16 7.2-16 16V448c0 8.8 7.2 16 16 16H256c8.8 0 16-7.2 16-16V416h48v32c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64z"]
  };
  const Copy = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCopy }, props));
  };
  const Cross$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTimes }, props));
  };
  const Filter$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faFilter }, props));
  };
  const Plus = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faPlus }, props));
  };
  const Refresh = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faRefresh }, props));
  };
  const Search = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faSearch }, props));
  };
  const Square = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faSquare }, props));
  };
  const SwapHorizontal = (props) => {
    return jsxRuntime.exports.jsx(StyledMDIcon, Object.assign({ path: mdiSwapHorizontal }, props));
  };
  const ToggleOff = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faToggleOff }, props));
  };
  const ToggleOn = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faToggleOn }, props));
  };
  const Trash = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTrash }, props));
  };
  const ChevronDown = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronDown }, props));
  };
  const ChevronUp = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronUp }, props));
  };
  const List$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faList }, props));
  };
  const Moon = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faMoon }, props));
  };
  const TrashAlt = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTrashAlt }, props));
  };
  const MagnifyingGlass = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faMagnifyingGlass }, props));
  };
  const shouldForwardProp$3 = (prop) => !["isOpen"].includes(prop);
  const Icon$1 = styled__default.default(ChevronDown).withConfig({ shouldForwardProp: shouldForwardProp$3 })`
    cursor: ${(props) => props.disabled ? "not-allowed" : "pointer"};
    transform: ${(props) => {
    const start2 = props.angles ? props.angles[0] : 0;
    const end2 = props.angles ? props.angles[1] : 180;
    return props.isOpen ? `rotate(${end2}deg)` : `rotate(${start2}deg)`;
  }};
    color: ${(props) => props.theme.colors.grey5};
    transition: transform 0.1s linear;
`;
  function Chevron$1(props, ref) {
    return jsxRuntime.exports.jsx(Icon$1, { angles: props.angles, className: props.className, disabled: props.disabled, isOpen: props.isOpen, onClick: props.onClick, ref, style: props.style });
  }
  const Chevron$2 = React__namespace.forwardRef(Chevron$1);
  styled__default.default.label`
    margin-bottom: 0px;
    font-size: 11px;
    color: ${(props) => props.theme.colors.grey6};
`;
  const List = styled__default.default.div`
    z-index: 5000;

    overflow-y: auto;
    display: ${(props) => props.isOpen ? "flex" : "none"};
    flex-direction: column;

    max-height: calc(${(props) => (props.maxItems || 5) * 2}em + 2px);

    border: 1px solid ${(props) => props.theme.colors.grey3};
`;
  const ListItem = styled__default.default.span`
    cursor: pointer;
    user-select: none;

    overflow: hidden;

    width: 100%;
    min-height: 2rem;
    padding: 0.25rem 1rem;

    font-size: ${(props) => props.size ? `${props.size}rem` : "1rem"};
    font-weight: 300;
    color: ${(props) => props.theme.colors.text};
    text-overflow: ellipsis;
    white-space: nowrap;

    background-color: ${(props) => props.hovered ? props.theme.colors.grey2 : props.theme.colors.blue1};
    border-bottom: 1px solid ${(props) => props.theme.colors.grey3};

    :active {
        color: ${(props) => props.theme.colors.blue1};
        background-color: ${(props) => props.theme.colors.primary};
    }

    &:last-child {
        border-bottom: none;
    }
`;
  const sameWidthModifier = {
    effect: ({ state }) => () => {
      state.elements.popper.style.width = `${state.elements.reference.offsetWidth}px`;
    },
    enabled: true,
    fn: ({ state }) => {
      state.styles.popper.width = `${state.rects.reference.width}px`;
    },
    name: "sameWidth",
    phase: "beforeWrite",
    requires: ["computeStyles"]
  };
  globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var Status;
  (function(Status2) {
    Status2["CANCELED"] = "CANCELED";
    Status2["CREATED"] = "CREATED";
    Status2["ERROR"] = "ERROR";
    Status2["FAILED"] = "FAILED";
    Status2["NONE"] = "";
    Status2["QUEUED"] = "QUEUED";
    Status2["RUNNING"] = "RUNNING";
    Status2["SUCCESS"] = "SUCCESS";
    Status2["WARNING"] = "WARNING";
  })(Status || (Status = {}));
  var HTTP_METHOD;
  (function(HTTP_METHOD2) {
    HTTP_METHOD2["DELETE"] = "DELETE";
    HTTP_METHOD2["GET"] = "GET";
    HTTP_METHOD2["PATCH"] = "PATCH";
    HTTP_METHOD2["POST"] = "POST";
    HTTP_METHOD2["PUT"] = "PUT";
  })(HTTP_METHOD || (HTTP_METHOD = {}));
  var shortid$1 = { exports: {} };
  var lib$1 = { exports: {} };
  var seed = 1;
  function getNextValue$1() {
    seed = (seed * 9301 + 49297) % 233280;
    return seed / 233280;
  }
  function setSeed$1(_seed_) {
    seed = _seed_;
  }
  var randomFromSeed$1 = {
    nextValue: getNextValue$1,
    seed: setSeed$1
  };
  var randomFromSeed = randomFromSeed$1;
  var ORIGINAL = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
  var alphabet$2;
  var previousSeed;
  var shuffled;
  function reset() {
    shuffled = false;
  }
  function setCharacters(_alphabet_) {
    if (!_alphabet_) {
      if (alphabet$2 !== ORIGINAL) {
        alphabet$2 = ORIGINAL;
        reset();
      }
      return;
    }
    if (_alphabet_ === alphabet$2) {
      return;
    }
    if (_alphabet_.length !== ORIGINAL.length) {
      throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. You submitted " + _alphabet_.length + " characters: " + _alphabet_);
    }
    var unique2 = _alphabet_.split("").filter(function(item, ind, arr) {
      return ind !== arr.lastIndexOf(item);
    });
    if (unique2.length) {
      throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. These characters were not unique: " + unique2.join(", "));
    }
    alphabet$2 = _alphabet_;
    reset();
  }
  function characters(_alphabet_) {
    setCharacters(_alphabet_);
    return alphabet$2;
  }
  function setSeed(seed2) {
    randomFromSeed.seed(seed2);
    if (previousSeed !== seed2) {
      reset();
      previousSeed = seed2;
    }
  }
  function shuffle$2() {
    if (!alphabet$2) {
      setCharacters(ORIGINAL);
    }
    var sourceArray = alphabet$2.split("");
    var targetArray = [];
    var r2 = randomFromSeed.nextValue();
    var characterIndex;
    while (sourceArray.length > 0) {
      r2 = randomFromSeed.nextValue();
      characterIndex = Math.floor(r2 * sourceArray.length);
      targetArray.push(sourceArray.splice(characterIndex, 1)[0]);
    }
    return targetArray.join("");
  }
  function getShuffled() {
    if (shuffled) {
      return shuffled;
    }
    shuffled = shuffle$2();
    return shuffled;
  }
  function lookup$1(index2) {
    var alphabetShuffled = getShuffled();
    return alphabetShuffled[index2];
  }
  function get$5() {
    return alphabet$2 || ORIGINAL;
  }
  var alphabet_1 = {
    get: get$5,
    characters,
    seed: setSeed,
    lookup: lookup$1,
    shuffled: getShuffled
  };
  var crypto$1 = typeof window === "object" && (window.crypto || window.msCrypto);
  var randomByte;
  if (!crypto$1 || !crypto$1.getRandomValues) {
    randomByte = function(size) {
      var bytes = [];
      for (var i2 = 0; i2 < size; i2++) {
        bytes.push(Math.floor(Math.random() * 256));
      }
      return bytes;
    };
  } else {
    randomByte = function(size) {
      return crypto$1.getRandomValues(new Uint8Array(size));
    };
  }
  var randomByteBrowser = randomByte;
  var format_browser = function(random2, alphabet2, size) {
    var mask = (2 << Math.log(alphabet2.length - 1) / Math.LN2) - 1;
    var step2 = -~(1.6 * mask * size / alphabet2.length);
    var id2 = "";
    while (true) {
      var bytes = random2(step2);
      var i2 = step2;
      while (i2--) {
        id2 += alphabet2[bytes[i2] & mask] || "";
        if (id2.length === +size)
          return id2;
      }
    }
  };
  var alphabet$1 = alphabet_1;
  var random$3 = randomByteBrowser;
  var format$3 = format_browser;
  function generate$1(number2) {
    var loopCounter = 0;
    var done;
    var str = "";
    while (!done) {
      str = str + format$3(random$3, alphabet$1.get(), 1);
      done = number2 < Math.pow(16, loopCounter + 1);
      loopCounter++;
    }
    return str;
  }
  var generate_1 = generate$1;
  var generate = generate_1;
  var REDUCE_TIME = 1567752802062;
  var version$1 = 7;
  var counter;
  var previousSeconds;
  function build$1(clusterWorkerId) {
    var str = "";
    var seconds = Math.floor((Date.now() - REDUCE_TIME) * 1e-3);
    if (seconds === previousSeconds) {
      counter++;
    } else {
      counter = 0;
      previousSeconds = seconds;
    }
    str = str + generate(version$1);
    str = str + generate(clusterWorkerId);
    if (counter > 0) {
      str = str + generate(counter);
    }
    str = str + generate(seconds);
    return str;
  }
  var build_1 = build$1;
  var alphabet = alphabet_1;
  function isShortId(id2) {
    if (!id2 || typeof id2 !== "string" || id2.length < 6) {
      return false;
    }
    var nonAlphabetic = new RegExp("[^" + alphabet.get().replace(/[|\\{}()[\]^$+*?.-]/g, "\\$&") + "]");
    return !nonAlphabetic.test(id2);
  }
  var isValid$2 = isShortId;
  (function(module2) {
    var alphabet2 = alphabet_1;
    var build2 = build_1;
    var isValid2 = isValid$2;
    var clusterWorkerId = 0;
    function seed2(seedValue) {
      alphabet2.seed(seedValue);
      return module2.exports;
    }
    function worker(workerId) {
      clusterWorkerId = workerId;
      return module2.exports;
    }
    function characters2(newCharacters) {
      if (newCharacters !== void 0) {
        alphabet2.characters(newCharacters);
      }
      return alphabet2.shuffled();
    }
    function generate2() {
      return build2(clusterWorkerId);
    }
    module2.exports = generate2;
    module2.exports.generate = generate2;
    module2.exports.seed = seed2;
    module2.exports.worker = worker;
    module2.exports.characters = characters2;
    module2.exports.isValid = isValid2;
  })(lib$1);
  (function(module2) {
    module2.exports = lib$1.exports;
  })(shortid$1);
  const shortid = /* @__PURE__ */ getDefaultExportFromCjs(shortid$1.exports);
  var __awaiter$3 = globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  class RequestError extends Error {
    constructor(status2, message, requestParams) {
      super(message);
      this.name = "ServiceError";
      this.status = status2;
      this.requestParams = requestParams;
    }
  }
  const isValidResponse = (res) => {
    return res.status >= 100 && res.status < 400;
  };
  function validateResponse(res, fallbackMessage, requestParams) {
    return __awaiter$3(this, void 0, void 0, function* () {
      if (!isValidResponse(res)) {
        let message = fallbackMessage;
        try {
          const json2 = yield res.json();
          message = (json2 === null || json2 === void 0 ? void 0 : json2.message) || (json2 === null || json2 === void 0 ? void 0 : json2.detail) || fallbackMessage;
        } catch (e3) {
          if (fallbackMessage) {
            try {
              message = (yield res.text()) || fallbackMessage;
            } catch (_a3) {
            }
          }
        }
        throw new RequestError(res.status, message, requestParams);
      }
    });
  }
  function listCacheClear$1() {
    this.__data__ = [];
    this.size = 0;
  }
  var _listCacheClear = listCacheClear$1;
  function eq$3(value, other) {
    return value === other || value !== value && other !== other;
  }
  var eq_1 = eq$3;
  var eq$2 = eq_1;
  function assocIndexOf$4(array2, key) {
    var length2 = array2.length;
    while (length2--) {
      if (eq$2(array2[length2][0], key)) {
        return length2;
      }
    }
    return -1;
  }
  var _assocIndexOf = assocIndexOf$4;
  var assocIndexOf$3 = _assocIndexOf;
  var arrayProto = Array.prototype;
  var splice$1 = arrayProto.splice;
  function listCacheDelete$1(key) {
    var data2 = this.__data__, index2 = assocIndexOf$3(data2, key);
    if (index2 < 0) {
      return false;
    }
    var lastIndex = data2.length - 1;
    if (index2 == lastIndex) {
      data2.pop();
    } else {
      splice$1.call(data2, index2, 1);
    }
    --this.size;
    return true;
  }
  var _listCacheDelete = listCacheDelete$1;
  var assocIndexOf$2 = _assocIndexOf;
  function listCacheGet$1(key) {
    var data2 = this.__data__, index2 = assocIndexOf$2(data2, key);
    return index2 < 0 ? void 0 : data2[index2][1];
  }
  var _listCacheGet = listCacheGet$1;
  var assocIndexOf$1 = _assocIndexOf;
  function listCacheHas$1(key) {
    return assocIndexOf$1(this.__data__, key) > -1;
  }
  var _listCacheHas = listCacheHas$1;
  var assocIndexOf = _assocIndexOf;
  function listCacheSet$1(key, value) {
    var data2 = this.__data__, index2 = assocIndexOf(data2, key);
    if (index2 < 0) {
      ++this.size;
      data2.push([key, value]);
    } else {
      data2[index2][1] = value;
    }
    return this;
  }
  var _listCacheSet = listCacheSet$1;
  var listCacheClear = _listCacheClear, listCacheDelete = _listCacheDelete, listCacheGet = _listCacheGet, listCacheHas = _listCacheHas, listCacheSet = _listCacheSet;
  function ListCache$4(entries) {
    var index2 = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache$4.prototype.clear = listCacheClear;
  ListCache$4.prototype["delete"] = listCacheDelete;
  ListCache$4.prototype.get = listCacheGet;
  ListCache$4.prototype.has = listCacheHas;
  ListCache$4.prototype.set = listCacheSet;
  var _ListCache = ListCache$4;
  var ListCache$3 = _ListCache;
  function stackClear$1() {
    this.__data__ = new ListCache$3();
    this.size = 0;
  }
  var _stackClear = stackClear$1;
  function stackDelete$1(key) {
    var data2 = this.__data__, result = data2["delete"](key);
    this.size = data2.size;
    return result;
  }
  var _stackDelete = stackDelete$1;
  function stackGet$1(key) {
    return this.__data__.get(key);
  }
  var _stackGet = stackGet$1;
  function stackHas$1(key) {
    return this.__data__.has(key);
  }
  var _stackHas = stackHas$1;
  var freeGlobal$1 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  var _freeGlobal = freeGlobal$1;
  var freeGlobal = _freeGlobal;
  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root$d = freeGlobal || freeSelf || Function("return this")();
  var _root = root$d;
  var root$c = _root;
  var Symbol$6 = root$c.Symbol;
  var _Symbol = Symbol$6;
  var Symbol$5 = _Symbol;
  var objectProto$e = Object.prototype;
  var hasOwnProperty$d = objectProto$e.hasOwnProperty;
  var nativeObjectToString$1 = objectProto$e.toString;
  var symToStringTag$1 = Symbol$5 ? Symbol$5.toStringTag : void 0;
  function getRawTag$1(value) {
    var isOwn = hasOwnProperty$d.call(value, symToStringTag$1), tag = value[symToStringTag$1];
    try {
      value[symToStringTag$1] = void 0;
      var unmasked = true;
    } catch (e3) {
    }
    var result = nativeObjectToString$1.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$1] = tag;
      } else {
        delete value[symToStringTag$1];
      }
    }
    return result;
  }
  var _getRawTag = getRawTag$1;
  var objectProto$d = Object.prototype;
  var nativeObjectToString = objectProto$d.toString;
  function objectToString$2(value) {
    return nativeObjectToString.call(value);
  }
  var _objectToString = objectToString$2;
  var Symbol$4 = _Symbol, getRawTag = _getRawTag, objectToString$1 = _objectToString;
  var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
  var symToStringTag = Symbol$4 ? Symbol$4.toStringTag : void 0;
  function baseGetTag$5(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString$1(value);
  }
  var _baseGetTag = baseGetTag$5;
  function isObject$a(value) {
    var type = typeof value;
    return value != null && (type == "object" || type == "function");
  }
  var isObject_1 = isObject$a;
  var baseGetTag$4 = _baseGetTag, isObject$9 = isObject_1;
  var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
  function isFunction$2(value) {
    if (!isObject$9(value)) {
      return false;
    }
    var tag = baseGetTag$4(value);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
  }
  var isFunction_1 = isFunction$2;
  var root$b = _root;
  var coreJsData$1 = root$b["__core-js_shared__"];
  var _coreJsData = coreJsData$1;
  var coreJsData = _coreJsData;
  var maskSrcKey = function() {
    var uid2 = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
    return uid2 ? "Symbol(src)_1." + uid2 : "";
  }();
  function isMasked$1(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  var _isMasked = isMasked$1;
  var funcProto$1 = Function.prototype;
  var funcToString$1 = funcProto$1.toString;
  function toSource$2(func) {
    if (func != null) {
      try {
        return funcToString$1.call(func);
      } catch (e3) {
      }
      try {
        return func + "";
      } catch (e3) {
      }
    }
    return "";
  }
  var _toSource = toSource$2;
  var isFunction$1 = isFunction_1, isMasked = _isMasked, isObject$8 = isObject_1, toSource$1 = _toSource;
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  var funcProto = Function.prototype, objectProto$c = Object.prototype;
  var funcToString = funcProto.toString;
  var hasOwnProperty$c = objectProto$c.hasOwnProperty;
  var reIsNative = RegExp(
    "^" + funcToString.call(hasOwnProperty$c).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative$1(value) {
    if (!isObject$8(value) || isMasked(value)) {
      return false;
    }
    var pattern = isFunction$1(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource$1(value));
  }
  var _baseIsNative = baseIsNative$1;
  function getValue$2(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  var _getValue = getValue$2;
  var baseIsNative = _baseIsNative, getValue$1 = _getValue;
  function getNative$7(object2, key) {
    var value = getValue$1(object2, key);
    return baseIsNative(value) ? value : void 0;
  }
  var _getNative = getNative$7;
  var getNative$6 = _getNative, root$a = _root;
  var Map$5 = getNative$6(root$a, "Map");
  var _Map = Map$5;
  var getNative$5 = _getNative;
  var nativeCreate$4 = getNative$5(Object, "create");
  var _nativeCreate = nativeCreate$4;
  var nativeCreate$3 = _nativeCreate;
  function hashClear$1() {
    this.__data__ = nativeCreate$3 ? nativeCreate$3(null) : {};
    this.size = 0;
  }
  var _hashClear = hashClear$1;
  function hashDelete$1(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var _hashDelete = hashDelete$1;
  var nativeCreate$2 = _nativeCreate;
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  var objectProto$b = Object.prototype;
  var hasOwnProperty$b = objectProto$b.hasOwnProperty;
  function hashGet$1(key) {
    var data2 = this.__data__;
    if (nativeCreate$2) {
      var result = data2[key];
      return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$b.call(data2, key) ? data2[key] : void 0;
  }
  var _hashGet = hashGet$1;
  var nativeCreate$1 = _nativeCreate;
  var objectProto$a = Object.prototype;
  var hasOwnProperty$a = objectProto$a.hasOwnProperty;
  function hashHas$1(key) {
    var data2 = this.__data__;
    return nativeCreate$1 ? data2[key] !== void 0 : hasOwnProperty$a.call(data2, key);
  }
  var _hashHas = hashHas$1;
  var nativeCreate = _nativeCreate;
  var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
  function hashSet$1(key, value) {
    var data2 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data2[key] = nativeCreate && value === void 0 ? HASH_UNDEFINED$1 : value;
    return this;
  }
  var _hashSet = hashSet$1;
  var hashClear = _hashClear, hashDelete = _hashDelete, hashGet = _hashGet, hashHas = _hashHas, hashSet = _hashSet;
  function Hash$1(entries) {
    var index2 = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  Hash$1.prototype.clear = hashClear;
  Hash$1.prototype["delete"] = hashDelete;
  Hash$1.prototype.get = hashGet;
  Hash$1.prototype.has = hashHas;
  Hash$1.prototype.set = hashSet;
  var _Hash = Hash$1;
  var Hash = _Hash, ListCache$2 = _ListCache, Map$4 = _Map;
  function mapCacheClear$1() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash(),
      "map": new (Map$4 || ListCache$2)(),
      "string": new Hash()
    };
  }
  var _mapCacheClear = mapCacheClear$1;
  function isKeyable$1(value) {
    var type = typeof value;
    return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
  }
  var _isKeyable = isKeyable$1;
  var isKeyable = _isKeyable;
  function getMapData$4(map2, key) {
    var data2 = map2.__data__;
    return isKeyable(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
  }
  var _getMapData = getMapData$4;
  var getMapData$3 = _getMapData;
  function mapCacheDelete$1(key) {
    var result = getMapData$3(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  var _mapCacheDelete = mapCacheDelete$1;
  var getMapData$2 = _getMapData;
  function mapCacheGet$1(key) {
    return getMapData$2(this, key).get(key);
  }
  var _mapCacheGet = mapCacheGet$1;
  var getMapData$1 = _getMapData;
  function mapCacheHas$1(key) {
    return getMapData$1(this, key).has(key);
  }
  var _mapCacheHas = mapCacheHas$1;
  var getMapData = _getMapData;
  function mapCacheSet$1(key, value) {
    var data2 = getMapData(this, key), size = data2.size;
    data2.set(key, value);
    this.size += data2.size == size ? 0 : 1;
    return this;
  }
  var _mapCacheSet = mapCacheSet$1;
  var mapCacheClear = _mapCacheClear, mapCacheDelete = _mapCacheDelete, mapCacheGet = _mapCacheGet, mapCacheHas = _mapCacheHas, mapCacheSet = _mapCacheSet;
  function MapCache$3(entries) {
    var index2 = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache$3.prototype.clear = mapCacheClear;
  MapCache$3.prototype["delete"] = mapCacheDelete;
  MapCache$3.prototype.get = mapCacheGet;
  MapCache$3.prototype.has = mapCacheHas;
  MapCache$3.prototype.set = mapCacheSet;
  var _MapCache = MapCache$3;
  var ListCache$1 = _ListCache, Map$3 = _Map, MapCache$2 = _MapCache;
  var LARGE_ARRAY_SIZE = 200;
  function stackSet$1(key, value) {
    var data2 = this.__data__;
    if (data2 instanceof ListCache$1) {
      var pairs2 = data2.__data__;
      if (!Map$3 || pairs2.length < LARGE_ARRAY_SIZE - 1) {
        pairs2.push([key, value]);
        this.size = ++data2.size;
        return this;
      }
      data2 = this.__data__ = new MapCache$2(pairs2);
    }
    data2.set(key, value);
    this.size = data2.size;
    return this;
  }
  var _stackSet = stackSet$1;
  var ListCache = _ListCache, stackClear = _stackClear, stackDelete = _stackDelete, stackGet = _stackGet, stackHas = _stackHas, stackSet = _stackSet;
  function Stack$5(entries) {
    var data2 = this.__data__ = new ListCache(entries);
    this.size = data2.size;
  }
  Stack$5.prototype.clear = stackClear;
  Stack$5.prototype["delete"] = stackDelete;
  Stack$5.prototype.get = stackGet;
  Stack$5.prototype.has = stackHas;
  Stack$5.prototype.set = stackSet;
  var _Stack = Stack$5;
  var HASH_UNDEFINED = "__lodash_hash_undefined__";
  function setCacheAdd$1(value) {
    this.__data__.set(value, HASH_UNDEFINED);
    return this;
  }
  var _setCacheAdd = setCacheAdd$1;
  function setCacheHas$1(value) {
    return this.__data__.has(value);
  }
  var _setCacheHas = setCacheHas$1;
  var MapCache$1 = _MapCache, setCacheAdd = _setCacheAdd, setCacheHas = _setCacheHas;
  function SetCache$1(values) {
    var index2 = -1, length2 = values == null ? 0 : values.length;
    this.__data__ = new MapCache$1();
    while (++index2 < length2) {
      this.add(values[index2]);
    }
  }
  SetCache$1.prototype.add = SetCache$1.prototype.push = setCacheAdd;
  SetCache$1.prototype.has = setCacheHas;
  var _SetCache = SetCache$1;
  function arraySome$1(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (predicate(array2[index2], index2, array2)) {
        return true;
      }
    }
    return false;
  }
  var _arraySome = arraySome$1;
  function cacheHas$1(cache2, key) {
    return cache2.has(key);
  }
  var _cacheHas = cacheHas$1;
  var SetCache = _SetCache, arraySome = _arraySome, cacheHas = _cacheHas;
  var COMPARE_PARTIAL_FLAG$3 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function equalArrays$2(array2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, arrLength = array2.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array2);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array2;
    }
    var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$1 ? new SetCache() : void 0;
    stack.set(array2, other);
    stack.set(other, array2);
    while (++index2 < arrLength) {
      var arrValue = array2[index2], othValue = other[index2];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array2);
    stack["delete"](other);
    return result;
  }
  var _equalArrays = equalArrays$2;
  var root$9 = _root;
  var Uint8Array$3 = root$9.Uint8Array;
  var _Uint8Array = Uint8Array$3;
  function mapToArray$1(map2) {
    var index2 = -1, result = Array(map2.size);
    map2.forEach(function(value, key) {
      result[++index2] = [key, value];
    });
    return result;
  }
  var _mapToArray = mapToArray$1;
  function setToArray$1(set2) {
    var index2 = -1, result = Array(set2.size);
    set2.forEach(function(value) {
      result[++index2] = value;
    });
    return result;
  }
  var _setToArray = setToArray$1;
  var Symbol$3 = _Symbol, Uint8Array$2 = _Uint8Array, eq$1 = eq_1, equalArrays$1 = _equalArrays, mapToArray = _mapToArray, setToArray = _setToArray;
  var COMPARE_PARTIAL_FLAG$2 = 1, COMPARE_UNORDERED_FLAG = 2;
  var boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", symbolTag$3 = "[object Symbol]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]";
  var symbolProto$2 = Symbol$3 ? Symbol$3.prototype : void 0, symbolValueOf$1 = symbolProto$2 ? symbolProto$2.valueOf : void 0;
  function equalByTag$1(object2, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag$4:
        if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
          return false;
        }
        object2 = object2.buffer;
        other = other.buffer;
      case arrayBufferTag$3:
        if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object2), new Uint8Array$2(other))) {
          return false;
        }
        return true;
      case boolTag$3:
      case dateTag$3:
      case numberTag$3:
        return eq$1(+object2, +other);
      case errorTag$2:
        return object2.name == other.name && object2.message == other.message;
      case regexpTag$3:
      case stringTag$3:
        return object2 == other + "";
      case mapTag$5:
        var convert2 = mapToArray;
      case setTag$5:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$2;
        convert2 || (convert2 = setToArray);
        if (object2.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object2);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG;
        stack.set(object2, other);
        var result = equalArrays$1(convert2(object2), convert2(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object2);
        return result;
      case symbolTag$3:
        if (symbolValueOf$1) {
          return symbolValueOf$1.call(object2) == symbolValueOf$1.call(other);
        }
    }
    return false;
  }
  var _equalByTag = equalByTag$1;
  function arrayPush$2(array2, values) {
    var index2 = -1, length2 = values.length, offset2 = array2.length;
    while (++index2 < length2) {
      array2[offset2 + index2] = values[index2];
    }
    return array2;
  }
  var _arrayPush = arrayPush$2;
  var isArray$e = Array.isArray;
  var isArray_1 = isArray$e;
  var arrayPush$1 = _arrayPush, isArray$d = isArray_1;
  function baseGetAllKeys$2(object2, keysFunc, symbolsFunc) {
    var result = keysFunc(object2);
    return isArray$d(object2) ? result : arrayPush$1(result, symbolsFunc(object2));
  }
  var _baseGetAllKeys = baseGetAllKeys$2;
  function arrayFilter$1(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
    while (++index2 < length2) {
      var value = array2[index2];
      if (predicate(value, index2, array2)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }
  var _arrayFilter = arrayFilter$1;
  function stubArray$2() {
    return [];
  }
  var stubArray_1 = stubArray$2;
  var arrayFilter = _arrayFilter, stubArray$1 = stubArray_1;
  var objectProto$9 = Object.prototype;
  var propertyIsEnumerable$1 = objectProto$9.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols$3 = !nativeGetSymbols$1 ? stubArray$1 : function(object2) {
    if (object2 == null) {
      return [];
    }
    object2 = Object(object2);
    return arrayFilter(nativeGetSymbols$1(object2), function(symbol) {
      return propertyIsEnumerable$1.call(object2, symbol);
    });
  };
  var _getSymbols = getSymbols$3;
  function baseTimes$1(n2, iteratee) {
    var index2 = -1, result = Array(n2);
    while (++index2 < n2) {
      result[index2] = iteratee(index2);
    }
    return result;
  }
  var _baseTimes = baseTimes$1;
  function isObjectLike$7(value) {
    return value != null && typeof value == "object";
  }
  var isObjectLike_1 = isObjectLike$7;
  var baseGetTag$3 = _baseGetTag, isObjectLike$6 = isObjectLike_1;
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments$1(value) {
    return isObjectLike$6(value) && baseGetTag$3(value) == argsTag$3;
  }
  var _baseIsArguments = baseIsArguments$1;
  var baseIsArguments = _baseIsArguments, isObjectLike$5 = isObjectLike_1;
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$9 = objectProto$8.hasOwnProperty;
  var propertyIsEnumerable = objectProto$8.propertyIsEnumerable;
  var isArguments$1 = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value) {
    return isObjectLike$5(value) && hasOwnProperty$9.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
  };
  var isArguments_1 = isArguments$1;
  var isBuffer$5 = { exports: {} };
  function stubFalse() {
    return false;
  }
  var stubFalse_1 = stubFalse;
  (function(module2, exports3) {
    var root2 = _root, stubFalse2 = stubFalse_1;
    var freeExports = exports3 && !exports3.nodeType && exports3;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root2.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer2 = nativeIsBuffer || stubFalse2;
    module2.exports = isBuffer2;
  })(isBuffer$5, isBuffer$5.exports);
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function isIndex$2(value, length2) {
    var type = typeof value;
    length2 = length2 == null ? MAX_SAFE_INTEGER$1 : length2;
    return !!length2 && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
  }
  var _isIndex = isIndex$2;
  var MAX_SAFE_INTEGER = 9007199254740991;
  function isLength$2(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  var isLength_1 = isLength$2;
  var baseGetTag$2 = _baseGetTag, isLength$1 = isLength_1, isObjectLike$4 = isObjectLike_1;
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", errorTag$1 = "[object Error]", funcTag$1 = "[object Function]", mapTag$4 = "[object Map]", numberTag$2 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$2 = "[object RegExp]", setTag$4 = "[object Set]", stringTag$2 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$3 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$2] = typedArrayTags[boolTag$2] = typedArrayTags[dataViewTag$3] = typedArrayTags[dateTag$2] = typedArrayTags[errorTag$1] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$4] = typedArrayTags[numberTag$2] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$2] = typedArrayTags[setTag$4] = typedArrayTags[stringTag$2] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray$1(value) {
    return isObjectLike$4(value) && isLength$1(value.length) && !!typedArrayTags[baseGetTag$2(value)];
  }
  var _baseIsTypedArray = baseIsTypedArray$1;
  function baseUnary$3(func) {
    return function(value) {
      return func(value);
    };
  }
  var _baseUnary = baseUnary$3;
  var _nodeUtil = { exports: {} };
  (function(module2, exports3) {
    var freeGlobal2 = _freeGlobal;
    var freeExports = exports3 && !exports3.nodeType && exports3;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal2.process;
    var nodeUtil2 = function() {
      try {
        var types2 = freeModule && freeModule.require && freeModule.require("util").types;
        if (types2) {
          return types2;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e3) {
      }
    }();
    module2.exports = nodeUtil2;
  })(_nodeUtil, _nodeUtil.exports);
  var baseIsTypedArray = _baseIsTypedArray, baseUnary$2 = _baseUnary, nodeUtil$2 = _nodeUtil.exports;
  var nodeIsTypedArray = nodeUtil$2 && nodeUtil$2.isTypedArray;
  var isTypedArray$2 = nodeIsTypedArray ? baseUnary$2(nodeIsTypedArray) : baseIsTypedArray;
  var isTypedArray_1 = isTypedArray$2;
  var baseTimes = _baseTimes, isArguments = isArguments_1, isArray$c = isArray_1, isBuffer$4 = isBuffer$5.exports, isIndex$1 = _isIndex, isTypedArray$1 = isTypedArray_1;
  var objectProto$7 = Object.prototype;
  var hasOwnProperty$8 = objectProto$7.hasOwnProperty;
  function arrayLikeKeys$2(value, inherited) {
    var isArr = isArray$c(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer$4(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType2, result = skipIndexes ? baseTimes(value.length, String) : [], length2 = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty$8.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex$1(key, length2)))) {
        result.push(key);
      }
    }
    return result;
  }
  var _arrayLikeKeys = arrayLikeKeys$2;
  var objectProto$6 = Object.prototype;
  function isPrototype$3(value) {
    var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto$6;
    return value === proto2;
  }
  var _isPrototype = isPrototype$3;
  function overArg$2(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var _overArg = overArg$2;
  var overArg$1 = _overArg;
  var nativeKeys$1 = overArg$1(Object.keys, Object);
  var _nativeKeys = nativeKeys$1;
  var isPrototype$2 = _isPrototype, nativeKeys = _nativeKeys;
  var objectProto$5 = Object.prototype;
  var hasOwnProperty$7 = objectProto$5.hasOwnProperty;
  function baseKeys$1(object2) {
    if (!isPrototype$2(object2)) {
      return nativeKeys(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$7.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  var _baseKeys = baseKeys$1;
  var isFunction = isFunction_1, isLength = isLength_1;
  function isArrayLike$2(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  var isArrayLike_1 = isArrayLike$2;
  var arrayLikeKeys$1 = _arrayLikeKeys, baseKeys = _baseKeys, isArrayLike$1 = isArrayLike_1;
  function keys$4(object2) {
    return isArrayLike$1(object2) ? arrayLikeKeys$1(object2) : baseKeys(object2);
  }
  var keys_1 = keys$4;
  var baseGetAllKeys$1 = _baseGetAllKeys, getSymbols$2 = _getSymbols, keys$3 = keys_1;
  function getAllKeys$2(object2) {
    return baseGetAllKeys$1(object2, keys$3, getSymbols$2);
  }
  var _getAllKeys = getAllKeys$2;
  var getAllKeys$1 = _getAllKeys;
  var COMPARE_PARTIAL_FLAG$1 = 1;
  var objectProto$4 = Object.prototype;
  var hasOwnProperty$6 = objectProto$4.hasOwnProperty;
  function equalObjects$1(object2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$1, objProps = getAllKeys$1(object2), objLength = objProps.length, othProps = getAllKeys$1(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index2 = objLength;
    while (index2--) {
      var key = objProps[index2];
      if (!(isPartial ? key in other : hasOwnProperty$6.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object2);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object2;
    }
    var result = true;
    stack.set(object2, other);
    stack.set(other, object2);
    var skipCtor = isPartial;
    while (++index2 < objLength) {
      key = objProps[index2];
      var objValue = object2[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object2.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object2);
    stack["delete"](other);
    return result;
  }
  var _equalObjects = equalObjects$1;
  var getNative$4 = _getNative, root$8 = _root;
  var DataView$2 = getNative$4(root$8, "DataView");
  var _DataView = DataView$2;
  var getNative$3 = _getNative, root$7 = _root;
  var Promise$3 = getNative$3(root$7, "Promise");
  var _Promise = Promise$3;
  var getNative$2 = _getNative, root$6 = _root;
  var Set$3 = getNative$2(root$6, "Set");
  var _Set = Set$3;
  var getNative$1 = _getNative, root$5 = _root;
  var WeakMap$2 = getNative$1(root$5, "WeakMap");
  var _WeakMap = WeakMap$2;
  var DataView$1 = _DataView, Map$2 = _Map, Promise$2 = _Promise, Set$2 = _Set, WeakMap$1 = _WeakMap, baseGetTag$1 = _baseGetTag, toSource = _toSource;
  var mapTag$3 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$3 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$2 = "[object DataView]";
  var dataViewCtorString = toSource(DataView$1), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$1);
  var getTag$4 = baseGetTag$1;
  if (DataView$1 && getTag$4(new DataView$1(new ArrayBuffer(1))) != dataViewTag$2 || Map$2 && getTag$4(new Map$2()) != mapTag$3 || Promise$2 && getTag$4(Promise$2.resolve()) != promiseTag || Set$2 && getTag$4(new Set$2()) != setTag$3 || WeakMap$1 && getTag$4(new WeakMap$1()) != weakMapTag$1) {
    getTag$4 = function(value) {
      var result = baseGetTag$1(value), Ctor = result == objectTag$2 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$2;
          case mapCtorString:
            return mapTag$3;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$3;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  var _getTag = getTag$4;
  var Stack$4 = _Stack, equalArrays = _equalArrays, equalByTag = _equalByTag, equalObjects = _equalObjects, getTag$3 = _getTag, isArray$b = isArray_1, isBuffer$3 = isBuffer$5.exports, isTypedArray = isTypedArray_1;
  var COMPARE_PARTIAL_FLAG = 1;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", objectTag$1 = "[object Object]";
  var objectProto$3 = Object.prototype;
  var hasOwnProperty$5 = objectProto$3.hasOwnProperty;
  function baseIsEqualDeep$1(object2, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$b(object2), othIsArr = isArray$b(other), objTag = objIsArr ? arrayTag$1 : getTag$3(object2), othTag = othIsArr ? arrayTag$1 : getTag$3(other);
    objTag = objTag == argsTag$1 ? objectTag$1 : objTag;
    othTag = othTag == argsTag$1 ? objectTag$1 : othTag;
    var objIsObj = objTag == objectTag$1, othIsObj = othTag == objectTag$1, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$3(object2)) {
      if (!isBuffer$3(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack$4());
      return objIsArr || isTypedArray(object2) ? equalArrays(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag(object2, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
      var objIsWrapped = objIsObj && hasOwnProperty$5.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$5.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack$4());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack$4());
    return equalObjects(object2, other, bitmask, customizer, equalFunc, stack);
  }
  var _baseIsEqualDeep = baseIsEqualDeep$1;
  var baseIsEqualDeep = _baseIsEqualDeep, isObjectLike$3 = isObjectLike_1;
  function baseIsEqual$1(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike$3(value) && !isObjectLike$3(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual$1, stack);
  }
  var _baseIsEqual = baseIsEqual$1;
  var baseIsEqual = _baseIsEqual;
  function isEqual$4(value, other) {
    return baseIsEqual(value, other);
  }
  var isEqual_1 = isEqual$4;
  function useDeepCompare(value) {
    const ref = React.useRef();
    if (!isEqual_1(value, ref.current)) {
      ref.current = value;
    }
    return ref.current;
  }
  function useDimensions(liveMeasure = true) {
    const [dimensions2, setDimensions] = React.useState({});
    const [node2, setNode2] = React.useState(null);
    const ref = React.useCallback((_node) => {
      setNode2(_node);
    }, []);
    React.useLayoutEffect(() => {
      if (node2) {
        const measure = () => window.requestAnimationFrame(() => setDimensions(node2.getBoundingClientRect()));
        measure();
        if (liveMeasure) {
          window.addEventListener("resize", measure);
          window.addEventListener("scroll", measure);
          return () => {
            window.removeEventListener("resize", measure);
            window.removeEventListener("scroll", measure);
          };
        }
      }
    }, [node2]);
    return [ref, dimensions2, node2];
  }
  var root$4 = _root;
  var now$3 = function() {
    return root$4.Date.now();
  };
  var now_1 = now$3;
  var reWhitespace = /\s/;
  function trimmedEndIndex$1(string2) {
    var index2 = string2.length;
    while (index2-- && reWhitespace.test(string2.charAt(index2))) {
    }
    return index2;
  }
  var _trimmedEndIndex = trimmedEndIndex$1;
  var trimmedEndIndex = _trimmedEndIndex;
  var reTrimStart = /^\s+/;
  function baseTrim$1(string2) {
    return string2 ? string2.slice(0, trimmedEndIndex(string2) + 1).replace(reTrimStart, "") : string2;
  }
  var _baseTrim = baseTrim$1;
  var baseGetTag = _baseGetTag, isObjectLike$2 = isObjectLike_1;
  var symbolTag$2 = "[object Symbol]";
  function isSymbol$6(value) {
    return typeof value == "symbol" || isObjectLike$2(value) && baseGetTag(value) == symbolTag$2;
  }
  var isSymbol_1 = isSymbol$6;
  var baseTrim = _baseTrim, isObject$7 = isObject_1, isSymbol$5 = isSymbol_1;
  var NAN = 0 / 0;
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary = /^0b[01]+$/i;
  var reIsOctal = /^0o[0-7]+$/i;
  var freeParseInt = parseInt;
  function toNumber$4(value) {
    if (typeof value == "number") {
      return value;
    }
    if (isSymbol$5(value)) {
      return NAN;
    }
    if (isObject$7(value)) {
      var other = typeof value.valueOf == "function" ? value.valueOf() : value;
      value = isObject$7(other) ? other + "" : other;
    }
    if (typeof value != "string") {
      return value === 0 ? value : +value;
    }
    value = baseTrim(value);
    var isBinary = reIsBinary.test(value);
    return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
  }
  var toNumber_1 = toNumber$4;
  var isObject$6 = isObject_1, now$2 = now_1, toNumber$3 = toNumber_1;
  var FUNC_ERROR_TEXT$2 = "Expected a function";
  var nativeMax = Math.max, nativeMin$1 = Math.min;
  function debounce$7(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$2);
    }
    wait = toNumber$3(wait) || 0;
    if (isObject$6(options)) {
      leading = !!options.leading;
      maxing = "maxWait" in options;
      maxWait = maxing ? nativeMax(toNumber$3(options.maxWait) || 0, wait) : maxWait;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
      var args = lastArgs, thisArg = lastThis;
      lastArgs = lastThis = void 0;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }
    function leadingEdge(time) {
      lastInvokeTime = time;
      timerId = setTimeout(timerExpired, wait);
      return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
      return maxing ? nativeMin$1(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
      return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
      var time = now$2();
      if (shouldInvoke(time)) {
        return trailingEdge(time);
      }
      timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
      timerId = void 0;
      if (trailing && lastArgs) {
        return invokeFunc(time);
      }
      lastArgs = lastThis = void 0;
      return result;
    }
    function cancel() {
      if (timerId !== void 0) {
        clearTimeout(timerId);
      }
      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = void 0;
    }
    function flush() {
      return timerId === void 0 ? result : trailingEdge(now$2());
    }
    function debounced() {
      var time = now$2(), isInvoking = shouldInvoke(time);
      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;
      if (isInvoking) {
        if (timerId === void 0) {
          return leadingEdge(lastCallTime);
        }
        if (maxing) {
          clearTimeout(timerId);
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }
      if (timerId === void 0) {
        timerId = setTimeout(timerExpired, wait);
      }
      return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }
  var debounce_1 = debounce$7;
  var debounce$6 = debounce_1, isObject$5 = isObject_1;
  var FUNC_ERROR_TEXT$1 = "Expected a function";
  function throttle(func, wait, options) {
    var leading = true, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$1);
    }
    if (isObject$5(options)) {
      leading = "leading" in options ? !!options.leading : leading;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    return debounce$6(func, wait, {
      "leading": leading,
      "maxWait": wait,
      "trailing": trailing
    });
  }
  var throttle_1 = throttle;
  function useThrottle(cb, delay, options) {
    const cbRef = React.useRef(cb);
    React.useEffect(() => {
      cbRef.current = cb;
    });
    return React.useCallback(throttle_1((...args) => cbRef.current(...args), delay, options), [delay]);
  }
  function useThrottledState(initialValue, delay, options = { leading: false, trailing: true }) {
    const [value, setValue] = React.useState(initialValue);
    const throttledSetValue = useThrottle(setValue, delay, options);
    return [value, throttledSetValue, setValue];
  }
  var e10$1 = Math.sqrt(50), e5$1 = Math.sqrt(10), e2$1 = Math.sqrt(2);
  function ticks$1(start2, stop, count2) {
    var reverse2, i2 = -1, n2, ticks2, step2;
    stop = +stop, start2 = +start2, count2 = +count2;
    if (start2 === stop && count2 > 0)
      return [start2];
    if (reverse2 = stop < start2)
      n2 = start2, start2 = stop, stop = n2;
    if ((step2 = tickIncrement$1(start2, stop, count2)) === 0 || !isFinite(step2))
      return [];
    if (step2 > 0) {
      let r0 = Math.round(start2 / step2), r1 = Math.round(stop / step2);
      if (r0 * step2 < start2)
        ++r0;
      if (r1 * step2 > stop)
        --r1;
      ticks2 = new Array(n2 = r1 - r0 + 1);
      while (++i2 < n2)
        ticks2[i2] = (r0 + i2) * step2;
    } else {
      step2 = -step2;
      let r0 = Math.round(start2 * step2), r1 = Math.round(stop * step2);
      if (r0 / step2 < start2)
        ++r0;
      if (r1 / step2 > stop)
        --r1;
      ticks2 = new Array(n2 = r1 - r0 + 1);
      while (++i2 < n2)
        ticks2[i2] = (r0 + i2) / step2;
    }
    if (reverse2)
      ticks2.reverse();
    return ticks2;
  }
  function tickIncrement$1(start2, stop, count2) {
    var step2 = (stop - start2) / Math.max(0, count2), power = Math.floor(Math.log(step2) / Math.LN10), error2 = step2 / Math.pow(10, power);
    return power >= 0 ? (error2 >= e10$1 ? 10 : error2 >= e5$1 ? 5 : error2 >= e2$1 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error2 >= e10$1 ? 10 : error2 >= e5$1 ? 5 : error2 >= e2$1 ? 2 : 1);
  }
  function initRange(domain2, range2) {
    switch (arguments.length) {
      case 0:
        break;
      case 1:
        this.range(domain2);
        break;
      default:
        this.range(range2).domain(domain2);
        break;
    }
    return this;
  }
  const implicit = Symbol("implicit");
  function ordinal() {
    var index2 = /* @__PURE__ */ new Map(), domain2 = [], range2 = [], unknown2 = implicit;
    function scale(d2) {
      var key = d2 + "", i2 = index2.get(key);
      if (!i2) {
        if (unknown2 !== implicit)
          return unknown2;
        index2.set(key, i2 = domain2.push(d2));
      }
      return range2[(i2 - 1) % range2.length];
    }
    scale.domain = function(_2) {
      if (!arguments.length)
        return domain2.slice();
      domain2 = [], index2 = /* @__PURE__ */ new Map();
      for (const value of _2) {
        const key = value + "";
        if (index2.has(key))
          continue;
        index2.set(key, domain2.push(value));
      }
      return scale;
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), scale) : range2.slice();
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown2 = _2, scale) : unknown2;
    };
    scale.copy = function() {
      return ordinal(domain2, range2).unknown(unknown2);
    };
    initRange.apply(scale, arguments);
    return scale;
  }
  function useIntersectionObserver(ref, rootMargin = "0px", threshold = 1) {
    const [isIntersecting, setIntersecting] = React.useState(false);
    React.useEffect(() => {
      const observer = new IntersectionObserver(([entry]) => setIntersecting(entry.isIntersecting), {
        rootMargin,
        threshold
      });
      if (ref.current) {
        observer.observe(ref.current);
      }
      return () => {
        if (ref.current)
          observer.unobserve(ref.current);
        else
          observer.disconnect();
      };
    }, []);
    return isIntersecting;
  }
  function useOnClickOutside(element2, handler) {
    React.useEffect(() => {
      const listener2 = (event2) => {
        if (!element2 || element2.contains(event2.target)) {
          return;
        }
        handler();
      };
      document.addEventListener("mousedown", listener2);
      document.addEventListener("touchstart", listener2);
      return () => {
        document.removeEventListener("mousedown", listener2);
        document.removeEventListener("touchstart", listener2);
      };
    }, [element2, handler]);
  }
  const useUpdateEffect = (effect2, deps) => {
    const isMounted = React.useRef(false);
    React.useEffect(() => {
      if (!isMounted.current) {
        isMounted.current = true;
        return;
      }
      return effect2();
    }, deps);
  };
  var __awaiter$2 = globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  function useInfiniteLoader(onLoadData, onError, batchSize = 50) {
    const onLoadRef = React.useRef(onLoadData);
    const [internalData, setInternalData] = React.useState([]);
    const [itemCount, setItemCount] = React.useState(0);
    const [currentStartIdx, setStartIdx] = React.useState(0);
    const [currentStopIdx, setStopIdx] = React.useState(0);
    const [currentRange, setCurrentRange] = React.useState({
      overscanStartIndex: 0,
      overscanStopIndex: 50
    });
    const getItem = React.useCallback((index2) => {
      const adjustedIndex = index2 - currentStartIdx;
      if (adjustedIndex < 0 || adjustedIndex > internalData.length) {
        return;
      }
      return internalData[adjustedIndex];
    }, useDeepCompare([currentStartIdx, internalData]));
    const onItemsRendered = React.useCallback(({ overscanStartIndex, overscanStopIndex }, forceRefresh) => __awaiter$2(this, void 0, void 0, function* () {
      try {
        const isFirstItemLoaded = overscanStartIndex >= currentStartIdx && overscanStartIndex <= currentStopIdx;
        const isLastItemLoaded = overscanStopIndex >= currentStartIdx && overscanStopIndex <= currentStopIdx;
        setCurrentRange({ overscanStartIndex, overscanStopIndex });
        if (isFirstItemLoaded && isLastItemLoaded && !forceRefresh) {
          return;
        }
        if (isFirstItemLoaded === isLastItemLoaded) {
          const mid = Math.floor((overscanStopIndex - overscanStartIndex) / 2 + overscanStartIndex);
          const start2 = Math.max(mid - batchSize / 2, 0);
          const end3 = mid + batchSize / 2;
          setStartIdx(start2);
          setStopIdx(end3);
          const { data: data3, totalCount: totalCount2 } = yield onLoadRef.current(start2, end3);
          setInternalData(data3);
          setItemCount(totalCount2);
          return;
        }
        if (!isFirstItemLoaded) {
          const start2 = Math.max(currentStartIdx - batchSize, 0);
          const res2 = onLoadRef.current(start2, currentStartIdx);
          setStartIdx(start2);
          const { data: data3, totalCount: totalCount2 } = yield res2;
          setInternalData((current) => [...data3, ...current]);
          setItemCount(totalCount2);
          return;
        }
        const end2 = currentStopIdx + batchSize;
        const res = onLoadRef.current(currentStopIdx, end2);
        setStopIdx(end2);
        const { data: data2, totalCount } = yield res;
        setInternalData((current) => [...current, ...data2]);
        setItemCount(totalCount);
      } catch (err) {
        onError === null || onError === void 0 ? void 0 : onError(err);
      }
    }), [currentStartIdx, currentStopIdx]);
    React.useEffect(() => {
      onLoadRef.current = onLoadData;
      onItemsRendered(currentRange, true);
    }, [onLoadData]);
    const refresh = React.useCallback(() => {
      onItemsRendered(currentRange, true);
    }, useDeepCompare([currentRange]));
    return {
      getItem,
      itemCount,
      onItemsRendered,
      refresh
    };
  }
  const AccordionItemWrapper = styled__default.default.div`
    width: 100%;
    background-color: ${(props) => {
    var _a3;
    return (_a3 = props.backgroundColor) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.blue1;
  }};
    border: 1px solid ${(props) => props.theme.colors.grey1};
    border-radius: 0.25rem;

    /* Define the animation used for collapsing */
    .ReactCollapse--collapse {
        transition: height 0.35s ease;
    }
`;
  const AccordionLabel = styled__default.default.dt`
    cursor: pointer;

    display: flex;
    align-items: center;
    justify-content: space-between;

    width: 100%;
    padding: 0.5rem 1rem;

    font-size: 1.2em;
    font-weight: 400;
    color: ${(props) => props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.grey1};
    border: none;
    border-radius: ${(props) => props.isOpen ? "0.25rem 0.25rem 0rem 0rem" : "0.25rem"};

    &:hover {
        background-color: ${(props) => props.theme.colors.grey2};
    }

    &:active {
        background-color: ${(props) => props.theme.colors.grey3};
    }
`;
  const ContentWrapper = styled__default.default.dd`
    overflow: hidden;

    width: 100%;
    height: 100%;
    /*
    We have to use padding for the gap between items rather than margin
    because margin doesn't work well with react-collapse and causes jumping
    See: https://github.com/nkbt/react-collapse#behaviour-notes
    */
    margin: 0;
    padding: 1rem;
`;
  const AccordionContent = styled__default.default.div`
    display: flex;

    height: auto;

    font-size: 1em;
    font-weight: 300;
    color: ${(props) => props.theme.colors.text};
`;
  function AccordionItem({ backgroundColor, headerRenderer: headerRenderer2, innerRenderer, item, onClick, open }) {
    return jsxRuntime.exports.jsxs(AccordionItemWrapper, { backgroundColor, children: [jsxRuntime.exports.jsxs(AccordionLabel, { isOpen: open, onClick, children: [headerRenderer2 ? headerRenderer2(item) : item.label, jsxRuntime.exports.jsx(Chevron$2, { isOpen: open })] }), jsxRuntime.exports.jsx(lib$2.Collapse, { isOpened: open, children: jsxRuntime.exports.jsx(ContentWrapper, { children: jsxRuntime.exports.jsx(AccordionContent, { children: innerRenderer ? innerRenderer(item) : item.content }) }) })] }, item.label);
  }
  const AccordionWrapper = styled__default.default.dl`
    overflow: auto;
    display: flex;
    flex-direction: column;
    gap: 2px;
    align-items: center;

    width: 100%;
    height: 100%;
`;
  function getInitialOpen(initialItems, value, itemsArray) {
    if (value !== void 0) {
      const initialOpen = Array.isArray(value) ? value : [value];
      return itemsArray.map((item, index2) => {
        return initialOpen.includes(index2);
      });
    }
    if (initialItems !== void 0) {
      const initialOpen = Array.isArray(initialItems) ? initialItems : [initialItems];
      return itemsArray.map((item, index2) => {
        return initialOpen.includes(index2);
      });
    }
    return new Array(itemsArray.length).fill(false);
  }
  function Accordion$1({ backgroundColor, className, initialOpenItems, headerRenderer: headerRenderer2, innerRenderer, items, style: style2, multi = true, onChange: onChange2, value }) {
    const [openItems, setOpenItems] = React.useState(getInitialOpen(initialOpenItems, value, items));
    const onClick = React.useCallback((index2) => {
      let newOpenItems = openItems;
      if (!multi) {
        newOpenItems = openItems.map((item, idx) => {
          if (idx === index2) {
            return !item;
          }
          return false;
        });
      } else {
        newOpenItems[index2] = !openItems[index2];
      }
      const chosenItems = newOpenItems.reduce((acc, curr, idx) => {
        if (curr) {
          acc.push(idx);
        }
        return acc;
      }, []);
      onChange2 === null || onChange2 === void 0 ? void 0 : onChange2([...chosenItems]);
      if (value === void 0) {
        setOpenItems([...newOpenItems]);
      }
    }, [openItems, setOpenItems]);
    React.useEffect(() => {
      setOpenItems(getInitialOpen(initialOpenItems, value, items));
    }, [value]);
    return jsxRuntime.exports.jsx(AccordionWrapper, { className, style: style2, children: items.map((item, index2) => jsxRuntime.exports.jsx(AccordionItem, { backgroundColor, headerRenderer: headerRenderer2, innerRenderer, item, onClick: () => onClick(index2), open: openItems[index2] }, `accordion-item-${index2}`)) });
  }
  const shouldForwardProp$2 = (prop) => !["color", "width"].includes(prop);
  const Badge = styled__default.default.span.withConfig({ shouldForwardProp: shouldForwardProp$2 })`
    display: inline-flex;
    align-items: center;
    justify-content: center;

    width: ${(props) => props.width || "auto"};
    height: ${(props) => props.height ? `${props.height}px` : "2rem"};
    padding: 0 0.75rem;

    font-size: 0.875rem;
    font-weight: 400;
    color: ${(props) => props.outline ? props.color : props.theme.colors.blue1};

    background-color: ${(props) => props.outline ? props.theme.colors.blue1 : props.color};
    border: 1px solid ${(props) => props.color};
    border-radius: ${(props) => props.height ? `${props.height / 2}px` : "1rem"};
`;
  function _extends$2() {
    _extends$2 = Object.assign ? Object.assign.bind() : function(target) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        var source = arguments[i2];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends$2.apply(this, arguments);
  }
  function _assertThisInitialized$2(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  function _setPrototypeOf$2(o2, p2) {
    _setPrototypeOf$2 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$2(o2, p2);
  }
  function _inheritsLoose$1(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf$2(subClass, superClass);
  }
  function _getPrototypeOf$1(o2) {
    _getPrototypeOf$1 = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf2(o3) {
      return o3.__proto__ || Object.getPrototypeOf(o3);
    };
    return _getPrototypeOf$1(o2);
  }
  function _isNativeFunction(fn2) {
    return Function.toString.call(fn2).indexOf("[native code]") !== -1;
  }
  function _isNativeReflectConstruct$1() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e3) {
      return false;
    }
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct$1()) {
      _construct = Reflect.construct.bind();
    } else {
      _construct = function _construct2(Parent2, args2, Class2) {
        var a2 = [null];
        a2.push.apply(a2, args2);
        var Constructor = Function.bind.apply(Parent2, a2);
        var instance2 = new Constructor();
        if (Class2)
          _setPrototypeOf$2(instance2, Class2.prototype);
        return instance2;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? /* @__PURE__ */ new Map() : void 0;
    _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
      if (Class2 === null || !_isNativeFunction(Class2))
        return Class2;
      if (typeof Class2 !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }
      if (typeof _cache !== "undefined") {
        if (_cache.has(Class2))
          return _cache.get(Class2);
        _cache.set(Class2, Wrapper2);
      }
      function Wrapper2() {
        return _construct(Class2, arguments, _getPrototypeOf$1(this).constructor);
      }
      Wrapper2.prototype = Object.create(Class2.prototype, {
        constructor: {
          value: Wrapper2,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return _setPrototypeOf$2(Wrapper2, Class2);
    };
    return _wrapNativeSuper(Class);
  }
  var PolishedError$1 = /* @__PURE__ */ function(_Error) {
    _inheritsLoose$1(PolishedError2, _Error);
    function PolishedError2(code2) {
      var _this;
      {
        _this = _Error.call(this, "An error occurred. See https://github.com/styled-components/polished/blob/master/src/internalHelpers/errors.md#" + code2 + " for more information.") || this;
      }
      return _assertThisInitialized$2(_this);
    }
    return PolishedError2;
  }(/* @__PURE__ */ _wrapNativeSuper(Error));
  function colorToInt$1(color2) {
    return Math.round(color2 * 255);
  }
  function convertToInt$1(red, green, blue) {
    return colorToInt$1(red) + "," + colorToInt$1(green) + "," + colorToInt$1(blue);
  }
  function hslToRgb$1(hue, saturation, lightness, convert2) {
    if (convert2 === void 0) {
      convert2 = convertToInt$1;
    }
    if (saturation === 0) {
      return convert2(lightness, lightness, lightness);
    }
    var huePrime = (hue % 360 + 360) % 360 / 60;
    var chroma = (1 - Math.abs(2 * lightness - 1)) * saturation;
    var secondComponent = chroma * (1 - Math.abs(huePrime % 2 - 1));
    var red = 0;
    var green = 0;
    var blue = 0;
    if (huePrime >= 0 && huePrime < 1) {
      red = chroma;
      green = secondComponent;
    } else if (huePrime >= 1 && huePrime < 2) {
      red = secondComponent;
      green = chroma;
    } else if (huePrime >= 2 && huePrime < 3) {
      green = chroma;
      blue = secondComponent;
    } else if (huePrime >= 3 && huePrime < 4) {
      green = secondComponent;
      blue = chroma;
    } else if (huePrime >= 4 && huePrime < 5) {
      red = secondComponent;
      blue = chroma;
    } else if (huePrime >= 5 && huePrime < 6) {
      red = chroma;
      blue = secondComponent;
    }
    var lightnessModification = lightness - chroma / 2;
    var finalRed = red + lightnessModification;
    var finalGreen = green + lightnessModification;
    var finalBlue = blue + lightnessModification;
    return convert2(finalRed, finalGreen, finalBlue);
  }
  var namedColorMap$1 = {
    aliceblue: "f0f8ff",
    antiquewhite: "faebd7",
    aqua: "00ffff",
    aquamarine: "7fffd4",
    azure: "f0ffff",
    beige: "f5f5dc",
    bisque: "ffe4c4",
    black: "000",
    blanchedalmond: "ffebcd",
    blue: "0000ff",
    blueviolet: "8a2be2",
    brown: "a52a2a",
    burlywood: "deb887",
    cadetblue: "5f9ea0",
    chartreuse: "7fff00",
    chocolate: "d2691e",
    coral: "ff7f50",
    cornflowerblue: "6495ed",
    cornsilk: "fff8dc",
    crimson: "dc143c",
    cyan: "00ffff",
    darkblue: "00008b",
    darkcyan: "008b8b",
    darkgoldenrod: "b8860b",
    darkgray: "a9a9a9",
    darkgreen: "006400",
    darkgrey: "a9a9a9",
    darkkhaki: "bdb76b",
    darkmagenta: "8b008b",
    darkolivegreen: "556b2f",
    darkorange: "ff8c00",
    darkorchid: "9932cc",
    darkred: "8b0000",
    darksalmon: "e9967a",
    darkseagreen: "8fbc8f",
    darkslateblue: "483d8b",
    darkslategray: "2f4f4f",
    darkslategrey: "2f4f4f",
    darkturquoise: "00ced1",
    darkviolet: "9400d3",
    deeppink: "ff1493",
    deepskyblue: "00bfff",
    dimgray: "696969",
    dimgrey: "696969",
    dodgerblue: "1e90ff",
    firebrick: "b22222",
    floralwhite: "fffaf0",
    forestgreen: "228b22",
    fuchsia: "ff00ff",
    gainsboro: "dcdcdc",
    ghostwhite: "f8f8ff",
    gold: "ffd700",
    goldenrod: "daa520",
    gray: "808080",
    green: "008000",
    greenyellow: "adff2f",
    grey: "808080",
    honeydew: "f0fff0",
    hotpink: "ff69b4",
    indianred: "cd5c5c",
    indigo: "4b0082",
    ivory: "fffff0",
    khaki: "f0e68c",
    lavender: "e6e6fa",
    lavenderblush: "fff0f5",
    lawngreen: "7cfc00",
    lemonchiffon: "fffacd",
    lightblue: "add8e6",
    lightcoral: "f08080",
    lightcyan: "e0ffff",
    lightgoldenrodyellow: "fafad2",
    lightgray: "d3d3d3",
    lightgreen: "90ee90",
    lightgrey: "d3d3d3",
    lightpink: "ffb6c1",
    lightsalmon: "ffa07a",
    lightseagreen: "20b2aa",
    lightskyblue: "87cefa",
    lightslategray: "789",
    lightslategrey: "789",
    lightsteelblue: "b0c4de",
    lightyellow: "ffffe0",
    lime: "0f0",
    limegreen: "32cd32",
    linen: "faf0e6",
    magenta: "f0f",
    maroon: "800000",
    mediumaquamarine: "66cdaa",
    mediumblue: "0000cd",
    mediumorchid: "ba55d3",
    mediumpurple: "9370db",
    mediumseagreen: "3cb371",
    mediumslateblue: "7b68ee",
    mediumspringgreen: "00fa9a",
    mediumturquoise: "48d1cc",
    mediumvioletred: "c71585",
    midnightblue: "191970",
    mintcream: "f5fffa",
    mistyrose: "ffe4e1",
    moccasin: "ffe4b5",
    navajowhite: "ffdead",
    navy: "000080",
    oldlace: "fdf5e6",
    olive: "808000",
    olivedrab: "6b8e23",
    orange: "ffa500",
    orangered: "ff4500",
    orchid: "da70d6",
    palegoldenrod: "eee8aa",
    palegreen: "98fb98",
    paleturquoise: "afeeee",
    palevioletred: "db7093",
    papayawhip: "ffefd5",
    peachpuff: "ffdab9",
    peru: "cd853f",
    pink: "ffc0cb",
    plum: "dda0dd",
    powderblue: "b0e0e6",
    purple: "800080",
    rebeccapurple: "639",
    red: "f00",
    rosybrown: "bc8f8f",
    royalblue: "4169e1",
    saddlebrown: "8b4513",
    salmon: "fa8072",
    sandybrown: "f4a460",
    seagreen: "2e8b57",
    seashell: "fff5ee",
    sienna: "a0522d",
    silver: "c0c0c0",
    skyblue: "87ceeb",
    slateblue: "6a5acd",
    slategray: "708090",
    slategrey: "708090",
    snow: "fffafa",
    springgreen: "00ff7f",
    steelblue: "4682b4",
    tan: "d2b48c",
    teal: "008080",
    thistle: "d8bfd8",
    tomato: "ff6347",
    turquoise: "40e0d0",
    violet: "ee82ee",
    wheat: "f5deb3",
    white: "fff",
    whitesmoke: "f5f5f5",
    yellow: "ff0",
    yellowgreen: "9acd32"
  };
  function nameToHex$1(color2) {
    if (typeof color2 !== "string")
      return color2;
    var normalizedColorName = color2.toLowerCase();
    return namedColorMap$1[normalizedColorName] ? "#" + namedColorMap$1[normalizedColorName] : color2;
  }
  var hexRegex$1 = /^#[a-fA-F0-9]{6}$/;
  var hexRgbaRegex$1 = /^#[a-fA-F0-9]{8}$/;
  var reducedHexRegex$1 = /^#[a-fA-F0-9]{3}$/;
  var reducedRgbaHexRegex$1 = /^#[a-fA-F0-9]{4}$/;
  var rgbRegex$1 = /^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i;
  var rgbaRegex$1 = /^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
  var hslRegex$1 = /^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i;
  var hslaRegex$1 = /^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
  function parseToRgb$1(color2) {
    if (typeof color2 !== "string") {
      throw new PolishedError$1(3);
    }
    var normalizedColor = nameToHex$1(color2);
    if (normalizedColor.match(hexRegex$1)) {
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
        green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
        blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16)
      };
    }
    if (normalizedColor.match(hexRgbaRegex$1)) {
      var alpha = parseFloat((parseInt("" + normalizedColor[7] + normalizedColor[8], 16) / 255).toFixed(2));
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
        green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
        blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16),
        alpha
      };
    }
    if (normalizedColor.match(reducedHexRegex$1)) {
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
        green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
        blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16)
      };
    }
    if (normalizedColor.match(reducedRgbaHexRegex$1)) {
      var _alpha = parseFloat((parseInt("" + normalizedColor[4] + normalizedColor[4], 16) / 255).toFixed(2));
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
        green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
        blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16),
        alpha: _alpha
      };
    }
    var rgbMatched = rgbRegex$1.exec(normalizedColor);
    if (rgbMatched) {
      return {
        red: parseInt("" + rgbMatched[1], 10),
        green: parseInt("" + rgbMatched[2], 10),
        blue: parseInt("" + rgbMatched[3], 10)
      };
    }
    var rgbaMatched = rgbaRegex$1.exec(normalizedColor);
    if (rgbaMatched) {
      return {
        red: parseInt("" + rgbaMatched[1], 10),
        green: parseInt("" + rgbaMatched[2], 10),
        blue: parseInt("" + rgbaMatched[3], 10),
        alpha: parseFloat("" + rgbaMatched[4])
      };
    }
    var hslMatched = hslRegex$1.exec(normalizedColor);
    if (hslMatched) {
      var hue = parseInt("" + hslMatched[1], 10);
      var saturation = parseInt("" + hslMatched[2], 10) / 100;
      var lightness = parseInt("" + hslMatched[3], 10) / 100;
      var rgbColorString = "rgb(" + hslToRgb$1(hue, saturation, lightness) + ")";
      var hslRgbMatched = rgbRegex$1.exec(rgbColorString);
      if (!hslRgbMatched) {
        throw new PolishedError$1(4, normalizedColor, rgbColorString);
      }
      return {
        red: parseInt("" + hslRgbMatched[1], 10),
        green: parseInt("" + hslRgbMatched[2], 10),
        blue: parseInt("" + hslRgbMatched[3], 10)
      };
    }
    var hslaMatched = hslaRegex$1.exec(normalizedColor);
    if (hslaMatched) {
      var _hue = parseInt("" + hslaMatched[1], 10);
      var _saturation = parseInt("" + hslaMatched[2], 10) / 100;
      var _lightness = parseInt("" + hslaMatched[3], 10) / 100;
      var _rgbColorString = "rgb(" + hslToRgb$1(_hue, _saturation, _lightness) + ")";
      var _hslRgbMatched = rgbRegex$1.exec(_rgbColorString);
      if (!_hslRgbMatched) {
        throw new PolishedError$1(4, normalizedColor, _rgbColorString);
      }
      return {
        red: parseInt("" + _hslRgbMatched[1], 10),
        green: parseInt("" + _hslRgbMatched[2], 10),
        blue: parseInt("" + _hslRgbMatched[3], 10),
        alpha: parseFloat("" + hslaMatched[4])
      };
    }
    throw new PolishedError$1(5);
  }
  var reduceHexValue$2 = function reduceHexValue2(value) {
    if (value.length === 7 && value[1] === value[2] && value[3] === value[4] && value[5] === value[6]) {
      return "#" + value[1] + value[3] + value[5];
    }
    return value;
  };
  function numberToHex$1(value) {
    var hex2 = value.toString(16);
    return hex2.length === 1 ? "0" + hex2 : hex2;
  }
  function rgb$2(value, green, blue) {
    if (typeof value === "number" && typeof green === "number" && typeof blue === "number") {
      return reduceHexValue$2("#" + numberToHex$1(value) + numberToHex$1(green) + numberToHex$1(blue));
    } else if (typeof value === "object" && green === void 0 && blue === void 0) {
      return reduceHexValue$2("#" + numberToHex$1(value.red) + numberToHex$1(value.green) + numberToHex$1(value.blue));
    }
    throw new PolishedError$1(6);
  }
  function rgba$3(firstValue, secondValue, thirdValue, fourthValue) {
    if (typeof firstValue === "string" && typeof secondValue === "number") {
      var rgbValue = parseToRgb$1(firstValue);
      return "rgba(" + rgbValue.red + "," + rgbValue.green + "," + rgbValue.blue + "," + secondValue + ")";
    } else if (typeof firstValue === "number" && typeof secondValue === "number" && typeof thirdValue === "number" && typeof fourthValue === "number") {
      return fourthValue >= 1 ? rgb$2(firstValue, secondValue, thirdValue) : "rgba(" + firstValue + "," + secondValue + "," + thirdValue + "," + fourthValue + ")";
    } else if (typeof firstValue === "object" && secondValue === void 0 && thirdValue === void 0 && fourthValue === void 0) {
      return firstValue.alpha >= 1 ? rgb$2(firstValue.red, firstValue.green, firstValue.blue) : "rgba(" + firstValue.red + "," + firstValue.green + "," + firstValue.blue + "," + firstValue.alpha + ")";
    }
    throw new PolishedError$1(7);
  }
  function curried$1(f2, length2, acc) {
    return function fn2() {
      var combined = acc.concat(Array.prototype.slice.call(arguments));
      return combined.length >= length2 ? f2.apply(this, combined) : curried$1(f2, length2, combined);
    };
  }
  function curry$1(f2) {
    return curried$1(f2, f2.length, []);
  }
  function guard$1(lowerBoundary, upperBoundary, value) {
    return Math.max(lowerBoundary, Math.min(upperBoundary, value));
  }
  function transparentize$1(amount, color2) {
    if (color2 === "transparent")
      return color2;
    var parsedColor = parseToRgb$1(color2);
    var alpha = typeof parsedColor.alpha === "number" ? parsedColor.alpha : 1;
    var colorWithAlpha = _extends$2({}, parsedColor, {
      alpha: guard$1(0, 1, (alpha * 100 - parseFloat(amount) * 100) / 100)
    });
    return rgba$3(colorWithAlpha);
  }
  var curriedTransparentize$2 = /* @__PURE__ */ curry$1(transparentize$1);
  const Wrapper$c = styled__default.default.div`
    display: flex;
    gap: 1rem;
    align-items: center;
    justify-content: center;

    height: 100%;
`;
  const LoadingText = styled__default.default.span`
    font-size: 1.2rem;
    color: ${(props) => {
    var _a3;
    return (_a3 = props.color) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.grey4;
  }};
`;
  const Loader$1 = styled__default.default.span`
    position: relative;
    width: ${(props) => {
    var _a3;
    return (_a3 = props.size) !== null && _a3 !== void 0 ? _a3 : "2.5rem";
  }};
    height: ${(props) => {
    var _a3;
    return (_a3 = props.size) !== null && _a3 !== void 0 ? _a3 : "2.5rem";
  }};
    animation: sk-chase 2.5s infinite linear both;

    .sk-chase-dot {
        position: absolute;
        top: 0;
        left: 0;

        width: 100%;
        height: 100%;

        animation: sk-chase-dot 2s infinite ease-in-out both;
    }

    .sk-chase-dot:before {
        content: '';

        display: block;

        width: 25%;
        height: 25%;

        background-color: ${(props) => {
    var _a3;
    return (_a3 = props.color) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.grey4;
  }};
        border-radius: 100%;

        animation: sk-chase-dot-before 2s infinite ease-in-out both;
    }

    .sk-chase-dot:nth-child(1) {
        animation-delay: -1.1s;
    }
    .sk-chase-dot:nth-child(2) {
        animation-delay: -1s;
    }
    .sk-chase-dot:nth-child(3) {
        animation-delay: -0.9s;
    }
    .sk-chase-dot:nth-child(4) {
        animation-delay: -0.8s;
    }
    .sk-chase-dot:nth-child(5) {
        animation-delay: -0.7s;
    }
    .sk-chase-dot:nth-child(6) {
        animation-delay: -0.6s;
    }
    .sk-chase-dot:nth-child(1):before {
        animation-delay: -1.1s;
    }
    .sk-chase-dot:nth-child(2):before {
        animation-delay: -1s;
    }
    .sk-chase-dot:nth-child(3):before {
        animation-delay: -0.9s;
    }
    .sk-chase-dot:nth-child(4):before {
        animation-delay: -0.8s;
    }
    .sk-chase-dot:nth-child(5):before {
        animation-delay: -0.7s;
    }
    .sk-chase-dot:nth-child(6):before {
        animation-delay: -0.6s;
    }

    @keyframes sk-chase {
        100% {
            transform: rotate(360deg);
        }
    }

    @keyframes sk-chase-dot {
        80%,
        100% {
            transform: rotate(360deg);
        }
    }

    @keyframes sk-chase-dot-before {
        50% {
            transform: scale(0.4);
        }
        100%,
        0% {
            transform: scale(1);
        }
    }
`;
  function Spinner(props) {
    var _a3;
    return jsxRuntime.exports.jsxs(Wrapper$c, { className: props.className, style: props.style, children: [jsxRuntime.exports.jsxs(Loader$1, { color: props.color, size: props.size, children: [jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" })] }), (props.showText || props.text) && jsxRuntime.exports.jsx(LoadingText, { color: props.color, children: (_a3 = props.text) !== null && _a3 !== void 0 ? _a3 : "LOADING" })] });
  }
  var __rest$b = globalThis && globalThis.__rest || function(s2, e3) {
    var t2 = {};
    for (var p2 in s2)
      if (Object.prototype.hasOwnProperty.call(s2, p2) && e3.indexOf(p2) < 0)
        t2[p2] = s2[p2];
    if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
        if (e3.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
          t2[p2[i2]] = s2[p2[i2]];
      }
    return t2;
  };
  const BaseButton = styled__default.default.button`
    cursor: ${(props) => props.disabled ? "not-allowed" : "pointer"};
    user-select: none;

    display: flex;
    align-items: center;
    justify-content: center;

    height: 2.5rem;
    padding: ${(props) => props.$hasAnchor ? 0 : "0 1rem"};
    padding: 0 1rem;

    font-size: 1rem;
    font-weight: 600;

    border: none;
    border-radius: 0.25rem;
`;
  function getOutlinedButtonStyle(buttonColor, disabled2, theme2) {
    return `
        color: ${disabled2 ? theme2.colors.grey2 : buttonColor};

        background-color: transparent;
        border: 1px solid
            ${disabled2 ? theme2.colors.grey2 : buttonColor};

        :hover:not(:disabled) {
            background-color: ${theme2.themeType === "dark" ? curriedTransparentize$2(0.85, buttonColor) : curriedTransparentize$2(0.9, buttonColor)};
        }

        :active:not(:disabled) {
            background-color: ${theme2.themeType === "dark" ? curriedTransparentize$2(0.7, buttonColor) : curriedTransparentize$2(0.8, buttonColor)};
        }
    `;
  }
  function getFilledButtonStyle(buttonColor, hoverColor, clickColor, disabled2, theme2, textColor) {
    let color2 = theme2.themeType === "dark" ? theme2.colors.text : theme2.colors.blue1;
    if (textColor)
      color2 = textColor;
    return `
        color: ${color2};

        background-color: ${disabled2 ? theme2.colors.grey2 : buttonColor};

        :hover:not(:disabled) {
            background-color: ${hoverColor};
        }

        :active:not(:disabled) {
            background-color: ${clickColor};
        }
    `;
  }
  const PrimaryButton$1 = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.primary, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.primary, props.theme.colors.primaryHover, props.theme.colors.primaryDown, props.disabled, props.theme)}
`;
  const SecondaryButton$1 = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.secondary, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.secondary, props.theme.colors.secondaryHover, props.theme.colors.secondaryDown, props.disabled, props.theme)}
`;
  const GhostButton = styled__default.default(BaseButton)`
    ${(props) => getFilledButtonStyle("transparent", props.theme.colors.grey2, props.theme.colors.grey2, props.disabled, props.theme, props.theme.colors.grey4)}
`;
  const ErrorButton = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.error, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.error, props.theme.colors.errorHover, props.theme.colors.errorDown, props.disabled, props.theme)}
`;
  const PlainButton = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.grey6, props.disabled, props.theme) : getFilledButtonStyle("transparent", props.theme.colors.grey1, props.theme.colors.grey2, props.disabled, props.theme, props.theme.colors.grey6)}
`;
  const AnchorWrapper = styled__default.default.a`
    display: flex;
    align-items: center;
    justify-content: center;

    width: 100%;
    height: 100%;
    padding: 0 1rem;

    color: inherit;

    :hover,
    :active {
        color: inherit;
        text-decoration: none;
    }
`;
  const StyledLoading = styled__default.default(Spinner)`
    padding: 1rem 2rem;
`;
  const stylingMap = {
    error: ErrorButton,
    ghost: GhostButton,
    plain: PlainButton,
    primary: PrimaryButton$1,
    secondary: SecondaryButton$1
  };
  function Button$2(_a3, ref) {
    var { autoFocus, children: children2, className, disabled: disabled2, download, href, loading, id: id2, onClick, outline = false, style: style2, styling = "primary", type = "button" } = _a3, props = __rest$b(_a3, ["autoFocus", "children", "className", "disabled", "download", "href", "loading", "id", "onClick", "outline", "style", "styling", "type"]);
    const currentTheme = useClTheme();
    const Component = stylingMap[styling];
    const content2 = loading ? jsxRuntime.exports.jsx(StyledLoading, { color: outline ? currentTheme.colors.grey2 : currentTheme.colors.blue1 }) : children2;
    const wrappedContent = href ? jsxRuntime.exports.jsx(AnchorWrapper, { download, href, children: content2 }) : content2;
    return jsxRuntime.exports.jsx(Component, Object.assign({ "$hasAnchor": !!href, autoFocus, className, disabled: disabled2 || loading, id: id2, onClick, outline, style: style2, type }, props, { ref, children: wrappedContent }));
  }
  const Button$3 = React.forwardRef(Button$2);
  const ButtonBarWrapper = styled__default.default.div`
    overflow: hidden;
    display: flex;
    flex: 1 1 auto;

    height: 2.5rem;

    border: 1px solid ${(props) => {
    var _a3;
    return props.disabled ? props.theme.colors.grey2 : (_a3 = props.theme.colors) === null || _a3 === void 0 ? void 0 : _a3[props.styling];
  }};
    border-radius: 0.25rem;

    button:not(:last-child) {
        border-right: 1px solid
            ${(props) => {
    var _a3;
    return props.disabled ? props.theme.colors.grey2 : (_a3 = props.theme.colors) === null || _a3 === void 0 ? void 0 : _a3[props.styling];
  }};
    }
`;
  const shouldForwardProp$1 = (prop) => !["selected"].includes(prop);
  function getButtonStyle(buttonColor, disabled2, selected, theme2) {
    let color2 = buttonColor;
    let backgroundColor = "transparent";
    if (selected) {
      color2 = theme2.colors.background;
      backgroundColor = buttonColor;
    }
    if (disabled2) {
      color2 = theme2.colors.grey2;
      backgroundColor = theme2.colors.blue1;
    }
    if (disabled2 && selected) {
      color2 = theme2.colors.blue1;
      backgroundColor = theme2.colors.grey2;
    }
    return `
    flex: 1 1 auto;

    margin: 0px;

    color: ${color2};

    background-color: ${backgroundColor};
    border-radius: 0px;
    height: 100%;

    ${!selected && (theme2.themeType === "dark" ? `
        :hover:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.8, buttonColor)};
        }


        :active:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.6, buttonColor)};
        }
    ` : `
        :hover:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.9, buttonColor)};
        }


        :active:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.8, buttonColor)};
        }
    `)}
    `;
  }
  const PrimaryButton = styled__default.default(BaseButton).withConfig({ shouldForwardProp: shouldForwardProp$1 })`
    ${(props) => getButtonStyle(props.theme.colors.primary, props.disabled, props.selected, props.theme)}
`;
  const SecondaryButton = styled__default.default(BaseButton).withConfig({ shouldForwardProp: shouldForwardProp$1 })`
    ${(props) => getButtonStyle(props.theme.colors.secondary, props.disabled, props.selected, props.theme)}
`;
  function ButtonBar$1({ className, disabled: disabled2, id: id2, value, initialValue, items, onSelect, style: style2, styling = "primary" }) {
    const [selected, setSelected] = React.useState(value || initialValue || items[0]);
    const ButtonComponent = styling === "secondary" ? SecondaryButton : PrimaryButton;
    const onClick = React.useCallback((item) => {
      onSelect === null || onSelect === void 0 ? void 0 : onSelect(item);
      if (value === void 0) {
        setSelected(item);
      }
    }, [value, onSelect]);
    React.useEffect(() => {
      setSelected(value || initialValue || items[0]);
    }, [value]);
    return jsxRuntime.exports.jsx(ButtonBarWrapper, { className, disabled: disabled2, style: style2, styling, children: items.map((item) => jsxRuntime.exports.jsx(ButtonComponent, { "$hasAnchor": false, "aria-selected": selected.value === item.value, disabled: disabled2, id: id2, onClick: () => onClick(item), selected: selected.value === item.value, type: "button", children: item.label }, `option-${String(item.value)}`)) });
  }
  const CarouselComponent = styled__default.default.div`
    position: relative;

    overflow: hidden;
    display: flex;
    flex: 1 1 auto;
    flex-direction: column;
    justify-content: center;

    max-height: 100%;
    padding: 0 0.5rem;
`;
  const CarouselItemsContainer = styled__default.default.div`
    display: inline-flex;
    max-height: calc(100% - 1.625rem);
    white-space: nowrap;
    transition: transform 0.3s;
`;
  const CarouselItemWrapper = styled__default.default.div`
    display: flex;
    flex: 1 0 auto;
    justify-content: center;

    width: 100%;
    min-height: 5rem;
    max-height: 100%;
`;
  const CarouselIndicators = styled__default.default.div`
    display: flex;
    gap: 0.2rem;
    justify-content: center;
`;
  const Button$1 = styled__default.default.button`
    cursor: pointer;
    user-select: none;

    position: absolute;
    z-index: 3;
    top: calc(50% - 0.5rem);
    transform: translateY(-50%);

    display: flex;
    align-items: center;

    padding: 0;

    color: ${(props) => props.theme.colors.grey4};

    background-color: inherit;
    border: none;

    :hover {
        color: ${(props) => props.theme.colors.grey5};
    }
`;
  const CircleSelect = styled__default.default.button`
    cursor: pointer;
    user-select: none;

    z-index: 3;

    padding: 0;

    color: ${(props) => props.selected ? props.theme.colors.grey4 : props.theme.colors.grey3};

    background-color: inherit;
    border: none;

    :hover {
        color: ${(props) => props.theme.colors.grey4};
    }

    svg {
        width: 0.5rem;
        height: 0.5rem;
    }
`;
  const ImageWrapper = styled__default.default.div`
    display: flex;
    flex: 0 0 auto;
    align-items: center;
    justify-content: center;
`;
  const TextWrapper = styled__default.default.div`
    overflow: auto;
    display: flex;
    flex: 1 1 auto;
    flex-direction: column;

    box-sizing: border-box;
    margin: 1rem 0;
    padding: 0 1.5rem;

    color: ${(props) => props.theme.colors.text};
`;
  const Title$3 = styled__default.default.div`
    display: flex;
    flex: 0 0 auto;
    font-weight: bold;
    color: ${(props) => props.theme.colors.text};
`;
  const CarouselItemContainer = (props) => {
    return jsxRuntime.exports.jsx(CarouselItemWrapper, { children: jsxRuntime.exports.jsxs("div", { style: {
      display: "flex",
      flexDirection: "column",
      overflow: "auto",
      padding: "0rem 1rem"
    }, children: [props.item.image && jsxRuntime.exports.jsx(ImageWrapper, { children: jsxRuntime.exports.jsx("img", { alt: props.item.imageAlt, src: props.item.image, style: {
      height: props.item.imageHeight,
      width: props.item.imageWidth
    } }) }), (props.item.title || props.item.subtitle) && jsxRuntime.exports.jsxs(TextWrapper, { style: {
      gap: `${props.item.title && props.item.subtitle ? "0.5rem" : "0"}`,
      maxWidth: "100%",
      whiteSpace: "normal"
    }, children: [jsxRuntime.exports.jsx(Title$3, { children: props.item.title }), jsxRuntime.exports.jsx("span", { children: props.item.subtitle })] }), props.item.component && props.item.component] }) });
  };
  function Carousel$1(props) {
    const [activeIndex, setActiveIndex] = React.useState(props.value || props.initialValue || 0);
    const updateIndex = React.useCallback((newIndex) => {
      var _a3;
      let _newIndex = newIndex;
      if (newIndex < 0) {
        _newIndex = props.items.length - 1;
      } else if (newIndex >= props.items.length) {
        _newIndex = 0;
      }
      (_a3 = props.onChange) === null || _a3 === void 0 ? void 0 : _a3.call(props, _newIndex);
      if (props.value === void 0) {
        setActiveIndex(_newIndex);
      }
    }, [props.onChange, props.items, props.value]);
    React.useEffect(() => {
      setActiveIndex(props.value || props.initialValue || 0);
    }, [props.value]);
    return jsxRuntime.exports.jsxs(CarouselComponent, { className: props.className, style: props.style, children: [jsxRuntime.exports.jsx(Button$1, { "data-testid": "carousel-left-button", onClick: () => {
      updateIndex(activeIndex - 1);
    }, style: { left: "0.5rem" }, type: "button", children: jsxRuntime.exports.jsx(ChevronLeft, {}) }), jsxRuntime.exports.jsx(CarouselItemsContainer, { style: { transform: `translateX(-${activeIndex * 100}%)` }, children: props.items.map((item, index2) => {
      return jsxRuntime.exports.jsx(CarouselItemContainer, { item }, `carousel-item-${index2}`);
    }) }), jsxRuntime.exports.jsx(Button$1, { "data-testid": "carousel-right-button", onClick: () => {
      updateIndex(activeIndex + 1);
    }, style: { right: "0.5rem" }, type: "button", children: jsxRuntime.exports.jsx(ChevronRight, {}) }), jsxRuntime.exports.jsx(CarouselIndicators, { children: props.items.map((item, index2) => {
      return jsxRuntime.exports.jsx(CircleSelect, { onClick: () => {
        updateIndex(index2);
      }, selected: index2 === activeIndex, type: "button", children: jsxRuntime.exports.jsx(Circle$1, {}) }, `carousel-select-${index2}`);
    }) })] });
  }
  const CheckboxWrapper$1 = styled__default.default.label`
    cursor: ${(props) => props.disabled ? "not-allowed" : "pointer"};
    user-select: none;

    position: relative;

    display: flex;
    align-items: center;

    width: ${(props) => props.isListStyle ? "100%" : "fit-content"};
    padding: 0.5625rem 0rem 0.5625rem 2rem;

    font-size: 1rem;

    border-radius: 0.25rem;

    ${(props) => {
    if (props.isListStyle && !props.disabled) {
      return `
                :hover {
                    background-color: ${props.theme.colors.grey1};

                    span {
                        border: 1px solid ${props.theme.colors.grey4};
                    }
                }

                :active {
                    background-color: ${props.theme.colors.grey2};
                }
        `;
    }
  }}

    // sets checkmark indicator
    span:after {
        top: 0.05rem;
        left: 0.3rem;
        transform: rotate(45deg);

        width: 0.3125rem;
        height: 0.625rem;

        border: solid ${(props) => props.theme.colors.grey5};
        border-width: 0 2px 2px 0;
    }

    // Show the checkmark when checked
    input:checked ~ span:after {
        display: block;
    }

    :hover {
        span,
        input:checked ~ span {
            background-color: ${(props) => {
    if (props.disabled) {
      return props.theme.colors.grey3;
    }
    if (props.isListStyle) {
      return props.theme.colors.blue1;
    }
    return props.theme.colors.grey1;
  }};
            border: 1px solid ${(props) => props.theme.colors.grey4};
        }
    }

    :active {
        span,
        input:checked ~ span {
            background-color: ${(props) => {
    if (props.disabled) {
      return props.theme.colors.grey3;
    }
    if (props.isListStyle) {
      return props.theme.colors.blue1;
    }
    return props.theme.colors.grey2;
  }};
        }
    }
`;
  const StyledCheckbox$1 = styled__default.default.input`
    cursor: pointer;
    /* Hide the browser's default checkbox */
    position: absolute;

    width: 0;
    height: 0;

    opacity: 0;

    :checked ~ span {
        background-color: ${(props) => props.disabled ? props.theme.colors.grey3 : props.theme.colors.blue1};
    }
`;
  const StyledCheckmark$1 = styled__default.default.span`
    position: absolute;
    left: 0.5rem;

    width: 1rem;
    height: 1rem;

    background-color: ${(props) => props.disabled ? props.theme.colors.grey3 : props.theme.colors.blue1};
    border: 1px solid ${(props) => props.disabled ? props.theme.colors.grey3 : props.theme.colors.grey4};
    border-radius: 0.25rem;

    // hidden checkmark indicator
    :after {
        content: '';
        position: absolute;
        display: none;
    }
`;
  function Checkbox(props) {
    const [checked, setChecked] = React.useState(props.selected || props.initialValue);
    React.useEffect(() => {
      if (props.selected !== void 0) {
        setChecked(props.selected);
      }
    }, [props.selected]);
    const onClick = (e3) => {
      if (props.disabled) {
        return;
      }
      if (props.selected === void 0) {
        setChecked(!checked);
      }
      if (props.onChange) {
        props.onChange(!checked, e3);
      }
    };
    return jsxRuntime.exports.jsxs(CheckboxWrapper$1, { className: props.className, disabled: props.disabled, isListStyle: props.isListStyle, children: [props.label, jsxRuntime.exports.jsx(StyledCheckbox$1, { "aria-disabled": props.disabled, checked: props.selected, disabled: props.disabled, isListStyle: props.isListStyle, onChange: (e3) => onClick(e3), onClick: props.onClick, type: "checkbox", value: props.id }), jsxRuntime.exports.jsx(StyledCheckmark$1, { disabled: props.disabled, isListStyle: props.isListStyle })] });
  }
  const CheckboxWrapper = styled__default.default.div`
    user-select: none;
    display: flex;
    width: 100%;
    border: none;
`;
  const CheckboxGroupWrapper = styled__default.default.div`
    color: ${(props) => props.theme.colors.text};
`;
  const CheckboxInfo = styled__default.default.p`
    font-size: 0.75rem;
    color: ${(props) => props.theme.colors.grey4};
`;
  function getInitialValue$3(initialValue) {
    if (Array.isArray(initialValue)) {
      return initialValue;
    }
    if (initialValue) {
      return [initialValue];
    }
    return [];
  }
  function getInitialCheckedState(items, initialValues) {
    if (initialValues) {
      return items.map((item) => ({ state: initialValues.includes(item.value), value: item.value }));
    }
    return items.map((item) => ({ state: initialValues.includes(item.value), value: false }));
  }
  function CheckboxGroup$1(props) {
    const [values, setValues] = React.useState(() => getInitialValue$3(props.values || props.initialValue));
    const [checkedState, setCheckedState] = React.useState(() => getInitialCheckedState(props.items, values));
    const isSelectPermitted = React.useMemo(() => {
      if (!props.selectMax || values.length < props.selectMax) {
        return true;
      }
      return false;
    }, [values, props.selectMax]);
    const infoMessage = React.useMemo(() => {
      if (props.selectMax && props.selectMin) {
        return `You can select from ${props.selectMin} to ${props.selectMax} options`;
      }
      if (props.selectMax) {
        return `You can select up to ${props.selectMax} options`;
      }
      if (props.selectMin) {
        return `You should select at least ${props.selectMin} options`;
      }
    }, [props.selectMax, props.selectMin]);
    const onChangeValue = (event2) => {
      var _a3;
      const target = event2.target;
      const chosenIndex = Number(target.value);
      const chosenValue = props.items[chosenIndex].value;
      let newValues = [...values];
      if (values.includes(chosenValue)) {
        newValues = newValues.filter((value) => value !== chosenValue);
      } else {
        newValues.push(chosenValue);
      }
      if (newValues.length > props.selectMax && checkedState[chosenIndex] || newValues.length <= props.selectMax || !props.selectMax) {
        const indexToUpdate = checkedState.findIndex((item) => item.value === chosenValue);
        checkedState[indexToUpdate].state = !checkedState[indexToUpdate].state;
        setCheckedState(checkedState);
        setValues(newValues);
        if (!props.selectMin || newValues.length >= props.selectMin) {
          (_a3 = props.onChange) === null || _a3 === void 0 ? void 0 : _a3.call(props, props.items.filter((item) => newValues.includes(item.value)), event2);
        }
      }
    };
    React.useEffect(() => {
      if (props.values) {
        const valuesArray = props.values.map((value) => value.value);
        setCheckedState(props.items.map((item) => ({ state: valuesArray.includes(item.value), value: item.value })));
        setValues(valuesArray);
      }
    }, [props.values, props.items]);
    return jsxRuntime.exports.jsxs(CheckboxGroupWrapper, { className: props.className, style: props.style, children: [(props.selectMax || props.selectMin) && jsxRuntime.exports.jsx(CheckboxInfo, { children: infoMessage }), props.items.map((item, index2) => {
      var _a3, _b;
      return jsxRuntime.exports.jsx(CheckboxWrapper, { "aria-disabled": props.disabled, children: jsxRuntime.exports.jsx(Checkbox, { disabled: isSelectPermitted ? props.disabled : ((_a3 = checkedState.find((option) => option.value === item.value)) === null || _a3 === void 0 ? void 0 : _a3.state) === false, id: index2, isListStyle: props.isListStyle, label: item.label ? item.label : item.value, onChange: (checked, e3) => onChangeValue(e3), selected: (_b = checkedState.find((option) => option.value === item.value)) === null || _b === void 0 ? void 0 : _b.state }) }, `item-${index2}`);
    })] });
  }
  var __rest$a = globalThis && globalThis.__rest || function(s2, e3) {
    var t2 = {};
    for (var p2 in s2)
      if (Object.prototype.hasOwnProperty.call(s2, p2) && e3.indexOf(p2) < 0)
        t2[p2] = s2[p2];
    if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
        if (e3.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
          t2[p2[i2]] = s2[p2[i2]];
      }
    return t2;
  };
  const PrimaryInput = styled__default.default.input`
    display: flex;
    align-items: center;

    width: 100%;
    height: 100%;
    padding: 0 1rem;

    font-size: 1rem;
    color: ${(props) => props.disabled ? props.theme.colors.grey2 : props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.grey1};
    border: 1px solid
        ${(props) => {
    return props.isErrored ? props.theme.colors.error : props.theme.colors.grey1;
  }};
    border-radius: 0.25rem;
    outline: 0;

    :active:not(:disabled),
    :focus:not(:disabled) {
        border: 1px solid ${(props) => props.isErrored ? props.theme.colors.error : props.theme.colors.grey3};
    }

    :hover:not(:disabled) {
        background-color: ${(props) => props.theme.colors.grey2};
    }

    :disabled {
        cursor: not-allowed;
    }

    ::placeholder {
        font-style: italic;
    }
`;
  const InputWrapper$5 = styled__default.default.div`
    width: 22ch;
    max-width: 100%;
    height: 2.5rem;
`;
  const ErrorMessage$2 = styled__default.default.span`
    margin-left: 1rem;
    font-size: 0.75rem;
    color: ${(props) => props.theme.colors.error};
`;
  const Input$3 = React.forwardRef((_a3, ref) => {
    var { type = "text" } = _a3, props = __rest$a(_a3, ["type"]);
    const onChange2 = (e3) => {
      const target = e3.target;
      if (props.onChange) {
        props.onChange(target.value, e3);
      }
    };
    const onKeyDown = (e3) => {
      if (props.onKeyDown)
        props.onKeyDown(e3);
      if (props.keydownFilter && !props.keydownFilter(e3)) {
        e3.preventDefault();
      }
      if (e3.key === Key.ENTER && props.onComplete) {
        props.onComplete();
      }
    };
    const addOptionalItems = () => {
      const result = {};
      if (props.minValue)
        result.minValue = props.minValue;
      if (props.maxValue)
        result.maxValue = props.minValue;
      return result;
    };
    return jsxRuntime.exports.jsxs(InputWrapper$5, { className: props.className, style: props.style, children: [jsxRuntime.exports.jsx(PrimaryInput, Object.assign({ autoFocus: props.autoFocus, defaultValue: props.initialValue, disabled: props.disabled, isErrored: !!props.errorMsg, maxLength: props.maxLength, onBlur: props.onBlur, onChange: onChange2, onClick: props.onClick, onKeyDown, placeholder: props.placeholder, ref, type, value: props.value }, addOptionalItems())), props.errorMsg && jsxRuntime.exports.jsxs(ErrorMessage$2, { children: [props.errorMsg, " "] })] });
  });
  Input$3.displayName = "Input";
  const Wrapper$b = styled__default.default.div`
    display: flex;
    margin: 0rem 0.5rem;
`;
  const SearchBarComponent = styled__default.default(Input$3)`
    input {
        padding-right: 2.25rem;
    }

    :hover:not(:disabled) {
        input {
            border: 1px solid ${(props) => props.theme.colors.grey3};
        }
    }
`;
  const SearchBarIcon = styled__default.default(MagnifyingGlass)`
    position: relative;
    top: 0.625rem;
    right: 1.75rem;

    height: 1.25rem;

    color: ${(props) => props.theme.colors.grey4};
`;
  function SearchBar(props) {
    var _a3;
    return jsxRuntime.exports.jsxs(Wrapper$b, { children: [jsxRuntime.exports.jsx(SearchBarComponent, { className: props.className, disabled: props.disabled, maxLength: props.maxLength, onChange: props.onChange, placeholder: (_a3 = props.placeholder) !== null && _a3 !== void 0 ? _a3 : "Search", style: props.style, value: props.value }), jsxRuntime.exports.jsx(SearchBarIcon, {})] });
  }
  const FilterWrapper = styled__default.default.div`
    display: flex;
    flex-direction: column;
    gap: 0.5rem;

    width: 17.5rem;
    padding: 1.25rem 0.5rem;

    background-color: ${(props) => props.theme.colors.grey1};
    border-radius: 0.25rem;
    box-shadow: ${(props) => props.theme.shadow.light};
`;
  const StyledSearchBar = styled__default.default(SearchBar)`
    width: 15.5rem;
    background-color: ${(props) => props.theme.colors.blue1};
    border: 1px solid ${(props) => props.theme.colors.blue1};
    border-radius: 0.25rem;

    input {
        width: 15.5rem;
        background-color: ${(props) => props.theme.colors.blue1};
        border: none;

        :active:not(:disabled),
        :focus:not(:disabled) {
            border: none;
        }
    }

    :hover:not(:disabled) {
        background-color: ${(props) => props.theme.colors.blue1};
        border: 1px solid ${(props) => props.theme.colors.grey2};

        input {
            background-color: ${(props) => props.theme.colors.blue1};
            border: none;
        }
    }
`;
  const FilterButtons = styled__default.default.button`
    font-size: 0.75rem;
    font-weight: 400;
    color: ${(props) => props.theme.colors.primary};

    background-color: inherit;
    border: none;

    :hover {
        cursor: pointer;
        color: ${(props) => props.theme.colors.primaryHover};
    }

    :active {
        color: ${(props) => props.theme.colors.primaryDown};
    }

    :disabled {
        cursor: not-allowed;
        color: ${(props) => props.theme.colors.grey2};
    }
`;
  const OptionsWrapper = styled__default.default.div`
    overflow-y: auto;
    height: 10rem;
`;
  const StyledCheckboxGroup = styled__default.default(CheckboxGroup$1)`
    div {
        height: 2rem;
        padding: 0rem 0.75rem;
    }
    label {
        font-size: 0.75rem;
        :hover {
            background: ${(props) => props.theme.colors.grey2} !important;
        }
        :active {
            background: ${(props) => props.theme.colors.grey3} !important;
        }
    }
`;
  const ApplyButton = styled__default.default(FilterButtons)`
    align-self: center;

    width: fit-content;
    height: 2rem;
    padding: 0.5rem;

    font-size: 0.875rem;
`;
  function CategoricalFilter(props) {
    var _a3;
    const [inputValue, setInputValue] = React.useState("");
    const [filterValue, setFilterValue] = React.useState((_a3 = props.values) !== null && _a3 !== void 0 ? _a3 : []);
    const [previousFilter, setPreviousFilter] = React.useState(props.values);
    const filteredItems = props.items.filter((item) => {
      var _a4;
      return inputValue ? (_a4 = item.label) === null || _a4 === void 0 ? void 0 : _a4.toLowerCase().includes(inputValue === null || inputValue === void 0 ? void 0 : inputValue.toLowerCase()) : true;
    });
    return jsxRuntime.exports.jsxs(FilterWrapper, { className: props.className, children: [jsxRuntime.exports.jsx(StyledSearchBar, { onChange: (change) => setInputValue(change) }), jsxRuntime.exports.jsxs("div", { style: { display: "flex", height: "2rem", margin: "0rem 0.75rem -0.5rem 0.75rem" }, children: [jsxRuntime.exports.jsx(FilterButtons, { onClick: () => setFilterValue(filteredItems), children: "Select all" }), jsxRuntime.exports.jsx(FilterButtons, { onClick: () => setFilterValue([]), children: "Clear" })] }), jsxRuntime.exports.jsx(OptionsWrapper, { children: jsxRuntime.exports.jsx(StyledCheckboxGroup, { isListStyle: true, items: filteredItems, onChange: (v2) => {
      var _a4, _b;
      const selectedFilteredItems = Array.isArray(v2) ? v2 : [v2];
      const unchecked = (_a4 = filterValue === null || filterValue === void 0 ? void 0 : filterValue.filter((value) => selectedFilteredItems.every((item) => !isEqual_1(value, item)) && filteredItems.some((item) => isEqual_1(value, item)))) !== null && _a4 !== void 0 ? _a4 : [];
      const newlyChecked = selectedFilteredItems.filter((value) => filterValue === null || filterValue === void 0 ? void 0 : filterValue.every((item) => !isEqual_1(value, item)));
      const stillChecked = (_b = filterValue === null || filterValue === void 0 ? void 0 : filterValue.filter((value) => !unchecked.some((item) => isEqual_1(value, item)))) !== null && _b !== void 0 ? _b : [];
      setFilterValue([...stillChecked, ...newlyChecked]);
    }, values: filterValue }) }), jsxRuntime.exports.jsx(ApplyButton, { disabled: props.disabled || previousFilter === filterValue, onClick: (e3) => {
      var _a4, _b;
      (_a4 = props.onChange) === null || _a4 === void 0 ? void 0 : _a4.call(props, filterValue, e3);
      (_b = props === null || props === void 0 ? void 0 : props.column) === null || _b === void 0 ? void 0 : _b.setFilter(filterValue || void 0);
      setPreviousFilter(filterValue);
    }, children: "Apply" })] });
  }
  function _objectWithoutPropertiesLoose$5(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  var reactIs$1 = { exports: {} };
  var reactIs_production_min$1 = {};
  /** @license React v17.0.2
   * react-is.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var b$5 = 60103, c$6 = 60106, d$3 = 60107, e$3 = 60108, f$4 = 60114, g$4 = 60109, h$4 = 60110, k$4 = 60112, l$4 = 60113, m$3 = 60120, n$5 = 60115, p$4 = 60116, q$3 = 60121, r$3 = 60122, u$3 = 60117, v$4 = 60129, w$4 = 60131;
  if ("function" === typeof Symbol && Symbol.for) {
    var x$4 = Symbol.for;
    b$5 = x$4("react.element");
    c$6 = x$4("react.portal");
    d$3 = x$4("react.fragment");
    e$3 = x$4("react.strict_mode");
    f$4 = x$4("react.profiler");
    g$4 = x$4("react.provider");
    h$4 = x$4("react.context");
    k$4 = x$4("react.forward_ref");
    l$4 = x$4("react.suspense");
    m$3 = x$4("react.suspense_list");
    n$5 = x$4("react.memo");
    p$4 = x$4("react.lazy");
    q$3 = x$4("react.block");
    r$3 = x$4("react.server.block");
    u$3 = x$4("react.fundamental");
    v$4 = x$4("react.debug_trace_mode");
    w$4 = x$4("react.legacy_hidden");
  }
  function y$6(a2) {
    if ("object" === typeof a2 && null !== a2) {
      var t2 = a2.$$typeof;
      switch (t2) {
        case b$5:
          switch (a2 = a2.type, a2) {
            case d$3:
            case f$4:
            case e$3:
            case l$4:
            case m$3:
              return a2;
            default:
              switch (a2 = a2 && a2.$$typeof, a2) {
                case h$4:
                case k$4:
                case p$4:
                case n$5:
                case g$4:
                  return a2;
                default:
                  return t2;
              }
          }
        case c$6:
          return t2;
      }
    }
  }
  var z$3 = g$4, A$2 = b$5, B$2 = k$4, C$2 = d$3, D$2 = p$4, E$2 = n$5, F$2 = c$6, G$2 = f$4, H$3 = e$3, I$2 = l$4;
  reactIs_production_min$1.ContextConsumer = h$4;
  reactIs_production_min$1.ContextProvider = z$3;
  reactIs_production_min$1.Element = A$2;
  reactIs_production_min$1.ForwardRef = B$2;
  reactIs_production_min$1.Fragment = C$2;
  reactIs_production_min$1.Lazy = D$2;
  reactIs_production_min$1.Memo = E$2;
  reactIs_production_min$1.Portal = F$2;
  reactIs_production_min$1.Profiler = G$2;
  reactIs_production_min$1.StrictMode = H$3;
  reactIs_production_min$1.Suspense = I$2;
  reactIs_production_min$1.isAsyncMode = function() {
    return false;
  };
  reactIs_production_min$1.isConcurrentMode = function() {
    return false;
  };
  reactIs_production_min$1.isContextConsumer = function(a2) {
    return y$6(a2) === h$4;
  };
  reactIs_production_min$1.isContextProvider = function(a2) {
    return y$6(a2) === g$4;
  };
  reactIs_production_min$1.isElement = function(a2) {
    return "object" === typeof a2 && null !== a2 && a2.$$typeof === b$5;
  };
  reactIs_production_min$1.isForwardRef = function(a2) {
    return y$6(a2) === k$4;
  };
  reactIs_production_min$1.isFragment = function(a2) {
    return y$6(a2) === d$3;
  };
  reactIs_production_min$1.isLazy = function(a2) {
    return y$6(a2) === p$4;
  };
  reactIs_production_min$1.isMemo = function(a2) {
    return y$6(a2) === n$5;
  };
  reactIs_production_min$1.isPortal = function(a2) {
    return y$6(a2) === c$6;
  };
  reactIs_production_min$1.isProfiler = function(a2) {
    return y$6(a2) === f$4;
  };
  reactIs_production_min$1.isStrictMode = function(a2) {
    return y$6(a2) === e$3;
  };
  reactIs_production_min$1.isSuspense = function(a2) {
    return y$6(a2) === l$4;
  };
  reactIs_production_min$1.isValidElementType = function(a2) {
    return "string" === typeof a2 || "function" === typeof a2 || a2 === d$3 || a2 === f$4 || a2 === v$4 || a2 === e$3 || a2 === l$4 || a2 === m$3 || a2 === w$4 || "object" === typeof a2 && null !== a2 && (a2.$$typeof === p$4 || a2.$$typeof === n$5 || a2.$$typeof === g$4 || a2.$$typeof === h$4 || a2.$$typeof === k$4 || a2.$$typeof === u$3 || a2.$$typeof === q$3 || a2[0] === r$3) ? true : false;
  };
  reactIs_production_min$1.typeOf = y$6;
  (function(module2) {
    {
      module2.exports = reactIs_production_min$1;
    }
  })(reactIs$1);
  let e$2 = (e3) => "object" == typeof e3 && null != e3 && 1 === e3.nodeType, t$4 = (e3, t2) => (!t2 || "hidden" !== e3) && ("visible" !== e3 && "clip" !== e3), n$4 = (e3, n2) => {
    if (e3.clientHeight < e3.scrollHeight || e3.clientWidth < e3.scrollWidth) {
      let l2 = getComputedStyle(e3, null);
      return t$4(l2.overflowY, n2) || t$4(l2.overflowX, n2) || ((e4) => {
        let t2 = ((e6) => {
          if (!e6.ownerDocument || !e6.ownerDocument.defaultView)
            return null;
          try {
            return e6.ownerDocument.defaultView.frameElement;
          } catch (e7) {
            return null;
          }
        })(e4);
        return !!t2 && (t2.clientHeight < e4.scrollHeight || t2.clientWidth < e4.scrollWidth);
      })(e3);
    }
    return false;
  }, l$3 = (e3, t2, n2, l2, i2, o2, r2, d2) => o2 < e3 && r2 > t2 || o2 > e3 && r2 < t2 ? 0 : o2 <= e3 && d2 <= n2 || r2 >= t2 && d2 >= n2 ? o2 - e3 - l2 : r2 > t2 && d2 < n2 || o2 < e3 && d2 > n2 ? r2 - t2 + i2 : 0, i$5 = (e3) => {
    let t2 = e3.parentElement;
    return null == t2 ? e3.getRootNode().host || null : t2;
  };
  var o$4 = (t2, o2) => {
    var r2, d2, h2, f2, u2, s2;
    if ("undefined" == typeof document)
      return [];
    let { scrollMode: a2, block: c2, inline: g2, boundary: m2, skipOverflowHiddenElements: p2 } = o2, w2 = "function" == typeof m2 ? m2 : (e3) => e3 !== m2;
    if (!e$2(t2))
      throw new TypeError("Invalid target");
    let W2 = document.scrollingElement || document.documentElement, H2 = [], b2 = t2;
    for (; e$2(b2) && w2(b2); ) {
      if (b2 = i$5(b2), b2 === W2) {
        H2.push(b2);
        break;
      }
      null != b2 && b2 === document.body && n$4(b2) && !n$4(document.documentElement) || null != b2 && n$4(b2, p2) && H2.push(b2);
    }
    let v2 = null != (d2 = null == (r2 = window.visualViewport) ? void 0 : r2.width) ? d2 : innerWidth, y2 = null != (f2 = null == (h2 = window.visualViewport) ? void 0 : h2.height) ? f2 : innerHeight, E2 = null != (u2 = window.scrollX) ? u2 : pageXOffset, M2 = null != (s2 = window.scrollY) ? s2 : pageYOffset, { height: x2, width: I2, top: C2, right: R2, bottom: T2, left: V2 } = t2.getBoundingClientRect(), k2 = "start" === c2 || "nearest" === c2 ? C2 : "end" === c2 ? T2 : C2 + x2 / 2, B2 = "center" === g2 ? V2 + I2 / 2 : "end" === g2 ? R2 : V2, D2 = [];
    for (let e3 = 0; e3 < H2.length; e3++) {
      let t3 = H2[e3], { height: n2, width: i2, top: o3, right: r3, bottom: d3, left: h3 } = t3.getBoundingClientRect();
      if ("if-needed" === a2 && C2 >= 0 && V2 >= 0 && T2 <= y2 && R2 <= v2 && C2 >= o3 && T2 <= d3 && V2 >= h3 && R2 <= r3)
        return D2;
      let f3 = getComputedStyle(t3), u3 = parseInt(f3.borderLeftWidth, 10), s3 = parseInt(f3.borderTopWidth, 10), m3 = parseInt(f3.borderRightWidth, 10), p3 = parseInt(f3.borderBottomWidth, 10), w3 = 0, b3 = 0, O2 = "offsetWidth" in t3 ? t3.offsetWidth - t3.clientWidth - u3 - m3 : 0, X2 = "offsetHeight" in t3 ? t3.offsetHeight - t3.clientHeight - s3 - p3 : 0, Y2 = "offsetWidth" in t3 ? 0 === t3.offsetWidth ? 0 : i2 / t3.offsetWidth : 0, L2 = "offsetHeight" in t3 ? 0 === t3.offsetHeight ? 0 : n2 / t3.offsetHeight : 0;
      if (W2 === t3)
        w3 = "start" === c2 ? k2 : "end" === c2 ? k2 - y2 : "nearest" === c2 ? l$3(M2, M2 + y2, y2, s3, p3, M2 + k2, M2 + k2 + x2, x2) : k2 - y2 / 2, b3 = "start" === g2 ? B2 : "center" === g2 ? B2 - v2 / 2 : "end" === g2 ? B2 - v2 : l$3(E2, E2 + v2, v2, u3, m3, E2 + B2, E2 + B2 + I2, I2), w3 = Math.max(0, w3 + M2), b3 = Math.max(0, b3 + E2);
      else {
        w3 = "start" === c2 ? k2 - o3 - s3 : "end" === c2 ? k2 - d3 + p3 + X2 : "nearest" === c2 ? l$3(o3, d3, n2, s3, p3 + X2, k2, k2 + x2, x2) : k2 - (o3 + n2 / 2) + X2 / 2, b3 = "start" === g2 ? B2 - h3 - u3 : "center" === g2 ? B2 - (h3 + i2 / 2) + O2 / 2 : "end" === g2 ? B2 - r3 + m3 + O2 : l$3(h3, r3, i2, u3, m3 + O2, B2, B2 + I2, I2);
        let { scrollLeft: e4, scrollTop: f4 } = t3;
        w3 = Math.max(0, Math.min(f4 + w3 / L2, t3.scrollHeight - n2 / L2 + X2)), b3 = Math.max(0, Math.min(e4 + b3 / Y2, t3.scrollWidth - i2 / Y2 + O2)), k2 += f4 - w3, B2 += e4 - b3;
      }
      D2.push({ el: t3, top: w3, left: b3 });
    }
    return D2;
  };
  var __assign = function() {
    __assign = Object.assign || function __assign2(t2) {
      for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
        s2 = arguments[i2];
        for (var p2 in s2)
          if (Object.prototype.hasOwnProperty.call(s2, p2))
            t2[p2] = s2[p2];
      }
      return t2;
    };
    return __assign.apply(this, arguments);
  };
  function __awaiter$1(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  }
  function __generator(thisArg, body) {
    var _2 = { label: 0, sent: function() {
      if (t2[0] & 1)
        throw t2[1];
      return t2[1];
    }, trys: [], ops: [] }, f2, y2, t2, g2;
    return g2 = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
      return this;
    }), g2;
    function verb(n2) {
      return function(v2) {
        return step2([n2, v2]);
      };
    }
    function step2(op) {
      if (f2)
        throw new TypeError("Generator is already executing.");
      while (g2 && (g2 = 0, op[0] && (_2 = 0)), _2)
        try {
          if (f2 = 1, y2 && (t2 = op[0] & 2 ? y2["return"] : op[0] ? y2["throw"] || ((t2 = y2["return"]) && t2.call(y2), 0) : y2.next) && !(t2 = t2.call(y2, op[1])).done)
            return t2;
          if (y2 = 0, t2)
            op = [op[0] & 2, t2.value];
          switch (op[0]) {
            case 0:
            case 1:
              t2 = op;
              break;
            case 4:
              _2.label++;
              return { value: op[1], done: false };
            case 5:
              _2.label++;
              y2 = op[1];
              op = [0];
              continue;
            case 7:
              op = _2.ops.pop();
              _2.trys.pop();
              continue;
            default:
              if (!(t2 = _2.trys, t2 = t2.length > 0 && t2[t2.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _2 = 0;
                continue;
              }
              if (op[0] === 3 && (!t2 || op[1] > t2[0] && op[1] < t2[3])) {
                _2.label = op[1];
                break;
              }
              if (op[0] === 6 && _2.label < t2[1]) {
                _2.label = t2[1];
                t2 = op;
                break;
              }
              if (t2 && _2.label < t2[2]) {
                _2.label = t2[2];
                _2.ops.push(op);
                break;
              }
              if (t2[2])
                _2.ops.pop();
              _2.trys.pop();
              continue;
          }
          op = body.call(thisArg, _2);
        } catch (e3) {
          op = [6, e3];
          y2 = 0;
        } finally {
          f2 = t2 = 0;
        }
      if (op[0] & 5)
        throw op[1];
      return { value: op[0] ? op[1] : void 0, done: true };
    }
  }
  function __read(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2)
      return o2;
    var i2 = m2.call(o2), r2, ar = [], e3;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done)
        ar.push(r2.value);
    } catch (error2) {
      e3 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"]))
          m2.call(i2);
      } finally {
        if (e3)
          throw e3.error;
      }
    }
    return ar;
  }
  function __spread() {
    for (var ar = [], i2 = 0; i2 < arguments.length; i2++)
      ar = ar.concat(__read(arguments[i2]));
    return ar;
  }
  typeof SuppressedError === "function" ? SuppressedError : function(error2, suppressed, message) {
    var e3 = new Error(message);
    return e3.name = "SuppressedError", e3.error = error2, e3.suppressed = suppressed, e3;
  };
  var idCounter$2 = 0;
  function noop$5() {
  }
  function scrollIntoView$1(node2, menuNode) {
    if (!node2) {
      return;
    }
    var actions = o$4(node2, {
      boundary: menuNode,
      block: "nearest",
      scrollMode: "if-needed"
    });
    actions.forEach(function(_ref2) {
      var el = _ref2.el, top2 = _ref2.top, left2 = _ref2.left;
      el.scrollTop = top2;
      el.scrollLeft = left2;
    });
  }
  function isOrContainsNode(parent, child, environment) {
    var result = parent === child || child instanceof environment.Node && parent.contains && parent.contains(child);
    return result;
  }
  function debounce$5(fn2, time) {
    var timeoutId;
    function cancel() {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    }
    function wrapper() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      cancel();
      timeoutId = setTimeout(function() {
        timeoutId = null;
        fn2.apply(void 0, args);
      }, time);
    }
    wrapper.cancel = cancel;
    return wrapper;
  }
  function callAllEventHandlers() {
    for (var _len2 = arguments.length, fns = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      fns[_key2] = arguments[_key2];
    }
    return function(event2) {
      for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }
      return fns.some(function(fn2) {
        if (fn2) {
          fn2.apply(void 0, [event2].concat(args));
        }
        return event2.preventDownshiftDefault || event2.hasOwnProperty("nativeEvent") && event2.nativeEvent.preventDownshiftDefault;
      });
    };
  }
  function handleRefs() {
    for (var _len4 = arguments.length, refs = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      refs[_key4] = arguments[_key4];
    }
    return function(node2) {
      refs.forEach(function(ref) {
        if (typeof ref === "function") {
          ref(node2);
        } else if (ref) {
          ref.current = node2;
        }
      });
    };
  }
  function generateId() {
    return String(idCounter$2++);
  }
  function getA11yStatusMessage$1(_ref2) {
    var isOpen = _ref2.isOpen, resultCount = _ref2.resultCount, previousResultCount = _ref2.previousResultCount;
    if (!isOpen) {
      return "";
    }
    if (!resultCount) {
      return "No results are available.";
    }
    if (resultCount !== previousResultCount) {
      return resultCount + " result" + (resultCount === 1 ? " is" : "s are") + " available, use up and down arrow keys to navigate. Press Enter key to select.";
    }
    return "";
  }
  function getState(state, props) {
    return Object.keys(state).reduce(function(prevState, key) {
      prevState[key] = isControlledProp(props, key) ? props[key] : state[key];
      return prevState;
    }, {});
  }
  function isControlledProp(props, key) {
    return props[key] !== void 0;
  }
  function normalizeArrowKey(event2) {
    var key = event2.key, keyCode = event2.keyCode;
    if (keyCode >= 37 && keyCode <= 40 && key.indexOf("Arrow") !== 0) {
      return "Arrow" + key;
    }
    return key;
  }
  function getNextWrappingIndex(moveAmount, baseIndex, itemCount, getItemNodeFromIndex, circular2) {
    if (circular2 === void 0) {
      circular2 = true;
    }
    if (itemCount === 0) {
      return -1;
    }
    var itemsLastIndex = itemCount - 1;
    if (typeof baseIndex !== "number" || baseIndex < 0 || baseIndex >= itemCount) {
      baseIndex = moveAmount > 0 ? -1 : itemsLastIndex + 1;
    }
    var newIndex = baseIndex + moveAmount;
    if (newIndex < 0) {
      newIndex = circular2 ? itemsLastIndex : 0;
    } else if (newIndex > itemsLastIndex) {
      newIndex = circular2 ? 0 : itemsLastIndex;
    }
    var nonDisabledNewIndex = getNextNonDisabledIndex(moveAmount, newIndex, itemCount, getItemNodeFromIndex, circular2);
    if (nonDisabledNewIndex === -1) {
      return baseIndex >= itemCount ? -1 : baseIndex;
    }
    return nonDisabledNewIndex;
  }
  function getNextNonDisabledIndex(moveAmount, baseIndex, itemCount, getItemNodeFromIndex, circular2) {
    var currentElementNode = getItemNodeFromIndex(baseIndex);
    if (!currentElementNode || !currentElementNode.hasAttribute("disabled")) {
      return baseIndex;
    }
    if (moveAmount > 0) {
      for (var index2 = baseIndex + 1; index2 < itemCount; index2++) {
        if (!getItemNodeFromIndex(index2).hasAttribute("disabled")) {
          return index2;
        }
      }
    } else {
      for (var _index = baseIndex - 1; _index >= 0; _index--) {
        if (!getItemNodeFromIndex(_index).hasAttribute("disabled")) {
          return _index;
        }
      }
    }
    if (circular2) {
      return moveAmount > 0 ? getNextNonDisabledIndex(1, 0, itemCount, getItemNodeFromIndex, false) : getNextNonDisabledIndex(-1, itemCount - 1, itemCount, getItemNodeFromIndex, false);
    }
    return -1;
  }
  function targetWithinDownshift(target, downshiftElements, environment, checkActiveElement) {
    if (checkActiveElement === void 0) {
      checkActiveElement = true;
    }
    return downshiftElements.some(function(contextNode) {
      return contextNode && (isOrContainsNode(contextNode, target, environment) || checkActiveElement && isOrContainsNode(contextNode, environment.document.activeElement, environment));
    });
  }
  var cleanupStatus = debounce$5(function(documentProp) {
    getStatusDiv(documentProp).textContent = "";
  }, 500);
  function setStatus(status2, documentProp) {
    var div2 = getStatusDiv(documentProp);
    if (!status2) {
      return;
    }
    div2.textContent = status2;
    cleanupStatus(documentProp);
  }
  function getStatusDiv(documentProp) {
    if (documentProp === void 0) {
      documentProp = document;
    }
    var statusDiv = documentProp.getElementById("a11y-status-message");
    if (statusDiv) {
      return statusDiv;
    }
    statusDiv = documentProp.createElement("div");
    statusDiv.setAttribute("id", "a11y-status-message");
    statusDiv.setAttribute("role", "status");
    statusDiv.setAttribute("aria-live", "polite");
    statusDiv.setAttribute("aria-relevant", "additions text");
    Object.assign(statusDiv.style, {
      border: "0",
      clip: "rect(0 0 0 0)",
      height: "1px",
      margin: "-1px",
      overflow: "hidden",
      padding: "0",
      position: "absolute",
      width: "1px"
    });
    documentProp.body.appendChild(statusDiv);
    return statusDiv;
  }
  var _excluded$3 = ["isInitialMount", "highlightedIndex", "items", "environment"];
  var dropdownDefaultStateValues = {
    highlightedIndex: -1,
    isOpen: false,
    selectedItem: null,
    inputValue: ""
  };
  function callOnChangeProps(action, state, newState) {
    var props = action.props, type = action.type;
    var changes = {};
    Object.keys(state).forEach(function(key) {
      invokeOnChangeHandler(key, action, state, newState);
      if (newState[key] !== state[key]) {
        changes[key] = newState[key];
      }
    });
    if (props.onStateChange && Object.keys(changes).length) {
      props.onStateChange(_extends$2({
        type
      }, changes));
    }
  }
  function invokeOnChangeHandler(key, action, state, newState) {
    var props = action.props, type = action.type;
    var handler = "on" + capitalizeString(key) + "Change";
    if (props[handler] && newState[key] !== void 0 && newState[key] !== state[key]) {
      props[handler](_extends$2({
        type
      }, newState));
    }
  }
  function stateReducer(s2, a2) {
    return a2.changes;
  }
  function getA11ySelectionMessage(selectionParameters) {
    var selectedItem = selectionParameters.selectedItem, itemToStringLocal = selectionParameters.itemToString;
    return selectedItem ? itemToStringLocal(selectedItem) + " has been selected." : "";
  }
  var updateA11yStatus = debounce$5(function(getA11yMessage, document2) {
    setStatus(getA11yMessage(), document2);
  }, 200);
  var useIsomorphicLayoutEffect$4 = typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined" ? React.useLayoutEffect : React.useEffect;
  function useElementIds(_ref2) {
    var _ref$id = _ref2.id, id2 = _ref$id === void 0 ? "downshift-" + generateId() : _ref$id, labelId = _ref2.labelId, menuId = _ref2.menuId, getItemId = _ref2.getItemId, toggleButtonId = _ref2.toggleButtonId, inputId = _ref2.inputId;
    var elementIdsRef = React.useRef({
      labelId: labelId || id2 + "-label",
      menuId: menuId || id2 + "-menu",
      getItemId: getItemId || function(index2) {
        return id2 + "-item-" + index2;
      },
      toggleButtonId: toggleButtonId || id2 + "-toggle-button",
      inputId: inputId || id2 + "-input"
    });
    return elementIdsRef.current;
  }
  function getItemAndIndex(itemProp, indexProp, items, errorMessage) {
    var item, index2;
    if (itemProp === void 0) {
      if (indexProp === void 0) {
        throw new Error(errorMessage);
      }
      item = items[indexProp];
      index2 = indexProp;
    } else {
      index2 = indexProp === void 0 ? items.indexOf(itemProp) : indexProp;
      item = itemProp;
    }
    return [item, index2];
  }
  function itemToString(item) {
    return item ? String(item) : "";
  }
  function isAcceptedCharacterKey(key) {
    return /^\S{1}$/.test(key);
  }
  function capitalizeString(string2) {
    return "" + string2.slice(0, 1).toUpperCase() + string2.slice(1);
  }
  function useLatestRef(val) {
    var ref = React.useRef(val);
    ref.current = val;
    return ref;
  }
  function useEnhancedReducer(reducer2, initialState2, props) {
    var prevStateRef = React.useRef();
    var actionRef = React.useRef();
    var enhancedReducer = React.useCallback(function(state2, action2) {
      actionRef.current = action2;
      state2 = getState(state2, action2.props);
      var changes = reducer2(state2, action2);
      var newState = action2.props.stateReducer(state2, _extends$2({}, action2, {
        changes
      }));
      return newState;
    }, [reducer2]);
    var _useReducer = React.useReducer(enhancedReducer, initialState2), state = _useReducer[0], dispatch2 = _useReducer[1];
    var propsRef = useLatestRef(props);
    var dispatchWithProps = React.useCallback(function(action2) {
      return dispatch2(_extends$2({
        props: propsRef.current
      }, action2));
    }, [propsRef]);
    var action = actionRef.current;
    React.useEffect(function() {
      if (action && prevStateRef.current && prevStateRef.current !== state) {
        callOnChangeProps(action, getState(prevStateRef.current, action.props), state);
      }
      prevStateRef.current = state;
    }, [state, props, action]);
    return [state, dispatchWithProps];
  }
  function useControlledReducer$1(reducer2, initialState2, props) {
    var _useEnhancedReducer = useEnhancedReducer(reducer2, initialState2, props), state = _useEnhancedReducer[0], dispatch2 = _useEnhancedReducer[1];
    return [getState(state, props), dispatch2];
  }
  var defaultProps$3 = {
    itemToString,
    stateReducer,
    getA11ySelectionMessage,
    scrollIntoView: scrollIntoView$1,
    environment: typeof window === "undefined" ? {} : window
  };
  function getDefaultValue$1(props, propKey, defaultStateValues2) {
    if (defaultStateValues2 === void 0) {
      defaultStateValues2 = dropdownDefaultStateValues;
    }
    var defaultValue2 = props["default" + capitalizeString(propKey)];
    if (defaultValue2 !== void 0) {
      return defaultValue2;
    }
    return defaultStateValues2[propKey];
  }
  function getInitialValue$1(props, propKey, defaultStateValues2) {
    if (defaultStateValues2 === void 0) {
      defaultStateValues2 = dropdownDefaultStateValues;
    }
    var value = props[propKey];
    if (value !== void 0) {
      return value;
    }
    var initialValue = props["initial" + capitalizeString(propKey)];
    if (initialValue !== void 0) {
      return initialValue;
    }
    return getDefaultValue$1(props, propKey, defaultStateValues2);
  }
  function getInitialState$2(props) {
    var selectedItem = getInitialValue$1(props, "selectedItem");
    var isOpen = getInitialValue$1(props, "isOpen");
    var highlightedIndex = getInitialValue$1(props, "highlightedIndex");
    var inputValue = getInitialValue$1(props, "inputValue");
    return {
      highlightedIndex: highlightedIndex < 0 && selectedItem && isOpen ? props.items.indexOf(selectedItem) : highlightedIndex,
      isOpen,
      selectedItem,
      inputValue
    };
  }
  function getHighlightedIndexOnOpen(props, state, offset2) {
    var items = props.items, initialHighlightedIndex = props.initialHighlightedIndex, defaultHighlightedIndex = props.defaultHighlightedIndex;
    var selectedItem = state.selectedItem, highlightedIndex = state.highlightedIndex;
    if (items.length === 0) {
      return -1;
    }
    if (initialHighlightedIndex !== void 0 && highlightedIndex === initialHighlightedIndex) {
      return initialHighlightedIndex;
    }
    if (defaultHighlightedIndex !== void 0) {
      return defaultHighlightedIndex;
    }
    if (selectedItem) {
      return items.indexOf(selectedItem);
    }
    if (offset2 === 0) {
      return -1;
    }
    return offset2 < 0 ? items.length - 1 : 0;
  }
  function useMouseAndTouchTracker(isOpen, downshiftElementRefs, environment, handleBlur) {
    var mouseAndTouchTrackersRef = React.useRef({
      isMouseDown: false,
      isTouchMove: false
    });
    React.useEffect(function() {
      if ((environment == null ? void 0 : environment.addEventListener) == null) {
        return;
      }
      var onMouseDown = function onMouseDown2() {
        mouseAndTouchTrackersRef.current.isMouseDown = true;
      };
      var onMouseUp = function onMouseUp2(event2) {
        mouseAndTouchTrackersRef.current.isMouseDown = false;
        if (isOpen && !targetWithinDownshift(event2.target, downshiftElementRefs.map(function(ref) {
          return ref.current;
        }), environment)) {
          handleBlur();
        }
      };
      var onTouchStart = function onTouchStart2() {
        mouseAndTouchTrackersRef.current.isTouchMove = false;
      };
      var onTouchMove = function onTouchMove2() {
        mouseAndTouchTrackersRef.current.isTouchMove = true;
      };
      var onTouchEnd = function onTouchEnd2(event2) {
        if (isOpen && !mouseAndTouchTrackersRef.current.isTouchMove && !targetWithinDownshift(event2.target, downshiftElementRefs.map(function(ref) {
          return ref.current;
        }), environment, false)) {
          handleBlur();
        }
      };
      environment.addEventListener("mousedown", onMouseDown);
      environment.addEventListener("mouseup", onMouseUp);
      environment.addEventListener("touchstart", onTouchStart);
      environment.addEventListener("touchmove", onTouchMove);
      environment.addEventListener("touchend", onTouchEnd);
      return function cleanup() {
        environment.removeEventListener("mousedown", onMouseDown);
        environment.removeEventListener("mouseup", onMouseUp);
        environment.removeEventListener("touchstart", onTouchStart);
        environment.removeEventListener("touchmove", onTouchMove);
        environment.removeEventListener("touchend", onTouchEnd);
      };
    }, [isOpen, environment]);
    return mouseAndTouchTrackersRef;
  }
  var useGetterPropsCalledChecker = function useGetterPropsCalledChecker2() {
    return noop$5;
  };
  function useA11yMessageSetter(getA11yMessage, dependencyArray, _ref2) {
    var isInitialMount = _ref2.isInitialMount, highlightedIndex = _ref2.highlightedIndex, items = _ref2.items, environment = _ref2.environment, rest = _objectWithoutPropertiesLoose$5(_ref2, _excluded$3);
    React.useEffect(function() {
      if (isInitialMount || false) {
        return;
      }
      updateA11yStatus(function() {
        return getA11yMessage(_extends$2({
          highlightedIndex,
          highlightedItem: items[highlightedIndex],
          resultCount: items.length
        }, rest));
      }, environment.document);
    }, dependencyArray);
  }
  function useScrollIntoView(_ref3) {
    var highlightedIndex = _ref3.highlightedIndex, isOpen = _ref3.isOpen, itemRefs = _ref3.itemRefs, getItemNodeFromIndex = _ref3.getItemNodeFromIndex, menuElement = _ref3.menuElement, scrollIntoViewProp = _ref3.scrollIntoView;
    var shouldScrollRef = React.useRef(true);
    useIsomorphicLayoutEffect$4(function() {
      if (highlightedIndex < 0 || !isOpen || !Object.keys(itemRefs.current).length) {
        return;
      }
      if (shouldScrollRef.current === false) {
        shouldScrollRef.current = true;
      } else {
        scrollIntoViewProp(getItemNodeFromIndex(highlightedIndex), menuElement);
      }
    }, [highlightedIndex]);
    return shouldScrollRef;
  }
  var useControlPropsValidator = noop$5;
  function getChangesOnSelection(props, highlightedIndex, inputValue) {
    var _props$items;
    if (inputValue === void 0) {
      inputValue = true;
    }
    var shouldSelect = ((_props$items = props.items) == null ? void 0 : _props$items.length) && highlightedIndex >= 0;
    return _extends$2({
      isOpen: false,
      highlightedIndex: -1
    }, shouldSelect && _extends$2({
      selectedItem: props.items[highlightedIndex],
      isOpen: getDefaultValue$1(props, "isOpen"),
      highlightedIndex: getDefaultValue$1(props, "highlightedIndex")
    }, inputValue && {
      inputValue: props.itemToString(props.items[highlightedIndex])
    }));
  }
  function downshiftCommonReducer(state, action, stateChangeTypes2) {
    var type = action.type, props = action.props;
    var changes;
    switch (type) {
      case stateChangeTypes2.ItemMouseMove:
        changes = {
          highlightedIndex: action.disabled ? -1 : action.index
        };
        break;
      case stateChangeTypes2.MenuMouseLeave:
        changes = {
          highlightedIndex: -1
        };
        break;
      case stateChangeTypes2.ToggleButtonClick:
      case stateChangeTypes2.FunctionToggleMenu:
        changes = {
          isOpen: !state.isOpen,
          highlightedIndex: state.isOpen ? -1 : getHighlightedIndexOnOpen(props, state, 0)
        };
        break;
      case stateChangeTypes2.FunctionOpenMenu:
        changes = {
          isOpen: true,
          highlightedIndex: getHighlightedIndexOnOpen(props, state, 0)
        };
        break;
      case stateChangeTypes2.FunctionCloseMenu:
        changes = {
          isOpen: false
        };
        break;
      case stateChangeTypes2.FunctionSetHighlightedIndex:
        changes = {
          highlightedIndex: action.highlightedIndex
        };
        break;
      case stateChangeTypes2.FunctionSetInputValue:
        changes = {
          inputValue: action.inputValue
        };
        break;
      case stateChangeTypes2.FunctionReset:
        changes = {
          highlightedIndex: getDefaultValue$1(props, "highlightedIndex"),
          isOpen: getDefaultValue$1(props, "isOpen"),
          selectedItem: getDefaultValue$1(props, "selectedItem"),
          inputValue: getDefaultValue$1(props, "inputValue")
        };
        break;
      default:
        throw new Error("Reducer called without proper action type.");
    }
    return _extends$2({}, state, changes);
  }
  function getItemIndexByCharacterKey(_a3) {
    var keysSoFar = _a3.keysSoFar, highlightedIndex = _a3.highlightedIndex, items = _a3.items, itemToString2 = _a3.itemToString, getItemNodeFromIndex = _a3.getItemNodeFromIndex;
    var lowerCasedKeysSoFar = keysSoFar.toLowerCase();
    for (var index2 = 0; index2 < items.length; index2++) {
      var offsetIndex = (index2 + highlightedIndex + (keysSoFar.length < 2 ? 1 : 0)) % items.length;
      var item = items[offsetIndex];
      if (item !== void 0 && itemToString2(item).toLowerCase().startsWith(lowerCasedKeysSoFar)) {
        var element2 = getItemNodeFromIndex(offsetIndex);
        if (!(element2 === null || element2 === void 0 ? void 0 : element2.hasAttribute("disabled"))) {
          return offsetIndex;
        }
      }
    }
    return highlightedIndex;
  }
  ({
    items: propTypes.exports.array.isRequired,
    itemToString: propTypes.exports.func,
    getA11yStatusMessage: propTypes.exports.func,
    getA11ySelectionMessage: propTypes.exports.func,
    highlightedIndex: propTypes.exports.number,
    defaultHighlightedIndex: propTypes.exports.number,
    initialHighlightedIndex: propTypes.exports.number,
    isOpen: propTypes.exports.bool,
    defaultIsOpen: propTypes.exports.bool,
    initialIsOpen: propTypes.exports.bool,
    selectedItem: propTypes.exports.any,
    initialSelectedItem: propTypes.exports.any,
    defaultSelectedItem: propTypes.exports.any,
    id: propTypes.exports.string,
    labelId: propTypes.exports.string,
    menuId: propTypes.exports.string,
    getItemId: propTypes.exports.func,
    toggleButtonId: propTypes.exports.string,
    stateReducer: propTypes.exports.func,
    onSelectedItemChange: propTypes.exports.func,
    onHighlightedIndexChange: propTypes.exports.func,
    onStateChange: propTypes.exports.func,
    onIsOpenChange: propTypes.exports.func,
    environment: propTypes.exports.shape({
      addEventListener: propTypes.exports.func,
      removeEventListener: propTypes.exports.func,
      document: propTypes.exports.shape({
        getElementById: propTypes.exports.func,
        activeElement: propTypes.exports.any,
        body: propTypes.exports.any
      })
    })
  });
  function getA11yStatusMessage(_a3) {
    var isOpen = _a3.isOpen, resultCount = _a3.resultCount, previousResultCount = _a3.previousResultCount;
    if (!isOpen) {
      return "";
    }
    if (!resultCount) {
      return "No results are available.";
    }
    if (resultCount !== previousResultCount) {
      return "".concat(resultCount, " result").concat(resultCount === 1 ? " is" : "s are", " available, use up and down arrow keys to navigate. Press Enter or Space Bar keys to select.");
    }
    return "";
  }
  var defaultProps$2$1 = __assign(__assign({}, defaultProps$3), { getA11yStatusMessage });
  var ToggleButtonClick$1 = 0;
  var ToggleButtonKeyDownArrowDown = 1;
  var ToggleButtonKeyDownArrowUp = 2;
  var ToggleButtonKeyDownCharacter = 3;
  var ToggleButtonKeyDownEscape = 4;
  var ToggleButtonKeyDownHome = 5;
  var ToggleButtonKeyDownEnd = 6;
  var ToggleButtonKeyDownEnter = 7;
  var ToggleButtonKeyDownSpaceButton = 8;
  var ToggleButtonKeyDownPageUp = 9;
  var ToggleButtonKeyDownPageDown = 10;
  var ToggleButtonBlur = 11;
  var MenuMouseLeave$1 = 12;
  var ItemMouseMove$1 = 13;
  var ItemClick$1 = 14;
  var FunctionToggleMenu$1 = 15;
  var FunctionOpenMenu$1 = 16;
  var FunctionCloseMenu$1 = 17;
  var FunctionSetHighlightedIndex$1 = 18;
  var FunctionSelectItem$1 = 19;
  var FunctionSetInputValue$1 = 20;
  var FunctionReset$2 = 21;
  var stateChangeTypes$2$1 = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    ToggleButtonClick: ToggleButtonClick$1,
    ToggleButtonKeyDownArrowDown,
    ToggleButtonKeyDownArrowUp,
    ToggleButtonKeyDownCharacter,
    ToggleButtonKeyDownEscape,
    ToggleButtonKeyDownHome,
    ToggleButtonKeyDownEnd,
    ToggleButtonKeyDownEnter,
    ToggleButtonKeyDownSpaceButton,
    ToggleButtonKeyDownPageUp,
    ToggleButtonKeyDownPageDown,
    ToggleButtonBlur,
    MenuMouseLeave: MenuMouseLeave$1,
    ItemMouseMove: ItemMouseMove$1,
    ItemClick: ItemClick$1,
    FunctionToggleMenu: FunctionToggleMenu$1,
    FunctionOpenMenu: FunctionOpenMenu$1,
    FunctionCloseMenu: FunctionCloseMenu$1,
    FunctionSetHighlightedIndex: FunctionSetHighlightedIndex$1,
    FunctionSelectItem: FunctionSelectItem$1,
    FunctionSetInputValue: FunctionSetInputValue$1,
    FunctionReset: FunctionReset$2
  });
  function downshiftSelectReducer(state, action) {
    var _props$items;
    var type = action.type, props = action.props, altKey = action.altKey;
    var changes;
    switch (type) {
      case ItemClick$1:
        changes = {
          isOpen: getDefaultValue$1(props, "isOpen"),
          highlightedIndex: getDefaultValue$1(props, "highlightedIndex"),
          selectedItem: props.items[action.index]
        };
        break;
      case ToggleButtonKeyDownCharacter:
        {
          var lowercasedKey = action.key;
          var inputValue = "" + state.inputValue + lowercasedKey;
          var prevHighlightedIndex = !state.isOpen && state.selectedItem ? props.items.indexOf(state.selectedItem) : state.highlightedIndex;
          var highlightedIndex = getItemIndexByCharacterKey({
            keysSoFar: inputValue,
            highlightedIndex: prevHighlightedIndex,
            items: props.items,
            itemToString: props.itemToString,
            getItemNodeFromIndex: action.getItemNodeFromIndex
          });
          changes = {
            inputValue,
            highlightedIndex,
            isOpen: true
          };
        }
        break;
      case ToggleButtonKeyDownArrowDown:
        {
          var _highlightedIndex = state.isOpen ? getNextWrappingIndex(1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false) : altKey && state.selectedItem == null ? -1 : getHighlightedIndexOnOpen(props, state, 1);
          changes = {
            highlightedIndex: _highlightedIndex,
            isOpen: true
          };
        }
        break;
      case ToggleButtonKeyDownArrowUp:
        if (state.isOpen && altKey) {
          changes = getChangesOnSelection(props, state.highlightedIndex, false);
        } else {
          var _highlightedIndex2 = state.isOpen ? getNextWrappingIndex(-1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false) : getHighlightedIndexOnOpen(props, state, -1);
          changes = {
            highlightedIndex: _highlightedIndex2,
            isOpen: true
          };
        }
        break;
      case ToggleButtonKeyDownEnter:
      case ToggleButtonKeyDownSpaceButton:
        changes = getChangesOnSelection(props, state.highlightedIndex, false);
        break;
      case ToggleButtonKeyDownHome:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(1, 0, props.items.length, action.getItemNodeFromIndex, false),
          isOpen: true
        };
        break;
      case ToggleButtonKeyDownEnd:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(-1, props.items.length - 1, props.items.length, action.getItemNodeFromIndex, false),
          isOpen: true
        };
        break;
      case ToggleButtonKeyDownPageUp:
        changes = {
          highlightedIndex: getNextWrappingIndex(-10, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case ToggleButtonKeyDownPageDown:
        changes = {
          highlightedIndex: getNextWrappingIndex(10, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case ToggleButtonKeyDownEscape:
        changes = {
          isOpen: false,
          highlightedIndex: -1
        };
        break;
      case ToggleButtonBlur:
        changes = _extends$2({
          isOpen: false,
          highlightedIndex: -1
        }, state.highlightedIndex >= 0 && ((_props$items = props.items) == null ? void 0 : _props$items.length) && {
          selectedItem: props.items[state.highlightedIndex]
        });
        break;
      case FunctionSelectItem$1:
        changes = {
          selectedItem: action.selectedItem
        };
        break;
      default:
        return downshiftCommonReducer(state, action, stateChangeTypes$2$1);
    }
    return _extends$2({}, state, changes);
  }
  var _excluded$2 = ["onMouseLeave", "refKey", "onKeyDown", "onBlur", "ref"], _excluded2$2 = ["onBlur", "onClick", "onPress", "onKeyDown", "refKey", "ref"], _excluded3$1 = ["item", "index", "onMouseMove", "onClick", "onPress", "refKey", "ref", "disabled"];
  useSelect.stateChangeTypes = stateChangeTypes$2$1;
  function useSelect(userProps) {
    if (userProps === void 0) {
      userProps = {};
    }
    var props = _extends$2({}, defaultProps$2$1, userProps);
    var items = props.items, scrollIntoView2 = props.scrollIntoView, environment = props.environment, itemToString2 = props.itemToString, getA11ySelectionMessage2 = props.getA11ySelectionMessage, getA11yStatusMessage2 = props.getA11yStatusMessage;
    var initialState2 = getInitialState$2(props);
    var _useControlledReducer = useControlledReducer$1(downshiftSelectReducer, initialState2, props), state = _useControlledReducer[0], dispatch2 = _useControlledReducer[1];
    var isOpen = state.isOpen, highlightedIndex = state.highlightedIndex, selectedItem = state.selectedItem, inputValue = state.inputValue;
    var toggleButtonRef = React.useRef(null);
    var menuRef = React.useRef(null);
    var itemRefs = React.useRef({});
    var clearTimeoutRef = React.useRef(null);
    var elementIds = useElementIds(props);
    var previousResultCountRef = React.useRef();
    var isInitialMountRef = React.useRef(true);
    var latest = useLatestRef({
      state,
      props
    });
    var getItemNodeFromIndex = React.useCallback(function(index2) {
      return itemRefs.current[elementIds.getItemId(index2)];
    }, [elementIds]);
    useA11yMessageSetter(getA11yStatusMessage2, [isOpen, highlightedIndex, inputValue, items], _extends$2({
      isInitialMount: isInitialMountRef.current,
      previousResultCount: previousResultCountRef.current,
      items,
      environment,
      itemToString: itemToString2
    }, state));
    useA11yMessageSetter(getA11ySelectionMessage2, [selectedItem], _extends$2({
      isInitialMount: isInitialMountRef.current,
      previousResultCount: previousResultCountRef.current,
      items,
      environment,
      itemToString: itemToString2
    }, state));
    var shouldScrollRef = useScrollIntoView({
      menuElement: menuRef.current,
      highlightedIndex,
      isOpen,
      itemRefs,
      scrollIntoView: scrollIntoView2,
      getItemNodeFromIndex
    });
    React.useEffect(function() {
      clearTimeoutRef.current = debounce$5(function(outerDispatch) {
        outerDispatch({
          type: FunctionSetInputValue$1,
          inputValue: ""
        });
      }, 500);
      return function() {
        clearTimeoutRef.current.cancel();
      };
    }, []);
    React.useEffect(function() {
      if (!inputValue) {
        return;
      }
      clearTimeoutRef.current(dispatch2);
    }, [dispatch2, inputValue]);
    useControlPropsValidator({
      isInitialMount: isInitialMountRef.current,
      props,
      state
    });
    React.useEffect(function() {
      if (isInitialMountRef.current) {
        return;
      }
      previousResultCountRef.current = items.length;
    });
    var mouseAndTouchTrackersRef = useMouseAndTouchTracker(isOpen, [menuRef, toggleButtonRef], environment, function() {
      dispatch2({
        type: ToggleButtonBlur
      });
    });
    var setGetterPropCallInfo = useGetterPropsCalledChecker();
    React.useEffect(function() {
      isInitialMountRef.current = false;
      return function() {
        isInitialMountRef.current = true;
      };
    }, []);
    React.useEffect(function() {
      if (!isOpen) {
        itemRefs.current = {};
      }
    }, [isOpen]);
    var toggleButtonKeyDownHandlers = React.useMemo(function() {
      return {
        ArrowDown: function ArrowDown2(event2) {
          event2.preventDefault();
          dispatch2({
            type: ToggleButtonKeyDownArrowDown,
            getItemNodeFromIndex,
            altKey: event2.altKey
          });
        },
        ArrowUp: function ArrowUp2(event2) {
          event2.preventDefault();
          dispatch2({
            type: ToggleButtonKeyDownArrowUp,
            getItemNodeFromIndex,
            altKey: event2.altKey
          });
        },
        Home: function Home(event2) {
          event2.preventDefault();
          dispatch2({
            type: ToggleButtonKeyDownHome,
            getItemNodeFromIndex
          });
        },
        End: function End(event2) {
          event2.preventDefault();
          dispatch2({
            type: ToggleButtonKeyDownEnd,
            getItemNodeFromIndex
          });
        },
        Escape: function Escape() {
          if (latest.current.state.isOpen) {
            dispatch2({
              type: ToggleButtonKeyDownEscape
            });
          }
        },
        Enter: function Enter(event2) {
          event2.preventDefault();
          dispatch2({
            type: latest.current.state.isOpen ? ToggleButtonKeyDownEnter : ToggleButtonClick$1
          });
        },
        PageUp: function PageUp(event2) {
          if (latest.current.state.isOpen) {
            event2.preventDefault();
            dispatch2({
              type: ToggleButtonKeyDownPageUp,
              getItemNodeFromIndex
            });
          }
        },
        PageDown: function PageDown(event2) {
          if (latest.current.state.isOpen) {
            event2.preventDefault();
            dispatch2({
              type: ToggleButtonKeyDownPageDown,
              getItemNodeFromIndex
            });
          }
        },
        " ": function _2(event2) {
          event2.preventDefault();
          var currentState = latest.current.state;
          if (!currentState.isOpen) {
            dispatch2({
              type: ToggleButtonClick$1
            });
            return;
          }
          if (currentState.inputValue) {
            dispatch2({
              type: ToggleButtonKeyDownCharacter,
              key: " ",
              getItemNodeFromIndex
            });
          } else {
            dispatch2({
              type: ToggleButtonKeyDownSpaceButton
            });
          }
        }
      };
    }, [dispatch2, getItemNodeFromIndex, latest]);
    var toggleMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionToggleMenu$1
      });
    }, [dispatch2]);
    var closeMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionCloseMenu$1
      });
    }, [dispatch2]);
    var openMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionOpenMenu$1
      });
    }, [dispatch2]);
    var setHighlightedIndex = React.useCallback(function(newHighlightedIndex) {
      dispatch2({
        type: FunctionSetHighlightedIndex$1,
        highlightedIndex: newHighlightedIndex
      });
    }, [dispatch2]);
    var selectItem = React.useCallback(function(newSelectedItem) {
      dispatch2({
        type: FunctionSelectItem$1,
        selectedItem: newSelectedItem
      });
    }, [dispatch2]);
    var reset2 = React.useCallback(function() {
      dispatch2({
        type: FunctionReset$2
      });
    }, [dispatch2]);
    var setInputValue = React.useCallback(function(newInputValue) {
      dispatch2({
        type: FunctionSetInputValue$1,
        inputValue: newInputValue
      });
    }, [dispatch2]);
    var getLabelProps = React.useCallback(function(labelProps) {
      return _extends$2({
        id: elementIds.labelId,
        htmlFor: elementIds.toggleButtonId
      }, labelProps);
    }, [elementIds]);
    var getMenuProps = React.useCallback(function(_temp, _temp2) {
      var _extends2;
      var _ref2 = _temp === void 0 ? {} : _temp, onMouseLeave = _ref2.onMouseLeave, _ref$refKey = _ref2.refKey, refKey = _ref$refKey === void 0 ? "ref" : _ref$refKey;
      _ref2.onKeyDown;
      _ref2.onBlur;
      var ref = _ref2.ref, rest = _objectWithoutPropertiesLoose$5(_ref2, _excluded$2);
      var _ref22 = _temp2 === void 0 ? {} : _temp2;
      _ref22.suppressRefError;
      var menuHandleMouseLeave = function menuHandleMouseLeave2() {
        dispatch2({
          type: MenuMouseLeave$1
        });
      };
      return _extends$2((_extends2 = {}, _extends2[refKey] = handleRefs(ref, function(menuNode) {
        menuRef.current = menuNode;
      }), _extends2.id = elementIds.menuId, _extends2.role = "listbox", _extends2["aria-labelledby"] = rest && rest["aria-label"] ? void 0 : "" + elementIds.labelId, _extends2.onMouseLeave = callAllEventHandlers(onMouseLeave, menuHandleMouseLeave), _extends2), rest);
    }, [dispatch2, setGetterPropCallInfo, elementIds]);
    var getToggleButtonProps = React.useCallback(function(_temp3, _temp4) {
      var _extends3;
      var _ref3 = _temp3 === void 0 ? {} : _temp3, onBlur = _ref3.onBlur, onClick = _ref3.onClick;
      _ref3.onPress;
      var onKeyDown = _ref3.onKeyDown, _ref3$refKey = _ref3.refKey, refKey = _ref3$refKey === void 0 ? "ref" : _ref3$refKey, ref = _ref3.ref, rest = _objectWithoutPropertiesLoose$5(_ref3, _excluded2$2);
      var _ref4 = _temp4 === void 0 ? {} : _temp4;
      _ref4.suppressRefError;
      var latestState = latest.current.state;
      var toggleButtonHandleClick = function toggleButtonHandleClick2() {
        dispatch2({
          type: ToggleButtonClick$1
        });
      };
      var toggleButtonHandleBlur = function toggleButtonHandleBlur2() {
        if (latestState.isOpen && !mouseAndTouchTrackersRef.current.isMouseDown) {
          dispatch2({
            type: ToggleButtonBlur
          });
        }
      };
      var toggleButtonHandleKeyDown = function toggleButtonHandleKeyDown2(event2) {
        var key = normalizeArrowKey(event2);
        if (key && toggleButtonKeyDownHandlers[key]) {
          toggleButtonKeyDownHandlers[key](event2);
        } else if (isAcceptedCharacterKey(key)) {
          dispatch2({
            type: ToggleButtonKeyDownCharacter,
            key,
            getItemNodeFromIndex
          });
        }
      };
      var toggleProps = _extends$2((_extends3 = {}, _extends3[refKey] = handleRefs(ref, function(toggleButtonNode) {
        toggleButtonRef.current = toggleButtonNode;
      }), _extends3["aria-activedescendant"] = latestState.isOpen && latestState.highlightedIndex > -1 ? elementIds.getItemId(latestState.highlightedIndex) : "", _extends3["aria-controls"] = elementIds.menuId, _extends3["aria-expanded"] = latest.current.state.isOpen, _extends3["aria-haspopup"] = "listbox", _extends3["aria-labelledby"] = rest && rest["aria-label"] ? void 0 : "" + elementIds.labelId, _extends3.id = elementIds.toggleButtonId, _extends3.role = "combobox", _extends3.tabIndex = 0, _extends3.onBlur = callAllEventHandlers(onBlur, toggleButtonHandleBlur), _extends3), rest);
      if (!rest.disabled) {
        {
          toggleProps.onClick = callAllEventHandlers(onClick, toggleButtonHandleClick);
          toggleProps.onKeyDown = callAllEventHandlers(onKeyDown, toggleButtonHandleKeyDown);
        }
      }
      return toggleProps;
    }, [latest, elementIds, setGetterPropCallInfo, dispatch2, mouseAndTouchTrackersRef, toggleButtonKeyDownHandlers, getItemNodeFromIndex]);
    var getItemProps = React.useCallback(function(_temp5) {
      var _extends4;
      var _ref5 = _temp5 === void 0 ? {} : _temp5, itemProp = _ref5.item, indexProp = _ref5.index, onMouseMove = _ref5.onMouseMove, onClick = _ref5.onClick;
      _ref5.onPress;
      var _ref5$refKey = _ref5.refKey, refKey = _ref5$refKey === void 0 ? "ref" : _ref5$refKey, ref = _ref5.ref, disabled2 = _ref5.disabled, rest = _objectWithoutPropertiesLoose$5(_ref5, _excluded3$1);
      var _latest$current = latest.current, latestState = _latest$current.state, latestProps = _latest$current.props;
      var _getItemAndIndex = getItemAndIndex(itemProp, indexProp, latestProps.items, "Pass either item or index to getItemProps!"), item = _getItemAndIndex[0], index2 = _getItemAndIndex[1];
      var itemHandleMouseMove = function itemHandleMouseMove2() {
        if (index2 === latestState.highlightedIndex) {
          return;
        }
        shouldScrollRef.current = false;
        dispatch2({
          type: ItemMouseMove$1,
          index: index2,
          disabled: disabled2
        });
      };
      var itemHandleClick = function itemHandleClick2() {
        dispatch2({
          type: ItemClick$1,
          index: index2
        });
      };
      var itemProps = _extends$2((_extends4 = {
        disabled: disabled2,
        role: "option",
        "aria-selected": "" + (item === selectedItem),
        id: elementIds.getItemId(index2)
      }, _extends4[refKey] = handleRefs(ref, function(itemNode) {
        if (itemNode) {
          itemRefs.current[elementIds.getItemId(index2)] = itemNode;
        }
      }), _extends4), rest);
      if (!disabled2) {
        {
          itemProps.onClick = callAllEventHandlers(onClick, itemHandleClick);
        }
      }
      itemProps.onMouseMove = callAllEventHandlers(onMouseMove, itemHandleMouseMove);
      return itemProps;
    }, [latest, selectedItem, elementIds, shouldScrollRef, dispatch2]);
    return {
      getToggleButtonProps,
      getLabelProps,
      getMenuProps,
      getItemProps,
      toggleMenu,
      openMenu,
      closeMenu,
      setHighlightedIndex,
      selectItem,
      reset: reset2,
      setInputValue,
      highlightedIndex,
      isOpen,
      selectedItem,
      inputValue
    };
  }
  var InputKeyDownArrowDown = 0;
  var InputKeyDownArrowUp = 1;
  var InputKeyDownEscape = 2;
  var InputKeyDownHome = 3;
  var InputKeyDownEnd = 4;
  var InputKeyDownPageUp = 5;
  var InputKeyDownPageDown = 6;
  var InputKeyDownEnter = 7;
  var InputChange = 8;
  var InputBlur = 9;
  var InputFocus = 10;
  var MenuMouseLeave = 11;
  var ItemMouseMove = 12;
  var ItemClick = 13;
  var ToggleButtonClick = 14;
  var FunctionToggleMenu = 15;
  var FunctionOpenMenu = 16;
  var FunctionCloseMenu = 17;
  var FunctionSetHighlightedIndex = 18;
  var FunctionSelectItem = 19;
  var FunctionSetInputValue = 20;
  var FunctionReset$1 = 21;
  var ControlledPropUpdatedSelectedItem = 22;
  var stateChangeTypes$1$1 = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    InputKeyDownArrowDown,
    InputKeyDownArrowUp,
    InputKeyDownEscape,
    InputKeyDownHome,
    InputKeyDownEnd,
    InputKeyDownPageUp,
    InputKeyDownPageDown,
    InputKeyDownEnter,
    InputChange,
    InputBlur,
    InputFocus,
    MenuMouseLeave,
    ItemMouseMove,
    ItemClick,
    ToggleButtonClick,
    FunctionToggleMenu,
    FunctionOpenMenu,
    FunctionCloseMenu,
    FunctionSetHighlightedIndex,
    FunctionSelectItem,
    FunctionSetInputValue,
    FunctionReset: FunctionReset$1,
    ControlledPropUpdatedSelectedItem
  });
  function getInitialState$1(props) {
    var initialState2 = getInitialState$2(props);
    var selectedItem = initialState2.selectedItem;
    var inputValue = initialState2.inputValue;
    if (inputValue === "" && selectedItem && props.defaultInputValue === void 0 && props.initialInputValue === void 0 && props.inputValue === void 0) {
      inputValue = props.itemToString(selectedItem);
    }
    return _extends$2({}, initialState2, {
      inputValue
    });
  }
  ({
    items: propTypes.exports.array.isRequired,
    itemToString: propTypes.exports.func,
    selectedItemChanged: propTypes.exports.func,
    getA11yStatusMessage: propTypes.exports.func,
    getA11ySelectionMessage: propTypes.exports.func,
    highlightedIndex: propTypes.exports.number,
    defaultHighlightedIndex: propTypes.exports.number,
    initialHighlightedIndex: propTypes.exports.number,
    isOpen: propTypes.exports.bool,
    defaultIsOpen: propTypes.exports.bool,
    initialIsOpen: propTypes.exports.bool,
    selectedItem: propTypes.exports.any,
    initialSelectedItem: propTypes.exports.any,
    defaultSelectedItem: propTypes.exports.any,
    inputValue: propTypes.exports.string,
    defaultInputValue: propTypes.exports.string,
    initialInputValue: propTypes.exports.string,
    id: propTypes.exports.string,
    labelId: propTypes.exports.string,
    menuId: propTypes.exports.string,
    getItemId: propTypes.exports.func,
    inputId: propTypes.exports.string,
    toggleButtonId: propTypes.exports.string,
    stateReducer: propTypes.exports.func,
    onSelectedItemChange: propTypes.exports.func,
    onHighlightedIndexChange: propTypes.exports.func,
    onStateChange: propTypes.exports.func,
    onIsOpenChange: propTypes.exports.func,
    onInputValueChange: propTypes.exports.func,
    environment: propTypes.exports.shape({
      addEventListener: propTypes.exports.func,
      removeEventListener: propTypes.exports.func,
      document: propTypes.exports.shape({
        getElementById: propTypes.exports.func,
        activeElement: propTypes.exports.any,
        body: propTypes.exports.any
      })
    })
  });
  function useControlledReducer(reducer2, initialState2, props) {
    var previousSelectedItemRef = React.useRef();
    var _useEnhancedReducer = useEnhancedReducer(reducer2, initialState2, props), state = _useEnhancedReducer[0], dispatch2 = _useEnhancedReducer[1];
    React.useEffect(function() {
      if (!isControlledProp(props, "selectedItem")) {
        return;
      }
      if (props.selectedItemChanged(previousSelectedItemRef.current, props.selectedItem)) {
        dispatch2({
          type: ControlledPropUpdatedSelectedItem,
          inputValue: props.itemToString(props.selectedItem)
        });
      }
      previousSelectedItemRef.current = state.selectedItem === previousSelectedItemRef.current ? props.selectedItem : state.selectedItem;
    }, [state.selectedItem, props.selectedItem]);
    return [getState(state, props), dispatch2];
  }
  var defaultProps$1$1 = _extends$2({}, defaultProps$3, {
    selectedItemChanged: function selectedItemChanged(prevItem, item) {
      return prevItem !== item;
    },
    getA11yStatusMessage: getA11yStatusMessage$1
  });
  function downshiftUseComboboxReducer(state, action) {
    var _props$items;
    var type = action.type, props = action.props, altKey = action.altKey;
    var changes;
    switch (type) {
      case ItemClick:
        changes = {
          isOpen: getDefaultValue$1(props, "isOpen"),
          highlightedIndex: getDefaultValue$1(props, "highlightedIndex"),
          selectedItem: props.items[action.index],
          inputValue: props.itemToString(props.items[action.index])
        };
        break;
      case InputKeyDownArrowDown:
        if (state.isOpen) {
          changes = {
            highlightedIndex: getNextWrappingIndex(1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, true)
          };
        } else {
          changes = {
            highlightedIndex: altKey && state.selectedItem == null ? -1 : getHighlightedIndexOnOpen(props, state, 1, action.getItemNodeFromIndex),
            isOpen: props.items.length >= 0
          };
        }
        break;
      case InputKeyDownArrowUp:
        if (state.isOpen) {
          if (altKey) {
            changes = getChangesOnSelection(props, state.highlightedIndex);
          } else {
            changes = {
              highlightedIndex: getNextWrappingIndex(-1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, true)
            };
          }
        } else {
          changes = {
            highlightedIndex: getHighlightedIndexOnOpen(props, state, -1, action.getItemNodeFromIndex),
            isOpen: props.items.length >= 0
          };
        }
        break;
      case InputKeyDownEnter:
        changes = getChangesOnSelection(props, state.highlightedIndex);
        break;
      case InputKeyDownEscape:
        changes = _extends$2({
          isOpen: false,
          highlightedIndex: -1
        }, !state.isOpen && {
          selectedItem: null,
          inputValue: ""
        });
        break;
      case InputKeyDownPageUp:
        changes = {
          highlightedIndex: getNextWrappingIndex(-10, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case InputKeyDownPageDown:
        changes = {
          highlightedIndex: getNextWrappingIndex(10, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case InputKeyDownHome:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(1, 0, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case InputKeyDownEnd:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(-1, props.items.length - 1, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;
      case InputBlur:
        changes = _extends$2({
          isOpen: false,
          highlightedIndex: -1
        }, state.highlightedIndex >= 0 && ((_props$items = props.items) == null ? void 0 : _props$items.length) && action.selectItem && {
          selectedItem: props.items[state.highlightedIndex],
          inputValue: props.itemToString(props.items[state.highlightedIndex])
        });
        break;
      case InputChange:
        changes = {
          isOpen: true,
          highlightedIndex: getDefaultValue$1(props, "highlightedIndex"),
          inputValue: action.inputValue
        };
        break;
      case InputFocus:
        changes = {
          isOpen: true,
          highlightedIndex: getHighlightedIndexOnOpen(props, state, 0)
        };
        break;
      case FunctionSelectItem:
        changes = {
          selectedItem: action.selectedItem,
          inputValue: props.itemToString(action.selectedItem)
        };
        break;
      case ControlledPropUpdatedSelectedItem:
        changes = {
          inputValue: action.inputValue
        };
        break;
      default:
        return downshiftCommonReducer(state, action, stateChangeTypes$1$1);
    }
    return _extends$2({}, state, changes);
  }
  var _excluded$1$1 = ["onMouseLeave", "refKey", "ref"], _excluded2$1 = ["item", "index", "refKey", "ref", "onMouseMove", "onMouseDown", "onClick", "onPress", "disabled"], _excluded3 = ["onClick", "onPress", "refKey", "ref"], _excluded4 = ["onKeyDown", "onChange", "onInput", "onFocus", "onBlur", "onChangeText", "refKey", "ref"];
  useCombobox.stateChangeTypes = stateChangeTypes$1$1;
  function useCombobox(userProps) {
    if (userProps === void 0) {
      userProps = {};
    }
    var props = _extends$2({}, defaultProps$1$1, userProps);
    var initialIsOpen = props.initialIsOpen, defaultIsOpen = props.defaultIsOpen, items = props.items, scrollIntoView2 = props.scrollIntoView, environment = props.environment, getA11yStatusMessage2 = props.getA11yStatusMessage, getA11ySelectionMessage2 = props.getA11ySelectionMessage, itemToString2 = props.itemToString;
    var initialState2 = getInitialState$1(props);
    var _useControlledReducer = useControlledReducer(downshiftUseComboboxReducer, initialState2, props), state = _useControlledReducer[0], dispatch2 = _useControlledReducer[1];
    var isOpen = state.isOpen, highlightedIndex = state.highlightedIndex, selectedItem = state.selectedItem, inputValue = state.inputValue;
    var menuRef = React.useRef(null);
    var itemRefs = React.useRef({});
    var inputRef = React.useRef(null);
    var toggleButtonRef = React.useRef(null);
    var isInitialMountRef = React.useRef(true);
    var elementIds = useElementIds(props);
    var previousResultCountRef = React.useRef();
    var latest = useLatestRef({
      state,
      props
    });
    var getItemNodeFromIndex = React.useCallback(function(index2) {
      return itemRefs.current[elementIds.getItemId(index2)];
    }, [elementIds]);
    useA11yMessageSetter(getA11yStatusMessage2, [isOpen, highlightedIndex, inputValue, items], _extends$2({
      isInitialMount: isInitialMountRef.current,
      previousResultCount: previousResultCountRef.current,
      items,
      environment,
      itemToString: itemToString2
    }, state));
    useA11yMessageSetter(getA11ySelectionMessage2, [selectedItem], _extends$2({
      isInitialMount: isInitialMountRef.current,
      previousResultCount: previousResultCountRef.current,
      items,
      environment,
      itemToString: itemToString2
    }, state));
    var shouldScrollRef = useScrollIntoView({
      menuElement: menuRef.current,
      highlightedIndex,
      isOpen,
      itemRefs,
      scrollIntoView: scrollIntoView2,
      getItemNodeFromIndex
    });
    useControlPropsValidator({
      isInitialMount: isInitialMountRef.current,
      props,
      state
    });
    React.useEffect(function() {
      var focusOnOpen = initialIsOpen || defaultIsOpen || isOpen;
      if (focusOnOpen && inputRef.current) {
        inputRef.current.focus();
      }
    }, []);
    React.useEffect(function() {
      if (isInitialMountRef.current) {
        return;
      }
      previousResultCountRef.current = items.length;
    });
    var mouseAndTouchTrackersRef = useMouseAndTouchTracker(isOpen, [inputRef, menuRef, toggleButtonRef], environment, function() {
      dispatch2({
        type: InputBlur,
        selectItem: false
      });
    });
    var setGetterPropCallInfo = useGetterPropsCalledChecker();
    React.useEffect(function() {
      isInitialMountRef.current = false;
      return function() {
        isInitialMountRef.current = true;
      };
    }, []);
    React.useEffect(function() {
      var _environment$document;
      if (!isOpen) {
        itemRefs.current = {};
      } else if (((_environment$document = environment.document) == null ? void 0 : _environment$document.activeElement) !== inputRef.current) {
        var _inputRef$current;
        inputRef == null || (_inputRef$current = inputRef.current) == null ? void 0 : _inputRef$current.focus();
      }
    }, [isOpen, environment]);
    var inputKeyDownHandlers = React.useMemo(function() {
      return {
        ArrowDown: function ArrowDown2(event2) {
          event2.preventDefault();
          dispatch2({
            type: InputKeyDownArrowDown,
            altKey: event2.altKey,
            getItemNodeFromIndex
          });
        },
        ArrowUp: function ArrowUp2(event2) {
          event2.preventDefault();
          dispatch2({
            type: InputKeyDownArrowUp,
            altKey: event2.altKey,
            getItemNodeFromIndex
          });
        },
        Home: function Home(event2) {
          if (!latest.current.state.isOpen) {
            return;
          }
          event2.preventDefault();
          dispatch2({
            type: InputKeyDownHome,
            getItemNodeFromIndex
          });
        },
        End: function End(event2) {
          if (!latest.current.state.isOpen) {
            return;
          }
          event2.preventDefault();
          dispatch2({
            type: InputKeyDownEnd,
            getItemNodeFromIndex
          });
        },
        Escape: function Escape(event2) {
          var latestState = latest.current.state;
          if (latestState.isOpen || latestState.inputValue || latestState.selectedItem || latestState.highlightedIndex > -1) {
            event2.preventDefault();
            dispatch2({
              type: InputKeyDownEscape
            });
          }
        },
        Enter: function Enter(event2) {
          var latestState = latest.current.state;
          if (!latestState.isOpen || event2.which === 229) {
            return;
          }
          event2.preventDefault();
          dispatch2({
            type: InputKeyDownEnter,
            getItemNodeFromIndex
          });
        },
        PageUp: function PageUp(event2) {
          if (latest.current.state.isOpen) {
            event2.preventDefault();
            dispatch2({
              type: InputKeyDownPageUp,
              getItemNodeFromIndex
            });
          }
        },
        PageDown: function PageDown(event2) {
          if (latest.current.state.isOpen) {
            event2.preventDefault();
            dispatch2({
              type: InputKeyDownPageDown,
              getItemNodeFromIndex
            });
          }
        }
      };
    }, [dispatch2, latest, getItemNodeFromIndex]);
    var getLabelProps = React.useCallback(function(labelProps) {
      return _extends$2({
        id: elementIds.labelId,
        htmlFor: elementIds.inputId
      }, labelProps);
    }, [elementIds]);
    var getMenuProps = React.useCallback(function(_temp, _temp2) {
      var _extends2;
      var _ref2 = _temp === void 0 ? {} : _temp, onMouseLeave = _ref2.onMouseLeave, _ref$refKey = _ref2.refKey, refKey = _ref$refKey === void 0 ? "ref" : _ref$refKey, ref = _ref2.ref, rest = _objectWithoutPropertiesLoose$5(_ref2, _excluded$1$1);
      var _ref22 = _temp2 === void 0 ? {} : _temp2;
      _ref22.suppressRefError;
      return _extends$2((_extends2 = {}, _extends2[refKey] = handleRefs(ref, function(menuNode) {
        menuRef.current = menuNode;
      }), _extends2.id = elementIds.menuId, _extends2.role = "listbox", _extends2["aria-labelledby"] = rest && rest["aria-label"] ? void 0 : "" + elementIds.labelId, _extends2.onMouseLeave = callAllEventHandlers(onMouseLeave, function() {
        dispatch2({
          type: MenuMouseLeave
        });
      }), _extends2), rest);
    }, [dispatch2, setGetterPropCallInfo, elementIds]);
    var getItemProps = React.useCallback(function(_temp3) {
      var _extends3, _ref4;
      var _ref3 = _temp3 === void 0 ? {} : _temp3, itemProp = _ref3.item, indexProp = _ref3.index, _ref3$refKey = _ref3.refKey, refKey = _ref3$refKey === void 0 ? "ref" : _ref3$refKey, ref = _ref3.ref, onMouseMove = _ref3.onMouseMove, onMouseDown = _ref3.onMouseDown, onClick = _ref3.onClick;
      _ref3.onPress;
      var disabled2 = _ref3.disabled, rest = _objectWithoutPropertiesLoose$5(_ref3, _excluded2$1);
      var _latest$current = latest.current, latestProps = _latest$current.props, latestState = _latest$current.state;
      var _getItemAndIndex = getItemAndIndex(itemProp, indexProp, latestProps.items, "Pass either item or index to getItemProps!"), index2 = _getItemAndIndex[1];
      var onSelectKey = "onClick";
      var customClickHandler = onClick;
      var itemHandleMouseMove = function itemHandleMouseMove2() {
        if (index2 === latestState.highlightedIndex) {
          return;
        }
        shouldScrollRef.current = false;
        dispatch2({
          type: ItemMouseMove,
          index: index2,
          disabled: disabled2
        });
      };
      var itemHandleClick = function itemHandleClick2() {
        dispatch2({
          type: ItemClick,
          index: index2
        });
      };
      var itemHandleMouseDown = function itemHandleMouseDown2(e3) {
        return e3.preventDefault();
      };
      return _extends$2((_extends3 = {}, _extends3[refKey] = handleRefs(ref, function(itemNode) {
        if (itemNode) {
          itemRefs.current[elementIds.getItemId(index2)] = itemNode;
        }
      }), _extends3.disabled = disabled2, _extends3.role = "option", _extends3["aria-selected"] = "" + (index2 === latestState.highlightedIndex), _extends3.id = elementIds.getItemId(index2), _extends3), !disabled2 && (_ref4 = {}, _ref4[onSelectKey] = callAllEventHandlers(customClickHandler, itemHandleClick), _ref4), {
        onMouseMove: callAllEventHandlers(onMouseMove, itemHandleMouseMove),
        onMouseDown: callAllEventHandlers(onMouseDown, itemHandleMouseDown)
      }, rest);
    }, [dispatch2, latest, shouldScrollRef, elementIds]);
    var getToggleButtonProps = React.useCallback(function(_temp4) {
      var _extends4;
      var _ref5 = _temp4 === void 0 ? {} : _temp4, onClick = _ref5.onClick;
      _ref5.onPress;
      var _ref5$refKey = _ref5.refKey, refKey = _ref5$refKey === void 0 ? "ref" : _ref5$refKey, ref = _ref5.ref, rest = _objectWithoutPropertiesLoose$5(_ref5, _excluded3);
      var latestState = latest.current.state;
      var toggleButtonHandleClick = function toggleButtonHandleClick2() {
        dispatch2({
          type: ToggleButtonClick
        });
      };
      return _extends$2((_extends4 = {}, _extends4[refKey] = handleRefs(ref, function(toggleButtonNode) {
        toggleButtonRef.current = toggleButtonNode;
      }), _extends4["aria-controls"] = elementIds.menuId, _extends4["aria-expanded"] = latestState.isOpen, _extends4.id = elementIds.toggleButtonId, _extends4.tabIndex = -1, _extends4), !rest.disabled && _extends$2({}, {
        onClick: callAllEventHandlers(onClick, toggleButtonHandleClick)
      }), rest);
    }, [dispatch2, latest, elementIds]);
    var getInputProps = React.useCallback(function(_temp5, _temp6) {
      var _extends5;
      var _ref6 = _temp5 === void 0 ? {} : _temp5, onKeyDown = _ref6.onKeyDown, onChange2 = _ref6.onChange, onInput = _ref6.onInput, onFocus = _ref6.onFocus, onBlur = _ref6.onBlur;
      _ref6.onChangeText;
      var _ref6$refKey = _ref6.refKey, refKey = _ref6$refKey === void 0 ? "ref" : _ref6$refKey, ref = _ref6.ref, rest = _objectWithoutPropertiesLoose$5(_ref6, _excluded4);
      var _ref7 = _temp6 === void 0 ? {} : _temp6;
      _ref7.suppressRefError;
      var latestState = latest.current.state;
      var inputHandleKeyDown = function inputHandleKeyDown2(event2) {
        var key = normalizeArrowKey(event2);
        if (key && inputKeyDownHandlers[key]) {
          inputKeyDownHandlers[key](event2);
        }
      };
      var inputHandleChange = function inputHandleChange2(event2) {
        dispatch2({
          type: InputChange,
          inputValue: event2.target.value
        });
      };
      var inputHandleBlur = function inputHandleBlur2(event2) {
        if (latestState.isOpen && !mouseAndTouchTrackersRef.current.isMouseDown) {
          var isBlurByTabChange = event2.relatedTarget === null && environment.document.activeElement !== environment.document.body;
          dispatch2({
            type: InputBlur,
            selectItem: !isBlurByTabChange
          });
        }
      };
      var inputHandleFocus = function inputHandleFocus2() {
        if (!latestState.isOpen) {
          dispatch2({
            type: InputFocus
          });
        }
      };
      var onChangeKey = "onChange";
      var eventHandlers = {};
      if (!rest.disabled) {
        var _eventHandlers;
        eventHandlers = (_eventHandlers = {}, _eventHandlers[onChangeKey] = callAllEventHandlers(onChange2, onInput, inputHandleChange), _eventHandlers.onKeyDown = callAllEventHandlers(onKeyDown, inputHandleKeyDown), _eventHandlers.onBlur = callAllEventHandlers(onBlur, inputHandleBlur), _eventHandlers.onFocus = callAllEventHandlers(onFocus, inputHandleFocus), _eventHandlers);
      }
      return _extends$2((_extends5 = {}, _extends5[refKey] = handleRefs(ref, function(inputNode) {
        inputRef.current = inputNode;
      }), _extends5["aria-activedescendant"] = latestState.isOpen && latestState.highlightedIndex > -1 ? elementIds.getItemId(latestState.highlightedIndex) : "", _extends5["aria-autocomplete"] = "list", _extends5["aria-controls"] = elementIds.menuId, _extends5["aria-expanded"] = latestState.isOpen, _extends5["aria-labelledby"] = rest && rest["aria-label"] ? void 0 : "" + elementIds.labelId, _extends5.autoComplete = "off", _extends5.id = elementIds.inputId, _extends5.role = "combobox", _extends5.value = latestState.inputValue, _extends5), eventHandlers, rest);
    }, [setGetterPropCallInfo, latest, elementIds, inputKeyDownHandlers, dispatch2, mouseAndTouchTrackersRef, environment]);
    var toggleMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionToggleMenu
      });
    }, [dispatch2]);
    var closeMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionCloseMenu
      });
    }, [dispatch2]);
    var openMenu = React.useCallback(function() {
      dispatch2({
        type: FunctionOpenMenu
      });
    }, [dispatch2]);
    var setHighlightedIndex = React.useCallback(function(newHighlightedIndex) {
      dispatch2({
        type: FunctionSetHighlightedIndex,
        highlightedIndex: newHighlightedIndex
      });
    }, [dispatch2]);
    var selectItem = React.useCallback(function(newSelectedItem) {
      dispatch2({
        type: FunctionSelectItem,
        selectedItem: newSelectedItem
      });
    }, [dispatch2]);
    var setInputValue = React.useCallback(function(newInputValue) {
      dispatch2({
        type: FunctionSetInputValue,
        inputValue: newInputValue
      });
    }, [dispatch2]);
    var reset2 = React.useCallback(function() {
      dispatch2({
        type: FunctionReset$1
      });
    }, [dispatch2]);
    return {
      getItemProps,
      getLabelProps,
      getMenuProps,
      getInputProps,
      getToggleButtonProps,
      toggleMenu,
      openMenu,
      closeMenu,
      setHighlightedIndex,
      setInputValue,
      selectItem,
      reset: reset2,
      highlightedIndex,
      isOpen,
      selectedItem,
      inputValue
    };
  }
  var defaultStateValues = {
    activeIndex: -1,
    selectedItems: []
  };
  function getInitialValue$2(props, propKey) {
    return getInitialValue$1(props, propKey, defaultStateValues);
  }
  function getDefaultValue(props, propKey) {
    return getDefaultValue$1(props, propKey, defaultStateValues);
  }
  function getInitialState(props) {
    var activeIndex = getInitialValue$2(props, "activeIndex");
    var selectedItems = getInitialValue$2(props, "selectedItems");
    return {
      activeIndex,
      selectedItems
    };
  }
  function isKeyDownOperationPermitted(event2) {
    if (event2.shiftKey || event2.metaKey || event2.ctrlKey || event2.altKey) {
      return false;
    }
    var element2 = event2.target;
    if (element2 instanceof HTMLInputElement && element2.value !== "" && (element2.selectionStart !== 0 || element2.selectionEnd !== 0)) {
      return false;
    }
    return true;
  }
  function getA11yRemovalMessage(selectionParameters) {
    var removedSelectedItem = selectionParameters.removedSelectedItem, itemToStringLocal = selectionParameters.itemToString;
    return itemToStringLocal(removedSelectedItem) + " has been removed.";
  }
  ({
    selectedItems: propTypes.exports.array,
    initialSelectedItems: propTypes.exports.array,
    defaultSelectedItems: propTypes.exports.array,
    itemToString: propTypes.exports.func,
    getA11yRemovalMessage: propTypes.exports.func,
    stateReducer: propTypes.exports.func,
    activeIndex: propTypes.exports.number,
    initialActiveIndex: propTypes.exports.number,
    defaultActiveIndex: propTypes.exports.number,
    onActiveIndexChange: propTypes.exports.func,
    onSelectedItemsChange: propTypes.exports.func,
    keyNavigationNext: propTypes.exports.string,
    keyNavigationPrevious: propTypes.exports.string,
    environment: propTypes.exports.shape({
      addEventListener: propTypes.exports.func,
      removeEventListener: propTypes.exports.func,
      document: propTypes.exports.shape({
        getElementById: propTypes.exports.func,
        activeElement: propTypes.exports.any,
        body: propTypes.exports.any
      })
    })
  });
  var defaultProps$4 = {
    itemToString: defaultProps$3.itemToString,
    stateReducer: defaultProps$3.stateReducer,
    environment: defaultProps$3.environment,
    getA11yRemovalMessage,
    keyNavigationNext: "ArrowRight",
    keyNavigationPrevious: "ArrowLeft"
  };
  var SelectedItemClick = 0;
  var SelectedItemKeyDownDelete = 1;
  var SelectedItemKeyDownBackspace = 2;
  var SelectedItemKeyDownNavigationNext = 3;
  var SelectedItemKeyDownNavigationPrevious = 4;
  var DropdownKeyDownNavigationPrevious = 5;
  var DropdownKeyDownBackspace = 6;
  var DropdownClick = 7;
  var FunctionAddSelectedItem = 8;
  var FunctionRemoveSelectedItem = 9;
  var FunctionSetSelectedItems = 10;
  var FunctionSetActiveIndex = 11;
  var FunctionReset = 12;
  var stateChangeTypes$4 = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    SelectedItemClick,
    SelectedItemKeyDownDelete,
    SelectedItemKeyDownBackspace,
    SelectedItemKeyDownNavigationNext,
    SelectedItemKeyDownNavigationPrevious,
    DropdownKeyDownNavigationPrevious,
    DropdownKeyDownBackspace,
    DropdownClick,
    FunctionAddSelectedItem,
    FunctionRemoveSelectedItem,
    FunctionSetSelectedItems,
    FunctionSetActiveIndex,
    FunctionReset
  });
  function downshiftMultipleSelectionReducer(state, action) {
    var type = action.type, index2 = action.index, props = action.props, selectedItem = action.selectedItem;
    var activeIndex = state.activeIndex, selectedItems = state.selectedItems;
    var changes;
    switch (type) {
      case SelectedItemClick:
        changes = {
          activeIndex: index2
        };
        break;
      case SelectedItemKeyDownNavigationPrevious:
        changes = {
          activeIndex: activeIndex - 1 < 0 ? 0 : activeIndex - 1
        };
        break;
      case SelectedItemKeyDownNavigationNext:
        changes = {
          activeIndex: activeIndex + 1 >= selectedItems.length ? -1 : activeIndex + 1
        };
        break;
      case SelectedItemKeyDownBackspace:
      case SelectedItemKeyDownDelete: {
        if (activeIndex < 0) {
          break;
        }
        var newActiveIndex = activeIndex;
        if (selectedItems.length === 1) {
          newActiveIndex = -1;
        } else if (activeIndex === selectedItems.length - 1) {
          newActiveIndex = selectedItems.length - 2;
        }
        changes = _extends$2({
          selectedItems: [].concat(selectedItems.slice(0, activeIndex), selectedItems.slice(activeIndex + 1))
        }, {
          activeIndex: newActiveIndex
        });
        break;
      }
      case DropdownKeyDownNavigationPrevious:
        changes = {
          activeIndex: selectedItems.length - 1
        };
        break;
      case DropdownKeyDownBackspace:
        changes = {
          selectedItems: selectedItems.slice(0, selectedItems.length - 1)
        };
        break;
      case FunctionAddSelectedItem:
        changes = {
          selectedItems: [].concat(selectedItems, [selectedItem])
        };
        break;
      case DropdownClick:
        changes = {
          activeIndex: -1
        };
        break;
      case FunctionRemoveSelectedItem: {
        var _newActiveIndex = activeIndex;
        var selectedItemIndex = selectedItems.indexOf(selectedItem);
        if (selectedItemIndex < 0) {
          break;
        }
        if (selectedItems.length === 1) {
          _newActiveIndex = -1;
        } else if (selectedItemIndex === selectedItems.length - 1) {
          _newActiveIndex = selectedItems.length - 2;
        }
        changes = {
          selectedItems: [].concat(selectedItems.slice(0, selectedItemIndex), selectedItems.slice(selectedItemIndex + 1)),
          activeIndex: _newActiveIndex
        };
        break;
      }
      case FunctionSetSelectedItems: {
        var newSelectedItems = action.selectedItems;
        changes = {
          selectedItems: newSelectedItems
        };
        break;
      }
      case FunctionSetActiveIndex: {
        var _newActiveIndex2 = action.activeIndex;
        changes = {
          activeIndex: _newActiveIndex2
        };
        break;
      }
      case FunctionReset:
        changes = {
          activeIndex: getDefaultValue(props, "activeIndex"),
          selectedItems: getDefaultValue(props, "selectedItems")
        };
        break;
      default:
        throw new Error("Reducer called without proper action type.");
    }
    return _extends$2({}, state, changes);
  }
  var _excluded$4 = ["refKey", "ref", "onClick", "onKeyDown", "selectedItem", "index"], _excluded2 = ["refKey", "ref", "onKeyDown", "onClick", "preventKeyAction"];
  useMultipleSelection.stateChangeTypes = stateChangeTypes$4;
  function useMultipleSelection(userProps) {
    if (userProps === void 0) {
      userProps = {};
    }
    var props = _extends$2({}, defaultProps$4, userProps);
    var getA11yRemovalMessage2 = props.getA11yRemovalMessage, itemToString2 = props.itemToString, environment = props.environment, keyNavigationNext = props.keyNavigationNext, keyNavigationPrevious = props.keyNavigationPrevious;
    var _useControlledReducer = useControlledReducer$1(downshiftMultipleSelectionReducer, getInitialState(props), props), state = _useControlledReducer[0], dispatch2 = _useControlledReducer[1];
    var activeIndex = state.activeIndex, selectedItems = state.selectedItems;
    var isInitialMountRef = React.useRef(true);
    var dropdownRef = React.useRef(null);
    var previousSelectedItemsRef = React.useRef(selectedItems);
    var selectedItemRefs = React.useRef();
    selectedItemRefs.current = [];
    var latest = useLatestRef({
      state,
      props
    });
    React.useEffect(function() {
      if (isInitialMountRef.current || false) {
        return;
      }
      if (selectedItems.length < previousSelectedItemsRef.current.length) {
        var removedSelectedItem = previousSelectedItemsRef.current.find(function(item) {
          return selectedItems.indexOf(item) < 0;
        });
        setStatus(getA11yRemovalMessage2({
          itemToString: itemToString2,
          resultCount: selectedItems.length,
          removedSelectedItem,
          activeIndex,
          activeSelectedItem: selectedItems[activeIndex]
        }), environment.document);
      }
      previousSelectedItemsRef.current = selectedItems;
    }, [selectedItems.length]);
    React.useEffect(function() {
      if (isInitialMountRef.current) {
        return;
      }
      if (activeIndex === -1 && dropdownRef.current) {
        dropdownRef.current.focus();
      } else if (selectedItemRefs.current[activeIndex]) {
        selectedItemRefs.current[activeIndex].focus();
      }
    }, [activeIndex]);
    useControlPropsValidator({
      isInitialMount: isInitialMountRef.current,
      props,
      state
    });
    var setGetterPropCallInfo = useGetterPropsCalledChecker();
    React.useEffect(function() {
      isInitialMountRef.current = false;
      return function() {
        isInitialMountRef.current = true;
      };
    }, []);
    var selectedItemKeyDownHandlers = React.useMemo(function() {
      var _ref2;
      return _ref2 = {}, _ref2[keyNavigationPrevious] = function() {
        dispatch2({
          type: SelectedItemKeyDownNavigationPrevious
        });
      }, _ref2[keyNavigationNext] = function() {
        dispatch2({
          type: SelectedItemKeyDownNavigationNext
        });
      }, _ref2.Delete = function Delete() {
        dispatch2({
          type: SelectedItemKeyDownDelete
        });
      }, _ref2.Backspace = function Backspace() {
        dispatch2({
          type: SelectedItemKeyDownBackspace
        });
      }, _ref2;
    }, [dispatch2, keyNavigationNext, keyNavigationPrevious]);
    var dropdownKeyDownHandlers = React.useMemo(function() {
      var _ref2;
      return _ref2 = {}, _ref2[keyNavigationPrevious] = function(event2) {
        if (isKeyDownOperationPermitted(event2)) {
          dispatch2({
            type: DropdownKeyDownNavigationPrevious
          });
        }
      }, _ref2.Backspace = function Backspace(event2) {
        if (isKeyDownOperationPermitted(event2)) {
          dispatch2({
            type: DropdownKeyDownBackspace
          });
        }
      }, _ref2;
    }, [dispatch2, keyNavigationPrevious]);
    var getSelectedItemProps = React.useCallback(function(_temp) {
      var _extends2;
      var _ref3 = _temp === void 0 ? {} : _temp, _ref3$refKey = _ref3.refKey, refKey = _ref3$refKey === void 0 ? "ref" : _ref3$refKey, ref = _ref3.ref, onClick = _ref3.onClick, onKeyDown = _ref3.onKeyDown, selectedItemProp = _ref3.selectedItem, indexProp = _ref3.index, rest = _objectWithoutPropertiesLoose$5(_ref3, _excluded$4);
      var latestState = latest.current.state;
      var _getItemAndIndex = getItemAndIndex(selectedItemProp, indexProp, latestState.selectedItems, "Pass either item or index to getSelectedItemProps!"), index2 = _getItemAndIndex[1];
      var isFocusable = index2 > -1 && index2 === latestState.activeIndex;
      var selectedItemHandleClick = function selectedItemHandleClick2() {
        dispatch2({
          type: SelectedItemClick,
          index: index2
        });
      };
      var selectedItemHandleKeyDown = function selectedItemHandleKeyDown2(event2) {
        var key = normalizeArrowKey(event2);
        if (key && selectedItemKeyDownHandlers[key]) {
          selectedItemKeyDownHandlers[key](event2);
        }
      };
      return _extends$2((_extends2 = {}, _extends2[refKey] = handleRefs(ref, function(selectedItemNode) {
        if (selectedItemNode) {
          selectedItemRefs.current.push(selectedItemNode);
        }
      }), _extends2.tabIndex = isFocusable ? 0 : -1, _extends2.onClick = callAllEventHandlers(onClick, selectedItemHandleClick), _extends2.onKeyDown = callAllEventHandlers(onKeyDown, selectedItemHandleKeyDown), _extends2), rest);
    }, [dispatch2, latest, selectedItemKeyDownHandlers]);
    var getDropdownProps = React.useCallback(function(_temp2, _temp3) {
      var _extends3;
      var _ref4 = _temp2 === void 0 ? {} : _temp2, _ref4$refKey = _ref4.refKey, refKey = _ref4$refKey === void 0 ? "ref" : _ref4$refKey, ref = _ref4.ref, onKeyDown = _ref4.onKeyDown, onClick = _ref4.onClick, _ref4$preventKeyActio = _ref4.preventKeyAction, preventKeyAction = _ref4$preventKeyActio === void 0 ? false : _ref4$preventKeyActio, rest = _objectWithoutPropertiesLoose$5(_ref4, _excluded2);
      var _ref5 = _temp3 === void 0 ? {} : _temp3;
      _ref5.suppressRefError;
      var dropdownHandleKeyDown = function dropdownHandleKeyDown2(event2) {
        var key = normalizeArrowKey(event2);
        if (key && dropdownKeyDownHandlers[key]) {
          dropdownKeyDownHandlers[key](event2);
        }
      };
      var dropdownHandleClick = function dropdownHandleClick2() {
        dispatch2({
          type: DropdownClick
        });
      };
      return _extends$2((_extends3 = {}, _extends3[refKey] = handleRefs(ref, function(dropdownNode) {
        if (dropdownNode) {
          dropdownRef.current = dropdownNode;
        }
      }), _extends3), !preventKeyAction && {
        onKeyDown: callAllEventHandlers(onKeyDown, dropdownHandleKeyDown),
        onClick: callAllEventHandlers(onClick, dropdownHandleClick)
      }, rest);
    }, [dispatch2, dropdownKeyDownHandlers, setGetterPropCallInfo]);
    var addSelectedItem = React.useCallback(function(selectedItem) {
      dispatch2({
        type: FunctionAddSelectedItem,
        selectedItem
      });
    }, [dispatch2]);
    var removeSelectedItem = React.useCallback(function(selectedItem) {
      dispatch2({
        type: FunctionRemoveSelectedItem,
        selectedItem
      });
    }, [dispatch2]);
    var setSelectedItems = React.useCallback(function(newSelectedItems) {
      dispatch2({
        type: FunctionSetSelectedItems,
        selectedItems: newSelectedItems
      });
    }, [dispatch2]);
    var setActiveIndex = React.useCallback(function(newActiveIndex) {
      dispatch2({
        type: FunctionSetActiveIndex,
        activeIndex: newActiveIndex
      });
    }, [dispatch2]);
    var reset2 = React.useCallback(function() {
      dispatch2({
        type: FunctionReset
      });
    }, [dispatch2]);
    return {
      getSelectedItemProps,
      getDropdownProps,
      addSelectedItem,
      removeSelectedItem,
      setSelectedItems,
      setActiveIndex,
      reset: reset2,
      selectedItems,
      activeIndex
    };
  }
  var fromEntries$1 = function fromEntries2(entries) {
    return entries.reduce(function(acc, _ref2) {
      var key = _ref2[0], value = _ref2[1];
      acc[key] = value;
      return acc;
    }, {});
  };
  var useIsomorphicLayoutEffect$3 = typeof window !== "undefined" && window.document && window.document.createElement ? React__namespace.useLayoutEffect : React__namespace.useEffect;
  function getBoundingClientRect$1(element2) {
    var rect = element2.getBoundingClientRect();
    return {
      width: rect.width,
      height: rect.height,
      top: rect.top,
      right: rect.right,
      bottom: rect.bottom,
      left: rect.left,
      x: rect.left,
      y: rect.top
    };
  }
  function getWindow$1(node2) {
    if (node2.toString() !== "[object Window]") {
      var ownerDocument = node2.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView : window;
    }
    return node2;
  }
  function getWindowScroll$1(node2) {
    var win = getWindow$1(node2);
    var scrollLeft = win.pageXOffset;
    var scrollTop = win.pageYOffset;
    return {
      scrollLeft,
      scrollTop
    };
  }
  function isElement$4(node2) {
    var OwnElement = getWindow$1(node2).Element;
    return node2 instanceof OwnElement || node2 instanceof Element;
  }
  function isHTMLElement$1(node2) {
    var OwnElement = getWindow$1(node2).HTMLElement;
    return node2 instanceof OwnElement || node2 instanceof HTMLElement;
  }
  function getHTMLElementScroll$1(element2) {
    return {
      scrollLeft: element2.scrollLeft,
      scrollTop: element2.scrollTop
    };
  }
  function getNodeScroll$1(node2) {
    if (node2 === getWindow$1(node2) || !isHTMLElement$1(node2)) {
      return getWindowScroll$1(node2);
    } else {
      return getHTMLElementScroll$1(node2);
    }
  }
  function getNodeName$1(element2) {
    return element2 ? (element2.nodeName || "").toLowerCase() : null;
  }
  function getDocumentElement$1(element2) {
    return (isElement$4(element2) ? element2.ownerDocument : element2.document).documentElement;
  }
  function getWindowScrollBarX$1(element2) {
    return getBoundingClientRect$1(getDocumentElement$1(element2)).left + getWindowScroll$1(element2).scrollLeft;
  }
  function getComputedStyle$2(element2) {
    return getWindow$1(element2).getComputedStyle(element2);
  }
  function isScrollParent$1(element2) {
    var _getComputedStyle = getComputedStyle$2(element2), overflow = _getComputedStyle.overflow, overflowX = _getComputedStyle.overflowX, overflowY = _getComputedStyle.overflowY;
    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
  }
  function getCompositeRect$1(elementOrVirtualElement, offsetParent, isFixed) {
    if (isFixed === void 0) {
      isFixed = false;
    }
    var documentElement = getDocumentElement$1(offsetParent);
    var rect = getBoundingClientRect$1(elementOrVirtualElement);
    var scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    var offsets = {
      x: 0,
      y: 0
    };
    if (!isFixed) {
      if (getNodeName$1(offsetParent) !== "body" || isScrollParent$1(documentElement)) {
        scroll = getNodeScroll$1(offsetParent);
      }
      if (isHTMLElement$1(offsetParent)) {
        offsets = getBoundingClientRect$1(offsetParent);
        offsets.x += offsetParent.clientLeft;
        offsets.y += offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX$1(documentElement);
      }
    }
    return {
      x: rect.left + scroll.scrollLeft - offsets.x,
      y: rect.top + scroll.scrollTop - offsets.y,
      width: rect.width,
      height: rect.height
    };
  }
  function getLayoutRect$1(element2) {
    return {
      x: element2.offsetLeft,
      y: element2.offsetTop,
      width: element2.offsetWidth,
      height: element2.offsetHeight
    };
  }
  function getParentNode$1(element2) {
    if (getNodeName$1(element2) === "html") {
      return element2;
    }
    return element2.assignedSlot || element2.parentNode || element2.host || getDocumentElement$1(element2);
  }
  function getScrollParent$1(node2) {
    if (["html", "body", "#document"].indexOf(getNodeName$1(node2)) >= 0) {
      return node2.ownerDocument.body;
    }
    if (isHTMLElement$1(node2) && isScrollParent$1(node2)) {
      return node2;
    }
    return getScrollParent$1(getParentNode$1(node2));
  }
  function listScrollParents$1(element2, list2) {
    if (list2 === void 0) {
      list2 = [];
    }
    var scrollParent = getScrollParent$1(element2);
    var isBody = getNodeName$1(scrollParent) === "body";
    var win = getWindow$1(scrollParent);
    var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent$1(scrollParent) ? scrollParent : []) : scrollParent;
    var updatedList = list2.concat(target);
    return isBody ? updatedList : updatedList.concat(listScrollParents$1(getParentNode$1(target)));
  }
  function isTableElement$1(element2) {
    return ["table", "td", "th"].indexOf(getNodeName$1(element2)) >= 0;
  }
  function getTrueOffsetParent$1(element2) {
    if (!isHTMLElement$1(element2) || getComputedStyle$2(element2).position === "fixed") {
      return null;
    }
    return element2.offsetParent;
  }
  function getOffsetParent$1(element2) {
    var window2 = getWindow$1(element2);
    var offsetParent = getTrueOffsetParent$1(element2);
    while (offsetParent && isTableElement$1(offsetParent)) {
      offsetParent = getTrueOffsetParent$1(offsetParent);
    }
    if (offsetParent && getNodeName$1(offsetParent) === "body" && getComputedStyle$2(offsetParent).position === "static") {
      return window2;
    }
    return offsetParent || window2;
  }
  var top$2 = "top";
  var bottom$1 = "bottom";
  var right$1 = "right";
  var left$1 = "left";
  var auto$1 = "auto";
  var basePlacements$1 = [top$2, bottom$1, right$1, left$1];
  var start$2 = "start";
  var end$1 = "end";
  var clippingParents$1 = "clippingParents";
  var viewport$1 = "viewport";
  var popper$1 = "popper";
  var reference$1 = "reference";
  var variationPlacements$1 = /* @__PURE__ */ basePlacements$1.reduce(function(acc, placement) {
    return acc.concat([placement + "-" + start$2, placement + "-" + end$1]);
  }, []);
  var placements$1 = /* @__PURE__ */ [].concat(basePlacements$1, [auto$1]).reduce(function(acc, placement) {
    return acc.concat([placement, placement + "-" + start$2, placement + "-" + end$1]);
  }, []);
  var beforeRead$1 = "beforeRead";
  var read$1 = "read";
  var afterRead$1 = "afterRead";
  var beforeMain$1 = "beforeMain";
  var main$4 = "main";
  var afterMain$1 = "afterMain";
  var beforeWrite$1 = "beforeWrite";
  var write$1 = "write";
  var afterWrite$1 = "afterWrite";
  var modifierPhases$1 = [beforeRead$1, read$1, afterRead$1, beforeMain$1, main$4, afterMain$1, beforeWrite$1, write$1, afterWrite$1];
  function order$2(modifiers2) {
    var map2 = /* @__PURE__ */ new Map();
    var visited = /* @__PURE__ */ new Set();
    var result = [];
    modifiers2.forEach(function(modifier) {
      map2.set(modifier.name, modifier);
    });
    function sort2(modifier) {
      visited.add(modifier.name);
      var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
      requires.forEach(function(dep) {
        if (!visited.has(dep)) {
          var depModifier = map2.get(dep);
          if (depModifier) {
            sort2(depModifier);
          }
        }
      });
      result.push(modifier);
    }
    modifiers2.forEach(function(modifier) {
      if (!visited.has(modifier.name)) {
        sort2(modifier);
      }
    });
    return result;
  }
  function orderModifiers$1(modifiers2) {
    var orderedModifiers = order$2(modifiers2);
    return modifierPhases$1.reduce(function(acc, phase) {
      return acc.concat(orderedModifiers.filter(function(modifier) {
        return modifier.phase === phase;
      }));
    }, []);
  }
  function debounce$4(fn2) {
    var pending;
    return function() {
      if (!pending) {
        pending = new Promise(function(resolve2) {
          Promise.resolve().then(function() {
            pending = void 0;
            resolve2(fn2());
          });
        });
      }
      return pending;
    };
  }
  function getBasePlacement$3(placement) {
    return placement.split("-")[0];
  }
  function mergeByName$1(modifiers2) {
    var merged = modifiers2.reduce(function(merged2, current) {
      var existing = merged2[current.name];
      merged2[current.name] = existing ? Object.assign({}, existing, {}, current, {
        options: Object.assign({}, existing.options, {}, current.options),
        data: Object.assign({}, existing.data, {}, current.data)
      }) : current;
      return merged2;
    }, {});
    return Object.keys(merged).map(function(key) {
      return merged[key];
    });
  }
  var DEFAULT_OPTIONS$2 = {
    placement: "bottom",
    modifiers: [],
    strategy: "absolute"
  };
  function areValidElements$1() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return !args.some(function(element2) {
      return !(element2 && typeof element2.getBoundingClientRect === "function");
    });
  }
  function popperGenerator$1(generatorOptions) {
    if (generatorOptions === void 0) {
      generatorOptions = {};
    }
    var _generatorOptions = generatorOptions, _generatorOptions$def = _generatorOptions.defaultModifiers, defaultModifiers2 = _generatorOptions$def === void 0 ? [] : _generatorOptions$def, _generatorOptions$def2 = _generatorOptions.defaultOptions, defaultOptions2 = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS$2 : _generatorOptions$def2;
    return function createPopper2(reference2, popper2, options) {
      if (options === void 0) {
        options = defaultOptions2;
      }
      var state = {
        placement: "bottom",
        orderedModifiers: [],
        options: Object.assign({}, DEFAULT_OPTIONS$2, {}, defaultOptions2),
        modifiersData: {},
        elements: {
          reference: reference2,
          popper: popper2
        },
        attributes: {},
        styles: {}
      };
      var effectCleanupFns = [];
      var isDestroyed = false;
      var instance2 = {
        state,
        setOptions: function setOptions2(options2) {
          cleanupModifierEffects();
          state.options = Object.assign({}, defaultOptions2, {}, state.options, {}, options2);
          state.scrollParents = {
            reference: isElement$4(reference2) ? listScrollParents$1(reference2) : reference2.contextElement ? listScrollParents$1(reference2.contextElement) : [],
            popper: listScrollParents$1(popper2)
          };
          var orderedModifiers = orderModifiers$1(mergeByName$1([].concat(defaultModifiers2, state.options.modifiers)));
          state.orderedModifiers = orderedModifiers.filter(function(m2) {
            return m2.enabled;
          });
          runModifierEffects();
          return instance2.update();
        },
        forceUpdate: function forceUpdate() {
          if (isDestroyed) {
            return;
          }
          var _state$elements = state.elements, reference3 = _state$elements.reference, popper3 = _state$elements.popper;
          if (!areValidElements$1(reference3, popper3)) {
            return;
          }
          state.rects = {
            reference: getCompositeRect$1(reference3, getOffsetParent$1(popper3), state.options.strategy === "fixed"),
            popper: getLayoutRect$1(popper3)
          };
          state.reset = false;
          state.placement = state.options.placement;
          state.orderedModifiers.forEach(function(modifier) {
            return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
          });
          for (var index2 = 0; index2 < state.orderedModifiers.length; index2++) {
            if (state.reset === true) {
              state.reset = false;
              index2 = -1;
              continue;
            }
            var _state$orderedModifie = state.orderedModifiers[index2], fn2 = _state$orderedModifie.fn, _state$orderedModifie2 = _state$orderedModifie.options, _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2, name2 = _state$orderedModifie.name;
            if (typeof fn2 === "function") {
              state = fn2({
                state,
                options: _options,
                name: name2,
                instance: instance2
              }) || state;
            }
          }
        },
        update: debounce$4(function() {
          return new Promise(function(resolve2) {
            instance2.forceUpdate();
            resolve2(state);
          });
        }),
        destroy: function destroy() {
          cleanupModifierEffects();
          isDestroyed = true;
        }
      };
      if (!areValidElements$1(reference2, popper2)) {
        return instance2;
      }
      instance2.setOptions(options).then(function(state2) {
        if (!isDestroyed && options.onFirstUpdate) {
          options.onFirstUpdate(state2);
        }
      });
      function runModifierEffects() {
        state.orderedModifiers.forEach(function(_ref3) {
          var name2 = _ref3.name, _ref3$options = _ref3.options, options2 = _ref3$options === void 0 ? {} : _ref3$options, effect2 = _ref3.effect;
          if (typeof effect2 === "function") {
            var cleanupFn = effect2({
              state,
              name: name2,
              instance: instance2,
              options: options2
            });
            var noopFn = function noopFn2() {
            };
            effectCleanupFns.push(cleanupFn || noopFn);
          }
        });
      }
      function cleanupModifierEffects() {
        effectCleanupFns.forEach(function(fn2) {
          return fn2();
        });
        effectCleanupFns = [];
      }
      return instance2;
    };
  }
  var passive$1 = {
    passive: true
  };
  function effect$5(_ref2) {
    var state = _ref2.state, instance2 = _ref2.instance, options = _ref2.options;
    var _options$scroll = options.scroll, scroll = _options$scroll === void 0 ? true : _options$scroll, _options$resize = options.resize, resize = _options$resize === void 0 ? true : _options$resize;
    var window2 = getWindow$1(state.elements.popper);
    var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);
    if (scroll) {
      scrollParents.forEach(function(scrollParent) {
        scrollParent.addEventListener("scroll", instance2.update, passive$1);
      });
    }
    if (resize) {
      window2.addEventListener("resize", instance2.update, passive$1);
    }
    return function() {
      if (scroll) {
        scrollParents.forEach(function(scrollParent) {
          scrollParent.removeEventListener("scroll", instance2.update, passive$1);
        });
      }
      if (resize) {
        window2.removeEventListener("resize", instance2.update, passive$1);
      }
    };
  }
  const eventListeners$1 = {
    name: "eventListeners",
    enabled: true,
    phase: "write",
    fn: function fn2() {
    },
    effect: effect$5,
    data: {}
  };
  function getVariation$1(placement) {
    return placement.split("-")[1];
  }
  function getMainAxisFromPlacement$1(placement) {
    return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
  }
  function computeOffsets$1(_ref2) {
    var reference2 = _ref2.reference, element2 = _ref2.element, placement = _ref2.placement;
    var basePlacement = placement ? getBasePlacement$3(placement) : null;
    var variation = placement ? getVariation$1(placement) : null;
    var commonX = reference2.x + reference2.width / 2 - element2.width / 2;
    var commonY = reference2.y + reference2.height / 2 - element2.height / 2;
    var offsets;
    switch (basePlacement) {
      case top$2:
        offsets = {
          x: commonX,
          y: reference2.y - element2.height
        };
        break;
      case bottom$1:
        offsets = {
          x: commonX,
          y: reference2.y + reference2.height
        };
        break;
      case right$1:
        offsets = {
          x: reference2.x + reference2.width,
          y: commonY
        };
        break;
      case left$1:
        offsets = {
          x: reference2.x - element2.width,
          y: commonY
        };
        break;
      default:
        offsets = {
          x: reference2.x,
          y: reference2.y
        };
    }
    var mainAxis = basePlacement ? getMainAxisFromPlacement$1(basePlacement) : null;
    if (mainAxis != null) {
      var len = mainAxis === "y" ? "height" : "width";
      switch (variation) {
        case start$2:
          offsets[mainAxis] = Math.floor(offsets[mainAxis]) - Math.floor(reference2[len] / 2 - element2[len] / 2);
          break;
        case end$1:
          offsets[mainAxis] = Math.floor(offsets[mainAxis]) + Math.ceil(reference2[len] / 2 - element2[len] / 2);
          break;
      }
    }
    return offsets;
  }
  function popperOffsets$2(_ref2) {
    var state = _ref2.state, name2 = _ref2.name;
    state.modifiersData[name2] = computeOffsets$1({
      reference: state.rects.reference,
      element: state.rects.popper,
      strategy: "absolute",
      placement: state.placement
    });
  }
  const popperOffsets$3 = {
    name: "popperOffsets",
    enabled: true,
    phase: "read",
    fn: popperOffsets$2,
    data: {}
  };
  var unsetSides$1 = {
    top: "auto",
    right: "auto",
    bottom: "auto",
    left: "auto"
  };
  function roundOffsets(_ref2) {
    var x2 = _ref2.x, y2 = _ref2.y;
    var win = window;
    var dpr = win.devicePixelRatio || 1;
    return {
      x: Math.round(x2 * dpr) / dpr || 0,
      y: Math.round(y2 * dpr) / dpr || 0
    };
  }
  function mapToStyles$1(_ref2) {
    var _Object$assign2;
    var popper2 = _ref2.popper, popperRect = _ref2.popperRect, placement = _ref2.placement, offsets = _ref2.offsets, position2 = _ref2.position, gpuAcceleration = _ref2.gpuAcceleration, adaptive = _ref2.adaptive;
    var _roundOffsets = roundOffsets(offsets), x2 = _roundOffsets.x, y2 = _roundOffsets.y;
    var hasX = offsets.hasOwnProperty("x");
    var hasY = offsets.hasOwnProperty("y");
    var sideX = left$1;
    var sideY = top$2;
    var win = window;
    if (adaptive) {
      var offsetParent = getOffsetParent$1(popper2);
      if (offsetParent === getWindow$1(popper2)) {
        offsetParent = getDocumentElement$1(popper2);
      }
      if (placement === top$2) {
        sideY = bottom$1;
        y2 -= offsetParent.clientHeight - popperRect.height;
        y2 *= gpuAcceleration ? 1 : -1;
      }
      if (placement === left$1) {
        sideX = right$1;
        x2 -= offsetParent.clientWidth - popperRect.width;
        x2 *= gpuAcceleration ? 1 : -1;
      }
    }
    var commonStyles = Object.assign({
      position: position2
    }, adaptive && unsetSides$1);
    if (gpuAcceleration) {
      var _Object$assign;
      return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? "0" : "", _Object$assign[sideX] = hasX ? "0" : "", _Object$assign.transform = (win.devicePixelRatio || 1) < 2 ? "translate(" + x2 + "px, " + y2 + "px)" : "translate3d(" + x2 + "px, " + y2 + "px, 0)", _Object$assign));
    }
    return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y2 + "px" : "", _Object$assign2[sideX] = hasX ? x2 + "px" : "", _Object$assign2.transform = "", _Object$assign2));
  }
  function computeStyles$2(_ref3) {
    var state = _ref3.state, options = _ref3.options;
    var _options$gpuAccelerat = options.gpuAcceleration, gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat, _options$adaptive = options.adaptive, adaptive = _options$adaptive === void 0 ? true : _options$adaptive;
    var commonStyles = {
      placement: getBasePlacement$3(state.placement),
      popper: state.elements.popper,
      popperRect: state.rects.popper,
      gpuAcceleration
    };
    if (state.modifiersData.popperOffsets != null) {
      state.styles.popper = Object.assign({}, state.styles.popper, {}, mapToStyles$1(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.popperOffsets,
        position: state.options.strategy,
        adaptive
      })));
    }
    if (state.modifiersData.arrow != null) {
      state.styles.arrow = Object.assign({}, state.styles.arrow, {}, mapToStyles$1(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.arrow,
        position: "absolute",
        adaptive: false
      })));
    }
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-placement": state.placement
    });
  }
  const computeStyles$3 = {
    name: "computeStyles",
    enabled: true,
    phase: "beforeWrite",
    fn: computeStyles$2,
    data: {}
  };
  function applyStyles$2(_ref2) {
    var state = _ref2.state;
    Object.keys(state.elements).forEach(function(name2) {
      var style2 = state.styles[name2] || {};
      var attributes2 = state.attributes[name2] || {};
      var element2 = state.elements[name2];
      if (!isHTMLElement$1(element2) || !getNodeName$1(element2)) {
        return;
      }
      Object.assign(element2.style, style2);
      Object.keys(attributes2).forEach(function(name3) {
        var value = attributes2[name3];
        if (value === false) {
          element2.removeAttribute(name3);
        } else {
          element2.setAttribute(name3, value === true ? "" : value);
        }
      });
    });
  }
  function effect$4(_ref2) {
    var state = _ref2.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: "0",
        top: "0",
        margin: "0"
      },
      arrow: {
        position: "absolute"
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }
    return function() {
      Object.keys(state.elements).forEach(function(name2) {
        var element2 = state.elements[name2];
        var attributes2 = state.attributes[name2] || {};
        var styleProperties = Object.keys(state.styles.hasOwnProperty(name2) ? state.styles[name2] : initialStyles[name2]);
        var style2 = styleProperties.reduce(function(style3, property) {
          style3[property] = "";
          return style3;
        }, {});
        if (!isHTMLElement$1(element2) || !getNodeName$1(element2)) {
          return;
        }
        Object.assign(element2.style, style2);
        Object.keys(attributes2).forEach(function(attribute) {
          element2.removeAttribute(attribute);
        });
      });
    };
  }
  const applyStyles$3 = {
    name: "applyStyles",
    enabled: true,
    phase: "write",
    fn: applyStyles$2,
    effect: effect$4,
    requires: ["computeStyles"]
  };
  function distanceAndSkiddingToXY$1(placement, rects, offset2) {
    var basePlacement = getBasePlacement$3(placement);
    var invertDistance = [left$1, top$2].indexOf(basePlacement) >= 0 ? -1 : 1;
    var _ref2 = typeof offset2 === "function" ? offset2(Object.assign({}, rects, {
      placement
    })) : offset2, skidding = _ref2[0], distance = _ref2[1];
    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left$1, right$1].indexOf(basePlacement) >= 0 ? {
      x: distance,
      y: skidding
    } : {
      x: skidding,
      y: distance
    };
  }
  function offset$2(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    var _options$offset = options.offset, offset2 = _options$offset === void 0 ? [0, 0] : _options$offset;
    var data2 = placements$1.reduce(function(acc, placement) {
      acc[placement] = distanceAndSkiddingToXY$1(placement, state.rects, offset2);
      return acc;
    }, {});
    var _data$state$placement = data2[state.placement], x2 = _data$state$placement.x, y2 = _data$state$placement.y;
    if (state.modifiersData.popperOffsets != null) {
      state.modifiersData.popperOffsets.x += x2;
      state.modifiersData.popperOffsets.y += y2;
    }
    state.modifiersData[name2] = data2;
  }
  const offset$3 = {
    name: "offset",
    enabled: true,
    phase: "main",
    requires: ["popperOffsets"],
    fn: offset$2
  };
  var hash$4 = {
    left: "right",
    right: "left",
    bottom: "top",
    top: "bottom"
  };
  function getOppositePlacement$1(placement) {
    return placement.replace(/left|right|bottom|top/g, function(matched) {
      return hash$4[matched];
    });
  }
  var hash$3 = {
    start: "end",
    end: "start"
  };
  function getOppositeVariationPlacement$1(placement) {
    return placement.replace(/start|end/g, function(matched) {
      return hash$3[matched];
    });
  }
  function getViewportRect$1(element2) {
    var win = getWindow$1(element2);
    var visualViewport = win.visualViewport;
    var width = win.innerWidth;
    var height = win.innerHeight;
    if (visualViewport && /iPhone|iPod|iPad/.test(navigator.platform)) {
      width = visualViewport.width;
      height = visualViewport.height;
    }
    return {
      width,
      height,
      x: 0,
      y: 0
    };
  }
  function getDocumentRect$1(element2) {
    var win = getWindow$1(element2);
    var winScroll = getWindowScroll$1(element2);
    var documentRect = getCompositeRect$1(getDocumentElement$1(element2), win);
    documentRect.height = Math.max(documentRect.height, win.innerHeight);
    documentRect.width = Math.max(documentRect.width, win.innerWidth);
    documentRect.x = -winScroll.scrollLeft;
    documentRect.y = -winScroll.scrollTop;
    return documentRect;
  }
  function toNumber$2(cssValue) {
    return parseFloat(cssValue) || 0;
  }
  function getBorders(element2) {
    var computedStyle = isHTMLElement$1(element2) ? getComputedStyle$2(element2) : {};
    return {
      top: toNumber$2(computedStyle.borderTopWidth),
      right: toNumber$2(computedStyle.borderRightWidth),
      bottom: toNumber$2(computedStyle.borderBottomWidth),
      left: toNumber$2(computedStyle.borderLeftWidth)
    };
  }
  function getDecorations(element2) {
    var win = getWindow$1(element2);
    var borders = getBorders(element2);
    var isHTML = getNodeName$1(element2) === "html";
    var winScrollBarX = getWindowScrollBarX$1(element2);
    var x2 = element2.clientWidth + borders.right;
    var y2 = element2.clientHeight + borders.bottom;
    if (isHTML && win.innerHeight - element2.clientHeight > 50) {
      y2 = win.innerHeight - borders.bottom;
    }
    return {
      top: isHTML ? 0 : element2.clientTop,
      right: element2.clientLeft > borders.left ? borders.right : isHTML ? win.innerWidth - x2 - winScrollBarX : element2.offsetWidth - x2,
      bottom: isHTML ? win.innerHeight - y2 : element2.offsetHeight - y2,
      left: isHTML ? winScrollBarX : element2.clientLeft
    };
  }
  function contains$2(parent, child) {
    var isShadow = Boolean(child.getRootNode && child.getRootNode().host);
    if (parent.contains(child)) {
      return true;
    } else if (isShadow) {
      var next2 = child;
      do {
        if (next2 && parent.isSameNode(next2)) {
          return true;
        }
        next2 = next2.parentNode || next2.host;
      } while (next2);
    }
    return false;
  }
  function rectToClientRect$1(rect) {
    return Object.assign({}, rect, {
      left: rect.x,
      top: rect.y,
      right: rect.x + rect.width,
      bottom: rect.y + rect.height
    });
  }
  function getClientRectFromMixedType$1(element2, clippingParent) {
    return clippingParent === viewport$1 ? rectToClientRect$1(getViewportRect$1(element2)) : isHTMLElement$1(clippingParent) ? getBoundingClientRect$1(clippingParent) : rectToClientRect$1(getDocumentRect$1(getDocumentElement$1(element2)));
  }
  function getClippingParents$1(element2) {
    var clippingParents2 = listScrollParents$1(element2);
    var canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle$2(element2).position) >= 0;
    var clipperElement = canEscapeClipping && isHTMLElement$1(element2) ? getOffsetParent$1(element2) : element2;
    if (!isElement$4(clipperElement)) {
      return [];
    }
    return clippingParents2.filter(function(clippingParent) {
      return isElement$4(clippingParent) && contains$2(clippingParent, clipperElement);
    });
  }
  function getClippingRect$1(element2, boundary, rootBoundary) {
    var mainClippingParents = boundary === "clippingParents" ? getClippingParents$1(element2) : [].concat(boundary);
    var clippingParents2 = [].concat(mainClippingParents, [rootBoundary]);
    var firstClippingParent = clippingParents2[0];
    var clippingRect = clippingParents2.reduce(function(accRect, clippingParent) {
      var rect = getClientRectFromMixedType$1(element2, clippingParent);
      var decorations2 = getDecorations(isHTMLElement$1(clippingParent) ? clippingParent : getDocumentElement$1(element2));
      accRect.top = Math.max(rect.top + decorations2.top, accRect.top);
      accRect.right = Math.min(rect.right - decorations2.right, accRect.right);
      accRect.bottom = Math.min(rect.bottom - decorations2.bottom, accRect.bottom);
      accRect.left = Math.max(rect.left + decorations2.left, accRect.left);
      return accRect;
    }, getClientRectFromMixedType$1(element2, firstClippingParent));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
  }
  function getFreshSideObject$1() {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
  }
  function mergePaddingObject$1(paddingObject) {
    return Object.assign({}, getFreshSideObject$1(), {}, paddingObject);
  }
  function expandToHashMap$1(value, keys2) {
    return keys2.reduce(function(hashMap, key) {
      hashMap[key] = value;
      return hashMap;
    }, {});
  }
  function detectOverflow$1(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, _options$placement = _options.placement, placement = _options$placement === void 0 ? state.placement : _options$placement, _options$boundary = _options.boundary, boundary = _options$boundary === void 0 ? clippingParents$1 : _options$boundary, _options$rootBoundary = _options.rootBoundary, rootBoundary = _options$rootBoundary === void 0 ? viewport$1 : _options$rootBoundary, _options$elementConte = _options.elementContext, elementContext = _options$elementConte === void 0 ? popper$1 : _options$elementConte, _options$altBoundary = _options.altBoundary, altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary, _options$padding = _options.padding, padding = _options$padding === void 0 ? 0 : _options$padding;
    var paddingObject = mergePaddingObject$1(typeof padding !== "number" ? padding : expandToHashMap$1(padding, basePlacements$1));
    var altContext = elementContext === popper$1 ? reference$1 : popper$1;
    var referenceElement = state.elements.reference;
    var popperRect = state.rects.popper;
    var element2 = state.elements[altBoundary ? altContext : elementContext];
    var clippingClientRect = getClippingRect$1(isElement$4(element2) ? element2 : element2.contextElement || getDocumentElement$1(state.elements.popper), boundary, rootBoundary);
    var referenceClientRect = getBoundingClientRect$1(referenceElement);
    var popperOffsets2 = computeOffsets$1({
      reference: referenceClientRect,
      element: popperRect,
      strategy: "absolute",
      placement
    });
    var popperClientRect = rectToClientRect$1(Object.assign({}, popperRect, {}, popperOffsets2));
    var elementClientRect = elementContext === popper$1 ? popperClientRect : referenceClientRect;
    var overflowOffsets = {
      top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
      bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
      left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
      right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    var offsetData = state.modifiersData.offset;
    if (elementContext === popper$1 && offsetData) {
      var offset2 = offsetData[placement];
      Object.keys(overflowOffsets).forEach(function(key) {
        var multiply = [right$1, bottom$1].indexOf(key) >= 0 ? 1 : -1;
        var axis = [top$2, bottom$1].indexOf(key) >= 0 ? "y" : "x";
        overflowOffsets[key] += offset2[axis] * multiply;
      });
    }
    return overflowOffsets;
  }
  function computeAutoPlacement$1(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, placement = _options.placement, boundary = _options.boundary, rootBoundary = _options.rootBoundary, padding = _options.padding, flipVariations = _options.flipVariations, _options$allowedAutoP = _options.allowedAutoPlacements, allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements$1 : _options$allowedAutoP;
    var variation = getVariation$1(placement);
    var placements2 = (variation ? flipVariations ? variationPlacements$1 : variationPlacements$1.filter(function(placement2) {
      return getVariation$1(placement2) === variation;
    }) : basePlacements$1).filter(function(placement2) {
      return allowedAutoPlacements.indexOf(placement2) >= 0;
    });
    var overflows = placements2.reduce(function(acc, placement2) {
      acc[placement2] = detectOverflow$1(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding
      })[getBasePlacement$3(placement2)];
      return acc;
    }, {});
    return Object.keys(overflows).sort(function(a2, b2) {
      return overflows[a2] - overflows[b2];
    });
  }
  function getExpandedFallbackPlacements$1(placement) {
    if (getBasePlacement$3(placement) === auto$1) {
      return [];
    }
    var oppositePlacement = getOppositePlacement$1(placement);
    return [getOppositeVariationPlacement$1(placement), oppositePlacement, getOppositeVariationPlacement$1(oppositePlacement)];
  }
  function flip$2(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    if (state.modifiersData[name2]._skip) {
      return;
    }
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis, specifiedFallbackPlacements = options.fallbackPlacements, padding = options.padding, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, _options$flipVariatio = options.flipVariations, flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio, allowedAutoPlacements = options.allowedAutoPlacements;
    var preferredPlacement = state.options.placement;
    var basePlacement = getBasePlacement$3(preferredPlacement);
    var isBasePlacement = basePlacement === preferredPlacement;
    var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement$1(preferredPlacement)] : getExpandedFallbackPlacements$1(preferredPlacement));
    var placements2 = [preferredPlacement].concat(fallbackPlacements).reduce(function(acc, placement2) {
      return acc.concat(getBasePlacement$3(placement2) === auto$1 ? computeAutoPlacement$1(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding,
        flipVariations,
        allowedAutoPlacements
      }) : placement2);
    }, []);
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var checksMap = /* @__PURE__ */ new Map();
    var makeFallbackChecks = true;
    var firstFittingPlacement = placements2[0];
    for (var i2 = 0; i2 < placements2.length; i2++) {
      var placement = placements2[i2];
      var _basePlacement = getBasePlacement$3(placement);
      var isStartVariation = getVariation$1(placement) === start$2;
      var isVertical = [top$2, bottom$1].indexOf(_basePlacement) >= 0;
      var len = isVertical ? "width" : "height";
      var overflow = detectOverflow$1(state, {
        placement,
        boundary,
        rootBoundary,
        altBoundary,
        padding
      });
      var mainVariationSide = isVertical ? isStartVariation ? right$1 : left$1 : isStartVariation ? bottom$1 : top$2;
      if (referenceRect[len] > popperRect[len]) {
        mainVariationSide = getOppositePlacement$1(mainVariationSide);
      }
      var altVariationSide = getOppositePlacement$1(mainVariationSide);
      var checks2 = [];
      if (checkMainAxis) {
        checks2.push(overflow[_basePlacement] <= 0);
      }
      if (checkAltAxis) {
        checks2.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
      }
      if (checks2.every(function(check) {
        return check;
      })) {
        firstFittingPlacement = placement;
        makeFallbackChecks = false;
        break;
      }
      checksMap.set(placement, checks2);
    }
    if (makeFallbackChecks) {
      var numberOfChecks = flipVariations ? 3 : 1;
      var _loop = function _loop2(_i2) {
        var fittingPlacement = placements2.find(function(placement2) {
          var checks3 = checksMap.get(placement2);
          if (checks3) {
            return checks3.slice(0, _i2).every(function(check) {
              return check;
            });
          }
        });
        if (fittingPlacement) {
          firstFittingPlacement = fittingPlacement;
          return "break";
        }
      };
      for (var _i = numberOfChecks; _i > 0; _i--) {
        var _ret = _loop(_i);
        if (_ret === "break")
          break;
      }
    }
    if (state.placement !== firstFittingPlacement) {
      state.modifiersData[name2]._skip = true;
      state.placement = firstFittingPlacement;
      state.reset = true;
    }
  }
  const flip$3 = {
    name: "flip",
    enabled: true,
    phase: "main",
    fn: flip$2,
    requiresIfExists: ["offset"],
    data: {
      _skip: false
    }
  };
  function getAltAxis$1(axis) {
    return axis === "x" ? "y" : "x";
  }
  function within$1(min2, value, max2) {
    return Math.max(min2, Math.min(value, max2));
  }
  function preventOverflow$2(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, padding = options.padding, _options$tether = options.tether, tether = _options$tether === void 0 ? true : _options$tether, _options$tetherOffset = options.tetherOffset, tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
    var overflow = detectOverflow$1(state, {
      boundary,
      rootBoundary,
      padding,
      altBoundary
    });
    var basePlacement = getBasePlacement$3(state.placement);
    var variation = getVariation$1(state.placement);
    var isBasePlacement = !variation;
    var mainAxis = getMainAxisFromPlacement$1(basePlacement);
    var altAxis = getAltAxis$1(mainAxis);
    var popperOffsets2 = state.modifiersData.popperOffsets;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign({}, state.rects, {
      placement: state.placement
    })) : tetherOffset;
    var data2 = {
      x: 0,
      y: 0
    };
    if (!popperOffsets2) {
      return;
    }
    if (checkMainAxis) {
      var mainSide = mainAxis === "y" ? top$2 : left$1;
      var altSide = mainAxis === "y" ? bottom$1 : right$1;
      var len = mainAxis === "y" ? "height" : "width";
      var offset2 = popperOffsets2[mainAxis];
      var min2 = popperOffsets2[mainAxis] + overflow[mainSide];
      var max2 = popperOffsets2[mainAxis] - overflow[altSide];
      var additive = tether ? -popperRect[len] / 2 : 0;
      var minLen = variation === start$2 ? referenceRect[len] : popperRect[len];
      var maxLen = variation === start$2 ? -popperRect[len] : -referenceRect[len];
      var arrowElement = state.elements.arrow;
      var arrowRect = tether && arrowElement ? getLayoutRect$1(arrowElement) : {
        width: 0,
        height: 0
      };
      var arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject$1();
      var arrowPaddingMin = arrowPaddingObject[mainSide];
      var arrowPaddingMax = arrowPaddingObject[altSide];
      var arrowLen = within$1(0, referenceRect[len], arrowRect[len]);
      var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
      var maxOffset2 = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
      var arrowOffsetParent = state.elements.arrow && getOffsetParent$1(state.elements.arrow);
      var clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
      var offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
      var tetherMin = popperOffsets2[mainAxis] + minOffset - offsetModifierValue - clientOffset;
      var tetherMax = popperOffsets2[mainAxis] + maxOffset2 - offsetModifierValue;
      var preventedOffset = within$1(tether ? Math.min(min2, tetherMin) : min2, offset2, tether ? Math.max(max2, tetherMax) : max2);
      popperOffsets2[mainAxis] = preventedOffset;
      data2[mainAxis] = preventedOffset - offset2;
    }
    if (checkAltAxis) {
      var _mainSide = mainAxis === "x" ? top$2 : left$1;
      var _altSide = mainAxis === "x" ? bottom$1 : right$1;
      var _offset = popperOffsets2[altAxis];
      var _min = _offset + overflow[_mainSide];
      var _max = _offset - overflow[_altSide];
      var _preventedOffset = within$1(_min, _offset, _max);
      popperOffsets2[altAxis] = _preventedOffset;
      data2[altAxis] = _preventedOffset - _offset;
    }
    state.modifiersData[name2] = data2;
  }
  const preventOverflow$3 = {
    name: "preventOverflow",
    enabled: true,
    phase: "main",
    fn: preventOverflow$2,
    requiresIfExists: ["offset"]
  };
  function arrow$2(_ref2) {
    var _state$modifiersData$;
    var state = _ref2.state, name2 = _ref2.name;
    var arrowElement = state.elements.arrow;
    var popperOffsets2 = state.modifiersData.popperOffsets;
    var basePlacement = getBasePlacement$3(state.placement);
    var axis = getMainAxisFromPlacement$1(basePlacement);
    var isVertical = [left$1, right$1].indexOf(basePlacement) >= 0;
    var len = isVertical ? "height" : "width";
    if (!arrowElement || !popperOffsets2) {
      return;
    }
    var paddingObject = state.modifiersData[name2 + "#persistent"].padding;
    var arrowRect = getLayoutRect$1(arrowElement);
    var minProp = axis === "y" ? top$2 : left$1;
    var maxProp = axis === "y" ? bottom$1 : right$1;
    var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets2[axis] - state.rects.popper[len];
    var startDiff = popperOffsets2[axis] - state.rects.reference[axis];
    var arrowOffsetParent = getOffsetParent$1(arrowElement);
    var clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    var centerToReference = endDiff / 2 - startDiff / 2;
    var min2 = paddingObject[minProp];
    var max2 = clientSize - arrowRect[len] - paddingObject[maxProp];
    var center2 = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    var offset2 = within$1(min2, center2, max2);
    var axisProp = axis;
    state.modifiersData[name2] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset2, _state$modifiersData$.centerOffset = offset2 - center2, _state$modifiersData$);
  }
  function effect$3(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    var _options$element = options.element, arrowElement = _options$element === void 0 ? "[data-popper-arrow]" : _options$element, _options$padding = options.padding, padding = _options$padding === void 0 ? 0 : _options$padding;
    if (arrowElement == null) {
      return;
    }
    if (typeof arrowElement === "string") {
      arrowElement = state.elements.popper.querySelector(arrowElement);
      if (!arrowElement) {
        return;
      }
    }
    if (!contains$2(state.elements.popper, arrowElement)) {
      return;
    }
    state.elements.arrow = arrowElement;
    state.modifiersData[name2 + "#persistent"] = {
      padding: mergePaddingObject$1(typeof padding !== "number" ? padding : expandToHashMap$1(padding, basePlacements$1))
    };
  }
  const arrow$3 = {
    name: "arrow",
    enabled: true,
    phase: "main",
    fn: arrow$2,
    effect: effect$3,
    requires: ["popperOffsets"],
    requiresIfExists: ["preventOverflow"]
  };
  function getSideOffsets$1(overflow, rect, preventedOffsets) {
    if (preventedOffsets === void 0) {
      preventedOffsets = {
        x: 0,
        y: 0
      };
    }
    return {
      top: overflow.top - rect.height - preventedOffsets.y,
      right: overflow.right - rect.width + preventedOffsets.x,
      bottom: overflow.bottom - rect.height + preventedOffsets.y,
      left: overflow.left - rect.width - preventedOffsets.x
    };
  }
  function isAnySideFullyClipped$1(overflow) {
    return [top$2, right$1, bottom$1, left$1].some(function(side) {
      return overflow[side] >= 0;
    });
  }
  function hide$2(_ref2) {
    var state = _ref2.state, name2 = _ref2.name;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var preventedOffsets = state.modifiersData.preventOverflow;
    var referenceOverflow = detectOverflow$1(state, {
      elementContext: "reference"
    });
    var popperAltOverflow = detectOverflow$1(state, {
      altBoundary: true
    });
    var referenceClippingOffsets = getSideOffsets$1(referenceOverflow, referenceRect);
    var popperEscapeOffsets = getSideOffsets$1(popperAltOverflow, popperRect, preventedOffsets);
    var isReferenceHidden = isAnySideFullyClipped$1(referenceClippingOffsets);
    var hasPopperEscaped = isAnySideFullyClipped$1(popperEscapeOffsets);
    state.modifiersData[name2] = {
      referenceClippingOffsets,
      popperEscapeOffsets,
      isReferenceHidden,
      hasPopperEscaped
    };
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-reference-hidden": isReferenceHidden,
      "data-popper-escaped": hasPopperEscaped
    });
  }
  const hide$3 = {
    name: "hide",
    enabled: true,
    phase: "main",
    requiresIfExists: ["preventOverflow"],
    fn: hide$2
  };
  var defaultModifiers$1 = [eventListeners$1, popperOffsets$3, computeStyles$3, applyStyles$3, offset$3, flip$3, preventOverflow$3, arrow$3, hide$3];
  var createPopper$1 = /* @__PURE__ */ popperGenerator$1({
    defaultModifiers: defaultModifiers$1
  });
  var hasElementType = typeof Element !== "undefined";
  var hasMap$1 = typeof Map === "function";
  var hasSet$1 = typeof Set === "function";
  var hasArrayBuffer = typeof ArrayBuffer === "function" && !!ArrayBuffer.isView;
  function equal$1(a2, b2) {
    if (a2 === b2)
      return true;
    if (a2 && b2 && typeof a2 == "object" && typeof b2 == "object") {
      if (a2.constructor !== b2.constructor)
        return false;
      var length2, i2, keys2;
      if (Array.isArray(a2)) {
        length2 = a2.length;
        if (length2 != b2.length)
          return false;
        for (i2 = length2; i2-- !== 0; )
          if (!equal$1(a2[i2], b2[i2]))
            return false;
        return true;
      }
      var it2;
      if (hasMap$1 && a2 instanceof Map && b2 instanceof Map) {
        if (a2.size !== b2.size)
          return false;
        it2 = a2.entries();
        while (!(i2 = it2.next()).done)
          if (!b2.has(i2.value[0]))
            return false;
        it2 = a2.entries();
        while (!(i2 = it2.next()).done)
          if (!equal$1(i2.value[1], b2.get(i2.value[0])))
            return false;
        return true;
      }
      if (hasSet$1 && a2 instanceof Set && b2 instanceof Set) {
        if (a2.size !== b2.size)
          return false;
        it2 = a2.entries();
        while (!(i2 = it2.next()).done)
          if (!b2.has(i2.value[0]))
            return false;
        return true;
      }
      if (hasArrayBuffer && ArrayBuffer.isView(a2) && ArrayBuffer.isView(b2)) {
        length2 = a2.length;
        if (length2 != b2.length)
          return false;
        for (i2 = length2; i2-- !== 0; )
          if (a2[i2] !== b2[i2])
            return false;
        return true;
      }
      if (a2.constructor === RegExp)
        return a2.source === b2.source && a2.flags === b2.flags;
      if (a2.valueOf !== Object.prototype.valueOf && typeof a2.valueOf === "function" && typeof b2.valueOf === "function")
        return a2.valueOf() === b2.valueOf();
      if (a2.toString !== Object.prototype.toString && typeof a2.toString === "function" && typeof b2.toString === "function")
        return a2.toString() === b2.toString();
      keys2 = Object.keys(a2);
      length2 = keys2.length;
      if (length2 !== Object.keys(b2).length)
        return false;
      for (i2 = length2; i2-- !== 0; )
        if (!Object.prototype.hasOwnProperty.call(b2, keys2[i2]))
          return false;
      if (hasElementType && a2 instanceof Element)
        return false;
      for (i2 = length2; i2-- !== 0; ) {
        if ((keys2[i2] === "_owner" || keys2[i2] === "__v" || keys2[i2] === "__o") && a2.$$typeof) {
          continue;
        }
        if (!equal$1(a2[keys2[i2]], b2[keys2[i2]]))
          return false;
      }
      return true;
    }
    return a2 !== a2 && b2 !== b2;
  }
  var reactFastCompare = function isEqual2(a2, b2) {
    try {
      return equal$1(a2, b2);
    } catch (error2) {
      if ((error2.message || "").match(/stack|recursion/i)) {
        console.warn("react-fast-compare cannot handle circular refs");
        return false;
      }
      throw error2;
    }
  };
  var EMPTY_MODIFIERS$2 = [];
  var usePopper$1 = function usePopper2(referenceElement, popperElement, options) {
    if (options === void 0) {
      options = {};
    }
    var prevOptions = React__namespace.useRef(null);
    var optionsWithDefaults = {
      onFirstUpdate: options.onFirstUpdate,
      placement: options.placement || "bottom",
      strategy: options.strategy || "absolute",
      modifiers: options.modifiers || EMPTY_MODIFIERS$2
    };
    var _React$useState = React__namespace.useState({
      styles: {
        popper: {
          position: optionsWithDefaults.strategy,
          left: "0",
          top: "0"
        },
        arrow: {
          position: "absolute"
        }
      },
      attributes: {}
    }), state = _React$useState[0], setState = _React$useState[1];
    var updateStateModifier = React__namespace.useMemo(function() {
      return {
        name: "updateState",
        enabled: true,
        phase: "write",
        fn: function fn2(_ref2) {
          var state2 = _ref2.state;
          var elements = Object.keys(state2.elements);
          setState({
            styles: fromEntries$1(elements.map(function(element2) {
              return [element2, state2.styles[element2] || {}];
            })),
            attributes: fromEntries$1(elements.map(function(element2) {
              return [element2, state2.attributes[element2]];
            }))
          });
        },
        requires: ["computeStyles"]
      };
    }, []);
    var popperOptions = React__namespace.useMemo(function() {
      var newOptions = {
        onFirstUpdate: optionsWithDefaults.onFirstUpdate,
        placement: optionsWithDefaults.placement,
        strategy: optionsWithDefaults.strategy,
        modifiers: [].concat(optionsWithDefaults.modifiers, [updateStateModifier, {
          name: "applyStyles",
          enabled: false
        }])
      };
      if (reactFastCompare(prevOptions.current, newOptions)) {
        return prevOptions.current || newOptions;
      } else {
        prevOptions.current = newOptions;
        return newOptions;
      }
    }, [optionsWithDefaults.onFirstUpdate, optionsWithDefaults.placement, optionsWithDefaults.strategy, optionsWithDefaults.modifiers, updateStateModifier]);
    var popperInstanceRef = React__namespace.useRef();
    useIsomorphicLayoutEffect$3(function() {
      if (popperInstanceRef.current) {
        popperInstanceRef.current.setOptions(popperOptions);
      }
    }, [popperOptions]);
    useIsomorphicLayoutEffect$3(function() {
      if (referenceElement == null || popperElement == null) {
        return;
      }
      var createPopper2 = options.createPopper || createPopper$1;
      var popperInstance = createPopper2(referenceElement, popperElement, popperOptions);
      popperInstanceRef.current = popperInstance;
      return function() {
        popperInstance.destroy();
        popperInstanceRef.current = null;
      };
    }, [referenceElement, popperElement, options.createPopper]);
    return {
      state: popperInstanceRef.current ? popperInstanceRef.current.state : null,
      styles: state.styles,
      attributes: state.attributes,
      update: popperInstanceRef.current ? popperInstanceRef.current.update : null,
      forceUpdate: popperInstanceRef.current ? popperInstanceRef.current.forceUpdate : null
    };
  };
  var top$1 = "top";
  var bottom = "bottom";
  var right = "right";
  var left = "left";
  var auto = "auto";
  var basePlacements = [top$1, bottom, right, left];
  var start$1 = "start";
  var end = "end";
  var clippingParents = "clippingParents";
  var viewport = "viewport";
  var popper = "popper";
  var reference = "reference";
  var variationPlacements = /* @__PURE__ */ basePlacements.reduce(function(acc, placement) {
    return acc.concat([placement + "-" + start$1, placement + "-" + end]);
  }, []);
  var placements = /* @__PURE__ */ [].concat(basePlacements, [auto]).reduce(function(acc, placement) {
    return acc.concat([placement, placement + "-" + start$1, placement + "-" + end]);
  }, []);
  var beforeRead = "beforeRead";
  var read = "read";
  var afterRead = "afterRead";
  var beforeMain = "beforeMain";
  var main$3 = "main";
  var afterMain = "afterMain";
  var beforeWrite = "beforeWrite";
  var write = "write";
  var afterWrite = "afterWrite";
  var modifierPhases = [beforeRead, read, afterRead, beforeMain, main$3, afterMain, beforeWrite, write, afterWrite];
  function getNodeName(element2) {
    return element2 ? (element2.nodeName || "").toLowerCase() : null;
  }
  function getWindow(node2) {
    if (node2 == null) {
      return window;
    }
    if (node2.toString() !== "[object Window]") {
      var ownerDocument = node2.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView || window : window;
    }
    return node2;
  }
  function isElement$3(node2) {
    var OwnElement = getWindow(node2).Element;
    return node2 instanceof OwnElement || node2 instanceof Element;
  }
  function isHTMLElement(node2) {
    var OwnElement = getWindow(node2).HTMLElement;
    return node2 instanceof OwnElement || node2 instanceof HTMLElement;
  }
  function isShadowRoot(node2) {
    if (typeof ShadowRoot === "undefined") {
      return false;
    }
    var OwnElement = getWindow(node2).ShadowRoot;
    return node2 instanceof OwnElement || node2 instanceof ShadowRoot;
  }
  function applyStyles(_ref2) {
    var state = _ref2.state;
    Object.keys(state.elements).forEach(function(name2) {
      var style2 = state.styles[name2] || {};
      var attributes2 = state.attributes[name2] || {};
      var element2 = state.elements[name2];
      if (!isHTMLElement(element2) || !getNodeName(element2)) {
        return;
      }
      Object.assign(element2.style, style2);
      Object.keys(attributes2).forEach(function(name3) {
        var value = attributes2[name3];
        if (value === false) {
          element2.removeAttribute(name3);
        } else {
          element2.setAttribute(name3, value === true ? "" : value);
        }
      });
    });
  }
  function effect$2(_ref2) {
    var state = _ref2.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: "0",
        top: "0",
        margin: "0"
      },
      arrow: {
        position: "absolute"
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    state.styles = initialStyles;
    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }
    return function() {
      Object.keys(state.elements).forEach(function(name2) {
        var element2 = state.elements[name2];
        var attributes2 = state.attributes[name2] || {};
        var styleProperties = Object.keys(state.styles.hasOwnProperty(name2) ? state.styles[name2] : initialStyles[name2]);
        var style2 = styleProperties.reduce(function(style3, property) {
          style3[property] = "";
          return style3;
        }, {});
        if (!isHTMLElement(element2) || !getNodeName(element2)) {
          return;
        }
        Object.assign(element2.style, style2);
        Object.keys(attributes2).forEach(function(attribute) {
          element2.removeAttribute(attribute);
        });
      });
    };
  }
  const applyStyles$1 = {
    name: "applyStyles",
    enabled: true,
    phase: "write",
    fn: applyStyles,
    effect: effect$2,
    requires: ["computeStyles"]
  };
  function getBasePlacement$2(placement) {
    return placement.split("-")[0];
  }
  var max$3 = Math.max;
  var min$3 = Math.min;
  var round$2 = Math.round;
  function getUAString() {
    var uaData = navigator.userAgentData;
    if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
      return uaData.brands.map(function(item) {
        return item.brand + "/" + item.version;
      }).join(" ");
    }
    return navigator.userAgent;
  }
  function isLayoutViewport() {
    return !/^((?!chrome|android).)*safari/i.test(getUAString());
  }
  function getBoundingClientRect(element2, includeScale, isFixedStrategy) {
    if (includeScale === void 0) {
      includeScale = false;
    }
    if (isFixedStrategy === void 0) {
      isFixedStrategy = false;
    }
    var clientRect = element2.getBoundingClientRect();
    var scaleX = 1;
    var scaleY = 1;
    if (includeScale && isHTMLElement(element2)) {
      scaleX = element2.offsetWidth > 0 ? round$2(clientRect.width) / element2.offsetWidth || 1 : 1;
      scaleY = element2.offsetHeight > 0 ? round$2(clientRect.height) / element2.offsetHeight || 1 : 1;
    }
    var _ref2 = isElement$3(element2) ? getWindow(element2) : window, visualViewport = _ref2.visualViewport;
    var addVisualOffsets = !isLayoutViewport() && isFixedStrategy;
    var x2 = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
    var y2 = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
    var width = clientRect.width / scaleX;
    var height = clientRect.height / scaleY;
    return {
      width,
      height,
      top: y2,
      right: x2 + width,
      bottom: y2 + height,
      left: x2,
      x: x2,
      y: y2
    };
  }
  function getLayoutRect(element2) {
    var clientRect = getBoundingClientRect(element2);
    var width = element2.offsetWidth;
    var height = element2.offsetHeight;
    if (Math.abs(clientRect.width - width) <= 1) {
      width = clientRect.width;
    }
    if (Math.abs(clientRect.height - height) <= 1) {
      height = clientRect.height;
    }
    return {
      x: element2.offsetLeft,
      y: element2.offsetTop,
      width,
      height
    };
  }
  function contains$1(parent, child) {
    var rootNode = child.getRootNode && child.getRootNode();
    if (parent.contains(child)) {
      return true;
    } else if (rootNode && isShadowRoot(rootNode)) {
      var next2 = child;
      do {
        if (next2 && parent.isSameNode(next2)) {
          return true;
        }
        next2 = next2.parentNode || next2.host;
      } while (next2);
    }
    return false;
  }
  function getComputedStyle$1(element2) {
    return getWindow(element2).getComputedStyle(element2);
  }
  function isTableElement(element2) {
    return ["table", "td", "th"].indexOf(getNodeName(element2)) >= 0;
  }
  function getDocumentElement(element2) {
    return ((isElement$3(element2) ? element2.ownerDocument : element2.document) || window.document).documentElement;
  }
  function getParentNode(element2) {
    if (getNodeName(element2) === "html") {
      return element2;
    }
    return element2.assignedSlot || element2.parentNode || (isShadowRoot(element2) ? element2.host : null) || getDocumentElement(element2);
  }
  function getTrueOffsetParent(element2) {
    if (!isHTMLElement(element2) || getComputedStyle$1(element2).position === "fixed") {
      return null;
    }
    return element2.offsetParent;
  }
  function getContainingBlock(element2) {
    var isFirefox2 = /firefox/i.test(getUAString());
    var isIE2 = /Trident/i.test(getUAString());
    if (isIE2 && isHTMLElement(element2)) {
      var elementCss = getComputedStyle$1(element2);
      if (elementCss.position === "fixed") {
        return null;
      }
    }
    var currentNode = getParentNode(element2);
    if (isShadowRoot(currentNode)) {
      currentNode = currentNode.host;
    }
    while (isHTMLElement(currentNode) && ["html", "body"].indexOf(getNodeName(currentNode)) < 0) {
      var css2 = getComputedStyle$1(currentNode);
      if (css2.transform !== "none" || css2.perspective !== "none" || css2.contain === "paint" || ["transform", "perspective"].indexOf(css2.willChange) !== -1 || isFirefox2 && css2.willChange === "filter" || isFirefox2 && css2.filter && css2.filter !== "none") {
        return currentNode;
      } else {
        currentNode = currentNode.parentNode;
      }
    }
    return null;
  }
  function getOffsetParent(element2) {
    var window2 = getWindow(element2);
    var offsetParent = getTrueOffsetParent(element2);
    while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === "static") {
      offsetParent = getTrueOffsetParent(offsetParent);
    }
    if (offsetParent && (getNodeName(offsetParent) === "html" || getNodeName(offsetParent) === "body" && getComputedStyle$1(offsetParent).position === "static")) {
      return window2;
    }
    return offsetParent || getContainingBlock(element2) || window2;
  }
  function getMainAxisFromPlacement(placement) {
    return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
  }
  function within(min2, value, max2) {
    return max$3(min2, min$3(value, max2));
  }
  function withinMaxClamp(min2, value, max2) {
    var v2 = within(min2, value, max2);
    return v2 > max2 ? max2 : v2;
  }
  function getFreshSideObject() {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
  }
  function mergePaddingObject(paddingObject) {
    return Object.assign({}, getFreshSideObject(), paddingObject);
  }
  function expandToHashMap(value, keys2) {
    return keys2.reduce(function(hashMap, key) {
      hashMap[key] = value;
      return hashMap;
    }, {});
  }
  var toPaddingObject = function toPaddingObject2(padding, state) {
    padding = typeof padding === "function" ? padding(Object.assign({}, state.rects, {
      placement: state.placement
    })) : padding;
    return mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
  };
  function arrow(_ref2) {
    var _state$modifiersData$;
    var state = _ref2.state, name2 = _ref2.name, options = _ref2.options;
    var arrowElement = state.elements.arrow;
    var popperOffsets2 = state.modifiersData.popperOffsets;
    var basePlacement = getBasePlacement$2(state.placement);
    var axis = getMainAxisFromPlacement(basePlacement);
    var isVertical = [left, right].indexOf(basePlacement) >= 0;
    var len = isVertical ? "height" : "width";
    if (!arrowElement || !popperOffsets2) {
      return;
    }
    var paddingObject = toPaddingObject(options.padding, state);
    var arrowRect = getLayoutRect(arrowElement);
    var minProp = axis === "y" ? top$1 : left;
    var maxProp = axis === "y" ? bottom : right;
    var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets2[axis] - state.rects.popper[len];
    var startDiff = popperOffsets2[axis] - state.rects.reference[axis];
    var arrowOffsetParent = getOffsetParent(arrowElement);
    var clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    var centerToReference = endDiff / 2 - startDiff / 2;
    var min2 = paddingObject[minProp];
    var max2 = clientSize - arrowRect[len] - paddingObject[maxProp];
    var center2 = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    var offset2 = within(min2, center2, max2);
    var axisProp = axis;
    state.modifiersData[name2] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset2, _state$modifiersData$.centerOffset = offset2 - center2, _state$modifiersData$);
  }
  function effect$1(_ref2) {
    var state = _ref2.state, options = _ref2.options;
    var _options$element = options.element, arrowElement = _options$element === void 0 ? "[data-popper-arrow]" : _options$element;
    if (arrowElement == null) {
      return;
    }
    if (typeof arrowElement === "string") {
      arrowElement = state.elements.popper.querySelector(arrowElement);
      if (!arrowElement) {
        return;
      }
    }
    if (!contains$1(state.elements.popper, arrowElement)) {
      return;
    }
    state.elements.arrow = arrowElement;
  }
  const arrow$1 = {
    name: "arrow",
    enabled: true,
    phase: "main",
    fn: arrow,
    effect: effect$1,
    requires: ["popperOffsets"],
    requiresIfExists: ["preventOverflow"]
  };
  function getVariation(placement) {
    return placement.split("-")[1];
  }
  var unsetSides = {
    top: "auto",
    right: "auto",
    bottom: "auto",
    left: "auto"
  };
  function roundOffsetsByDPR(_ref2, win) {
    var x2 = _ref2.x, y2 = _ref2.y;
    var dpr = win.devicePixelRatio || 1;
    return {
      x: round$2(x2 * dpr) / dpr || 0,
      y: round$2(y2 * dpr) / dpr || 0
    };
  }
  function mapToStyles(_ref2) {
    var _Object$assign2;
    var popper2 = _ref2.popper, popperRect = _ref2.popperRect, placement = _ref2.placement, variation = _ref2.variation, offsets = _ref2.offsets, position2 = _ref2.position, gpuAcceleration = _ref2.gpuAcceleration, adaptive = _ref2.adaptive, roundOffsets2 = _ref2.roundOffsets, isFixed = _ref2.isFixed;
    var _offsets$x = offsets.x, x2 = _offsets$x === void 0 ? 0 : _offsets$x, _offsets$y = offsets.y, y2 = _offsets$y === void 0 ? 0 : _offsets$y;
    var _ref3 = typeof roundOffsets2 === "function" ? roundOffsets2({
      x: x2,
      y: y2
    }) : {
      x: x2,
      y: y2
    };
    x2 = _ref3.x;
    y2 = _ref3.y;
    var hasX = offsets.hasOwnProperty("x");
    var hasY = offsets.hasOwnProperty("y");
    var sideX = left;
    var sideY = top$1;
    var win = window;
    if (adaptive) {
      var offsetParent = getOffsetParent(popper2);
      var heightProp = "clientHeight";
      var widthProp = "clientWidth";
      if (offsetParent === getWindow(popper2)) {
        offsetParent = getDocumentElement(popper2);
        if (getComputedStyle$1(offsetParent).position !== "static" && position2 === "absolute") {
          heightProp = "scrollHeight";
          widthProp = "scrollWidth";
        }
      }
      offsetParent = offsetParent;
      if (placement === top$1 || (placement === left || placement === right) && variation === end) {
        sideY = bottom;
        var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : offsetParent[heightProp];
        y2 -= offsetY - popperRect.height;
        y2 *= gpuAcceleration ? 1 : -1;
      }
      if (placement === left || (placement === top$1 || placement === bottom) && variation === end) {
        sideX = right;
        var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : offsetParent[widthProp];
        x2 -= offsetX - popperRect.width;
        x2 *= gpuAcceleration ? 1 : -1;
      }
    }
    var commonStyles = Object.assign({
      position: position2
    }, adaptive && unsetSides);
    var _ref4 = roundOffsets2 === true ? roundOffsetsByDPR({
      x: x2,
      y: y2
    }, getWindow(popper2)) : {
      x: x2,
      y: y2
    };
    x2 = _ref4.x;
    y2 = _ref4.y;
    if (gpuAcceleration) {
      var _Object$assign;
      return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? "0" : "", _Object$assign[sideX] = hasX ? "0" : "", _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x2 + "px, " + y2 + "px)" : "translate3d(" + x2 + "px, " + y2 + "px, 0)", _Object$assign));
    }
    return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y2 + "px" : "", _Object$assign2[sideX] = hasX ? x2 + "px" : "", _Object$assign2.transform = "", _Object$assign2));
  }
  function computeStyles(_ref5) {
    var state = _ref5.state, options = _ref5.options;
    var _options$gpuAccelerat = options.gpuAcceleration, gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat, _options$adaptive = options.adaptive, adaptive = _options$adaptive === void 0 ? true : _options$adaptive, _options$roundOffsets = options.roundOffsets, roundOffsets2 = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
    var commonStyles = {
      placement: getBasePlacement$2(state.placement),
      variation: getVariation(state.placement),
      popper: state.elements.popper,
      popperRect: state.rects.popper,
      gpuAcceleration,
      isFixed: state.options.strategy === "fixed"
    };
    if (state.modifiersData.popperOffsets != null) {
      state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.popperOffsets,
        position: state.options.strategy,
        adaptive,
        roundOffsets: roundOffsets2
      })));
    }
    if (state.modifiersData.arrow != null) {
      state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.arrow,
        position: "absolute",
        adaptive: false,
        roundOffsets: roundOffsets2
      })));
    }
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-placement": state.placement
    });
  }
  const computeStyles$1 = {
    name: "computeStyles",
    enabled: true,
    phase: "beforeWrite",
    fn: computeStyles,
    data: {}
  };
  var passive = {
    passive: true
  };
  function effect(_ref2) {
    var state = _ref2.state, instance2 = _ref2.instance, options = _ref2.options;
    var _options$scroll = options.scroll, scroll = _options$scroll === void 0 ? true : _options$scroll, _options$resize = options.resize, resize = _options$resize === void 0 ? true : _options$resize;
    var window2 = getWindow(state.elements.popper);
    var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);
    if (scroll) {
      scrollParents.forEach(function(scrollParent) {
        scrollParent.addEventListener("scroll", instance2.update, passive);
      });
    }
    if (resize) {
      window2.addEventListener("resize", instance2.update, passive);
    }
    return function() {
      if (scroll) {
        scrollParents.forEach(function(scrollParent) {
          scrollParent.removeEventListener("scroll", instance2.update, passive);
        });
      }
      if (resize) {
        window2.removeEventListener("resize", instance2.update, passive);
      }
    };
  }
  const eventListeners = {
    name: "eventListeners",
    enabled: true,
    phase: "write",
    fn: function fn2() {
    },
    effect,
    data: {}
  };
  var hash$2 = {
    left: "right",
    right: "left",
    bottom: "top",
    top: "bottom"
  };
  function getOppositePlacement(placement) {
    return placement.replace(/left|right|bottom|top/g, function(matched) {
      return hash$2[matched];
    });
  }
  var hash$1 = {
    start: "end",
    end: "start"
  };
  function getOppositeVariationPlacement(placement) {
    return placement.replace(/start|end/g, function(matched) {
      return hash$1[matched];
    });
  }
  function getWindowScroll(node2) {
    var win = getWindow(node2);
    var scrollLeft = win.pageXOffset;
    var scrollTop = win.pageYOffset;
    return {
      scrollLeft,
      scrollTop
    };
  }
  function getWindowScrollBarX(element2) {
    return getBoundingClientRect(getDocumentElement(element2)).left + getWindowScroll(element2).scrollLeft;
  }
  function getViewportRect(element2, strategy) {
    var win = getWindow(element2);
    var html2 = getDocumentElement(element2);
    var visualViewport = win.visualViewport;
    var width = html2.clientWidth;
    var height = html2.clientHeight;
    var x2 = 0;
    var y2 = 0;
    if (visualViewport) {
      width = visualViewport.width;
      height = visualViewport.height;
      var layoutViewport = isLayoutViewport();
      if (layoutViewport || !layoutViewport && strategy === "fixed") {
        x2 = visualViewport.offsetLeft;
        y2 = visualViewport.offsetTop;
      }
    }
    return {
      width,
      height,
      x: x2 + getWindowScrollBarX(element2),
      y: y2
    };
  }
  function getDocumentRect(element2) {
    var _element$ownerDocumen;
    var html2 = getDocumentElement(element2);
    var winScroll = getWindowScroll(element2);
    var body = (_element$ownerDocumen = element2.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
    var width = max$3(html2.scrollWidth, html2.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
    var height = max$3(html2.scrollHeight, html2.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
    var x2 = -winScroll.scrollLeft + getWindowScrollBarX(element2);
    var y2 = -winScroll.scrollTop;
    if (getComputedStyle$1(body || html2).direction === "rtl") {
      x2 += max$3(html2.clientWidth, body ? body.clientWidth : 0) - width;
    }
    return {
      width,
      height,
      x: x2,
      y: y2
    };
  }
  function isScrollParent(element2) {
    var _getComputedStyle = getComputedStyle$1(element2), overflow = _getComputedStyle.overflow, overflowX = _getComputedStyle.overflowX, overflowY = _getComputedStyle.overflowY;
    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
  }
  function getScrollParent(node2) {
    if (["html", "body", "#document"].indexOf(getNodeName(node2)) >= 0) {
      return node2.ownerDocument.body;
    }
    if (isHTMLElement(node2) && isScrollParent(node2)) {
      return node2;
    }
    return getScrollParent(getParentNode(node2));
  }
  function listScrollParents(element2, list2) {
    var _element$ownerDocumen;
    if (list2 === void 0) {
      list2 = [];
    }
    var scrollParent = getScrollParent(element2);
    var isBody = scrollParent === ((_element$ownerDocumen = element2.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
    var win = getWindow(scrollParent);
    var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
    var updatedList = list2.concat(target);
    return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
  }
  function rectToClientRect(rect) {
    return Object.assign({}, rect, {
      left: rect.x,
      top: rect.y,
      right: rect.x + rect.width,
      bottom: rect.y + rect.height
    });
  }
  function getInnerBoundingClientRect(element2, strategy) {
    var rect = getBoundingClientRect(element2, false, strategy === "fixed");
    rect.top = rect.top + element2.clientTop;
    rect.left = rect.left + element2.clientLeft;
    rect.bottom = rect.top + element2.clientHeight;
    rect.right = rect.left + element2.clientWidth;
    rect.width = element2.clientWidth;
    rect.height = element2.clientHeight;
    rect.x = rect.left;
    rect.y = rect.top;
    return rect;
  }
  function getClientRectFromMixedType(element2, clippingParent, strategy) {
    return clippingParent === viewport ? rectToClientRect(getViewportRect(element2, strategy)) : isElement$3(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : rectToClientRect(getDocumentRect(getDocumentElement(element2)));
  }
  function getClippingParents(element2) {
    var clippingParents2 = listScrollParents(getParentNode(element2));
    var canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle$1(element2).position) >= 0;
    var clipperElement = canEscapeClipping && isHTMLElement(element2) ? getOffsetParent(element2) : element2;
    if (!isElement$3(clipperElement)) {
      return [];
    }
    return clippingParents2.filter(function(clippingParent) {
      return isElement$3(clippingParent) && contains$1(clippingParent, clipperElement) && getNodeName(clippingParent) !== "body";
    });
  }
  function getClippingRect(element2, boundary, rootBoundary, strategy) {
    var mainClippingParents = boundary === "clippingParents" ? getClippingParents(element2) : [].concat(boundary);
    var clippingParents2 = [].concat(mainClippingParents, [rootBoundary]);
    var firstClippingParent = clippingParents2[0];
    var clippingRect = clippingParents2.reduce(function(accRect, clippingParent) {
      var rect = getClientRectFromMixedType(element2, clippingParent, strategy);
      accRect.top = max$3(rect.top, accRect.top);
      accRect.right = min$3(rect.right, accRect.right);
      accRect.bottom = min$3(rect.bottom, accRect.bottom);
      accRect.left = max$3(rect.left, accRect.left);
      return accRect;
    }, getClientRectFromMixedType(element2, firstClippingParent, strategy));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
  }
  function computeOffsets(_ref2) {
    var reference2 = _ref2.reference, element2 = _ref2.element, placement = _ref2.placement;
    var basePlacement = placement ? getBasePlacement$2(placement) : null;
    var variation = placement ? getVariation(placement) : null;
    var commonX = reference2.x + reference2.width / 2 - element2.width / 2;
    var commonY = reference2.y + reference2.height / 2 - element2.height / 2;
    var offsets;
    switch (basePlacement) {
      case top$1:
        offsets = {
          x: commonX,
          y: reference2.y - element2.height
        };
        break;
      case bottom:
        offsets = {
          x: commonX,
          y: reference2.y + reference2.height
        };
        break;
      case right:
        offsets = {
          x: reference2.x + reference2.width,
          y: commonY
        };
        break;
      case left:
        offsets = {
          x: reference2.x - element2.width,
          y: commonY
        };
        break;
      default:
        offsets = {
          x: reference2.x,
          y: reference2.y
        };
    }
    var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
    if (mainAxis != null) {
      var len = mainAxis === "y" ? "height" : "width";
      switch (variation) {
        case start$1:
          offsets[mainAxis] = offsets[mainAxis] - (reference2[len] / 2 - element2[len] / 2);
          break;
        case end:
          offsets[mainAxis] = offsets[mainAxis] + (reference2[len] / 2 - element2[len] / 2);
          break;
      }
    }
    return offsets;
  }
  function detectOverflow(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, _options$placement = _options.placement, placement = _options$placement === void 0 ? state.placement : _options$placement, _options$strategy = _options.strategy, strategy = _options$strategy === void 0 ? state.strategy : _options$strategy, _options$boundary = _options.boundary, boundary = _options$boundary === void 0 ? clippingParents : _options$boundary, _options$rootBoundary = _options.rootBoundary, rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary, _options$elementConte = _options.elementContext, elementContext = _options$elementConte === void 0 ? popper : _options$elementConte, _options$altBoundary = _options.altBoundary, altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary, _options$padding = _options.padding, padding = _options$padding === void 0 ? 0 : _options$padding;
    var paddingObject = mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
    var altContext = elementContext === popper ? reference : popper;
    var popperRect = state.rects.popper;
    var element2 = state.elements[altBoundary ? altContext : elementContext];
    var clippingClientRect = getClippingRect(isElement$3(element2) ? element2 : element2.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary, strategy);
    var referenceClientRect = getBoundingClientRect(state.elements.reference);
    var popperOffsets2 = computeOffsets({
      reference: referenceClientRect,
      element: popperRect,
      strategy: "absolute",
      placement
    });
    var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets2));
    var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
    var overflowOffsets = {
      top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
      bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
      left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
      right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    var offsetData = state.modifiersData.offset;
    if (elementContext === popper && offsetData) {
      var offset2 = offsetData[placement];
      Object.keys(overflowOffsets).forEach(function(key) {
        var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
        var axis = [top$1, bottom].indexOf(key) >= 0 ? "y" : "x";
        overflowOffsets[key] += offset2[axis] * multiply;
      });
    }
    return overflowOffsets;
  }
  function computeAutoPlacement(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, placement = _options.placement, boundary = _options.boundary, rootBoundary = _options.rootBoundary, padding = _options.padding, flipVariations = _options.flipVariations, _options$allowedAutoP = _options.allowedAutoPlacements, allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
    var variation = getVariation(placement);
    var placements$12 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function(placement2) {
      return getVariation(placement2) === variation;
    }) : basePlacements;
    var allowedPlacements = placements$12.filter(function(placement2) {
      return allowedAutoPlacements.indexOf(placement2) >= 0;
    });
    if (allowedPlacements.length === 0) {
      allowedPlacements = placements$12;
    }
    var overflows = allowedPlacements.reduce(function(acc, placement2) {
      acc[placement2] = detectOverflow(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding
      })[getBasePlacement$2(placement2)];
      return acc;
    }, {});
    return Object.keys(overflows).sort(function(a2, b2) {
      return overflows[a2] - overflows[b2];
    });
  }
  function getExpandedFallbackPlacements(placement) {
    if (getBasePlacement$2(placement) === auto) {
      return [];
    }
    var oppositePlacement = getOppositePlacement(placement);
    return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
  }
  function flip(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    if (state.modifiersData[name2]._skip) {
      return;
    }
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis, specifiedFallbackPlacements = options.fallbackPlacements, padding = options.padding, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, _options$flipVariatio = options.flipVariations, flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio, allowedAutoPlacements = options.allowedAutoPlacements;
    var preferredPlacement = state.options.placement;
    var basePlacement = getBasePlacement$2(preferredPlacement);
    var isBasePlacement = basePlacement === preferredPlacement;
    var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
    var placements2 = [preferredPlacement].concat(fallbackPlacements).reduce(function(acc, placement2) {
      return acc.concat(getBasePlacement$2(placement2) === auto ? computeAutoPlacement(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding,
        flipVariations,
        allowedAutoPlacements
      }) : placement2);
    }, []);
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var checksMap = /* @__PURE__ */ new Map();
    var makeFallbackChecks = true;
    var firstFittingPlacement = placements2[0];
    for (var i2 = 0; i2 < placements2.length; i2++) {
      var placement = placements2[i2];
      var _basePlacement = getBasePlacement$2(placement);
      var isStartVariation = getVariation(placement) === start$1;
      var isVertical = [top$1, bottom].indexOf(_basePlacement) >= 0;
      var len = isVertical ? "width" : "height";
      var overflow = detectOverflow(state, {
        placement,
        boundary,
        rootBoundary,
        altBoundary,
        padding
      });
      var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top$1;
      if (referenceRect[len] > popperRect[len]) {
        mainVariationSide = getOppositePlacement(mainVariationSide);
      }
      var altVariationSide = getOppositePlacement(mainVariationSide);
      var checks2 = [];
      if (checkMainAxis) {
        checks2.push(overflow[_basePlacement] <= 0);
      }
      if (checkAltAxis) {
        checks2.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
      }
      if (checks2.every(function(check) {
        return check;
      })) {
        firstFittingPlacement = placement;
        makeFallbackChecks = false;
        break;
      }
      checksMap.set(placement, checks2);
    }
    if (makeFallbackChecks) {
      var numberOfChecks = flipVariations ? 3 : 1;
      var _loop = function _loop2(_i2) {
        var fittingPlacement = placements2.find(function(placement2) {
          var checks3 = checksMap.get(placement2);
          if (checks3) {
            return checks3.slice(0, _i2).every(function(check) {
              return check;
            });
          }
        });
        if (fittingPlacement) {
          firstFittingPlacement = fittingPlacement;
          return "break";
        }
      };
      for (var _i = numberOfChecks; _i > 0; _i--) {
        var _ret = _loop(_i);
        if (_ret === "break")
          break;
      }
    }
    if (state.placement !== firstFittingPlacement) {
      state.modifiersData[name2]._skip = true;
      state.placement = firstFittingPlacement;
      state.reset = true;
    }
  }
  const flip$1 = {
    name: "flip",
    enabled: true,
    phase: "main",
    fn: flip,
    requiresIfExists: ["offset"],
    data: {
      _skip: false
    }
  };
  function getSideOffsets(overflow, rect, preventedOffsets) {
    if (preventedOffsets === void 0) {
      preventedOffsets = {
        x: 0,
        y: 0
      };
    }
    return {
      top: overflow.top - rect.height - preventedOffsets.y,
      right: overflow.right - rect.width + preventedOffsets.x,
      bottom: overflow.bottom - rect.height + preventedOffsets.y,
      left: overflow.left - rect.width - preventedOffsets.x
    };
  }
  function isAnySideFullyClipped(overflow) {
    return [top$1, right, bottom, left].some(function(side) {
      return overflow[side] >= 0;
    });
  }
  function hide(_ref2) {
    var state = _ref2.state, name2 = _ref2.name;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var preventedOffsets = state.modifiersData.preventOverflow;
    var referenceOverflow = detectOverflow(state, {
      elementContext: "reference"
    });
    var popperAltOverflow = detectOverflow(state, {
      altBoundary: true
    });
    var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
    var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
    var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
    var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
    state.modifiersData[name2] = {
      referenceClippingOffsets,
      popperEscapeOffsets,
      isReferenceHidden,
      hasPopperEscaped
    };
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-reference-hidden": isReferenceHidden,
      "data-popper-escaped": hasPopperEscaped
    });
  }
  const hide$1 = {
    name: "hide",
    enabled: true,
    phase: "main",
    requiresIfExists: ["preventOverflow"],
    fn: hide
  };
  function distanceAndSkiddingToXY(placement, rects, offset2) {
    var basePlacement = getBasePlacement$2(placement);
    var invertDistance = [left, top$1].indexOf(basePlacement) >= 0 ? -1 : 1;
    var _ref2 = typeof offset2 === "function" ? offset2(Object.assign({}, rects, {
      placement
    })) : offset2, skidding = _ref2[0], distance = _ref2[1];
    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left, right].indexOf(basePlacement) >= 0 ? {
      x: distance,
      y: skidding
    } : {
      x: skidding,
      y: distance
    };
  }
  function offset(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    var _options$offset = options.offset, offset2 = _options$offset === void 0 ? [0, 0] : _options$offset;
    var data2 = placements.reduce(function(acc, placement) {
      acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset2);
      return acc;
    }, {});
    var _data$state$placement = data2[state.placement], x2 = _data$state$placement.x, y2 = _data$state$placement.y;
    if (state.modifiersData.popperOffsets != null) {
      state.modifiersData.popperOffsets.x += x2;
      state.modifiersData.popperOffsets.y += y2;
    }
    state.modifiersData[name2] = data2;
  }
  const offset$1 = {
    name: "offset",
    enabled: true,
    phase: "main",
    requires: ["popperOffsets"],
    fn: offset
  };
  function popperOffsets(_ref2) {
    var state = _ref2.state, name2 = _ref2.name;
    state.modifiersData[name2] = computeOffsets({
      reference: state.rects.reference,
      element: state.rects.popper,
      strategy: "absolute",
      placement: state.placement
    });
  }
  const popperOffsets$1 = {
    name: "popperOffsets",
    enabled: true,
    phase: "read",
    fn: popperOffsets,
    data: {}
  };
  function getAltAxis(axis) {
    return axis === "x" ? "y" : "x";
  }
  function preventOverflow(_ref2) {
    var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, padding = options.padding, _options$tether = options.tether, tether = _options$tether === void 0 ? true : _options$tether, _options$tetherOffset = options.tetherOffset, tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
    var overflow = detectOverflow(state, {
      boundary,
      rootBoundary,
      padding,
      altBoundary
    });
    var basePlacement = getBasePlacement$2(state.placement);
    var variation = getVariation(state.placement);
    var isBasePlacement = !variation;
    var mainAxis = getMainAxisFromPlacement(basePlacement);
    var altAxis = getAltAxis(mainAxis);
    var popperOffsets2 = state.modifiersData.popperOffsets;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign({}, state.rects, {
      placement: state.placement
    })) : tetherOffset;
    var normalizedTetherOffsetValue = typeof tetherOffsetValue === "number" ? {
      mainAxis: tetherOffsetValue,
      altAxis: tetherOffsetValue
    } : Object.assign({
      mainAxis: 0,
      altAxis: 0
    }, tetherOffsetValue);
    var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
    var data2 = {
      x: 0,
      y: 0
    };
    if (!popperOffsets2) {
      return;
    }
    if (checkMainAxis) {
      var _offsetModifierState$;
      var mainSide = mainAxis === "y" ? top$1 : left;
      var altSide = mainAxis === "y" ? bottom : right;
      var len = mainAxis === "y" ? "height" : "width";
      var offset2 = popperOffsets2[mainAxis];
      var min2 = offset2 + overflow[mainSide];
      var max2 = offset2 - overflow[altSide];
      var additive = tether ? -popperRect[len] / 2 : 0;
      var minLen = variation === start$1 ? referenceRect[len] : popperRect[len];
      var maxLen = variation === start$1 ? -popperRect[len] : -referenceRect[len];
      var arrowElement = state.elements.arrow;
      var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
        width: 0,
        height: 0
      };
      var arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject();
      var arrowPaddingMin = arrowPaddingObject[mainSide];
      var arrowPaddingMax = arrowPaddingObject[altSide];
      var arrowLen = within(0, referenceRect[len], arrowRect[len]);
      var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
      var maxOffset2 = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
      var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
      var clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
      var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
      var tetherMin = offset2 + minOffset - offsetModifierValue - clientOffset;
      var tetherMax = offset2 + maxOffset2 - offsetModifierValue;
      var preventedOffset = within(tether ? min$3(min2, tetherMin) : min2, offset2, tether ? max$3(max2, tetherMax) : max2);
      popperOffsets2[mainAxis] = preventedOffset;
      data2[mainAxis] = preventedOffset - offset2;
    }
    if (checkAltAxis) {
      var _offsetModifierState$2;
      var _mainSide = mainAxis === "x" ? top$1 : left;
      var _altSide = mainAxis === "x" ? bottom : right;
      var _offset = popperOffsets2[altAxis];
      var _len = altAxis === "y" ? "height" : "width";
      var _min = _offset + overflow[_mainSide];
      var _max = _offset - overflow[_altSide];
      var isOriginSide = [top$1, left].indexOf(basePlacement) !== -1;
      var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;
      var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;
      var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;
      var _preventedOffset = tether && isOriginSide ? withinMaxClamp(_tetherMin, _offset, _tetherMax) : within(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);
      popperOffsets2[altAxis] = _preventedOffset;
      data2[altAxis] = _preventedOffset - _offset;
    }
    state.modifiersData[name2] = data2;
  }
  const preventOverflow$1 = {
    name: "preventOverflow",
    enabled: true,
    phase: "main",
    fn: preventOverflow,
    requiresIfExists: ["offset"]
  };
  function getHTMLElementScroll(element2) {
    return {
      scrollLeft: element2.scrollLeft,
      scrollTop: element2.scrollTop
    };
  }
  function getNodeScroll(node2) {
    if (node2 === getWindow(node2) || !isHTMLElement(node2)) {
      return getWindowScroll(node2);
    } else {
      return getHTMLElementScroll(node2);
    }
  }
  function isElementScaled(element2) {
    var rect = element2.getBoundingClientRect();
    var scaleX = round$2(rect.width) / element2.offsetWidth || 1;
    var scaleY = round$2(rect.height) / element2.offsetHeight || 1;
    return scaleX !== 1 || scaleY !== 1;
  }
  function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
    if (isFixed === void 0) {
      isFixed = false;
    }
    var isOffsetParentAnElement = isHTMLElement(offsetParent);
    var offsetParentIsScaled = isHTMLElement(offsetParent) && isElementScaled(offsetParent);
    var documentElement = getDocumentElement(offsetParent);
    var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled, isFixed);
    var scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    var offsets = {
      x: 0,
      y: 0
    };
    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName(offsetParent) !== "body" || isScrollParent(documentElement)) {
        scroll = getNodeScroll(offsetParent);
      }
      if (isHTMLElement(offsetParent)) {
        offsets = getBoundingClientRect(offsetParent, true);
        offsets.x += offsetParent.clientLeft;
        offsets.y += offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX(documentElement);
      }
    }
    return {
      x: rect.left + scroll.scrollLeft - offsets.x,
      y: rect.top + scroll.scrollTop - offsets.y,
      width: rect.width,
      height: rect.height
    };
  }
  function order$1(modifiers2) {
    var map2 = /* @__PURE__ */ new Map();
    var visited = /* @__PURE__ */ new Set();
    var result = [];
    modifiers2.forEach(function(modifier) {
      map2.set(modifier.name, modifier);
    });
    function sort2(modifier) {
      visited.add(modifier.name);
      var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
      requires.forEach(function(dep) {
        if (!visited.has(dep)) {
          var depModifier = map2.get(dep);
          if (depModifier) {
            sort2(depModifier);
          }
        }
      });
      result.push(modifier);
    }
    modifiers2.forEach(function(modifier) {
      if (!visited.has(modifier.name)) {
        sort2(modifier);
      }
    });
    return result;
  }
  function orderModifiers(modifiers2) {
    var orderedModifiers = order$1(modifiers2);
    return modifierPhases.reduce(function(acc, phase) {
      return acc.concat(orderedModifiers.filter(function(modifier) {
        return modifier.phase === phase;
      }));
    }, []);
  }
  function debounce$3(fn2) {
    var pending;
    return function() {
      if (!pending) {
        pending = new Promise(function(resolve2) {
          Promise.resolve().then(function() {
            pending = void 0;
            resolve2(fn2());
          });
        });
      }
      return pending;
    };
  }
  function mergeByName(modifiers2) {
    var merged = modifiers2.reduce(function(merged2, current) {
      var existing = merged2[current.name];
      merged2[current.name] = existing ? Object.assign({}, existing, current, {
        options: Object.assign({}, existing.options, current.options),
        data: Object.assign({}, existing.data, current.data)
      }) : current;
      return merged2;
    }, {});
    return Object.keys(merged).map(function(key) {
      return merged[key];
    });
  }
  var DEFAULT_OPTIONS$1 = {
    placement: "bottom",
    modifiers: [],
    strategy: "absolute"
  };
  function areValidElements() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return !args.some(function(element2) {
      return !(element2 && typeof element2.getBoundingClientRect === "function");
    });
  }
  function popperGenerator(generatorOptions) {
    if (generatorOptions === void 0) {
      generatorOptions = {};
    }
    var _generatorOptions = generatorOptions, _generatorOptions$def = _generatorOptions.defaultModifiers, defaultModifiers2 = _generatorOptions$def === void 0 ? [] : _generatorOptions$def, _generatorOptions$def2 = _generatorOptions.defaultOptions, defaultOptions2 = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS$1 : _generatorOptions$def2;
    return function createPopper2(reference2, popper2, options) {
      if (options === void 0) {
        options = defaultOptions2;
      }
      var state = {
        placement: "bottom",
        orderedModifiers: [],
        options: Object.assign({}, DEFAULT_OPTIONS$1, defaultOptions2),
        modifiersData: {},
        elements: {
          reference: reference2,
          popper: popper2
        },
        attributes: {},
        styles: {}
      };
      var effectCleanupFns = [];
      var isDestroyed = false;
      var instance2 = {
        state,
        setOptions: function setOptions2(setOptionsAction) {
          var options2 = typeof setOptionsAction === "function" ? setOptionsAction(state.options) : setOptionsAction;
          cleanupModifierEffects();
          state.options = Object.assign({}, defaultOptions2, state.options, options2);
          state.scrollParents = {
            reference: isElement$3(reference2) ? listScrollParents(reference2) : reference2.contextElement ? listScrollParents(reference2.contextElement) : [],
            popper: listScrollParents(popper2)
          };
          var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers2, state.options.modifiers)));
          state.orderedModifiers = orderedModifiers.filter(function(m2) {
            return m2.enabled;
          });
          runModifierEffects();
          return instance2.update();
        },
        forceUpdate: function forceUpdate() {
          if (isDestroyed) {
            return;
          }
          var _state$elements = state.elements, reference3 = _state$elements.reference, popper3 = _state$elements.popper;
          if (!areValidElements(reference3, popper3)) {
            return;
          }
          state.rects = {
            reference: getCompositeRect(reference3, getOffsetParent(popper3), state.options.strategy === "fixed"),
            popper: getLayoutRect(popper3)
          };
          state.reset = false;
          state.placement = state.options.placement;
          state.orderedModifiers.forEach(function(modifier) {
            return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
          });
          for (var index2 = 0; index2 < state.orderedModifiers.length; index2++) {
            if (state.reset === true) {
              state.reset = false;
              index2 = -1;
              continue;
            }
            var _state$orderedModifie = state.orderedModifiers[index2], fn2 = _state$orderedModifie.fn, _state$orderedModifie2 = _state$orderedModifie.options, _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2, name2 = _state$orderedModifie.name;
            if (typeof fn2 === "function") {
              state = fn2({
                state,
                options: _options,
                name: name2,
                instance: instance2
              }) || state;
            }
          }
        },
        update: debounce$3(function() {
          return new Promise(function(resolve2) {
            instance2.forceUpdate();
            resolve2(state);
          });
        }),
        destroy: function destroy() {
          cleanupModifierEffects();
          isDestroyed = true;
        }
      };
      if (!areValidElements(reference2, popper2)) {
        return instance2;
      }
      instance2.setOptions(options).then(function(state2) {
        if (!isDestroyed && options.onFirstUpdate) {
          options.onFirstUpdate(state2);
        }
      });
      function runModifierEffects() {
        state.orderedModifiers.forEach(function(_ref2) {
          var name2 = _ref2.name, _ref$options = _ref2.options, options2 = _ref$options === void 0 ? {} : _ref$options, effect2 = _ref2.effect;
          if (typeof effect2 === "function") {
            var cleanupFn = effect2({
              state,
              name: name2,
              instance: instance2,
              options: options2
            });
            var noopFn = function noopFn2() {
            };
            effectCleanupFns.push(cleanupFn || noopFn);
          }
        });
      }
      function cleanupModifierEffects() {
        effectCleanupFns.forEach(function(fn2) {
          return fn2();
        });
        effectCleanupFns = [];
      }
      return instance2;
    };
  }
  var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
  var createPopper = /* @__PURE__ */ popperGenerator({
    defaultModifiers
  });
  var CONTENT_CLASS$1 = "tippy-content";
  var BACKDROP_CLASS$1 = "tippy-backdrop";
  var ARROW_CLASS$1 = "tippy-arrow";
  var SVG_ARROW_CLASS$1 = "tippy-svg-arrow";
  var TOUCH_OPTIONS$1 = {
    passive: true,
    capture: true
  };
  function getValueAtIndexOrReturn$1(value, index2, defaultValue2) {
    if (Array.isArray(value)) {
      var v2 = value[index2];
      return v2 == null ? Array.isArray(defaultValue2) ? defaultValue2[index2] : defaultValue2 : v2;
    }
    return value;
  }
  function isType$1(value, type) {
    var str = {}.toString.call(value);
    return str.indexOf("[object") === 0 && str.indexOf(type + "]") > -1;
  }
  function invokeWithArgsOrReturn$1(value, args) {
    return typeof value === "function" ? value.apply(void 0, args) : value;
  }
  function debounce$2(fn2, ms2) {
    if (ms2 === 0) {
      return fn2;
    }
    var timeout2;
    return function(arg) {
      clearTimeout(timeout2);
      timeout2 = setTimeout(function() {
        fn2(arg);
      }, ms2);
    };
  }
  function splitBySpaces$1(value) {
    return value.split(/\s+/).filter(Boolean);
  }
  function normalizeToArray$1(value) {
    return [].concat(value);
  }
  function pushIfUnique$1(arr, value) {
    if (arr.indexOf(value) === -1) {
      arr.push(value);
    }
  }
  function unique$2(arr) {
    return arr.filter(function(item, index2) {
      return arr.indexOf(item) === index2;
    });
  }
  function getBasePlacement$1(placement) {
    return placement.split("-")[0];
  }
  function arrayFrom$1(value) {
    return [].slice.call(value);
  }
  function removeUndefinedProps$1(obj) {
    return Object.keys(obj).reduce(function(acc, key) {
      if (obj[key] !== void 0) {
        acc[key] = obj[key];
      }
      return acc;
    }, {});
  }
  function div$1() {
    return document.createElement("div");
  }
  function isElement$2(value) {
    return ["Element", "Fragment"].some(function(type) {
      return isType$1(value, type);
    });
  }
  function isNodeList$2(value) {
    return isType$1(value, "NodeList");
  }
  function isMouseEvent$1(value) {
    return isType$1(value, "MouseEvent");
  }
  function isReferenceElement$1(value) {
    return !!(value && value._tippy && value._tippy.reference === value);
  }
  function getArrayOfElements$1(value) {
    if (isElement$2(value)) {
      return [value];
    }
    if (isNodeList$2(value)) {
      return arrayFrom$1(value);
    }
    if (Array.isArray(value)) {
      return value;
    }
    return arrayFrom$1(document.querySelectorAll(value));
  }
  function setTransitionDuration$1(els, value) {
    els.forEach(function(el) {
      if (el) {
        el.style.transitionDuration = value + "ms";
      }
    });
  }
  function setVisibilityState$1(els, state) {
    els.forEach(function(el) {
      if (el) {
        el.setAttribute("data-state", state);
      }
    });
  }
  function getOwnerDocument$1(elementOrElements) {
    var _normalizeToArray = normalizeToArray$1(elementOrElements), element2 = _normalizeToArray[0];
    return element2 ? element2.ownerDocument || document : document;
  }
  function isCursorOutsideInteractiveBorder$1(popperTreeData, event2) {
    var clientX = event2.clientX, clientY = event2.clientY;
    return popperTreeData.every(function(_ref2) {
      var popperRect = _ref2.popperRect, popperState = _ref2.popperState, props = _ref2.props;
      var interactiveBorder = props.interactiveBorder;
      var basePlacement = getBasePlacement$1(popperState.placement);
      var offsetData = popperState.modifiersData.offset;
      if (!offsetData) {
        return true;
      }
      var topDistance = basePlacement === "bottom" ? offsetData.top.y : 0;
      var bottomDistance = basePlacement === "top" ? offsetData.bottom.y : 0;
      var leftDistance = basePlacement === "right" ? offsetData.left.x : 0;
      var rightDistance = basePlacement === "left" ? offsetData.right.x : 0;
      var exceedsTop = popperRect.top - clientY + topDistance > interactiveBorder;
      var exceedsBottom = clientY - popperRect.bottom - bottomDistance > interactiveBorder;
      var exceedsLeft = popperRect.left - clientX + leftDistance > interactiveBorder;
      var exceedsRight = clientX - popperRect.right - rightDistance > interactiveBorder;
      return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
    });
  }
  function updateTransitionEndListener$1(box, action, listener2) {
    var method = action + "EventListener";
    ["transitionend", "webkitTransitionEnd"].forEach(function(event2) {
      box[method](event2, listener2);
    });
  }
  var currentInput$1 = {
    isTouch: false
  };
  var lastMouseMoveTime$1 = 0;
  function onDocumentTouchStart$1() {
    if (currentInput$1.isTouch) {
      return;
    }
    currentInput$1.isTouch = true;
    if (window.performance) {
      document.addEventListener("mousemove", onDocumentMouseMove$1);
    }
  }
  function onDocumentMouseMove$1() {
    var now2 = performance.now();
    if (now2 - lastMouseMoveTime$1 < 20) {
      currentInput$1.isTouch = false;
      document.removeEventListener("mousemove", onDocumentMouseMove$1);
    }
    lastMouseMoveTime$1 = now2;
  }
  function onWindowBlur$1() {
    var activeElement = document.activeElement;
    if (isReferenceElement$1(activeElement)) {
      var instance2 = activeElement._tippy;
      if (activeElement.blur && !instance2.state.isVisible) {
        activeElement.blur();
      }
    }
  }
  function bindGlobalEventListeners$1() {
    document.addEventListener("touchstart", onDocumentTouchStart$1, TOUCH_OPTIONS$1);
    window.addEventListener("blur", onWindowBlur$1);
  }
  var isBrowser$3 = typeof window !== "undefined" && typeof document !== "undefined";
  var ua$1 = isBrowser$3 ? navigator.userAgent : "";
  var isIE$1 = /MSIE |Trident\//.test(ua$1);
  var pluginProps$1 = {
    animateFill: false,
    followCursor: false,
    inlinePositioning: false,
    sticky: false
  };
  var renderProps$1 = {
    allowHTML: false,
    animation: "fade",
    arrow: true,
    content: "",
    inertia: false,
    maxWidth: 350,
    role: "tooltip",
    theme: "",
    zIndex: 9999
  };
  var defaultProps$2 = Object.assign({
    appendTo: function appendTo() {
      return document.body;
    },
    aria: {
      content: "auto",
      expanded: "auto"
    },
    delay: 0,
    duration: [300, 250],
    getReferenceClientRect: null,
    hideOnClick: true,
    ignoreAttributes: false,
    interactive: false,
    interactiveBorder: 2,
    interactiveDebounce: 0,
    moveTransition: "",
    offset: [0, 10],
    onAfterUpdate: function onAfterUpdate() {
    },
    onBeforeUpdate: function onBeforeUpdate() {
    },
    onCreate: function onCreate() {
    },
    onDestroy: function onDestroy() {
    },
    onHidden: function onHidden() {
    },
    onHide: function onHide() {
    },
    onMount: function onMount() {
    },
    onShow: function onShow() {
    },
    onShown: function onShown() {
    },
    onTrigger: function onTrigger() {
    },
    onUntrigger: function onUntrigger() {
    },
    onClickOutside: function onClickOutside() {
    },
    placement: "top",
    plugins: [],
    popperOptions: {},
    render: null,
    showOnCreate: false,
    touch: true,
    trigger: "mouseenter focus",
    triggerTarget: null
  }, pluginProps$1, {}, renderProps$1);
  var defaultKeys$1 = Object.keys(defaultProps$2);
  var setDefaultProps$1 = function setDefaultProps2(partialProps) {
    var keys2 = Object.keys(partialProps);
    keys2.forEach(function(key) {
      defaultProps$2[key] = partialProps[key];
    });
  };
  function getExtendedPassedProps$1(passedProps) {
    var plugins2 = passedProps.plugins || [];
    var pluginProps2 = plugins2.reduce(function(acc, plugin) {
      var name2 = plugin.name, defaultValue2 = plugin.defaultValue;
      if (name2) {
        acc[name2] = passedProps[name2] !== void 0 ? passedProps[name2] : defaultValue2;
      }
      return acc;
    }, {});
    return Object.assign({}, passedProps, {}, pluginProps2);
  }
  function getDataAttributeProps$1(reference2, plugins2) {
    var propKeys = plugins2 ? Object.keys(getExtendedPassedProps$1(Object.assign({}, defaultProps$2, {
      plugins: plugins2
    }))) : defaultKeys$1;
    var props = propKeys.reduce(function(acc, key) {
      var valueAsString = (reference2.getAttribute("data-tippy-" + key) || "").trim();
      if (!valueAsString) {
        return acc;
      }
      if (key === "content") {
        acc[key] = valueAsString;
      } else {
        try {
          acc[key] = JSON.parse(valueAsString);
        } catch (e3) {
          acc[key] = valueAsString;
        }
      }
      return acc;
    }, {});
    return props;
  }
  function evaluateProps$1(reference2, props) {
    var out = Object.assign({}, props, {
      content: invokeWithArgsOrReturn$1(props.content, [reference2])
    }, props.ignoreAttributes ? {} : getDataAttributeProps$1(reference2, props.plugins));
    out.aria = Object.assign({}, defaultProps$2.aria, {}, out.aria);
    out.aria = {
      expanded: out.aria.expanded === "auto" ? props.interactive : out.aria.expanded,
      content: out.aria.content === "auto" ? props.interactive ? null : "describedby" : out.aria.content
    };
    return out;
  }
  function getChildren$2(popper2) {
    var box = popper2.firstElementChild;
    var boxChildren = arrayFrom$1(box.children);
    return {
      box,
      content: boxChildren.find(function(node2) {
        return node2.classList.contains(CONTENT_CLASS$1);
      }),
      arrow: boxChildren.find(function(node2) {
        return node2.classList.contains(ARROW_CLASS$1) || node2.classList.contains(SVG_ARROW_CLASS$1);
      }),
      backdrop: boxChildren.find(function(node2) {
        return node2.classList.contains(BACKDROP_CLASS$1);
      })
    };
  }
  var idCounter$1 = 1;
  var mouseMoveListeners$1 = [];
  var mountedInstances$1 = [];
  function createTippy$1(reference2, passedProps) {
    var props = evaluateProps$1(reference2, Object.assign({}, defaultProps$2, {}, getExtendedPassedProps$1(removeUndefinedProps$1(passedProps))));
    var showTimeout;
    var hideTimeout;
    var scheduleHideAnimationFrame;
    var isVisibleFromClick = false;
    var didHideDueToDocumentMouseDown = false;
    var didTouchMove = false;
    var ignoreOnFirstUpdate = false;
    var lastTriggerEvent;
    var currentTransitionEndListener;
    var onFirstUpdate;
    var listeners = [];
    var debouncedOnMouseMove = debounce$2(onMouseMove, props.interactiveDebounce);
    var currentTarget;
    var doc2 = getOwnerDocument$1(props.triggerTarget || reference2);
    var id2 = idCounter$1++;
    var popperInstance = null;
    var plugins2 = unique$2(props.plugins);
    var state = {
      isEnabled: true,
      isVisible: false,
      isDestroyed: false,
      isMounted: false,
      isShown: false
    };
    var instance2 = {
      id: id2,
      reference: reference2,
      popper: div$1(),
      popperInstance,
      props,
      state,
      plugins: plugins2,
      clearDelayTimeouts,
      setProps,
      setContent: setContent2,
      show,
      hide: hide2,
      hideWithInteractivity,
      enable,
      disable: disable2,
      unmount,
      destroy
    };
    if (!props.render) {
      return instance2;
    }
    var _props$render = props.render(instance2), popper2 = _props$render.popper, onUpdate = _props$render.onUpdate;
    popper2.setAttribute("data-tippy-root", "");
    popper2.id = "tippy-" + instance2.id;
    instance2.popper = popper2;
    reference2._tippy = instance2;
    popper2._tippy = instance2;
    var pluginsHooks = plugins2.map(function(plugin) {
      return plugin.fn(instance2);
    });
    var hasAriaExpanded = reference2.hasAttribute("aria-expanded");
    addListeners();
    handleAriaExpandedAttribute();
    handleStyles();
    invokeHook("onCreate", [instance2]);
    if (props.showOnCreate) {
      scheduleShow();
    }
    popper2.addEventListener("mouseenter", function() {
      if (instance2.props.interactive && instance2.state.isVisible) {
        instance2.clearDelayTimeouts();
      }
    });
    popper2.addEventListener("mouseleave", function(event2) {
      if (instance2.props.interactive && instance2.props.trigger.indexOf("mouseenter") >= 0) {
        doc2.addEventListener("mousemove", debouncedOnMouseMove);
        debouncedOnMouseMove(event2);
      }
    });
    return instance2;
    function getNormalizedTouchSettings() {
      var touch = instance2.props.touch;
      return Array.isArray(touch) ? touch : [touch, 0];
    }
    function getIsCustomTouchBehavior() {
      return getNormalizedTouchSettings()[0] === "hold";
    }
    function getIsDefaultRenderFn() {
      var _instance$props$rende;
      return !!((_instance$props$rende = instance2.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
    }
    function getCurrentTarget() {
      return currentTarget || reference2;
    }
    function getDefaultTemplateChildren() {
      return getChildren$2(popper2);
    }
    function getDelay(isShow) {
      if (instance2.state.isMounted && !instance2.state.isVisible || currentInput$1.isTouch || lastTriggerEvent && lastTriggerEvent.type === "focus") {
        return 0;
      }
      return getValueAtIndexOrReturn$1(instance2.props.delay, isShow ? 0 : 1, defaultProps$2.delay);
    }
    function handleStyles() {
      popper2.style.pointerEvents = instance2.props.interactive && instance2.state.isVisible ? "" : "none";
      popper2.style.zIndex = "" + instance2.props.zIndex;
    }
    function invokeHook(hook, args, shouldInvokePropsHook) {
      if (shouldInvokePropsHook === void 0) {
        shouldInvokePropsHook = true;
      }
      pluginsHooks.forEach(function(pluginHooks) {
        if (pluginHooks[hook]) {
          pluginHooks[hook].apply(void 0, args);
        }
      });
      if (shouldInvokePropsHook) {
        var _instance$props;
        (_instance$props = instance2.props)[hook].apply(_instance$props, args);
      }
    }
    function handleAriaContentAttribute() {
      var aria2 = instance2.props.aria;
      if (!aria2.content) {
        return;
      }
      var attr = "aria-" + aria2.content;
      var id3 = popper2.id;
      var nodes = normalizeToArray$1(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        var currentValue = node2.getAttribute(attr);
        if (instance2.state.isVisible) {
          node2.setAttribute(attr, currentValue ? currentValue + " " + id3 : id3);
        } else {
          var nextValue = currentValue && currentValue.replace(id3, "").trim();
          if (nextValue) {
            node2.setAttribute(attr, nextValue);
          } else {
            node2.removeAttribute(attr);
          }
        }
      });
    }
    function handleAriaExpandedAttribute() {
      if (hasAriaExpanded || !instance2.props.aria.expanded) {
        return;
      }
      var nodes = normalizeToArray$1(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        if (instance2.props.interactive) {
          node2.setAttribute("aria-expanded", instance2.state.isVisible && node2 === getCurrentTarget() ? "true" : "false");
        } else {
          node2.removeAttribute("aria-expanded");
        }
      });
    }
    function cleanupInteractiveMouseListeners() {
      doc2.removeEventListener("mousemove", debouncedOnMouseMove);
      mouseMoveListeners$1 = mouseMoveListeners$1.filter(function(listener2) {
        return listener2 !== debouncedOnMouseMove;
      });
    }
    function onDocumentPress(event2) {
      if (currentInput$1.isTouch) {
        if (didTouchMove || event2.type === "mousedown") {
          return;
        }
      }
      if (instance2.props.interactive && popper2.contains(event2.target)) {
        return;
      }
      if (getCurrentTarget().contains(event2.target)) {
        if (currentInput$1.isTouch) {
          return;
        }
        if (instance2.state.isVisible && instance2.props.trigger.indexOf("click") >= 0) {
          return;
        }
      } else {
        invokeHook("onClickOutside", [instance2, event2]);
      }
      if (instance2.props.hideOnClick === true) {
        instance2.clearDelayTimeouts();
        instance2.hide();
        didHideDueToDocumentMouseDown = true;
        setTimeout(function() {
          didHideDueToDocumentMouseDown = false;
        });
        if (!instance2.state.isMounted) {
          removeDocumentPress();
        }
      }
    }
    function onTouchMove() {
      didTouchMove = true;
    }
    function onTouchStart() {
      didTouchMove = false;
    }
    function addDocumentPress() {
      doc2.addEventListener("mousedown", onDocumentPress, true);
      doc2.addEventListener("touchend", onDocumentPress, TOUCH_OPTIONS$1);
      doc2.addEventListener("touchstart", onTouchStart, TOUCH_OPTIONS$1);
      doc2.addEventListener("touchmove", onTouchMove, TOUCH_OPTIONS$1);
    }
    function removeDocumentPress() {
      doc2.removeEventListener("mousedown", onDocumentPress, true);
      doc2.removeEventListener("touchend", onDocumentPress, TOUCH_OPTIONS$1);
      doc2.removeEventListener("touchstart", onTouchStart, TOUCH_OPTIONS$1);
      doc2.removeEventListener("touchmove", onTouchMove, TOUCH_OPTIONS$1);
    }
    function onTransitionedOut(duration, callback) {
      onTransitionEnd(duration, function() {
        if (!instance2.state.isVisible && popper2.parentNode && popper2.parentNode.contains(popper2)) {
          callback();
        }
      });
    }
    function onTransitionedIn(duration, callback) {
      onTransitionEnd(duration, callback);
    }
    function onTransitionEnd(duration, callback) {
      var box = getDefaultTemplateChildren().box;
      function listener2(event2) {
        if (event2.target === box) {
          updateTransitionEndListener$1(box, "remove", listener2);
          callback();
        }
      }
      if (duration === 0) {
        return callback();
      }
      updateTransitionEndListener$1(box, "remove", currentTransitionEndListener);
      updateTransitionEndListener$1(box, "add", listener2);
      currentTransitionEndListener = listener2;
    }
    function on2(eventType, handler, options) {
      if (options === void 0) {
        options = false;
      }
      var nodes = normalizeToArray$1(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        node2.addEventListener(eventType, handler, options);
        listeners.push({
          node: node2,
          eventType,
          handler,
          options
        });
      });
    }
    function addListeners() {
      if (getIsCustomTouchBehavior()) {
        on2("touchstart", onTrigger, {
          passive: true
        });
        on2("touchend", onMouseLeave, {
          passive: true
        });
      }
      splitBySpaces$1(instance2.props.trigger).forEach(function(eventType) {
        if (eventType === "manual") {
          return;
        }
        on2(eventType, onTrigger);
        switch (eventType) {
          case "mouseenter":
            on2("mouseleave", onMouseLeave);
            break;
          case "focus":
            on2(isIE$1 ? "focusout" : "blur", onBlurOrFocusOut);
            break;
          case "focusin":
            on2("focusout", onBlurOrFocusOut);
            break;
        }
      });
    }
    function removeListeners() {
      listeners.forEach(function(_ref2) {
        var node2 = _ref2.node, eventType = _ref2.eventType, handler = _ref2.handler, options = _ref2.options;
        node2.removeEventListener(eventType, handler, options);
      });
      listeners = [];
    }
    function onTrigger(event2) {
      var _lastTriggerEvent;
      var shouldScheduleClickHide = false;
      if (!instance2.state.isEnabled || isEventListenerStopped(event2) || didHideDueToDocumentMouseDown) {
        return;
      }
      var wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == null ? void 0 : _lastTriggerEvent.type) === "focus";
      lastTriggerEvent = event2;
      currentTarget = event2.currentTarget;
      handleAriaExpandedAttribute();
      if (!instance2.state.isVisible && isMouseEvent$1(event2)) {
        mouseMoveListeners$1.forEach(function(listener2) {
          return listener2(event2);
        });
      }
      if (event2.type === "click" && (instance2.props.trigger.indexOf("mouseenter") < 0 || isVisibleFromClick) && instance2.props.hideOnClick !== false && instance2.state.isVisible) {
        shouldScheduleClickHide = true;
      } else {
        scheduleShow(event2);
      }
      if (event2.type === "click") {
        isVisibleFromClick = !shouldScheduleClickHide;
      }
      if (shouldScheduleClickHide && !wasFocused) {
        scheduleHide(event2);
      }
    }
    function onMouseMove(event2) {
      var target = event2.target;
      var isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper2.contains(target);
      if (event2.type === "mousemove" && isCursorOverReferenceOrPopper) {
        return;
      }
      var popperTreeData = getNestedPopperTree().concat(popper2).map(function(popper3) {
        var _instance$popperInsta;
        var instance3 = popper3._tippy;
        var state2 = (_instance$popperInsta = instance3.popperInstance) == null ? void 0 : _instance$popperInsta.state;
        if (state2) {
          return {
            popperRect: popper3.getBoundingClientRect(),
            popperState: state2,
            props
          };
        }
        return null;
      }).filter(Boolean);
      if (isCursorOutsideInteractiveBorder$1(popperTreeData, event2)) {
        cleanupInteractiveMouseListeners();
        scheduleHide(event2);
      }
    }
    function onMouseLeave(event2) {
      var shouldBail = isEventListenerStopped(event2) || instance2.props.trigger.indexOf("click") >= 0 && isVisibleFromClick;
      if (shouldBail) {
        return;
      }
      if (instance2.props.interactive) {
        instance2.hideWithInteractivity(event2);
        return;
      }
      scheduleHide(event2);
    }
    function onBlurOrFocusOut(event2) {
      if (instance2.props.trigger.indexOf("focusin") < 0 && event2.target !== getCurrentTarget()) {
        return;
      }
      if (instance2.props.interactive && event2.relatedTarget && popper2.contains(event2.relatedTarget)) {
        return;
      }
      scheduleHide(event2);
    }
    function isEventListenerStopped(event2) {
      return currentInput$1.isTouch ? getIsCustomTouchBehavior() !== event2.type.indexOf("touch") >= 0 : false;
    }
    function createPopperInstance() {
      destroyPopperInstance();
      var _instance$props2 = instance2.props, popperOptions = _instance$props2.popperOptions, placement = _instance$props2.placement, offset2 = _instance$props2.offset, getReferenceClientRect = _instance$props2.getReferenceClientRect, moveTransition = _instance$props2.moveTransition;
      var arrow2 = getIsDefaultRenderFn() ? getChildren$2(popper2).arrow : null;
      var computedReference = getReferenceClientRect ? {
        getBoundingClientRect: getReferenceClientRect,
        contextElement: getReferenceClientRect.contextElement || getCurrentTarget()
      } : reference2;
      var tippyModifier = {
        name: "$$tippy",
        enabled: true,
        phase: "beforeWrite",
        requires: ["computeStyles"],
        fn: function fn2(_ref2) {
          var state2 = _ref2.state;
          if (getIsDefaultRenderFn()) {
            var _getDefaultTemplateCh = getDefaultTemplateChildren(), box = _getDefaultTemplateCh.box;
            ["placement", "reference-hidden", "escaped"].forEach(function(attr) {
              if (attr === "placement") {
                box.setAttribute("data-placement", state2.placement);
              } else {
                if (state2.attributes.popper["data-popper-" + attr]) {
                  box.setAttribute("data-" + attr, "");
                } else {
                  box.removeAttribute("data-" + attr);
                }
              }
            });
            state2.attributes.popper = {};
          }
        }
      };
      var modifiers2 = [{
        name: "offset",
        options: {
          offset: offset2
        }
      }, {
        name: "preventOverflow",
        options: {
          padding: {
            top: 2,
            bottom: 2,
            left: 5,
            right: 5
          }
        }
      }, {
        name: "flip",
        options: {
          padding: 5
        }
      }, {
        name: "computeStyles",
        options: {
          adaptive: !moveTransition
        }
      }, tippyModifier];
      if (getIsDefaultRenderFn() && arrow2) {
        modifiers2.push({
          name: "arrow",
          options: {
            element: arrow2,
            padding: 3
          }
        });
      }
      modifiers2.push.apply(modifiers2, (popperOptions == null ? void 0 : popperOptions.modifiers) || []);
      instance2.popperInstance = createPopper(computedReference, popper2, Object.assign({}, popperOptions, {
        placement,
        onFirstUpdate,
        modifiers: modifiers2
      }));
    }
    function destroyPopperInstance() {
      if (instance2.popperInstance) {
        instance2.popperInstance.destroy();
        instance2.popperInstance = null;
      }
    }
    function mount() {
      var appendTo = instance2.props.appendTo;
      var parentNode;
      var node2 = getCurrentTarget();
      if (instance2.props.interactive && appendTo === defaultProps$2.appendTo || appendTo === "parent") {
        parentNode = node2.parentNode;
      } else {
        parentNode = invokeWithArgsOrReturn$1(appendTo, [node2]);
      }
      if (!parentNode.contains(popper2)) {
        parentNode.appendChild(popper2);
      }
      createPopperInstance();
    }
    function getNestedPopperTree() {
      return arrayFrom$1(popper2.querySelectorAll("[data-tippy-root]"));
    }
    function scheduleShow(event2) {
      instance2.clearDelayTimeouts();
      if (event2) {
        invokeHook("onTrigger", [instance2, event2]);
      }
      addDocumentPress();
      var delay = getDelay(true);
      var _getNormalizedTouchSe = getNormalizedTouchSettings(), touchValue = _getNormalizedTouchSe[0], touchDelay = _getNormalizedTouchSe[1];
      if (currentInput$1.isTouch && touchValue === "hold" && touchDelay) {
        delay = touchDelay;
      }
      if (delay) {
        showTimeout = setTimeout(function() {
          instance2.show();
        }, delay);
      } else {
        instance2.show();
      }
    }
    function scheduleHide(event2) {
      instance2.clearDelayTimeouts();
      invokeHook("onUntrigger", [instance2, event2]);
      if (!instance2.state.isVisible) {
        removeDocumentPress();
        return;
      }
      if (instance2.props.trigger.indexOf("mouseenter") >= 0 && instance2.props.trigger.indexOf("click") >= 0 && ["mouseleave", "mousemove"].indexOf(event2.type) >= 0 && isVisibleFromClick) {
        return;
      }
      var delay = getDelay(false);
      if (delay) {
        hideTimeout = setTimeout(function() {
          if (instance2.state.isVisible) {
            instance2.hide();
          }
        }, delay);
      } else {
        scheduleHideAnimationFrame = requestAnimationFrame(function() {
          instance2.hide();
        });
      }
    }
    function enable() {
      instance2.state.isEnabled = true;
    }
    function disable2() {
      instance2.hide();
      instance2.state.isEnabled = false;
    }
    function clearDelayTimeouts() {
      clearTimeout(showTimeout);
      clearTimeout(hideTimeout);
      cancelAnimationFrame(scheduleHideAnimationFrame);
    }
    function setProps(partialProps) {
      if (instance2.state.isDestroyed) {
        return;
      }
      invokeHook("onBeforeUpdate", [instance2, partialProps]);
      removeListeners();
      var prevProps = instance2.props;
      var nextProps = evaluateProps$1(reference2, Object.assign({}, instance2.props, {}, partialProps, {
        ignoreAttributes: true
      }));
      instance2.props = nextProps;
      addListeners();
      if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
        cleanupInteractiveMouseListeners();
        debouncedOnMouseMove = debounce$2(onMouseMove, nextProps.interactiveDebounce);
      }
      if (prevProps.triggerTarget && !nextProps.triggerTarget) {
        normalizeToArray$1(prevProps.triggerTarget).forEach(function(node2) {
          node2.removeAttribute("aria-expanded");
        });
      } else if (nextProps.triggerTarget) {
        reference2.removeAttribute("aria-expanded");
      }
      handleAriaExpandedAttribute();
      handleStyles();
      if (onUpdate) {
        onUpdate(prevProps, nextProps);
      }
      if (instance2.popperInstance) {
        createPopperInstance();
        getNestedPopperTree().forEach(function(nestedPopper) {
          requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
        });
      }
      invokeHook("onAfterUpdate", [instance2, partialProps]);
    }
    function setContent2(content2) {
      instance2.setProps({
        content: content2
      });
    }
    function show() {
      var isAlreadyVisible = instance2.state.isVisible;
      var isDestroyed = instance2.state.isDestroyed;
      var isDisabled = !instance2.state.isEnabled;
      var isTouchAndTouchDisabled = currentInput$1.isTouch && !instance2.props.touch;
      var duration = getValueAtIndexOrReturn$1(instance2.props.duration, 0, defaultProps$2.duration);
      if (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
        return;
      }
      if (getCurrentTarget().hasAttribute("disabled")) {
        return;
      }
      invokeHook("onShow", [instance2], false);
      if (instance2.props.onShow(instance2) === false) {
        return;
      }
      instance2.state.isVisible = true;
      if (getIsDefaultRenderFn()) {
        popper2.style.visibility = "visible";
      }
      handleStyles();
      addDocumentPress();
      if (!instance2.state.isMounted) {
        popper2.style.transition = "none";
      }
      if (getIsDefaultRenderFn()) {
        var _getDefaultTemplateCh2 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh2.box, content2 = _getDefaultTemplateCh2.content;
        setTransitionDuration$1([box, content2], 0);
      }
      onFirstUpdate = function onFirstUpdate2() {
        if (!instance2.state.isVisible || ignoreOnFirstUpdate) {
          return;
        }
        ignoreOnFirstUpdate = true;
        void popper2.offsetHeight;
        popper2.style.transition = instance2.props.moveTransition;
        if (getIsDefaultRenderFn() && instance2.props.animation) {
          var _getDefaultTemplateCh3 = getDefaultTemplateChildren(), _box = _getDefaultTemplateCh3.box, _content = _getDefaultTemplateCh3.content;
          setTransitionDuration$1([_box, _content], duration);
          setVisibilityState$1([_box, _content], "visible");
        }
        handleAriaContentAttribute();
        handleAriaExpandedAttribute();
        pushIfUnique$1(mountedInstances$1, instance2);
        instance2.state.isMounted = true;
        invokeHook("onMount", [instance2]);
        if (instance2.props.animation && getIsDefaultRenderFn()) {
          onTransitionedIn(duration, function() {
            instance2.state.isShown = true;
            invokeHook("onShown", [instance2]);
          });
        }
      };
      mount();
    }
    function hide2() {
      var isAlreadyHidden = !instance2.state.isVisible;
      var isDestroyed = instance2.state.isDestroyed;
      var isDisabled = !instance2.state.isEnabled;
      var duration = getValueAtIndexOrReturn$1(instance2.props.duration, 1, defaultProps$2.duration);
      if (isAlreadyHidden || isDestroyed || isDisabled) {
        return;
      }
      invokeHook("onHide", [instance2], false);
      if (instance2.props.onHide(instance2) === false) {
        return;
      }
      instance2.state.isVisible = false;
      instance2.state.isShown = false;
      ignoreOnFirstUpdate = false;
      isVisibleFromClick = false;
      if (getIsDefaultRenderFn()) {
        popper2.style.visibility = "hidden";
      }
      cleanupInteractiveMouseListeners();
      removeDocumentPress();
      handleStyles();
      if (getIsDefaultRenderFn()) {
        var _getDefaultTemplateCh4 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh4.box, content2 = _getDefaultTemplateCh4.content;
        if (instance2.props.animation) {
          setTransitionDuration$1([box, content2], duration);
          setVisibilityState$1([box, content2], "hidden");
        }
      }
      handleAriaContentAttribute();
      handleAriaExpandedAttribute();
      if (instance2.props.animation) {
        if (getIsDefaultRenderFn()) {
          onTransitionedOut(duration, instance2.unmount);
        }
      } else {
        instance2.unmount();
      }
    }
    function hideWithInteractivity(event2) {
      doc2.addEventListener("mousemove", debouncedOnMouseMove);
      pushIfUnique$1(mouseMoveListeners$1, debouncedOnMouseMove);
      debouncedOnMouseMove(event2);
    }
    function unmount() {
      if (instance2.state.isVisible) {
        instance2.hide();
      }
      if (!instance2.state.isMounted) {
        return;
      }
      destroyPopperInstance();
      getNestedPopperTree().forEach(function(nestedPopper) {
        nestedPopper._tippy.unmount();
      });
      if (popper2.parentNode) {
        popper2.parentNode.removeChild(popper2);
      }
      mountedInstances$1 = mountedInstances$1.filter(function(i2) {
        return i2 !== instance2;
      });
      instance2.state.isMounted = false;
      invokeHook("onHidden", [instance2]);
    }
    function destroy() {
      if (instance2.state.isDestroyed) {
        return;
      }
      instance2.clearDelayTimeouts();
      instance2.unmount();
      removeListeners();
      delete reference2._tippy;
      instance2.state.isDestroyed = true;
      invokeHook("onDestroy", [instance2]);
    }
  }
  function tippy$1(targets, optionalProps) {
    if (optionalProps === void 0) {
      optionalProps = {};
    }
    var plugins2 = defaultProps$2.plugins.concat(optionalProps.plugins || []);
    bindGlobalEventListeners$1();
    var passedProps = Object.assign({}, optionalProps, {
      plugins: plugins2
    });
    var elements = getArrayOfElements$1(targets);
    var instances = elements.reduce(function(acc, reference2) {
      var instance2 = reference2 && createTippy$1(reference2, passedProps);
      if (instance2) {
        acc.push(instance2);
      }
      return acc;
    }, []);
    return isElement$2(targets) ? instances[0] : instances;
  }
  tippy$1.defaultProps = defaultProps$2;
  tippy$1.setDefaultProps = setDefaultProps$1;
  tippy$1.currentInput = currentInput$1;
  tippy$1.setDefaultProps({
    animation: false
  });
  function _objectWithoutPropertiesLoose$4(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  var isBrowser$2 = typeof window !== "undefined" && typeof document !== "undefined";
  function preserveRef(ref, node2) {
    if (ref) {
      if (typeof ref === "function") {
        ref(node2);
      }
      if ({}.hasOwnProperty.call(ref, "current")) {
        ref.current = node2;
      }
    }
  }
  function ssrSafeCreateDiv() {
    return isBrowser$2 && document.createElement("div");
  }
  function toDataAttributes(attrs2) {
    var dataAttrs = {
      "data-placement": attrs2.placement
    };
    if (attrs2.referenceHidden) {
      dataAttrs["data-reference-hidden"] = "";
    }
    if (attrs2.escaped) {
      dataAttrs["data-escaped"] = "";
    }
    return dataAttrs;
  }
  function deepPreserveProps(instanceProps, componentProps) {
    var _instanceProps$popper, _componentProps$poppe;
    return Object.assign({}, componentProps, {
      popperOptions: Object.assign({}, instanceProps.popperOptions, componentProps.popperOptions, {
        modifiers: [].concat((((_instanceProps$popper = instanceProps.popperOptions) == null ? void 0 : _instanceProps$popper.modifiers) || []).filter(function(modifier) {
          return modifier.name.indexOf("tippy") >= 0;
        }), ((_componentProps$poppe = componentProps.popperOptions) == null ? void 0 : _componentProps$poppe.modifiers) || [])
      })
    });
  }
  var useIsomorphicLayoutEffect$2 = isBrowser$2 ? React.useLayoutEffect : React.useEffect;
  function useMutableBox(initialValue) {
    var ref = React.useRef();
    if (!ref.current) {
      ref.current = typeof initialValue === "function" ? initialValue() : initialValue;
    }
    return ref.current;
  }
  function updateClassName(box, action, classNames) {
    classNames.split(/\s+/).forEach(function(name2) {
      if (name2) {
        box.classList[action](name2);
      }
    });
  }
  var classNamePlugin = {
    name: "className",
    defaultValue: "",
    fn: function fn2(instance2) {
      var box = instance2.popper.firstElementChild;
      var isDefaultRenderFn = function isDefaultRenderFn2() {
        var _instance$props$rende;
        return !!((_instance$props$rende = instance2.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
      };
      function add2() {
        if (instance2.props.className && !isDefaultRenderFn()) {
          return;
        }
        updateClassName(box, "add", instance2.props.className);
      }
      function remove2() {
        if (isDefaultRenderFn()) {
          updateClassName(box, "remove", instance2.props.className);
        }
      }
      return {
        onCreate: add2,
        onBeforeUpdate: remove2,
        onAfterUpdate: add2
      };
    }
  };
  function TippyGenerator(tippy2) {
    function Tippy2(_ref2) {
      var children2 = _ref2.children, content2 = _ref2.content, visible = _ref2.visible, singleton = _ref2.singleton, render2 = _ref2.render, reference2 = _ref2.reference, _ref$disabled = _ref2.disabled, disabled2 = _ref$disabled === void 0 ? false : _ref$disabled, _ref$ignoreAttributes = _ref2.ignoreAttributes, ignoreAttributes = _ref$ignoreAttributes === void 0 ? true : _ref$ignoreAttributes;
      _ref2.__source;
      _ref2.__self;
      var restOfNativeProps = _objectWithoutPropertiesLoose$4(_ref2, ["children", "content", "visible", "singleton", "render", "reference", "disabled", "ignoreAttributes", "__source", "__self"]);
      var isControlledMode = visible !== void 0;
      var isSingletonMode = singleton !== void 0;
      var _useState = React.useState(false), mounted = _useState[0], setMounted = _useState[1];
      var _useState2 = React.useState({}), attrs2 = _useState2[0], setAttrs = _useState2[1];
      var _useState3 = React.useState(), singletonContent = _useState3[0], setSingletonContent = _useState3[1];
      var mutableBox = useMutableBox(function() {
        return {
          container: ssrSafeCreateDiv(),
          renders: 1
        };
      });
      var props = Object.assign({
        ignoreAttributes
      }, restOfNativeProps, {
        content: mutableBox.container
      });
      if (isControlledMode) {
        props.trigger = "manual";
        props.hideOnClick = false;
      }
      if (isSingletonMode) {
        disabled2 = true;
      }
      var computedProps = props;
      var plugins2 = props.plugins || [];
      if (render2) {
        computedProps = Object.assign({}, props, {
          plugins: isSingletonMode ? [].concat(plugins2, [{
            fn: function fn2() {
              return {
                onTrigger: function onTrigger(_2, event2) {
                  var _singleton$data$child = singleton.data.children.find(function(_ref22) {
                    var instance2 = _ref22.instance;
                    return instance2.reference === event2.currentTarget;
                  }), content3 = _singleton$data$child.content;
                  setSingletonContent(content3);
                }
              };
            }
          }]) : plugins2,
          render: function render3() {
            return {
              popper: mutableBox.container
            };
          }
        });
      }
      var deps = [reference2].concat(children2 ? [children2.type] : []);
      useIsomorphicLayoutEffect$2(function() {
        var element2 = reference2;
        if (reference2 && reference2.hasOwnProperty("current")) {
          element2 = reference2.current;
        }
        var instance2 = tippy2(element2 || mutableBox.ref || ssrSafeCreateDiv(), Object.assign({}, computedProps, {
          plugins: [classNamePlugin].concat(props.plugins || [])
        }));
        mutableBox.instance = instance2;
        if (disabled2) {
          instance2.disable();
        }
        if (visible) {
          instance2.show();
        }
        if (isSingletonMode) {
          singleton.hook({
            instance: instance2,
            content: content2,
            props: computedProps
          });
        }
        setMounted(true);
        return function() {
          instance2.destroy();
          singleton == null ? void 0 : singleton.cleanup(instance2);
        };
      }, deps);
      useIsomorphicLayoutEffect$2(function() {
        if (mutableBox.renders === 1) {
          mutableBox.renders++;
          return;
        }
        var instance2 = mutableBox.instance;
        instance2.setProps(deepPreserveProps(instance2.props, computedProps));
        if (disabled2) {
          instance2.disable();
        } else {
          instance2.enable();
        }
        if (isControlledMode) {
          if (visible) {
            instance2.show();
          } else {
            instance2.hide();
          }
        }
        if (isSingletonMode) {
          singleton.hook({
            instance: instance2,
            content: content2,
            props: computedProps
          });
        }
      });
      useIsomorphicLayoutEffect$2(function() {
        var _instance$props$poppe;
        if (!render2) {
          return;
        }
        var instance2 = mutableBox.instance;
        instance2.setProps({
          popperOptions: Object.assign({}, instance2.props.popperOptions, {
            modifiers: [].concat(((_instance$props$poppe = instance2.props.popperOptions) == null ? void 0 : _instance$props$poppe.modifiers) || [], [{
              name: "$$tippyReact",
              enabled: true,
              phase: "beforeWrite",
              requires: ["computeStyles"],
              fn: function fn2(_ref3) {
                var _state$modifiersData;
                var state = _ref3.state;
                var hideData = (_state$modifiersData = state.modifiersData) == null ? void 0 : _state$modifiersData.hide;
                if (attrs2.placement !== state.placement || attrs2.referenceHidden !== (hideData == null ? void 0 : hideData.isReferenceHidden) || attrs2.escaped !== (hideData == null ? void 0 : hideData.hasPopperEscaped)) {
                  setAttrs({
                    placement: state.placement,
                    referenceHidden: hideData == null ? void 0 : hideData.isReferenceHidden,
                    escaped: hideData == null ? void 0 : hideData.hasPopperEscaped
                  });
                }
                state.attributes.popper = {};
              }
            }])
          })
        });
      }, [attrs2.placement, attrs2.referenceHidden, attrs2.escaped].concat(deps));
      return /* @__PURE__ */ React__default.default.createElement(React__default.default.Fragment, null, children2 ? /* @__PURE__ */ React.cloneElement(children2, {
        ref: function ref(node2) {
          mutableBox.ref = node2;
          preserveRef(children2.ref, node2);
        }
      }) : null, mounted && /* @__PURE__ */ ReactDOM.createPortal(render2 ? render2(toDataAttributes(attrs2), singletonContent) : content2, mutableBox.container));
    }
    return Tippy2;
  }
  var forwardRef = function(Tippy2, defaultProps2) {
    return /* @__PURE__ */ React.forwardRef(function TippyWrapper(_ref2, _ref22) {
      var children2 = _ref2.children, props = _objectWithoutPropertiesLoose$4(_ref2, ["children"]);
      return /* @__PURE__ */ React__default.default.createElement(Tippy2, Object.assign({}, defaultProps2, props), children2 ? /* @__PURE__ */ React.cloneElement(children2, {
        ref: function ref(node2) {
          preserveRef(_ref22, node2);
          preserveRef(children2.ref, node2);
        }
      }) : null);
    });
  };
  var headless = /* @__PURE__ */ forwardRef(/* @__PURE__ */ TippyGenerator(tippy$1), {
    render: function render2() {
      return "";
    }
  });
  const Tippy = headless;
  var BOX_CLASS = "tippy-box";
  var CONTENT_CLASS = "tippy-content";
  var BACKDROP_CLASS = "tippy-backdrop";
  var ARROW_CLASS = "tippy-arrow";
  var SVG_ARROW_CLASS = "tippy-svg-arrow";
  var TOUCH_OPTIONS = {
    passive: true,
    capture: true
  };
  function getValueAtIndexOrReturn(value, index2, defaultValue2) {
    if (Array.isArray(value)) {
      var v2 = value[index2];
      return v2 == null ? Array.isArray(defaultValue2) ? defaultValue2[index2] : defaultValue2 : v2;
    }
    return value;
  }
  function isType(value, type) {
    var str = {}.toString.call(value);
    return str.indexOf("[object") === 0 && str.indexOf(type + "]") > -1;
  }
  function invokeWithArgsOrReturn(value, args) {
    return typeof value === "function" ? value.apply(void 0, args) : value;
  }
  function debounce$1(fn2, ms2) {
    if (ms2 === 0) {
      return fn2;
    }
    var timeout2;
    return function(arg) {
      clearTimeout(timeout2);
      timeout2 = setTimeout(function() {
        fn2(arg);
      }, ms2);
    };
  }
  function splitBySpaces(value) {
    return value.split(/\s+/).filter(Boolean);
  }
  function normalizeToArray(value) {
    return [].concat(value);
  }
  function pushIfUnique(arr, value) {
    if (arr.indexOf(value) === -1) {
      arr.push(value);
    }
  }
  function unique$1(arr) {
    return arr.filter(function(item, index2) {
      return arr.indexOf(item) === index2;
    });
  }
  function getBasePlacement(placement) {
    return placement.split("-")[0];
  }
  function arrayFrom(value) {
    return [].slice.call(value);
  }
  function removeUndefinedProps(obj) {
    return Object.keys(obj).reduce(function(acc, key) {
      if (obj[key] !== void 0) {
        acc[key] = obj[key];
      }
      return acc;
    }, {});
  }
  function div() {
    return document.createElement("div");
  }
  function isElement$1(value) {
    return ["Element", "Fragment"].some(function(type) {
      return isType(value, type);
    });
  }
  function isNodeList$1(value) {
    return isType(value, "NodeList");
  }
  function isMouseEvent(value) {
    return isType(value, "MouseEvent");
  }
  function isReferenceElement(value) {
    return !!(value && value._tippy && value._tippy.reference === value);
  }
  function getArrayOfElements(value) {
    if (isElement$1(value)) {
      return [value];
    }
    if (isNodeList$1(value)) {
      return arrayFrom(value);
    }
    if (Array.isArray(value)) {
      return value;
    }
    return arrayFrom(document.querySelectorAll(value));
  }
  function setTransitionDuration(els, value) {
    els.forEach(function(el) {
      if (el) {
        el.style.transitionDuration = value + "ms";
      }
    });
  }
  function setVisibilityState(els, state) {
    els.forEach(function(el) {
      if (el) {
        el.setAttribute("data-state", state);
      }
    });
  }
  function getOwnerDocument(elementOrElements) {
    var _normalizeToArray = normalizeToArray(elementOrElements), element2 = _normalizeToArray[0];
    return element2 ? element2.ownerDocument || document : document;
  }
  function isCursorOutsideInteractiveBorder(popperTreeData, event2) {
    var clientX = event2.clientX, clientY = event2.clientY;
    return popperTreeData.every(function(_ref2) {
      var popperRect = _ref2.popperRect, popperState = _ref2.popperState, props = _ref2.props;
      var interactiveBorder = props.interactiveBorder;
      var basePlacement = getBasePlacement(popperState.placement);
      var offsetData = popperState.modifiersData.offset;
      if (!offsetData) {
        return true;
      }
      var topDistance = basePlacement === "bottom" ? offsetData.top.y : 0;
      var bottomDistance = basePlacement === "top" ? offsetData.bottom.y : 0;
      var leftDistance = basePlacement === "right" ? offsetData.left.x : 0;
      var rightDistance = basePlacement === "left" ? offsetData.right.x : 0;
      var exceedsTop = popperRect.top - clientY + topDistance > interactiveBorder;
      var exceedsBottom = clientY - popperRect.bottom - bottomDistance > interactiveBorder;
      var exceedsLeft = popperRect.left - clientX + leftDistance > interactiveBorder;
      var exceedsRight = clientX - popperRect.right - rightDistance > interactiveBorder;
      return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
    });
  }
  function updateTransitionEndListener(box, action, listener2) {
    var method = action + "EventListener";
    ["transitionend", "webkitTransitionEnd"].forEach(function(event2) {
      box[method](event2, listener2);
    });
  }
  var currentInput = {
    isTouch: false
  };
  var lastMouseMoveTime = 0;
  function onDocumentTouchStart() {
    if (currentInput.isTouch) {
      return;
    }
    currentInput.isTouch = true;
    if (window.performance) {
      document.addEventListener("mousemove", onDocumentMouseMove);
    }
  }
  function onDocumentMouseMove() {
    var now2 = performance.now();
    if (now2 - lastMouseMoveTime < 20) {
      currentInput.isTouch = false;
      document.removeEventListener("mousemove", onDocumentMouseMove);
    }
    lastMouseMoveTime = now2;
  }
  function onWindowBlur() {
    var activeElement = document.activeElement;
    if (isReferenceElement(activeElement)) {
      var instance2 = activeElement._tippy;
      if (activeElement.blur && !instance2.state.isVisible) {
        activeElement.blur();
      }
    }
  }
  function bindGlobalEventListeners() {
    document.addEventListener("touchstart", onDocumentTouchStart, TOUCH_OPTIONS);
    window.addEventListener("blur", onWindowBlur);
  }
  var isBrowser$1 = typeof window !== "undefined" && typeof document !== "undefined";
  var ua = isBrowser$1 ? navigator.userAgent : "";
  var isIE = /MSIE |Trident\//.test(ua);
  var pluginProps = {
    animateFill: false,
    followCursor: false,
    inlinePositioning: false,
    sticky: false
  };
  var renderProps = {
    allowHTML: false,
    animation: "fade",
    arrow: true,
    content: "",
    inertia: false,
    maxWidth: 350,
    role: "tooltip",
    theme: "",
    zIndex: 9999
  };
  var defaultProps$1 = Object.assign({
    appendTo: function appendTo() {
      return document.body;
    },
    aria: {
      content: "auto",
      expanded: "auto"
    },
    delay: 0,
    duration: [300, 250],
    getReferenceClientRect: null,
    hideOnClick: true,
    ignoreAttributes: false,
    interactive: false,
    interactiveBorder: 2,
    interactiveDebounce: 0,
    moveTransition: "",
    offset: [0, 10],
    onAfterUpdate: function onAfterUpdate() {
    },
    onBeforeUpdate: function onBeforeUpdate() {
    },
    onCreate: function onCreate() {
    },
    onDestroy: function onDestroy() {
    },
    onHidden: function onHidden() {
    },
    onHide: function onHide() {
    },
    onMount: function onMount() {
    },
    onShow: function onShow() {
    },
    onShown: function onShown() {
    },
    onTrigger: function onTrigger() {
    },
    onUntrigger: function onUntrigger() {
    },
    onClickOutside: function onClickOutside() {
    },
    placement: "top",
    plugins: [],
    popperOptions: {},
    render: null,
    showOnCreate: false,
    touch: true,
    trigger: "mouseenter focus",
    triggerTarget: null
  }, pluginProps, {}, renderProps);
  var defaultKeys = Object.keys(defaultProps$1);
  var setDefaultProps = function setDefaultProps2(partialProps) {
    var keys2 = Object.keys(partialProps);
    keys2.forEach(function(key) {
      defaultProps$1[key] = partialProps[key];
    });
  };
  function getExtendedPassedProps(passedProps) {
    var plugins2 = passedProps.plugins || [];
    var pluginProps2 = plugins2.reduce(function(acc, plugin) {
      var name2 = plugin.name, defaultValue2 = plugin.defaultValue;
      if (name2) {
        acc[name2] = passedProps[name2] !== void 0 ? passedProps[name2] : defaultValue2;
      }
      return acc;
    }, {});
    return Object.assign({}, passedProps, {}, pluginProps2);
  }
  function getDataAttributeProps(reference2, plugins2) {
    var propKeys = plugins2 ? Object.keys(getExtendedPassedProps(Object.assign({}, defaultProps$1, {
      plugins: plugins2
    }))) : defaultKeys;
    var props = propKeys.reduce(function(acc, key) {
      var valueAsString = (reference2.getAttribute("data-tippy-" + key) || "").trim();
      if (!valueAsString) {
        return acc;
      }
      if (key === "content") {
        acc[key] = valueAsString;
      } else {
        try {
          acc[key] = JSON.parse(valueAsString);
        } catch (e3) {
          acc[key] = valueAsString;
        }
      }
      return acc;
    }, {});
    return props;
  }
  function evaluateProps(reference2, props) {
    var out = Object.assign({}, props, {
      content: invokeWithArgsOrReturn(props.content, [reference2])
    }, props.ignoreAttributes ? {} : getDataAttributeProps(reference2, props.plugins));
    out.aria = Object.assign({}, defaultProps$1.aria, {}, out.aria);
    out.aria = {
      expanded: out.aria.expanded === "auto" ? props.interactive : out.aria.expanded,
      content: out.aria.content === "auto" ? props.interactive ? null : "describedby" : out.aria.content
    };
    return out;
  }
  var innerHTML = function innerHTML2() {
    return "innerHTML";
  };
  function dangerouslySetInnerHTML(element2, html2) {
    element2[innerHTML()] = html2;
  }
  function createArrowElement(value) {
    var arrow2 = div();
    if (value === true) {
      arrow2.className = ARROW_CLASS;
    } else {
      arrow2.className = SVG_ARROW_CLASS;
      if (isElement$1(value)) {
        arrow2.appendChild(value);
      } else {
        dangerouslySetInnerHTML(arrow2, value);
      }
    }
    return arrow2;
  }
  function setContent(content2, props) {
    if (isElement$1(props.content)) {
      dangerouslySetInnerHTML(content2, "");
      content2.appendChild(props.content);
    } else if (typeof props.content !== "function") {
      if (props.allowHTML) {
        dangerouslySetInnerHTML(content2, props.content);
      } else {
        content2.textContent = props.content;
      }
    }
  }
  function getChildren$1(popper2) {
    var box = popper2.firstElementChild;
    var boxChildren = arrayFrom(box.children);
    return {
      box,
      content: boxChildren.find(function(node2) {
        return node2.classList.contains(CONTENT_CLASS);
      }),
      arrow: boxChildren.find(function(node2) {
        return node2.classList.contains(ARROW_CLASS) || node2.classList.contains(SVG_ARROW_CLASS);
      }),
      backdrop: boxChildren.find(function(node2) {
        return node2.classList.contains(BACKDROP_CLASS);
      })
    };
  }
  function render(instance2) {
    var popper2 = div();
    var box = div();
    box.className = BOX_CLASS;
    box.setAttribute("data-state", "hidden");
    box.setAttribute("tabindex", "-1");
    var content2 = div();
    content2.className = CONTENT_CLASS;
    content2.setAttribute("data-state", "hidden");
    setContent(content2, instance2.props);
    popper2.appendChild(box);
    box.appendChild(content2);
    onUpdate(instance2.props, instance2.props);
    function onUpdate(prevProps, nextProps) {
      var _getChildren = getChildren$1(popper2), box2 = _getChildren.box, content3 = _getChildren.content, arrow2 = _getChildren.arrow;
      if (nextProps.theme) {
        box2.setAttribute("data-theme", nextProps.theme);
      } else {
        box2.removeAttribute("data-theme");
      }
      if (typeof nextProps.animation === "string") {
        box2.setAttribute("data-animation", nextProps.animation);
      } else {
        box2.removeAttribute("data-animation");
      }
      if (nextProps.inertia) {
        box2.setAttribute("data-inertia", "");
      } else {
        box2.removeAttribute("data-inertia");
      }
      box2.style.maxWidth = typeof nextProps.maxWidth === "number" ? nextProps.maxWidth + "px" : nextProps.maxWidth;
      if (nextProps.role) {
        box2.setAttribute("role", nextProps.role);
      } else {
        box2.removeAttribute("role");
      }
      if (prevProps.content !== nextProps.content || prevProps.allowHTML !== nextProps.allowHTML) {
        setContent(content3, instance2.props);
      }
      if (nextProps.arrow) {
        if (!arrow2) {
          box2.appendChild(createArrowElement(nextProps.arrow));
        } else if (prevProps.arrow !== nextProps.arrow) {
          box2.removeChild(arrow2);
          box2.appendChild(createArrowElement(nextProps.arrow));
        }
      } else if (arrow2) {
        box2.removeChild(arrow2);
      }
    }
    return {
      popper: popper2,
      onUpdate
    };
  }
  render.$$tippy = true;
  var idCounter = 1;
  var mouseMoveListeners = [];
  var mountedInstances = [];
  function createTippy(reference2, passedProps) {
    var props = evaluateProps(reference2, Object.assign({}, defaultProps$1, {}, getExtendedPassedProps(removeUndefinedProps(passedProps))));
    var showTimeout;
    var hideTimeout;
    var scheduleHideAnimationFrame;
    var isVisibleFromClick = false;
    var didHideDueToDocumentMouseDown = false;
    var didTouchMove = false;
    var ignoreOnFirstUpdate = false;
    var lastTriggerEvent;
    var currentTransitionEndListener;
    var onFirstUpdate;
    var listeners = [];
    var debouncedOnMouseMove = debounce$1(onMouseMove, props.interactiveDebounce);
    var currentTarget;
    var doc2 = getOwnerDocument(props.triggerTarget || reference2);
    var id2 = idCounter++;
    var popperInstance = null;
    var plugins2 = unique$1(props.plugins);
    var state = {
      isEnabled: true,
      isVisible: false,
      isDestroyed: false,
      isMounted: false,
      isShown: false
    };
    var instance2 = {
      id: id2,
      reference: reference2,
      popper: div(),
      popperInstance,
      props,
      state,
      plugins: plugins2,
      clearDelayTimeouts,
      setProps,
      setContent: setContent2,
      show,
      hide: hide2,
      hideWithInteractivity,
      enable,
      disable: disable2,
      unmount,
      destroy
    };
    if (!props.render) {
      return instance2;
    }
    var _props$render = props.render(instance2), popper2 = _props$render.popper, onUpdate = _props$render.onUpdate;
    popper2.setAttribute("data-tippy-root", "");
    popper2.id = "tippy-" + instance2.id;
    instance2.popper = popper2;
    reference2._tippy = instance2;
    popper2._tippy = instance2;
    var pluginsHooks = plugins2.map(function(plugin) {
      return plugin.fn(instance2);
    });
    var hasAriaExpanded = reference2.hasAttribute("aria-expanded");
    addListeners();
    handleAriaExpandedAttribute();
    handleStyles();
    invokeHook("onCreate", [instance2]);
    if (props.showOnCreate) {
      scheduleShow();
    }
    popper2.addEventListener("mouseenter", function() {
      if (instance2.props.interactive && instance2.state.isVisible) {
        instance2.clearDelayTimeouts();
      }
    });
    popper2.addEventListener("mouseleave", function(event2) {
      if (instance2.props.interactive && instance2.props.trigger.indexOf("mouseenter") >= 0) {
        doc2.addEventListener("mousemove", debouncedOnMouseMove);
        debouncedOnMouseMove(event2);
      }
    });
    return instance2;
    function getNormalizedTouchSettings() {
      var touch = instance2.props.touch;
      return Array.isArray(touch) ? touch : [touch, 0];
    }
    function getIsCustomTouchBehavior() {
      return getNormalizedTouchSettings()[0] === "hold";
    }
    function getIsDefaultRenderFn() {
      var _instance$props$rende;
      return !!((_instance$props$rende = instance2.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
    }
    function getCurrentTarget() {
      return currentTarget || reference2;
    }
    function getDefaultTemplateChildren() {
      return getChildren$1(popper2);
    }
    function getDelay(isShow) {
      if (instance2.state.isMounted && !instance2.state.isVisible || currentInput.isTouch || lastTriggerEvent && lastTriggerEvent.type === "focus") {
        return 0;
      }
      return getValueAtIndexOrReturn(instance2.props.delay, isShow ? 0 : 1, defaultProps$1.delay);
    }
    function handleStyles() {
      popper2.style.pointerEvents = instance2.props.interactive && instance2.state.isVisible ? "" : "none";
      popper2.style.zIndex = "" + instance2.props.zIndex;
    }
    function invokeHook(hook, args, shouldInvokePropsHook) {
      if (shouldInvokePropsHook === void 0) {
        shouldInvokePropsHook = true;
      }
      pluginsHooks.forEach(function(pluginHooks) {
        if (pluginHooks[hook]) {
          pluginHooks[hook].apply(void 0, args);
        }
      });
      if (shouldInvokePropsHook) {
        var _instance$props;
        (_instance$props = instance2.props)[hook].apply(_instance$props, args);
      }
    }
    function handleAriaContentAttribute() {
      var aria2 = instance2.props.aria;
      if (!aria2.content) {
        return;
      }
      var attr = "aria-" + aria2.content;
      var id3 = popper2.id;
      var nodes = normalizeToArray(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        var currentValue = node2.getAttribute(attr);
        if (instance2.state.isVisible) {
          node2.setAttribute(attr, currentValue ? currentValue + " " + id3 : id3);
        } else {
          var nextValue = currentValue && currentValue.replace(id3, "").trim();
          if (nextValue) {
            node2.setAttribute(attr, nextValue);
          } else {
            node2.removeAttribute(attr);
          }
        }
      });
    }
    function handleAriaExpandedAttribute() {
      if (hasAriaExpanded || !instance2.props.aria.expanded) {
        return;
      }
      var nodes = normalizeToArray(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        if (instance2.props.interactive) {
          node2.setAttribute("aria-expanded", instance2.state.isVisible && node2 === getCurrentTarget() ? "true" : "false");
        } else {
          node2.removeAttribute("aria-expanded");
        }
      });
    }
    function cleanupInteractiveMouseListeners() {
      doc2.removeEventListener("mousemove", debouncedOnMouseMove);
      mouseMoveListeners = mouseMoveListeners.filter(function(listener2) {
        return listener2 !== debouncedOnMouseMove;
      });
    }
    function onDocumentPress(event2) {
      if (currentInput.isTouch) {
        if (didTouchMove || event2.type === "mousedown") {
          return;
        }
      }
      if (instance2.props.interactive && popper2.contains(event2.target)) {
        return;
      }
      if (getCurrentTarget().contains(event2.target)) {
        if (currentInput.isTouch) {
          return;
        }
        if (instance2.state.isVisible && instance2.props.trigger.indexOf("click") >= 0) {
          return;
        }
      } else {
        invokeHook("onClickOutside", [instance2, event2]);
      }
      if (instance2.props.hideOnClick === true) {
        instance2.clearDelayTimeouts();
        instance2.hide();
        didHideDueToDocumentMouseDown = true;
        setTimeout(function() {
          didHideDueToDocumentMouseDown = false;
        });
        if (!instance2.state.isMounted) {
          removeDocumentPress();
        }
      }
    }
    function onTouchMove() {
      didTouchMove = true;
    }
    function onTouchStart() {
      didTouchMove = false;
    }
    function addDocumentPress() {
      doc2.addEventListener("mousedown", onDocumentPress, true);
      doc2.addEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
      doc2.addEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
      doc2.addEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
    }
    function removeDocumentPress() {
      doc2.removeEventListener("mousedown", onDocumentPress, true);
      doc2.removeEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
      doc2.removeEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
      doc2.removeEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
    }
    function onTransitionedOut(duration, callback) {
      onTransitionEnd(duration, function() {
        if (!instance2.state.isVisible && popper2.parentNode && popper2.parentNode.contains(popper2)) {
          callback();
        }
      });
    }
    function onTransitionedIn(duration, callback) {
      onTransitionEnd(duration, callback);
    }
    function onTransitionEnd(duration, callback) {
      var box = getDefaultTemplateChildren().box;
      function listener2(event2) {
        if (event2.target === box) {
          updateTransitionEndListener(box, "remove", listener2);
          callback();
        }
      }
      if (duration === 0) {
        return callback();
      }
      updateTransitionEndListener(box, "remove", currentTransitionEndListener);
      updateTransitionEndListener(box, "add", listener2);
      currentTransitionEndListener = listener2;
    }
    function on2(eventType, handler, options) {
      if (options === void 0) {
        options = false;
      }
      var nodes = normalizeToArray(instance2.props.triggerTarget || reference2);
      nodes.forEach(function(node2) {
        node2.addEventListener(eventType, handler, options);
        listeners.push({
          node: node2,
          eventType,
          handler,
          options
        });
      });
    }
    function addListeners() {
      if (getIsCustomTouchBehavior()) {
        on2("touchstart", onTrigger, {
          passive: true
        });
        on2("touchend", onMouseLeave, {
          passive: true
        });
      }
      splitBySpaces(instance2.props.trigger).forEach(function(eventType) {
        if (eventType === "manual") {
          return;
        }
        on2(eventType, onTrigger);
        switch (eventType) {
          case "mouseenter":
            on2("mouseleave", onMouseLeave);
            break;
          case "focus":
            on2(isIE ? "focusout" : "blur", onBlurOrFocusOut);
            break;
          case "focusin":
            on2("focusout", onBlurOrFocusOut);
            break;
        }
      });
    }
    function removeListeners() {
      listeners.forEach(function(_ref2) {
        var node2 = _ref2.node, eventType = _ref2.eventType, handler = _ref2.handler, options = _ref2.options;
        node2.removeEventListener(eventType, handler, options);
      });
      listeners = [];
    }
    function onTrigger(event2) {
      var _lastTriggerEvent;
      var shouldScheduleClickHide = false;
      if (!instance2.state.isEnabled || isEventListenerStopped(event2) || didHideDueToDocumentMouseDown) {
        return;
      }
      var wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == null ? void 0 : _lastTriggerEvent.type) === "focus";
      lastTriggerEvent = event2;
      currentTarget = event2.currentTarget;
      handleAriaExpandedAttribute();
      if (!instance2.state.isVisible && isMouseEvent(event2)) {
        mouseMoveListeners.forEach(function(listener2) {
          return listener2(event2);
        });
      }
      if (event2.type === "click" && (instance2.props.trigger.indexOf("mouseenter") < 0 || isVisibleFromClick) && instance2.props.hideOnClick !== false && instance2.state.isVisible) {
        shouldScheduleClickHide = true;
      } else {
        scheduleShow(event2);
      }
      if (event2.type === "click") {
        isVisibleFromClick = !shouldScheduleClickHide;
      }
      if (shouldScheduleClickHide && !wasFocused) {
        scheduleHide(event2);
      }
    }
    function onMouseMove(event2) {
      var target = event2.target;
      var isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper2.contains(target);
      if (event2.type === "mousemove" && isCursorOverReferenceOrPopper) {
        return;
      }
      var popperTreeData = getNestedPopperTree().concat(popper2).map(function(popper3) {
        var _instance$popperInsta;
        var instance3 = popper3._tippy;
        var state2 = (_instance$popperInsta = instance3.popperInstance) == null ? void 0 : _instance$popperInsta.state;
        if (state2) {
          return {
            popperRect: popper3.getBoundingClientRect(),
            popperState: state2,
            props
          };
        }
        return null;
      }).filter(Boolean);
      if (isCursorOutsideInteractiveBorder(popperTreeData, event2)) {
        cleanupInteractiveMouseListeners();
        scheduleHide(event2);
      }
    }
    function onMouseLeave(event2) {
      var shouldBail = isEventListenerStopped(event2) || instance2.props.trigger.indexOf("click") >= 0 && isVisibleFromClick;
      if (shouldBail) {
        return;
      }
      if (instance2.props.interactive) {
        instance2.hideWithInteractivity(event2);
        return;
      }
      scheduleHide(event2);
    }
    function onBlurOrFocusOut(event2) {
      if (instance2.props.trigger.indexOf("focusin") < 0 && event2.target !== getCurrentTarget()) {
        return;
      }
      if (instance2.props.interactive && event2.relatedTarget && popper2.contains(event2.relatedTarget)) {
        return;
      }
      scheduleHide(event2);
    }
    function isEventListenerStopped(event2) {
      return currentInput.isTouch ? getIsCustomTouchBehavior() !== event2.type.indexOf("touch") >= 0 : false;
    }
    function createPopperInstance() {
      destroyPopperInstance();
      var _instance$props2 = instance2.props, popperOptions = _instance$props2.popperOptions, placement = _instance$props2.placement, offset2 = _instance$props2.offset, getReferenceClientRect = _instance$props2.getReferenceClientRect, moveTransition = _instance$props2.moveTransition;
      var arrow2 = getIsDefaultRenderFn() ? getChildren$1(popper2).arrow : null;
      var computedReference = getReferenceClientRect ? {
        getBoundingClientRect: getReferenceClientRect,
        contextElement: getReferenceClientRect.contextElement || getCurrentTarget()
      } : reference2;
      var tippyModifier = {
        name: "$$tippy",
        enabled: true,
        phase: "beforeWrite",
        requires: ["computeStyles"],
        fn: function fn2(_ref2) {
          var state2 = _ref2.state;
          if (getIsDefaultRenderFn()) {
            var _getDefaultTemplateCh = getDefaultTemplateChildren(), box = _getDefaultTemplateCh.box;
            ["placement", "reference-hidden", "escaped"].forEach(function(attr) {
              if (attr === "placement") {
                box.setAttribute("data-placement", state2.placement);
              } else {
                if (state2.attributes.popper["data-popper-" + attr]) {
                  box.setAttribute("data-" + attr, "");
                } else {
                  box.removeAttribute("data-" + attr);
                }
              }
            });
            state2.attributes.popper = {};
          }
        }
      };
      var modifiers2 = [{
        name: "offset",
        options: {
          offset: offset2
        }
      }, {
        name: "preventOverflow",
        options: {
          padding: {
            top: 2,
            bottom: 2,
            left: 5,
            right: 5
          }
        }
      }, {
        name: "flip",
        options: {
          padding: 5
        }
      }, {
        name: "computeStyles",
        options: {
          adaptive: !moveTransition
        }
      }, tippyModifier];
      if (getIsDefaultRenderFn() && arrow2) {
        modifiers2.push({
          name: "arrow",
          options: {
            element: arrow2,
            padding: 3
          }
        });
      }
      modifiers2.push.apply(modifiers2, (popperOptions == null ? void 0 : popperOptions.modifiers) || []);
      instance2.popperInstance = createPopper(computedReference, popper2, Object.assign({}, popperOptions, {
        placement,
        onFirstUpdate,
        modifiers: modifiers2
      }));
    }
    function destroyPopperInstance() {
      if (instance2.popperInstance) {
        instance2.popperInstance.destroy();
        instance2.popperInstance = null;
      }
    }
    function mount() {
      var appendTo = instance2.props.appendTo;
      var parentNode;
      var node2 = getCurrentTarget();
      if (instance2.props.interactive && appendTo === defaultProps$1.appendTo || appendTo === "parent") {
        parentNode = node2.parentNode;
      } else {
        parentNode = invokeWithArgsOrReturn(appendTo, [node2]);
      }
      if (!parentNode.contains(popper2)) {
        parentNode.appendChild(popper2);
      }
      createPopperInstance();
    }
    function getNestedPopperTree() {
      return arrayFrom(popper2.querySelectorAll("[data-tippy-root]"));
    }
    function scheduleShow(event2) {
      instance2.clearDelayTimeouts();
      if (event2) {
        invokeHook("onTrigger", [instance2, event2]);
      }
      addDocumentPress();
      var delay = getDelay(true);
      var _getNormalizedTouchSe = getNormalizedTouchSettings(), touchValue = _getNormalizedTouchSe[0], touchDelay = _getNormalizedTouchSe[1];
      if (currentInput.isTouch && touchValue === "hold" && touchDelay) {
        delay = touchDelay;
      }
      if (delay) {
        showTimeout = setTimeout(function() {
          instance2.show();
        }, delay);
      } else {
        instance2.show();
      }
    }
    function scheduleHide(event2) {
      instance2.clearDelayTimeouts();
      invokeHook("onUntrigger", [instance2, event2]);
      if (!instance2.state.isVisible) {
        removeDocumentPress();
        return;
      }
      if (instance2.props.trigger.indexOf("mouseenter") >= 0 && instance2.props.trigger.indexOf("click") >= 0 && ["mouseleave", "mousemove"].indexOf(event2.type) >= 0 && isVisibleFromClick) {
        return;
      }
      var delay = getDelay(false);
      if (delay) {
        hideTimeout = setTimeout(function() {
          if (instance2.state.isVisible) {
            instance2.hide();
          }
        }, delay);
      } else {
        scheduleHideAnimationFrame = requestAnimationFrame(function() {
          instance2.hide();
        });
      }
    }
    function enable() {
      instance2.state.isEnabled = true;
    }
    function disable2() {
      instance2.hide();
      instance2.state.isEnabled = false;
    }
    function clearDelayTimeouts() {
      clearTimeout(showTimeout);
      clearTimeout(hideTimeout);
      cancelAnimationFrame(scheduleHideAnimationFrame);
    }
    function setProps(partialProps) {
      if (instance2.state.isDestroyed) {
        return;
      }
      invokeHook("onBeforeUpdate", [instance2, partialProps]);
      removeListeners();
      var prevProps = instance2.props;
      var nextProps = evaluateProps(reference2, Object.assign({}, instance2.props, {}, partialProps, {
        ignoreAttributes: true
      }));
      instance2.props = nextProps;
      addListeners();
      if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
        cleanupInteractiveMouseListeners();
        debouncedOnMouseMove = debounce$1(onMouseMove, nextProps.interactiveDebounce);
      }
      if (prevProps.triggerTarget && !nextProps.triggerTarget) {
        normalizeToArray(prevProps.triggerTarget).forEach(function(node2) {
          node2.removeAttribute("aria-expanded");
        });
      } else if (nextProps.triggerTarget) {
        reference2.removeAttribute("aria-expanded");
      }
      handleAriaExpandedAttribute();
      handleStyles();
      if (onUpdate) {
        onUpdate(prevProps, nextProps);
      }
      if (instance2.popperInstance) {
        createPopperInstance();
        getNestedPopperTree().forEach(function(nestedPopper) {
          requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
        });
      }
      invokeHook("onAfterUpdate", [instance2, partialProps]);
    }
    function setContent2(content2) {
      instance2.setProps({
        content: content2
      });
    }
    function show() {
      var isAlreadyVisible = instance2.state.isVisible;
      var isDestroyed = instance2.state.isDestroyed;
      var isDisabled = !instance2.state.isEnabled;
      var isTouchAndTouchDisabled = currentInput.isTouch && !instance2.props.touch;
      var duration = getValueAtIndexOrReturn(instance2.props.duration, 0, defaultProps$1.duration);
      if (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
        return;
      }
      if (getCurrentTarget().hasAttribute("disabled")) {
        return;
      }
      invokeHook("onShow", [instance2], false);
      if (instance2.props.onShow(instance2) === false) {
        return;
      }
      instance2.state.isVisible = true;
      if (getIsDefaultRenderFn()) {
        popper2.style.visibility = "visible";
      }
      handleStyles();
      addDocumentPress();
      if (!instance2.state.isMounted) {
        popper2.style.transition = "none";
      }
      if (getIsDefaultRenderFn()) {
        var _getDefaultTemplateCh2 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh2.box, content2 = _getDefaultTemplateCh2.content;
        setTransitionDuration([box, content2], 0);
      }
      onFirstUpdate = function onFirstUpdate2() {
        if (!instance2.state.isVisible || ignoreOnFirstUpdate) {
          return;
        }
        ignoreOnFirstUpdate = true;
        void popper2.offsetHeight;
        popper2.style.transition = instance2.props.moveTransition;
        if (getIsDefaultRenderFn() && instance2.props.animation) {
          var _getDefaultTemplateCh3 = getDefaultTemplateChildren(), _box = _getDefaultTemplateCh3.box, _content = _getDefaultTemplateCh3.content;
          setTransitionDuration([_box, _content], duration);
          setVisibilityState([_box, _content], "visible");
        }
        handleAriaContentAttribute();
        handleAriaExpandedAttribute();
        pushIfUnique(mountedInstances, instance2);
        instance2.state.isMounted = true;
        invokeHook("onMount", [instance2]);
        if (instance2.props.animation && getIsDefaultRenderFn()) {
          onTransitionedIn(duration, function() {
            instance2.state.isShown = true;
            invokeHook("onShown", [instance2]);
          });
        }
      };
      mount();
    }
    function hide2() {
      var isAlreadyHidden = !instance2.state.isVisible;
      var isDestroyed = instance2.state.isDestroyed;
      var isDisabled = !instance2.state.isEnabled;
      var duration = getValueAtIndexOrReturn(instance2.props.duration, 1, defaultProps$1.duration);
      if (isAlreadyHidden || isDestroyed || isDisabled) {
        return;
      }
      invokeHook("onHide", [instance2], false);
      if (instance2.props.onHide(instance2) === false) {
        return;
      }
      instance2.state.isVisible = false;
      instance2.state.isShown = false;
      ignoreOnFirstUpdate = false;
      isVisibleFromClick = false;
      if (getIsDefaultRenderFn()) {
        popper2.style.visibility = "hidden";
      }
      cleanupInteractiveMouseListeners();
      removeDocumentPress();
      handleStyles();
      if (getIsDefaultRenderFn()) {
        var _getDefaultTemplateCh4 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh4.box, content2 = _getDefaultTemplateCh4.content;
        if (instance2.props.animation) {
          setTransitionDuration([box, content2], duration);
          setVisibilityState([box, content2], "hidden");
        }
      }
      handleAriaContentAttribute();
      handleAriaExpandedAttribute();
      if (instance2.props.animation) {
        if (getIsDefaultRenderFn()) {
          onTransitionedOut(duration, instance2.unmount);
        }
      } else {
        instance2.unmount();
      }
    }
    function hideWithInteractivity(event2) {
      doc2.addEventListener("mousemove", debouncedOnMouseMove);
      pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
      debouncedOnMouseMove(event2);
    }
    function unmount() {
      if (instance2.state.isVisible) {
        instance2.hide();
      }
      if (!instance2.state.isMounted) {
        return;
      }
      destroyPopperInstance();
      getNestedPopperTree().forEach(function(nestedPopper) {
        nestedPopper._tippy.unmount();
      });
      if (popper2.parentNode) {
        popper2.parentNode.removeChild(popper2);
      }
      mountedInstances = mountedInstances.filter(function(i2) {
        return i2 !== instance2;
      });
      instance2.state.isMounted = false;
      invokeHook("onHidden", [instance2]);
    }
    function destroy() {
      if (instance2.state.isDestroyed) {
        return;
      }
      instance2.clearDelayTimeouts();
      instance2.unmount();
      removeListeners();
      delete reference2._tippy;
      instance2.state.isDestroyed = true;
      invokeHook("onDestroy", [instance2]);
    }
  }
  function tippy(targets, optionalProps) {
    if (optionalProps === void 0) {
      optionalProps = {};
    }
    var plugins2 = defaultProps$1.plugins.concat(optionalProps.plugins || []);
    bindGlobalEventListeners();
    var passedProps = Object.assign({}, optionalProps, {
      plugins: plugins2
    });
    var elements = getArrayOfElements(targets);
    var instances = elements.reduce(function(acc, reference2) {
      var instance2 = reference2 && createTippy(reference2, passedProps);
      if (instance2) {
        acc.push(instance2);
      }
      return acc;
    }, []);
    return isElement$1(targets) ? instances[0] : instances;
  }
  tippy.defaultProps = defaultProps$1;
  tippy.setDefaultProps = setDefaultProps;
  tippy.currentInput = currentInput;
  var mouseCoords = {
    clientX: 0,
    clientY: 0
  };
  var activeInstances = [];
  function storeMouseCoords(_ref2) {
    var clientX = _ref2.clientX, clientY = _ref2.clientY;
    mouseCoords = {
      clientX,
      clientY
    };
  }
  function addMouseCoordsListener(doc2) {
    doc2.addEventListener("mousemove", storeMouseCoords);
  }
  function removeMouseCoordsListener(doc2) {
    doc2.removeEventListener("mousemove", storeMouseCoords);
  }
  var followCursor = {
    name: "followCursor",
    defaultValue: false,
    fn: function fn2(instance2) {
      var reference2 = instance2.reference;
      var doc2 = getOwnerDocument(instance2.props.triggerTarget || reference2);
      var isInternalUpdate = false;
      var wasFocusEvent = false;
      var isUnmounted = true;
      var prevProps = instance2.props;
      function getIsInitialBehavior() {
        return instance2.props.followCursor === "initial" && instance2.state.isVisible;
      }
      function addListener() {
        doc2.addEventListener("mousemove", onMouseMove);
      }
      function removeListener() {
        doc2.removeEventListener("mousemove", onMouseMove);
      }
      function unsetGetReferenceClientRect() {
        isInternalUpdate = true;
        instance2.setProps({
          getReferenceClientRect: null
        });
        isInternalUpdate = false;
      }
      function onMouseMove(event2) {
        var isCursorOverReference = event2.target ? reference2.contains(event2.target) : true;
        var followCursor2 = instance2.props.followCursor;
        var clientX = event2.clientX, clientY = event2.clientY;
        var rect = reference2.getBoundingClientRect();
        var relativeX = clientX - rect.left;
        var relativeY = clientY - rect.top;
        if (isCursorOverReference || !instance2.props.interactive) {
          instance2.setProps({
            getReferenceClientRect: function getReferenceClientRect() {
              var rect2 = reference2.getBoundingClientRect();
              var x2 = clientX;
              var y2 = clientY;
              if (followCursor2 === "initial") {
                x2 = rect2.left + relativeX;
                y2 = rect2.top + relativeY;
              }
              var top2 = followCursor2 === "horizontal" ? rect2.top : y2;
              var right2 = followCursor2 === "vertical" ? rect2.right : x2;
              var bottom2 = followCursor2 === "horizontal" ? rect2.bottom : y2;
              var left2 = followCursor2 === "vertical" ? rect2.left : x2;
              return {
                width: right2 - left2,
                height: bottom2 - top2,
                top: top2,
                right: right2,
                bottom: bottom2,
                left: left2
              };
            }
          });
        }
      }
      function create2() {
        if (instance2.props.followCursor) {
          activeInstances.push({
            instance: instance2,
            doc: doc2
          });
          addMouseCoordsListener(doc2);
        }
      }
      function destroy() {
        activeInstances = activeInstances.filter(function(data2) {
          return data2.instance !== instance2;
        });
        if (activeInstances.filter(function(data2) {
          return data2.doc === doc2;
        }).length === 0) {
          removeMouseCoordsListener(doc2);
        }
      }
      return {
        onCreate: create2,
        onDestroy: destroy,
        onBeforeUpdate: function onBeforeUpdate() {
          prevProps = instance2.props;
        },
        onAfterUpdate: function onAfterUpdate(_2, _ref2) {
          var followCursor2 = _ref2.followCursor;
          if (isInternalUpdate) {
            return;
          }
          if (followCursor2 !== void 0 && prevProps.followCursor !== followCursor2) {
            destroy();
            if (followCursor2) {
              create2();
              if (instance2.state.isMounted && !wasFocusEvent && !getIsInitialBehavior()) {
                addListener();
              }
            } else {
              removeListener();
              unsetGetReferenceClientRect();
            }
          }
        },
        onMount: function onMount() {
          if (instance2.props.followCursor && !wasFocusEvent) {
            if (isUnmounted) {
              onMouseMove(mouseCoords);
              isUnmounted = false;
            }
            if (!getIsInitialBehavior()) {
              addListener();
            }
          }
        },
        onTrigger: function onTrigger(_2, event2) {
          if (isMouseEvent(event2)) {
            mouseCoords = {
              clientX: event2.clientX,
              clientY: event2.clientY
            };
          }
          wasFocusEvent = event2.type === "focus";
        },
        onHidden: function onHidden() {
          if (instance2.props.followCursor) {
            unsetGetReferenceClientRect();
            removeListener();
            isUnmounted = true;
          }
        }
      };
    }
  };
  tippy.setDefaultProps({
    render
  });
  const TooltipWrapper = styled__default.default.div`
    position: relative;

    display: block;

    max-width: 15rem;
    padding: 0.75rem 1rem;

    word-break: break-word;

    border-radius: 0.25rem;

    transition: opacity 150ms ease-in-out;

    ${(props) => {
    if (!props.$hidden) {
      return `
            color: ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.blue1};
            font-size: ${props.theme.font.size};
            border: 1px solid ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.errorDown};

            background-color: ${props.styling === "default" ? props.theme.colors.grey2 : props.theme.colors.error};
            `;
    }
  }};
`;
  const Arrow = styled__default.default.span`
    position: absolute;

    ${(props) => {
    switch (props.placement) {
      case "top":
        return "bottom: 3px; left: -3px !important;";
      case "bottom":
        return "top: -5px;";
      case "left":
        return "right: 3px;";
      case "right":
        return "left: -5px;";
      default:
        return "display: none;";
    }
  }}

    ${(props) => {
    if (props.$hidden) {
      return "display: none;";
    }
  }}

    &::before {
        content: '';

        position: absolute;

        ${(props) => {
    switch (props.placement) {
      case "top":
      case "bottom":
        return "transform: rotate(45deg);";
      case "left":
        return "transform: rotate(135deg);";
      case "right":
        return "transform: rotate(-45deg);";
      default:
        return "display: none;";
    }
  }}

        width: 0.5rem;
        height: 0.5rem;

        background: ${(props) => {
    return props.styling === "default" ? props.theme.colors.grey2 : props.theme.colors.error;
  }};
        ${(props) => {
    if (props.placement === "top") {
      return `border-bottom: 1px solid ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.errorDown};
                        border-right: 1px solid ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.errorDown};`;
    }
    return `border-top: 1px solid ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.errorDown};
                        border-left: 1px solid ${props.styling === "default" ? props.theme.colors.grey5 : props.theme.colors.errorDown};`;
  }}
    }
`;
  function Tooltip$1({ appendTo = document.body, getReferenceClientRect, children: children2, className, content: content2, disabled: disabled2, hideOnClick = true, interactive, visible, placement = "auto", styling = "default", followCursor: followCursor$1 = false, hidden = false, style: style2, onClickOutside = () => false }) {
    return jsxRuntime.exports.jsx(Tippy, { appendTo, arrow: true, disabled: disabled2, followCursor: followCursor$1, getReferenceClientRect, hideOnClick: visible !== void 0 ? void 0 : hideOnClick, interactive, onClickOutside, placement, plugins: [followCursor], render: (attrs2) => jsxRuntime.exports.jsxs(TooltipWrapper, Object.assign({ "$hidden": hidden, className, style: style2, styling }, attrs2, { children: [content2, jsxRuntime.exports.jsx(Arrow, { "$hidden": hidden, "data-popper-arrow": "", placement: attrs2["data-placement"], styling })] })), visible, zIndex: 9998, children: children2 });
  }
  const { stateChangeTypes: stateChangeTypes$3 } = useCombobox;
  const Wrapper$a = styled__default.default.div`
    display: inline-flex;

    width: 100%;
    min-width: 4rem;
    height: 2.5rem;

    border-radius: ${(props) => props.isOpen ? "0.25rem 0.25rem 0px 0px" : "0.25rem"};

    ${(props) => {
    if (props.isDisabled) {
      return `
                border: 1px solid ${props.theme.colors.grey2};

                svg {
                    color: ${props.theme.colors.grey2};
                }
            `;
    }
    if (props.isErrored) {
      return `border: 1px solid ${props.theme.colors.error};`;
    }
    return `
            border: 1px solid ${props.isOpen ? props.theme.colors.grey3 : props.theme.colors.grey1};
            :hover {
                border: 1px solid ${props.theme.colors.grey3};

            }
        `;
  }}
`;
  const InputWrapper$4 = styled__default.default.div`
    display: flex;
    flex: 1 1 auto;
    align-items: center;
    justify-content: space-between;

    width: calc(100% - 1rem);
    height: 100%;
    padding: 0 0.25rem 0 1rem;

    color: ${(props) => props.disabled ? props.theme.colors.grey2 : props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.grey1};
    border: none;
    border-radius: ${(props) => props.isOpen ? "0.25rem 0.25rem 0px 0px" : "0.25rem"};

    :hover {
        background-color: ${(props) => props.disabled ? props.theme.colors.grey1 : props.theme.colors.grey2};
    }
    svg {
        height: 0.8rem;
    }
`;
  const Input$2 = styled__default.default.input`
    overflow: hidden;
    flex: 1 1 auto;

    height: 100%;
    margin-right: 0.5rem;
    padding: 0rem;

    font-size: ${(props) => props.size ? `${props.size}rem` : props.theme.font.size};
    font-weight: 300;
    color: ${(props) => props.theme.colors.text};
    text-align: left;
    text-overflow: ellipsis;
    white-space: nowrap;

    background-color: transparent;
    border: none;
    outline: 0;

    :disabled {
        cursor: not-allowed;
        color: ${(props) => props.theme.colors.grey2};
    }
`;
  const NoItemsLabel$1 = styled__default.default.span`
    display: flex;
    flex: 1 1 auto;
    align-items: center;
    justify-content: center;

    height: 2rem;

    font-size: 1rem;
    color: ${(props) => props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.blue1};
`;
  const DropdownList$3 = styled__default.default(List)`
    margin-left: -1px;
    border-radius: 0px 0px 0.25rem 0.25rem;
    box-shadow: ${(props) => props.theme.shadow.light};
`;
  const ChevronButton$1 = styled__default.default(Button$3).attrs((attrs2) => Object.assign(Object.assign({}, attrs2), { styling: "ghost" }))`
    min-width: 0;
    height: auto;
    margin: 0;
    padding: 0 0.25rem;

    background-color: transparent !important;
`;
  function ComboBox(props) {
    var _a3, _b, _c, _d, _e2, _f, _g;
    const referenceElement = React.useRef(null);
    const popperElement = React.useRef(null);
    const { styles: styles2, attributes: attributes2, update: update2 } = usePopper$1(referenceElement.current, popperElement.current, {
      modifiers: [sameWidthModifier],
      placement: "bottom-start"
    });
    const [inputValue, setInputValue] = React.useState((_d = (_b = (_a3 = props.initialValue) === null || _a3 === void 0 ? void 0 : _a3.label) !== null && _b !== void 0 ? _b : (_c = props.selectedItem) === null || _c === void 0 ? void 0 : _c.label) !== null && _d !== void 0 ? _d : "");
    const [pendingHighlight, setPendingHighlight] = React.useState(null);
    const filteredItems = props.items.filter((item) => {
      var _a4;
      return inputValue ? (_a4 = item.label) === null || _a4 === void 0 ? void 0 : _a4.toLowerCase().includes(inputValue === null || inputValue === void 0 ? void 0 : inputValue.toLowerCase()) : true;
    });
    const { selectedItem, isOpen, getMenuProps, getInputProps, getToggleButtonProps, highlightedIndex, getItemProps, setHighlightedIndex } = useCombobox(Object.assign({ initialIsOpen: props.initialIsOpen, initialSelectedItem: (_e2 = props.initialValue) !== null && _e2 !== void 0 ? _e2 : props.selectedItem, itemToString: (item) => item ? item.label : "", items: filteredItems, onInputValueChange: (change) => {
      setInputValue(change.inputValue);
    }, onSelectedItemChange: (changes) => {
      var _a4, _b2;
      if (props.onSelect) {
        if (props.selectedItem && ((_a4 = changes.selectedItem) === null || _a4 === void 0 ? void 0 : _a4.value) !== ((_b2 = props.selectedItem) === null || _b2 === void 0 ? void 0 : _b2.value) || !props.selectedItem) {
          props.onSelect(changes.selectedItem);
        }
      }
    }, stateReducer: (state, { changes, type }) => {
      var _a4;
      if (type === stateChangeTypes$3.InputFocus || type === stateChangeTypes$3.ToggleButtonClick && changes.isOpen || type === stateChangeTypes$3.ControlledPropUpdatedSelectedItem && changes.isOpen) {
        setPendingHighlight(changes.selectedItem ? props.items.findIndex((i2) => i2.value === changes.selectedItem.value) : 0);
        return Object.assign(Object.assign({}, changes), { inputValue: "" });
      }
      if ([
        stateChangeTypes$3.InputKeyDownEnter,
        stateChangeTypes$3.ItemClick,
        stateChangeTypes$3.InputBlur,
        stateChangeTypes$3.InputKeyDownEscape,
        stateChangeTypes$3.ToggleButtonClick
      ].includes(type)) {
        return Object.assign(Object.assign({}, changes), { inputValue: ((_a4 = changes.selectedItem) === null || _a4 === void 0 ? void 0 : _a4.label) || "" });
      }
      return changes;
    } }, "selectedItem" in props && { selectedItem: props.selectedItem }));
    React.useEffect(() => {
      if (isOpen && pendingHighlight !== null) {
        setHighlightedIndex(pendingHighlight);
        setPendingHighlight(null);
      }
    }, [isOpen, pendingHighlight, setHighlightedIndex]);
    React.useEffect(() => {
      if (props.selectedItem === null) {
        setInputValue("");
      }
    }, [props.selectedItem]);
    React.useEffect(() => {
      if (isOpen && update2) {
        update2();
      }
    }, [isOpen, update2]);
    const menuProps = getMenuProps();
    const setMenuRef = menuProps.ref;
    delete menuProps.ref;
    const setMenuReference = (value) => {
      setMenuRef(value);
      popperElement.current = value;
    };
    return jsxRuntime.exports.jsx(Tooltip$1, { content: props.errorMsg, disabled: !props.errorMsg, styling: "error", children: jsxRuntime.exports.jsxs(Wrapper$a, { className: props.className, isDisabled: props.disabled, isErrored: !!props.errorMsg, isOpen, style: props.style, children: [jsxRuntime.exports.jsxs(InputWrapper$4, { disabled: props.disabled, isOpen, ref: referenceElement, children: [jsxRuntime.exports.jsx(Input$2, Object.assign({}, getInputProps({
      disabled: props.disabled
    }), { placeholder: (_f = selectedItem === null ? props.placeholder : selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.label) !== null && _f !== void 0 ? _f : props.placeholder, size: props.size })), jsxRuntime.exports.jsx(ChevronButton$1, Object.assign({}, getToggleButtonProps(), { children: jsxRuntime.exports.jsx(Chevron$2, { disabled: props.disabled, isOpen }) }))] }), ReactDOM__default.default.createPortal(jsxRuntime.exports.jsxs(DropdownList$3, Object.assign({}, menuProps, attributes2.popper, { isOpen, ref: setMenuReference, style: Object.assign(Object.assign({}, styles2.popper), { width: parseFloat((_g = styles2.popper) === null || _g === void 0 ? void 0 : _g.width) + 2, zIndex: 9999 }), children: [filteredItems.length > 0 && filteredItems.map((item, index2) => React.createElement(ListItem, Object.assign({}, getItemProps({ index: index2, item }), { hovered: index2 === highlightedIndex, key: `item-${index2}`, size: props.size, title: item.label }), item.label)), filteredItems.length === 0 && jsxRuntime.exports.jsx(NoItemsLabel$1, { children: "No Items" })] })), document.body)] }) });
  }
  styled__default.default(List)`
    overflow-y: auto;
    box-shadow: ${(props) => props.theme.shadow.light};
`;
  function toInteger$3(dirtyNumber) {
    if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
      return NaN;
    }
    var number2 = Number(dirtyNumber);
    if (isNaN(number2)) {
      return number2;
    }
    return number2 < 0 ? Math.ceil(number2) : Math.floor(number2);
  }
  function requiredArgs$1(required2, args) {
    if (args.length < required2) {
      throw new TypeError(required2 + " argument" + required2 > 1 ? "s" : " required, but only " + args.length + " present");
    }
  }
  function toDate$1(argument) {
    requiredArgs$1(1, arguments);
    var argStr = Object.prototype.toString.call(argument);
    if (argument instanceof Date || typeof argument === "object" && argStr === "[object Date]") {
      return new Date(argument.getTime());
    } else if (typeof argument === "number" || argStr === "[object Number]") {
      return new Date(argument);
    } else {
      if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
        console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as arguments. Please use `parseISO` to parse strings. See: https://git.io/fjule");
        console.warn(new Error().stack);
      }
      return new Date(NaN);
    }
  }
  function addMilliseconds$1(dirtyDate, dirtyAmount) {
    requiredArgs$1(2, arguments);
    var timestamp = toDate$1(dirtyDate).getTime();
    var amount = toInteger$3(dirtyAmount);
    return new Date(timestamp + amount);
  }
  var MILLISECONDS_IN_MINUTE$3 = 6e4;
  function getTimezoneOffsetInMilliseconds$1(dirtyDate) {
    var date = new Date(dirtyDate.getTime());
    var baseTimezoneOffset = Math.ceil(date.getTimezoneOffset());
    date.setSeconds(0, 0);
    var millisecondsPartOfTimezoneOffset = date.getTime() % MILLISECONDS_IN_MINUTE$3;
    return baseTimezoneOffset * MILLISECONDS_IN_MINUTE$3 + millisecondsPartOfTimezoneOffset;
  }
  function isValid$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    return !isNaN(date);
  }
  var formatDistanceLocale$1 = {
    lessThanXSeconds: {
      one: "less than a second",
      other: "less than {{count}} seconds"
    },
    xSeconds: {
      one: "1 second",
      other: "{{count}} seconds"
    },
    halfAMinute: "half a minute",
    lessThanXMinutes: {
      one: "less than a minute",
      other: "less than {{count}} minutes"
    },
    xMinutes: {
      one: "1 minute",
      other: "{{count}} minutes"
    },
    aboutXHours: {
      one: "about 1 hour",
      other: "about {{count}} hours"
    },
    xHours: {
      one: "1 hour",
      other: "{{count}} hours"
    },
    xDays: {
      one: "1 day",
      other: "{{count}} days"
    },
    aboutXMonths: {
      one: "about 1 month",
      other: "about {{count}} months"
    },
    xMonths: {
      one: "1 month",
      other: "{{count}} months"
    },
    aboutXYears: {
      one: "about 1 year",
      other: "about {{count}} years"
    },
    xYears: {
      one: "1 year",
      other: "{{count}} years"
    },
    overXYears: {
      one: "over 1 year",
      other: "over {{count}} years"
    },
    almostXYears: {
      one: "almost 1 year",
      other: "almost {{count}} years"
    }
  };
  function formatDistance$2(token, count2, options) {
    options = options || {};
    var result;
    if (typeof formatDistanceLocale$1[token] === "string") {
      result = formatDistanceLocale$1[token];
    } else if (count2 === 1) {
      result = formatDistanceLocale$1[token].one;
    } else {
      result = formatDistanceLocale$1[token].other.replace("{{count}}", count2);
    }
    if (options.addSuffix) {
      if (options.comparison > 0) {
        return "in " + result;
      } else {
        return result + " ago";
      }
    }
    return result;
  }
  function buildFormatLongFn$1(args) {
    return function(dirtyOptions) {
      var options = dirtyOptions || {};
      var width = options.width ? String(options.width) : args.defaultWidth;
      var format2 = args.formats[width] || args.formats[args.defaultWidth];
      return format2;
    };
  }
  var dateFormats$2 = {
    full: "EEEE, MMMM do, y",
    long: "MMMM do, y",
    medium: "MMM d, y",
    short: "MM/dd/yyyy"
  };
  var timeFormats$2 = {
    full: "h:mm:ss a zzzz",
    long: "h:mm:ss a z",
    medium: "h:mm:ss a",
    short: "h:mm a"
  };
  var dateTimeFormats$2 = {
    full: "{{date}} 'at' {{time}}",
    long: "{{date}} 'at' {{time}}",
    medium: "{{date}}, {{time}}",
    short: "{{date}}, {{time}}"
  };
  var formatLong$4 = {
    date: buildFormatLongFn$1({
      formats: dateFormats$2,
      defaultWidth: "full"
    }),
    time: buildFormatLongFn$1({
      formats: timeFormats$2,
      defaultWidth: "full"
    }),
    dateTime: buildFormatLongFn$1({
      formats: dateTimeFormats$2,
      defaultWidth: "full"
    })
  };
  const formatLong$5 = formatLong$4;
  var formatRelativeLocale$1 = {
    lastWeek: "'last' eeee 'at' p",
    yesterday: "'yesterday at' p",
    today: "'today at' p",
    tomorrow: "'tomorrow at' p",
    nextWeek: "eeee 'at' p",
    other: "P"
  };
  function formatRelative$2(token, _date, _baseDate, _options) {
    return formatRelativeLocale$1[token];
  }
  function buildLocalizeFn$1(args) {
    return function(dirtyIndex, dirtyOptions) {
      var options = dirtyOptions || {};
      var context2 = options.context ? String(options.context) : "standalone";
      var valuesArray;
      if (context2 === "formatting" && args.formattingValues) {
        var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
        var width = options.width ? String(options.width) : defaultWidth;
        valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
      } else {
        var _defaultWidth = args.defaultWidth;
        var _width = options.width ? String(options.width) : args.defaultWidth;
        valuesArray = args.values[_width] || args.values[_defaultWidth];
      }
      var index2 = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
      return valuesArray[index2];
    };
  }
  var eraValues$1 = {
    narrow: ["B", "A"],
    abbreviated: ["BC", "AD"],
    wide: ["Before Christ", "Anno Domini"]
  };
  var quarterValues$1 = {
    narrow: ["1", "2", "3", "4"],
    abbreviated: ["Q1", "Q2", "Q3", "Q4"],
    wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
  };
  var monthValues$1 = {
    narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
    abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
  };
  var dayValues$1 = {
    narrow: ["S", "M", "T", "W", "T", "F", "S"],
    short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
    abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
  };
  var dayPeriodValues$1 = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    }
  };
  var formattingDayPeriodValues$1 = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    }
  };
  function ordinalNumber$1(dirtyNumber, _dirtyOptions) {
    var number2 = Number(dirtyNumber);
    var rem100 = number2 % 100;
    if (rem100 > 20 || rem100 < 10) {
      switch (rem100 % 10) {
        case 1:
          return number2 + "st";
        case 2:
          return number2 + "nd";
        case 3:
          return number2 + "rd";
      }
    }
    return number2 + "th";
  }
  var localize$2 = {
    ordinalNumber: ordinalNumber$1,
    era: buildLocalizeFn$1({
      values: eraValues$1,
      defaultWidth: "wide"
    }),
    quarter: buildLocalizeFn$1({
      values: quarterValues$1,
      defaultWidth: "wide",
      argumentCallback: function(quarter) {
        return Number(quarter) - 1;
      }
    }),
    month: buildLocalizeFn$1({
      values: monthValues$1,
      defaultWidth: "wide"
    }),
    day: buildLocalizeFn$1({
      values: dayValues$1,
      defaultWidth: "wide"
    }),
    dayPeriod: buildLocalizeFn$1({
      values: dayPeriodValues$1,
      defaultWidth: "wide",
      formattingValues: formattingDayPeriodValues$1,
      defaultFormattingWidth: "wide"
    })
  };
  const localize$3 = localize$2;
  function buildMatchPatternFn$1(args) {
    return function(dirtyString, dirtyOptions) {
      var string2 = String(dirtyString);
      var options = dirtyOptions || {};
      var matchResult = string2.match(args.matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parseResult = string2.match(args.parsePattern);
      if (!parseResult) {
        return null;
      }
      var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value,
        rest: string2.slice(matchedString.length)
      };
    };
  }
  function buildMatchFn$1(args) {
    return function(dirtyString, dirtyOptions) {
      var string2 = String(dirtyString);
      var options = dirtyOptions || {};
      var width = options.width;
      var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
      var matchResult = string2.match(matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
      var value;
      if (Object.prototype.toString.call(parsePatterns) === "[object Array]") {
        value = findIndex$1(parsePatterns, function(pattern) {
          return pattern.test(string2);
        });
      } else {
        value = findKey$1(parsePatterns, function(pattern) {
          return pattern.test(string2);
        });
      }
      value = args.valueCallback ? args.valueCallback(value) : value;
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value,
        rest: string2.slice(matchedString.length)
      };
    };
  }
  function findKey$1(object2, predicate) {
    for (var key in object2) {
      if (object2.hasOwnProperty(key) && predicate(object2[key])) {
        return key;
      }
    }
  }
  function findIndex$1(array2, predicate) {
    for (var key = 0; key < array2.length; key++) {
      if (predicate(array2[key])) {
        return key;
      }
    }
  }
  var matchOrdinalNumberPattern$1 = /^(\d+)(th|st|nd|rd)?/i;
  var parseOrdinalNumberPattern$1 = /\d+/i;
  var matchEraPatterns$1 = {
    narrow: /^(b|a)/i,
    abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
    wide: /^(before christ|before common era|anno domini|common era)/i
  };
  var parseEraPatterns$1 = {
    any: [/^b/i, /^(a|c)/i]
  };
  var matchQuarterPatterns$1 = {
    narrow: /^[1234]/i,
    abbreviated: /^q[1234]/i,
    wide: /^[1234](th|st|nd|rd)? quarter/i
  };
  var parseQuarterPatterns$1 = {
    any: [/1/i, /2/i, /3/i, /4/i]
  };
  var matchMonthPatterns$1 = {
    narrow: /^[jfmasond]/i,
    abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
    wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
  };
  var parseMonthPatterns$1 = {
    narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
    any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
  };
  var matchDayPatterns$1 = {
    narrow: /^[smtwf]/i,
    short: /^(su|mo|tu|we|th|fr|sa)/i,
    abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
    wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
  };
  var parseDayPatterns$1 = {
    narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
    any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
  };
  var matchDayPeriodPatterns$1 = {
    narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
    any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
  };
  var parseDayPeriodPatterns$1 = {
    any: {
      am: /^a/i,
      pm: /^p/i,
      midnight: /^mi/i,
      noon: /^no/i,
      morning: /morning/i,
      afternoon: /afternoon/i,
      evening: /evening/i,
      night: /night/i
    }
  };
  var match$3 = {
    ordinalNumber: buildMatchPatternFn$1({
      matchPattern: matchOrdinalNumberPattern$1,
      parsePattern: parseOrdinalNumberPattern$1,
      valueCallback: function(value) {
        return parseInt(value, 10);
      }
    }),
    era: buildMatchFn$1({
      matchPatterns: matchEraPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseEraPatterns$1,
      defaultParseWidth: "any"
    }),
    quarter: buildMatchFn$1({
      matchPatterns: matchQuarterPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseQuarterPatterns$1,
      defaultParseWidth: "any",
      valueCallback: function(index2) {
        return index2 + 1;
      }
    }),
    month: buildMatchFn$1({
      matchPatterns: matchMonthPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseMonthPatterns$1,
      defaultParseWidth: "any"
    }),
    day: buildMatchFn$1({
      matchPatterns: matchDayPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseDayPatterns$1,
      defaultParseWidth: "any"
    }),
    dayPeriod: buildMatchFn$1({
      matchPatterns: matchDayPeriodPatterns$1,
      defaultMatchWidth: "any",
      parsePatterns: parseDayPeriodPatterns$1,
      defaultParseWidth: "any"
    })
  };
  const match$4 = match$3;
  var locale$2 = {
    code: "en-US",
    formatDistance: formatDistance$2,
    formatLong: formatLong$5,
    formatRelative: formatRelative$2,
    localize: localize$3,
    match: match$4,
    options: {
      weekStartsOn: 0,
      firstWeekContainsDate: 1
    }
  };
  const defaultLocale$1 = locale$2;
  function subMilliseconds$1(dirtyDate, dirtyAmount) {
    requiredArgs$1(2, arguments);
    var amount = toInteger$3(dirtyAmount);
    return addMilliseconds$1(dirtyDate, -amount);
  }
  function addLeadingZeros$1(number2, targetLength) {
    var sign2 = number2 < 0 ? "-" : "";
    var output2 = Math.abs(number2).toString();
    while (output2.length < targetLength) {
      output2 = "0" + output2;
    }
    return sign2 + output2;
  }
  var formatters$5 = {
    y: function(date, token) {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return addLeadingZeros$1(token === "yy" ? year % 100 : year, token.length);
    },
    M: function(date, token) {
      var month = date.getUTCMonth();
      return token === "M" ? String(month + 1) : addLeadingZeros$1(month + 1, 2);
    },
    d: function(date, token) {
      return addLeadingZeros$1(date.getUTCDate(), token.length);
    },
    a: function(date, token) {
      var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return dayPeriodEnumValue.toUpperCase();
        case "aaaaa":
          return dayPeriodEnumValue[0];
        case "aaaa":
        default:
          return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
      }
    },
    h: function(date, token) {
      return addLeadingZeros$1(date.getUTCHours() % 12 || 12, token.length);
    },
    H: function(date, token) {
      return addLeadingZeros$1(date.getUTCHours(), token.length);
    },
    m: function(date, token) {
      return addLeadingZeros$1(date.getUTCMinutes(), token.length);
    },
    s: function(date, token) {
      return addLeadingZeros$1(date.getUTCSeconds(), token.length);
    },
    S: function(date, token) {
      var numberOfDigits = token.length;
      var milliseconds = date.getUTCMilliseconds();
      var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
      return addLeadingZeros$1(fractionalSeconds, token.length);
    }
  };
  const formatters$6 = formatters$5;
  var MILLISECONDS_IN_DAY$2 = 864e5;
  function getUTCDayOfYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var timestamp = date.getTime();
    date.setUTCMonth(0, 1);
    date.setUTCHours(0, 0, 0, 0);
    var startOfYearTimestamp = date.getTime();
    var difference2 = timestamp - startOfYearTimestamp;
    return Math.floor(difference2 / MILLISECONDS_IN_DAY$2) + 1;
  }
  function startOfUTCISOWeek$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var weekStartsOn = 1;
    var date = toDate$1(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCISOWeekYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var year = date.getUTCFullYear();
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCISOWeek$1(fourthOfJanuaryOfNextYear);
    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCISOWeek$1(fourthOfJanuaryOfThisYear);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCISOWeekYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var year = getUTCISOWeekYear$1(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setUTCFullYear(year, 0, 4);
    fourthOfJanuary.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCISOWeek$1(fourthOfJanuary);
    return date;
  }
  var MILLISECONDS_IN_WEEK$4 = 6048e5;
  function getUTCISOWeek$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var diff = startOfUTCISOWeek$1(date).getTime() - startOfUTCISOWeekYear$1(date).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$4) + 1;
  }
  function startOfUTCWeek$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeWeekStartsOn = locale2 && locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate$1(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCWeekYear$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate, dirtyOptions);
    var year = date.getUTCFullYear();
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeFirstWeekContainsDate = locale2 && locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var firstWeekOfNextYear = new Date(0);
    firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
    firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCWeek$1(firstWeekOfNextYear, dirtyOptions);
    var firstWeekOfThisYear = new Date(0);
    firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCWeek$1(firstWeekOfThisYear, dirtyOptions);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCWeekYear$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeFirstWeekContainsDate = locale2 && locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    var year = getUTCWeekYear$1(dirtyDate, dirtyOptions);
    var firstWeek = new Date(0);
    firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeek.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCWeek$1(firstWeek, dirtyOptions);
    return date;
  }
  var MILLISECONDS_IN_WEEK$3 = 6048e5;
  function getUTCWeek$1(dirtyDate, options) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var diff = startOfUTCWeek$1(date, options).getTime() - startOfUTCWeekYear$1(date, options).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$3) + 1;
  }
  var dayPeriodEnum$1 = {
    am: "am",
    pm: "pm",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  };
  var formatters$3 = {
    G: function(date, token, localize2) {
      var era = date.getUTCFullYear() > 0 ? 1 : 0;
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return localize2.era(era, {
            width: "abbreviated"
          });
        case "GGGGG":
          return localize2.era(era, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return localize2.era(era, {
            width: "wide"
          });
      }
    },
    y: function(date, token, localize2) {
      if (token === "yo") {
        var signedYear = date.getUTCFullYear();
        var year = signedYear > 0 ? signedYear : 1 - signedYear;
        return localize2.ordinalNumber(year, {
          unit: "year"
        });
      }
      return formatters$6.y(date, token);
    },
    Y: function(date, token, localize2, options) {
      var signedWeekYear = getUTCWeekYear$1(date, options);
      var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
      if (token === "YY") {
        var twoDigitYear = weekYear % 100;
        return addLeadingZeros$1(twoDigitYear, 2);
      }
      if (token === "Yo") {
        return localize2.ordinalNumber(weekYear, {
          unit: "year"
        });
      }
      return addLeadingZeros$1(weekYear, token.length);
    },
    R: function(date, token) {
      var isoWeekYear = getUTCISOWeekYear$1(date);
      return addLeadingZeros$1(isoWeekYear, token.length);
    },
    u: function(date, token) {
      var year = date.getUTCFullYear();
      return addLeadingZeros$1(year, token.length);
    },
    Q: function(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "Q":
          return String(quarter);
        case "QQ":
          return addLeadingZeros$1(quarter, 2);
        case "Qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "QQQ":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "formatting"
          });
        case "QQQQQ":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    q: function(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "q":
          return String(quarter);
        case "qq":
          return addLeadingZeros$1(quarter, 2);
        case "qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "qqq":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "standalone"
          });
        case "qqqqq":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    M: function(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "M":
        case "MM":
          return formatters$6.M(date, token);
        case "Mo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "MMM":
          return localize2.month(month, {
            width: "abbreviated",
            context: "formatting"
          });
        case "MMMMM":
          return localize2.month(month, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    L: function(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "L":
          return String(month + 1);
        case "LL":
          return addLeadingZeros$1(month + 1, 2);
        case "Lo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "LLL":
          return localize2.month(month, {
            width: "abbreviated",
            context: "standalone"
          });
        case "LLLLL":
          return localize2.month(month, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    w: function(date, token, localize2, options) {
      var week = getUTCWeek$1(date, options);
      if (token === "wo") {
        return localize2.ordinalNumber(week, {
          unit: "week"
        });
      }
      return addLeadingZeros$1(week, token.length);
    },
    I: function(date, token, localize2) {
      var isoWeek = getUTCISOWeek$1(date);
      if (token === "Io") {
        return localize2.ordinalNumber(isoWeek, {
          unit: "week"
        });
      }
      return addLeadingZeros$1(isoWeek, token.length);
    },
    d: function(date, token, localize2) {
      if (token === "do") {
        return localize2.ordinalNumber(date.getUTCDate(), {
          unit: "date"
        });
      }
      return formatters$6.d(date, token);
    },
    D: function(date, token, localize2) {
      var dayOfYear = getUTCDayOfYear$1(date);
      if (token === "Do") {
        return localize2.ordinalNumber(dayOfYear, {
          unit: "dayOfYear"
        });
      }
      return addLeadingZeros$1(dayOfYear, token.length);
    },
    E: function(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "EEEEE":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "EEEE":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    e: function(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "e":
          return String(localDayOfWeek);
        case "ee":
          return addLeadingZeros$1(localDayOfWeek, 2);
        case "eo":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "eee":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "eeeee":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "eeee":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    c: function(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "c":
          return String(localDayOfWeek);
        case "cc":
          return addLeadingZeros$1(localDayOfWeek, token.length);
        case "co":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "ccc":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "standalone"
          });
        case "ccccc":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "standalone"
          });
        case "cccc":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    i: function(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
      switch (token) {
        case "i":
          return String(isoDayOfWeek);
        case "ii":
          return addLeadingZeros$1(isoDayOfWeek, token.length);
        case "io":
          return localize2.ordinalNumber(isoDayOfWeek, {
            unit: "day"
          });
        case "iii":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "iiiii":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "iiiiii":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "iiii":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    a: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "aaaaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    b: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours === 12) {
        dayPeriodEnumValue = dayPeriodEnum$1.noon;
      } else if (hours === 0) {
        dayPeriodEnumValue = dayPeriodEnum$1.midnight;
      } else {
        dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      }
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "bbbbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    B: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours >= 17) {
        dayPeriodEnumValue = dayPeriodEnum$1.evening;
      } else if (hours >= 12) {
        dayPeriodEnumValue = dayPeriodEnum$1.afternoon;
      } else if (hours >= 4) {
        dayPeriodEnumValue = dayPeriodEnum$1.morning;
      } else {
        dayPeriodEnumValue = dayPeriodEnum$1.night;
      }
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "BBBBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    h: function(date, token, localize2) {
      if (token === "ho") {
        var hours = date.getUTCHours() % 12;
        if (hours === 0)
          hours = 12;
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return formatters$6.h(date, token);
    },
    H: function(date, token, localize2) {
      if (token === "Ho") {
        return localize2.ordinalNumber(date.getUTCHours(), {
          unit: "hour"
        });
      }
      return formatters$6.H(date, token);
    },
    K: function(date, token, localize2) {
      var hours = date.getUTCHours() % 12;
      if (token === "Ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros$1(hours, token.length);
    },
    k: function(date, token, localize2) {
      var hours = date.getUTCHours();
      if (hours === 0)
        hours = 24;
      if (token === "ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros$1(hours, token.length);
    },
    m: function(date, token, localize2) {
      if (token === "mo") {
        return localize2.ordinalNumber(date.getUTCMinutes(), {
          unit: "minute"
        });
      }
      return formatters$6.m(date, token);
    },
    s: function(date, token, localize2) {
      if (token === "so") {
        return localize2.ordinalNumber(date.getUTCSeconds(), {
          unit: "second"
        });
      }
      return formatters$6.s(date, token);
    },
    S: function(date, token) {
      return formatters$6.S(date, token);
    },
    X: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      if (timezoneOffset === 0) {
        return "Z";
      }
      switch (token) {
        case "X":
          return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
        case "XXXX":
        case "XX":
          return formatTimezone$1(timezoneOffset);
        case "XXXXX":
        case "XXX":
        default:
          return formatTimezone$1(timezoneOffset, ":");
      }
    },
    x: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "x":
          return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
        case "xxxx":
        case "xx":
          return formatTimezone$1(timezoneOffset);
        case "xxxxx":
        case "xxx":
        default:
          return formatTimezone$1(timezoneOffset, ":");
      }
    },
    O: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "O":
        case "OO":
        case "OOO":
          return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
        case "OOOO":
        default:
          return "GMT" + formatTimezone$1(timezoneOffset, ":");
      }
    },
    z: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "z":
        case "zz":
        case "zzz":
          return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
        case "zzzz":
        default:
          return "GMT" + formatTimezone$1(timezoneOffset, ":");
      }
    },
    t: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = Math.floor(originalDate.getTime() / 1e3);
      return addLeadingZeros$1(timestamp, token.length);
    },
    T: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = originalDate.getTime();
      return addLeadingZeros$1(timestamp, token.length);
    }
  };
  function formatTimezoneShort$1(offset2, dirtyDelimiter) {
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = Math.floor(absOffset / 60);
    var minutes = absOffset % 60;
    if (minutes === 0) {
      return sign2 + String(hours);
    }
    var delimiter = dirtyDelimiter || "";
    return sign2 + String(hours) + delimiter + addLeadingZeros$1(minutes, 2);
  }
  function formatTimezoneWithOptionalMinutes$1(offset2, dirtyDelimiter) {
    if (offset2 % 60 === 0) {
      var sign2 = offset2 > 0 ? "-" : "+";
      return sign2 + addLeadingZeros$1(Math.abs(offset2) / 60, 2);
    }
    return formatTimezone$1(offset2, dirtyDelimiter);
  }
  function formatTimezone$1(offset2, dirtyDelimiter) {
    var delimiter = dirtyDelimiter || "";
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = addLeadingZeros$1(Math.floor(absOffset / 60), 2);
    var minutes = addLeadingZeros$1(absOffset % 60, 2);
    return sign2 + hours + delimiter + minutes;
  }
  const formatters$4 = formatters$3;
  function dateLongFormatter$1(pattern, formatLong2) {
    switch (pattern) {
      case "P":
        return formatLong2.date({
          width: "short"
        });
      case "PP":
        return formatLong2.date({
          width: "medium"
        });
      case "PPP":
        return formatLong2.date({
          width: "long"
        });
      case "PPPP":
      default:
        return formatLong2.date({
          width: "full"
        });
    }
  }
  function timeLongFormatter$1(pattern, formatLong2) {
    switch (pattern) {
      case "p":
        return formatLong2.time({
          width: "short"
        });
      case "pp":
        return formatLong2.time({
          width: "medium"
        });
      case "ppp":
        return formatLong2.time({
          width: "long"
        });
      case "pppp":
      default:
        return formatLong2.time({
          width: "full"
        });
    }
  }
  function dateTimeLongFormatter$1(pattern, formatLong2) {
    var matchResult = pattern.match(/(P+)(p+)?/);
    var datePattern = matchResult[1];
    var timePattern = matchResult[2];
    if (!timePattern) {
      return dateLongFormatter$1(pattern, formatLong2);
    }
    var dateTimeFormat;
    switch (datePattern) {
      case "P":
        dateTimeFormat = formatLong2.dateTime({
          width: "short"
        });
        break;
      case "PP":
        dateTimeFormat = formatLong2.dateTime({
          width: "medium"
        });
        break;
      case "PPP":
        dateTimeFormat = formatLong2.dateTime({
          width: "long"
        });
        break;
      case "PPPP":
      default:
        dateTimeFormat = formatLong2.dateTime({
          width: "full"
        });
        break;
    }
    return dateTimeFormat.replace("{{date}}", dateLongFormatter$1(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter$1(timePattern, formatLong2));
  }
  var longFormatters$2 = {
    p: timeLongFormatter$1,
    P: dateTimeLongFormatter$1
  };
  const longFormatters$3 = longFormatters$2;
  var protectedDayOfYearTokens$1 = ["D", "DD"];
  var protectedWeekYearTokens$1 = ["YY", "YYYY"];
  function isProtectedDayOfYearToken$1(token) {
    return protectedDayOfYearTokens$1.indexOf(token) !== -1;
  }
  function isProtectedWeekYearToken$1(token) {
    return protectedWeekYearTokens$1.indexOf(token) !== -1;
  }
  function throwProtectedError$1(token) {
    if (token === "YYYY") {
      throw new RangeError("Use `yyyy` instead of `YYYY` for formatting years; see: https://git.io/fxCyr");
    } else if (token === "YY") {
      throw new RangeError("Use `yy` instead of `YY` for formatting years; see: https://git.io/fxCyr");
    } else if (token === "D") {
      throw new RangeError("Use `d` instead of `D` for formatting days of the month; see: https://git.io/fxCyr");
    } else if (token === "DD") {
      throw new RangeError("Use `dd` instead of `DD` for formatting days of the month; see: https://git.io/fxCyr");
    }
  }
  var formattingTokensRegExp$3 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
  var longFormattingTokensRegExp$3 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp$3 = /^'([^]*?)'?$/;
  var doubleQuoteRegExp$3 = /''/g;
  var unescapedLatinCharacterRegExp$3 = /[a-zA-Z]/;
  function format$2(dirtyDate, dirtyFormatStr, dirtyOptions) {
    requiredArgs$1(2, arguments);
    var formatStr = String(dirtyFormatStr);
    var options = dirtyOptions || {};
    var locale2 = options.locale || defaultLocale$1;
    var localeFirstWeekContainsDate = locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var localeWeekStartsOn = locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    if (!locale2.localize) {
      throw new RangeError("locale must contain localize property");
    }
    if (!locale2.formatLong) {
      throw new RangeError("locale must contain formatLong property");
    }
    var originalDate = toDate$1(dirtyDate);
    if (!isValid$1(originalDate)) {
      throw new RangeError("Invalid time value");
    }
    var timezoneOffset = getTimezoneOffsetInMilliseconds$1(originalDate);
    var utcDate = subMilliseconds$1(originalDate, timezoneOffset);
    var formatterOptions = {
      firstWeekContainsDate,
      weekStartsOn,
      locale: locale2,
      _originalDate: originalDate
    };
    var result = formatStr.match(longFormattingTokensRegExp$3).map(function(substring) {
      var firstCharacter = substring[0];
      if (firstCharacter === "p" || firstCharacter === "P") {
        var longFormatter = longFormatters$3[firstCharacter];
        return longFormatter(substring, locale2.formatLong, formatterOptions);
      }
      return substring;
    }).join("").match(formattingTokensRegExp$3).map(function(substring) {
      if (substring === "''") {
        return "'";
      }
      var firstCharacter = substring[0];
      if (firstCharacter === "'") {
        return cleanEscapedString$3(substring);
      }
      var formatter = formatters$4[firstCharacter];
      if (formatter) {
        if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken$1(substring)) {
          throwProtectedError$1(substring);
        }
        if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken$1(substring)) {
          throwProtectedError$1(substring);
        }
        return formatter(utcDate, substring, locale2.localize, formatterOptions);
      }
      if (firstCharacter.match(unescapedLatinCharacterRegExp$3)) {
        throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
      }
      return substring;
    }).join("");
    return result;
  }
  function cleanEscapedString$3(input) {
    return input.match(escapedStringRegExp$3)[1].replace(doubleQuoteRegExp$3, "'");
  }
  function assign$6(target, dirtyObject) {
    if (target == null) {
      throw new TypeError("assign requires that input parameter not be null or undefined");
    }
    dirtyObject = dirtyObject || {};
    for (var property in dirtyObject) {
      if (dirtyObject.hasOwnProperty(property)) {
        target[property] = dirtyObject[property];
      }
    }
    return target;
  }
  function formatISO(dirtyDate, dirtyOptions) {
    if (arguments.length < 1) {
      throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
    }
    var originalDate = toDate$1(dirtyDate);
    if (!isValid$1(originalDate)) {
      throw new RangeError("Invalid time value");
    }
    var options = dirtyOptions || {};
    var format2 = options.format == null ? "extended" : String(options.format);
    var representation = options.representation == null ? "complete" : String(options.representation);
    if (format2 !== "extended" && format2 !== "basic") {
      throw new RangeError("format must be 'extended' or 'basic'");
    }
    if (representation !== "date" && representation !== "time" && representation !== "complete") {
      throw new RangeError("representation must be 'date', 'time', or 'complete'");
    }
    var result = "";
    var tzOffset = "";
    var dateDelimiter = format2 === "extended" ? "-" : "";
    var timeDelimiter = format2 === "extended" ? ":" : "";
    if (representation !== "time") {
      var day = addLeadingZeros$1(originalDate.getDate(), 2);
      var month = addLeadingZeros$1(originalDate.getMonth() + 1, 2);
      var year = addLeadingZeros$1(originalDate.getFullYear(), 4);
      result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
    }
    if (representation !== "date") {
      var offset2 = originalDate.getTimezoneOffset();
      if (offset2 !== 0) {
        var absoluteOffset = Math.abs(offset2);
        var hourOffset = addLeadingZeros$1(absoluteOffset / 60, 2);
        var minuteOffset = addLeadingZeros$1(absoluteOffset % 60, 2);
        var sign2 = offset2 < 0 ? "+" : "-";
        tzOffset = "".concat(sign2).concat(hourOffset, ":").concat(minuteOffset);
      } else {
        tzOffset = "Z";
      }
      var hour = addLeadingZeros$1(originalDate.getHours(), 2);
      var minute = addLeadingZeros$1(originalDate.getMinutes(), 2);
      var second = addLeadingZeros$1(originalDate.getSeconds(), 2);
      var separator = result === "" ? "" : "T";
      var time = [hour, minute, second].join(timeDelimiter);
      result = "".concat(result).concat(separator).concat(time).concat(tzOffset);
    }
    return result;
  }
  function isAfter$1(dirtyDate, dirtyDateToCompare) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var dateToCompare = toDate$1(dirtyDateToCompare);
    return date.getTime() > dateToCompare.getTime();
  }
  function isBefore$1(dirtyDate, dirtyDateToCompare) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var dateToCompare = toDate$1(dirtyDateToCompare);
    return date.getTime() < dateToCompare.getTime();
  }
  function isEqual$3(dirtyLeftDate, dirtyRightDate) {
    requiredArgs$1(2, arguments);
    var dateLeft = toDate$1(dirtyLeftDate);
    var dateRight = toDate$1(dirtyRightDate);
    return dateLeft.getTime() === dateRight.getTime();
  }
  function isWithinInterval$1(dirtyDate, dirtyInterval) {
    requiredArgs$1(2, arguments);
    var interval2 = dirtyInterval || {};
    var time = toDate$1(dirtyDate).getTime();
    var startTime = toDate$1(interval2.start).getTime();
    var endTime = toDate$1(interval2.end).getTime();
    if (!(startTime <= endTime)) {
      throw new RangeError("Invalid interval");
    }
    return time >= startTime && time <= endTime;
  }
  function setUTCDay$1(dirtyDate, dirtyDay, dirtyOptions) {
    requiredArgs$1(2, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeWeekStartsOn = locale2 && locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate$1(dirtyDate);
    var day = toInteger$3(dirtyDay);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  function setUTCISODay$1(dirtyDate, dirtyDay) {
    requiredArgs$1(2, arguments);
    var day = toInteger$3(dirtyDay);
    if (day % 7 === 0) {
      day = day - 7;
    }
    var weekStartsOn = 1;
    var date = toDate$1(dirtyDate);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  function setUTCISOWeek$1(dirtyDate, dirtyISOWeek) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var isoWeek = toInteger$3(dirtyISOWeek);
    var diff = getUTCISOWeek$1(date) - isoWeek;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }
  function setUTCWeek$1(dirtyDate, dirtyWeek, options) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var week = toInteger$3(dirtyWeek);
    var diff = getUTCWeek$1(date, options) - week;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }
  var MILLISECONDS_IN_HOUR$2 = 36e5;
  var MILLISECONDS_IN_MINUTE$2 = 6e4;
  var MILLISECONDS_IN_SECOND = 1e3;
  var numericPatterns$1 = {
    month: /^(1[0-2]|0?\d)/,
    date: /^(3[0-1]|[0-2]?\d)/,
    dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
    week: /^(5[0-3]|[0-4]?\d)/,
    hour23h: /^(2[0-3]|[0-1]?\d)/,
    hour24h: /^(2[0-4]|[0-1]?\d)/,
    hour11h: /^(1[0-1]|0?\d)/,
    hour12h: /^(1[0-2]|0?\d)/,
    minute: /^[0-5]?\d/,
    second: /^[0-5]?\d/,
    singleDigit: /^\d/,
    twoDigits: /^\d{1,2}/,
    threeDigits: /^\d{1,3}/,
    fourDigits: /^\d{1,4}/,
    anyDigitsSigned: /^-?\d+/,
    singleDigitSigned: /^-?\d/,
    twoDigitsSigned: /^-?\d{1,2}/,
    threeDigitsSigned: /^-?\d{1,3}/,
    fourDigitsSigned: /^-?\d{1,4}/
  };
  var timezonePatterns$1 = {
    basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
    basic: /^([+-])(\d{2})(\d{2})|Z/,
    basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
    extended: /^([+-])(\d{2}):(\d{2})|Z/,
    extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
  };
  function parseNumericPattern$1(pattern, string2, valueCallback) {
    var matchResult = string2.match(pattern);
    if (!matchResult) {
      return null;
    }
    var value = parseInt(matchResult[0], 10);
    return {
      value: valueCallback ? valueCallback(value) : value,
      rest: string2.slice(matchResult[0].length)
    };
  }
  function parseTimezonePattern$1(pattern, string2) {
    var matchResult = string2.match(pattern);
    if (!matchResult) {
      return null;
    }
    if (matchResult[0] === "Z") {
      return {
        value: 0,
        rest: string2.slice(1)
      };
    }
    var sign2 = matchResult[1] === "+" ? 1 : -1;
    var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
    var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
    var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
    return {
      value: sign2 * (hours * MILLISECONDS_IN_HOUR$2 + minutes * MILLISECONDS_IN_MINUTE$2 + seconds * MILLISECONDS_IN_SECOND),
      rest: string2.slice(matchResult[0].length)
    };
  }
  function parseAnyDigitsSigned$1(string2, valueCallback) {
    return parseNumericPattern$1(numericPatterns$1.anyDigitsSigned, string2, valueCallback);
  }
  function parseNDigits$1(n2, string2, valueCallback) {
    switch (n2) {
      case 1:
        return parseNumericPattern$1(numericPatterns$1.singleDigit, string2, valueCallback);
      case 2:
        return parseNumericPattern$1(numericPatterns$1.twoDigits, string2, valueCallback);
      case 3:
        return parseNumericPattern$1(numericPatterns$1.threeDigits, string2, valueCallback);
      case 4:
        return parseNumericPattern$1(numericPatterns$1.fourDigits, string2, valueCallback);
      default:
        return parseNumericPattern$1(new RegExp("^\\d{1," + n2 + "}"), string2, valueCallback);
    }
  }
  function parseNDigitsSigned$1(n2, string2, valueCallback) {
    switch (n2) {
      case 1:
        return parseNumericPattern$1(numericPatterns$1.singleDigitSigned, string2, valueCallback);
      case 2:
        return parseNumericPattern$1(numericPatterns$1.twoDigitsSigned, string2, valueCallback);
      case 3:
        return parseNumericPattern$1(numericPatterns$1.threeDigitsSigned, string2, valueCallback);
      case 4:
        return parseNumericPattern$1(numericPatterns$1.fourDigitsSigned, string2, valueCallback);
      default:
        return parseNumericPattern$1(new RegExp("^-?\\d{1," + n2 + "}"), string2, valueCallback);
    }
  }
  function dayPeriodEnumToHours$1(enumValue) {
    switch (enumValue) {
      case "morning":
        return 4;
      case "evening":
        return 17;
      case "pm":
      case "noon":
      case "afternoon":
        return 12;
      case "am":
      case "midnight":
      case "night":
      default:
        return 0;
    }
  }
  function normalizeTwoDigitYear$1(twoDigitYear, currentYear) {
    var isCommonEra = currentYear > 0;
    var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
    var result;
    if (absCurrentYear <= 50) {
      result = twoDigitYear || 100;
    } else {
      var rangeEnd2 = absCurrentYear + 50;
      var rangeEndCentury = Math.floor(rangeEnd2 / 100) * 100;
      var isPreviousCentury = twoDigitYear >= rangeEnd2 % 100;
      result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
    }
    return isCommonEra ? result : 1 - result;
  }
  var DAYS_IN_MONTH$1 = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var DAYS_IN_MONTH_LEAP_YEAR$1 = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  function isLeapYearIndex$3(year) {
    return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
  }
  var parsers$1 = {
    G: {
      priority: 140,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "G":
          case "GG":
          case "GGG":
            return match2.era(string2, {
              width: "abbreviated"
            }) || match2.era(string2, {
              width: "narrow"
            });
          case "GGGGG":
            return match2.era(string2, {
              width: "narrow"
            });
          case "GGGG":
          default:
            return match2.era(string2, {
              width: "wide"
            }) || match2.era(string2, {
              width: "abbreviated"
            }) || match2.era(string2, {
              width: "narrow"
            });
        }
      },
      set: function(date, flags, value, _options) {
        flags.era = value;
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["R", "u", "t", "T"]
    },
    y: {
      priority: 130,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(year) {
          return {
            year,
            isTwoDigitYear: token === "yy"
          };
        };
        switch (token) {
          case "y":
            return parseNDigits$1(4, string2, valueCallback);
          case "yo":
            return match2.ordinalNumber(string2, {
              unit: "year",
              valueCallback
            });
          default:
            return parseNDigits$1(token.length, string2, valueCallback);
        }
      },
      validate: function(_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function(date, flags, value, _options) {
        var currentYear = date.getUTCFullYear();
        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
          date.setUTCHours(0, 0, 0, 0);
          return date;
        }
        var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]
    },
    Y: {
      priority: 130,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(year) {
          return {
            year,
            isTwoDigitYear: token === "YY"
          };
        };
        switch (token) {
          case "Y":
            return parseNDigits$1(4, string2, valueCallback);
          case "Yo":
            return match2.ordinalNumber(string2, {
              unit: "year",
              valueCallback
            });
          default:
            return parseNDigits$1(token.length, string2, valueCallback);
        }
      },
      validate: function(_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function(date, flags, value, options) {
        var currentYear = getUTCWeekYear$1(date, options);
        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
          date.setUTCHours(0, 0, 0, 0);
          return startOfUTCWeek$1(date, options);
        }
        var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek$1(date, options);
      },
      incompatibleTokens: ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]
    },
    R: {
      priority: 130,
      parse: function(string2, token, _match, _options) {
        if (token === "R") {
          return parseNDigitsSigned$1(4, string2);
        }
        return parseNDigitsSigned$1(token.length, string2);
      },
      set: function(_date, _flags, value, _options) {
        var firstWeekOfYear = new Date(0);
        firstWeekOfYear.setUTCFullYear(value, 0, 4);
        firstWeekOfYear.setUTCHours(0, 0, 0, 0);
        return startOfUTCISOWeek$1(firstWeekOfYear);
      },
      incompatibleTokens: ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]
    },
    u: {
      priority: 130,
      parse: function(string2, token, _match, _options) {
        if (token === "u") {
          return parseNDigitsSigned$1(4, string2);
        }
        return parseNDigitsSigned$1(token.length, string2);
      },
      set: function(date, _flags, value, _options) {
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]
    },
    Q: {
      priority: 120,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "Q":
          case "QQ":
            return parseNDigits$1(token.length, string2);
          case "Qo":
            return match2.ordinalNumber(string2, {
              unit: "quarter"
            });
          case "QQQ":
            return match2.quarter(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "QQQQQ":
            return match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "QQQQ":
          default:
            return match2.quarter(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]
    },
    q: {
      priority: 120,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "q":
          case "qq":
            return parseNDigits$1(token.length, string2);
          case "qo":
            return match2.ordinalNumber(string2, {
              unit: "quarter"
            });
          case "qqq":
            return match2.quarter(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "qqqqq":
            return match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "qqqq":
          default:
            return match2.quarter(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]
    },
    M: {
      priority: 110,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          return value - 1;
        };
        switch (token) {
          case "M":
            return parseNumericPattern$1(numericPatterns$1.month, string2, valueCallback);
          case "MM":
            return parseNDigits$1(2, string2, valueCallback);
          case "Mo":
            return match2.ordinalNumber(string2, {
              unit: "month",
              valueCallback
            });
          case "MMM":
            return match2.month(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "MMMMM":
            return match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "MMMM":
          default:
            return match2.month(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.month(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    L: {
      priority: 110,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          return value - 1;
        };
        switch (token) {
          case "L":
            return parseNumericPattern$1(numericPatterns$1.month, string2, valueCallback);
          case "LL":
            return parseNDigits$1(2, string2, valueCallback);
          case "Lo":
            return match2.ordinalNumber(string2, {
              unit: "month",
              valueCallback
            });
          case "LLL":
            return match2.month(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "LLLLL":
            return match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "LLLL":
          default:
            return match2.month(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.month(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    w: {
      priority: 100,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "w":
            return parseNumericPattern$1(numericPatterns$1.week, string2);
          case "wo":
            return match2.ordinalNumber(string2, {
              unit: "week"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function(date, _flags, value, options) {
        return startOfUTCWeek$1(setUTCWeek$1(date, value, options), options);
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]
    },
    I: {
      priority: 100,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "I":
            return parseNumericPattern$1(numericPatterns$1.week, string2);
          case "Io":
            return match2.ordinalNumber(string2, {
              unit: "week"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function(date, _flags, value, options) {
        return startOfUTCISOWeek$1(setUTCISOWeek$1(date, value, options), options);
      },
      incompatibleTokens: ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]
    },
    d: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "d":
            return parseNumericPattern$1(numericPatterns$1.date, string2);
          case "do":
            return match2.ordinalNumber(string2, {
              unit: "date"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex$3(year);
        var month = date.getUTCMonth();
        if (isLeapYear) {
          return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR$1[month];
        } else {
          return value >= 1 && value <= DAYS_IN_MONTH$1[month];
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCDate(value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    D: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "D":
          case "DD":
            return parseNumericPattern$1(numericPatterns$1.dayOfYear, string2);
          case "Do":
            return match2.ordinalNumber(string2, {
              unit: "date"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex$3(year);
        if (isLeapYear) {
          return value >= 1 && value <= 366;
        } else {
          return value >= 1 && value <= 365;
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(0, value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]
    },
    E: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "E":
          case "EE":
          case "EEE":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEEE":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEEEE":
            return match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEE":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["D", "i", "e", "c", "t", "T"]
    },
    e: {
      priority: 90,
      parse: function(string2, token, match2, options) {
        var valueCallback = function(value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };
        switch (token) {
          case "e":
          case "ee":
            return parseNDigits$1(token.length, string2, valueCallback);
          case "eo":
            return match2.ordinalNumber(string2, {
              unit: "day",
              valueCallback
            });
          case "eee":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeeee":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeeeee":
            return match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeee":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]
    },
    c: {
      priority: 90,
      parse: function(string2, token, match2, options) {
        var valueCallback = function(value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };
        switch (token) {
          case "c":
          case "cc":
            return parseNDigits$1(token.length, string2, valueCallback);
          case "co":
            return match2.ordinalNumber(string2, {
              unit: "day",
              valueCallback
            });
          case "ccc":
            return match2.day(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "ccccc":
            return match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "cccccc":
            return match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "cccc":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]
    },
    i: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          if (value === 0) {
            return 7;
          }
          return value;
        };
        switch (token) {
          case "i":
          case "ii":
            return parseNDigits$1(token.length, string2);
          case "io":
            return match2.ordinalNumber(string2, {
              unit: "day"
            });
          case "iii":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiiii":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiiiii":
            return match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiii":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 7;
      },
      set: function(date, _flags, value, options) {
        date = setUTCISODay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]
    },
    a: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "a":
          case "aa":
          case "aaa":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "aaaaa":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "aaaa":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["b", "B", "H", "K", "k", "t", "T"]
    },
    b: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "b":
          case "bb":
          case "bbb":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "bbbbb":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "bbbb":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "B", "H", "K", "k", "t", "T"]
    },
    B: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "B":
          case "BB":
          case "BBB":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "BBBBB":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "BBBB":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "t", "T"]
    },
    h: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "h":
            return parseNumericPattern$1(numericPatterns$1.hour12h, string2);
          case "ho":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 12;
      },
      set: function(date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;
        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else if (!isPM && value === 12) {
          date.setUTCHours(0, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }
        return date;
      },
      incompatibleTokens: ["H", "K", "k", "t", "T"]
    },
    H: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "H":
            return parseNumericPattern$1(numericPatterns$1.hour23h, string2);
          case "Ho":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 23;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(value, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "K", "k", "t", "T"]
    },
    K: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "K":
            return parseNumericPattern$1(numericPatterns$1.hour11h, string2);
          case "Ko":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;
        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "H", "k", "t", "T"]
    },
    k: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "k":
            return parseNumericPattern$1(numericPatterns$1.hour24h, string2);
          case "ko":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 24;
      },
      set: function(date, _flags, value, _options) {
        var hours = value <= 24 ? value % 24 : value;
        date.setUTCHours(hours, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "H", "K", "t", "T"]
    },
    m: {
      priority: 60,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "m":
            return parseNumericPattern$1(numericPatterns$1.minute, string2);
          case "mo":
            return match2.ordinalNumber(string2, {
              unit: "minute"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMinutes(value, 0, 0);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    s: {
      priority: 50,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "s":
            return parseNumericPattern$1(numericPatterns$1.second, string2);
          case "so":
            return match2.ordinalNumber(string2, {
              unit: "second"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCSeconds(value, 0);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    S: {
      priority: 30,
      parse: function(string2, token, _match, _options) {
        var valueCallback = function(value) {
          return Math.floor(value * Math.pow(10, -token.length + 3));
        };
        return parseNDigits$1(token.length, string2, valueCallback);
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMilliseconds(value);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    X: {
      priority: 10,
      parse: function(string2, token, _match, _options) {
        switch (token) {
          case "X":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, string2);
          case "XX":
            return parseTimezonePattern$1(timezonePatterns$1.basic, string2);
          case "XXXX":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, string2);
          case "XXXXX":
            return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, string2);
          case "XXX":
          default:
            return parseTimezonePattern$1(timezonePatterns$1.extended, string2);
        }
      },
      set: function(date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }
        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ["t", "T", "x"]
    },
    x: {
      priority: 10,
      parse: function(string2, token, _match, _options) {
        switch (token) {
          case "x":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, string2);
          case "xx":
            return parseTimezonePattern$1(timezonePatterns$1.basic, string2);
          case "xxxx":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, string2);
          case "xxxxx":
            return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, string2);
          case "xxx":
          default:
            return parseTimezonePattern$1(timezonePatterns$1.extended, string2);
        }
      },
      set: function(date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }
        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ["t", "T", "X"]
    },
    t: {
      priority: 40,
      parse: function(string2, _token, _match, _options) {
        return parseAnyDigitsSigned$1(string2);
      },
      set: function(_date, _flags, value, _options) {
        return [new Date(value * 1e3), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: "*"
    },
    T: {
      priority: 20,
      parse: function(string2, _token, _match, _options) {
        return parseAnyDigitsSigned$1(string2);
      },
      set: function(_date, _flags, value, _options) {
        return [new Date(value), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: "*"
    }
  };
  const parsers$2 = parsers$1;
  var TIMEZONE_UNIT_PRIORITY$1 = 10;
  var formattingTokensRegExp$2 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
  var longFormattingTokensRegExp$2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp$2 = /^'([^]*?)'?$/;
  var doubleQuoteRegExp$2 = /''/g;
  var notWhitespaceRegExp$1 = /\S/;
  var unescapedLatinCharacterRegExp$2 = /[a-zA-Z]/;
  function parse$a(dirtyDateString, dirtyFormatString, dirtyBackupDate, dirtyOptions) {
    requiredArgs$1(3, arguments);
    var dateString = String(dirtyDateString);
    var formatString = String(dirtyFormatString);
    var options = dirtyOptions || {};
    var locale2 = options.locale || defaultLocale$1;
    if (!locale2.match) {
      throw new RangeError("locale must contain match property");
    }
    var localeFirstWeekContainsDate = locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var localeWeekStartsOn = locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    if (formatString === "") {
      if (dateString === "") {
        return toDate$1(dirtyBackupDate);
      } else {
        return new Date(NaN);
      }
    }
    var subFnOptions = {
      firstWeekContainsDate,
      weekStartsOn,
      locale: locale2
    };
    var setters = [{
      priority: TIMEZONE_UNIT_PRIORITY$1,
      set: dateToSystemTimezone,
      index: 0
    }];
    var i2;
    var tokens2 = formatString.match(longFormattingTokensRegExp$2).map(function(substring) {
      var firstCharacter2 = substring[0];
      if (firstCharacter2 === "p" || firstCharacter2 === "P") {
        var longFormatter = longFormatters$3[firstCharacter2];
        return longFormatter(substring, locale2.formatLong, subFnOptions);
      }
      return substring;
    }).join("").match(formattingTokensRegExp$2);
    var usedTokens = [];
    for (i2 = 0; i2 < tokens2.length; i2++) {
      var token = tokens2[i2];
      if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken$1(token)) {
        throwProtectedError$1(token);
      }
      if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken$1(token)) {
        throwProtectedError$1(token);
      }
      var firstCharacter = token[0];
      var parser2 = parsers$2[firstCharacter];
      if (parser2) {
        var incompatibleTokens = parser2.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = void 0;
          for (var _i = 0; _i < usedTokens.length; _i++) {
            var usedToken = usedTokens[_i].token;
            if (incompatibleTokens.indexOf(usedToken) !== -1 || usedToken === firstCharacter) {
              incompatibleToken = usedTokens[_i];
              break;
            }
          }
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser2.incompatibleTokens === "*" && usedTokens.length) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser2.parse(dateString, token, locale2.match, subFnOptions);
        if (!parseResult) {
          return new Date(NaN);
        }
        setters.push({
          priority: parser2.priority,
          set: parser2.set,
          validate: parser2.validate,
          value: parseResult.value,
          index: setters.length
        });
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp$2)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString$2(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return new Date(NaN);
        }
      }
    }
    if (dateString.length > 0 && notWhitespaceRegExp$1.test(dateString)) {
      return new Date(NaN);
    }
    var uniquePrioritySetters = setters.map(function(setter2) {
      return setter2.priority;
    }).sort(function(a2, b2) {
      return b2 - a2;
    }).filter(function(priority, index2, array2) {
      return array2.indexOf(priority) === index2;
    }).map(function(priority) {
      return setters.filter(function(setter2) {
        return setter2.priority === priority;
      }).reverse();
    }).map(function(setterArray) {
      return setterArray[0];
    });
    var date = toDate$1(dirtyBackupDate);
    if (isNaN(date)) {
      return new Date(NaN);
    }
    var utcDate = subMilliseconds$1(date, getTimezoneOffsetInMilliseconds$1(date));
    var flags = {};
    for (i2 = 0; i2 < uniquePrioritySetters.length; i2++) {
      var setter = uniquePrioritySetters[i2];
      if (setter.validate && !setter.validate(utcDate, setter.value, subFnOptions)) {
        return new Date(NaN);
      }
      var result = setter.set(utcDate, flags, setter.value, subFnOptions);
      if (result[0]) {
        utcDate = result[0];
        assign$6(flags, result[1]);
      } else {
        utcDate = result;
      }
    }
    return utcDate;
  }
  function dateToSystemTimezone(date, flags) {
    if (flags.timestampIsSet) {
      return date;
    }
    var convertedDate = new Date(0);
    convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
    convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
    return convertedDate;
  }
  function cleanEscapedString$2(input) {
    return input.match(escapedStringRegExp$2)[1].replace(doubleQuoteRegExp$2, "'");
  }
  var MILLISECONDS_IN_HOUR$1 = 36e5;
  var MILLISECONDS_IN_MINUTE$1 = 6e4;
  var DEFAULT_ADDITIONAL_DIGITS = 2;
  var patterns$1 = {
    dateTimeDelimiter: /[T ]/,
    timeZoneDelimiter: /[Z ]/i,
    timezone: /([Z+-].*)$/
  };
  var dateRegex$1 = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
  var timeRegex$1 = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
  var timezoneRegex$1 = /^([+-])(\d{2})(?::?(\d{2}))?$/;
  function parseISO$1(argument, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var additionalDigits = options.additionalDigits == null ? DEFAULT_ADDITIONAL_DIGITS : toInteger$3(options.additionalDigits);
    if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
      throw new RangeError("additionalDigits must be 0, 1 or 2");
    }
    if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
      return new Date(NaN);
    }
    var dateStrings = splitDateString$1(argument);
    var date;
    if (dateStrings.date) {
      var parseYearResult = parseYear$1(dateStrings.date, additionalDigits);
      date = parseDate$1(parseYearResult.restDateString, parseYearResult.year);
    }
    if (isNaN(date) || !date) {
      return new Date(NaN);
    }
    var timestamp = date.getTime();
    var time = 0;
    var offset2;
    if (dateStrings.time) {
      time = parseTime$1(dateStrings.time);
      if (isNaN(time) || time === null) {
        return new Date(NaN);
      }
    }
    if (dateStrings.timezone) {
      offset2 = parseTimezone$1(dateStrings.timezone);
      if (isNaN(offset2)) {
        return new Date(NaN);
      }
    } else {
      var fullTime = timestamp + time;
      var fullTimeDate = new Date(fullTime);
      offset2 = getTimezoneOffsetInMilliseconds$1(fullTimeDate);
      var fullTimeDateDiffDay = new Date(fullTime);
      if (offset2 > 0) {
        fullTimeDateDiffDay.setDate(fullTimeDate.getDate() + 1);
      } else {
        fullTimeDateDiffDay.setDate(fullTimeDate.getDate() - 1);
      }
      var offsetDiff = getTimezoneOffsetInMilliseconds$1(fullTimeDateDiffDay) - offset2;
      if (offsetDiff > 0) {
        offset2 += offsetDiff;
      }
    }
    return new Date(timestamp + time + offset2);
  }
  function splitDateString$1(dateString) {
    var dateStrings = {};
    var array2 = dateString.split(patterns$1.dateTimeDelimiter);
    var timeString;
    if (/:/.test(array2[0])) {
      dateStrings.date = null;
      timeString = array2[0];
    } else {
      dateStrings.date = array2[0];
      timeString = array2[1];
      if (patterns$1.timeZoneDelimiter.test(dateStrings.date)) {
        dateStrings.date = dateString.split(patterns$1.timeZoneDelimiter)[0];
        timeString = dateString.substr(dateStrings.date.length, dateString.length);
      }
    }
    if (timeString) {
      var token = patterns$1.timezone.exec(timeString);
      if (token) {
        dateStrings.time = timeString.replace(token[1], "");
        dateStrings.timezone = token[1];
      } else {
        dateStrings.time = timeString;
      }
    }
    return dateStrings;
  }
  function parseYear$1(dateString, additionalDigits) {
    var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
    var captures = dateString.match(regex);
    if (!captures)
      return {
        year: null
      };
    var year = captures[1] && parseInt(captures[1]);
    var century = captures[2] && parseInt(captures[2]);
    return {
      year: century == null ? year : century * 100,
      restDateString: dateString.slice((captures[1] || captures[2]).length)
    };
  }
  function parseDate$1(dateString, year) {
    if (year === null)
      return null;
    var captures = dateString.match(dateRegex$1);
    if (!captures)
      return null;
    var isWeekDate = !!captures[4];
    var dayOfYear = parseDateUnit$1(captures[1]);
    var month = parseDateUnit$1(captures[2]) - 1;
    var day = parseDateUnit$1(captures[3]);
    var week = parseDateUnit$1(captures[4]);
    var dayOfWeek = parseDateUnit$1(captures[5]) - 1;
    if (isWeekDate) {
      if (!validateWeekDate$1(year, week, dayOfWeek)) {
        return new Date(NaN);
      }
      return dayOfISOWeekYear$1(year, week, dayOfWeek);
    } else {
      var date = new Date(0);
      if (!validateDate$1(year, month, day) || !validateDayOfYearDate$1(year, dayOfYear)) {
        return new Date(NaN);
      }
      date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
      return date;
    }
  }
  function parseDateUnit$1(value) {
    return value ? parseInt(value) : 1;
  }
  function parseTime$1(timeString) {
    var captures = timeString.match(timeRegex$1);
    if (!captures)
      return null;
    var hours = parseTimeUnit$1(captures[1]);
    var minutes = parseTimeUnit$1(captures[2]);
    var seconds = parseTimeUnit$1(captures[3]);
    if (!validateTime$1(hours, minutes, seconds)) {
      return NaN;
    }
    return hours * MILLISECONDS_IN_HOUR$1 + minutes * MILLISECONDS_IN_MINUTE$1 + seconds * 1e3;
  }
  function parseTimeUnit$1(value) {
    return value && parseFloat(value.replace(",", ".")) || 0;
  }
  function parseTimezone$1(timezoneString) {
    if (timezoneString === "Z")
      return 0;
    var captures = timezoneString.match(timezoneRegex$1);
    if (!captures)
      return 0;
    var sign2 = captures[1] === "+" ? -1 : 1;
    var hours = parseInt(captures[2]);
    var minutes = captures[3] && parseInt(captures[3]) || 0;
    if (!validateTimezone$1(hours, minutes)) {
      return NaN;
    }
    return sign2 * (hours * MILLISECONDS_IN_HOUR$1 + minutes * MILLISECONDS_IN_MINUTE$1);
  }
  function dayOfISOWeekYear$1(isoWeekYear, week, day) {
    var date = new Date(0);
    date.setUTCFullYear(isoWeekYear, 0, 4);
    var fourthOfJanuaryDay = date.getUTCDay() || 7;
    var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  var daysInMonths$1 = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  function isLeapYearIndex$2(year) {
    return year % 400 === 0 || year % 4 === 0 && year % 100;
  }
  function validateDate$1(year, month, date) {
    return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths$1[month] || (isLeapYearIndex$2(year) ? 29 : 28));
  }
  function validateDayOfYearDate$1(year, dayOfYear) {
    return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex$2(year) ? 366 : 365);
  }
  function validateWeekDate$1(_year, week, day) {
    return week >= 1 && week <= 53 && day >= 0 && day <= 6;
  }
  function validateTime$1(hours, minutes, seconds) {
    if (hours === 24) {
      return minutes === 0 && seconds === 0;
    }
    return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
  }
  function validateTimezone$1(_hours, minutes) {
    return minutes >= 0 && minutes <= 59;
  }
  var dateFormats$1 = {
    full: "EEEE, d MMMM yyyy",
    long: "d MMMM yyyy",
    medium: "d MMM yyyy",
    short: "dd/MM/yyyy"
  };
  var timeFormats$1 = {
    full: "HH:mm:ss zzzz",
    long: "HH:mm:ss z",
    medium: "HH:mm:ss",
    short: "HH:mm"
  };
  var dateTimeFormats$1 = {
    full: "{{date}} 'at' {{time}}",
    long: "{{date}} 'at' {{time}}",
    medium: "{{date}}, {{time}}",
    short: "{{date}}, {{time}}"
  };
  var formatLong$2 = {
    date: buildFormatLongFn$1({
      formats: dateFormats$1,
      defaultWidth: "full"
    }),
    time: buildFormatLongFn$1({
      formats: timeFormats$1,
      defaultWidth: "full"
    }),
    dateTime: buildFormatLongFn$1({
      formats: dateTimeFormats$1,
      defaultWidth: "full"
    })
  };
  const formatLong$3 = formatLong$2;
  var locale$1 = {
    code: "en-GB",
    formatDistance: formatDistance$2,
    formatLong: formatLong$3,
    formatRelative: formatRelative$2,
    localize: localize$3,
    match: match$4,
    options: {
      weekStartsOn: 1,
      firstWeekContainsDate: 4
    }
  };
  const enGB = locale$1;
  var lodash = { exports: {} };
  /**
   * @license
   * Lodash <https://lodash.com/>
   * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */
  (function(module2, exports3) {
    (function() {
      var undefined$12;
      var VERSION = "4.17.21";
      var LARGE_ARRAY_SIZE2 = 200;
      var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT2 = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
      var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
      var MAX_MEMOIZE_SIZE2 = 500;
      var PLACEHOLDER = "__lodash_placeholder__";
      var CLONE_DEEP_FLAG2 = 1, CLONE_FLAT_FLAG2 = 2, CLONE_SYMBOLS_FLAG2 = 4;
      var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
      var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
      var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
      var HOT_COUNT = 800, HOT_SPAN = 16;
      var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
      var INFINITY2 = 1 / 0, MAX_SAFE_INTEGER2 = 9007199254740991, MAX_INTEGER2 = 17976931348623157e292, NAN2 = 0 / 0;
      var MAX_ARRAY_LENGTH = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
      var wrapFlags = [
        ["ary", WRAP_ARY_FLAG],
        ["bind", WRAP_BIND_FLAG],
        ["bindKey", WRAP_BIND_KEY_FLAG],
        ["curry", WRAP_CURRY_FLAG],
        ["curryRight", WRAP_CURRY_RIGHT_FLAG],
        ["flip", WRAP_FLIP_FLAG],
        ["partial", WRAP_PARTIAL_FLAG],
        ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
        ["rearg", WRAP_REARG_FLAG]
      ];
      var argsTag2 = "[object Arguments]", arrayTag2 = "[object Array]", asyncTag2 = "[object AsyncFunction]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", domExcTag = "[object DOMException]", errorTag2 = "[object Error]", funcTag2 = "[object Function]", genTag2 = "[object GeneratorFunction]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", nullTag2 = "[object Null]", objectTag2 = "[object Object]", promiseTag2 = "[object Promise]", proxyTag2 = "[object Proxy]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", symbolTag2 = "[object Symbol]", undefinedTag2 = "[object Undefined]", weakMapTag2 = "[object WeakMap]", weakSetTag = "[object WeakSet]";
      var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
      var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
      var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
      var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
      var reIsDeepProp2 = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp2 = /^\w*$/, rePropName2 = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
      var reRegExpChar2 = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar2.source);
      var reTrimStart2 = /^\s+/;
      var reWhitespace2 = /\s/;
      var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
      var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
      var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
      var reEscapeChar2 = /\\(\\)?/g;
      var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
      var reFlags2 = /\w*$/;
      var reIsBadHex2 = /^[-+]0x[0-9a-f]+$/i;
      var reIsBinary2 = /^0b[01]+$/i;
      var reIsHostCtor2 = /^\[object .+?Constructor\]$/;
      var reIsOctal2 = /^0o[0-7]+$/i;
      var reIsUint2 = /^(?:0|[1-9]\d*)$/;
      var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
      var reNoMatch = /($^)/;
      var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
      var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
      var rsApos = "['\u2019]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
      var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
      var reApos = RegExp(rsApos, "g");
      var reComboMark = RegExp(rsCombo, "g");
      var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
      var reUnicodeWord = RegExp([
        rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
        rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
        rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
        rsUpper + "+" + rsOptContrUpper,
        rsOrdUpper,
        rsOrdLower,
        rsDigits,
        rsEmoji
      ].join("|"), "g");
      var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
      var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
      var contextProps = [
        "Array",
        "Buffer",
        "DataView",
        "Date",
        "Error",
        "Float32Array",
        "Float64Array",
        "Function",
        "Int8Array",
        "Int16Array",
        "Int32Array",
        "Map",
        "Math",
        "Object",
        "Promise",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "TypeError",
        "Uint8Array",
        "Uint8ClampedArray",
        "Uint16Array",
        "Uint32Array",
        "WeakMap",
        "_",
        "clearTimeout",
        "isFinite",
        "parseInt",
        "setTimeout"
      ];
      var templateCounter = -1;
      var typedArrayTags2 = {};
      typedArrayTags2[float32Tag2] = typedArrayTags2[float64Tag2] = typedArrayTags2[int8Tag2] = typedArrayTags2[int16Tag2] = typedArrayTags2[int32Tag2] = typedArrayTags2[uint8Tag2] = typedArrayTags2[uint8ClampedTag2] = typedArrayTags2[uint16Tag2] = typedArrayTags2[uint32Tag2] = true;
      typedArrayTags2[argsTag2] = typedArrayTags2[arrayTag2] = typedArrayTags2[arrayBufferTag2] = typedArrayTags2[boolTag2] = typedArrayTags2[dataViewTag2] = typedArrayTags2[dateTag2] = typedArrayTags2[errorTag2] = typedArrayTags2[funcTag2] = typedArrayTags2[mapTag2] = typedArrayTags2[numberTag2] = typedArrayTags2[objectTag2] = typedArrayTags2[regexpTag2] = typedArrayTags2[setTag2] = typedArrayTags2[stringTag2] = typedArrayTags2[weakMapTag2] = false;
      var cloneableTags2 = {};
      cloneableTags2[argsTag2] = cloneableTags2[arrayTag2] = cloneableTags2[arrayBufferTag2] = cloneableTags2[dataViewTag2] = cloneableTags2[boolTag2] = cloneableTags2[dateTag2] = cloneableTags2[float32Tag2] = cloneableTags2[float64Tag2] = cloneableTags2[int8Tag2] = cloneableTags2[int16Tag2] = cloneableTags2[int32Tag2] = cloneableTags2[mapTag2] = cloneableTags2[numberTag2] = cloneableTags2[objectTag2] = cloneableTags2[regexpTag2] = cloneableTags2[setTag2] = cloneableTags2[stringTag2] = cloneableTags2[symbolTag2] = cloneableTags2[uint8Tag2] = cloneableTags2[uint8ClampedTag2] = cloneableTags2[uint16Tag2] = cloneableTags2[uint32Tag2] = true;
      cloneableTags2[errorTag2] = cloneableTags2[funcTag2] = cloneableTags2[weakMapTag2] = false;
      var deburredLetters = {
        "\xC0": "A",
        "\xC1": "A",
        "\xC2": "A",
        "\xC3": "A",
        "\xC4": "A",
        "\xC5": "A",
        "\xE0": "a",
        "\xE1": "a",
        "\xE2": "a",
        "\xE3": "a",
        "\xE4": "a",
        "\xE5": "a",
        "\xC7": "C",
        "\xE7": "c",
        "\xD0": "D",
        "\xF0": "d",
        "\xC8": "E",
        "\xC9": "E",
        "\xCA": "E",
        "\xCB": "E",
        "\xE8": "e",
        "\xE9": "e",
        "\xEA": "e",
        "\xEB": "e",
        "\xCC": "I",
        "\xCD": "I",
        "\xCE": "I",
        "\xCF": "I",
        "\xEC": "i",
        "\xED": "i",
        "\xEE": "i",
        "\xEF": "i",
        "\xD1": "N",
        "\xF1": "n",
        "\xD2": "O",
        "\xD3": "O",
        "\xD4": "O",
        "\xD5": "O",
        "\xD6": "O",
        "\xD8": "O",
        "\xF2": "o",
        "\xF3": "o",
        "\xF4": "o",
        "\xF5": "o",
        "\xF6": "o",
        "\xF8": "o",
        "\xD9": "U",
        "\xDA": "U",
        "\xDB": "U",
        "\xDC": "U",
        "\xF9": "u",
        "\xFA": "u",
        "\xFB": "u",
        "\xFC": "u",
        "\xDD": "Y",
        "\xFD": "y",
        "\xFF": "y",
        "\xC6": "Ae",
        "\xE6": "ae",
        "\xDE": "Th",
        "\xFE": "th",
        "\xDF": "ss",
        "\u0100": "A",
        "\u0102": "A",
        "\u0104": "A",
        "\u0101": "a",
        "\u0103": "a",
        "\u0105": "a",
        "\u0106": "C",
        "\u0108": "C",
        "\u010A": "C",
        "\u010C": "C",
        "\u0107": "c",
        "\u0109": "c",
        "\u010B": "c",
        "\u010D": "c",
        "\u010E": "D",
        "\u0110": "D",
        "\u010F": "d",
        "\u0111": "d",
        "\u0112": "E",
        "\u0114": "E",
        "\u0116": "E",
        "\u0118": "E",
        "\u011A": "E",
        "\u0113": "e",
        "\u0115": "e",
        "\u0117": "e",
        "\u0119": "e",
        "\u011B": "e",
        "\u011C": "G",
        "\u011E": "G",
        "\u0120": "G",
        "\u0122": "G",
        "\u011D": "g",
        "\u011F": "g",
        "\u0121": "g",
        "\u0123": "g",
        "\u0124": "H",
        "\u0126": "H",
        "\u0125": "h",
        "\u0127": "h",
        "\u0128": "I",
        "\u012A": "I",
        "\u012C": "I",
        "\u012E": "I",
        "\u0130": "I",
        "\u0129": "i",
        "\u012B": "i",
        "\u012D": "i",
        "\u012F": "i",
        "\u0131": "i",
        "\u0134": "J",
        "\u0135": "j",
        "\u0136": "K",
        "\u0137": "k",
        "\u0138": "k",
        "\u0139": "L",
        "\u013B": "L",
        "\u013D": "L",
        "\u013F": "L",
        "\u0141": "L",
        "\u013A": "l",
        "\u013C": "l",
        "\u013E": "l",
        "\u0140": "l",
        "\u0142": "l",
        "\u0143": "N",
        "\u0145": "N",
        "\u0147": "N",
        "\u014A": "N",
        "\u0144": "n",
        "\u0146": "n",
        "\u0148": "n",
        "\u014B": "n",
        "\u014C": "O",
        "\u014E": "O",
        "\u0150": "O",
        "\u014D": "o",
        "\u014F": "o",
        "\u0151": "o",
        "\u0154": "R",
        "\u0156": "R",
        "\u0158": "R",
        "\u0155": "r",
        "\u0157": "r",
        "\u0159": "r",
        "\u015A": "S",
        "\u015C": "S",
        "\u015E": "S",
        "\u0160": "S",
        "\u015B": "s",
        "\u015D": "s",
        "\u015F": "s",
        "\u0161": "s",
        "\u0162": "T",
        "\u0164": "T",
        "\u0166": "T",
        "\u0163": "t",
        "\u0165": "t",
        "\u0167": "t",
        "\u0168": "U",
        "\u016A": "U",
        "\u016C": "U",
        "\u016E": "U",
        "\u0170": "U",
        "\u0172": "U",
        "\u0169": "u",
        "\u016B": "u",
        "\u016D": "u",
        "\u016F": "u",
        "\u0171": "u",
        "\u0173": "u",
        "\u0174": "W",
        "\u0175": "w",
        "\u0176": "Y",
        "\u0177": "y",
        "\u0178": "Y",
        "\u0179": "Z",
        "\u017B": "Z",
        "\u017D": "Z",
        "\u017A": "z",
        "\u017C": "z",
        "\u017E": "z",
        "\u0132": "IJ",
        "\u0133": "ij",
        "\u0152": "Oe",
        "\u0153": "oe",
        "\u0149": "'n",
        "\u017F": "s"
      };
      var htmlEscapes = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;"
      };
      var htmlUnescapes = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&quot;": '"',
        "&#39;": "'"
      };
      var stringEscapes = {
        "\\": "\\",
        "'": "'",
        "\n": "n",
        "\r": "r",
        "\u2028": "u2028",
        "\u2029": "u2029"
      };
      var freeParseFloat = parseFloat, freeParseInt2 = parseInt;
      var freeGlobal2 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
      var freeSelf2 = typeof self == "object" && self && self.Object === Object && self;
      var root2 = freeGlobal2 || freeSelf2 || Function("return this")();
      var freeExports = exports3 && !exports3.nodeType && exports3;
      var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
      var moduleExports = freeModule && freeModule.exports === freeExports;
      var freeProcess = moduleExports && freeGlobal2.process;
      var nodeUtil2 = function() {
        try {
          var types2 = freeModule && freeModule.require && freeModule.require("util").types;
          if (types2) {
            return types2;
          }
          return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e3) {
        }
      }();
      var nodeIsArrayBuffer = nodeUtil2 && nodeUtil2.isArrayBuffer, nodeIsDate = nodeUtil2 && nodeUtil2.isDate, nodeIsMap2 = nodeUtil2 && nodeUtil2.isMap, nodeIsRegExp = nodeUtil2 && nodeUtil2.isRegExp, nodeIsSet2 = nodeUtil2 && nodeUtil2.isSet, nodeIsTypedArray2 = nodeUtil2 && nodeUtil2.isTypedArray;
      function apply(func, thisArg, args) {
        switch (args.length) {
          case 0:
            return func.call(thisArg);
          case 1:
            return func.call(thisArg, args[0]);
          case 2:
            return func.call(thisArg, args[0], args[1]);
          case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
        }
        return func.apply(thisArg, args);
      }
      function arrayAggregator(array2, setter, iteratee, accumulator) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        while (++index2 < length2) {
          var value = array2[index2];
          setter(accumulator, value, iteratee(value), array2);
        }
        return accumulator;
      }
      function arrayEach2(array2, iteratee) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        while (++index2 < length2) {
          if (iteratee(array2[index2], index2, array2) === false) {
            break;
          }
        }
        return array2;
      }
      function arrayEachRight(array2, iteratee) {
        var length2 = array2 == null ? 0 : array2.length;
        while (length2--) {
          if (iteratee(array2[length2], length2, array2) === false) {
            break;
          }
        }
        return array2;
      }
      function arrayEvery(array2, predicate) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        while (++index2 < length2) {
          if (!predicate(array2[index2], index2, array2)) {
            return false;
          }
        }
        return true;
      }
      function arrayFilter2(array2, predicate) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
        while (++index2 < length2) {
          var value = array2[index2];
          if (predicate(value, index2, array2)) {
            result[resIndex++] = value;
          }
        }
        return result;
      }
      function arrayIncludes(array2, value) {
        var length2 = array2 == null ? 0 : array2.length;
        return !!length2 && baseIndexOf(array2, value, 0) > -1;
      }
      function arrayIncludesWith(array2, value, comparator) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        while (++index2 < length2) {
          if (comparator(value, array2[index2])) {
            return true;
          }
        }
        return false;
      }
      function arrayMap2(array2, iteratee) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length, result = Array(length2);
        while (++index2 < length2) {
          result[index2] = iteratee(array2[index2], index2, array2);
        }
        return result;
      }
      function arrayPush2(array2, values) {
        var index2 = -1, length2 = values.length, offset2 = array2.length;
        while (++index2 < length2) {
          array2[offset2 + index2] = values[index2];
        }
        return array2;
      }
      function arrayReduce(array2, iteratee, accumulator, initAccum) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        if (initAccum && length2) {
          accumulator = array2[++index2];
        }
        while (++index2 < length2) {
          accumulator = iteratee(accumulator, array2[index2], index2, array2);
        }
        return accumulator;
      }
      function arrayReduceRight(array2, iteratee, accumulator, initAccum) {
        var length2 = array2 == null ? 0 : array2.length;
        if (initAccum && length2) {
          accumulator = array2[--length2];
        }
        while (length2--) {
          accumulator = iteratee(accumulator, array2[length2], length2, array2);
        }
        return accumulator;
      }
      function arraySome2(array2, predicate) {
        var index2 = -1, length2 = array2 == null ? 0 : array2.length;
        while (++index2 < length2) {
          if (predicate(array2[index2], index2, array2)) {
            return true;
          }
        }
        return false;
      }
      var asciiSize = baseProperty("length");
      function asciiToArray(string2) {
        return string2.split("");
      }
      function asciiWords(string2) {
        return string2.match(reAsciiWord) || [];
      }
      function baseFindKey(collection2, predicate, eachFunc) {
        var result;
        eachFunc(collection2, function(value, key, collection3) {
          if (predicate(value, key, collection3)) {
            result = key;
            return false;
          }
        });
        return result;
      }
      function baseFindIndex(array2, predicate, fromIndex, fromRight) {
        var length2 = array2.length, index2 = fromIndex + (fromRight ? 1 : -1);
        while (fromRight ? index2-- : ++index2 < length2) {
          if (predicate(array2[index2], index2, array2)) {
            return index2;
          }
        }
        return -1;
      }
      function baseIndexOf(array2, value, fromIndex) {
        return value === value ? strictIndexOf(array2, value, fromIndex) : baseFindIndex(array2, baseIsNaN, fromIndex);
      }
      function baseIndexOfWith(array2, value, fromIndex, comparator) {
        var index2 = fromIndex - 1, length2 = array2.length;
        while (++index2 < length2) {
          if (comparator(array2[index2], value)) {
            return index2;
          }
        }
        return -1;
      }
      function baseIsNaN(value) {
        return value !== value;
      }
      function baseMean(array2, iteratee) {
        var length2 = array2 == null ? 0 : array2.length;
        return length2 ? baseSum(array2, iteratee) / length2 : NAN2;
      }
      function baseProperty(key) {
        return function(object2) {
          return object2 == null ? undefined$12 : object2[key];
        };
      }
      function basePropertyOf(object2) {
        return function(key) {
          return object2 == null ? undefined$12 : object2[key];
        };
      }
      function baseReduce(collection2, iteratee, accumulator, initAccum, eachFunc) {
        eachFunc(collection2, function(value, index2, collection3) {
          accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index2, collection3);
        });
        return accumulator;
      }
      function baseSortBy(array2, comparer) {
        var length2 = array2.length;
        array2.sort(comparer);
        while (length2--) {
          array2[length2] = array2[length2].value;
        }
        return array2;
      }
      function baseSum(array2, iteratee) {
        var result, index2 = -1, length2 = array2.length;
        while (++index2 < length2) {
          var current = iteratee(array2[index2]);
          if (current !== undefined$12) {
            result = result === undefined$12 ? current : result + current;
          }
        }
        return result;
      }
      function baseTimes2(n2, iteratee) {
        var index2 = -1, result = Array(n2);
        while (++index2 < n2) {
          result[index2] = iteratee(index2);
        }
        return result;
      }
      function baseToPairs(object2, props) {
        return arrayMap2(props, function(key) {
          return [key, object2[key]];
        });
      }
      function baseTrim2(string2) {
        return string2 ? string2.slice(0, trimmedEndIndex2(string2) + 1).replace(reTrimStart2, "") : string2;
      }
      function baseUnary2(func) {
        return function(value) {
          return func(value);
        };
      }
      function baseValues(object2, props) {
        return arrayMap2(props, function(key) {
          return object2[key];
        });
      }
      function cacheHas2(cache2, key) {
        return cache2.has(key);
      }
      function charsStartIndex(strSymbols, chrSymbols) {
        var index2 = -1, length2 = strSymbols.length;
        while (++index2 < length2 && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
        }
        return index2;
      }
      function charsEndIndex(strSymbols, chrSymbols) {
        var index2 = strSymbols.length;
        while (index2-- && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
        }
        return index2;
      }
      function countHolders(array2, placeholder) {
        var length2 = array2.length, result = 0;
        while (length2--) {
          if (array2[length2] === placeholder) {
            ++result;
          }
        }
        return result;
      }
      var deburrLetter = basePropertyOf(deburredLetters);
      var escapeHtmlChar = basePropertyOf(htmlEscapes);
      function escapeStringChar(chr) {
        return "\\" + stringEscapes[chr];
      }
      function getValue2(object2, key) {
        return object2 == null ? undefined$12 : object2[key];
      }
      function hasUnicode(string2) {
        return reHasUnicode.test(string2);
      }
      function hasUnicodeWord(string2) {
        return reHasUnicodeWord.test(string2);
      }
      function iteratorToArray(iterator2) {
        var data2, result = [];
        while (!(data2 = iterator2.next()).done) {
          result.push(data2.value);
        }
        return result;
      }
      function mapToArray2(map2) {
        var index2 = -1, result = Array(map2.size);
        map2.forEach(function(value, key) {
          result[++index2] = [key, value];
        });
        return result;
      }
      function overArg2(func, transform) {
        return function(arg) {
          return func(transform(arg));
        };
      }
      function replaceHolders(array2, placeholder) {
        var index2 = -1, length2 = array2.length, resIndex = 0, result = [];
        while (++index2 < length2) {
          var value = array2[index2];
          if (value === placeholder || value === PLACEHOLDER) {
            array2[index2] = PLACEHOLDER;
            result[resIndex++] = index2;
          }
        }
        return result;
      }
      function setToArray2(set2) {
        var index2 = -1, result = Array(set2.size);
        set2.forEach(function(value) {
          result[++index2] = value;
        });
        return result;
      }
      function setToPairs(set2) {
        var index2 = -1, result = Array(set2.size);
        set2.forEach(function(value) {
          result[++index2] = [value, value];
        });
        return result;
      }
      function strictIndexOf(array2, value, fromIndex) {
        var index2 = fromIndex - 1, length2 = array2.length;
        while (++index2 < length2) {
          if (array2[index2] === value) {
            return index2;
          }
        }
        return -1;
      }
      function strictLastIndexOf(array2, value, fromIndex) {
        var index2 = fromIndex + 1;
        while (index2--) {
          if (array2[index2] === value) {
            return index2;
          }
        }
        return index2;
      }
      function stringSize(string2) {
        return hasUnicode(string2) ? unicodeSize(string2) : asciiSize(string2);
      }
      function stringToArray(string2) {
        return hasUnicode(string2) ? unicodeToArray(string2) : asciiToArray(string2);
      }
      function trimmedEndIndex2(string2) {
        var index2 = string2.length;
        while (index2-- && reWhitespace2.test(string2.charAt(index2))) {
        }
        return index2;
      }
      var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
      function unicodeSize(string2) {
        var result = reUnicode.lastIndex = 0;
        while (reUnicode.test(string2)) {
          ++result;
        }
        return result;
      }
      function unicodeToArray(string2) {
        return string2.match(reUnicode) || [];
      }
      function unicodeWords(string2) {
        return string2.match(reUnicodeWord) || [];
      }
      var runInContext = function runInContext2(context2) {
        context2 = context2 == null ? root2 : _2.defaults(root2.Object(), context2, _2.pick(root2, contextProps));
        var Array2 = context2.Array, Date2 = context2.Date, Error2 = context2.Error, Function2 = context2.Function, Math2 = context2.Math, Object2 = context2.Object, RegExp2 = context2.RegExp, String2 = context2.String, TypeError2 = context2.TypeError;
        var arrayProto2 = Array2.prototype, funcProto2 = Function2.prototype, objectProto2 = Object2.prototype;
        var coreJsData2 = context2["__core-js_shared__"];
        var funcToString2 = funcProto2.toString;
        var hasOwnProperty2 = objectProto2.hasOwnProperty;
        var idCounter2 = 0;
        var maskSrcKey2 = function() {
          var uid2 = /[^.]+$/.exec(coreJsData2 && coreJsData2.keys && coreJsData2.keys.IE_PROTO || "");
          return uid2 ? "Symbol(src)_1." + uid2 : "";
        }();
        var nativeObjectToString2 = objectProto2.toString;
        var objectCtorString = funcToString2.call(Object2);
        var oldDash = root2._;
        var reIsNative2 = RegExp2(
          "^" + funcToString2.call(hasOwnProperty2).replace(reRegExpChar2, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
        );
        var Buffer2 = moduleExports ? context2.Buffer : undefined$12, Symbol2 = context2.Symbol, Uint8Array2 = context2.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined$12, getPrototype2 = overArg2(Object2.getPrototypeOf, Object2), objectCreate2 = Object2.create, propertyIsEnumerable2 = objectProto2.propertyIsEnumerable, splice2 = arrayProto2.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined$12, symIterator = Symbol2 ? Symbol2.iterator : undefined$12, symToStringTag2 = Symbol2 ? Symbol2.toStringTag : undefined$12;
        var defineProperty2 = function() {
          try {
            var func = getNative2(Object2, "defineProperty");
            func({}, "", {});
            return func;
          } catch (e3) {
          }
        }();
        var ctxClearTimeout = context2.clearTimeout !== root2.clearTimeout && context2.clearTimeout, ctxNow = Date2 && Date2.now !== root2.Date.now && Date2.now, ctxSetTimeout = context2.setTimeout !== root2.setTimeout && context2.setTimeout;
        var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols2 = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined$12, nativeIsFinite2 = context2.isFinite, nativeJoin = arrayProto2.join, nativeKeys2 = overArg2(Object2.keys, Object2), nativeMax2 = Math2.max, nativeMin2 = Math2.min, nativeNow = Date2.now, nativeParseInt = context2.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto2.reverse;
        var DataView2 = getNative2(context2, "DataView"), Map2 = getNative2(context2, "Map"), Promise2 = getNative2(context2, "Promise"), Set2 = getNative2(context2, "Set"), WeakMap2 = getNative2(context2, "WeakMap"), nativeCreate2 = getNative2(Object2, "create");
        var metaMap = WeakMap2 && new WeakMap2();
        var realNames = {};
        var dataViewCtorString2 = toSource2(DataView2), mapCtorString2 = toSource2(Map2), promiseCtorString2 = toSource2(Promise2), setCtorString2 = toSource2(Set2), weakMapCtorString2 = toSource2(WeakMap2);
        var symbolProto2 = Symbol2 ? Symbol2.prototype : undefined$12, symbolValueOf2 = symbolProto2 ? symbolProto2.valueOf : undefined$12, symbolToString2 = symbolProto2 ? symbolProto2.toString : undefined$12;
        function lodash2(value) {
          if (isObjectLike2(value) && !isArray2(value) && !(value instanceof LazyWrapper)) {
            if (value instanceof LodashWrapper) {
              return value;
            }
            if (hasOwnProperty2.call(value, "__wrapped__")) {
              return wrapperClone(value);
            }
          }
          return new LodashWrapper(value);
        }
        var baseCreate2 = function() {
          function object2() {
          }
          return function(proto2) {
            if (!isObject2(proto2)) {
              return {};
            }
            if (objectCreate2) {
              return objectCreate2(proto2);
            }
            object2.prototype = proto2;
            var result2 = new object2();
            object2.prototype = undefined$12;
            return result2;
          };
        }();
        function baseLodash() {
        }
        function LodashWrapper(value, chainAll) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__chain__ = !!chainAll;
          this.__index__ = 0;
          this.__values__ = undefined$12;
        }
        lodash2.templateSettings = {
          "escape": reEscape,
          "evaluate": reEvaluate,
          "interpolate": reInterpolate,
          "variable": "",
          "imports": {
            "_": lodash2
          }
        };
        lodash2.prototype = baseLodash.prototype;
        lodash2.prototype.constructor = lodash2;
        LodashWrapper.prototype = baseCreate2(baseLodash.prototype);
        LodashWrapper.prototype.constructor = LodashWrapper;
        function LazyWrapper(value) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__dir__ = 1;
          this.__filtered__ = false;
          this.__iteratees__ = [];
          this.__takeCount__ = MAX_ARRAY_LENGTH;
          this.__views__ = [];
        }
        function lazyClone() {
          var result2 = new LazyWrapper(this.__wrapped__);
          result2.__actions__ = copyArray2(this.__actions__);
          result2.__dir__ = this.__dir__;
          result2.__filtered__ = this.__filtered__;
          result2.__iteratees__ = copyArray2(this.__iteratees__);
          result2.__takeCount__ = this.__takeCount__;
          result2.__views__ = copyArray2(this.__views__);
          return result2;
        }
        function lazyReverse() {
          if (this.__filtered__) {
            var result2 = new LazyWrapper(this);
            result2.__dir__ = -1;
            result2.__filtered__ = true;
          } else {
            result2 = this.clone();
            result2.__dir__ *= -1;
          }
          return result2;
        }
        function lazyValue() {
          var array2 = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray2(array2), isRight = dir < 0, arrLength = isArr ? array2.length : 0, view = getView(0, arrLength, this.__views__), start2 = view.start, end2 = view.end, length2 = end2 - start2, index2 = isRight ? end2 : start2 - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin2(length2, this.__takeCount__);
          if (!isArr || !isRight && arrLength == length2 && takeCount == length2) {
            return baseWrapperValue(array2, this.__actions__);
          }
          var result2 = [];
          outer:
            while (length2-- && resIndex < takeCount) {
              index2 += dir;
              var iterIndex = -1, value = array2[index2];
              while (++iterIndex < iterLength) {
                var data2 = iteratees[iterIndex], iteratee2 = data2.iteratee, type = data2.type, computed = iteratee2(value);
                if (type == LAZY_MAP_FLAG) {
                  value = computed;
                } else if (!computed) {
                  if (type == LAZY_FILTER_FLAG) {
                    continue outer;
                  } else {
                    break outer;
                  }
                }
              }
              result2[resIndex++] = value;
            }
          return result2;
        }
        LazyWrapper.prototype = baseCreate2(baseLodash.prototype);
        LazyWrapper.prototype.constructor = LazyWrapper;
        function Hash2(entries) {
          var index2 = -1, length2 = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length2) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function hashClear2() {
          this.__data__ = nativeCreate2 ? nativeCreate2(null) : {};
          this.size = 0;
        }
        function hashDelete2(key) {
          var result2 = this.has(key) && delete this.__data__[key];
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function hashGet2(key) {
          var data2 = this.__data__;
          if (nativeCreate2) {
            var result2 = data2[key];
            return result2 === HASH_UNDEFINED2 ? undefined$12 : result2;
          }
          return hasOwnProperty2.call(data2, key) ? data2[key] : undefined$12;
        }
        function hashHas2(key) {
          var data2 = this.__data__;
          return nativeCreate2 ? data2[key] !== undefined$12 : hasOwnProperty2.call(data2, key);
        }
        function hashSet2(key, value) {
          var data2 = this.__data__;
          this.size += this.has(key) ? 0 : 1;
          data2[key] = nativeCreate2 && value === undefined$12 ? HASH_UNDEFINED2 : value;
          return this;
        }
        Hash2.prototype.clear = hashClear2;
        Hash2.prototype["delete"] = hashDelete2;
        Hash2.prototype.get = hashGet2;
        Hash2.prototype.has = hashHas2;
        Hash2.prototype.set = hashSet2;
        function ListCache2(entries) {
          var index2 = -1, length2 = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length2) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function listCacheClear2() {
          this.__data__ = [];
          this.size = 0;
        }
        function listCacheDelete2(key) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          if (index2 < 0) {
            return false;
          }
          var lastIndex = data2.length - 1;
          if (index2 == lastIndex) {
            data2.pop();
          } else {
            splice2.call(data2, index2, 1);
          }
          --this.size;
          return true;
        }
        function listCacheGet2(key) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          return index2 < 0 ? undefined$12 : data2[index2][1];
        }
        function listCacheHas2(key) {
          return assocIndexOf2(this.__data__, key) > -1;
        }
        function listCacheSet2(key, value) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          if (index2 < 0) {
            ++this.size;
            data2.push([key, value]);
          } else {
            data2[index2][1] = value;
          }
          return this;
        }
        ListCache2.prototype.clear = listCacheClear2;
        ListCache2.prototype["delete"] = listCacheDelete2;
        ListCache2.prototype.get = listCacheGet2;
        ListCache2.prototype.has = listCacheHas2;
        ListCache2.prototype.set = listCacheSet2;
        function MapCache2(entries) {
          var index2 = -1, length2 = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length2) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function mapCacheClear2() {
          this.size = 0;
          this.__data__ = {
            "hash": new Hash2(),
            "map": new (Map2 || ListCache2)(),
            "string": new Hash2()
          };
        }
        function mapCacheDelete2(key) {
          var result2 = getMapData2(this, key)["delete"](key);
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function mapCacheGet2(key) {
          return getMapData2(this, key).get(key);
        }
        function mapCacheHas2(key) {
          return getMapData2(this, key).has(key);
        }
        function mapCacheSet2(key, value) {
          var data2 = getMapData2(this, key), size2 = data2.size;
          data2.set(key, value);
          this.size += data2.size == size2 ? 0 : 1;
          return this;
        }
        MapCache2.prototype.clear = mapCacheClear2;
        MapCache2.prototype["delete"] = mapCacheDelete2;
        MapCache2.prototype.get = mapCacheGet2;
        MapCache2.prototype.has = mapCacheHas2;
        MapCache2.prototype.set = mapCacheSet2;
        function SetCache2(values2) {
          var index2 = -1, length2 = values2 == null ? 0 : values2.length;
          this.__data__ = new MapCache2();
          while (++index2 < length2) {
            this.add(values2[index2]);
          }
        }
        function setCacheAdd2(value) {
          this.__data__.set(value, HASH_UNDEFINED2);
          return this;
        }
        function setCacheHas2(value) {
          return this.__data__.has(value);
        }
        SetCache2.prototype.add = SetCache2.prototype.push = setCacheAdd2;
        SetCache2.prototype.has = setCacheHas2;
        function Stack2(entries) {
          var data2 = this.__data__ = new ListCache2(entries);
          this.size = data2.size;
        }
        function stackClear2() {
          this.__data__ = new ListCache2();
          this.size = 0;
        }
        function stackDelete2(key) {
          var data2 = this.__data__, result2 = data2["delete"](key);
          this.size = data2.size;
          return result2;
        }
        function stackGet2(key) {
          return this.__data__.get(key);
        }
        function stackHas2(key) {
          return this.__data__.has(key);
        }
        function stackSet2(key, value) {
          var data2 = this.__data__;
          if (data2 instanceof ListCache2) {
            var pairs2 = data2.__data__;
            if (!Map2 || pairs2.length < LARGE_ARRAY_SIZE2 - 1) {
              pairs2.push([key, value]);
              this.size = ++data2.size;
              return this;
            }
            data2 = this.__data__ = new MapCache2(pairs2);
          }
          data2.set(key, value);
          this.size = data2.size;
          return this;
        }
        Stack2.prototype.clear = stackClear2;
        Stack2.prototype["delete"] = stackDelete2;
        Stack2.prototype.get = stackGet2;
        Stack2.prototype.has = stackHas2;
        Stack2.prototype.set = stackSet2;
        function arrayLikeKeys2(value, inherited) {
          var isArr = isArray2(value), isArg = !isArr && isArguments2(value), isBuff = !isArr && !isArg && isBuffer2(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray2(value), skipIndexes = isArr || isArg || isBuff || isType2, result2 = skipIndexes ? baseTimes2(value.length, String2) : [], length2 = result2.length;
          for (var key in value) {
            if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex2(key, length2)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function arraySample(array2) {
          var length2 = array2.length;
          return length2 ? array2[baseRandom(0, length2 - 1)] : undefined$12;
        }
        function arraySampleSize(array2, n2) {
          return shuffleSelf(copyArray2(array2), baseClamp(n2, 0, array2.length));
        }
        function arrayShuffle(array2) {
          return shuffleSelf(copyArray2(array2));
        }
        function assignMergeValue(object2, key, value) {
          if (value !== undefined$12 && !eq2(object2[key], value) || value === undefined$12 && !(key in object2)) {
            baseAssignValue2(object2, key, value);
          }
        }
        function assignValue2(object2, key, value) {
          var objValue = object2[key];
          if (!(hasOwnProperty2.call(object2, key) && eq2(objValue, value)) || value === undefined$12 && !(key in object2)) {
            baseAssignValue2(object2, key, value);
          }
        }
        function assocIndexOf2(array2, key) {
          var length2 = array2.length;
          while (length2--) {
            if (eq2(array2[length2][0], key)) {
              return length2;
            }
          }
          return -1;
        }
        function baseAggregator(collection2, setter, iteratee2, accumulator) {
          baseEach(collection2, function(value, key, collection3) {
            setter(accumulator, value, iteratee2(value), collection3);
          });
          return accumulator;
        }
        function baseAssign2(object2, source) {
          return object2 && copyObject2(source, keys2(source), object2);
        }
        function baseAssignIn2(object2, source) {
          return object2 && copyObject2(source, keysIn2(source), object2);
        }
        function baseAssignValue2(object2, key, value) {
          if (key == "__proto__" && defineProperty2) {
            defineProperty2(object2, key, {
              "configurable": true,
              "enumerable": true,
              "value": value,
              "writable": true
            });
          } else {
            object2[key] = value;
          }
        }
        function baseAt(object2, paths) {
          var index2 = -1, length2 = paths.length, result2 = Array2(length2), skip = object2 == null;
          while (++index2 < length2) {
            result2[index2] = skip ? undefined$12 : get2(object2, paths[index2]);
          }
          return result2;
        }
        function baseClamp(number2, lower2, upper) {
          if (number2 === number2) {
            if (upper !== undefined$12) {
              number2 = number2 <= upper ? number2 : upper;
            }
            if (lower2 !== undefined$12) {
              number2 = number2 >= lower2 ? number2 : lower2;
            }
          }
          return number2;
        }
        function baseClone2(value, bitmask, customizer, key, object2, stack) {
          var result2, isDeep = bitmask & CLONE_DEEP_FLAG2, isFlat = bitmask & CLONE_FLAT_FLAG2, isFull = bitmask & CLONE_SYMBOLS_FLAG2;
          if (customizer) {
            result2 = object2 ? customizer(value, key, object2, stack) : customizer(value);
          }
          if (result2 !== undefined$12) {
            return result2;
          }
          if (!isObject2(value)) {
            return value;
          }
          var isArr = isArray2(value);
          if (isArr) {
            result2 = initCloneArray2(value);
            if (!isDeep) {
              return copyArray2(value, result2);
            }
          } else {
            var tag = getTag2(value), isFunc = tag == funcTag2 || tag == genTag2;
            if (isBuffer2(value)) {
              return cloneBuffer2(value, isDeep);
            }
            if (tag == objectTag2 || tag == argsTag2 || isFunc && !object2) {
              result2 = isFlat || isFunc ? {} : initCloneObject2(value);
              if (!isDeep) {
                return isFlat ? copySymbolsIn2(value, baseAssignIn2(result2, value)) : copySymbols2(value, baseAssign2(result2, value));
              }
            } else {
              if (!cloneableTags2[tag]) {
                return object2 ? value : {};
              }
              result2 = initCloneByTag2(value, tag, isDeep);
            }
          }
          stack || (stack = new Stack2());
          var stacked = stack.get(value);
          if (stacked) {
            return stacked;
          }
          stack.set(value, result2);
          if (isSet2(value)) {
            value.forEach(function(subValue) {
              result2.add(baseClone2(subValue, bitmask, customizer, subValue, value, stack));
            });
          } else if (isMap2(value)) {
            value.forEach(function(subValue, key2) {
              result2.set(key2, baseClone2(subValue, bitmask, customizer, key2, value, stack));
            });
          }
          var keysFunc = isFull ? isFlat ? getAllKeysIn2 : getAllKeys2 : isFlat ? keysIn2 : keys2;
          var props = isArr ? undefined$12 : keysFunc(value);
          arrayEach2(props || value, function(subValue, key2) {
            if (props) {
              key2 = subValue;
              subValue = value[key2];
            }
            assignValue2(result2, key2, baseClone2(subValue, bitmask, customizer, key2, value, stack));
          });
          return result2;
        }
        function baseConforms(source) {
          var props = keys2(source);
          return function(object2) {
            return baseConformsTo(object2, source, props);
          };
        }
        function baseConformsTo(object2, source, props) {
          var length2 = props.length;
          if (object2 == null) {
            return !length2;
          }
          object2 = Object2(object2);
          while (length2--) {
            var key = props[length2], predicate = source[key], value = object2[key];
            if (value === undefined$12 && !(key in object2) || !predicate(value)) {
              return false;
            }
          }
          return true;
        }
        function baseDelay(func, wait, args) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          return setTimeout2(function() {
            func.apply(undefined$12, args);
          }, wait);
        }
        function baseDifference(array2, values2, iteratee2, comparator) {
          var index2 = -1, includes2 = arrayIncludes, isCommon = true, length2 = array2.length, result2 = [], valuesLength = values2.length;
          if (!length2) {
            return result2;
          }
          if (iteratee2) {
            values2 = arrayMap2(values2, baseUnary2(iteratee2));
          }
          if (comparator) {
            includes2 = arrayIncludesWith;
            isCommon = false;
          } else if (values2.length >= LARGE_ARRAY_SIZE2) {
            includes2 = cacheHas2;
            isCommon = false;
            values2 = new SetCache2(values2);
          }
          outer:
            while (++index2 < length2) {
              var value = array2[index2], computed = iteratee2 == null ? value : iteratee2(value);
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                  if (values2[valuesIndex] === computed) {
                    continue outer;
                  }
                }
                result2.push(value);
              } else if (!includes2(values2, computed, comparator)) {
                result2.push(value);
              }
            }
          return result2;
        }
        var baseEach = createBaseEach(baseForOwn);
        var baseEachRight = createBaseEach(baseForOwnRight, true);
        function baseEvery(collection2, predicate) {
          var result2 = true;
          baseEach(collection2, function(value, index2, collection3) {
            result2 = !!predicate(value, index2, collection3);
            return result2;
          });
          return result2;
        }
        function baseExtremum(array2, iteratee2, comparator) {
          var index2 = -1, length2 = array2.length;
          while (++index2 < length2) {
            var value = array2[index2], current = iteratee2(value);
            if (current != null && (computed === undefined$12 ? current === current && !isSymbol2(current) : comparator(current, computed))) {
              var computed = current, result2 = value;
            }
          }
          return result2;
        }
        function baseFill(array2, value, start2, end2) {
          var length2 = array2.length;
          start2 = toInteger2(start2);
          if (start2 < 0) {
            start2 = -start2 > length2 ? 0 : length2 + start2;
          }
          end2 = end2 === undefined$12 || end2 > length2 ? length2 : toInteger2(end2);
          if (end2 < 0) {
            end2 += length2;
          }
          end2 = start2 > end2 ? 0 : toLength(end2);
          while (start2 < end2) {
            array2[start2++] = value;
          }
          return array2;
        }
        function baseFilter(collection2, predicate) {
          var result2 = [];
          baseEach(collection2, function(value, index2, collection3) {
            if (predicate(value, index2, collection3)) {
              result2.push(value);
            }
          });
          return result2;
        }
        function baseFlatten(array2, depth, predicate, isStrict, result2) {
          var index2 = -1, length2 = array2.length;
          predicate || (predicate = isFlattenable);
          result2 || (result2 = []);
          while (++index2 < length2) {
            var value = array2[index2];
            if (depth > 0 && predicate(value)) {
              if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result2);
              } else {
                arrayPush2(result2, value);
              }
            } else if (!isStrict) {
              result2[result2.length] = value;
            }
          }
          return result2;
        }
        var baseFor = createBaseFor();
        var baseForRight = createBaseFor(true);
        function baseForOwn(object2, iteratee2) {
          return object2 && baseFor(object2, iteratee2, keys2);
        }
        function baseForOwnRight(object2, iteratee2) {
          return object2 && baseForRight(object2, iteratee2, keys2);
        }
        function baseFunctions(object2, props) {
          return arrayFilter2(props, function(key) {
            return isFunction2(object2[key]);
          });
        }
        function baseGet2(object2, path2) {
          path2 = castPath2(path2, object2);
          var index2 = 0, length2 = path2.length;
          while (object2 != null && index2 < length2) {
            object2 = object2[toKey2(path2[index2++])];
          }
          return index2 && index2 == length2 ? object2 : undefined$12;
        }
        function baseGetAllKeys2(object2, keysFunc, symbolsFunc) {
          var result2 = keysFunc(object2);
          return isArray2(object2) ? result2 : arrayPush2(result2, symbolsFunc(object2));
        }
        function baseGetTag2(value) {
          if (value == null) {
            return value === undefined$12 ? undefinedTag2 : nullTag2;
          }
          return symToStringTag2 && symToStringTag2 in Object2(value) ? getRawTag2(value) : objectToString2(value);
        }
        function baseGt(value, other) {
          return value > other;
        }
        function baseHas(object2, key) {
          return object2 != null && hasOwnProperty2.call(object2, key);
        }
        function baseHasIn(object2, key) {
          return object2 != null && key in Object2(object2);
        }
        function baseInRange(number2, start2, end2) {
          return number2 >= nativeMin2(start2, end2) && number2 < nativeMax2(start2, end2);
        }
        function baseIntersection(arrays, iteratee2, comparator) {
          var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length2 = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
          while (othIndex--) {
            var array2 = arrays[othIndex];
            if (othIndex && iteratee2) {
              array2 = arrayMap2(array2, baseUnary2(iteratee2));
            }
            maxLength = nativeMin2(array2.length, maxLength);
            caches[othIndex] = !comparator && (iteratee2 || length2 >= 120 && array2.length >= 120) ? new SetCache2(othIndex && array2) : undefined$12;
          }
          array2 = arrays[0];
          var index2 = -1, seen = caches[0];
          outer:
            while (++index2 < length2 && result2.length < maxLength) {
              var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (!(seen ? cacheHas2(seen, computed) : includes2(result2, computed, comparator))) {
                othIndex = othLength;
                while (--othIndex) {
                  var cache2 = caches[othIndex];
                  if (!(cache2 ? cacheHas2(cache2, computed) : includes2(arrays[othIndex], computed, comparator))) {
                    continue outer;
                  }
                }
                if (seen) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseInverter(object2, setter, iteratee2, accumulator) {
          baseForOwn(object2, function(value, key, object3) {
            setter(accumulator, iteratee2(value), key, object3);
          });
          return accumulator;
        }
        function baseInvoke(object2, path2, args) {
          path2 = castPath2(path2, object2);
          object2 = parent(object2, path2);
          var func = object2 == null ? object2 : object2[toKey2(last(path2))];
          return func == null ? undefined$12 : apply(func, object2, args);
        }
        function baseIsArguments2(value) {
          return isObjectLike2(value) && baseGetTag2(value) == argsTag2;
        }
        function baseIsArrayBuffer(value) {
          return isObjectLike2(value) && baseGetTag2(value) == arrayBufferTag2;
        }
        function baseIsDate(value) {
          return isObjectLike2(value) && baseGetTag2(value) == dateTag2;
        }
        function baseIsEqual2(value, other, bitmask, customizer, stack) {
          if (value === other) {
            return true;
          }
          if (value == null || other == null || !isObjectLike2(value) && !isObjectLike2(other)) {
            return value !== value && other !== other;
          }
          return baseIsEqualDeep2(value, other, bitmask, customizer, baseIsEqual2, stack);
        }
        function baseIsEqualDeep2(object2, other, bitmask, customizer, equalFunc, stack) {
          var objIsArr = isArray2(object2), othIsArr = isArray2(other), objTag = objIsArr ? arrayTag2 : getTag2(object2), othTag = othIsArr ? arrayTag2 : getTag2(other);
          objTag = objTag == argsTag2 ? objectTag2 : objTag;
          othTag = othTag == argsTag2 ? objectTag2 : othTag;
          var objIsObj = objTag == objectTag2, othIsObj = othTag == objectTag2, isSameTag = objTag == othTag;
          if (isSameTag && isBuffer2(object2)) {
            if (!isBuffer2(other)) {
              return false;
            }
            objIsArr = true;
            objIsObj = false;
          }
          if (isSameTag && !objIsObj) {
            stack || (stack = new Stack2());
            return objIsArr || isTypedArray2(object2) ? equalArrays2(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag2(object2, other, objTag, bitmask, customizer, equalFunc, stack);
          }
          if (!(bitmask & COMPARE_PARTIAL_FLAG2)) {
            var objIsWrapped = objIsObj && hasOwnProperty2.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty2.call(other, "__wrapped__");
            if (objIsWrapped || othIsWrapped) {
              var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
              stack || (stack = new Stack2());
              return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
            }
          }
          if (!isSameTag) {
            return false;
          }
          stack || (stack = new Stack2());
          return equalObjects2(object2, other, bitmask, customizer, equalFunc, stack);
        }
        function baseIsMap2(value) {
          return isObjectLike2(value) && getTag2(value) == mapTag2;
        }
        function baseIsMatch(object2, source, matchData, customizer) {
          var index2 = matchData.length, length2 = index2, noCustomizer = !customizer;
          if (object2 == null) {
            return !length2;
          }
          object2 = Object2(object2);
          while (index2--) {
            var data2 = matchData[index2];
            if (noCustomizer && data2[2] ? data2[1] !== object2[data2[0]] : !(data2[0] in object2)) {
              return false;
            }
          }
          while (++index2 < length2) {
            data2 = matchData[index2];
            var key = data2[0], objValue = object2[key], srcValue = data2[1];
            if (noCustomizer && data2[2]) {
              if (objValue === undefined$12 && !(key in object2)) {
                return false;
              }
            } else {
              var stack = new Stack2();
              if (customizer) {
                var result2 = customizer(objValue, srcValue, key, object2, source, stack);
              }
              if (!(result2 === undefined$12 ? baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2, customizer, stack) : result2)) {
                return false;
              }
            }
          }
          return true;
        }
        function baseIsNative2(value) {
          if (!isObject2(value) || isMasked2(value)) {
            return false;
          }
          var pattern = isFunction2(value) ? reIsNative2 : reIsHostCtor2;
          return pattern.test(toSource2(value));
        }
        function baseIsRegExp(value) {
          return isObjectLike2(value) && baseGetTag2(value) == regexpTag2;
        }
        function baseIsSet2(value) {
          return isObjectLike2(value) && getTag2(value) == setTag2;
        }
        function baseIsTypedArray2(value) {
          return isObjectLike2(value) && isLength2(value.length) && !!typedArrayTags2[baseGetTag2(value)];
        }
        function baseIteratee(value) {
          if (typeof value == "function") {
            return value;
          }
          if (value == null) {
            return identity2;
          }
          if (typeof value == "object") {
            return isArray2(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
          }
          return property(value);
        }
        function baseKeys2(object2) {
          if (!isPrototype2(object2)) {
            return nativeKeys2(object2);
          }
          var result2 = [];
          for (var key in Object2(object2)) {
            if (hasOwnProperty2.call(object2, key) && key != "constructor") {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseKeysIn2(object2) {
          if (!isObject2(object2)) {
            return nativeKeysIn2(object2);
          }
          var isProto = isPrototype2(object2), result2 = [];
          for (var key in object2) {
            if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object2, key)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseLt(value, other) {
          return value < other;
        }
        function baseMap(collection2, iteratee2) {
          var index2 = -1, result2 = isArrayLike2(collection2) ? Array2(collection2.length) : [];
          baseEach(collection2, function(value, key, collection3) {
            result2[++index2] = iteratee2(value, key, collection3);
          });
          return result2;
        }
        function baseMatches(source) {
          var matchData = getMatchData(source);
          if (matchData.length == 1 && matchData[0][2]) {
            return matchesStrictComparable(matchData[0][0], matchData[0][1]);
          }
          return function(object2) {
            return object2 === source || baseIsMatch(object2, source, matchData);
          };
        }
        function baseMatchesProperty(path2, srcValue) {
          if (isKey2(path2) && isStrictComparable(srcValue)) {
            return matchesStrictComparable(toKey2(path2), srcValue);
          }
          return function(object2) {
            var objValue = get2(object2, path2);
            return objValue === undefined$12 && objValue === srcValue ? hasIn(object2, path2) : baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2);
          };
        }
        function baseMerge(object2, source, srcIndex, customizer, stack) {
          if (object2 === source) {
            return;
          }
          baseFor(source, function(srcValue, key) {
            stack || (stack = new Stack2());
            if (isObject2(srcValue)) {
              baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
            } else {
              var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : undefined$12;
              if (newValue === undefined$12) {
                newValue = srcValue;
              }
              assignMergeValue(object2, key, newValue);
            }
          }, keysIn2);
        }
        function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
          var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
          if (stacked) {
            assignMergeValue(object2, key, stacked);
            return;
          }
          var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : undefined$12;
          var isCommon = newValue === undefined$12;
          if (isCommon) {
            var isArr = isArray2(srcValue), isBuff = !isArr && isBuffer2(srcValue), isTyped = !isArr && !isBuff && isTypedArray2(srcValue);
            newValue = srcValue;
            if (isArr || isBuff || isTyped) {
              if (isArray2(objValue)) {
                newValue = objValue;
              } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray2(objValue);
              } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer2(srcValue, true);
              } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray2(srcValue, true);
              } else {
                newValue = [];
              }
            } else if (isPlainObject2(srcValue) || isArguments2(srcValue)) {
              newValue = objValue;
              if (isArguments2(objValue)) {
                newValue = toPlainObject(objValue);
              } else if (!isObject2(objValue) || isFunction2(objValue)) {
                newValue = initCloneObject2(srcValue);
              }
            } else {
              isCommon = false;
            }
          }
          if (isCommon) {
            stack.set(srcValue, newValue);
            mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
            stack["delete"](srcValue);
          }
          assignMergeValue(object2, key, newValue);
        }
        function baseNth(array2, n2) {
          var length2 = array2.length;
          if (!length2) {
            return;
          }
          n2 += n2 < 0 ? length2 : 0;
          return isIndex2(n2, length2) ? array2[n2] : undefined$12;
        }
        function baseOrderBy(collection2, iteratees, orders) {
          if (iteratees.length) {
            iteratees = arrayMap2(iteratees, function(iteratee2) {
              if (isArray2(iteratee2)) {
                return function(value) {
                  return baseGet2(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
                };
              }
              return iteratee2;
            });
          } else {
            iteratees = [identity2];
          }
          var index2 = -1;
          iteratees = arrayMap2(iteratees, baseUnary2(getIteratee()));
          var result2 = baseMap(collection2, function(value, key, collection3) {
            var criteria = arrayMap2(iteratees, function(iteratee2) {
              return iteratee2(value);
            });
            return { "criteria": criteria, "index": ++index2, "value": value };
          });
          return baseSortBy(result2, function(object2, other) {
            return compareMultiple(object2, other, orders);
          });
        }
        function basePick(object2, paths) {
          return basePickBy(object2, paths, function(value, path2) {
            return hasIn(object2, path2);
          });
        }
        function basePickBy(object2, paths, predicate) {
          var index2 = -1, length2 = paths.length, result2 = {};
          while (++index2 < length2) {
            var path2 = paths[index2], value = baseGet2(object2, path2);
            if (predicate(value, path2)) {
              baseSet2(result2, castPath2(path2, object2), value);
            }
          }
          return result2;
        }
        function basePropertyDeep(path2) {
          return function(object2) {
            return baseGet2(object2, path2);
          };
        }
        function basePullAll(array2, values2, iteratee2, comparator) {
          var indexOf3 = comparator ? baseIndexOfWith : baseIndexOf, index2 = -1, length2 = values2.length, seen = array2;
          if (array2 === values2) {
            values2 = copyArray2(values2);
          }
          if (iteratee2) {
            seen = arrayMap2(array2, baseUnary2(iteratee2));
          }
          while (++index2 < length2) {
            var fromIndex = 0, value = values2[index2], computed = iteratee2 ? iteratee2(value) : value;
            while ((fromIndex = indexOf3(seen, computed, fromIndex, comparator)) > -1) {
              if (seen !== array2) {
                splice2.call(seen, fromIndex, 1);
              }
              splice2.call(array2, fromIndex, 1);
            }
          }
          return array2;
        }
        function basePullAt(array2, indexes2) {
          var length2 = array2 ? indexes2.length : 0, lastIndex = length2 - 1;
          while (length2--) {
            var index2 = indexes2[length2];
            if (length2 == lastIndex || index2 !== previous2) {
              var previous2 = index2;
              if (isIndex2(index2)) {
                splice2.call(array2, index2, 1);
              } else {
                baseUnset(array2, index2);
              }
            }
          }
          return array2;
        }
        function baseRandom(lower2, upper) {
          return lower2 + nativeFloor(nativeRandom() * (upper - lower2 + 1));
        }
        function baseRange(start2, end2, step2, fromRight) {
          var index2 = -1, length2 = nativeMax2(nativeCeil((end2 - start2) / (step2 || 1)), 0), result2 = Array2(length2);
          while (length2--) {
            result2[fromRight ? length2 : ++index2] = start2;
            start2 += step2;
          }
          return result2;
        }
        function baseRepeat(string2, n2) {
          var result2 = "";
          if (!string2 || n2 < 1 || n2 > MAX_SAFE_INTEGER2) {
            return result2;
          }
          do {
            if (n2 % 2) {
              result2 += string2;
            }
            n2 = nativeFloor(n2 / 2);
            if (n2) {
              string2 += string2;
            }
          } while (n2);
          return result2;
        }
        function baseRest(func, start2) {
          return setToString(overRest(func, start2, identity2), func + "");
        }
        function baseSample(collection2) {
          return arraySample(values(collection2));
        }
        function baseSampleSize(collection2, n2) {
          var array2 = values(collection2);
          return shuffleSelf(array2, baseClamp(n2, 0, array2.length));
        }
        function baseSet2(object2, path2, value, customizer) {
          if (!isObject2(object2)) {
            return object2;
          }
          path2 = castPath2(path2, object2);
          var index2 = -1, length2 = path2.length, lastIndex = length2 - 1, nested = object2;
          while (nested != null && ++index2 < length2) {
            var key = toKey2(path2[index2]), newValue = value;
            if (key === "__proto__" || key === "constructor" || key === "prototype") {
              return object2;
            }
            if (index2 != lastIndex) {
              var objValue = nested[key];
              newValue = customizer ? customizer(objValue, key, nested) : undefined$12;
              if (newValue === undefined$12) {
                newValue = isObject2(objValue) ? objValue : isIndex2(path2[index2 + 1]) ? [] : {};
              }
            }
            assignValue2(nested, key, newValue);
            nested = nested[key];
          }
          return object2;
        }
        var baseSetData = !metaMap ? identity2 : function(func, data2) {
          metaMap.set(func, data2);
          return func;
        };
        var baseSetToString = !defineProperty2 ? identity2 : function(func, string2) {
          return defineProperty2(func, "toString", {
            "configurable": true,
            "enumerable": false,
            "value": constant2(string2),
            "writable": true
          });
        };
        function baseShuffle(collection2) {
          return shuffleSelf(values(collection2));
        }
        function baseSlice(array2, start2, end2) {
          var index2 = -1, length2 = array2.length;
          if (start2 < 0) {
            start2 = -start2 > length2 ? 0 : length2 + start2;
          }
          end2 = end2 > length2 ? length2 : end2;
          if (end2 < 0) {
            end2 += length2;
          }
          length2 = start2 > end2 ? 0 : end2 - start2 >>> 0;
          start2 >>>= 0;
          var result2 = Array2(length2);
          while (++index2 < length2) {
            result2[index2] = array2[index2 + start2];
          }
          return result2;
        }
        function baseSome(collection2, predicate) {
          var result2;
          baseEach(collection2, function(value, index2, collection3) {
            result2 = predicate(value, index2, collection3);
            return !result2;
          });
          return !!result2;
        }
        function baseSortedIndex(array2, value, retHighest) {
          var low = 0, high = array2 == null ? low : array2.length;
          if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
            while (low < high) {
              var mid = low + high >>> 1, computed = array2[mid];
              if (computed !== null && !isSymbol2(computed) && (retHighest ? computed <= value : computed < value)) {
                low = mid + 1;
              } else {
                high = mid;
              }
            }
            return high;
          }
          return baseSortedIndexBy(array2, value, identity2, retHighest);
        }
        function baseSortedIndexBy(array2, value, iteratee2, retHighest) {
          var low = 0, high = array2 == null ? 0 : array2.length;
          if (high === 0) {
            return 0;
          }
          value = iteratee2(value);
          var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol2(value), valIsUndefined = value === undefined$12;
          while (low < high) {
            var mid = nativeFloor((low + high) / 2), computed = iteratee2(array2[mid]), othIsDefined = computed !== undefined$12, othIsNull = computed === null, othIsReflexive = computed === computed, othIsSymbol = isSymbol2(computed);
            if (valIsNaN) {
              var setLow = retHighest || othIsReflexive;
            } else if (valIsUndefined) {
              setLow = othIsReflexive && (retHighest || othIsDefined);
            } else if (valIsNull) {
              setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
            } else if (valIsSymbol) {
              setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
            } else if (othIsNull || othIsSymbol) {
              setLow = false;
            } else {
              setLow = retHighest ? computed <= value : computed < value;
            }
            if (setLow) {
              low = mid + 1;
            } else {
              high = mid;
            }
          }
          return nativeMin2(high, MAX_ARRAY_INDEX);
        }
        function baseSortedUniq(array2, iteratee2) {
          var index2 = -1, length2 = array2.length, resIndex = 0, result2 = [];
          while (++index2 < length2) {
            var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
            if (!index2 || !eq2(computed, seen)) {
              var seen = computed;
              result2[resIndex++] = value === 0 ? 0 : value;
            }
          }
          return result2;
        }
        function baseToNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol2(value)) {
            return NAN2;
          }
          return +value;
        }
        function baseToString2(value) {
          if (typeof value == "string") {
            return value;
          }
          if (isArray2(value)) {
            return arrayMap2(value, baseToString2) + "";
          }
          if (isSymbol2(value)) {
            return symbolToString2 ? symbolToString2.call(value) : "";
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY2 ? "-0" : result2;
        }
        function baseUniq(array2, iteratee2, comparator) {
          var index2 = -1, includes2 = arrayIncludes, length2 = array2.length, isCommon = true, result2 = [], seen = result2;
          if (comparator) {
            isCommon = false;
            includes2 = arrayIncludesWith;
          } else if (length2 >= LARGE_ARRAY_SIZE2) {
            var set3 = iteratee2 ? null : createSet(array2);
            if (set3) {
              return setToArray2(set3);
            }
            isCommon = false;
            includes2 = cacheHas2;
            seen = new SetCache2();
          } else {
            seen = iteratee2 ? [] : result2;
          }
          outer:
            while (++index2 < length2) {
              var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var seenIndex = seen.length;
                while (seenIndex--) {
                  if (seen[seenIndex] === computed) {
                    continue outer;
                  }
                }
                if (iteratee2) {
                  seen.push(computed);
                }
                result2.push(value);
              } else if (!includes2(seen, computed, comparator)) {
                if (seen !== result2) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseUnset(object2, path2) {
          path2 = castPath2(path2, object2);
          object2 = parent(object2, path2);
          return object2 == null || delete object2[toKey2(last(path2))];
        }
        function baseUpdate(object2, path2, updater, customizer) {
          return baseSet2(object2, path2, updater(baseGet2(object2, path2)), customizer);
        }
        function baseWhile(array2, predicate, isDrop, fromRight) {
          var length2 = array2.length, index2 = fromRight ? length2 : -1;
          while ((fromRight ? index2-- : ++index2 < length2) && predicate(array2[index2], index2, array2)) {
          }
          return isDrop ? baseSlice(array2, fromRight ? 0 : index2, fromRight ? index2 + 1 : length2) : baseSlice(array2, fromRight ? index2 + 1 : 0, fromRight ? length2 : index2);
        }
        function baseWrapperValue(value, actions) {
          var result2 = value;
          if (result2 instanceof LazyWrapper) {
            result2 = result2.value();
          }
          return arrayReduce(actions, function(result3, action) {
            return action.func.apply(action.thisArg, arrayPush2([result3], action.args));
          }, result2);
        }
        function baseXor(arrays, iteratee2, comparator) {
          var length2 = arrays.length;
          if (length2 < 2) {
            return length2 ? baseUniq(arrays[0]) : [];
          }
          var index2 = -1, result2 = Array2(length2);
          while (++index2 < length2) {
            var array2 = arrays[index2], othIndex = -1;
            while (++othIndex < length2) {
              if (othIndex != index2) {
                result2[index2] = baseDifference(result2[index2] || array2, arrays[othIndex], iteratee2, comparator);
              }
            }
          }
          return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
        }
        function baseZipObject(props, values2, assignFunc) {
          var index2 = -1, length2 = props.length, valsLength = values2.length, result2 = {};
          while (++index2 < length2) {
            var value = index2 < valsLength ? values2[index2] : undefined$12;
            assignFunc(result2, props[index2], value);
          }
          return result2;
        }
        function castArrayLikeObject(value) {
          return isArrayLikeObject(value) ? value : [];
        }
        function castFunction(value) {
          return typeof value == "function" ? value : identity2;
        }
        function castPath2(value, object2) {
          if (isArray2(value)) {
            return value;
          }
          return isKey2(value, object2) ? [value] : stringToPath2(toString2(value));
        }
        var castRest = baseRest;
        function castSlice(array2, start2, end2) {
          var length2 = array2.length;
          end2 = end2 === undefined$12 ? length2 : end2;
          return !start2 && end2 >= length2 ? array2 : baseSlice(array2, start2, end2);
        }
        var clearTimeout2 = ctxClearTimeout || function(id2) {
          return root2.clearTimeout(id2);
        };
        function cloneBuffer2(buffer2, isDeep) {
          if (isDeep) {
            return buffer2.slice();
          }
          var length2 = buffer2.length, result2 = allocUnsafe ? allocUnsafe(length2) : new buffer2.constructor(length2);
          buffer2.copy(result2);
          return result2;
        }
        function cloneArrayBuffer2(arrayBuffer) {
          var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
          new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
          return result2;
        }
        function cloneDataView2(dataView, isDeep) {
          var buffer2 = isDeep ? cloneArrayBuffer2(dataView.buffer) : dataView.buffer;
          return new dataView.constructor(buffer2, dataView.byteOffset, dataView.byteLength);
        }
        function cloneRegExp2(regexp) {
          var result2 = new regexp.constructor(regexp.source, reFlags2.exec(regexp));
          result2.lastIndex = regexp.lastIndex;
          return result2;
        }
        function cloneSymbol2(symbol) {
          return symbolValueOf2 ? Object2(symbolValueOf2.call(symbol)) : {};
        }
        function cloneTypedArray2(typedArray, isDeep) {
          var buffer2 = isDeep ? cloneArrayBuffer2(typedArray.buffer) : typedArray.buffer;
          return new typedArray.constructor(buffer2, typedArray.byteOffset, typedArray.length);
        }
        function compareAscending(value, other) {
          if (value !== other) {
            var valIsDefined = value !== undefined$12, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol2(value);
            var othIsDefined = other !== undefined$12, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol2(other);
            if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
              return 1;
            }
            if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
              return -1;
            }
          }
          return 0;
        }
        function compareMultiple(object2, other, orders) {
          var index2 = -1, objCriteria = object2.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
          while (++index2 < length2) {
            var result2 = compareAscending(objCriteria[index2], othCriteria[index2]);
            if (result2) {
              if (index2 >= ordersLength) {
                return result2;
              }
              var order2 = orders[index2];
              return result2 * (order2 == "desc" ? -1 : 1);
            }
          }
          return object2.index - other.index;
        }
        function composeArgs(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax2(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
          while (++leftIndex < leftLength) {
            result2[leftIndex] = partials[leftIndex];
          }
          while (++argsIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[holders[argsIndex]] = args[argsIndex];
            }
          }
          while (rangeLength--) {
            result2[leftIndex++] = args[argsIndex++];
          }
          return result2;
        }
        function composeArgsRight(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax2(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
          while (++argsIndex < rangeLength) {
            result2[argsIndex] = args[argsIndex];
          }
          var offset2 = argsIndex;
          while (++rightIndex < rightLength) {
            result2[offset2 + rightIndex] = partials[rightIndex];
          }
          while (++holdersIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[offset2 + holders[holdersIndex]] = args[argsIndex++];
            }
          }
          return result2;
        }
        function copyArray2(source, array2) {
          var index2 = -1, length2 = source.length;
          array2 || (array2 = Array2(length2));
          while (++index2 < length2) {
            array2[index2] = source[index2];
          }
          return array2;
        }
        function copyObject2(source, props, object2, customizer) {
          var isNew = !object2;
          object2 || (object2 = {});
          var index2 = -1, length2 = props.length;
          while (++index2 < length2) {
            var key = props[index2];
            var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : undefined$12;
            if (newValue === undefined$12) {
              newValue = source[key];
            }
            if (isNew) {
              baseAssignValue2(object2, key, newValue);
            } else {
              assignValue2(object2, key, newValue);
            }
          }
          return object2;
        }
        function copySymbols2(source, object2) {
          return copyObject2(source, getSymbols2(source), object2);
        }
        function copySymbolsIn2(source, object2) {
          return copyObject2(source, getSymbolsIn2(source), object2);
        }
        function createAggregator(setter, initializer) {
          return function(collection2, iteratee2) {
            var func = isArray2(collection2) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
            return func(collection2, setter, getIteratee(iteratee2, 2), accumulator);
          };
        }
        function createAssigner(assigner) {
          return baseRest(function(object2, sources) {
            var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : undefined$12, guard2 = length2 > 2 ? sources[2] : undefined$12;
            customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : undefined$12;
            if (guard2 && isIterateeCall(sources[0], sources[1], guard2)) {
              customizer = length2 < 3 ? undefined$12 : customizer;
              length2 = 1;
            }
            object2 = Object2(object2);
            while (++index2 < length2) {
              var source = sources[index2];
              if (source) {
                assigner(object2, source, index2, customizer);
              }
            }
            return object2;
          });
        }
        function createBaseEach(eachFunc, fromRight) {
          return function(collection2, iteratee2) {
            if (collection2 == null) {
              return collection2;
            }
            if (!isArrayLike2(collection2)) {
              return eachFunc(collection2, iteratee2);
            }
            var length2 = collection2.length, index2 = fromRight ? length2 : -1, iterable = Object2(collection2);
            while (fromRight ? index2-- : ++index2 < length2) {
              if (iteratee2(iterable[index2], index2, iterable) === false) {
                break;
              }
            }
            return collection2;
          };
        }
        function createBaseFor(fromRight) {
          return function(object2, iteratee2, keysFunc) {
            var index2 = -1, iterable = Object2(object2), props = keysFunc(object2), length2 = props.length;
            while (length2--) {
              var key = props[fromRight ? length2 : ++index2];
              if (iteratee2(iterable[key], key, iterable) === false) {
                break;
              }
            }
            return object2;
          };
        }
        function createBind(func, bitmask, thisArg) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            return fn2.apply(isBind ? thisArg : this, arguments);
          }
          return wrapper;
        }
        function createCaseFirst(methodName) {
          return function(string2) {
            string2 = toString2(string2);
            var strSymbols = hasUnicode(string2) ? stringToArray(string2) : undefined$12;
            var chr = strSymbols ? strSymbols[0] : string2.charAt(0);
            var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string2.slice(1);
            return chr[methodName]() + trailing;
          };
        }
        function createCompounder(callback) {
          return function(string2) {
            return arrayReduce(words(deburr(string2).replace(reApos, "")), callback, "");
          };
        }
        function createCtor(Ctor) {
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return new Ctor();
              case 1:
                return new Ctor(args[0]);
              case 2:
                return new Ctor(args[0], args[1]);
              case 3:
                return new Ctor(args[0], args[1], args[2]);
              case 4:
                return new Ctor(args[0], args[1], args[2], args[3]);
              case 5:
                return new Ctor(args[0], args[1], args[2], args[3], args[4]);
              case 6:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
              case 7:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            var thisBinding = baseCreate2(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
            return isObject2(result2) ? result2 : thisBinding;
          };
        }
        function createCurry(func, bitmask, arity) {
          var Ctor = createCtor(func);
          function wrapper() {
            var length2 = arguments.length, args = Array2(length2), index2 = length2, placeholder = getHolder(wrapper);
            while (index2--) {
              args[index2] = arguments[index2];
            }
            var holders = length2 < 3 && args[0] !== placeholder && args[length2 - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
            length2 -= holders.length;
            if (length2 < arity) {
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                undefined$12,
                args,
                holders,
                undefined$12,
                undefined$12,
                arity - length2
              );
            }
            var fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            return apply(fn2, this, args);
          }
          return wrapper;
        }
        function createFind(findIndexFunc) {
          return function(collection2, predicate, fromIndex) {
            var iterable = Object2(collection2);
            if (!isArrayLike2(collection2)) {
              var iteratee2 = getIteratee(predicate, 3);
              collection2 = keys2(collection2);
              predicate = function(key) {
                return iteratee2(iterable[key], key, iterable);
              };
            }
            var index2 = findIndexFunc(collection2, predicate, fromIndex);
            return index2 > -1 ? iterable[iteratee2 ? collection2[index2] : index2] : undefined$12;
          };
        }
        function createFlow(fromRight) {
          return flatRest(function(funcs) {
            var length2 = funcs.length, index2 = length2, prereq = LodashWrapper.prototype.thru;
            if (fromRight) {
              funcs.reverse();
            }
            while (index2--) {
              var func = funcs[index2];
              if (typeof func != "function") {
                throw new TypeError2(FUNC_ERROR_TEXT2);
              }
              if (prereq && !wrapper && getFuncName(func) == "wrapper") {
                var wrapper = new LodashWrapper([], true);
              }
            }
            index2 = wrapper ? index2 : length2;
            while (++index2 < length2) {
              func = funcs[index2];
              var funcName = getFuncName(func), data2 = funcName == "wrapper" ? getData(func) : undefined$12;
              if (data2 && isLaziable(data2[0]) && data2[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data2[4].length && data2[9] == 1) {
                wrapper = wrapper[getFuncName(data2[0])].apply(wrapper, data2[3]);
              } else {
                wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
              }
            }
            return function() {
              var args = arguments, value = args[0];
              if (wrapper && args.length == 1 && isArray2(value)) {
                return wrapper.plant(value).value();
              }
              var index3 = 0, result2 = length2 ? funcs[index3].apply(this, args) : value;
              while (++index3 < length2) {
                result2 = funcs[index3].call(this, result2);
              }
              return result2;
            };
          });
        }
        function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
          var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined$12 : createCtor(func);
          function wrapper() {
            var length2 = arguments.length, args = Array2(length2), index2 = length2;
            while (index2--) {
              args[index2] = arguments[index2];
            }
            if (isCurried) {
              var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
            }
            if (partials) {
              args = composeArgs(args, partials, holders, isCurried);
            }
            if (partialsRight) {
              args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
            }
            length2 -= holdersCount;
            if (isCurried && length2 < arity) {
              var newHolders = replaceHolders(args, placeholder);
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                thisArg,
                args,
                newHolders,
                argPos,
                ary2,
                arity - length2
              );
            }
            var thisBinding = isBind ? thisArg : this, fn2 = isBindKey ? thisBinding[func] : func;
            length2 = args.length;
            if (argPos) {
              args = reorder(args, argPos);
            } else if (isFlip && length2 > 1) {
              args.reverse();
            }
            if (isAry && ary2 < length2) {
              args.length = ary2;
            }
            if (this && this !== root2 && this instanceof wrapper) {
              fn2 = Ctor || createCtor(fn2);
            }
            return fn2.apply(thisBinding, args);
          }
          return wrapper;
        }
        function createInverter(setter, toIteratee) {
          return function(object2, iteratee2) {
            return baseInverter(object2, setter, toIteratee(iteratee2), {});
          };
        }
        function createMathOperation(operator2, defaultValue2) {
          return function(value, other) {
            var result2;
            if (value === undefined$12 && other === undefined$12) {
              return defaultValue2;
            }
            if (value !== undefined$12) {
              result2 = value;
            }
            if (other !== undefined$12) {
              if (result2 === undefined$12) {
                return other;
              }
              if (typeof value == "string" || typeof other == "string") {
                value = baseToString2(value);
                other = baseToString2(other);
              } else {
                value = baseToNumber(value);
                other = baseToNumber(other);
              }
              result2 = operator2(value, other);
            }
            return result2;
          };
        }
        function createOver(arrayFunc) {
          return flatRest(function(iteratees) {
            iteratees = arrayMap2(iteratees, baseUnary2(getIteratee()));
            return baseRest(function(args) {
              var thisArg = this;
              return arrayFunc(iteratees, function(iteratee2) {
                return apply(iteratee2, thisArg, args);
              });
            });
          });
        }
        function createPadding(length2, chars) {
          chars = chars === undefined$12 ? " " : baseToString2(chars);
          var charsLength = chars.length;
          if (charsLength < 2) {
            return charsLength ? baseRepeat(chars, length2) : chars;
          }
          var result2 = baseRepeat(chars, nativeCeil(length2 / stringSize(chars)));
          return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length2).join("") : result2.slice(0, length2);
        }
        function createPartial(func, bitmask, thisArg, partials) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            while (++leftIndex < leftLength) {
              args[leftIndex] = partials[leftIndex];
            }
            while (argsLength--) {
              args[leftIndex++] = arguments[++argsIndex];
            }
            return apply(fn2, isBind ? thisArg : this, args);
          }
          return wrapper;
        }
        function createRange(fromRight) {
          return function(start2, end2, step2) {
            if (step2 && typeof step2 != "number" && isIterateeCall(start2, end2, step2)) {
              end2 = step2 = undefined$12;
            }
            start2 = toFinite2(start2);
            if (end2 === undefined$12) {
              end2 = start2;
              start2 = 0;
            } else {
              end2 = toFinite2(end2);
            }
            step2 = step2 === undefined$12 ? start2 < end2 ? 1 : -1 : toFinite2(step2);
            return baseRange(start2, end2, step2, fromRight);
          };
        }
        function createRelationalOperation(operator2) {
          return function(value, other) {
            if (!(typeof value == "string" && typeof other == "string")) {
              value = toNumber2(value);
              other = toNumber2(other);
            }
            return operator2(value, other);
          };
        }
        function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
          var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined$12, newHoldersRight = isCurry ? undefined$12 : holders, newPartials = isCurry ? partials : undefined$12, newPartialsRight = isCurry ? undefined$12 : partials;
          bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
          bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
          if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
            bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
          }
          var newData = [
            func,
            bitmask,
            thisArg,
            newPartials,
            newHolders,
            newPartialsRight,
            newHoldersRight,
            argPos,
            ary2,
            arity
          ];
          var result2 = wrapFunc.apply(undefined$12, newData);
          if (isLaziable(func)) {
            setData(result2, newData);
          }
          result2.placeholder = placeholder;
          return setWrapToString(result2, func, bitmask);
        }
        function createRound2(methodName) {
          var func = Math2[methodName];
          return function(number2, precision2) {
            number2 = toNumber2(number2);
            precision2 = precision2 == null ? 0 : nativeMin2(toInteger2(precision2), 292);
            if (precision2 && nativeIsFinite2(number2)) {
              var pair2 = (toString2(number2) + "e").split("e"), value = func(pair2[0] + "e" + (+pair2[1] + precision2));
              pair2 = (toString2(value) + "e").split("e");
              return +(pair2[0] + "e" + (+pair2[1] - precision2));
            }
            return func(number2);
          };
        }
        var createSet = !(Set2 && 1 / setToArray2(new Set2([, -0]))[1] == INFINITY2) ? noop2 : function(values2) {
          return new Set2(values2);
        };
        function createToPairs(keysFunc) {
          return function(object2) {
            var tag = getTag2(object2);
            if (tag == mapTag2) {
              return mapToArray2(object2);
            }
            if (tag == setTag2) {
              return setToPairs(object2);
            }
            return baseToPairs(object2, keysFunc(object2));
          };
        }
        function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
          var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
          if (!isBindKey && typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          var length2 = partials ? partials.length : 0;
          if (!length2) {
            bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
            partials = holders = undefined$12;
          }
          ary2 = ary2 === undefined$12 ? ary2 : nativeMax2(toInteger2(ary2), 0);
          arity = arity === undefined$12 ? arity : toInteger2(arity);
          length2 -= holders ? holders.length : 0;
          if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
            var partialsRight = partials, holdersRight = holders;
            partials = holders = undefined$12;
          }
          var data2 = isBindKey ? undefined$12 : getData(func);
          var newData = [
            func,
            bitmask,
            thisArg,
            partials,
            holders,
            partialsRight,
            holdersRight,
            argPos,
            ary2,
            arity
          ];
          if (data2) {
            mergeData(newData, data2);
          }
          func = newData[0];
          bitmask = newData[1];
          thisArg = newData[2];
          partials = newData[3];
          holders = newData[4];
          arity = newData[9] = newData[9] === undefined$12 ? isBindKey ? 0 : func.length : nativeMax2(newData[9] - length2, 0);
          if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
            bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
          }
          if (!bitmask || bitmask == WRAP_BIND_FLAG) {
            var result2 = createBind(func, bitmask, thisArg);
          } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
            result2 = createCurry(func, bitmask, arity);
          } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
            result2 = createPartial(func, bitmask, thisArg, partials);
          } else {
            result2 = createHybrid.apply(undefined$12, newData);
          }
          var setter = data2 ? baseSetData : setData;
          return setWrapToString(setter(result2, newData), func, bitmask);
        }
        function customDefaultsAssignIn(objValue, srcValue, key, object2) {
          if (objValue === undefined$12 || eq2(objValue, objectProto2[key]) && !hasOwnProperty2.call(object2, key)) {
            return srcValue;
          }
          return objValue;
        }
        function customDefaultsMerge(objValue, srcValue, key, object2, source, stack) {
          if (isObject2(objValue) && isObject2(srcValue)) {
            stack.set(srcValue, objValue);
            baseMerge(objValue, srcValue, undefined$12, customDefaultsMerge, stack);
            stack["delete"](srcValue);
          }
          return objValue;
        }
        function customOmitClone(value) {
          return isPlainObject2(value) ? undefined$12 : value;
        }
        function equalArrays2(array2, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, arrLength = array2.length, othLength = other.length;
          if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
            return false;
          }
          var arrStacked = stack.get(array2);
          var othStacked = stack.get(other);
          if (arrStacked && othStacked) {
            return arrStacked == other && othStacked == array2;
          }
          var index2 = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG2 ? new SetCache2() : undefined$12;
          stack.set(array2, other);
          stack.set(other, array2);
          while (++index2 < arrLength) {
            var arrValue = array2[index2], othValue = other[index2];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
            }
            if (compared !== undefined$12) {
              if (compared) {
                continue;
              }
              result2 = false;
              break;
            }
            if (seen) {
              if (!arraySome2(other, function(othValue2, othIndex) {
                if (!cacheHas2(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
                result2 = false;
                break;
              }
            } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              result2 = false;
              break;
            }
          }
          stack["delete"](array2);
          stack["delete"](other);
          return result2;
        }
        function equalByTag2(object2, other, tag, bitmask, customizer, equalFunc, stack) {
          switch (tag) {
            case dataViewTag2:
              if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
                return false;
              }
              object2 = object2.buffer;
              other = other.buffer;
            case arrayBufferTag2:
              if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object2), new Uint8Array2(other))) {
                return false;
              }
              return true;
            case boolTag2:
            case dateTag2:
            case numberTag2:
              return eq2(+object2, +other);
            case errorTag2:
              return object2.name == other.name && object2.message == other.message;
            case regexpTag2:
            case stringTag2:
              return object2 == other + "";
            case mapTag2:
              var convert2 = mapToArray2;
            case setTag2:
              var isPartial = bitmask & COMPARE_PARTIAL_FLAG2;
              convert2 || (convert2 = setToArray2);
              if (object2.size != other.size && !isPartial) {
                return false;
              }
              var stacked = stack.get(object2);
              if (stacked) {
                return stacked == other;
              }
              bitmask |= COMPARE_UNORDERED_FLAG2;
              stack.set(object2, other);
              var result2 = equalArrays2(convert2(object2), convert2(other), bitmask, customizer, equalFunc, stack);
              stack["delete"](object2);
              return result2;
            case symbolTag2:
              if (symbolValueOf2) {
                return symbolValueOf2.call(object2) == symbolValueOf2.call(other);
              }
          }
          return false;
        }
        function equalObjects2(object2, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, objProps = getAllKeys2(object2), objLength = objProps.length, othProps = getAllKeys2(other), othLength = othProps.length;
          if (objLength != othLength && !isPartial) {
            return false;
          }
          var index2 = objLength;
          while (index2--) {
            var key = objProps[index2];
            if (!(isPartial ? key in other : hasOwnProperty2.call(other, key))) {
              return false;
            }
          }
          var objStacked = stack.get(object2);
          var othStacked = stack.get(other);
          if (objStacked && othStacked) {
            return objStacked == other && othStacked == object2;
          }
          var result2 = true;
          stack.set(object2, other);
          stack.set(other, object2);
          var skipCtor = isPartial;
          while (++index2 < objLength) {
            key = objProps[index2];
            var objValue = object2[key], othValue = other[key];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
            }
            if (!(compared === undefined$12 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
              result2 = false;
              break;
            }
            skipCtor || (skipCtor = key == "constructor");
          }
          if (result2 && !skipCtor) {
            var objCtor = object2.constructor, othCtor = other.constructor;
            if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
              result2 = false;
            }
          }
          stack["delete"](object2);
          stack["delete"](other);
          return result2;
        }
        function flatRest(func) {
          return setToString(overRest(func, undefined$12, flatten2), func + "");
        }
        function getAllKeys2(object2) {
          return baseGetAllKeys2(object2, keys2, getSymbols2);
        }
        function getAllKeysIn2(object2) {
          return baseGetAllKeys2(object2, keysIn2, getSymbolsIn2);
        }
        var getData = !metaMap ? noop2 : function(func) {
          return metaMap.get(func);
        };
        function getFuncName(func) {
          var result2 = func.name + "", array2 = realNames[result2], length2 = hasOwnProperty2.call(realNames, result2) ? array2.length : 0;
          while (length2--) {
            var data2 = array2[length2], otherFunc = data2.func;
            if (otherFunc == null || otherFunc == func) {
              return data2.name;
            }
          }
          return result2;
        }
        function getHolder(func) {
          var object2 = hasOwnProperty2.call(lodash2, "placeholder") ? lodash2 : func;
          return object2.placeholder;
        }
        function getIteratee() {
          var result2 = lodash2.iteratee || iteratee;
          result2 = result2 === iteratee ? baseIteratee : result2;
          return arguments.length ? result2(arguments[0], arguments[1]) : result2;
        }
        function getMapData2(map3, key) {
          var data2 = map3.__data__;
          return isKeyable2(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
        }
        function getMatchData(object2) {
          var result2 = keys2(object2), length2 = result2.length;
          while (length2--) {
            var key = result2[length2], value = object2[key];
            result2[length2] = [key, value, isStrictComparable(value)];
          }
          return result2;
        }
        function getNative2(object2, key) {
          var value = getValue2(object2, key);
          return baseIsNative2(value) ? value : undefined$12;
        }
        function getRawTag2(value) {
          var isOwn = hasOwnProperty2.call(value, symToStringTag2), tag = value[symToStringTag2];
          try {
            value[symToStringTag2] = undefined$12;
            var unmasked = true;
          } catch (e3) {
          }
          var result2 = nativeObjectToString2.call(value);
          if (unmasked) {
            if (isOwn) {
              value[symToStringTag2] = tag;
            } else {
              delete value[symToStringTag2];
            }
          }
          return result2;
        }
        var getSymbols2 = !nativeGetSymbols2 ? stubArray2 : function(object2) {
          if (object2 == null) {
            return [];
          }
          object2 = Object2(object2);
          return arrayFilter2(nativeGetSymbols2(object2), function(symbol) {
            return propertyIsEnumerable2.call(object2, symbol);
          });
        };
        var getSymbolsIn2 = !nativeGetSymbols2 ? stubArray2 : function(object2) {
          var result2 = [];
          while (object2) {
            arrayPush2(result2, getSymbols2(object2));
            object2 = getPrototype2(object2);
          }
          return result2;
        };
        var getTag2 = baseGetTag2;
        if (DataView2 && getTag2(new DataView2(new ArrayBuffer(1))) != dataViewTag2 || Map2 && getTag2(new Map2()) != mapTag2 || Promise2 && getTag2(Promise2.resolve()) != promiseTag2 || Set2 && getTag2(new Set2()) != setTag2 || WeakMap2 && getTag2(new WeakMap2()) != weakMapTag2) {
          getTag2 = function(value) {
            var result2 = baseGetTag2(value), Ctor = result2 == objectTag2 ? value.constructor : undefined$12, ctorString = Ctor ? toSource2(Ctor) : "";
            if (ctorString) {
              switch (ctorString) {
                case dataViewCtorString2:
                  return dataViewTag2;
                case mapCtorString2:
                  return mapTag2;
                case promiseCtorString2:
                  return promiseTag2;
                case setCtorString2:
                  return setTag2;
                case weakMapCtorString2:
                  return weakMapTag2;
              }
            }
            return result2;
          };
        }
        function getView(start2, end2, transforms) {
          var index2 = -1, length2 = transforms.length;
          while (++index2 < length2) {
            var data2 = transforms[index2], size2 = data2.size;
            switch (data2.type) {
              case "drop":
                start2 += size2;
                break;
              case "dropRight":
                end2 -= size2;
                break;
              case "take":
                end2 = nativeMin2(end2, start2 + size2);
                break;
              case "takeRight":
                start2 = nativeMax2(start2, end2 - size2);
                break;
            }
          }
          return { "start": start2, "end": end2 };
        }
        function getWrapDetails(source) {
          var match2 = source.match(reWrapDetails);
          return match2 ? match2[1].split(reSplitDetails) : [];
        }
        function hasPath(object2, path2, hasFunc) {
          path2 = castPath2(path2, object2);
          var index2 = -1, length2 = path2.length, result2 = false;
          while (++index2 < length2) {
            var key = toKey2(path2[index2]);
            if (!(result2 = object2 != null && hasFunc(object2, key))) {
              break;
            }
            object2 = object2[key];
          }
          if (result2 || ++index2 != length2) {
            return result2;
          }
          length2 = object2 == null ? 0 : object2.length;
          return !!length2 && isLength2(length2) && isIndex2(key, length2) && (isArray2(object2) || isArguments2(object2));
        }
        function initCloneArray2(array2) {
          var length2 = array2.length, result2 = new array2.constructor(length2);
          if (length2 && typeof array2[0] == "string" && hasOwnProperty2.call(array2, "index")) {
            result2.index = array2.index;
            result2.input = array2.input;
          }
          return result2;
        }
        function initCloneObject2(object2) {
          return typeof object2.constructor == "function" && !isPrototype2(object2) ? baseCreate2(getPrototype2(object2)) : {};
        }
        function initCloneByTag2(object2, tag, isDeep) {
          var Ctor = object2.constructor;
          switch (tag) {
            case arrayBufferTag2:
              return cloneArrayBuffer2(object2);
            case boolTag2:
            case dateTag2:
              return new Ctor(+object2);
            case dataViewTag2:
              return cloneDataView2(object2, isDeep);
            case float32Tag2:
            case float64Tag2:
            case int8Tag2:
            case int16Tag2:
            case int32Tag2:
            case uint8Tag2:
            case uint8ClampedTag2:
            case uint16Tag2:
            case uint32Tag2:
              return cloneTypedArray2(object2, isDeep);
            case mapTag2:
              return new Ctor();
            case numberTag2:
            case stringTag2:
              return new Ctor(object2);
            case regexpTag2:
              return cloneRegExp2(object2);
            case setTag2:
              return new Ctor();
            case symbolTag2:
              return cloneSymbol2(object2);
          }
        }
        function insertWrapDetails(source, details) {
          var length2 = details.length;
          if (!length2) {
            return source;
          }
          var lastIndex = length2 - 1;
          details[lastIndex] = (length2 > 1 ? "& " : "") + details[lastIndex];
          details = details.join(length2 > 2 ? ", " : " ");
          return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
        }
        function isFlattenable(value) {
          return isArray2(value) || isArguments2(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
        }
        function isIndex2(value, length2) {
          var type = typeof value;
          length2 = length2 == null ? MAX_SAFE_INTEGER2 : length2;
          return !!length2 && (type == "number" || type != "symbol" && reIsUint2.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
        }
        function isIterateeCall(value, index2, object2) {
          if (!isObject2(object2)) {
            return false;
          }
          var type = typeof index2;
          if (type == "number" ? isArrayLike2(object2) && isIndex2(index2, object2.length) : type == "string" && index2 in object2) {
            return eq2(object2[index2], value);
          }
          return false;
        }
        function isKey2(value, object2) {
          if (isArray2(value)) {
            return false;
          }
          var type = typeof value;
          if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol2(value)) {
            return true;
          }
          return reIsPlainProp2.test(value) || !reIsDeepProp2.test(value) || object2 != null && value in Object2(object2);
        }
        function isKeyable2(value) {
          var type = typeof value;
          return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
        }
        function isLaziable(func) {
          var funcName = getFuncName(func), other = lodash2[funcName];
          if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
            return false;
          }
          if (func === other) {
            return true;
          }
          var data2 = getData(other);
          return !!data2 && func === data2[0];
        }
        function isMasked2(func) {
          return !!maskSrcKey2 && maskSrcKey2 in func;
        }
        var isMaskable = coreJsData2 ? isFunction2 : stubFalse2;
        function isPrototype2(value) {
          var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto2;
          return value === proto2;
        }
        function isStrictComparable(value) {
          return value === value && !isObject2(value);
        }
        function matchesStrictComparable(key, srcValue) {
          return function(object2) {
            if (object2 == null) {
              return false;
            }
            return object2[key] === srcValue && (srcValue !== undefined$12 || key in Object2(object2));
          };
        }
        function memoizeCapped2(func) {
          var result2 = memoize2(func, function(key) {
            if (cache2.size === MAX_MEMOIZE_SIZE2) {
              cache2.clear();
            }
            return key;
          });
          var cache2 = result2.cache;
          return result2;
        }
        function mergeData(data2, source) {
          var bitmask = data2[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
          var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data2[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
          if (!(isCommon || isCombo)) {
            return data2;
          }
          if (srcBitmask & WRAP_BIND_FLAG) {
            data2[2] = source[2];
            newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
          }
          var value = source[3];
          if (value) {
            var partials = data2[3];
            data2[3] = partials ? composeArgs(partials, value, source[4]) : value;
            data2[4] = partials ? replaceHolders(data2[3], PLACEHOLDER) : source[4];
          }
          value = source[5];
          if (value) {
            partials = data2[5];
            data2[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
            data2[6] = partials ? replaceHolders(data2[5], PLACEHOLDER) : source[6];
          }
          value = source[7];
          if (value) {
            data2[7] = value;
          }
          if (srcBitmask & WRAP_ARY_FLAG) {
            data2[8] = data2[8] == null ? source[8] : nativeMin2(data2[8], source[8]);
          }
          if (data2[9] == null) {
            data2[9] = source[9];
          }
          data2[0] = source[0];
          data2[1] = newBitmask;
          return data2;
        }
        function nativeKeysIn2(object2) {
          var result2 = [];
          if (object2 != null) {
            for (var key in Object2(object2)) {
              result2.push(key);
            }
          }
          return result2;
        }
        function objectToString2(value) {
          return nativeObjectToString2.call(value);
        }
        function overRest(func, start2, transform2) {
          start2 = nativeMax2(start2 === undefined$12 ? func.length - 1 : start2, 0);
          return function() {
            var args = arguments, index2 = -1, length2 = nativeMax2(args.length - start2, 0), array2 = Array2(length2);
            while (++index2 < length2) {
              array2[index2] = args[start2 + index2];
            }
            index2 = -1;
            var otherArgs = Array2(start2 + 1);
            while (++index2 < start2) {
              otherArgs[index2] = args[index2];
            }
            otherArgs[start2] = transform2(array2);
            return apply(func, this, otherArgs);
          };
        }
        function parent(object2, path2) {
          return path2.length < 2 ? object2 : baseGet2(object2, baseSlice(path2, 0, -1));
        }
        function reorder(array2, indexes2) {
          var arrLength = array2.length, length2 = nativeMin2(indexes2.length, arrLength), oldArray = copyArray2(array2);
          while (length2--) {
            var index2 = indexes2[length2];
            array2[length2] = isIndex2(index2, arrLength) ? oldArray[index2] : undefined$12;
          }
          return array2;
        }
        function safeGet(object2, key) {
          if (key === "constructor" && typeof object2[key] === "function") {
            return;
          }
          if (key == "__proto__") {
            return;
          }
          return object2[key];
        }
        var setData = shortOut(baseSetData);
        var setTimeout2 = ctxSetTimeout || function(func, wait) {
          return root2.setTimeout(func, wait);
        };
        var setToString = shortOut(baseSetToString);
        function setWrapToString(wrapper, reference2, bitmask) {
          var source = reference2 + "";
          return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
        }
        function shortOut(func) {
          var count2 = 0, lastCalled = 0;
          return function() {
            var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
            lastCalled = stamp;
            if (remaining > 0) {
              if (++count2 >= HOT_COUNT) {
                return arguments[0];
              }
            } else {
              count2 = 0;
            }
            return func.apply(undefined$12, arguments);
          };
        }
        function shuffleSelf(array2, size2) {
          var index2 = -1, length2 = array2.length, lastIndex = length2 - 1;
          size2 = size2 === undefined$12 ? length2 : size2;
          while (++index2 < size2) {
            var rand = baseRandom(index2, lastIndex), value = array2[rand];
            array2[rand] = array2[index2];
            array2[index2] = value;
          }
          array2.length = size2;
          return array2;
        }
        var stringToPath2 = memoizeCapped2(function(string2) {
          var result2 = [];
          if (string2.charCodeAt(0) === 46) {
            result2.push("");
          }
          string2.replace(rePropName2, function(match2, number2, quote2, subString) {
            result2.push(quote2 ? subString.replace(reEscapeChar2, "$1") : number2 || match2);
          });
          return result2;
        });
        function toKey2(value) {
          if (typeof value == "string" || isSymbol2(value)) {
            return value;
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY2 ? "-0" : result2;
        }
        function toSource2(func) {
          if (func != null) {
            try {
              return funcToString2.call(func);
            } catch (e3) {
            }
            try {
              return func + "";
            } catch (e3) {
            }
          }
          return "";
        }
        function updateWrapDetails(details, bitmask) {
          arrayEach2(wrapFlags, function(pair2) {
            var value = "_." + pair2[0];
            if (bitmask & pair2[1] && !arrayIncludes(details, value)) {
              details.push(value);
            }
          });
          return details.sort();
        }
        function wrapperClone(wrapper) {
          if (wrapper instanceof LazyWrapper) {
            return wrapper.clone();
          }
          var result2 = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
          result2.__actions__ = copyArray2(wrapper.__actions__);
          result2.__index__ = wrapper.__index__;
          result2.__values__ = wrapper.__values__;
          return result2;
        }
        function chunk(array2, size2, guard2) {
          if (guard2 ? isIterateeCall(array2, size2, guard2) : size2 === undefined$12) {
            size2 = 1;
          } else {
            size2 = nativeMax2(toInteger2(size2), 0);
          }
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2 || size2 < 1) {
            return [];
          }
          var index2 = 0, resIndex = 0, result2 = Array2(nativeCeil(length2 / size2));
          while (index2 < length2) {
            result2[resIndex++] = baseSlice(array2, index2, index2 += size2);
          }
          return result2;
        }
        function compact2(array2) {
          var index2 = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result2 = [];
          while (++index2 < length2) {
            var value = array2[index2];
            if (value) {
              result2[resIndex++] = value;
            }
          }
          return result2;
        }
        function concat() {
          var length2 = arguments.length;
          if (!length2) {
            return [];
          }
          var args = Array2(length2 - 1), array2 = arguments[0], index2 = length2;
          while (index2--) {
            args[index2 - 1] = arguments[index2];
          }
          return arrayPush2(isArray2(array2) ? copyArray2(array2) : [array2], baseFlatten(args, 1));
        }
        var difference2 = baseRest(function(array2, values2) {
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
        });
        var differenceBy = baseRest(function(array2, values2) {
          var iteratee2 = last(values2);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
        });
        var differenceWith = baseRest(function(array2, values2) {
          var comparator = last(values2);
          if (isArrayLikeObject(comparator)) {
            comparator = undefined$12;
          }
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true), undefined$12, comparator) : [];
        });
        function drop(array2, n2, guard2) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          return baseSlice(array2, n2 < 0 ? 0 : n2, length2);
        }
        function dropRight(array2, n2, guard2) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          n2 = length2 - n2;
          return baseSlice(array2, 0, n2 < 0 ? 0 : n2);
        }
        function dropRightWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), true, true) : [];
        }
        function dropWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), true) : [];
        }
        function fill(array2, value, start2, end2) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          if (start2 && typeof start2 != "number" && isIterateeCall(array2, value, start2)) {
            start2 = 0;
            end2 = length2;
          }
          return baseFill(array2, value, start2, end2);
        }
        function findIndex2(array2, predicate, fromIndex) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return -1;
          }
          var index2 = fromIndex == null ? 0 : toInteger2(fromIndex);
          if (index2 < 0) {
            index2 = nativeMax2(length2 + index2, 0);
          }
          return baseFindIndex(array2, getIteratee(predicate, 3), index2);
        }
        function findLastIndex(array2, predicate, fromIndex) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return -1;
          }
          var index2 = length2 - 1;
          if (fromIndex !== undefined$12) {
            index2 = toInteger2(fromIndex);
            index2 = fromIndex < 0 ? nativeMax2(length2 + index2, 0) : nativeMin2(index2, length2 - 1);
          }
          return baseFindIndex(array2, getIteratee(predicate, 3), index2, true);
        }
        function flatten2(array2) {
          var length2 = array2 == null ? 0 : array2.length;
          return length2 ? baseFlatten(array2, 1) : [];
        }
        function flattenDeep(array2) {
          var length2 = array2 == null ? 0 : array2.length;
          return length2 ? baseFlatten(array2, INFINITY2) : [];
        }
        function flattenDepth(array2, depth) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          depth = depth === undefined$12 ? 1 : toInteger2(depth);
          return baseFlatten(array2, depth);
        }
        function fromPairs(pairs2) {
          var index2 = -1, length2 = pairs2 == null ? 0 : pairs2.length, result2 = {};
          while (++index2 < length2) {
            var pair2 = pairs2[index2];
            result2[pair2[0]] = pair2[1];
          }
          return result2;
        }
        function head(array2) {
          return array2 && array2.length ? array2[0] : undefined$12;
        }
        function indexOf2(array2, value, fromIndex) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return -1;
          }
          var index2 = fromIndex == null ? 0 : toInteger2(fromIndex);
          if (index2 < 0) {
            index2 = nativeMax2(length2 + index2, 0);
          }
          return baseIndexOf(array2, value, index2);
        }
        function initial2(array2) {
          var length2 = array2 == null ? 0 : array2.length;
          return length2 ? baseSlice(array2, 0, -1) : [];
        }
        var intersection2 = baseRest(function(arrays) {
          var mapped = arrayMap2(arrays, castArrayLikeObject);
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped) : [];
        });
        var intersectionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays), mapped = arrayMap2(arrays, castArrayLikeObject);
          if (iteratee2 === last(mapped)) {
            iteratee2 = undefined$12;
          } else {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, getIteratee(iteratee2, 2)) : [];
        });
        var intersectionWith = baseRest(function(arrays) {
          var comparator = last(arrays), mapped = arrayMap2(arrays, castArrayLikeObject);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          if (comparator) {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, undefined$12, comparator) : [];
        });
        function join2(array2, separator) {
          return array2 == null ? "" : nativeJoin.call(array2, separator);
        }
        function last(array2) {
          var length2 = array2 == null ? 0 : array2.length;
          return length2 ? array2[length2 - 1] : undefined$12;
        }
        function lastIndexOf(array2, value, fromIndex) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return -1;
          }
          var index2 = length2;
          if (fromIndex !== undefined$12) {
            index2 = toInteger2(fromIndex);
            index2 = index2 < 0 ? nativeMax2(length2 + index2, 0) : nativeMin2(index2, length2 - 1);
          }
          return value === value ? strictLastIndexOf(array2, value, index2) : baseFindIndex(array2, baseIsNaN, index2, true);
        }
        function nth(array2, n2) {
          return array2 && array2.length ? baseNth(array2, toInteger2(n2)) : undefined$12;
        }
        var pull = baseRest(pullAll);
        function pullAll(array2, values2) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2) : array2;
        }
        function pullAllBy(array2, values2, iteratee2) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2, getIteratee(iteratee2, 2)) : array2;
        }
        function pullAllWith(array2, values2, comparator) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2, undefined$12, comparator) : array2;
        }
        var pullAt = flatRest(function(array2, indexes2) {
          var length2 = array2 == null ? 0 : array2.length, result2 = baseAt(array2, indexes2);
          basePullAt(array2, arrayMap2(indexes2, function(index2) {
            return isIndex2(index2, length2) ? +index2 : index2;
          }).sort(compareAscending));
          return result2;
        });
        function remove2(array2, predicate) {
          var result2 = [];
          if (!(array2 && array2.length)) {
            return result2;
          }
          var index2 = -1, indexes2 = [], length2 = array2.length;
          predicate = getIteratee(predicate, 3);
          while (++index2 < length2) {
            var value = array2[index2];
            if (predicate(value, index2, array2)) {
              result2.push(value);
              indexes2.push(index2);
            }
          }
          basePullAt(array2, indexes2);
          return result2;
        }
        function reverse2(array2) {
          return array2 == null ? array2 : nativeReverse.call(array2);
        }
        function slice2(array2, start2, end2) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          if (end2 && typeof end2 != "number" && isIterateeCall(array2, start2, end2)) {
            start2 = 0;
            end2 = length2;
          } else {
            start2 = start2 == null ? 0 : toInteger2(start2);
            end2 = end2 === undefined$12 ? length2 : toInteger2(end2);
          }
          return baseSlice(array2, start2, end2);
        }
        function sortedIndex(array2, value) {
          return baseSortedIndex(array2, value);
        }
        function sortedIndexBy(array2, value, iteratee2) {
          return baseSortedIndexBy(array2, value, getIteratee(iteratee2, 2));
        }
        function sortedIndexOf(array2, value) {
          var length2 = array2 == null ? 0 : array2.length;
          if (length2) {
            var index2 = baseSortedIndex(array2, value);
            if (index2 < length2 && eq2(array2[index2], value)) {
              return index2;
            }
          }
          return -1;
        }
        function sortedLastIndex(array2, value) {
          return baseSortedIndex(array2, value, true);
        }
        function sortedLastIndexBy(array2, value, iteratee2) {
          return baseSortedIndexBy(array2, value, getIteratee(iteratee2, 2), true);
        }
        function sortedLastIndexOf(array2, value) {
          var length2 = array2 == null ? 0 : array2.length;
          if (length2) {
            var index2 = baseSortedIndex(array2, value, true) - 1;
            if (eq2(array2[index2], value)) {
              return index2;
            }
          }
          return -1;
        }
        function sortedUniq(array2) {
          return array2 && array2.length ? baseSortedUniq(array2) : [];
        }
        function sortedUniqBy(array2, iteratee2) {
          return array2 && array2.length ? baseSortedUniq(array2, getIteratee(iteratee2, 2)) : [];
        }
        function tail(array2) {
          var length2 = array2 == null ? 0 : array2.length;
          return length2 ? baseSlice(array2, 1, length2) : [];
        }
        function take2(array2, n2, guard2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          return baseSlice(array2, 0, n2 < 0 ? 0 : n2);
        }
        function takeRight(array2, n2, guard2) {
          var length2 = array2 == null ? 0 : array2.length;
          if (!length2) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          n2 = length2 - n2;
          return baseSlice(array2, n2 < 0 ? 0 : n2, length2);
        }
        function takeRightWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), false, true) : [];
        }
        function takeWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3)) : [];
        }
        var union2 = baseRest(function(arrays) {
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
        });
        var unionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2));
        });
        var unionWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined$12, comparator);
        });
        function uniq(array2) {
          return array2 && array2.length ? baseUniq(array2) : [];
        }
        function uniqBy(array2, iteratee2) {
          return array2 && array2.length ? baseUniq(array2, getIteratee(iteratee2, 2)) : [];
        }
        function uniqWith(array2, comparator) {
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return array2 && array2.length ? baseUniq(array2, undefined$12, comparator) : [];
        }
        function unzip(array2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          var length2 = 0;
          array2 = arrayFilter2(array2, function(group2) {
            if (isArrayLikeObject(group2)) {
              length2 = nativeMax2(group2.length, length2);
              return true;
            }
          });
          return baseTimes2(length2, function(index2) {
            return arrayMap2(array2, baseProperty(index2));
          });
        }
        function unzipWith(array2, iteratee2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          var result2 = unzip(array2);
          if (iteratee2 == null) {
            return result2;
          }
          return arrayMap2(result2, function(group2) {
            return apply(iteratee2, undefined$12, group2);
          });
        }
        var without2 = baseRest(function(array2, values2) {
          return isArrayLikeObject(array2) ? baseDifference(array2, values2) : [];
        });
        var xor2 = baseRest(function(arrays) {
          return baseXor(arrayFilter2(arrays, isArrayLikeObject));
        });
        var xorBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return baseXor(arrayFilter2(arrays, isArrayLikeObject), getIteratee(iteratee2, 2));
        });
        var xorWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return baseXor(arrayFilter2(arrays, isArrayLikeObject), undefined$12, comparator);
        });
        var zip2 = baseRest(unzip);
        function zipObject(props, values2) {
          return baseZipObject(props || [], values2 || [], assignValue2);
        }
        function zipObjectDeep(props, values2) {
          return baseZipObject(props || [], values2 || [], baseSet2);
        }
        var zipWith = baseRest(function(arrays) {
          var length2 = arrays.length, iteratee2 = length2 > 1 ? arrays[length2 - 1] : undefined$12;
          iteratee2 = typeof iteratee2 == "function" ? (arrays.pop(), iteratee2) : undefined$12;
          return unzipWith(arrays, iteratee2);
        });
        function chain2(value) {
          var result2 = lodash2(value);
          result2.__chain__ = true;
          return result2;
        }
        function tap(value, interceptor) {
          interceptor(value);
          return value;
        }
        function thru(value, interceptor) {
          return interceptor(value);
        }
        var wrapperAt = flatRest(function(paths) {
          var length2 = paths.length, start2 = length2 ? paths[0] : 0, value = this.__wrapped__, interceptor = function(object2) {
            return baseAt(object2, paths);
          };
          if (length2 > 1 || this.__actions__.length || !(value instanceof LazyWrapper) || !isIndex2(start2)) {
            return this.thru(interceptor);
          }
          value = value.slice(start2, +start2 + (length2 ? 1 : 0));
          value.__actions__.push({
            "func": thru,
            "args": [interceptor],
            "thisArg": undefined$12
          });
          return new LodashWrapper(value, this.__chain__).thru(function(array2) {
            if (length2 && !array2.length) {
              array2.push(undefined$12);
            }
            return array2;
          });
        });
        function wrapperChain() {
          return chain2(this);
        }
        function wrapperCommit() {
          return new LodashWrapper(this.value(), this.__chain__);
        }
        function wrapperNext() {
          if (this.__values__ === undefined$12) {
            this.__values__ = toArray2(this.value());
          }
          var done = this.__index__ >= this.__values__.length, value = done ? undefined$12 : this.__values__[this.__index__++];
          return { "done": done, "value": value };
        }
        function wrapperToIterator() {
          return this;
        }
        function wrapperPlant(value) {
          var result2, parent2 = this;
          while (parent2 instanceof baseLodash) {
            var clone3 = wrapperClone(parent2);
            clone3.__index__ = 0;
            clone3.__values__ = undefined$12;
            if (result2) {
              previous2.__wrapped__ = clone3;
            } else {
              result2 = clone3;
            }
            var previous2 = clone3;
            parent2 = parent2.__wrapped__;
          }
          previous2.__wrapped__ = value;
          return result2;
        }
        function wrapperReverse() {
          var value = this.__wrapped__;
          if (value instanceof LazyWrapper) {
            var wrapped = value;
            if (this.__actions__.length) {
              wrapped = new LazyWrapper(this);
            }
            wrapped = wrapped.reverse();
            wrapped.__actions__.push({
              "func": thru,
              "args": [reverse2],
              "thisArg": undefined$12
            });
            return new LodashWrapper(wrapped, this.__chain__);
          }
          return this.thru(reverse2);
        }
        function wrapperValue() {
          return baseWrapperValue(this.__wrapped__, this.__actions__);
        }
        var countBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty2.call(result2, key)) {
            ++result2[key];
          } else {
            baseAssignValue2(result2, key, 1);
          }
        });
        function every2(collection2, predicate, guard2) {
          var func = isArray2(collection2) ? arrayEvery : baseEvery;
          if (guard2 && isIterateeCall(collection2, predicate, guard2)) {
            predicate = undefined$12;
          }
          return func(collection2, getIteratee(predicate, 3));
        }
        function filter2(collection2, predicate) {
          var func = isArray2(collection2) ? arrayFilter2 : baseFilter;
          return func(collection2, getIteratee(predicate, 3));
        }
        var find2 = createFind(findIndex2);
        var findLast = createFind(findLastIndex);
        function flatMap(collection2, iteratee2) {
          return baseFlatten(map2(collection2, iteratee2), 1);
        }
        function flatMapDeep(collection2, iteratee2) {
          return baseFlatten(map2(collection2, iteratee2), INFINITY2);
        }
        function flatMapDepth(collection2, iteratee2, depth) {
          depth = depth === undefined$12 ? 1 : toInteger2(depth);
          return baseFlatten(map2(collection2, iteratee2), depth);
        }
        function forEach(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayEach2 : baseEach;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        function forEachRight(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayEachRight : baseEachRight;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        var groupBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty2.call(result2, key)) {
            result2[key].push(value);
          } else {
            baseAssignValue2(result2, key, [value]);
          }
        });
        function includes(collection2, value, fromIndex, guard2) {
          collection2 = isArrayLike2(collection2) ? collection2 : values(collection2);
          fromIndex = fromIndex && !guard2 ? toInteger2(fromIndex) : 0;
          var length2 = collection2.length;
          if (fromIndex < 0) {
            fromIndex = nativeMax2(length2 + fromIndex, 0);
          }
          return isString2(collection2) ? fromIndex <= length2 && collection2.indexOf(value, fromIndex) > -1 : !!length2 && baseIndexOf(collection2, value, fromIndex) > -1;
        }
        var invokeMap = baseRest(function(collection2, path2, args) {
          var index2 = -1, isFunc = typeof path2 == "function", result2 = isArrayLike2(collection2) ? Array2(collection2.length) : [];
          baseEach(collection2, function(value) {
            result2[++index2] = isFunc ? apply(path2, value, args) : baseInvoke(value, path2, args);
          });
          return result2;
        });
        var keyBy = createAggregator(function(result2, value, key) {
          baseAssignValue2(result2, key, value);
        });
        function map2(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayMap2 : baseMap;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        function orderBy(collection2, iteratees, orders, guard2) {
          if (collection2 == null) {
            return [];
          }
          if (!isArray2(iteratees)) {
            iteratees = iteratees == null ? [] : [iteratees];
          }
          orders = guard2 ? undefined$12 : orders;
          if (!isArray2(orders)) {
            orders = orders == null ? [] : [orders];
          }
          return baseOrderBy(collection2, iteratees, orders);
        }
        var partition = createAggregator(function(result2, value, key) {
          result2[key ? 0 : 1].push(value);
        }, function() {
          return [[], []];
        });
        function reduce2(collection2, iteratee2, accumulator) {
          var func = isArray2(collection2) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
          return func(collection2, getIteratee(iteratee2, 4), accumulator, initAccum, baseEach);
        }
        function reduceRight(collection2, iteratee2, accumulator) {
          var func = isArray2(collection2) ? arrayReduceRight : baseReduce, initAccum = arguments.length < 3;
          return func(collection2, getIteratee(iteratee2, 4), accumulator, initAccum, baseEachRight);
        }
        function reject(collection2, predicate) {
          var func = isArray2(collection2) ? arrayFilter2 : baseFilter;
          return func(collection2, negate(getIteratee(predicate, 3)));
        }
        function sample(collection2) {
          var func = isArray2(collection2) ? arraySample : baseSample;
          return func(collection2);
        }
        function sampleSize(collection2, n2, guard2) {
          if (guard2 ? isIterateeCall(collection2, n2, guard2) : n2 === undefined$12) {
            n2 = 1;
          } else {
            n2 = toInteger2(n2);
          }
          var func = isArray2(collection2) ? arraySampleSize : baseSampleSize;
          return func(collection2, n2);
        }
        function shuffle2(collection2) {
          var func = isArray2(collection2) ? arrayShuffle : baseShuffle;
          return func(collection2);
        }
        function size(collection2) {
          if (collection2 == null) {
            return 0;
          }
          if (isArrayLike2(collection2)) {
            return isString2(collection2) ? stringSize(collection2) : collection2.length;
          }
          var tag = getTag2(collection2);
          if (tag == mapTag2 || tag == setTag2) {
            return collection2.size;
          }
          return baseKeys2(collection2).length;
        }
        function some2(collection2, predicate, guard2) {
          var func = isArray2(collection2) ? arraySome2 : baseSome;
          if (guard2 && isIterateeCall(collection2, predicate, guard2)) {
            predicate = undefined$12;
          }
          return func(collection2, getIteratee(predicate, 3));
        }
        var sortBy = baseRest(function(collection2, iteratees) {
          if (collection2 == null) {
            return [];
          }
          var length2 = iteratees.length;
          if (length2 > 1 && isIterateeCall(collection2, iteratees[0], iteratees[1])) {
            iteratees = [];
          } else if (length2 > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
            iteratees = [iteratees[0]];
          }
          return baseOrderBy(collection2, baseFlatten(iteratees, 1), []);
        });
        var now2 = ctxNow || function() {
          return root2.Date.now();
        };
        function after(n2, func) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          n2 = toInteger2(n2);
          return function() {
            if (--n2 < 1) {
              return func.apply(this, arguments);
            }
          };
        }
        function ary(func, n2, guard2) {
          n2 = guard2 ? undefined$12 : n2;
          n2 = func && n2 == null ? func.length : n2;
          return createWrap(func, WRAP_ARY_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, n2);
        }
        function before(n2, func) {
          var result2;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          n2 = toInteger2(n2);
          return function() {
            if (--n2 > 0) {
              result2 = func.apply(this, arguments);
            }
            if (n2 <= 1) {
              func = undefined$12;
            }
            return result2;
          };
        }
        var bind2 = baseRest(function(func, thisArg, partials) {
          var bitmask = WRAP_BIND_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bind2));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(func, bitmask, thisArg, partials, holders);
        });
        var bindKey2 = baseRest(function(object2, key, partials) {
          var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bindKey2));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(key, bitmask, object2, partials, holders);
        });
        function curry2(func, arity, guard2) {
          arity = guard2 ? undefined$12 : arity;
          var result2 = createWrap(func, WRAP_CURRY_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, undefined$12, arity);
          result2.placeholder = curry2.placeholder;
          return result2;
        }
        function curryRight(func, arity, guard2) {
          arity = guard2 ? undefined$12 : arity;
          var result2 = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, undefined$12, arity);
          result2.placeholder = curryRight.placeholder;
          return result2;
        }
        function debounce2(func, wait, options) {
          var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          wait = toNumber2(wait) || 0;
          if (isObject2(options)) {
            leading = !!options.leading;
            maxing = "maxWait" in options;
            maxWait = maxing ? nativeMax2(toNumber2(options.maxWait) || 0, wait) : maxWait;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          function invokeFunc(time) {
            var args = lastArgs, thisArg = lastThis;
            lastArgs = lastThis = undefined$12;
            lastInvokeTime = time;
            result2 = func.apply(thisArg, args);
            return result2;
          }
          function leadingEdge(time) {
            lastInvokeTime = time;
            timerId = setTimeout2(timerExpired, wait);
            return leading ? invokeFunc(time) : result2;
          }
          function remainingWait(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
            return maxing ? nativeMin2(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
          }
          function shouldInvoke(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
            return lastCallTime === undefined$12 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
          }
          function timerExpired() {
            var time = now2();
            if (shouldInvoke(time)) {
              return trailingEdge(time);
            }
            timerId = setTimeout2(timerExpired, remainingWait(time));
          }
          function trailingEdge(time) {
            timerId = undefined$12;
            if (trailing && lastArgs) {
              return invokeFunc(time);
            }
            lastArgs = lastThis = undefined$12;
            return result2;
          }
          function cancel() {
            if (timerId !== undefined$12) {
              clearTimeout2(timerId);
            }
            lastInvokeTime = 0;
            lastArgs = lastCallTime = lastThis = timerId = undefined$12;
          }
          function flush() {
            return timerId === undefined$12 ? result2 : trailingEdge(now2());
          }
          function debounced() {
            var time = now2(), isInvoking = shouldInvoke(time);
            lastArgs = arguments;
            lastThis = this;
            lastCallTime = time;
            if (isInvoking) {
              if (timerId === undefined$12) {
                return leadingEdge(lastCallTime);
              }
              if (maxing) {
                clearTimeout2(timerId);
                timerId = setTimeout2(timerExpired, wait);
                return invokeFunc(lastCallTime);
              }
            }
            if (timerId === undefined$12) {
              timerId = setTimeout2(timerExpired, wait);
            }
            return result2;
          }
          debounced.cancel = cancel;
          debounced.flush = flush;
          return debounced;
        }
        var defer = baseRest(function(func, args) {
          return baseDelay(func, 1, args);
        });
        var delay = baseRest(function(func, wait, args) {
          return baseDelay(func, toNumber2(wait) || 0, args);
        });
        function flip2(func) {
          return createWrap(func, WRAP_FLIP_FLAG);
        }
        function memoize2(func, resolver2) {
          if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          var memoized = function() {
            var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache2 = memoized.cache;
            if (cache2.has(key)) {
              return cache2.get(key);
            }
            var result2 = func.apply(this, args);
            memoized.cache = cache2.set(key, result2) || cache2;
            return result2;
          };
          memoized.cache = new (memoize2.Cache || MapCache2)();
          return memoized;
        }
        memoize2.Cache = MapCache2;
        function negate(predicate) {
          if (typeof predicate != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return !predicate.call(this);
              case 1:
                return !predicate.call(this, args[0]);
              case 2:
                return !predicate.call(this, args[0], args[1]);
              case 3:
                return !predicate.call(this, args[0], args[1], args[2]);
            }
            return !predicate.apply(this, args);
          };
        }
        function once2(func) {
          return before(2, func);
        }
        var overArgs = castRest(function(func, transforms) {
          transforms = transforms.length == 1 && isArray2(transforms[0]) ? arrayMap2(transforms[0], baseUnary2(getIteratee())) : arrayMap2(baseFlatten(transforms, 1), baseUnary2(getIteratee()));
          var funcsLength = transforms.length;
          return baseRest(function(args) {
            var index2 = -1, length2 = nativeMin2(args.length, funcsLength);
            while (++index2 < length2) {
              args[index2] = transforms[index2].call(this, args[index2]);
            }
            return apply(func, this, args);
          });
        });
        var partial = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partial));
          return createWrap(func, WRAP_PARTIAL_FLAG, undefined$12, partials, holders);
        });
        var partialRight = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partialRight));
          return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined$12, partials, holders);
        });
        var rearg = flatRest(function(func, indexes2) {
          return createWrap(func, WRAP_REARG_FLAG, undefined$12, undefined$12, undefined$12, indexes2);
        });
        function rest(func, start2) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          start2 = start2 === undefined$12 ? start2 : toInteger2(start2);
          return baseRest(func, start2);
        }
        function spread(func, start2) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          start2 = start2 == null ? 0 : nativeMax2(toInteger2(start2), 0);
          return baseRest(function(args) {
            var array2 = args[start2], otherArgs = castSlice(args, 0, start2);
            if (array2) {
              arrayPush2(otherArgs, array2);
            }
            return apply(func, this, otherArgs);
          });
        }
        function throttle2(func, wait, options) {
          var leading = true, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          if (isObject2(options)) {
            leading = "leading" in options ? !!options.leading : leading;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          return debounce2(func, wait, {
            "leading": leading,
            "maxWait": wait,
            "trailing": trailing
          });
        }
        function unary(func) {
          return ary(func, 1);
        }
        function wrap2(value, wrapper) {
          return partial(castFunction(wrapper), value);
        }
        function castArray2() {
          if (!arguments.length) {
            return [];
          }
          var value = arguments[0];
          return isArray2(value) ? value : [value];
        }
        function clone2(value) {
          return baseClone2(value, CLONE_SYMBOLS_FLAG2);
        }
        function cloneWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseClone2(value, CLONE_SYMBOLS_FLAG2, customizer);
        }
        function cloneDeep2(value) {
          return baseClone2(value, CLONE_DEEP_FLAG2 | CLONE_SYMBOLS_FLAG2);
        }
        function cloneDeepWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseClone2(value, CLONE_DEEP_FLAG2 | CLONE_SYMBOLS_FLAG2, customizer);
        }
        function conformsTo(object2, source) {
          return source == null || baseConformsTo(object2, source, keys2(source));
        }
        function eq2(value, other) {
          return value === other || value !== value && other !== other;
        }
        var gt2 = createRelationalOperation(baseGt);
        var gte = createRelationalOperation(function(value, other) {
          return value >= other;
        });
        var isArguments2 = baseIsArguments2(function() {
          return arguments;
        }()) ? baseIsArguments2 : function(value) {
          return isObjectLike2(value) && hasOwnProperty2.call(value, "callee") && !propertyIsEnumerable2.call(value, "callee");
        };
        var isArray2 = Array2.isArray;
        var isArrayBuffer = nodeIsArrayBuffer ? baseUnary2(nodeIsArrayBuffer) : baseIsArrayBuffer;
        function isArrayLike2(value) {
          return value != null && isLength2(value.length) && !isFunction2(value);
        }
        function isArrayLikeObject(value) {
          return isObjectLike2(value) && isArrayLike2(value);
        }
        function isBoolean2(value) {
          return value === true || value === false || isObjectLike2(value) && baseGetTag2(value) == boolTag2;
        }
        var isBuffer2 = nativeIsBuffer || stubFalse2;
        var isDate2 = nodeIsDate ? baseUnary2(nodeIsDate) : baseIsDate;
        function isElement2(value) {
          return isObjectLike2(value) && value.nodeType === 1 && !isPlainObject2(value);
        }
        function isEmpty2(value) {
          if (value == null) {
            return true;
          }
          if (isArrayLike2(value) && (isArray2(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer2(value) || isTypedArray2(value) || isArguments2(value))) {
            return !value.length;
          }
          var tag = getTag2(value);
          if (tag == mapTag2 || tag == setTag2) {
            return !value.size;
          }
          if (isPrototype2(value)) {
            return !baseKeys2(value).length;
          }
          for (var key in value) {
            if (hasOwnProperty2.call(value, key)) {
              return false;
            }
          }
          return true;
        }
        function isEqual2(value, other) {
          return baseIsEqual2(value, other);
        }
        function isEqualWith(value, other, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          var result2 = customizer ? customizer(value, other) : undefined$12;
          return result2 === undefined$12 ? baseIsEqual2(value, other, undefined$12, customizer) : !!result2;
        }
        function isError2(value) {
          if (!isObjectLike2(value)) {
            return false;
          }
          var tag = baseGetTag2(value);
          return tag == errorTag2 || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !isPlainObject2(value);
        }
        function isFinite2(value) {
          return typeof value == "number" && nativeIsFinite2(value);
        }
        function isFunction2(value) {
          if (!isObject2(value)) {
            return false;
          }
          var tag = baseGetTag2(value);
          return tag == funcTag2 || tag == genTag2 || tag == asyncTag2 || tag == proxyTag2;
        }
        function isInteger(value) {
          return typeof value == "number" && value == toInteger2(value);
        }
        function isLength2(value) {
          return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER2;
        }
        function isObject2(value) {
          var type = typeof value;
          return value != null && (type == "object" || type == "function");
        }
        function isObjectLike2(value) {
          return value != null && typeof value == "object";
        }
        var isMap2 = nodeIsMap2 ? baseUnary2(nodeIsMap2) : baseIsMap2;
        function isMatch(object2, source) {
          return object2 === source || baseIsMatch(object2, source, getMatchData(source));
        }
        function isMatchWith(object2, source, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseIsMatch(object2, source, getMatchData(source), customizer);
        }
        function isNaN2(value) {
          return isNumber2(value) && value != +value;
        }
        function isNative(value) {
          if (isMaskable(value)) {
            throw new Error2(CORE_ERROR_TEXT);
          }
          return baseIsNative2(value);
        }
        function isNull(value) {
          return value === null;
        }
        function isNil(value) {
          return value == null;
        }
        function isNumber2(value) {
          return typeof value == "number" || isObjectLike2(value) && baseGetTag2(value) == numberTag2;
        }
        function isPlainObject2(value) {
          if (!isObjectLike2(value) || baseGetTag2(value) != objectTag2) {
            return false;
          }
          var proto2 = getPrototype2(value);
          if (proto2 === null) {
            return true;
          }
          var Ctor = hasOwnProperty2.call(proto2, "constructor") && proto2.constructor;
          return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString2.call(Ctor) == objectCtorString;
        }
        var isRegExp2 = nodeIsRegExp ? baseUnary2(nodeIsRegExp) : baseIsRegExp;
        function isSafeInteger(value) {
          return isInteger(value) && value >= -MAX_SAFE_INTEGER2 && value <= MAX_SAFE_INTEGER2;
        }
        var isSet2 = nodeIsSet2 ? baseUnary2(nodeIsSet2) : baseIsSet2;
        function isString2(value) {
          return typeof value == "string" || !isArray2(value) && isObjectLike2(value) && baseGetTag2(value) == stringTag2;
        }
        function isSymbol2(value) {
          return typeof value == "symbol" || isObjectLike2(value) && baseGetTag2(value) == symbolTag2;
        }
        var isTypedArray2 = nodeIsTypedArray2 ? baseUnary2(nodeIsTypedArray2) : baseIsTypedArray2;
        function isUndefined(value) {
          return value === undefined$12;
        }
        function isWeakMap2(value) {
          return isObjectLike2(value) && getTag2(value) == weakMapTag2;
        }
        function isWeakSet2(value) {
          return isObjectLike2(value) && baseGetTag2(value) == weakSetTag;
        }
        var lt2 = createRelationalOperation(baseLt);
        var lte = createRelationalOperation(function(value, other) {
          return value <= other;
        });
        function toArray2(value) {
          if (!value) {
            return [];
          }
          if (isArrayLike2(value)) {
            return isString2(value) ? stringToArray(value) : copyArray2(value);
          }
          if (symIterator && value[symIterator]) {
            return iteratorToArray(value[symIterator]());
          }
          var tag = getTag2(value), func = tag == mapTag2 ? mapToArray2 : tag == setTag2 ? setToArray2 : values;
          return func(value);
        }
        function toFinite2(value) {
          if (!value) {
            return value === 0 ? value : 0;
          }
          value = toNumber2(value);
          if (value === INFINITY2 || value === -INFINITY2) {
            var sign2 = value < 0 ? -1 : 1;
            return sign2 * MAX_INTEGER2;
          }
          return value === value ? value : 0;
        }
        function toInteger2(value) {
          var result2 = toFinite2(value), remainder = result2 % 1;
          return result2 === result2 ? remainder ? result2 - remainder : result2 : 0;
        }
        function toLength(value) {
          return value ? baseClamp(toInteger2(value), 0, MAX_ARRAY_LENGTH) : 0;
        }
        function toNumber2(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol2(value)) {
            return NAN2;
          }
          if (isObject2(value)) {
            var other = typeof value.valueOf == "function" ? value.valueOf() : value;
            value = isObject2(other) ? other + "" : other;
          }
          if (typeof value != "string") {
            return value === 0 ? value : +value;
          }
          value = baseTrim2(value);
          var isBinary = reIsBinary2.test(value);
          return isBinary || reIsOctal2.test(value) ? freeParseInt2(value.slice(2), isBinary ? 2 : 8) : reIsBadHex2.test(value) ? NAN2 : +value;
        }
        function toPlainObject(value) {
          return copyObject2(value, keysIn2(value));
        }
        function toSafeInteger(value) {
          return value ? baseClamp(toInteger2(value), -MAX_SAFE_INTEGER2, MAX_SAFE_INTEGER2) : value === 0 ? value : 0;
        }
        function toString2(value) {
          return value == null ? "" : baseToString2(value);
        }
        var assign2 = createAssigner(function(object2, source) {
          if (isPrototype2(source) || isArrayLike2(source)) {
            copyObject2(source, keys2(source), object2);
            return;
          }
          for (var key in source) {
            if (hasOwnProperty2.call(source, key)) {
              assignValue2(object2, key, source[key]);
            }
          }
        });
        var assignIn = createAssigner(function(object2, source) {
          copyObject2(source, keysIn2(source), object2);
        });
        var assignInWith = createAssigner(function(object2, source, srcIndex, customizer) {
          copyObject2(source, keysIn2(source), object2, customizer);
        });
        var assignWith = createAssigner(function(object2, source, srcIndex, customizer) {
          copyObject2(source, keys2(source), object2, customizer);
        });
        var at2 = flatRest(baseAt);
        function create2(prototype, properties) {
          var result2 = baseCreate2(prototype);
          return properties == null ? result2 : baseAssign2(result2, properties);
        }
        var defaults2 = baseRest(function(object2, sources) {
          object2 = Object2(object2);
          var index2 = -1;
          var length2 = sources.length;
          var guard2 = length2 > 2 ? sources[2] : undefined$12;
          if (guard2 && isIterateeCall(sources[0], sources[1], guard2)) {
            length2 = 1;
          }
          while (++index2 < length2) {
            var source = sources[index2];
            var props = keysIn2(source);
            var propsIndex = -1;
            var propsLength = props.length;
            while (++propsIndex < propsLength) {
              var key = props[propsIndex];
              var value = object2[key];
              if (value === undefined$12 || eq2(value, objectProto2[key]) && !hasOwnProperty2.call(object2, key)) {
                object2[key] = source[key];
              }
            }
          }
          return object2;
        });
        var defaultsDeep = baseRest(function(args) {
          args.push(undefined$12, customDefaultsMerge);
          return apply(mergeWith, undefined$12, args);
        });
        function findKey2(object2, predicate) {
          return baseFindKey(object2, getIteratee(predicate, 3), baseForOwn);
        }
        function findLastKey(object2, predicate) {
          return baseFindKey(object2, getIteratee(predicate, 3), baseForOwnRight);
        }
        function forIn(object2, iteratee2) {
          return object2 == null ? object2 : baseFor(object2, getIteratee(iteratee2, 3), keysIn2);
        }
        function forInRight(object2, iteratee2) {
          return object2 == null ? object2 : baseForRight(object2, getIteratee(iteratee2, 3), keysIn2);
        }
        function forOwn(object2, iteratee2) {
          return object2 && baseForOwn(object2, getIteratee(iteratee2, 3));
        }
        function forOwnRight(object2, iteratee2) {
          return object2 && baseForOwnRight(object2, getIteratee(iteratee2, 3));
        }
        function functions2(object2) {
          return object2 == null ? [] : baseFunctions(object2, keys2(object2));
        }
        function functionsIn(object2) {
          return object2 == null ? [] : baseFunctions(object2, keysIn2(object2));
        }
        function get2(object2, path2, defaultValue2) {
          var result2 = object2 == null ? undefined$12 : baseGet2(object2, path2);
          return result2 === undefined$12 ? defaultValue2 : result2;
        }
        function has2(object2, path2) {
          return object2 != null && hasPath(object2, path2, baseHas);
        }
        function hasIn(object2, path2) {
          return object2 != null && hasPath(object2, path2, baseHasIn);
        }
        var invert = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString2.call(value);
          }
          result2[value] = key;
        }, constant2(identity2));
        var invertBy = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString2.call(value);
          }
          if (hasOwnProperty2.call(result2, value)) {
            result2[value].push(key);
          } else {
            result2[value] = [key];
          }
        }, getIteratee);
        var invoke = baseRest(baseInvoke);
        function keys2(object2) {
          return isArrayLike2(object2) ? arrayLikeKeys2(object2) : baseKeys2(object2);
        }
        function keysIn2(object2) {
          return isArrayLike2(object2) ? arrayLikeKeys2(object2, true) : baseKeysIn2(object2);
        }
        function mapKeys(object2, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object2, function(value, key, object3) {
            baseAssignValue2(result2, iteratee2(value, key, object3), value);
          });
          return result2;
        }
        function mapValues(object2, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object2, function(value, key, object3) {
            baseAssignValue2(result2, key, iteratee2(value, key, object3));
          });
          return result2;
        }
        var merge2 = createAssigner(function(object2, source, srcIndex) {
          baseMerge(object2, source, srcIndex);
        });
        var mergeWith = createAssigner(function(object2, source, srcIndex, customizer) {
          baseMerge(object2, source, srcIndex, customizer);
        });
        var omit = flatRest(function(object2, paths) {
          var result2 = {};
          if (object2 == null) {
            return result2;
          }
          var isDeep = false;
          paths = arrayMap2(paths, function(path2) {
            path2 = castPath2(path2, object2);
            isDeep || (isDeep = path2.length > 1);
            return path2;
          });
          copyObject2(object2, getAllKeysIn2(object2), result2);
          if (isDeep) {
            result2 = baseClone2(result2, CLONE_DEEP_FLAG2 | CLONE_FLAT_FLAG2 | CLONE_SYMBOLS_FLAG2, customOmitClone);
          }
          var length2 = paths.length;
          while (length2--) {
            baseUnset(result2, paths[length2]);
          }
          return result2;
        });
        function omitBy(object2, predicate) {
          return pickBy(object2, negate(getIteratee(predicate)));
        }
        var pick = flatRest(function(object2, paths) {
          return object2 == null ? {} : basePick(object2, paths);
        });
        function pickBy(object2, predicate) {
          if (object2 == null) {
            return {};
          }
          var props = arrayMap2(getAllKeysIn2(object2), function(prop) {
            return [prop];
          });
          predicate = getIteratee(predicate);
          return basePickBy(object2, props, function(value, path2) {
            return predicate(value, path2[0]);
          });
        }
        function result(object2, path2, defaultValue2) {
          path2 = castPath2(path2, object2);
          var index2 = -1, length2 = path2.length;
          if (!length2) {
            length2 = 1;
            object2 = undefined$12;
          }
          while (++index2 < length2) {
            var value = object2 == null ? undefined$12 : object2[toKey2(path2[index2])];
            if (value === undefined$12) {
              index2 = length2;
              value = defaultValue2;
            }
            object2 = isFunction2(value) ? value.call(object2) : value;
          }
          return object2;
        }
        function set2(object2, path2, value) {
          return object2 == null ? object2 : baseSet2(object2, path2, value);
        }
        function setWith(object2, path2, value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return object2 == null ? object2 : baseSet2(object2, path2, value, customizer);
        }
        var toPairs2 = createToPairs(keys2);
        var toPairsIn = createToPairs(keysIn2);
        function transform(object2, iteratee2, accumulator) {
          var isArr = isArray2(object2), isArrLike = isArr || isBuffer2(object2) || isTypedArray2(object2);
          iteratee2 = getIteratee(iteratee2, 4);
          if (accumulator == null) {
            var Ctor = object2 && object2.constructor;
            if (isArrLike) {
              accumulator = isArr ? new Ctor() : [];
            } else if (isObject2(object2)) {
              accumulator = isFunction2(Ctor) ? baseCreate2(getPrototype2(object2)) : {};
            } else {
              accumulator = {};
            }
          }
          (isArrLike ? arrayEach2 : baseForOwn)(object2, function(value, index2, object3) {
            return iteratee2(accumulator, value, index2, object3);
          });
          return accumulator;
        }
        function unset(object2, path2) {
          return object2 == null ? true : baseUnset(object2, path2);
        }
        function update2(object2, path2, updater) {
          return object2 == null ? object2 : baseUpdate(object2, path2, castFunction(updater));
        }
        function updateWith(object2, path2, updater, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return object2 == null ? object2 : baseUpdate(object2, path2, castFunction(updater), customizer);
        }
        function values(object2) {
          return object2 == null ? [] : baseValues(object2, keys2(object2));
        }
        function valuesIn(object2) {
          return object2 == null ? [] : baseValues(object2, keysIn2(object2));
        }
        function clamp2(number2, lower2, upper) {
          if (upper === undefined$12) {
            upper = lower2;
            lower2 = undefined$12;
          }
          if (upper !== undefined$12) {
            upper = toNumber2(upper);
            upper = upper === upper ? upper : 0;
          }
          if (lower2 !== undefined$12) {
            lower2 = toNumber2(lower2);
            lower2 = lower2 === lower2 ? lower2 : 0;
          }
          return baseClamp(toNumber2(number2), lower2, upper);
        }
        function inRange(number2, start2, end2) {
          start2 = toFinite2(start2);
          if (end2 === undefined$12) {
            end2 = start2;
            start2 = 0;
          } else {
            end2 = toFinite2(end2);
          }
          number2 = toNumber2(number2);
          return baseInRange(number2, start2, end2);
        }
        function random2(lower2, upper, floating) {
          if (floating && typeof floating != "boolean" && isIterateeCall(lower2, upper, floating)) {
            upper = floating = undefined$12;
          }
          if (floating === undefined$12) {
            if (typeof upper == "boolean") {
              floating = upper;
              upper = undefined$12;
            } else if (typeof lower2 == "boolean") {
              floating = lower2;
              lower2 = undefined$12;
            }
          }
          if (lower2 === undefined$12 && upper === undefined$12) {
            lower2 = 0;
            upper = 1;
          } else {
            lower2 = toFinite2(lower2);
            if (upper === undefined$12) {
              upper = lower2;
              lower2 = 0;
            } else {
              upper = toFinite2(upper);
            }
          }
          if (lower2 > upper) {
            var temp = lower2;
            lower2 = upper;
            upper = temp;
          }
          if (floating || lower2 % 1 || upper % 1) {
            var rand = nativeRandom();
            return nativeMin2(lower2 + rand * (upper - lower2 + freeParseFloat("1e-" + ((rand + "").length - 1))), upper);
          }
          return baseRandom(lower2, upper);
        }
        var camelCase = createCompounder(function(result2, word, index2) {
          word = word.toLowerCase();
          return result2 + (index2 ? capitalize2(word) : word);
        });
        function capitalize2(string2) {
          return upperFirst(toString2(string2).toLowerCase());
        }
        function deburr(string2) {
          string2 = toString2(string2);
          return string2 && string2.replace(reLatin, deburrLetter).replace(reComboMark, "");
        }
        function endsWith(string2, target, position2) {
          string2 = toString2(string2);
          target = baseToString2(target);
          var length2 = string2.length;
          position2 = position2 === undefined$12 ? length2 : baseClamp(toInteger2(position2), 0, length2);
          var end2 = position2;
          position2 -= target.length;
          return position2 >= 0 && string2.slice(position2, end2) == target;
        }
        function escape2(string2) {
          string2 = toString2(string2);
          return string2 && reHasUnescapedHtml.test(string2) ? string2.replace(reUnescapedHtml, escapeHtmlChar) : string2;
        }
        function escapeRegExp2(string2) {
          string2 = toString2(string2);
          return string2 && reHasRegExpChar.test(string2) ? string2.replace(reRegExpChar2, "\\$&") : string2;
        }
        var kebabCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? "-" : "") + word.toLowerCase();
        });
        var lowerCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + word.toLowerCase();
        });
        var lowerFirst = createCaseFirst("toLowerCase");
        function pad(string2, length2, chars) {
          string2 = toString2(string2);
          length2 = toInteger2(length2);
          var strLength = length2 ? stringSize(string2) : 0;
          if (!length2 || strLength >= length2) {
            return string2;
          }
          var mid = (length2 - strLength) / 2;
          return createPadding(nativeFloor(mid), chars) + string2 + createPadding(nativeCeil(mid), chars);
        }
        function padEnd(string2, length2, chars) {
          string2 = toString2(string2);
          length2 = toInteger2(length2);
          var strLength = length2 ? stringSize(string2) : 0;
          return length2 && strLength < length2 ? string2 + createPadding(length2 - strLength, chars) : string2;
        }
        function padStart(string2, length2, chars) {
          string2 = toString2(string2);
          length2 = toInteger2(length2);
          var strLength = length2 ? stringSize(string2) : 0;
          return length2 && strLength < length2 ? createPadding(length2 - strLength, chars) + string2 : string2;
        }
        function parseInt2(string2, radix, guard2) {
          if (guard2 || radix == null) {
            radix = 0;
          } else if (radix) {
            radix = +radix;
          }
          return nativeParseInt(toString2(string2).replace(reTrimStart2, ""), radix || 0);
        }
        function repeat(string2, n2, guard2) {
          if (guard2 ? isIterateeCall(string2, n2, guard2) : n2 === undefined$12) {
            n2 = 1;
          } else {
            n2 = toInteger2(n2);
          }
          return baseRepeat(toString2(string2), n2);
        }
        function replace2() {
          var args = arguments, string2 = toString2(args[0]);
          return args.length < 3 ? string2 : string2.replace(args[1], args[2]);
        }
        var snakeCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? "_" : "") + word.toLowerCase();
        });
        function split(string2, separator, limit) {
          if (limit && typeof limit != "number" && isIterateeCall(string2, separator, limit)) {
            separator = limit = undefined$12;
          }
          limit = limit === undefined$12 ? MAX_ARRAY_LENGTH : limit >>> 0;
          if (!limit) {
            return [];
          }
          string2 = toString2(string2);
          if (string2 && (typeof separator == "string" || separator != null && !isRegExp2(separator))) {
            separator = baseToString2(separator);
            if (!separator && hasUnicode(string2)) {
              return castSlice(stringToArray(string2), 0, limit);
            }
          }
          return string2.split(separator, limit);
        }
        var startCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + upperFirst(word);
        });
        function startsWith(string2, target, position2) {
          string2 = toString2(string2);
          position2 = position2 == null ? 0 : baseClamp(toInteger2(position2), 0, string2.length);
          target = baseToString2(target);
          return string2.slice(position2, position2 + target.length) == target;
        }
        function template(string2, options, guard2) {
          var settings2 = lodash2.templateSettings;
          if (guard2 && isIterateeCall(string2, options, guard2)) {
            options = undefined$12;
          }
          string2 = toString2(string2);
          options = assignInWith({}, options, settings2, customDefaultsAssignIn);
          var imports = assignInWith({}, options.imports, settings2.imports, customDefaultsAssignIn), importsKeys = keys2(imports), importsValues = baseValues(imports, importsKeys);
          var isEscaping, isEvaluating, index2 = 0, interpolate2 = options.interpolate || reNoMatch, source = "__p += '";
          var reDelimiters = RegExp2(
            (options.escape || reNoMatch).source + "|" + interpolate2.source + "|" + (interpolate2 === reInterpolate ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$",
            "g"
          );
          var sourceURL = "//# sourceURL=" + (hasOwnProperty2.call(options, "sourceURL") ? (options.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++templateCounter + "]") + "\n";
          string2.replace(reDelimiters, function(match2, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset2) {
            interpolateValue || (interpolateValue = esTemplateValue);
            source += string2.slice(index2, offset2).replace(reUnescapedString, escapeStringChar);
            if (escapeValue) {
              isEscaping = true;
              source += "' +\n__e(" + escapeValue + ") +\n'";
            }
            if (evaluateValue) {
              isEvaluating = true;
              source += "';\n" + evaluateValue + ";\n__p += '";
            }
            if (interpolateValue) {
              source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
            }
            index2 = offset2 + match2.length;
            return match2;
          });
          source += "';\n";
          var variable = hasOwnProperty2.call(options, "variable") && options.variable;
          if (!variable) {
            source = "with (obj) {\n" + source + "\n}\n";
          } else if (reForbiddenIdentifierChars.test(variable)) {
            throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT);
          }
          source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
          source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
          var result2 = attempt(function() {
            return Function2(importsKeys, sourceURL + "return " + source).apply(undefined$12, importsValues);
          });
          result2.source = source;
          if (isError2(result2)) {
            throw result2;
          }
          return result2;
        }
        function toLower(value) {
          return toString2(value).toLowerCase();
        }
        function toUpper(value) {
          return toString2(value).toUpperCase();
        }
        function trim2(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return baseTrim2(string2);
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), chrSymbols = stringToArray(chars), start2 = charsStartIndex(strSymbols, chrSymbols), end2 = charsEndIndex(strSymbols, chrSymbols) + 1;
          return castSlice(strSymbols, start2, end2).join("");
        }
        function trimEnd(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return string2.slice(0, trimmedEndIndex2(string2) + 1);
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), end2 = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
          return castSlice(strSymbols, 0, end2).join("");
        }
        function trimStart(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return string2.replace(reTrimStart2, "");
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), start2 = charsStartIndex(strSymbols, stringToArray(chars));
          return castSlice(strSymbols, start2).join("");
        }
        function truncate(string2, options) {
          var length2 = DEFAULT_TRUNC_LENGTH, omission = DEFAULT_TRUNC_OMISSION;
          if (isObject2(options)) {
            var separator = "separator" in options ? options.separator : separator;
            length2 = "length" in options ? toInteger2(options.length) : length2;
            omission = "omission" in options ? baseToString2(options.omission) : omission;
          }
          string2 = toString2(string2);
          var strLength = string2.length;
          if (hasUnicode(string2)) {
            var strSymbols = stringToArray(string2);
            strLength = strSymbols.length;
          }
          if (length2 >= strLength) {
            return string2;
          }
          var end2 = length2 - stringSize(omission);
          if (end2 < 1) {
            return omission;
          }
          var result2 = strSymbols ? castSlice(strSymbols, 0, end2).join("") : string2.slice(0, end2);
          if (separator === undefined$12) {
            return result2 + omission;
          }
          if (strSymbols) {
            end2 += result2.length - end2;
          }
          if (isRegExp2(separator)) {
            if (string2.slice(end2).search(separator)) {
              var match2, substring = result2;
              if (!separator.global) {
                separator = RegExp2(separator.source, toString2(reFlags2.exec(separator)) + "g");
              }
              separator.lastIndex = 0;
              while (match2 = separator.exec(substring)) {
                var newEnd = match2.index;
              }
              result2 = result2.slice(0, newEnd === undefined$12 ? end2 : newEnd);
            }
          } else if (string2.indexOf(baseToString2(separator), end2) != end2) {
            var index2 = result2.lastIndexOf(separator);
            if (index2 > -1) {
              result2 = result2.slice(0, index2);
            }
          }
          return result2 + omission;
        }
        function unescape2(string2) {
          string2 = toString2(string2);
          return string2 && reHasEscapedHtml.test(string2) ? string2.replace(reEscapedHtml, unescapeHtmlChar) : string2;
        }
        var upperCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + word.toUpperCase();
        });
        var upperFirst = createCaseFirst("toUpperCase");
        function words(string2, pattern, guard2) {
          string2 = toString2(string2);
          pattern = guard2 ? undefined$12 : pattern;
          if (pattern === undefined$12) {
            return hasUnicodeWord(string2) ? unicodeWords(string2) : asciiWords(string2);
          }
          return string2.match(pattern) || [];
        }
        var attempt = baseRest(function(func, args) {
          try {
            return apply(func, undefined$12, args);
          } catch (e3) {
            return isError2(e3) ? e3 : new Error2(e3);
          }
        });
        var bindAll = flatRest(function(object2, methodNames) {
          arrayEach2(methodNames, function(key) {
            key = toKey2(key);
            baseAssignValue2(object2, key, bind2(object2[key], object2));
          });
          return object2;
        });
        function cond(pairs2) {
          var length2 = pairs2 == null ? 0 : pairs2.length, toIteratee = getIteratee();
          pairs2 = !length2 ? [] : arrayMap2(pairs2, function(pair2) {
            if (typeof pair2[1] != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT2);
            }
            return [toIteratee(pair2[0]), pair2[1]];
          });
          return baseRest(function(args) {
            var index2 = -1;
            while (++index2 < length2) {
              var pair2 = pairs2[index2];
              if (apply(pair2[0], this, args)) {
                return apply(pair2[1], this, args);
              }
            }
          });
        }
        function conforms(source) {
          return baseConforms(baseClone2(source, CLONE_DEEP_FLAG2));
        }
        function constant2(value) {
          return function() {
            return value;
          };
        }
        function defaultTo(value, defaultValue2) {
          return value == null || value !== value ? defaultValue2 : value;
        }
        var flow2 = createFlow();
        var flowRight = createFlow(true);
        function identity2(value) {
          return value;
        }
        function iteratee(func) {
          return baseIteratee(typeof func == "function" ? func : baseClone2(func, CLONE_DEEP_FLAG2));
        }
        function matches2(source) {
          return baseMatches(baseClone2(source, CLONE_DEEP_FLAG2));
        }
        function matchesProperty(path2, srcValue) {
          return baseMatchesProperty(path2, baseClone2(srcValue, CLONE_DEEP_FLAG2));
        }
        var method = baseRest(function(path2, args) {
          return function(object2) {
            return baseInvoke(object2, path2, args);
          };
        });
        var methodOf = baseRest(function(object2, args) {
          return function(path2) {
            return baseInvoke(object2, path2, args);
          };
        });
        function mixin2(object2, source, options) {
          var props = keys2(source), methodNames = baseFunctions(source, props);
          if (options == null && !(isObject2(source) && (methodNames.length || !props.length))) {
            options = source;
            source = object2;
            object2 = this;
            methodNames = baseFunctions(source, keys2(source));
          }
          var chain3 = !(isObject2(options) && "chain" in options) || !!options.chain, isFunc = isFunction2(object2);
          arrayEach2(methodNames, function(methodName) {
            var func = source[methodName];
            object2[methodName] = func;
            if (isFunc) {
              object2.prototype[methodName] = function() {
                var chainAll = this.__chain__;
                if (chain3 || chainAll) {
                  var result2 = object2(this.__wrapped__), actions = result2.__actions__ = copyArray2(this.__actions__);
                  actions.push({ "func": func, "args": arguments, "thisArg": object2 });
                  result2.__chain__ = chainAll;
                  return result2;
                }
                return func.apply(object2, arrayPush2([this.value()], arguments));
              };
            }
          });
          return object2;
        }
        function noConflict() {
          if (root2._ === this) {
            root2._ = oldDash;
          }
          return this;
        }
        function noop2() {
        }
        function nthArg(n2) {
          n2 = toInteger2(n2);
          return baseRest(function(args) {
            return baseNth(args, n2);
          });
        }
        var over = createOver(arrayMap2);
        var overEvery = createOver(arrayEvery);
        var overSome = createOver(arraySome2);
        function property(path2) {
          return isKey2(path2) ? baseProperty(toKey2(path2)) : basePropertyDeep(path2);
        }
        function propertyOf(object2) {
          return function(path2) {
            return object2 == null ? undefined$12 : baseGet2(object2, path2);
          };
        }
        var range2 = createRange();
        var rangeRight = createRange(true);
        function stubArray2() {
          return [];
        }
        function stubFalse2() {
          return false;
        }
        function stubObject() {
          return {};
        }
        function stubString() {
          return "";
        }
        function stubTrue() {
          return true;
        }
        function times(n2, iteratee2) {
          n2 = toInteger2(n2);
          if (n2 < 1 || n2 > MAX_SAFE_INTEGER2) {
            return [];
          }
          var index2 = MAX_ARRAY_LENGTH, length2 = nativeMin2(n2, MAX_ARRAY_LENGTH);
          iteratee2 = getIteratee(iteratee2);
          n2 -= MAX_ARRAY_LENGTH;
          var result2 = baseTimes2(length2, iteratee2);
          while (++index2 < n2) {
            iteratee2(index2);
          }
          return result2;
        }
        function toPath2(value) {
          if (isArray2(value)) {
            return arrayMap2(value, toKey2);
          }
          return isSymbol2(value) ? [value] : copyArray2(stringToPath2(toString2(value)));
        }
        function uniqueId(prefix) {
          var id2 = ++idCounter2;
          return toString2(prefix) + id2;
        }
        var add2 = createMathOperation(function(augend, addend) {
          return augend + addend;
        }, 0);
        var ceil = createRound2("ceil");
        var divide = createMathOperation(function(dividend, divisor) {
          return dividend / divisor;
        }, 1);
        var floor = createRound2("floor");
        function max2(array2) {
          return array2 && array2.length ? baseExtremum(array2, identity2, baseGt) : undefined$12;
        }
        function maxBy(array2, iteratee2) {
          return array2 && array2.length ? baseExtremum(array2, getIteratee(iteratee2, 2), baseGt) : undefined$12;
        }
        function mean2(array2) {
          return baseMean(array2, identity2);
        }
        function meanBy(array2, iteratee2) {
          return baseMean(array2, getIteratee(iteratee2, 2));
        }
        function min2(array2) {
          return array2 && array2.length ? baseExtremum(array2, identity2, baseLt) : undefined$12;
        }
        function minBy(array2, iteratee2) {
          return array2 && array2.length ? baseExtremum(array2, getIteratee(iteratee2, 2), baseLt) : undefined$12;
        }
        var multiply = createMathOperation(function(multiplier, multiplicand) {
          return multiplier * multiplicand;
        }, 1);
        var round2 = createRound2("round");
        var subtract2 = createMathOperation(function(minuend, subtrahend) {
          return minuend - subtrahend;
        }, 0);
        function sum2(array2) {
          return array2 && array2.length ? baseSum(array2, identity2) : 0;
        }
        function sumBy(array2, iteratee2) {
          return array2 && array2.length ? baseSum(array2, getIteratee(iteratee2, 2)) : 0;
        }
        lodash2.after = after;
        lodash2.ary = ary;
        lodash2.assign = assign2;
        lodash2.assignIn = assignIn;
        lodash2.assignInWith = assignInWith;
        lodash2.assignWith = assignWith;
        lodash2.at = at2;
        lodash2.before = before;
        lodash2.bind = bind2;
        lodash2.bindAll = bindAll;
        lodash2.bindKey = bindKey2;
        lodash2.castArray = castArray2;
        lodash2.chain = chain2;
        lodash2.chunk = chunk;
        lodash2.compact = compact2;
        lodash2.concat = concat;
        lodash2.cond = cond;
        lodash2.conforms = conforms;
        lodash2.constant = constant2;
        lodash2.countBy = countBy;
        lodash2.create = create2;
        lodash2.curry = curry2;
        lodash2.curryRight = curryRight;
        lodash2.debounce = debounce2;
        lodash2.defaults = defaults2;
        lodash2.defaultsDeep = defaultsDeep;
        lodash2.defer = defer;
        lodash2.delay = delay;
        lodash2.difference = difference2;
        lodash2.differenceBy = differenceBy;
        lodash2.differenceWith = differenceWith;
        lodash2.drop = drop;
        lodash2.dropRight = dropRight;
        lodash2.dropRightWhile = dropRightWhile;
        lodash2.dropWhile = dropWhile;
        lodash2.fill = fill;
        lodash2.filter = filter2;
        lodash2.flatMap = flatMap;
        lodash2.flatMapDeep = flatMapDeep;
        lodash2.flatMapDepth = flatMapDepth;
        lodash2.flatten = flatten2;
        lodash2.flattenDeep = flattenDeep;
        lodash2.flattenDepth = flattenDepth;
        lodash2.flip = flip2;
        lodash2.flow = flow2;
        lodash2.flowRight = flowRight;
        lodash2.fromPairs = fromPairs;
        lodash2.functions = functions2;
        lodash2.functionsIn = functionsIn;
        lodash2.groupBy = groupBy;
        lodash2.initial = initial2;
        lodash2.intersection = intersection2;
        lodash2.intersectionBy = intersectionBy;
        lodash2.intersectionWith = intersectionWith;
        lodash2.invert = invert;
        lodash2.invertBy = invertBy;
        lodash2.invokeMap = invokeMap;
        lodash2.iteratee = iteratee;
        lodash2.keyBy = keyBy;
        lodash2.keys = keys2;
        lodash2.keysIn = keysIn2;
        lodash2.map = map2;
        lodash2.mapKeys = mapKeys;
        lodash2.mapValues = mapValues;
        lodash2.matches = matches2;
        lodash2.matchesProperty = matchesProperty;
        lodash2.memoize = memoize2;
        lodash2.merge = merge2;
        lodash2.mergeWith = mergeWith;
        lodash2.method = method;
        lodash2.methodOf = methodOf;
        lodash2.mixin = mixin2;
        lodash2.negate = negate;
        lodash2.nthArg = nthArg;
        lodash2.omit = omit;
        lodash2.omitBy = omitBy;
        lodash2.once = once2;
        lodash2.orderBy = orderBy;
        lodash2.over = over;
        lodash2.overArgs = overArgs;
        lodash2.overEvery = overEvery;
        lodash2.overSome = overSome;
        lodash2.partial = partial;
        lodash2.partialRight = partialRight;
        lodash2.partition = partition;
        lodash2.pick = pick;
        lodash2.pickBy = pickBy;
        lodash2.property = property;
        lodash2.propertyOf = propertyOf;
        lodash2.pull = pull;
        lodash2.pullAll = pullAll;
        lodash2.pullAllBy = pullAllBy;
        lodash2.pullAllWith = pullAllWith;
        lodash2.pullAt = pullAt;
        lodash2.range = range2;
        lodash2.rangeRight = rangeRight;
        lodash2.rearg = rearg;
        lodash2.reject = reject;
        lodash2.remove = remove2;
        lodash2.rest = rest;
        lodash2.reverse = reverse2;
        lodash2.sampleSize = sampleSize;
        lodash2.set = set2;
        lodash2.setWith = setWith;
        lodash2.shuffle = shuffle2;
        lodash2.slice = slice2;
        lodash2.sortBy = sortBy;
        lodash2.sortedUniq = sortedUniq;
        lodash2.sortedUniqBy = sortedUniqBy;
        lodash2.split = split;
        lodash2.spread = spread;
        lodash2.tail = tail;
        lodash2.take = take2;
        lodash2.takeRight = takeRight;
        lodash2.takeRightWhile = takeRightWhile;
        lodash2.takeWhile = takeWhile;
        lodash2.tap = tap;
        lodash2.throttle = throttle2;
        lodash2.thru = thru;
        lodash2.toArray = toArray2;
        lodash2.toPairs = toPairs2;
        lodash2.toPairsIn = toPairsIn;
        lodash2.toPath = toPath2;
        lodash2.toPlainObject = toPlainObject;
        lodash2.transform = transform;
        lodash2.unary = unary;
        lodash2.union = union2;
        lodash2.unionBy = unionBy;
        lodash2.unionWith = unionWith;
        lodash2.uniq = uniq;
        lodash2.uniqBy = uniqBy;
        lodash2.uniqWith = uniqWith;
        lodash2.unset = unset;
        lodash2.unzip = unzip;
        lodash2.unzipWith = unzipWith;
        lodash2.update = update2;
        lodash2.updateWith = updateWith;
        lodash2.values = values;
        lodash2.valuesIn = valuesIn;
        lodash2.without = without2;
        lodash2.words = words;
        lodash2.wrap = wrap2;
        lodash2.xor = xor2;
        lodash2.xorBy = xorBy;
        lodash2.xorWith = xorWith;
        lodash2.zip = zip2;
        lodash2.zipObject = zipObject;
        lodash2.zipObjectDeep = zipObjectDeep;
        lodash2.zipWith = zipWith;
        lodash2.entries = toPairs2;
        lodash2.entriesIn = toPairsIn;
        lodash2.extend = assignIn;
        lodash2.extendWith = assignInWith;
        mixin2(lodash2, lodash2);
        lodash2.add = add2;
        lodash2.attempt = attempt;
        lodash2.camelCase = camelCase;
        lodash2.capitalize = capitalize2;
        lodash2.ceil = ceil;
        lodash2.clamp = clamp2;
        lodash2.clone = clone2;
        lodash2.cloneDeep = cloneDeep2;
        lodash2.cloneDeepWith = cloneDeepWith;
        lodash2.cloneWith = cloneWith;
        lodash2.conformsTo = conformsTo;
        lodash2.deburr = deburr;
        lodash2.defaultTo = defaultTo;
        lodash2.divide = divide;
        lodash2.endsWith = endsWith;
        lodash2.eq = eq2;
        lodash2.escape = escape2;
        lodash2.escapeRegExp = escapeRegExp2;
        lodash2.every = every2;
        lodash2.find = find2;
        lodash2.findIndex = findIndex2;
        lodash2.findKey = findKey2;
        lodash2.findLast = findLast;
        lodash2.findLastIndex = findLastIndex;
        lodash2.findLastKey = findLastKey;
        lodash2.floor = floor;
        lodash2.forEach = forEach;
        lodash2.forEachRight = forEachRight;
        lodash2.forIn = forIn;
        lodash2.forInRight = forInRight;
        lodash2.forOwn = forOwn;
        lodash2.forOwnRight = forOwnRight;
        lodash2.get = get2;
        lodash2.gt = gt2;
        lodash2.gte = gte;
        lodash2.has = has2;
        lodash2.hasIn = hasIn;
        lodash2.head = head;
        lodash2.identity = identity2;
        lodash2.includes = includes;
        lodash2.indexOf = indexOf2;
        lodash2.inRange = inRange;
        lodash2.invoke = invoke;
        lodash2.isArguments = isArguments2;
        lodash2.isArray = isArray2;
        lodash2.isArrayBuffer = isArrayBuffer;
        lodash2.isArrayLike = isArrayLike2;
        lodash2.isArrayLikeObject = isArrayLikeObject;
        lodash2.isBoolean = isBoolean2;
        lodash2.isBuffer = isBuffer2;
        lodash2.isDate = isDate2;
        lodash2.isElement = isElement2;
        lodash2.isEmpty = isEmpty2;
        lodash2.isEqual = isEqual2;
        lodash2.isEqualWith = isEqualWith;
        lodash2.isError = isError2;
        lodash2.isFinite = isFinite2;
        lodash2.isFunction = isFunction2;
        lodash2.isInteger = isInteger;
        lodash2.isLength = isLength2;
        lodash2.isMap = isMap2;
        lodash2.isMatch = isMatch;
        lodash2.isMatchWith = isMatchWith;
        lodash2.isNaN = isNaN2;
        lodash2.isNative = isNative;
        lodash2.isNil = isNil;
        lodash2.isNull = isNull;
        lodash2.isNumber = isNumber2;
        lodash2.isObject = isObject2;
        lodash2.isObjectLike = isObjectLike2;
        lodash2.isPlainObject = isPlainObject2;
        lodash2.isRegExp = isRegExp2;
        lodash2.isSafeInteger = isSafeInteger;
        lodash2.isSet = isSet2;
        lodash2.isString = isString2;
        lodash2.isSymbol = isSymbol2;
        lodash2.isTypedArray = isTypedArray2;
        lodash2.isUndefined = isUndefined;
        lodash2.isWeakMap = isWeakMap2;
        lodash2.isWeakSet = isWeakSet2;
        lodash2.join = join2;
        lodash2.kebabCase = kebabCase;
        lodash2.last = last;
        lodash2.lastIndexOf = lastIndexOf;
        lodash2.lowerCase = lowerCase;
        lodash2.lowerFirst = lowerFirst;
        lodash2.lt = lt2;
        lodash2.lte = lte;
        lodash2.max = max2;
        lodash2.maxBy = maxBy;
        lodash2.mean = mean2;
        lodash2.meanBy = meanBy;
        lodash2.min = min2;
        lodash2.minBy = minBy;
        lodash2.stubArray = stubArray2;
        lodash2.stubFalse = stubFalse2;
        lodash2.stubObject = stubObject;
        lodash2.stubString = stubString;
        lodash2.stubTrue = stubTrue;
        lodash2.multiply = multiply;
        lodash2.nth = nth;
        lodash2.noConflict = noConflict;
        lodash2.noop = noop2;
        lodash2.now = now2;
        lodash2.pad = pad;
        lodash2.padEnd = padEnd;
        lodash2.padStart = padStart;
        lodash2.parseInt = parseInt2;
        lodash2.random = random2;
        lodash2.reduce = reduce2;
        lodash2.reduceRight = reduceRight;
        lodash2.repeat = repeat;
        lodash2.replace = replace2;
        lodash2.result = result;
        lodash2.round = round2;
        lodash2.runInContext = runInContext2;
        lodash2.sample = sample;
        lodash2.size = size;
        lodash2.snakeCase = snakeCase;
        lodash2.some = some2;
        lodash2.sortedIndex = sortedIndex;
        lodash2.sortedIndexBy = sortedIndexBy;
        lodash2.sortedIndexOf = sortedIndexOf;
        lodash2.sortedLastIndex = sortedLastIndex;
        lodash2.sortedLastIndexBy = sortedLastIndexBy;
        lodash2.sortedLastIndexOf = sortedLastIndexOf;
        lodash2.startCase = startCase;
        lodash2.startsWith = startsWith;
        lodash2.subtract = subtract2;
        lodash2.sum = sum2;
        lodash2.sumBy = sumBy;
        lodash2.template = template;
        lodash2.times = times;
        lodash2.toFinite = toFinite2;
        lodash2.toInteger = toInteger2;
        lodash2.toLength = toLength;
        lodash2.toLower = toLower;
        lodash2.toNumber = toNumber2;
        lodash2.toSafeInteger = toSafeInteger;
        lodash2.toString = toString2;
        lodash2.toUpper = toUpper;
        lodash2.trim = trim2;
        lodash2.trimEnd = trimEnd;
        lodash2.trimStart = trimStart;
        lodash2.truncate = truncate;
        lodash2.unescape = unescape2;
        lodash2.uniqueId = uniqueId;
        lodash2.upperCase = upperCase;
        lodash2.upperFirst = upperFirst;
        lodash2.each = forEach;
        lodash2.eachRight = forEachRight;
        lodash2.first = head;
        mixin2(lodash2, function() {
          var source = {};
          baseForOwn(lodash2, function(func, methodName) {
            if (!hasOwnProperty2.call(lodash2.prototype, methodName)) {
              source[methodName] = func;
            }
          });
          return source;
        }(), { "chain": false });
        lodash2.VERSION = VERSION;
        arrayEach2(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(methodName) {
          lodash2[methodName].placeholder = lodash2;
        });
        arrayEach2(["drop", "take"], function(methodName, index2) {
          LazyWrapper.prototype[methodName] = function(n2) {
            n2 = n2 === undefined$12 ? 1 : nativeMax2(toInteger2(n2), 0);
            var result2 = this.__filtered__ && !index2 ? new LazyWrapper(this) : this.clone();
            if (result2.__filtered__) {
              result2.__takeCount__ = nativeMin2(n2, result2.__takeCount__);
            } else {
              result2.__views__.push({
                "size": nativeMin2(n2, MAX_ARRAY_LENGTH),
                "type": methodName + (result2.__dir__ < 0 ? "Right" : "")
              });
            }
            return result2;
          };
          LazyWrapper.prototype[methodName + "Right"] = function(n2) {
            return this.reverse()[methodName](n2).reverse();
          };
        });
        arrayEach2(["filter", "map", "takeWhile"], function(methodName, index2) {
          var type = index2 + 1, isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
          LazyWrapper.prototype[methodName] = function(iteratee2) {
            var result2 = this.clone();
            result2.__iteratees__.push({
              "iteratee": getIteratee(iteratee2, 3),
              "type": type
            });
            result2.__filtered__ = result2.__filtered__ || isFilter;
            return result2;
          };
        });
        arrayEach2(["head", "last"], function(methodName, index2) {
          var takeName = "take" + (index2 ? "Right" : "");
          LazyWrapper.prototype[methodName] = function() {
            return this[takeName](1).value()[0];
          };
        });
        arrayEach2(["initial", "tail"], function(methodName, index2) {
          var dropName = "drop" + (index2 ? "" : "Right");
          LazyWrapper.prototype[methodName] = function() {
            return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
          };
        });
        LazyWrapper.prototype.compact = function() {
          return this.filter(identity2);
        };
        LazyWrapper.prototype.find = function(predicate) {
          return this.filter(predicate).head();
        };
        LazyWrapper.prototype.findLast = function(predicate) {
          return this.reverse().find(predicate);
        };
        LazyWrapper.prototype.invokeMap = baseRest(function(path2, args) {
          if (typeof path2 == "function") {
            return new LazyWrapper(this);
          }
          return this.map(function(value) {
            return baseInvoke(value, path2, args);
          });
        });
        LazyWrapper.prototype.reject = function(predicate) {
          return this.filter(negate(getIteratee(predicate)));
        };
        LazyWrapper.prototype.slice = function(start2, end2) {
          start2 = toInteger2(start2);
          var result2 = this;
          if (result2.__filtered__ && (start2 > 0 || end2 < 0)) {
            return new LazyWrapper(result2);
          }
          if (start2 < 0) {
            result2 = result2.takeRight(-start2);
          } else if (start2) {
            result2 = result2.drop(start2);
          }
          if (end2 !== undefined$12) {
            end2 = toInteger2(end2);
            result2 = end2 < 0 ? result2.dropRight(-end2) : result2.take(end2 - start2);
          }
          return result2;
        };
        LazyWrapper.prototype.takeRightWhile = function(predicate) {
          return this.reverse().takeWhile(predicate).reverse();
        };
        LazyWrapper.prototype.toArray = function() {
          return this.take(MAX_ARRAY_LENGTH);
        };
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName), isTaker = /^(?:head|last)$/.test(methodName), lodashFunc = lodash2[isTaker ? "take" + (methodName == "last" ? "Right" : "") : methodName], retUnwrapped = isTaker || /^find/.test(methodName);
          if (!lodashFunc) {
            return;
          }
          lodash2.prototype[methodName] = function() {
            var value = this.__wrapped__, args = isTaker ? [1] : arguments, isLazy = value instanceof LazyWrapper, iteratee2 = args[0], useLazy = isLazy || isArray2(value);
            var interceptor = function(value2) {
              var result3 = lodashFunc.apply(lodash2, arrayPush2([value2], args));
              return isTaker && chainAll ? result3[0] : result3;
            };
            if (useLazy && checkIteratee && typeof iteratee2 == "function" && iteratee2.length != 1) {
              isLazy = useLazy = false;
            }
            var chainAll = this.__chain__, isHybrid = !!this.__actions__.length, isUnwrapped = retUnwrapped && !chainAll, onlyLazy = isLazy && !isHybrid;
            if (!retUnwrapped && useLazy) {
              value = onlyLazy ? value : new LazyWrapper(this);
              var result2 = func.apply(value, args);
              result2.__actions__.push({ "func": thru, "args": [interceptor], "thisArg": undefined$12 });
              return new LodashWrapper(result2, chainAll);
            }
            if (isUnwrapped && onlyLazy) {
              return func.apply(this, args);
            }
            result2 = this.thru(interceptor);
            return isUnwrapped ? isTaker ? result2.value()[0] : result2.value() : result2;
          };
        });
        arrayEach2(["pop", "push", "shift", "sort", "splice", "unshift"], function(methodName) {
          var func = arrayProto2[methodName], chainName = /^(?:push|sort|unshift)$/.test(methodName) ? "tap" : "thru", retUnwrapped = /^(?:pop|shift)$/.test(methodName);
          lodash2.prototype[methodName] = function() {
            var args = arguments;
            if (retUnwrapped && !this.__chain__) {
              var value = this.value();
              return func.apply(isArray2(value) ? value : [], args);
            }
            return this[chainName](function(value2) {
              return func.apply(isArray2(value2) ? value2 : [], args);
            });
          };
        });
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var lodashFunc = lodash2[methodName];
          if (lodashFunc) {
            var key = lodashFunc.name + "";
            if (!hasOwnProperty2.call(realNames, key)) {
              realNames[key] = [];
            }
            realNames[key].push({ "name": methodName, "func": lodashFunc });
          }
        });
        realNames[createHybrid(undefined$12, WRAP_BIND_KEY_FLAG).name] = [{
          "name": "wrapper",
          "func": undefined$12
        }];
        LazyWrapper.prototype.clone = lazyClone;
        LazyWrapper.prototype.reverse = lazyReverse;
        LazyWrapper.prototype.value = lazyValue;
        lodash2.prototype.at = wrapperAt;
        lodash2.prototype.chain = wrapperChain;
        lodash2.prototype.commit = wrapperCommit;
        lodash2.prototype.next = wrapperNext;
        lodash2.prototype.plant = wrapperPlant;
        lodash2.prototype.reverse = wrapperReverse;
        lodash2.prototype.toJSON = lodash2.prototype.valueOf = lodash2.prototype.value = wrapperValue;
        lodash2.prototype.first = lodash2.prototype.head;
        if (symIterator) {
          lodash2.prototype[symIterator] = wrapperToIterator;
        }
        return lodash2;
      };
      var _2 = runInContext();
      if (freeModule) {
        (freeModule.exports = _2)._ = _2;
        freeExports._ = _2;
      } else {
        root2._ = _2;
      }
    }).call(commonjsGlobal);
  })(lodash, lodash.exports);
  var classnames = { exports: {} };
  /*!
  	Copyright (c) 2018 Jed Watson.
  	Licensed under the MIT License (MIT), see
  	http://jedwatson.github.io/classnames
  */
  (function(module2) {
    (function() {
      var hasOwn2 = {}.hasOwnProperty;
      function classNames() {
        var classes = [];
        for (var i2 = 0; i2 < arguments.length; i2++) {
          var arg = arguments[i2];
          if (!arg)
            continue;
          var argType = typeof arg;
          if (argType === "string" || argType === "number") {
            classes.push(arg);
          } else if (Array.isArray(arg)) {
            if (arg.length) {
              var inner = classNames.apply(null, arg);
              if (inner) {
                classes.push(inner);
              }
            }
          } else if (argType === "object") {
            if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes("[native code]")) {
              classes.push(arg.toString());
              continue;
            }
            for (var key in arg) {
              if (hasOwn2.call(arg, key) && arg[key]) {
                classes.push(key);
              }
            }
          }
        }
        return classes.join(" ");
      }
      if (module2.exports) {
        classNames.default = classNames;
        module2.exports = classNames;
      } else {
        window.classNames = classNames;
      }
    })();
  })(classnames);
  const r$2 = classnames.exports;
  function _typeof$6(obj) {
    "@babel/helpers - typeof";
    return _typeof$6 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$6(obj);
  }
  function requiredArgs(required2, args) {
    if (args.length < required2) {
      throw new TypeError(required2 + " argument" + (required2 > 1 ? "s" : "") + " required, but only " + args.length + " present");
    }
  }
  function isDate$1(value) {
    requiredArgs(1, arguments);
    return value instanceof Date || _typeof$6(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
  }
  function toDate(argument) {
    requiredArgs(1, arguments);
    var argStr = Object.prototype.toString.call(argument);
    if (argument instanceof Date || _typeof$6(argument) === "object" && argStr === "[object Date]") {
      return new Date(argument.getTime());
    } else if (typeof argument === "number" || argStr === "[object Number]") {
      return new Date(argument);
    } else {
      if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
        console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
        console.warn(new Error().stack);
      }
      return new Date(NaN);
    }
  }
  function isValid(dirtyDate) {
    requiredArgs(1, arguments);
    if (!isDate$1(dirtyDate) && typeof dirtyDate !== "number") {
      return false;
    }
    var date = toDate(dirtyDate);
    return !isNaN(Number(date));
  }
  function toInteger$2(dirtyNumber) {
    if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
      return NaN;
    }
    var number2 = Number(dirtyNumber);
    if (isNaN(number2)) {
      return number2;
    }
    return number2 < 0 ? Math.ceil(number2) : Math.floor(number2);
  }
  function addMilliseconds(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var timestamp = toDate(dirtyDate).getTime();
    var amount = toInteger$2(dirtyAmount);
    return new Date(timestamp + amount);
  }
  function subMilliseconds(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addMilliseconds(dirtyDate, -amount);
  }
  var MILLISECONDS_IN_DAY$1 = 864e5;
  function getUTCDayOfYear(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var timestamp = date.getTime();
    date.setUTCMonth(0, 1);
    date.setUTCHours(0, 0, 0, 0);
    var startOfYearTimestamp = date.getTime();
    var difference2 = timestamp - startOfYearTimestamp;
    return Math.floor(difference2 / MILLISECONDS_IN_DAY$1) + 1;
  }
  function startOfUTCISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    var weekStartsOn = 1;
    var date = toDate(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var year = date.getUTCFullYear();
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var year = getUTCISOWeekYear(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setUTCFullYear(year, 0, 4);
    fourthOfJanuary.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCISOWeek(fourthOfJanuary);
    return date;
  }
  var MILLISECONDS_IN_WEEK$2 = 6048e5;
  function getUTCISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$2) + 1;
  }
  var defaultOptions = {};
  function getDefaultOptions() {
    return defaultOptions;
  }
  function startOfUTCWeek(dirtyDate, options) {
    var _ref2, _ref22, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
    requiredArgs(1, arguments);
    var defaultOptions2 = getDefaultOptions();
    var weekStartsOn = toInteger$2((_ref2 = (_ref22 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref22 !== void 0 ? _ref22 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : 0);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCWeekYear(dirtyDate, options) {
    var _ref2, _ref22, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var year = date.getUTCFullYear();
    var defaultOptions2 = getDefaultOptions();
    var firstWeekContainsDate = toInteger$2((_ref2 = (_ref22 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref22 !== void 0 ? _ref22 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var firstWeekOfNextYear = new Date(0);
    firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
    firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
    var firstWeekOfThisYear = new Date(0);
    firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCWeekYear(dirtyDate, options) {
    var _ref2, _ref22, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
    requiredArgs(1, arguments);
    var defaultOptions2 = getDefaultOptions();
    var firstWeekContainsDate = toInteger$2((_ref2 = (_ref22 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref22 !== void 0 ? _ref22 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
    var year = getUTCWeekYear(dirtyDate, options);
    var firstWeek = new Date(0);
    firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeek.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCWeek(firstWeek, options);
    return date;
  }
  var MILLISECONDS_IN_WEEK$1 = 6048e5;
  function getUTCWeek(dirtyDate, options) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$1) + 1;
  }
  function addLeadingZeros(number2, targetLength) {
    var sign2 = number2 < 0 ? "-" : "";
    var output2 = Math.abs(number2).toString();
    while (output2.length < targetLength) {
      output2 = "0" + output2;
    }
    return sign2 + output2;
  }
  var formatters$2 = {
    y: function y2(date, token) {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
    },
    M: function M2(date, token) {
      var month = date.getUTCMonth();
      return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
    },
    d: function d2(date, token) {
      return addLeadingZeros(date.getUTCDate(), token.length);
    },
    a: function a2(date, token) {
      var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
          return dayPeriodEnumValue.toUpperCase();
        case "aaa":
          return dayPeriodEnumValue;
        case "aaaaa":
          return dayPeriodEnumValue[0];
        case "aaaa":
        default:
          return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
      }
    },
    h: function h2(date, token) {
      return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
    },
    H: function H2(date, token) {
      return addLeadingZeros(date.getUTCHours(), token.length);
    },
    m: function m2(date, token) {
      return addLeadingZeros(date.getUTCMinutes(), token.length);
    },
    s: function s2(date, token) {
      return addLeadingZeros(date.getUTCSeconds(), token.length);
    },
    S: function S2(date, token) {
      var numberOfDigits = token.length;
      var milliseconds = date.getUTCMilliseconds();
      var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
      return addLeadingZeros(fractionalSeconds, token.length);
    }
  };
  const lightFormatters = formatters$2;
  var dayPeriodEnum = {
    am: "am",
    pm: "pm",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  };
  var formatters = {
    G: function G2(date, token, localize2) {
      var era = date.getUTCFullYear() > 0 ? 1 : 0;
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return localize2.era(era, {
            width: "abbreviated"
          });
        case "GGGGG":
          return localize2.era(era, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return localize2.era(era, {
            width: "wide"
          });
      }
    },
    y: function y2(date, token, localize2) {
      if (token === "yo") {
        var signedYear = date.getUTCFullYear();
        var year = signedYear > 0 ? signedYear : 1 - signedYear;
        return localize2.ordinalNumber(year, {
          unit: "year"
        });
      }
      return lightFormatters.y(date, token);
    },
    Y: function Y2(date, token, localize2, options) {
      var signedWeekYear = getUTCWeekYear(date, options);
      var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
      if (token === "YY") {
        var twoDigitYear = weekYear % 100;
        return addLeadingZeros(twoDigitYear, 2);
      }
      if (token === "Yo") {
        return localize2.ordinalNumber(weekYear, {
          unit: "year"
        });
      }
      return addLeadingZeros(weekYear, token.length);
    },
    R: function R2(date, token) {
      var isoWeekYear = getUTCISOWeekYear(date);
      return addLeadingZeros(isoWeekYear, token.length);
    },
    u: function u2(date, token) {
      var year = date.getUTCFullYear();
      return addLeadingZeros(year, token.length);
    },
    Q: function Q2(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "Q":
          return String(quarter);
        case "QQ":
          return addLeadingZeros(quarter, 2);
        case "Qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "QQQ":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "formatting"
          });
        case "QQQQQ":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    q: function q2(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "q":
          return String(quarter);
        case "qq":
          return addLeadingZeros(quarter, 2);
        case "qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "qqq":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "standalone"
          });
        case "qqqqq":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    M: function M2(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "M":
        case "MM":
          return lightFormatters.M(date, token);
        case "Mo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "MMM":
          return localize2.month(month, {
            width: "abbreviated",
            context: "formatting"
          });
        case "MMMMM":
          return localize2.month(month, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    L: function L2(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "L":
          return String(month + 1);
        case "LL":
          return addLeadingZeros(month + 1, 2);
        case "Lo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "LLL":
          return localize2.month(month, {
            width: "abbreviated",
            context: "standalone"
          });
        case "LLLLL":
          return localize2.month(month, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    w: function w2(date, token, localize2, options) {
      var week = getUTCWeek(date, options);
      if (token === "wo") {
        return localize2.ordinalNumber(week, {
          unit: "week"
        });
      }
      return addLeadingZeros(week, token.length);
    },
    I: function I2(date, token, localize2) {
      var isoWeek = getUTCISOWeek(date);
      if (token === "Io") {
        return localize2.ordinalNumber(isoWeek, {
          unit: "week"
        });
      }
      return addLeadingZeros(isoWeek, token.length);
    },
    d: function d2(date, token, localize2) {
      if (token === "do") {
        return localize2.ordinalNumber(date.getUTCDate(), {
          unit: "date"
        });
      }
      return lightFormatters.d(date, token);
    },
    D: function D2(date, token, localize2) {
      var dayOfYear = getUTCDayOfYear(date);
      if (token === "Do") {
        return localize2.ordinalNumber(dayOfYear, {
          unit: "dayOfYear"
        });
      }
      return addLeadingZeros(dayOfYear, token.length);
    },
    E: function E2(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "EEEEE":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "EEEE":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    e: function e3(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "e":
          return String(localDayOfWeek);
        case "ee":
          return addLeadingZeros(localDayOfWeek, 2);
        case "eo":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "eee":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "eeeee":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "eeee":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    c: function c2(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "c":
          return String(localDayOfWeek);
        case "cc":
          return addLeadingZeros(localDayOfWeek, token.length);
        case "co":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "ccc":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "standalone"
          });
        case "ccccc":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "standalone"
          });
        case "cccc":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    i: function i2(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
      switch (token) {
        case "i":
          return String(isoDayOfWeek);
        case "ii":
          return addLeadingZeros(isoDayOfWeek, token.length);
        case "io":
          return localize2.ordinalNumber(isoDayOfWeek, {
            unit: "day"
          });
        case "iii":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "iiiii":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "iiiiii":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "iiii":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    a: function a2(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "aaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          }).toLowerCase();
        case "aaaaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    b: function b2(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours === 12) {
        dayPeriodEnumValue = dayPeriodEnum.noon;
      } else if (hours === 0) {
        dayPeriodEnumValue = dayPeriodEnum.midnight;
      } else {
        dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      }
      switch (token) {
        case "b":
        case "bb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "bbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          }).toLowerCase();
        case "bbbbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    B: function B2(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours >= 17) {
        dayPeriodEnumValue = dayPeriodEnum.evening;
      } else if (hours >= 12) {
        dayPeriodEnumValue = dayPeriodEnum.afternoon;
      } else if (hours >= 4) {
        dayPeriodEnumValue = dayPeriodEnum.morning;
      } else {
        dayPeriodEnumValue = dayPeriodEnum.night;
      }
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "BBBBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    h: function h2(date, token, localize2) {
      if (token === "ho") {
        var hours = date.getUTCHours() % 12;
        if (hours === 0)
          hours = 12;
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return lightFormatters.h(date, token);
    },
    H: function H2(date, token, localize2) {
      if (token === "Ho") {
        return localize2.ordinalNumber(date.getUTCHours(), {
          unit: "hour"
        });
      }
      return lightFormatters.H(date, token);
    },
    K: function K2(date, token, localize2) {
      var hours = date.getUTCHours() % 12;
      if (token === "Ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros(hours, token.length);
    },
    k: function k2(date, token, localize2) {
      var hours = date.getUTCHours();
      if (hours === 0)
        hours = 24;
      if (token === "ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros(hours, token.length);
    },
    m: function m2(date, token, localize2) {
      if (token === "mo") {
        return localize2.ordinalNumber(date.getUTCMinutes(), {
          unit: "minute"
        });
      }
      return lightFormatters.m(date, token);
    },
    s: function s2(date, token, localize2) {
      if (token === "so") {
        return localize2.ordinalNumber(date.getUTCSeconds(), {
          unit: "second"
        });
      }
      return lightFormatters.s(date, token);
    },
    S: function S2(date, token) {
      return lightFormatters.S(date, token);
    },
    X: function X2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      if (timezoneOffset === 0) {
        return "Z";
      }
      switch (token) {
        case "X":
          return formatTimezoneWithOptionalMinutes(timezoneOffset);
        case "XXXX":
        case "XX":
          return formatTimezone(timezoneOffset);
        case "XXXXX":
        case "XXX":
        default:
          return formatTimezone(timezoneOffset, ":");
      }
    },
    x: function x2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "x":
          return formatTimezoneWithOptionalMinutes(timezoneOffset);
        case "xxxx":
        case "xx":
          return formatTimezone(timezoneOffset);
        case "xxxxx":
        case "xxx":
        default:
          return formatTimezone(timezoneOffset, ":");
      }
    },
    O: function O2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "O":
        case "OO":
        case "OOO":
          return "GMT" + formatTimezoneShort(timezoneOffset, ":");
        case "OOOO":
        default:
          return "GMT" + formatTimezone(timezoneOffset, ":");
      }
    },
    z: function z2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "z":
        case "zz":
        case "zzz":
          return "GMT" + formatTimezoneShort(timezoneOffset, ":");
        case "zzzz":
        default:
          return "GMT" + formatTimezone(timezoneOffset, ":");
      }
    },
    t: function t2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = Math.floor(originalDate.getTime() / 1e3);
      return addLeadingZeros(timestamp, token.length);
    },
    T: function T2(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = originalDate.getTime();
      return addLeadingZeros(timestamp, token.length);
    }
  };
  function formatTimezoneShort(offset2, dirtyDelimiter) {
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = Math.floor(absOffset / 60);
    var minutes = absOffset % 60;
    if (minutes === 0) {
      return sign2 + String(hours);
    }
    var delimiter = dirtyDelimiter || "";
    return sign2 + String(hours) + delimiter + addLeadingZeros(minutes, 2);
  }
  function formatTimezoneWithOptionalMinutes(offset2, dirtyDelimiter) {
    if (offset2 % 60 === 0) {
      var sign2 = offset2 > 0 ? "-" : "+";
      return sign2 + addLeadingZeros(Math.abs(offset2) / 60, 2);
    }
    return formatTimezone(offset2, dirtyDelimiter);
  }
  function formatTimezone(offset2, dirtyDelimiter) {
    var delimiter = dirtyDelimiter || "";
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
    var minutes = addLeadingZeros(absOffset % 60, 2);
    return sign2 + hours + delimiter + minutes;
  }
  const formatters$1 = formatters;
  var dateLongFormatter = function dateLongFormatter2(pattern, formatLong2) {
    switch (pattern) {
      case "P":
        return formatLong2.date({
          width: "short"
        });
      case "PP":
        return formatLong2.date({
          width: "medium"
        });
      case "PPP":
        return formatLong2.date({
          width: "long"
        });
      case "PPPP":
      default:
        return formatLong2.date({
          width: "full"
        });
    }
  };
  var timeLongFormatter = function timeLongFormatter2(pattern, formatLong2) {
    switch (pattern) {
      case "p":
        return formatLong2.time({
          width: "short"
        });
      case "pp":
        return formatLong2.time({
          width: "medium"
        });
      case "ppp":
        return formatLong2.time({
          width: "long"
        });
      case "pppp":
      default:
        return formatLong2.time({
          width: "full"
        });
    }
  };
  var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong2) {
    var matchResult = pattern.match(/(P+)(p+)?/) || [];
    var datePattern = matchResult[1];
    var timePattern = matchResult[2];
    if (!timePattern) {
      return dateLongFormatter(pattern, formatLong2);
    }
    var dateTimeFormat;
    switch (datePattern) {
      case "P":
        dateTimeFormat = formatLong2.dateTime({
          width: "short"
        });
        break;
      case "PP":
        dateTimeFormat = formatLong2.dateTime({
          width: "medium"
        });
        break;
      case "PPP":
        dateTimeFormat = formatLong2.dateTime({
          width: "long"
        });
        break;
      case "PPPP":
      default:
        dateTimeFormat = formatLong2.dateTime({
          width: "full"
        });
        break;
    }
    return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter(timePattern, formatLong2));
  };
  var longFormatters = {
    p: timeLongFormatter,
    P: dateTimeLongFormatter
  };
  const longFormatters$1 = longFormatters;
  function getTimezoneOffsetInMilliseconds(date) {
    var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
    utcDate.setUTCFullYear(date.getFullYear());
    return date.getTime() - utcDate.getTime();
  }
  var protectedDayOfYearTokens = ["D", "DD"];
  var protectedWeekYearTokens = ["YY", "YYYY"];
  function isProtectedDayOfYearToken(token) {
    return protectedDayOfYearTokens.indexOf(token) !== -1;
  }
  function isProtectedWeekYearToken(token) {
    return protectedWeekYearTokens.indexOf(token) !== -1;
  }
  function throwProtectedError(token, format2, input) {
    if (token === "YYYY") {
      throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
    } else if (token === "YY") {
      throw new RangeError("Use `yy` instead of `YY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
    } else if (token === "D") {
      throw new RangeError("Use `d` instead of `D` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
    } else if (token === "DD") {
      throw new RangeError("Use `dd` instead of `DD` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
    }
  }
  var formatDistanceLocale = {
    lessThanXSeconds: {
      one: "less than a second",
      other: "less than {{count}} seconds"
    },
    xSeconds: {
      one: "1 second",
      other: "{{count}} seconds"
    },
    halfAMinute: "half a minute",
    lessThanXMinutes: {
      one: "less than a minute",
      other: "less than {{count}} minutes"
    },
    xMinutes: {
      one: "1 minute",
      other: "{{count}} minutes"
    },
    aboutXHours: {
      one: "about 1 hour",
      other: "about {{count}} hours"
    },
    xHours: {
      one: "1 hour",
      other: "{{count}} hours"
    },
    xDays: {
      one: "1 day",
      other: "{{count}} days"
    },
    aboutXWeeks: {
      one: "about 1 week",
      other: "about {{count}} weeks"
    },
    xWeeks: {
      one: "1 week",
      other: "{{count}} weeks"
    },
    aboutXMonths: {
      one: "about 1 month",
      other: "about {{count}} months"
    },
    xMonths: {
      one: "1 month",
      other: "{{count}} months"
    },
    aboutXYears: {
      one: "about 1 year",
      other: "about {{count}} years"
    },
    xYears: {
      one: "1 year",
      other: "{{count}} years"
    },
    overXYears: {
      one: "over 1 year",
      other: "over {{count}} years"
    },
    almostXYears: {
      one: "almost 1 year",
      other: "almost {{count}} years"
    }
  };
  var formatDistance = function formatDistance2(token, count2, options) {
    var result;
    var tokenValue = formatDistanceLocale[token];
    if (typeof tokenValue === "string") {
      result = tokenValue;
    } else if (count2 === 1) {
      result = tokenValue.one;
    } else {
      result = tokenValue.other.replace("{{count}}", count2.toString());
    }
    if (options !== null && options !== void 0 && options.addSuffix) {
      if (options.comparison && options.comparison > 0) {
        return "in " + result;
      } else {
        return result + " ago";
      }
    }
    return result;
  };
  const formatDistance$1 = formatDistance;
  function buildFormatLongFn(args) {
    return function() {
      var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      var width = options.width ? String(options.width) : args.defaultWidth;
      var format2 = args.formats[width] || args.formats[args.defaultWidth];
      return format2;
    };
  }
  var dateFormats = {
    full: "EEEE, MMMM do, y",
    long: "MMMM do, y",
    medium: "MMM d, y",
    short: "MM/dd/yyyy"
  };
  var timeFormats = {
    full: "h:mm:ss a zzzz",
    long: "h:mm:ss a z",
    medium: "h:mm:ss a",
    short: "h:mm a"
  };
  var dateTimeFormats = {
    full: "{{date}} 'at' {{time}}",
    long: "{{date}} 'at' {{time}}",
    medium: "{{date}}, {{time}}",
    short: "{{date}}, {{time}}"
  };
  var formatLong = {
    date: buildFormatLongFn({
      formats: dateFormats,
      defaultWidth: "full"
    }),
    time: buildFormatLongFn({
      formats: timeFormats,
      defaultWidth: "full"
    }),
    dateTime: buildFormatLongFn({
      formats: dateTimeFormats,
      defaultWidth: "full"
    })
  };
  const formatLong$1 = formatLong;
  var formatRelativeLocale = {
    lastWeek: "'last' eeee 'at' p",
    yesterday: "'yesterday at' p",
    today: "'today at' p",
    tomorrow: "'tomorrow at' p",
    nextWeek: "eeee 'at' p",
    other: "P"
  };
  var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
    return formatRelativeLocale[token];
  };
  const formatRelative$1 = formatRelative;
  function buildLocalizeFn(args) {
    return function(dirtyIndex, options) {
      var context2 = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
      var valuesArray;
      if (context2 === "formatting" && args.formattingValues) {
        var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
        var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
        valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
      } else {
        var _defaultWidth = args.defaultWidth;
        var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
        valuesArray = args.values[_width] || args.values[_defaultWidth];
      }
      var index2 = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
      return valuesArray[index2];
    };
  }
  var eraValues = {
    narrow: ["B", "A"],
    abbreviated: ["BC", "AD"],
    wide: ["Before Christ", "Anno Domini"]
  };
  var quarterValues = {
    narrow: ["1", "2", "3", "4"],
    abbreviated: ["Q1", "Q2", "Q3", "Q4"],
    wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
  };
  var monthValues = {
    narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
    abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
  };
  var dayValues = {
    narrow: ["S", "M", "T", "W", "T", "F", "S"],
    short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
    abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
  };
  var dayPeriodValues = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    }
  };
  var formattingDayPeriodValues = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    }
  };
  var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
    var number2 = Number(dirtyNumber);
    var rem100 = number2 % 100;
    if (rem100 > 20 || rem100 < 10) {
      switch (rem100 % 10) {
        case 1:
          return number2 + "st";
        case 2:
          return number2 + "nd";
        case 3:
          return number2 + "rd";
      }
    }
    return number2 + "th";
  };
  var localize = {
    ordinalNumber,
    era: buildLocalizeFn({
      values: eraValues,
      defaultWidth: "wide"
    }),
    quarter: buildLocalizeFn({
      values: quarterValues,
      defaultWidth: "wide",
      argumentCallback: function argumentCallback(quarter) {
        return quarter - 1;
      }
    }),
    month: buildLocalizeFn({
      values: monthValues,
      defaultWidth: "wide"
    }),
    day: buildLocalizeFn({
      values: dayValues,
      defaultWidth: "wide"
    }),
    dayPeriod: buildLocalizeFn({
      values: dayPeriodValues,
      defaultWidth: "wide",
      formattingValues: formattingDayPeriodValues,
      defaultFormattingWidth: "wide"
    })
  };
  const localize$1 = localize;
  function buildMatchFn(args) {
    return function(string2) {
      var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      var width = options.width;
      var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
      var matchResult = string2.match(matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
      var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
        return pattern.test(matchedString);
      }) : findKey(parsePatterns, function(pattern) {
        return pattern.test(matchedString);
      });
      var value;
      value = args.valueCallback ? args.valueCallback(key) : key;
      value = options.valueCallback ? options.valueCallback(value) : value;
      var rest = string2.slice(matchedString.length);
      return {
        value,
        rest
      };
    };
  }
  function findKey(object2, predicate) {
    for (var key in object2) {
      if (object2.hasOwnProperty(key) && predicate(object2[key])) {
        return key;
      }
    }
    return void 0;
  }
  function findIndex(array2, predicate) {
    for (var key = 0; key < array2.length; key++) {
      if (predicate(array2[key])) {
        return key;
      }
    }
    return void 0;
  }
  function buildMatchPatternFn(args) {
    return function(string2) {
      var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      var matchResult = string2.match(args.matchPattern);
      if (!matchResult)
        return null;
      var matchedString = matchResult[0];
      var parseResult = string2.match(args.parsePattern);
      if (!parseResult)
        return null;
      var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
      value = options.valueCallback ? options.valueCallback(value) : value;
      var rest = string2.slice(matchedString.length);
      return {
        value,
        rest
      };
    };
  }
  var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
  var parseOrdinalNumberPattern = /\d+/i;
  var matchEraPatterns = {
    narrow: /^(b|a)/i,
    abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
    wide: /^(before christ|before common era|anno domini|common era)/i
  };
  var parseEraPatterns = {
    any: [/^b/i, /^(a|c)/i]
  };
  var matchQuarterPatterns = {
    narrow: /^[1234]/i,
    abbreviated: /^q[1234]/i,
    wide: /^[1234](th|st|nd|rd)? quarter/i
  };
  var parseQuarterPatterns = {
    any: [/1/i, /2/i, /3/i, /4/i]
  };
  var matchMonthPatterns = {
    narrow: /^[jfmasond]/i,
    abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
    wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
  };
  var parseMonthPatterns = {
    narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
    any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
  };
  var matchDayPatterns = {
    narrow: /^[smtwf]/i,
    short: /^(su|mo|tu|we|th|fr|sa)/i,
    abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
    wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
  };
  var parseDayPatterns = {
    narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
    any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
  };
  var matchDayPeriodPatterns = {
    narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
    any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
  };
  var parseDayPeriodPatterns = {
    any: {
      am: /^a/i,
      pm: /^p/i,
      midnight: /^mi/i,
      noon: /^no/i,
      morning: /morning/i,
      afternoon: /afternoon/i,
      evening: /evening/i,
      night: /night/i
    }
  };
  var match$1 = {
    ordinalNumber: buildMatchPatternFn({
      matchPattern: matchOrdinalNumberPattern,
      parsePattern: parseOrdinalNumberPattern,
      valueCallback: function valueCallback(value) {
        return parseInt(value, 10);
      }
    }),
    era: buildMatchFn({
      matchPatterns: matchEraPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseEraPatterns,
      defaultParseWidth: "any"
    }),
    quarter: buildMatchFn({
      matchPatterns: matchQuarterPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseQuarterPatterns,
      defaultParseWidth: "any",
      valueCallback: function valueCallback(index2) {
        return index2 + 1;
      }
    }),
    month: buildMatchFn({
      matchPatterns: matchMonthPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseMonthPatterns,
      defaultParseWidth: "any"
    }),
    day: buildMatchFn({
      matchPatterns: matchDayPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseDayPatterns,
      defaultParseWidth: "any"
    }),
    dayPeriod: buildMatchFn({
      matchPatterns: matchDayPeriodPatterns,
      defaultMatchWidth: "any",
      parsePatterns: parseDayPeriodPatterns,
      defaultParseWidth: "any"
    })
  };
  const match$2 = match$1;
  var locale = {
    code: "en-US",
    formatDistance: formatDistance$1,
    formatLong: formatLong$1,
    formatRelative: formatRelative$1,
    localize: localize$1,
    match: match$2,
    options: {
      weekStartsOn: 0,
      firstWeekContainsDate: 1
    }
  };
  const defaultLocale = locale;
  var formattingTokensRegExp$1 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
  var longFormattingTokensRegExp$1 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp$1 = /^'([^]*?)'?$/;
  var doubleQuoteRegExp$1 = /''/g;
  var unescapedLatinCharacterRegExp$1 = /[a-zA-Z]/;
  function format$1(dirtyDate, dirtyFormatStr, options) {
    var _ref2, _options$locale, _ref22, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
    requiredArgs(2, arguments);
    var formatStr = String(dirtyFormatStr);
    var defaultOptions2 = getDefaultOptions();
    var locale2 = (_ref2 = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref2 !== void 0 ? _ref2 : defaultLocale;
    var firstWeekContainsDate = toInteger$2((_ref22 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref22 !== void 0 ? _ref22 : 1);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var weekStartsOn = toInteger$2((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    if (!locale2.localize) {
      throw new RangeError("locale must contain localize property");
    }
    if (!locale2.formatLong) {
      throw new RangeError("locale must contain formatLong property");
    }
    var originalDate = toDate(dirtyDate);
    if (!isValid(originalDate)) {
      throw new RangeError("Invalid time value");
    }
    var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
    var utcDate = subMilliseconds(originalDate, timezoneOffset);
    var formatterOptions = {
      firstWeekContainsDate,
      weekStartsOn,
      locale: locale2,
      _originalDate: originalDate
    };
    var result = formatStr.match(longFormattingTokensRegExp$1).map(function(substring) {
      var firstCharacter = substring[0];
      if (firstCharacter === "p" || firstCharacter === "P") {
        var longFormatter = longFormatters$1[firstCharacter];
        return longFormatter(substring, locale2.formatLong);
      }
      return substring;
    }).join("").match(formattingTokensRegExp$1).map(function(substring) {
      if (substring === "''") {
        return "'";
      }
      var firstCharacter = substring[0];
      if (firstCharacter === "'") {
        return cleanEscapedString$1(substring);
      }
      var formatter = formatters$1[firstCharacter];
      if (formatter) {
        if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
          throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
        }
        if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
          throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
        }
        return formatter(utcDate, substring, locale2.localize, formatterOptions);
      }
      if (firstCharacter.match(unescapedLatinCharacterRegExp$1)) {
        throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
      }
      return substring;
    }).join("");
    return result;
  }
  function cleanEscapedString$1(input) {
    var matched = input.match(escapedStringRegExp$1);
    if (!matched) {
      return input;
    }
    return matched[1].replace(doubleQuoteRegExp$1, "'");
  }
  var MILLISECONDS_IN_MINUTE = 6e4;
  function addMinutes(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addMilliseconds(dirtyDate, amount * MILLISECONDS_IN_MINUTE);
  }
  var MILLISECONDS_IN_HOUR = 36e5;
  function addHours(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addMilliseconds(dirtyDate, amount * MILLISECONDS_IN_HOUR);
  }
  function addDays(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var amount = toInteger$2(dirtyAmount);
    if (isNaN(amount)) {
      return new Date(NaN);
    }
    if (!amount) {
      return date;
    }
    date.setDate(date.getDate() + amount);
    return date;
  }
  function addWeeks(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    var days = amount * 7;
    return addDays(dirtyDate, days);
  }
  function addMonths(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var amount = toInteger$2(dirtyAmount);
    if (isNaN(amount)) {
      return new Date(NaN);
    }
    if (!amount) {
      return date;
    }
    var dayOfMonth = date.getDate();
    var endOfDesiredMonth = new Date(date.getTime());
    endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
    var daysInMonth = endOfDesiredMonth.getDate();
    if (dayOfMonth >= daysInMonth) {
      return endOfDesiredMonth;
    } else {
      date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
      return date;
    }
  }
  function addYears(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addMonths(dirtyDate, amount * 12);
  }
  function subDays(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addDays(dirtyDate, -amount);
  }
  function subWeeks(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addWeeks(dirtyDate, -amount);
  }
  function subMonths(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addMonths(dirtyDate, -amount);
  }
  function subYears(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger$2(dirtyAmount);
    return addYears(dirtyDate, -amount);
  }
  function getSeconds(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var seconds = date.getSeconds();
    return seconds;
  }
  function getMinutes(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var minutes = date.getMinutes();
    return minutes;
  }
  function getHours(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var hours = date.getHours();
    return hours;
  }
  function getDay(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var day = date.getDay();
    return day;
  }
  function getDate(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var dayOfMonth = date.getDate();
    return dayOfMonth;
  }
  function startOfWeek(dirtyDate, options) {
    var _ref2, _ref22, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
    requiredArgs(1, arguments);
    var defaultOptions2 = getDefaultOptions();
    var weekStartsOn = toInteger$2((_ref2 = (_ref22 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref22 !== void 0 ? _ref22 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : 0);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate(dirtyDate);
    var day = date.getDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setDate(date.getDate() - diff);
    date.setHours(0, 0, 0, 0);
    return date;
  }
  function startOfISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    return startOfWeek(dirtyDate, {
      weekStartsOn: 1
    });
  }
  function getISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var year = date.getFullYear();
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
    var startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);
    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
    var startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var year = getISOWeekYear(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setFullYear(year, 0, 4);
    fourthOfJanuary.setHours(0, 0, 0, 0);
    var date = startOfISOWeek(fourthOfJanuary);
    return date;
  }
  var MILLISECONDS_IN_WEEK = 6048e5;
  function getISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var diff = startOfISOWeek(date).getTime() - startOfISOWeekYear(date).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
  }
  function getMonth(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var month = date.getMonth();
    return month;
  }
  function getQuarter(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var quarter = Math.floor(date.getMonth() / 3) + 1;
    return quarter;
  }
  function getYear(dirtyDate) {
    requiredArgs(1, arguments);
    return toDate(dirtyDate).getFullYear();
  }
  function getTime(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var timestamp = date.getTime();
    return timestamp;
  }
  function setSeconds(dirtyDate, dirtySeconds) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var seconds = toInteger$2(dirtySeconds);
    date.setSeconds(seconds);
    return date;
  }
  function setMinutes(dirtyDate, dirtyMinutes) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var minutes = toInteger$2(dirtyMinutes);
    date.setMinutes(minutes);
    return date;
  }
  function setHours(dirtyDate, dirtyHours) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var hours = toInteger$2(dirtyHours);
    date.setHours(hours);
    return date;
  }
  function getDaysInMonth(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var year = date.getFullYear();
    var monthIndex = date.getMonth();
    var lastDayOfMonth = new Date(0);
    lastDayOfMonth.setFullYear(year, monthIndex + 1, 0);
    lastDayOfMonth.setHours(0, 0, 0, 0);
    return lastDayOfMonth.getDate();
  }
  function setMonth(dirtyDate, dirtyMonth) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var month = toInteger$2(dirtyMonth);
    var year = date.getFullYear();
    var day = date.getDate();
    var dateWithDesiredMonth = new Date(0);
    dateWithDesiredMonth.setFullYear(year, month, 15);
    dateWithDesiredMonth.setHours(0, 0, 0, 0);
    var daysInMonth = getDaysInMonth(dateWithDesiredMonth);
    date.setMonth(month, Math.min(day, daysInMonth));
    return date;
  }
  function setQuarter(dirtyDate, dirtyQuarter) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var quarter = toInteger$2(dirtyQuarter);
    var oldQuarter = Math.floor(date.getMonth() / 3) + 1;
    var diff = quarter - oldQuarter;
    return setMonth(date, date.getMonth() + diff * 3);
  }
  function setYear(dirtyDate, dirtyYear) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var year = toInteger$2(dirtyYear);
    if (isNaN(date.getTime())) {
      return new Date(NaN);
    }
    date.setFullYear(year);
    return date;
  }
  function min$2(dirtyDatesArray) {
    requiredArgs(1, arguments);
    var datesArray;
    if (dirtyDatesArray && typeof dirtyDatesArray.forEach === "function") {
      datesArray = dirtyDatesArray;
    } else if (_typeof$6(dirtyDatesArray) === "object" && dirtyDatesArray !== null) {
      datesArray = Array.prototype.slice.call(dirtyDatesArray);
    } else {
      return new Date(NaN);
    }
    var result;
    datesArray.forEach(function(dirtyDate) {
      var currentDate = toDate(dirtyDate);
      if (result === void 0 || result > currentDate || isNaN(currentDate.getDate())) {
        result = currentDate;
      }
    });
    return result || new Date(NaN);
  }
  function max$2(dirtyDatesArray) {
    requiredArgs(1, arguments);
    var datesArray;
    if (dirtyDatesArray && typeof dirtyDatesArray.forEach === "function") {
      datesArray = dirtyDatesArray;
    } else if (_typeof$6(dirtyDatesArray) === "object" && dirtyDatesArray !== null) {
      datesArray = Array.prototype.slice.call(dirtyDatesArray);
    } else {
      return new Date(NaN);
    }
    var result;
    datesArray.forEach(function(dirtyDate) {
      var currentDate = toDate(dirtyDate);
      if (result === void 0 || result < currentDate || isNaN(Number(currentDate))) {
        result = currentDate;
      }
    });
    return result || new Date(NaN);
  }
  function startOfDay(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    date.setHours(0, 0, 0, 0);
    return date;
  }
  var MILLISECONDS_IN_DAY = 864e5;
  function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var startOfDayLeft = startOfDay(dirtyDateLeft);
    var startOfDayRight = startOfDay(dirtyDateRight);
    var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
    var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
    return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
  }
  function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var dateLeft = toDate(dirtyDateLeft);
    var dateRight = toDate(dirtyDateRight);
    var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
    var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
    return yearDiff * 12 + monthDiff;
  }
  function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var dateLeft = toDate(dirtyDateLeft);
    var dateRight = toDate(dirtyDateRight);
    return dateLeft.getFullYear() - dateRight.getFullYear();
  }
  function startOfMonth(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    date.setDate(1);
    date.setHours(0, 0, 0, 0);
    return date;
  }
  function startOfQuarter(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var currentMonth = date.getMonth();
    var month = currentMonth - currentMonth % 3;
    date.setMonth(month, 1);
    date.setHours(0, 0, 0, 0);
    return date;
  }
  function startOfYear(dirtyDate) {
    requiredArgs(1, arguments);
    var cleanDate = toDate(dirtyDate);
    var date = new Date(0);
    date.setFullYear(cleanDate.getFullYear(), 0, 1);
    date.setHours(0, 0, 0, 0);
    return date;
  }
  function endOfDay(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    date.setHours(23, 59, 59, 999);
    return date;
  }
  function isEqual$2(dirtyLeftDate, dirtyRightDate) {
    requiredArgs(2, arguments);
    var dateLeft = toDate(dirtyLeftDate);
    var dateRight = toDate(dirtyRightDate);
    return dateLeft.getTime() === dateRight.getTime();
  }
  function isSameDay(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
    var dateRightStartOfDay = startOfDay(dirtyDateRight);
    return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
  }
  function isSameMonth(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var dateLeft = toDate(dirtyDateLeft);
    var dateRight = toDate(dirtyDateRight);
    return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
  }
  function isSameYear(dirtyDateLeft, dirtyDateRight) {
    requiredArgs(2, arguments);
    var dateLeft = toDate(dirtyDateLeft);
    var dateRight = toDate(di