"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineStartPipelineExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an AWS CodePipeline pipeline as a target for AWS EventBridge Scheduler.
 */
class CodePipelineStartPipelineExecution extends target_1.ScheduleTargetBase {
    constructor(pipeline, props = {}) {
        super(props, pipeline.pipelineArn);
        this.pipeline = pipeline;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodePipelineStartPipelineExecution);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        const region = this.pipeline.env.region ?? '';
        const account = this.pipeline.env.account ?? '';
        if (!(0, util_1.sameEnvDimension)(region, schedule.env.region)) {
            throw new Error(`Cannot assign pipeline in region ${region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the pipeline must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(account, schedule.env.account)) {
            throw new Error(`Cannot assign pipeline in account ${account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the pipeline must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.pipeline.node)} in account ${account}. Both the target and the execution role must be in the same account.`);
        }
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:StartPipelineExecution'],
            resources: [this.pipeline.pipelineArn],
        }));
    }
}
exports.CodePipelineStartPipelineExecution = CodePipelineStartPipelineExecution;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineStartPipelineExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.CodePipelineStartPipelineExecution", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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