import { ISchedule, IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { CfnAssessmentTemplate } from 'aws-cdk-lib/aws-inspector';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an Amazon Inspector as a target for AWS EventBridge Scheduler.
 */
export declare class InspectorStartAssessmentRun extends ScheduleTargetBase implements IScheduleTarget {
    private readonly template;
    private readonly props;
    constructor(template: CfnAssessmentTemplate, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
}
