import { ISchedule, IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an Amazon Kinesis Data Firehose as a target for AWS EventBridge Scheduler.
 */
export declare class KinesisDataFirehosePutRecord extends ScheduleTargetBase implements IScheduleTarget {
    private readonly deliveryStream;
    private readonly props;
    constructor(deliveryStream: CfnDeliveryStream, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
}
