"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataFirehosePutRecord = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an Amazon Kinesis Data Firehose as a target for AWS EventBridge Scheduler.
 */
class KinesisDataFirehosePutRecord extends target_1.ScheduleTargetBase {
    constructor(deliveryStream, props = {}) {
        super(props, deliveryStream.attrArn);
        this.deliveryStream = deliveryStream;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisDataFirehosePutRecord);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.deliveryStream.stack.region, schedule.env.region)) {
            throw new Error(`Cannot assign the Firehose delivery stream in region ${this.deliveryStream.stack.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the Firehose delivery stream must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.deliveryStream.stack.account, schedule.env.account)) {
            throw new Error(`Cannot assign the Firehose delivery stream in account ${this.deliveryStream.stack.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the Firehose delivery stream must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.deliveryStream.stack.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.deliveryStream.node)} in account ${this.deliveryStream.stack.account}. Both the target and the execution role must be in the same account.`);
        }
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['firehose:PutRecord'],
            resources: [this.deliveryStream.attrArn],
        }));
    }
}
exports.KinesisDataFirehosePutRecord = KinesisDataFirehosePutRecord;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataFirehosePutRecord[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.KinesisDataFirehosePutRecord", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1kYXRhLWZpcmVob3NlLXB1dC1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJraW5lc2lzLWRhdGEtZmlyZWhvc2UtcHV0LXJlY29yZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSw2Q0FBb0M7QUFDcEMsaURBQTZEO0FBRTdELHFDQUF1RTtBQUN2RSxpQ0FBMEM7QUFFMUM7O0dBRUc7QUFDSCxNQUFhLDRCQUE2QixTQUFRLDJCQUFrQjtJQUNsRSxZQUNtQixjQUFpQyxFQUNqQyxRQUFpQyxFQUFFO1FBRXBELEtBQUssQ0FBQyxLQUFLLEVBQUUsY0FBYyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBSHBCLG1CQUFjLEdBQWQsY0FBYyxDQUFtQjtRQUNqQyxVQUFLLEdBQUwsS0FBSyxDQUE4Qjs7Ozs7OytDQUgzQyw0QkFBNEI7Ozs7S0FNdEM7SUFFUyxxQkFBcUIsQ0FBQyxRQUFtQixFQUFFLElBQVc7UUFDOUQsSUFBSSxDQUFDLElBQUEsdUJBQWdCLEVBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztZQUM3RSxNQUFNLElBQUksS0FBSyxDQUFDLHdEQUF3RCxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxNQUFNLG9CQUFvQixtQkFBSyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxNQUFNLGtGQUFrRixDQUFDLENBQUM7UUFDcFIsQ0FBQztRQUVELElBQUksQ0FBQyxJQUFBLHVCQUFnQixFQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDL0UsTUFBTSxJQUFJLEtBQUssQ0FBQyx5REFBeUQsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsT0FBTyxvQkFBb0IsbUJBQUssQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxlQUFlLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxtRkFBbUYsQ0FBQyxDQUFDO1FBQ3hSLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsSUFBQSx1QkFBZ0IsRUFBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDekcsTUFBTSxJQUFJLEtBQUssQ0FBQyx3REFBd0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8scUJBQXFCLG1CQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLGVBQWUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsT0FBTyx1RUFBdUUsQ0FBQyxDQUFDO1FBQy9SLENBQUM7UUFFRCxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSx5QkFBZSxDQUFDO1lBQzVDLE9BQU8sRUFBRSxDQUFDLG9CQUFvQixDQUFDO1lBQy9CLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDO1NBQ3pDLENBQUMsQ0FBQyxDQUFDO0tBQ0w7O0FBekJILG9FQTBCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTY2hlZHVsZSwgSVNjaGVkdWxlVGFyZ2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNjaGVkdWxlci1hbHBoYSc7XG5pbXBvcnQgeyBOYW1lcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IElSb2xlLCBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENmbkRlbGl2ZXJ5U3RyZWFtIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWtpbmVzaXNmaXJlaG9zZSc7XG5pbXBvcnQgeyBTY2hlZHVsZVRhcmdldEJhc2UsIFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi90YXJnZXQnO1xuaW1wb3J0IHsgc2FtZUVudkRpbWVuc2lvbiB9IGZyb20gJy4vdXRpbCc7XG5cbi8qKlxuICogVXNlIGFuIEFtYXpvbiBLaW5lc2lzIERhdGEgRmlyZWhvc2UgYXMgYSB0YXJnZXQgZm9yIEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBLaW5lc2lzRGF0YUZpcmVob3NlUHV0UmVjb3JkIGV4dGVuZHMgU2NoZWR1bGVUYXJnZXRCYXNlIGltcGxlbWVudHMgSVNjaGVkdWxlVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBkZWxpdmVyeVN0cmVhbTogQ2ZuRGVsaXZlcnlTdHJlYW0sXG4gICAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgPSB7fSxcbiAgKSB7XG4gICAgc3VwZXIocHJvcHMsIGRlbGl2ZXJ5U3RyZWFtLmF0dHJBcm4pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFkZFRhcmdldEFjdGlvblRvUm9sZShzY2hlZHVsZTogSVNjaGVkdWxlLCByb2xlOiBJUm9sZSk6IHZvaWQge1xuICAgIGlmICghc2FtZUVudkRpbWVuc2lvbih0aGlzLmRlbGl2ZXJ5U3RyZWFtLnN0YWNrLnJlZ2lvbiwgc2NoZWR1bGUuZW52LnJlZ2lvbikpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGFzc2lnbiB0aGUgRmlyZWhvc2UgZGVsaXZlcnkgc3RyZWFtIGluIHJlZ2lvbiAke3RoaXMuZGVsaXZlcnlTdHJlYW0uc3RhY2sucmVnaW9ufSB0byB0aGUgc2NoZWR1bGUgJHtOYW1lcy5ub2RlVW5pcXVlSWQoc2NoZWR1bGUubm9kZSl9IGluIHJlZ2lvbiAke3NjaGVkdWxlLmVudi5yZWdpb259LiBCb3RoIHRoZSBzY2hlZHVsZSBhbmQgdGhlIEZpcmVob3NlIGRlbGl2ZXJ5IHN0cmVhbSBtdXN0IGJlIGluIHRoZSBzYW1lIHJlZ2lvbi5gKTtcbiAgICB9XG5cbiAgICBpZiAoIXNhbWVFbnZEaW1lbnNpb24odGhpcy5kZWxpdmVyeVN0cmVhbS5zdGFjay5hY2NvdW50LCBzY2hlZHVsZS5lbnYuYWNjb3VudCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGFzc2lnbiB0aGUgRmlyZWhvc2UgZGVsaXZlcnkgc3RyZWFtIGluIGFjY291bnQgJHt0aGlzLmRlbGl2ZXJ5U3RyZWFtLnN0YWNrLmFjY291bnR9IHRvIHRoZSBzY2hlZHVsZSAke05hbWVzLm5vZGVVbmlxdWVJZChzY2hlZHVsZS5ub2RlKX0gaW4gYWNjb3VudCAke3NjaGVkdWxlLmVudi5yZWdpb259LiBCb3RoIHRoZSBzY2hlZHVsZSBhbmQgdGhlIEZpcmVob3NlIGRlbGl2ZXJ5IHN0cmVhbSBtdXN0IGJlIGluIHRoZSBzYW1lIGFjY291bnQuYCk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvcHMucm9sZSAmJiAhc2FtZUVudkRpbWVuc2lvbih0aGlzLnByb3BzLnJvbGUuZW52LmFjY291bnQsIHRoaXMuZGVsaXZlcnlTdHJlYW0uc3RhY2suYWNjb3VudCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGdyYW50IHBlcm1pc3Npb24gdG8gZXhlY3V0aW9uIHJvbGUgaW4gYWNjb3VudCAke3RoaXMucHJvcHMucm9sZS5lbnYuYWNjb3VudH0gdG8gaW52b2tlIHRhcmdldCAke05hbWVzLm5vZGVVbmlxdWVJZCh0aGlzLmRlbGl2ZXJ5U3RyZWFtLm5vZGUpfSBpbiBhY2NvdW50ICR7dGhpcy5kZWxpdmVyeVN0cmVhbS5zdGFjay5hY2NvdW50fS4gQm90aCB0aGUgdGFyZ2V0IGFuZCB0aGUgZXhlY3V0aW9uIHJvbGUgbXVzdCBiZSBpbiB0aGUgc2FtZSBhY2NvdW50LmApO1xuICAgIH1cblxuICAgIHJvbGUuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ2ZpcmVob3NlOlB1dFJlY29yZCddLFxuICAgICAgcmVzb3VyY2VzOiBbdGhpcy5kZWxpdmVyeVN0cmVhbS5hdHRyQXJuXSxcbiAgICB9KSk7XG4gIH1cbn0iXX0=