"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStreamPutRecord = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an Amazon Kinesis Data Streams as a target for AWS EventBridge Scheduler.
 */
class KinesisStreamPutRecord extends target_1.ScheduleTargetBase {
    constructor(stream, props) {
        super(props, stream.streamArn);
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_KinesisStreamPutRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisStreamPutRecord);
            }
            throw error;
        }
        if (!aws_cdk_lib_1.Token.isUnresolved(props.partitionKey) && (props.partitionKey.length < 1 || props.partitionKey.length > 256)) {
            throw new Error(`partitionKey length must be between 1 and 256, got ${props.partitionKey.length}`);
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.stream.env.region, schedule.env.region)) {
            throw new Error(`Cannot assign stream in region ${this.stream.env.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the stream must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.stream.env.account, schedule.env.account)) {
            throw new Error(`Cannot assign stream in account ${this.stream.env.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the stream must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.stream.env.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.stream.node)} in account ${this.stream.env.account}. Both the target and the execution role must be in the same account.`);
        }
        this.stream.grantWrite(role);
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            kinesisParameters: {
                partitionKey: this.props.partitionKey,
            },
        };
    }
}
exports.KinesisStreamPutRecord = KinesisStreamPutRecord;
_a = JSII_RTTI_SYMBOL_1;
KinesisStreamPutRecord[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.KinesisStreamPutRecord", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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