"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerStartPipelineExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use a SageMaker pipeline as a target for AWS EventBridge Scheduler.
 */
class SageMakerStartPipelineExecution extends target_1.ScheduleTargetBase {
    constructor(pipeline, props = {}) {
        super(props, pipeline.pipelineArn);
        this.pipeline = pipeline;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_SageMakerStartPipelineExecutionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SageMakerStartPipelineExecution);
            }
            throw error;
        }
        if (props.pipelineParameterList !== undefined && props.pipelineParameterList.length > 200) {
            throw new Error(`pipelineParameterList length must be between 0 and 200, got ${props.pipelineParameterList.length}`);
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.pipeline.stack.region, schedule.env.region)) {
            throw new Error(`Cannot assign pipeline in region ${this.pipeline.stack.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the pipeline must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.pipeline.stack.account, schedule.env.account)) {
            throw new Error(`Cannot assign pipeline in account ${this.pipeline.stack.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the pipeline must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.pipeline.stack.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.pipeline.node)} in account ${this.pipeline.stack.account}. Both the target and the execution role must be in the same account.`);
        }
        this.pipeline.grantStartPipelineExecution(role);
    }
    bindBaseTargetConfig(schedule) {
        const sageMakerPipelineParameters = this.props.pipelineParameterList ? {
            pipelineParameterList: this.props.pipelineParameterList.map(param => {
                return {
                    name: param.name,
                    value: param.value,
                };
            }),
        } : undefined;
        return {
            ...super.bindBaseTargetConfig(schedule),
            sageMakerPipelineParameters,
        };
    }
}
exports.SageMakerStartPipelineExecution = SageMakerStartPipelineExecution;
_a = JSII_RTTI_SYMBOL_1;
SageMakerStartPipelineExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SageMakerStartPipelineExecution", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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