"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsSendMessage = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an Amazon SQS Queue as a target for AWS EventBridge Scheduler.
 */
class SqsSendMessage extends target_1.ScheduleTargetBase {
    constructor(queue, props) {
        super(props, queue.queueArn);
        this.queue = queue;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_SqsSendMessageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsSendMessage);
            }
            throw error;
        }
        if (props.messageGroupId !== undefined) {
            if (!aws_cdk_lib_1.Token.isUnresolved(props.messageGroupId) && (props.messageGroupId.length < 1 || props.messageGroupId.length > 128)) {
                throw new Error(`messageGroupId length must be between 1 and 128, got ${props.messageGroupId.length}`);
            }
            if (!queue.fifo) {
                throw new Error('target must be a FIFO queue if messageGroupId is specified');
            }
            if (!queue.node.defaultChild.contentBasedDeduplication) {
                throw new Error('contentBasedDeduplication must be true if the target is a FIFO queue');
            }
        }
        else if (queue.fifo) {
            throw new Error('messageGroupId must be specified if the target is a FIFO queue');
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.queue.env.region, schedule.env.region)) {
            throw new Error(`Cannot assign queue in region ${this.queue.env.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the queue must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.queue.env.account, schedule.env.account)) {
            throw new Error(`Cannot assign queue in account ${this.queue.env.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the queue must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.queue.env.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.queue.node)} in account ${this.queue.env.account}. Both the target and the execution role must be in the same account.`);
        }
        this.queue.grantSendMessages(role);
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            sqsParameters: {
                messageGroupId: this.props.messageGroupId,
            },
        };
    }
}
exports.SqsSendMessage = SqsSendMessage;
_a = JSII_RTTI_SYMBOL_1;
SqsSendMessage[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SqsSendMessage", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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