"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsStartExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an AWS Step function as a target for AWS EventBridge Scheduler.
 */
class StepFunctionsStartExecution extends target_1.ScheduleTargetBase {
    constructor(stateMachine, props) {
        super(props, stateMachine.stateMachineArn);
        this.stateMachine = stateMachine;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsStartExecution);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        const stateMachineEnv = this.stateMachine.env;
        if (!(0, util_1.sameEnvDimension)(stateMachineEnv.region, schedule.env.region)) {
            throw new Error(`Cannot assign stateMachine in region ${stateMachineEnv.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the stateMachine must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(stateMachineEnv.account, schedule.env.account)) {
            throw new Error(`Cannot assign stateMachine in account ${stateMachineEnv.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the stateMachine must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, stateMachineEnv.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.stateMachine.node)} in account ${stateMachineEnv.account}. Both the target and the execution role must be in the same account.`);
        }
        this.stateMachine.grantStartExecution(role);
    }
}
exports.StepFunctionsStartExecution = StepFunctionsStartExecution;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsStartExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.StepFunctionsStartExecution", version: "2.131.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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