from typing import Literal

from ..utils import _Parseable
from ..wikicode import Wikicode
from ._base import Node
from .extras.attribute import Attribute

__all__ = ["Tag"]

class Tag(Node):
    def __init__(
        self,
        tag: _Parseable,
        contents: _Parseable = ...,
        attrs: list[Attribute] | None = ...,
        wiki_markup: str | None = ...,
        self_closing: bool = ...,
        invalid: bool = ...,
        implicit: bool = ...,
        padding: str = ...,
        closing_tag: _Parseable = ...,
        wiki_style_separator: str | None = ...,
        closing_wiki_markup: str | None = ...,
    ) -> None: ...
    @property
    def tag(self) -> Wikicode: ...
    @tag.setter
    def tag(self, value: _Parseable) -> None: ...
    @property
    def contents(self) -> Wikicode: ...
    @contents.setter
    def contents(self, value: _Parseable) -> None: ...
    @property
    def attributes(self) -> list[Attribute]: ...
    @property
    def wiki_markup(self) -> str | None: ...
    @wiki_markup.setter
    def wiki_markup(self, value: str | None) -> None: ...
    @property
    def self_closing(self) -> bool: ...
    @self_closing.setter
    def self_closing(self, value: bool) -> None: ...
    @property
    def invalid(self) -> bool: ...
    @invalid.setter
    def invalid(self, value: bool) -> None: ...
    @property
    def implicit(self) -> bool: ...
    @implicit.setter
    def implicit(self, value: bool) -> None: ...
    @property
    def padding(self) -> str: ...
    @padding.setter
    def padding(self, value: str) -> None: ...
    @property
    def closing_tag(self) -> Wikicode: ...
    @closing_tag.setter
    def closing_tag(self, value: _Parseable) -> None: ...
    @property
    def wiki_style_separator(self) -> str | None: ...
    @wiki_style_separator.setter
    def wiki_style_separator(self, value: str | None) -> None: ...
    @property
    def closing_wiki_markup(self) -> str | None: ...
    @closing_wiki_markup.setter
    def closing_wiki_markup(self, value: str | None) -> None: ...
    def has(self, name: str | Attribute | Wikicode) -> bool: ...
    def get(self, name: str | Attribute | Wikicode) -> Attribute: ...
    def add(
        self,
        name: _Parseable,
        value: _Parseable = ...,
        quotes: Literal['"', "'"] | None = ...,
        pad_first: str = ...,
        pad_before_eq: str = ...,
        pad_after_eq: str = ...,
    ) -> Attribute: ...
    def remove(self, name: str) -> None: ...
