from collections.abc import Callable, Iterable, Iterator
from typing import Any, SupportsIndex, TypeVar, overload

from _typeshed import SupportsRichComparison, SupportsRichComparisonT
from typing_extensions import Self

from .smart_list import SmartList

_T = TypeVar("_T")
_S = TypeVar("_S")

class ListProxy(list[_T]):
    def __init__(
        self,
        parent: SmartList[_T],
        sliceinfo: list[int],
    ) -> None: ...
    def __reduce_ex__(
        self,
        protocol: SupportsIndex,
    ) -> tuple[type[Self], tuple[Self, list[int]], tuple[()]]: ...
    def __setstate__(self, state: tuple[Any, ...]) -> None: ...
    def __lt__(self, other: list[_T]) -> bool: ...
    def __le__(self, other: list[_T]) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __gt__(self, other: list[_T]) -> bool: ...
    def __ge__(self, other: list[_T]) -> bool: ...
    def __bool__(self) -> bool: ...
    @overload
    def __getitem__(self, key: SupportsIndex) -> _T: ...
    @overload
    def __getitem__(self, key: slice) -> Self: ...
    @overload
    def __setitem__(self, key: SupportsIndex, item: _T) -> None: ...
    @overload
    def __setitem__(self, key: slice, item: Iterable[_T]) -> None: ...
    def __delitem__(self, key: SupportsIndex | slice) -> None: ...
    def __iter__(self) -> Iterator[_T]: ...
    def __reversed__(self) -> Iterator[_T]: ...
    def __contains__(self, item: object) -> bool: ...
    @overload
    def __add__(self, other: list[_T]) -> SmartList[_T]: ...
    @overload
    def __add__(self, other: list[_S]) -> SmartList[_S | _T]: ...
    @overload
    def __radd__(self, other: list[_T]) -> SmartList[_T]: ...
    @overload
    def __radd__(self, other: list[_S]) -> SmartList[_S | _T]: ...  # type: ignore[misc]
    def __iadd__(self, other: Iterable[_T]) -> Self: ...  # type: ignore[misc,override]
    def __mul__(self, other: SupportsIndex) -> list[_T]: ...
    def __rmul__(self, other: SupportsIndex) -> list[_T]: ...
    def __imul__(self, other: SupportsIndex) -> Self: ...
    def append(self, item: _T) -> None: ...
    def count(self, item: _T) -> int: ...
    def index(
        self,
        item: _T,
        start: SupportsIndex | None = ...,
        stop: SupportsIndex | None = ...,
    ) -> int: ...
    def extend(self, item: Iterable[_T]) -> None: ...
    def insert(self, index: SupportsIndex, item: _T) -> None: ...
    def pop(self, index: SupportsIndex | None = ...) -> _T: ...
    def remove(self, item: _T) -> None: ...
    def reverse(self) -> None: ...
    @overload
    def sort(
        self: ListProxy[SupportsRichComparisonT],
        *,
        key: None = None,
        reverse: bool | None = ...,
    ) -> None: ...
    @overload
    def sort(
        self,
        *,
        key: Callable[[_T], SupportsRichComparison],
        reverse: bool | None = ...,
    ) -> None: ...
