__all__ = [
    "Token",
    "Text",
    "TemplateOpen",
    "TemplateParamSeparator",
    "TemplateParamEquals",
    "TemplateClose",
    "ArgumentOpen",
    "ArgumentSeparator",
    "ArgumentClose",
    "WikilinkOpen",
    "WikilinkSeparator",
    "WikilinkClose",
    "ExternalLinkOpen",
    "ExternalLinkSeparator",
    "ExternalLinkClose",
    "HTMLEntityStart",
    "HTMLEntityNumeric",
    "HTMLEntityHex",
    "HTMLEntityEnd",
    "HeadingStart",
    "HeadingEnd",
    "CommentStart",
    "CommentEnd",
    "TagOpenOpen",
    "TagAttrStart",
    "TagAttrEquals",
    "TagAttrQuote",
    "TagCloseOpen",
    "TagCloseSelfclose",
    "TagOpenClose",
    "TagCloseClose",
]

class Token(dict[str, str]):
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __getattr__(self, key: str) -> str: ...
    def __setattr__(self, key: str, value: str) -> None: ...
    def __delattr__(self, key: str) -> None: ...

class Text(Token): ...
class TemplateOpen(Token): ...
class TemplateParamSeparator(Token): ...
class TemplateParamEquals(Token): ...
class TemplateClose(Token): ...
class ArgumentOpen(Token): ...
class ArgumentSeparator(Token): ...
class ArgumentClose(Token): ...
class WikilinkOpen(Token): ...
class WikilinkSeparator(Token): ...
class WikilinkClose(Token): ...
class ExternalLinkOpen(Token): ...
class ExternalLinkSeparator(Token): ...
class ExternalLinkClose(Token): ...
class HTMLEntityStart(Token): ...
class HTMLEntityNumeric(Token): ...
class HTMLEntityHex(Token): ...
class HTMLEntityEnd(Token): ...
class HeadingStart(Token): ...
class HeadingEnd(Token): ...
class CommentStart(Token): ...
class CommentEnd(Token): ...
class TagOpenOpen(Token): ...
class TagAttrStart(Token): ...
class TagAttrEquals(Token): ...
class TagAttrQuote(Token): ...
class TagCloseOpen(Token): ...
class TagCloseSelfclose(Token): ...
class TagOpenClose(Token): ...
class TagCloseClose(Token): ...
