from collections.abc import Callable, Iterable, Iterator
from typing import Any, SupportsIndex, TypeVar, overload

from _typeshed import SupportsRichComparison, SupportsRichComparisonT
from typing_extensions import Self

from .list_proxy import ListProxy

_T = TypeVar("_T")
_S = TypeVar("_S")

class SmartList(list[_T]):
    def __new__(cls, *args: Any, **kwargs: Any) -> Self: ...
    def __reduce_ex__(
        self,
        protocol: SupportsIndex,
    ) -> tuple[type[Self], tuple[()], None, Iterator[_T]]: ...
    @overload
    def __getitem__(self, key: SupportsIndex) -> _T: ...
    @overload
    def __getitem__(self, key: slice) -> ListProxy[_T]: ...
    @overload
    def __setitem__(self, key: SupportsIndex, item: _T) -> None: ...
    @overload
    def __setitem__(self, key: slice, item: Iterable[_T]) -> None: ...
    def __delitem__(self, key: SupportsIndex | slice) -> None: ...
    @overload
    def __add__(self, other: list[_T]) -> Self: ...
    @overload
    def __add__(self, other: list[_S]) -> SmartList[_S | _T]: ...
    @overload
    def __radd__(self, other: list[_T]) -> Self: ...
    @overload
    def __radd__(self, other: list[_S]) -> SmartList[_S | _T]: ...  # type: ignore[misc]
    def __iadd__(self, other: Iterable[_T]) -> Self: ...  # type: ignore[misc,override]
    def append(self, item: _T) -> None: ...
    def extend(self, item: Iterable[_T]) -> None: ...
    def insert(self, index: SupportsIndex, item: _T) -> None: ...
    def pop(self, index: SupportsIndex | None = ...) -> _T: ...
    def remove(self, item: _T) -> None: ...
    def reverse(self) -> None: ...
    @overload
    def sort(
        self: SmartList[SupportsRichComparisonT],
        *,
        key: None = None,
        reverse: bool | None = ...,
    ) -> None: ...
    @overload
    def sort(
        self,
        *,
        key: Callable[[_T], SupportsRichComparison],
        reverse: bool | None = ...,
    ) -> None: ...
