from collections.abc import Iterable, Iterator, Mapping
from typing import Any, SupportsIndex

__all__ = ["StringMixIn"]

class StringMixIn:
    def __bytes__(self) -> bytes: ...
    def __lt__(self, other: str | StringMixIn) -> bool: ...
    def __le__(self, other: str | StringMixIn) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __gt__(self, other: str | StringMixIn) -> bool: ...
    def __ge__(self, other: str | StringMixIn) -> bool: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[str]: ...
    def __getitem__(self, key: SupportsIndex | slice) -> str: ...
    def __reversed__(self) -> Iterator[str]: ...
    def __contains__(self, item: object) -> bool: ...
    def capitalize(self) -> str: ...
    def casefold(self) -> str: ...
    def center(self, width: int, fillchar: str = ...) -> str: ...
    def count(
        self,
        sub: str | StringMixIn,
        start: SupportsIndex | None = ...,
        end: SupportsIndex | None = ...,
    ) -> int: ...
    def encode(self, encoding: str = ..., errors: str = ...) -> bytes: ...
    def endswith(
        self,
        suffix: str | tuple[str, ...],
        start: int | None = ...,
        end: int | None = ...,
    ) -> bool: ...
    def expandtabs(self, tabsize: int = ...) -> str: ...
    def find(
        self,
        sub: str | StringMixIn,
        start: SupportsIndex | None = ...,
        end: SupportsIndex | None = ...,
    ) -> int: ...
    def format(self, /, *args: Any, **kwds: Any) -> str: ...
    def format_map(self, mapping: Mapping[str, Any]) -> str: ...
    def index(
        self,
        sub: str | StringMixIn,
        start: SupportsIndex | None = ...,
        end: SupportsIndex | None = ...,
    ) -> int: ...
    def isalpha(self) -> bool: ...
    def isalnum(self) -> bool: ...
    def isascii(self) -> bool: ...
    def isdecimal(self) -> bool: ...
    def isdigit(self) -> bool: ...
    def isidentifier(self) -> bool: ...
    def islower(self) -> bool: ...
    def isnumeric(self) -> bool: ...
    def isprintable(self) -> bool: ...
    def isspace(self) -> bool: ...
    def istitle(self) -> bool: ...
    def isupper(self) -> bool: ...
    def join(self, seq: Iterable[str]) -> str: ...
    def ljust(self, width: int, fillchar: str = ...) -> str: ...
    def lower(self) -> str: ...
    def lstrip(self, chars: str | None = ...) -> str: ...
    maketrans = str.maketrans
    def partition(self, sep: str) -> tuple[str, str, str]: ...
    def removeprefix(self, prefix: str | StringMixIn, /) -> str: ...
    def removesuffix(self, suffix: str | StringMixIn, /) -> str: ...
    def replace(
        self,
        old: str | StringMixIn,
        new: str | StringMixIn,
        /,
        count: int = ...,
    ) -> str: ...
    def rfind(
        self,
        sub: str | StringMixIn,
        start: SupportsIndex | None = ...,
        end: SupportsIndex | None = ...,
    ) -> int: ...
    def rindex(
        self,
        sub: str,
        start: SupportsIndex | None = ...,
        end: SupportsIndex | None = ...,
    ) -> int: ...
    def rjust(self, width: int, fillchar: str = ...) -> str: ...
    def rpartition(self, sep: str) -> tuple[str, str, str]: ...
    def rsplit(self, sep: str | None = ..., maxsplit: int = ...) -> list[str]: ...
    def rstrip(self, chars: str | None = ...) -> str: ...
    def split(self, sep: str | None = ..., maxsplit: int = ...) -> list[str]: ...
    def splitlines(self, keepends: bool = ...) -> list[str]: ...
    def startswith(
        self,
        prefix: str | tuple[str, ...],
        start: int | None = ...,
        end: int | None = ...,
    ) -> bool: ...
    def strip(self, chars: str | None = ...) -> str: ...
    def swapcase(self) -> str: ...
    def title(self) -> str: ...
    def translate(self, *args: Any) -> str: ...
    def upper(self) -> str: ...
    def zfill(self, width: int) -> str: ...
