import logging
from dataclasses import dataclass

import config

logging.basicConfig(level=config.debug_level,
                    format='%(asctime)s %(levelname)s %(pathname)s %(funcName)s %(lineno)d : %(message)s',
                    datefmt='%d/%m/%Y %H:%M:%S',
                    filename=config.logs_file_path,
                    filemode='a')


@dataclass
class Label:
    id: int
    label_name: str
    contacts: list

    # @staticmethod
    # def get_all():
    #     pass

    # @staticmethod
    # def get_label_by_id(id_label):
    #     pass
    #
    # def get_contacts_by_label_id(self):
    #     pass

