import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnService`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export interface CfnServiceProps {
    /**
     * The source to deploy to the App Runner service.
     *
     * It can be a code or an image repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration
     */
    readonly sourceConfiguration: CfnService.SourceConfigurationProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
     *
     * If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn
     */
    readonly autoScalingConfigurationArn?: string;
    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     *
     * By default, App Runner uses an AWS managed key .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration
     */
    readonly encryptionConfiguration?: CfnService.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of your service.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration
     */
    readonly healthCheckConfiguration?: CfnService.HealthCheckConfigurationProperty | cdk.IResolvable;
    /**
     * The runtime configuration of instances (scaling units) of the App Runner service.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration
     */
    readonly instanceConfiguration?: CfnService.InstanceConfigurationProperty | cdk.IResolvable;
    /**
     * A name for the new service.
     *
     * It must be unique across all the running App Runner services in your AWS account in the AWS Region .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename
     */
    readonly serviceName?: string;
    /**
     * An optional list of metadata items that you can associate with your service resource.
     *
     * A tag is a key-value pair.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare class CfnService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppRunner::Service";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnService;
    /**
     * The Amazon Resource Name (ARN) of this service.
     *
     * @external
     * @cloudformationAttribute ServiceArn
     */
    readonly attrServiceArn: string;
    /**
     * An ID that App Runner generated for this service.
     *
     * It's unique within the AWS Region .
     *
     * @external
     * @cloudformationAttribute ServiceId
     */
    readonly attrServiceId: string;
    /**
     * A subdomain URL that App Runner generated for this service.
     *
     * You can use this URL to access your service web application.
     *
     * @external
     * @cloudformationAttribute ServiceUrl
     */
    readonly attrServiceUrl: string;
    /**
     * The current state of the App Runner service. These particular values mean the following.
     *
     * - `CREATE_FAILED` – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.
     *
     * The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.
     * - `DELETE_FAILED` – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.
     *
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * The source to deploy to the App Runner service.
     *
     * It can be a code or an image repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration
     */
    sourceConfiguration: CfnService.SourceConfigurationProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
     *
     * If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn
     */
    autoScalingConfigurationArn: string | undefined;
    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     *
     * By default, App Runner uses an AWS managed key .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration
     */
    encryptionConfiguration: CfnService.EncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of your service.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration
     */
    healthCheckConfiguration: CfnService.HealthCheckConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * The runtime configuration of instances (scaling units) of the App Runner service.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration
     */
    instanceConfiguration: CfnService.InstanceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * A name for the new service.
     *
     * It must be unique across all the running App Runner services in your AWS account in the AWS Region .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename
     */
    serviceName: string | undefined;
    /**
     * An optional list of metadata items that you can associate with your service resource.
     *
     * A tag is a key-value pair.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppRunner::Service`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServiceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes resources needed to authenticate access to some source repositories.
     *
     * The specific resource depends on the repository provider.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html
     */
    interface AuthenticationConfigurationProperty {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository.
         *
         * It's required for ECR image repositories (but not for ECR Public repositories).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-accessrolearn
         */
        readonly accessRoleArn?: string;
        /**
         * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository.
         *
         * It's required for GitHub code repositories.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-connectionarn
         */
        readonly connectionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the configuration that AWS App Runner uses to build and run an App Runner service from a source code repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html
     */
    interface CodeConfigurationProperty {
        /**
         * The basic configuration for building and running the App Runner service.
         *
         * Use it to quickly launch an App Runner service without providing a `apprunner.yaml` file in the source code repository (or ignoring the file if it exists).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-codeconfigurationvalues
         */
        readonly codeConfigurationValues?: CfnService.CodeConfigurationValuesProperty | cdk.IResolvable;
        /**
         * The source of the App Runner configuration. Values are interpreted as follows:.
         *
         * - `REPOSITORY` – App Runner reads configuration values from the `apprunner.yaml` file in the source code repository and ignores `CodeConfigurationValues` .
         * - `API` – App Runner uses configuration values provided in `CodeConfigurationValues` and ignores the `apprunner.yaml` file in the source code repository.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-configurationsource
         */
        readonly configurationSource: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the basic configuration needed for building and running an AWS App Runner service.
     *
     * This type doesn't support the full set of possible configuration options. Fur full configuration capabilities, use a `apprunner.yaml` file in the source code repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html
     */
    interface CodeConfigurationValuesProperty {
        /**
         * The command App Runner runs to build your application.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-buildcommand
         */
        readonly buildCommand?: string;
        /**
         * The port that your application listens to in the container.
         *
         * Default: `8080`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-port
         */
        readonly port?: string;
        /**
         * A runtime environment type for building and running an App Runner service.
         *
         * It represents a programming language runtime.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime
         */
        readonly runtime: string;
        /**
         * The environment variables that are available to your running App Runner service.
         *
         * An array of key-value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentvariables
         */
        readonly runtimeEnvironmentVariables?: Array<CfnService.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The command App Runner runs to start your application.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-startcommand
         */
        readonly startCommand?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes a source code repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html
     */
    interface CodeRepositoryProperty {
        /**
         * Configuration for building and running the service from a source code repository.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-codeconfiguration
         */
        readonly codeConfiguration?: CfnService.CodeConfigurationProperty | cdk.IResolvable;
        /**
         * The location of the repository that contains the source code.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-repositoryurl
         */
        readonly repositoryUrl: string;
        /**
         * The version that should be used within the source code repository.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcecodeversion
         */
        readonly sourceCodeVersion: CfnService.SourceCodeVersionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes a custom encryption key that AWS App Runner uses to encrypt copies of the source repository and service logs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * The ARN of the KMS key that's used for encryption.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html#cfn-apprunner-service-encryptionconfiguration-kmskey
         */
        readonly kmsKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the settings for the health check that AWS App Runner performs to monitor the health of a service.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html
     */
    interface HealthCheckConfigurationProperty {
        /**
         * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
         *
         * Default: `1`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-healthythreshold
         */
        readonly healthyThreshold?: number;
        /**
         * The time interval, in seconds, between health checks.
         *
         * Default: `5`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-interval
         */
        readonly interval?: number;
        /**
         * The URL that health check requests are sent to.
         *
         * `Path` is only applicable when you set `Protocol` to `HTTP` .
         *
         * Default: `"/"`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-path
         */
        readonly path?: string;
        /**
         * The IP protocol that App Runner uses to perform health checks for your service.
         *
         * If you set `Protocol` to `HTTP` , App Runner sends health check requests to the HTTP path specified by `Path` .
         *
         * Default: `TCP`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-protocol
         */
        readonly protocol?: string;
        /**
         * The time, in seconds, to wait for a health check response before deciding it failed.
         *
         * Default: `2`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-timeout
         */
        readonly timeout?: number;
        /**
         * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
         *
         * Default: `5`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-unhealthythreshold
         */
        readonly unhealthyThreshold?: number;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the configuration that AWS App Runner uses to run an App Runner service using an image pulled from a source image repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html
     */
    interface ImageConfigurationProperty {
        /**
         * The port that your application listens to in the container.
         *
         * Default: `8080`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
         */
        readonly port?: string;
        /**
         * Environment variables that are available to your running App Runner service.
         *
         * An array of key-value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentvariables
         */
        readonly runtimeEnvironmentVariables?: Array<CfnService.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An optional command that App Runner runs to start the application in the source image.
         *
         * If specified, this command overrides the Docker image’s default start command.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-startcommand
         */
        readonly startCommand?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes a source image repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html
     */
    interface ImageRepositoryProperty {
        /**
         * Configuration for running the identified image.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageconfiguration
         */
        readonly imageConfiguration?: CfnService.ImageConfigurationProperty | cdk.IResolvable;
        /**
         * The identifier of an image.
         *
         * For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see [Pulling an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html) in the *Amazon ECR User Guide* .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageidentifier
         */
        readonly imageIdentifier: string;
        /**
         * The type of the image repository.
         *
         * This reflects the repository provider and whether the repository is private or public.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imagerepositorytype
         */
        readonly imageRepositoryType: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the runtime configuration of an AWS App Runner service instance (scaling unit).
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html
     */
    interface InstanceConfigurationProperty {
        /**
         * The number of CPU units reserved for each instance of your App Runner service.
         *
         * Default: `1 vCPU`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
         */
        readonly cpu?: string;
        /**
         * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service.
         *
         * These are permissions that your code needs when it calls any AWS APIs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-instancerolearn
         */
        readonly instanceRoleArn?: string;
        /**
         * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
         *
         * Default: `2 GB`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
         */
        readonly memory?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes a key-value pair, which is a string-to-string mapping.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html
     */
    interface KeyValuePairProperty {
        /**
         * The key name string to map to a value.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-name
         */
        readonly name?: string;
        /**
         * The value string to which the key name is mapped.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Identifies a version of code that AWS App Runner refers to within a source code repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html
     */
    interface SourceCodeVersionProperty {
        /**
         * The type of version identifier.
         *
         * For a git-based repository, branches represent versions.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-type
         */
        readonly type: string;
        /**
         * A source code version.
         *
         * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * Specify an AWS App Runner service by using the `AWS::AppRunner::Service` resource in an AWS CloudFormation template.
 *
 * The `AWS::AppRunner::Service` resource is an AWS App Runner resource type that specifies an App Runner service.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * Describes the source deployed to an AWS App Runner service.
     *
     * It can be a code or an image repository.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html
     */
    interface SourceConfigurationProperty {
        /**
         * Describes the resources that are needed to authenticate access to some source repositories.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-authenticationconfiguration
         */
        readonly authenticationConfiguration?: CfnService.AuthenticationConfigurationProperty | cdk.IResolvable;
        /**
         * If `true` , continuous integration from the source repository is enabled for the App Runner service.
         *
         * Each repository change (including any source code commit or new image version) starts a deployment.
         *
         * Default: App Runner sets to `false` for a source image that uses an ECR Public repository or an ECR repository that's in an AWS account other than the one that the service is in. App Runner sets to `true` in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-autodeploymentsenabled
         */
        readonly autoDeploymentsEnabled?: boolean | cdk.IResolvable;
        /**
         * The description of a source code repository.
         *
         * You must provide either this member or `ImageRepository` (but not both).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-coderepository
         */
        readonly codeRepository?: CfnService.CodeRepositoryProperty | cdk.IResolvable;
        /**
         * The description of a source image repository.
         *
         * You must provide either this member or `CodeRepository` (but not both).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-imagerepository
         */
        readonly imageRepository?: CfnService.ImageRepositoryProperty | cdk.IResolvable;
    }
}
