# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 strategy: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_domain_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['ConnectionOptionsArgs']] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_as_button: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[_builtins.str] strategy: Type of the connection, which indicates the identity provider.
        :param pulumi.Input[_builtins.str] display_name: Name used in login screen.
        :param pulumi.Input[_builtins.bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        :param pulumi.Input[_builtins.str] name: Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        :param pulumi.Input['ConnectionOptionsArgs'] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[_builtins.bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        """
        pulumi.set(__self__, "strategy", strategy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_domain_connection is not None:
            pulumi.set(__self__, "is_domain_connection", is_domain_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if realms is not None:
            pulumi.set(__self__, "realms", realms)
        if show_as_button is not None:
            pulumi.set(__self__, "show_as_button", show_as_button)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "strategy", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @is_domain_connection.setter
    def is_domain_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_domain_connection", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ConnectionOptionsArgs']]:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ConnectionOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def realms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "realms", value)

    @_builtins.property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @show_as_button.setter
    def show_as_button(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_as_button", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_domain_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['ConnectionOptionsArgs']] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_as_button: Optional[pulumi.Input[_builtins.bool]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[_builtins.str] display_name: Name used in login screen.
        :param pulumi.Input[_builtins.bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        :param pulumi.Input[_builtins.str] name: Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        :param pulumi.Input['ConnectionOptionsArgs'] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[_builtins.bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[_builtins.str] strategy: Type of the connection, which indicates the identity provider.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_domain_connection is not None:
            pulumi.set(__self__, "is_domain_connection", is_domain_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if realms is not None:
            pulumi.set(__self__, "realms", realms)
        if show_as_button is not None:
            pulumi.set(__self__, "show_as_button", show_as_button)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @is_domain_connection.setter
    def is_domain_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_domain_connection", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ConnectionOptionsArgs']]:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ConnectionOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def realms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "realms", value)

    @_builtins.property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @show_as_button.setter
    def show_as_button(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_as_button", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy", value)


@pulumi.type_token("auth0:index/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_domain_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['ConnectionOptionsArgs', 'ConnectionOptionsArgsDict']]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_as_button: Optional[pulumi.Input[_builtins.bool]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With Auth0, you can define sources of users, otherwise known as connections, which may include identity providers (such as Google or LinkedIn), databases, or passwordless authentication methods. This resource allows you to configure and manage connections to be used with your clients and users.

        > The Auth0 dashboard displays only one connection per social provider. Although the Auth0 Management API allows the
        creation of multiple connections per strategy, the additional connections may not be visible in the Auth0 dashboard.

        > When updating the `options` parameter, ensure that all nested fields within the `options` schema are explicitly defined. Failing to do so may result in the loss of existing configurations.

        ## Example Usage

        ### Auth0 Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an Auth0 connection.
        my_connection = auth0.Connection("my_connection",
            name="Example-Connection",
            is_domain_connection=True,
            strategy="auth0",
            metadata={
                "key1": "foo",
                "key2": "bar",
            },
            options={
                "password_policy": "excellent",
                "brute_force_protection": True,
                "strategy_version": 2,
                "enabled_database_customization": True,
                "import_mode": False,
                "requires_username": True,
                "disable_signup": False,
                "custom_scripts": {
                    "get_user": \"\"\"        function getByEmail(email, callback) {
                  return callback(new Error("Whoops!"));
                }
        \"\"\",
                },
                "configuration": {
                    "foo": "bar",
                    "bar": "baz",
                },
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "password_histories": [{
                    "enable": True,
                    "size": 3,
                }],
                "password_no_personal_info": {
                    "enable": True,
                },
                "password_dictionary": {
                    "enable": True,
                    "dictionaries": [
                        "password",
                        "admin",
                        "1234",
                    ],
                },
                "password_complexity_options": {
                    "min_length": 12,
                },
                "validation": {
                    "username": {
                        "min": 10,
                        "max": 40,
                    },
                },
                "mfa": {
                    "active": True,
                    "return_enroll_settings": True,
                },
                "authentication_methods": [{
                    "passkey": {
                        "enabled": True,
                    },
                    "password": {
                        "enabled": True,
                    },
                }],
                "passkey_options": {
                    "challenge_ui": "both",
                    "local_enrollment_enabled": True,
                    "progressive_enrollment_enabled": True,
                },
            })
        ```

        ### Google OAuth2 Connection

        > Your Auth0 account may be pre-configured with a `google-oauth2` connection.

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a Google OAuth2 connection.
        google_oauth2 = auth0.Connection("google_oauth2",
            name="Google-OAuth2-Connection",
            strategy="google-oauth2",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "allowed_audiences": [
                    "example.com",
                    "api.example.com",
                ],
                "scopes": [
                    "email",
                    "profile",
                    "gmail",
                    "youtube",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Google Apps

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        google_apps = auth0.Connection("google_apps",
            name="connection-google-apps",
            is_domain_connection=False,
            strategy="google-apps",
            show_as_button=False,
            options={
                "client_id": "",
                "client_secret": "",
                "domain": "example.com",
                "tenant_domain": "example.com",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "api_enable_users": True,
                "scopes": [
                    "ext_profile",
                    "ext_groups",
                ],
                "icon_url": "https://example.com/assets/logo.png",
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Facebook Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a Facebook connection.
        facebook = auth0.Connection("facebook",
            name="Facebook-Connection",
            strategy="facebook",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "scopes": [
                    "public_profile",
                    "email",
                    "groups_access_member_info",
                    "user_birthday",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Apple Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an Apple connection.
        apple = auth0.Connection("apple",
            name="Apple-Connection",
            strategy="apple",
            options={
                "client_id": "<client-id>",
                "client_secret": \"\"\"-----BEGIN PRIVATE KEY-----
        MIHBAgEAMA0GCSqGSIb3DQEBAQUABIGsMIGpAgEAA
        -----END PRIVATE KEY-----\"\"\",
                "team_id": "<team-id>",
                "key_id": "<key-id>",
                "scopes": [
                    "email",
                    "name",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### LinkedIn Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an LinkedIn connection.
        linkedin = auth0.Connection("linkedin",
            name="Linkedin-Connection",
            strategy="linkedin",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "basic_profile",
                    "profile",
                    "email",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### GitHub Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an GitHub connection.
        github = auth0.Connection("github",
            name="GitHub-Connection",
            strategy="github",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "scopes": [
                    "email",
                    "profile",
                    "public_repo",
                    "repo",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### SalesForce Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an SalesForce connection.
        salesforce = auth0.Connection("salesforce",
            name="Salesforce-Connection",
            strategy="salesforce",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "community_base_url": "https://salesforce.example.com",
                "scopes": [
                    "openid",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### OAuth2 Connection

        Also applies to following connection strategies: `dropbox`, `bitbucket`, `paypal`, `twitter`, `amazon`, `yahoo`, `box`, `wordpress`, `shopify`, `custom`

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an OAuth2 connection.
        oauth2 = auth0.Connection("oauth2",
            name="OAuth2-Connection",
            strategy="oauth2",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "basic_profile",
                    "profile",
                    "email",
                ],
                "token_endpoint": "https://auth.example.com/oauth2/token",
                "authorization_endpoint": "https://auth.example.com/oauth2/authorize",
                "pkce_enabled": True,
                "icon_url": "https://auth.example.com/assets/logo.png",
                "custom_headers": [
                    {
                        "header": "bar",
                        "value": "foo",
                    },
                    {
                        "header": "foo",
                        "value": "bar",
                    },
                ],
                "scripts": {
                    "fetchUserProfile": \"\"\"        function fetchUserProfile(accessToken, context, callback) {
                  return callback(new Error("Whoops!"));
                }
        \"\"\",
                },
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Active Directory (AD)

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        ad = auth0.Connection("ad",
            name="connection-active-directory",
            display_name="Active Directory Connection",
            strategy="ad",
            show_as_button=True,
            options={
                "disable_self_service_change_password": True,
                "brute_force_protection": True,
                "tenant_domain": "example.com",
                "strategy_version": 2,
                "icon_url": "https://example.com/assets/logo.png",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "ips": [
                    "192.168.1.1",
                    "192.168.1.2",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "use_cert_auth": False,
                "use_kerberos": False,
                "disable_cache": False,
            })
        ```

        ### Azure AD Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        azure_ad = auth0.Connection("azure_ad",
            name="connection-azure-ad",
            strategy="waad",
            show_as_button=True,
            options={
                "identity_api": "azure-active-directory-v1.0",
                "client_id": "123456",
                "client_secret": "123456",
                "strategy_version": 2,
                "user_id_attribute": "oid",
                "app_id": "app-id-123",
                "tenant_domain": "example.onmicrosoft.com",
                "domain": "example.onmicrosoft.com",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "icon_url": "https://example.onmicrosoft.com/assets/logo.png",
                "use_wsfed": False,
                "waad_protocol": "openid-connect",
                "waad_common_endpoint": False,
                "max_groups_to_retrieve": "250",
                "api_enable_users": True,
                "scopes": [
                    "basic_profile",
                    "ext_groups",
                    "ext_profile",
                ],
                "set_user_root_attributes": "on_each_login",
                "should_trust_email_verified_connection": "never_set_emails_as_verified",
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Email Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "email".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an Email connection.
        passwordless_email = auth0.Connection("passwordless_email",
            strategy="email",
            name="email",
            options={
                "name": "email",
                "from_": "{{ application.name }} <root@auth0.com>",
                "subject": "Welcome to {{ application.name }}",
                "syntax": "liquid",
                "template": "<html>This is the body of the email</html>",
                "disable_signup": False,
                "brute_force_protection": True,
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [],
                "auth_params": {
                    "scope": "openid email profile offline_access",
                    "response_type": "code",
                },
                "totp": {
                    "time_step": 300,
                    "length": 6,
                },
            })
        ```

        ### SAML Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of a SAML connection.
        samlp = auth0.Connection("samlp",
            name="SAML-Connection",
            strategy="samlp",
            options={
                "debug": False,
                "signing_cert": "<signing-certificate>",
                "sign_in_endpoint": "https://saml.provider/sign_in",
                "sign_out_endpoint": "https://saml.provider/sign_out",
                "global_token_revocation_jwt_iss": "issuer.example.com",
                "global_token_revocation_jwt_sub": "user123",
                "disable_sign_out": True,
                "strategy_version": 2,
                "tenant_domain": "example.com",
                "domain_aliases": [
                    "example.com",
                    "alias.example.com",
                ],
                "protocol_binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                "request_template": \"\"\"<samlp:AuthnRequest xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol"
        @@AssertServiceURLAndDestination@@
            ID="@@ID@@"
            IssueInstant="@@IssueInstant@@"
            ProtocolBinding="@@ProtocolBinding@@" Version="2.0">
            <saml:Issuer xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">@@Issuer@@</saml:Issuer>
        </samlp:AuthnRequest>\"\"\",
                "user_id_attribute": "https://saml.provider/imi/ns/identity-200810",
                "signature_algorithm": "rsa-sha256",
                "digest_algorithm": "sha256",
                "icon_url": "https://saml.provider/assets/logo.png",
                "entity_id": "<entity_id>",
                "metadata_xml": \"\"\"    <?xml version="1.0"?>
            <md:EntityDescriptor xmlns:md="urn:oasis:names:tc:SAML:2.0:metadata" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" entityID="https://example.com">
              <md:IDPSSODescriptor protocolSupportEnumeration="urn:oasis:names:tc:SAML:2.0:protocol">
                <md:SingleLogoutService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://saml.provider/sign_out"/>
                <md:SingleSignOnService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://saml.provider/sign_in"/>
              </md:IDPSSODescriptor>
            </md:EntityDescriptor>
        \"\"\",
                "metadata_url": "https://saml.provider/imi/ns/FederationMetadata.xml",
                "fields_map": json.dumps({
                    "name": [
                        "name",
                        "nameidentifier",
                    ],
                    "email": [
                        "emailaddress",
                        "nameidentifier",
                    ],
                    "family_name": "surname",
                }),
                "signing_key": {
                    "key": \"\"\"-----BEGIN PRIVATE KEY-----
        ...{your private key here}...
        -----END PRIVATE KEY-----\"\"\",
                    "cert": \"\"\"-----BEGIN CERTIFICATE-----
        ...{your public key cert here}...
        -----END CERTIFICATE-----\"\"\",
                },
                "decryption_key": {
                    "key": \"\"\"-----BEGIN PRIVATE KEY-----
        ...{your private key here}...
        -----END PRIVATE KEY-----\"\"\",
                    "cert": \"\"\"-----BEGIN CERTIFICATE-----
        ...{your public key cert here}...
        -----END CERTIFICATE-----\"\"\",
                },
                "idp_initiated": {
                    "client_id": "client_id",
                    "client_protocol": "samlp",
                    "client_authorize_query": "type=code&timeout=30",
                },
            })
        ```

        ### WindowsLive Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a WindowsLive connection.
        windowslive = auth0.Connection("windowslive",
            name="Windowslive-Connection",
            strategy="windowslive",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "signin",
                    "graph_user",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### OIDC Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an OIDC connection.
        oidc = auth0.Connection("oidc",
            name="oidc-connection",
            display_name="OIDC Connection",
            strategy="oidc",
            show_as_button=False,
            options={
                "client_id": "1234567",
                "client_secret": "1234567",
                "domain_aliases": ["example.com"],
                "tenant_domain": "",
                "icon_url": "https://example.com/assets/logo.png",
                "type": "back_channel",
                "issuer": "https://www.paypalobjects.com",
                "jwks_uri": "https://api.paypal.com/v1/oauth2/certs",
                "discovery_url": "https://www.paypalobjects.com/.well-known/openid-configuration",
                "token_endpoint": "https://api.paypal.com/v1/oauth2/token",
                "userinfo_endpoint": "https://api.paypal.com/v1/oauth2/token/userinfo",
                "authorization_endpoint": "https://www.paypal.com/signin/authorize",
                "scopes": [
                    "openid",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "connection_settings": {
                    "pkce": "auto",
                },
                "attribute_map": {
                    "mapping_mode": "use_map",
                    "userinfo_scope": "openid email profile groups",
                    "attributes": json.dumps({
                        "name": "${context.tokenset.name}",
                        "email": "${context.tokenset.email}",
                        "email_verified": "${context.tokenset.email_verified}",
                        "nickname": "${context.tokenset.nickname}",
                        "picture": "${context.tokenset.picture}",
                        "given_name": "${context.tokenset.given_name}",
                        "family_name": "${context.tokenset.family_name}",
                    }),
                },
            })
        ```

        ### Okta Connection

        !> When configuring an Okta Workforce connection, the `scopes` attribute must be explicitly set. If omitted, the connection may not function correctly.
        To ensure proper behavior, always specify:  `scopes = ["openid", "profile", "email"]`

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an Okta Workforce connection.
        okta = auth0.Connection("okta",
            name="okta-connection",
            display_name="Okta Workforce Connection",
            strategy="okta",
            show_as_button=False,
            options={
                "client_id": "1234567",
                "client_secret": "1234567",
                "domain": "example.okta.com",
                "domain_aliases": ["example.com"],
                "issuer": "https://example.okta.com",
                "jwks_uri": "https://example.okta.com/oauth2/v1/keys",
                "token_endpoint": "https://example.okta.com/oauth2/v1/token",
                "userinfo_endpoint": "https://example.okta.com/oauth2/v1/userinfo",
                "authorization_endpoint": "https://example.okta.com/oauth2/v1/authorize",
                "scopes": [
                    "openid",
                    "profile",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "connection_settings": {
                    "pkce": "auto",
                },
                "attribute_map": {
                    "mapping_mode": "basic_profile",
                    "userinfo_scope": "openid email profile groups",
                    "attributes": json.dumps({
                        "name": "${context.tokenset.name}",
                        "email": "${context.tokenset.email}",
                        "email_verified": "${context.tokenset.email_verified}",
                        "nickname": "${context.tokenset.nickname}",
                        "picture": "${context.tokenset.picture}",
                        "given_name": "${context.tokenset.given_name}",
                        "family_name": "${context.tokenset.family_name}",
                    }),
                },
            })
        ```

        ## Import

        This resource can be imported by specifying the connection ID.

        Example:

        ```sh
        $ pulumi import auth0:index/connection:Connection google "con_a17f21fdb24d48a0"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Name used in login screen.
        :param pulumi.Input[_builtins.bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        :param pulumi.Input[_builtins.str] name: Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        :param pulumi.Input[Union['ConnectionOptionsArgs', 'ConnectionOptionsArgsDict']] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[_builtins.bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[_builtins.str] strategy: Type of the connection, which indicates the identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With Auth0, you can define sources of users, otherwise known as connections, which may include identity providers (such as Google or LinkedIn), databases, or passwordless authentication methods. This resource allows you to configure and manage connections to be used with your clients and users.

        > The Auth0 dashboard displays only one connection per social provider. Although the Auth0 Management API allows the
        creation of multiple connections per strategy, the additional connections may not be visible in the Auth0 dashboard.

        > When updating the `options` parameter, ensure that all nested fields within the `options` schema are explicitly defined. Failing to do so may result in the loss of existing configurations.

        ## Example Usage

        ### Auth0 Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an Auth0 connection.
        my_connection = auth0.Connection("my_connection",
            name="Example-Connection",
            is_domain_connection=True,
            strategy="auth0",
            metadata={
                "key1": "foo",
                "key2": "bar",
            },
            options={
                "password_policy": "excellent",
                "brute_force_protection": True,
                "strategy_version": 2,
                "enabled_database_customization": True,
                "import_mode": False,
                "requires_username": True,
                "disable_signup": False,
                "custom_scripts": {
                    "get_user": \"\"\"        function getByEmail(email, callback) {
                  return callback(new Error("Whoops!"));
                }
        \"\"\",
                },
                "configuration": {
                    "foo": "bar",
                    "bar": "baz",
                },
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "password_histories": [{
                    "enable": True,
                    "size": 3,
                }],
                "password_no_personal_info": {
                    "enable": True,
                },
                "password_dictionary": {
                    "enable": True,
                    "dictionaries": [
                        "password",
                        "admin",
                        "1234",
                    ],
                },
                "password_complexity_options": {
                    "min_length": 12,
                },
                "validation": {
                    "username": {
                        "min": 10,
                        "max": 40,
                    },
                },
                "mfa": {
                    "active": True,
                    "return_enroll_settings": True,
                },
                "authentication_methods": [{
                    "passkey": {
                        "enabled": True,
                    },
                    "password": {
                        "enabled": True,
                    },
                }],
                "passkey_options": {
                    "challenge_ui": "both",
                    "local_enrollment_enabled": True,
                    "progressive_enrollment_enabled": True,
                },
            })
        ```

        ### Google OAuth2 Connection

        > Your Auth0 account may be pre-configured with a `google-oauth2` connection.

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a Google OAuth2 connection.
        google_oauth2 = auth0.Connection("google_oauth2",
            name="Google-OAuth2-Connection",
            strategy="google-oauth2",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "allowed_audiences": [
                    "example.com",
                    "api.example.com",
                ],
                "scopes": [
                    "email",
                    "profile",
                    "gmail",
                    "youtube",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Google Apps

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        google_apps = auth0.Connection("google_apps",
            name="connection-google-apps",
            is_domain_connection=False,
            strategy="google-apps",
            show_as_button=False,
            options={
                "client_id": "",
                "client_secret": "",
                "domain": "example.com",
                "tenant_domain": "example.com",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "api_enable_users": True,
                "scopes": [
                    "ext_profile",
                    "ext_groups",
                ],
                "icon_url": "https://example.com/assets/logo.png",
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Facebook Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a Facebook connection.
        facebook = auth0.Connection("facebook",
            name="Facebook-Connection",
            strategy="facebook",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "scopes": [
                    "public_profile",
                    "email",
                    "groups_access_member_info",
                    "user_birthday",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Apple Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an Apple connection.
        apple = auth0.Connection("apple",
            name="Apple-Connection",
            strategy="apple",
            options={
                "client_id": "<client-id>",
                "client_secret": \"\"\"-----BEGIN PRIVATE KEY-----
        MIHBAgEAMA0GCSqGSIb3DQEBAQUABIGsMIGpAgEAA
        -----END PRIVATE KEY-----\"\"\",
                "team_id": "<team-id>",
                "key_id": "<key-id>",
                "scopes": [
                    "email",
                    "name",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### LinkedIn Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an LinkedIn connection.
        linkedin = auth0.Connection("linkedin",
            name="Linkedin-Connection",
            strategy="linkedin",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "basic_profile",
                    "profile",
                    "email",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### GitHub Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an GitHub connection.
        github = auth0.Connection("github",
            name="GitHub-Connection",
            strategy="github",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "scopes": [
                    "email",
                    "profile",
                    "public_repo",
                    "repo",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### SalesForce Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an SalesForce connection.
        salesforce = auth0.Connection("salesforce",
            name="Salesforce-Connection",
            strategy="salesforce",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "community_base_url": "https://salesforce.example.com",
                "scopes": [
                    "openid",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### OAuth2 Connection

        Also applies to following connection strategies: `dropbox`, `bitbucket`, `paypal`, `twitter`, `amazon`, `yahoo`, `box`, `wordpress`, `shopify`, `custom`

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an OAuth2 connection.
        oauth2 = auth0.Connection("oauth2",
            name="OAuth2-Connection",
            strategy="oauth2",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "basic_profile",
                    "profile",
                    "email",
                ],
                "token_endpoint": "https://auth.example.com/oauth2/token",
                "authorization_endpoint": "https://auth.example.com/oauth2/authorize",
                "pkce_enabled": True,
                "icon_url": "https://auth.example.com/assets/logo.png",
                "custom_headers": [
                    {
                        "header": "bar",
                        "value": "foo",
                    },
                    {
                        "header": "foo",
                        "value": "bar",
                    },
                ],
                "scripts": {
                    "fetchUserProfile": \"\"\"        function fetchUserProfile(accessToken, context, callback) {
                  return callback(new Error("Whoops!"));
                }
        \"\"\",
                },
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Active Directory (AD)

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        ad = auth0.Connection("ad",
            name="connection-active-directory",
            display_name="Active Directory Connection",
            strategy="ad",
            show_as_button=True,
            options={
                "disable_self_service_change_password": True,
                "brute_force_protection": True,
                "tenant_domain": "example.com",
                "strategy_version": 2,
                "icon_url": "https://example.com/assets/logo.png",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "ips": [
                    "192.168.1.1",
                    "192.168.1.2",
                ],
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "use_cert_auth": False,
                "use_kerberos": False,
                "disable_cache": False,
            })
        ```

        ### Azure AD Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        azure_ad = auth0.Connection("azure_ad",
            name="connection-azure-ad",
            strategy="waad",
            show_as_button=True,
            options={
                "identity_api": "azure-active-directory-v1.0",
                "client_id": "123456",
                "client_secret": "123456",
                "strategy_version": 2,
                "user_id_attribute": "oid",
                "app_id": "app-id-123",
                "tenant_domain": "example.onmicrosoft.com",
                "domain": "example.onmicrosoft.com",
                "domain_aliases": [
                    "example.com",
                    "api.example.com",
                ],
                "icon_url": "https://example.onmicrosoft.com/assets/logo.png",
                "use_wsfed": False,
                "waad_protocol": "openid-connect",
                "waad_common_endpoint": False,
                "max_groups_to_retrieve": "250",
                "api_enable_users": True,
                "scopes": [
                    "basic_profile",
                    "ext_groups",
                    "ext_profile",
                ],
                "set_user_root_attributes": "on_each_login",
                "should_trust_email_verified_connection": "never_set_emails_as_verified",
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### Email Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "email".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an Email connection.
        passwordless_email = auth0.Connection("passwordless_email",
            strategy="email",
            name="email",
            options={
                "name": "email",
                "from_": "{{ application.name }} <root@auth0.com>",
                "subject": "Welcome to {{ application.name }}",
                "syntax": "liquid",
                "template": "<html>This is the body of the email</html>",
                "disable_signup": False,
                "brute_force_protection": True,
                "set_user_root_attributes": "on_each_login",
                "non_persistent_attrs": [],
                "auth_params": {
                    "scope": "openid email profile offline_access",
                    "response_type": "code",
                },
                "totp": {
                    "time_step": 300,
                    "length": 6,
                },
            })
        ```

        ### SAML Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of a SAML connection.
        samlp = auth0.Connection("samlp",
            name="SAML-Connection",
            strategy="samlp",
            options={
                "debug": False,
                "signing_cert": "<signing-certificate>",
                "sign_in_endpoint": "https://saml.provider/sign_in",
                "sign_out_endpoint": "https://saml.provider/sign_out",
                "global_token_revocation_jwt_iss": "issuer.example.com",
                "global_token_revocation_jwt_sub": "user123",
                "disable_sign_out": True,
                "strategy_version": 2,
                "tenant_domain": "example.com",
                "domain_aliases": [
                    "example.com",
                    "alias.example.com",
                ],
                "protocol_binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                "request_template": \"\"\"<samlp:AuthnRequest xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol"
        @@AssertServiceURLAndDestination@@
            ID="@@ID@@"
            IssueInstant="@@IssueInstant@@"
            ProtocolBinding="@@ProtocolBinding@@" Version="2.0">
            <saml:Issuer xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">@@Issuer@@</saml:Issuer>
        </samlp:AuthnRequest>\"\"\",
                "user_id_attribute": "https://saml.provider/imi/ns/identity-200810",
                "signature_algorithm": "rsa-sha256",
                "digest_algorithm": "sha256",
                "icon_url": "https://saml.provider/assets/logo.png",
                "entity_id": "<entity_id>",
                "metadata_xml": \"\"\"    <?xml version="1.0"?>
            <md:EntityDescriptor xmlns:md="urn:oasis:names:tc:SAML:2.0:metadata" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" entityID="https://example.com">
              <md:IDPSSODescriptor protocolSupportEnumeration="urn:oasis:names:tc:SAML:2.0:protocol">
                <md:SingleLogoutService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://saml.provider/sign_out"/>
                <md:SingleSignOnService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://saml.provider/sign_in"/>
              </md:IDPSSODescriptor>
            </md:EntityDescriptor>
        \"\"\",
                "metadata_url": "https://saml.provider/imi/ns/FederationMetadata.xml",
                "fields_map": json.dumps({
                    "name": [
                        "name",
                        "nameidentifier",
                    ],
                    "email": [
                        "emailaddress",
                        "nameidentifier",
                    ],
                    "family_name": "surname",
                }),
                "signing_key": {
                    "key": \"\"\"-----BEGIN PRIVATE KEY-----
        ...{your private key here}...
        -----END PRIVATE KEY-----\"\"\",
                    "cert": \"\"\"-----BEGIN CERTIFICATE-----
        ...{your public key cert here}...
        -----END CERTIFICATE-----\"\"\",
                },
                "decryption_key": {
                    "key": \"\"\"-----BEGIN PRIVATE KEY-----
        ...{your private key here}...
        -----END PRIVATE KEY-----\"\"\",
                    "cert": \"\"\"-----BEGIN CERTIFICATE-----
        ...{your public key cert here}...
        -----END CERTIFICATE-----\"\"\",
                },
                "idp_initiated": {
                    "client_id": "client_id",
                    "client_protocol": "samlp",
                    "client_authorize_query": "type=code&timeout=30",
                },
            })
        ```

        ### WindowsLive Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of a WindowsLive connection.
        windowslive = auth0.Connection("windowslive",
            name="Windowslive-Connection",
            strategy="windowslive",
            options={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "strategy_version": 2,
                "scopes": [
                    "signin",
                    "graph_user",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
            })
        ```

        ### OIDC Connection

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an OIDC connection.
        oidc = auth0.Connection("oidc",
            name="oidc-connection",
            display_name="OIDC Connection",
            strategy="oidc",
            show_as_button=False,
            options={
                "client_id": "1234567",
                "client_secret": "1234567",
                "domain_aliases": ["example.com"],
                "tenant_domain": "",
                "icon_url": "https://example.com/assets/logo.png",
                "type": "back_channel",
                "issuer": "https://www.paypalobjects.com",
                "jwks_uri": "https://api.paypal.com/v1/oauth2/certs",
                "discovery_url": "https://www.paypalobjects.com/.well-known/openid-configuration",
                "token_endpoint": "https://api.paypal.com/v1/oauth2/token",
                "userinfo_endpoint": "https://api.paypal.com/v1/oauth2/token/userinfo",
                "authorization_endpoint": "https://www.paypal.com/signin/authorize",
                "scopes": [
                    "openid",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "connection_settings": {
                    "pkce": "auto",
                },
                "attribute_map": {
                    "mapping_mode": "use_map",
                    "userinfo_scope": "openid email profile groups",
                    "attributes": json.dumps({
                        "name": "${context.tokenset.name}",
                        "email": "${context.tokenset.email}",
                        "email_verified": "${context.tokenset.email_verified}",
                        "nickname": "${context.tokenset.nickname}",
                        "picture": "${context.tokenset.picture}",
                        "given_name": "${context.tokenset.given_name}",
                        "family_name": "${context.tokenset.family_name}",
                    }),
                },
            })
        ```

        ### Okta Connection

        !> When configuring an Okta Workforce connection, the `scopes` attribute must be explicitly set. If omitted, the connection may not function correctly.
        To ensure proper behavior, always specify:  `scopes = ["openid", "profile", "email"]`

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # This is an example of an Okta Workforce connection.
        okta = auth0.Connection("okta",
            name="okta-connection",
            display_name="Okta Workforce Connection",
            strategy="okta",
            show_as_button=False,
            options={
                "client_id": "1234567",
                "client_secret": "1234567",
                "domain": "example.okta.com",
                "domain_aliases": ["example.com"],
                "issuer": "https://example.okta.com",
                "jwks_uri": "https://example.okta.com/oauth2/v1/keys",
                "token_endpoint": "https://example.okta.com/oauth2/v1/token",
                "userinfo_endpoint": "https://example.okta.com/oauth2/v1/userinfo",
                "authorization_endpoint": "https://example.okta.com/oauth2/v1/authorize",
                "scopes": [
                    "openid",
                    "profile",
                    "email",
                ],
                "set_user_root_attributes": "on_first_login",
                "non_persistent_attrs": [
                    "ethnicity",
                    "gender",
                ],
                "upstream_params": json.dumps({
                    "screen_name": {
                        "alias": "login_hint",
                    },
                }),
                "connection_settings": {
                    "pkce": "auto",
                },
                "attribute_map": {
                    "mapping_mode": "basic_profile",
                    "userinfo_scope": "openid email profile groups",
                    "attributes": json.dumps({
                        "name": "${context.tokenset.name}",
                        "email": "${context.tokenset.email}",
                        "email_verified": "${context.tokenset.email_verified}",
                        "nickname": "${context.tokenset.nickname}",
                        "picture": "${context.tokenset.picture}",
                        "given_name": "${context.tokenset.given_name}",
                        "family_name": "${context.tokenset.family_name}",
                    }),
                },
            })
        ```

        ## Import

        This resource can be imported by specifying the connection ID.

        Example:

        ```sh
        $ pulumi import auth0:index/connection:Connection google "con_a17f21fdb24d48a0"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_domain_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['ConnectionOptionsArgs', 'ConnectionOptionsArgsDict']]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_as_button: Optional[pulumi.Input[_builtins.bool]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_domain_connection"] = is_domain_connection
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["realms"] = realms
            __props__.__dict__["show_as_button"] = show_as_button
            if strategy is None and not opts.urn:
                raise TypeError("Missing required property 'strategy'")
            __props__.__dict__["strategy"] = strategy
        super(Connection, __self__).__init__(
            'auth0:index/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_domain_connection: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Union['ConnectionOptionsArgs', 'ConnectionOptionsArgsDict']]] = None,
            realms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            show_as_button: Optional[pulumi.Input[_builtins.bool]] = None,
            strategy: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Name used in login screen.
        :param pulumi.Input[_builtins.bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        :param pulumi.Input[_builtins.str] name: Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        :param pulumi.Input[Union['ConnectionOptionsArgs', 'ConnectionOptionsArgsDict']] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[_builtins.bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[_builtins.str] strategy: Type of the connection, which indicates the identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["is_domain_connection"] = is_domain_connection
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["realms"] = realms
        __props__.__dict__["show_as_button"] = show_as_button
        __props__.__dict__["strategy"] = strategy
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars).
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the connection. This value is immutable and changing it requires the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.ConnectionOptions']:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def realms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @_builtins.property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

