# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogStreamArgs', 'LogStream']

@pulumi.input_type
class LogStreamArgs:
    def __init__(__self__, *,
                 sink: pulumi.Input['LogStreamSinkArgs'],
                 type: pulumi.Input[_builtins.str],
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 is_priority: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pii_config: Optional[pulumi.Input['LogStreamPiiConfigArgs']] = None,
                 start_from: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogStream resource.
        :param pulumi.Input['LogStreamSinkArgs'] sink: The sink configuration for the log stream.
        :param pulumi.Input[_builtins.str] type: Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] filters: Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        :param pulumi.Input[_builtins.bool] is_priority: Set True for priority log streams, False for non-priority
        :param pulumi.Input[_builtins.str] name: Name of the log stream.
        :param pulumi.Input['LogStreamPiiConfigArgs'] pii_config: Configuration for PII (Personally Identifiable Information) handling.
        :param pulumi.Input[_builtins.str] start_from: The optional datetime (ISO 8601) to start streaming logs from.
        :param pulumi.Input[_builtins.str] status: The current status of the log stream. Options are "active", "paused", "suspended".
        """
        pulumi.set(__self__, "sink", sink)
        pulumi.set(__self__, "type", type)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if is_priority is not None:
            pulumi.set(__self__, "is_priority", is_priority)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pii_config is not None:
            pulumi.set(__self__, "pii_config", pii_config)
        if start_from is not None:
            pulumi.set(__self__, "start_from", start_from)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def sink(self) -> pulumi.Input['LogStreamSinkArgs']:
        """
        The sink configuration for the log stream.
        """
        return pulumi.get(self, "sink")

    @sink.setter
    def sink(self, value: pulumi.Input['LogStreamSinkArgs']):
        pulumi.set(self, "sink", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="isPriority")
    def is_priority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set True for priority log streams, False for non-priority
        """
        return pulumi.get(self, "is_priority")

    @is_priority.setter
    def is_priority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_priority", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the log stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="piiConfig")
    def pii_config(self) -> Optional[pulumi.Input['LogStreamPiiConfigArgs']]:
        """
        Configuration for PII (Personally Identifiable Information) handling.
        """
        return pulumi.get(self, "pii_config")

    @pii_config.setter
    def pii_config(self, value: Optional[pulumi.Input['LogStreamPiiConfigArgs']]):
        pulumi.set(self, "pii_config", value)

    @_builtins.property
    @pulumi.getter(name="startFrom")
    def start_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The optional datetime (ISO 8601) to start streaming logs from.
        """
        return pulumi.get(self, "start_from")

    @start_from.setter
    def start_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_from", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the log stream. Options are "active", "paused", "suspended".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _LogStreamState:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 is_priority: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pii_config: Optional[pulumi.Input['LogStreamPiiConfigArgs']] = None,
                 sink: Optional[pulumi.Input['LogStreamSinkArgs']] = None,
                 start_from: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogStream resources.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] filters: Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        :param pulumi.Input[_builtins.bool] is_priority: Set True for priority log streams, False for non-priority
        :param pulumi.Input[_builtins.str] name: Name of the log stream.
        :param pulumi.Input['LogStreamPiiConfigArgs'] pii_config: Configuration for PII (Personally Identifiable Information) handling.
        :param pulumi.Input['LogStreamSinkArgs'] sink: The sink configuration for the log stream.
        :param pulumi.Input[_builtins.str] start_from: The optional datetime (ISO 8601) to start streaming logs from.
        :param pulumi.Input[_builtins.str] status: The current status of the log stream. Options are "active", "paused", "suspended".
        :param pulumi.Input[_builtins.str] type: Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if is_priority is not None:
            pulumi.set(__self__, "is_priority", is_priority)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pii_config is not None:
            pulumi.set(__self__, "pii_config", pii_config)
        if sink is not None:
            pulumi.set(__self__, "sink", sink)
        if start_from is not None:
            pulumi.set(__self__, "start_from", start_from)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="isPriority")
    def is_priority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set True for priority log streams, False for non-priority
        """
        return pulumi.get(self, "is_priority")

    @is_priority.setter
    def is_priority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_priority", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the log stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="piiConfig")
    def pii_config(self) -> Optional[pulumi.Input['LogStreamPiiConfigArgs']]:
        """
        Configuration for PII (Personally Identifiable Information) handling.
        """
        return pulumi.get(self, "pii_config")

    @pii_config.setter
    def pii_config(self, value: Optional[pulumi.Input['LogStreamPiiConfigArgs']]):
        pulumi.set(self, "pii_config", value)

    @_builtins.property
    @pulumi.getter
    def sink(self) -> Optional[pulumi.Input['LogStreamSinkArgs']]:
        """
        The sink configuration for the log stream.
        """
        return pulumi.get(self, "sink")

    @sink.setter
    def sink(self, value: Optional[pulumi.Input['LogStreamSinkArgs']]):
        pulumi.set(self, "sink", value)

    @_builtins.property
    @pulumi.getter(name="startFrom")
    def start_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The optional datetime (ISO 8601) to start streaming logs from.
        """
        return pulumi.get(self, "start_from")

    @start_from.setter
    def start_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_from", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the log stream. Options are "active", "paused", "suspended".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("auth0:index/logStream:LogStream")
class LogStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 is_priority: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pii_config: Optional[pulumi.Input[Union['LogStreamPiiConfigArgs', 'LogStreamPiiConfigArgsDict']]] = None,
                 sink: Optional[pulumi.Input[Union['LogStreamSinkArgs', 'LogStreamSinkArgsDict']]] = None,
                 start_from: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can manage your Auth0 log streams.

        !> isPriority is a field that can be set while the resource is being created.
        This cannot be updated once set. Updating the value might result in a noisy plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an http log stream.
        my_webhook = auth0.LogStream("my_webhook",
            name="HTTP log stream",
            type="http",
            filters=[
                {
                    "type": "category",
                    "name": "auth.login.fail",
                },
                {
                    "type": "category",
                    "name": "auth.signup.fail",
                },
            ],
            sink={
                "http_endpoint": "https://example.com/logs",
                "http_content_type": "application/json",
                "http_content_format": "JSONOBJECT",
                "http_authorization": "AKIAXXXXXXXXXXXXXXXX",
                "http_custom_headers": [{
                    "header": "foo",
                    "value": "bar",
                }],
            })
        # This is an example of an Amazon EventBridge log stream.
        example_aws = auth0.LogStream("example_aws",
            name="AWS Eventbridge",
            type="eventbridge",
            status="active",
            sink={
                "aws_account_id": "my_account_id",
                "aws_region": "us-east-2",
            })
        ```

        ## Import

        This resource can be imported by specifying the log stream ID.

        Example:

        ```sh
        $ pulumi import auth0:index/logStream:LogStream example "lst_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] filters: Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        :param pulumi.Input[_builtins.bool] is_priority: Set True for priority log streams, False for non-priority
        :param pulumi.Input[_builtins.str] name: Name of the log stream.
        :param pulumi.Input[Union['LogStreamPiiConfigArgs', 'LogStreamPiiConfigArgsDict']] pii_config: Configuration for PII (Personally Identifiable Information) handling.
        :param pulumi.Input[Union['LogStreamSinkArgs', 'LogStreamSinkArgsDict']] sink: The sink configuration for the log stream.
        :param pulumi.Input[_builtins.str] start_from: The optional datetime (ISO 8601) to start streaming logs from.
        :param pulumi.Input[_builtins.str] status: The current status of the log stream. Options are "active", "paused", "suspended".
        :param pulumi.Input[_builtins.str] type: Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage your Auth0 log streams.

        !> isPriority is a field that can be set while the resource is being created.
        This cannot be updated once set. Updating the value might result in a noisy plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example of an http log stream.
        my_webhook = auth0.LogStream("my_webhook",
            name="HTTP log stream",
            type="http",
            filters=[
                {
                    "type": "category",
                    "name": "auth.login.fail",
                },
                {
                    "type": "category",
                    "name": "auth.signup.fail",
                },
            ],
            sink={
                "http_endpoint": "https://example.com/logs",
                "http_content_type": "application/json",
                "http_content_format": "JSONOBJECT",
                "http_authorization": "AKIAXXXXXXXXXXXXXXXX",
                "http_custom_headers": [{
                    "header": "foo",
                    "value": "bar",
                }],
            })
        # This is an example of an Amazon EventBridge log stream.
        example_aws = auth0.LogStream("example_aws",
            name="AWS Eventbridge",
            type="eventbridge",
            status="active",
            sink={
                "aws_account_id": "my_account_id",
                "aws_region": "us-east-2",
            })
        ```

        ## Import

        This resource can be imported by specifying the log stream ID.

        Example:

        ```sh
        $ pulumi import auth0:index/logStream:LogStream example "lst_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param LogStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 is_priority: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pii_config: Optional[pulumi.Input[Union['LogStreamPiiConfigArgs', 'LogStreamPiiConfigArgsDict']]] = None,
                 sink: Optional[pulumi.Input[Union['LogStreamSinkArgs', 'LogStreamSinkArgsDict']]] = None,
                 start_from: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogStreamArgs.__new__(LogStreamArgs)

            __props__.__dict__["filters"] = filters
            __props__.__dict__["is_priority"] = is_priority
            __props__.__dict__["name"] = name
            __props__.__dict__["pii_config"] = pii_config
            if sink is None and not opts.urn:
                raise TypeError("Missing required property 'sink'")
            __props__.__dict__["sink"] = sink
            __props__.__dict__["start_from"] = start_from
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(LogStream, __self__).__init__(
            'auth0:index/logStream:LogStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            is_priority: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pii_config: Optional[pulumi.Input[Union['LogStreamPiiConfigArgs', 'LogStreamPiiConfigArgsDict']]] = None,
            sink: Optional[pulumi.Input[Union['LogStreamSinkArgs', 'LogStreamSinkArgsDict']]] = None,
            start_from: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogStream':
        """
        Get an existing LogStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] filters: Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        :param pulumi.Input[_builtins.bool] is_priority: Set True for priority log streams, False for non-priority
        :param pulumi.Input[_builtins.str] name: Name of the log stream.
        :param pulumi.Input[Union['LogStreamPiiConfigArgs', 'LogStreamPiiConfigArgsDict']] pii_config: Configuration for PII (Personally Identifiable Information) handling.
        :param pulumi.Input[Union['LogStreamSinkArgs', 'LogStreamSinkArgsDict']] sink: The sink configuration for the log stream.
        :param pulumi.Input[_builtins.str] start_from: The optional datetime (ISO 8601) to start streaming logs from.
        :param pulumi.Input[_builtins.str] status: The current status of the log stream. Options are "active", "paused", "suspended".
        :param pulumi.Input[_builtins.str] type: Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogStreamState.__new__(_LogStreamState)

        __props__.__dict__["filters"] = filters
        __props__.__dict__["is_priority"] = is_priority
        __props__.__dict__["name"] = name
        __props__.__dict__["pii_config"] = pii_config
        __props__.__dict__["sink"] = sink
        __props__.__dict__["start_from"] = start_from
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return LogStream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Sequence[Mapping[str, _builtins.str]]]:
        """
        Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered. Filters available: `auth.ancillary.fail`, `auth.ancillary.success`, `auth.login.fail`, `auth.login.notification`, `auth.login.success`, `auth.logout.fail`, `auth.logout.success`, `auth.signup.fail`, `auth.signup.success`, `auth.silent_auth.fail`, `auth.silent_auth.success`, `auth.token_exchange.fail`, `auth.token_exchange.success`, `management.fail`, `management.success`, `system.notification`, `user.fail`, `user.notification`, `user.success`, `other`.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="isPriority")
    def is_priority(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set True for priority log streams, False for non-priority
        """
        return pulumi.get(self, "is_priority")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the log stream.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="piiConfig")
    def pii_config(self) -> pulumi.Output[Optional['outputs.LogStreamPiiConfig']]:
        """
        Configuration for PII (Personally Identifiable Information) handling.
        """
        return pulumi.get(self, "pii_config")

    @_builtins.property
    @pulumi.getter
    def sink(self) -> pulumi.Output['outputs.LogStreamSink']:
        """
        The sink configuration for the log stream.
        """
        return pulumi.get(self, "sink")

    @_builtins.property
    @pulumi.getter(name="startFrom")
    def start_from(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The optional datetime (ISO 8601) to start streaming logs from.
        """
        return pulumi.get(self, "start_from")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the log stream. Options are "active", "paused", "suspended".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the log stream, which indicates the sink provider. Options include: `eventbridge`, `eventgrid`, `http`, `datadog`, `splunk`, `sumo`, `mixpanel`, `segment`.
        """
        return pulumi.get(self, "type")

