import sys
import typing
import mathutils
import bpy
import bl_operators.anim
import bl_operators.view3d
import bl_ui.properties_data_mesh
import bl_ui.space_toolsystem_common
import bl_ui.properties_output
import bl_ui.properties_collection
import bl_operators.file
import bl_ui.properties_physics_softbody
import bl_ui.properties_data_speaker
import bl_ui.properties_texture
import bl_ui.properties_physics_rigidbody
import bl_ui.properties_physics_fluid
import bl_ui.properties_data_lattice
import bl_operators.constraint
import bl_ui.space_dopesheet
import bl_ui.properties_grease_pencil_common
import bl_ui.properties_workspace
import bl_operators.freestyle
import bl_ui.properties_object
import bl_operators.object
import bl_ui.space_time
import bl_ui.properties_world
import bl_ui.properties_freestyle
import bl_operators.userpref
import bl_ui.space_view3d_toolbar
import bl_ui.properties_physics_common
import bl_ui.asset_shelf
import bl_ui.space_text
import bl_ui.properties_physics_cloth
import bl_ui.properties_data_curves
import bl_operators.presets
import bl_operators.clip
import bl_ui.properties_physics_rigidbody_constraint
import bl_ui.properties_render
import bl_ui.properties_data_light
import bl_ui.node_add_menu
import bl_ui.space_spreadsheet
import bl_ui.properties_data_volume
import bl_operators.assets
import bl_ui
import bl_ui.properties_data_curve
import bl_ui.properties_constraint
import bl_ui.properties_material_gpencil
import bl_operators.spreadsheet
import bl_ui.properties_data_shaderfx
import bl_ui.properties_material
import bl_ui.space_info
import bl_operators.wm
import bl_ui.properties_physics_dynamicpaint
import bl_ui.properties_data_metaball
import bl_ui.node_add_menu_shader
import bl_ui.node_add_menu_texture
import bl_ui.properties_view_layer
import bl_ui.properties_physics_field
import bl_ui.properties_scene
import bl_ui.space_userpref
import bl_ui.properties_data_gpencil
import bl_ui.properties_data_armature
import bl_ui.space_view3d
import bl_ui.properties_data_bone
import bl_ui.properties_data_grease_pencil
import bl_ui.properties_data_modifier
import bl_ui.space_statusbar
import bl_ui.space_console
import bl_ui.properties_physics_geometry_nodes
import bl_ui.node_add_menu_compositor
import bl_ui.space_clip
import bl_ui.properties_data_lightprobe
import bl_ui.space_sequencer
import bl_ui.properties_data_pointcloud
import bl_ui.properties_mask_common
import bl_ui.space_filebrowser
import bl_ui.space_toolsystem_toolbar
import bl_ui.space_node
import bl_ui.properties_data_camera
import bl_ui.generic_ui_list
import bl_ui.space_outliner
import bl_ui.space_image
import bl_ui.space_graph
import bl_ui.properties_data_empty
import bl_ui.properties_particle
import bl_ui.properties_paint_common
import bl_ui.space_properties
import bl_ui.space_nla
import bl_ui.space_topbar
import bl_ui.node_add_menu_geometry
import bl_operators.node

GenericType = typing.TypeVar("GenericType")


class bpy_prop_collection(typing.Generic[GenericType]):
    ''' built-in class used for all collections.
    '''

    def find(self, key: typing.Optional[str]) -> int:
        ''' Returns the index of a key in a collection or -1 when not found (matches Python's string find function of the same name).

        :param key: The identifier for the collection member.
        :type key: typing.Optional[str]
        :rtype: int
        :return: index of the key.
        '''
        pass

    def foreach_get(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! Multi-dimensional arrays (like array of vectors) will be flattened into seq.

        '''
        pass

    def foreach_set(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

        '''
        pass

    def get(self,
            key: typing.Optional[str],
            default: typing.Optional[typing.Any] = None):
        ''' Returns the value of the item assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The identifier for the collection member.
        :type key: typing.Optional[str]
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: typing.Optional[typing.Any]
        '''
        pass

    def items(self) -> typing.List:
        ''' Return the identifiers of collection members (matching Python's dict.items() functionality).

        :rtype: typing.List
        :return: (key, value) pairs for each member of this collection.
        '''
        pass

    def keys(self) -> typing.List[str]:
        ''' Return the identifiers of collection members (matching Python's dict.keys() functionality).

        :rtype: typing.List[str]
        :return: the identifiers for each member of this collection.
        '''
        pass

    def values(self) -> typing.List:
        ''' Return the values of collection (matching Python's dict.values() functionality).

        :rtype: typing.List
        :return: the members of this collection.
        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'GenericType'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'GenericType'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __iter__(self) -> typing.Iterator['GenericType']:
        ''' 

        :rtype: typing.Iterator['GenericType']
        '''
        pass

    def __next__(self) -> 'GenericType':
        ''' 

        :rtype: 'GenericType'
        '''
        pass

    def __len__(self) -> int:
        ''' 

        :rtype: int
        '''
        pass


class bpy_struct:
    ''' built-in base class for all classes in bpy.types.
    '''

    id_data = None
    ''' The `bpy.types.ID` object this datablock is from or None, (not available for all data types)'''

    def as_pointer(self) -> int:
        ''' Returns the memory address which holds a pointer to Blender's internal data

        :rtype: int
        :return: int (memory address).
        '''
        pass

    def driver_add(self,
                   path: typing.Optional[str],
                   index: typing.Optional[int] = -1) -> 'FCurve':
        ''' Adds driver(s) to the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: 'FCurve'
        :return: The driver(s) added.
        '''
        pass

    def driver_remove(self,
                      path: typing.Optional[str],
                      index: typing.Optional[int] = -1) -> bool:
        ''' Remove driver(s) from the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: bool
        :return: Success of driver removal.
        '''
        pass

    def get(self,
            key: typing.Optional[str],
            default: typing.Optional[typing.Any] = None):
        ''' Returns the value of the custom property assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The key associated with the custom property.
        :type key: typing.Optional[str]
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: typing.Optional[typing.Any]
        '''
        pass

    def id_properties_clear(self):
        ''' 

        '''
        pass

    def id_properties_ensure(self) -> typing.Any:
        ''' 

        :rtype: typing.Any
        :return: the parent group for an RNA struct's custom IDProperties.
        '''
        pass

    def id_properties_ui(self, key: typing.Optional[typing.Any]) -> typing.Any:
        ''' 

        :param key:  String name of the property.
        :type key: typing.Optional[typing.Any]
        :rtype: typing.Any
        :return: Return an object used to manage an IDProperty's UI data.
        '''
        pass

    def is_property_hidden(self, property) -> bool:
        ''' Check if a property is hidden.

        :rtype: bool
        :return: True when the property is hidden.
        '''
        pass

    def is_property_overridable_library(self, property) -> bool:
        ''' Check if a property is overridable.

        :rtype: bool
        :return: True when the property is overridable.
        '''
        pass

    def is_property_readonly(self, property) -> bool:
        ''' Check if a property is readonly.

        :rtype: bool
        :return: True when the property is readonly (not writable).
        '''
        pass

    def is_property_set(self, property,
                        ghost: typing.Optional[bool] = True) -> bool:
        ''' Check if a property is set, use for testing operator properties.

        :param ghost: Used for operators that re-run with previous settings. In this case the property is not marked as set, yet the value from the previous execution is used. In rare cases you may want to set this option to false.
        :type ghost: typing.Optional[bool]
        :rtype: bool
        :return: True when the property has been set.
        '''
        pass

    def items(self) -> typing.Any:
        ''' Returns the items of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: typing.Any
        :return: custom property key, value pairs.
        '''
        pass

    def keyframe_delete(
            self,
            data_path: typing.Optional[str],
            index: typing.Optional[int] = -1,
            frame: typing.Optional[float] = 'bpy.context.scene.frame_current',
            group: typing.Optional[str] = "") -> bool:
        ''' Remove a keyframe from this properties fcurve.

        :param data_path: path to the property to remove a key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :rtype: bool
        :return: Success of keyframe deletion.
        '''
        pass

    def keyframe_insert(
            self,
            data_path: typing.Optional[str],
            index: typing.Optional[int] = -1,
            frame: typing.Optional[float] = 'bpy.context.scene.frame_current',
            group: typing.Optional[str] = "",
            options: typing.Optional[typing.Any] = 'set()') -> bool:
        ''' Insert a keyframe on the property given, adding fcurves and animation data when necessary. This is the most simple example of inserting a keyframe from python. Note that when keying data paths which contain nested properties this must be done from the `ID` subclass, in this case the `Armature` rather than the bone.

        :param data_path: path to the property to key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to key. Defaults to -1 which will key all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is inserted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :param flag: 
        :type flag: typing.Optional[typing.Set]
        :param options:  - ``INSERTKEY_NEEDED`` Only insert keyframes where they're needed in the relevant F-Curves. - ``INSERTKEY_VISUAL`` Insert keyframes based on 'visual transforms'. - ``INSERTKEY_XYZ_TO_RGB`` Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis. - ``INSERTKEY_REPLACE`` Only replace already existing keyframes. - ``INSERTKEY_AVAILABLE`` Only insert into already existing F-Curves. - ``INSERTKEY_CYCLE_AWARE`` Take cyclic extrapolation into account (Cycle-Aware Keying option).
        :type options: typing.Optional[typing.Any]
        :rtype: bool
        :return: Success of keyframe insertion.
        '''
        pass

    def keys(self) -> typing.Any:
        ''' Returns the keys of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: typing.Any
        :return: custom property keys.
        '''
        pass

    def path_from_id(self, property: typing.Optional[str] = "") -> str:
        ''' Returns the data path from the ID to this object (string).

        :param property: Optional property name which can be used if the path is to a property of this object.
        :type property: typing.Optional[str]
        :rtype: str
        :return: `bpy.types.bpy_struct.id_data` to this struct and property (when given).
        '''
        pass

    def path_resolve(self,
                     path: typing.Optional[str],
                     coerce: typing.Optional[bool] = True):
        ''' Returns the property from the path, raise an exception when not found.

        :param path: path which this property resolves.
        :type path: typing.Optional[str]
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: typing.Optional[bool]
        '''
        pass

    def pop(self,
            key: typing.Optional[str],
            default: typing.Optional[typing.Any] = None):
        ''' Remove and return the value of the custom property assigned to key or default when not found (matches Python's dictionary function of the same name).

        :param key: The key associated with the custom property.
        :type key: typing.Optional[str]
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: typing.Optional[typing.Any]
        '''
        pass

    def property_overridable_library_set(self, property, overridable) -> bool:
        ''' Define a property as overridable or not (only for custom properties!).

        :rtype: bool
        :return: True when the overridable status of the property was successfully set.
        '''
        pass

    def property_unset(self, property):
        ''' Unset a property, will use default value afterward.

        '''
        pass

    def type_recast(self) -> 'bpy_struct':
        ''' Return a new instance, this is needed because types such as textures can be changed at runtime.

        :rtype: 'bpy_struct'
        :return: a new instance of this object with the type initialized again.
        '''
        pass

    def values(self) -> typing.Any:
        ''' Returns the values of this objects custom properties (matches Python's dictionary function of the same name).

        :rtype: typing.Any
        :return: custom property values.
        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'typing.Any':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'typing.Any'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'typing.Any'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'typing.Any':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        '''
        pass


class bpy_prop_array(typing.Generic[GenericType]):
    def foreach_get(self, attr, seq):
        ''' 

        '''
        pass

    def foreach_set(self, attr, seq):
        ''' 

        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'GenericType'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'GenericType'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __iter__(self) -> typing.Iterator['GenericType']:
        ''' 

        :rtype: typing.Iterator['GenericType']
        '''
        pass

    def __next__(self) -> 'GenericType':
        ''' 

        :rtype: 'GenericType'
        '''
        pass

    def __len__(self) -> int:
        ''' 

        :rtype: int
        '''
        pass


class AOV(bpy_struct):
    is_valid: bool = None
    ''' Is the name of the AOV conflicting

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the AOV

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the AOV

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ActionGroup(bpy_struct):
    ''' Groups of F-Curves
    '''

    channels: bpy_prop_collection['FCurve'] = None
    ''' F-Curves in this group

    :type: bpy_prop_collection['FCurve']
    '''

    color_set: typing.Union[str, int] = None
    ''' Custom color set to use

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    ''' Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: typing.Union[bool, typing.Any] = None
    ''' Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    '''

    lock: bool = None
    ''' Action group is locked

    :type: bool
    '''

    mute: bool = None
    ''' Action group is muted

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Action group is selected

    :type: bool
    '''

    show_expanded: bool = None
    ''' Action group is expanded except in graph editor

    :type: bool
    '''

    show_expanded_graph: bool = None
    ''' Action group is expanded in graph editor

    :type: bool
    '''

    use_pin: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Addon(bpy_struct):
    ''' Python add-ons to be loaded automatically
    '''

    module: typing.Union[str, typing.Any] = None
    ''' Module name

    :type: typing.Union[str, typing.Any]
    '''

    preferences: 'AddonPreferences' = None
    ''' 

    :type: 'AddonPreferences'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AddonPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AnimData(bpy_struct):
    ''' Animation data for data-block
    '''

    action: 'Action' = None
    ''' Active Action for this data-block

    :type: 'Action'
    '''

    action_blend_type: typing.Union[str, int] = None
    ''' Method used for combining Active Action's result with result of NLA stack * ``REPLACE`` Replace -- The strip values replace the accumulated results by amount specified by influence. * ``COMBINE`` Combine -- The strip values are combined with accumulated results by appropriately using addition, multiplication, or quaternion math, based on channel type. * ``ADD`` Add -- Weighted result of strip is added to the accumulated results. * ``SUBTRACT`` Subtract -- Weighted result of strip is removed from the accumulated results. * ``MULTIPLY`` Multiply -- Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    action_extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the Active Action's range (when evaluating with NLA) * ``NOTHING`` Nothing -- Strip has no influence past its extents. * ``HOLD`` Hold -- Hold the first frame if no previous strips in track, and always hold last frame. * ``HOLD_FORWARD`` Hold Forward -- Only hold last frame.

    :type: typing.Union[str, int]
    '''

    action_influence: float = None
    ''' Amount the Active Action contributes to the result of the NLA stack

    :type: float
    '''

    action_tweak_storage: 'Action' = None
    ''' Slot to temporarily hold the main action while in tweak mode

    :type: 'Action'
    '''

    drivers: 'AnimDataDrivers' = None
    ''' The Drivers/Expressions for this data-block

    :type: 'AnimDataDrivers'
    '''

    nla_tracks: 'NlaTracks' = None
    ''' NLA Tracks (i.e. Animation Layers)

    :type: 'NlaTracks'
    '''

    use_nla: bool = None
    ''' NLA stack is evaluated when evaluating this block

    :type: bool
    '''

    use_pin: bool = None
    ''' 

    :type: bool
    '''

    use_tweak_mode: bool = None
    ''' Whether to enable or disable tweak mode in NLA

    :type: bool
    '''

    def nla_tweak_strip_time_to_scene(
            self,
            frame: typing.Optional[float],
            invert: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> float:
        ''' Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking.

        :param frame: Input time
        :type frame: typing.Optional[float]
        :param invert: Invert, Convert scene time to action time
        :type invert: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Converted time
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AnimViz(bpy_struct):
    ''' Settings for the visualization of motion
    '''

    motion_path: 'AnimVizMotionPaths' = None
    ''' Motion Path settings for visualization

    :type: 'AnimVizMotionPaths'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AnimVizMotionPaths(bpy_struct):
    ''' Motion Path settings for animation visualization
    '''

    bake_location: typing.Union[str, int] = None
    ''' When calculating Bone Paths, use Head or Tips

    :type: typing.Union[str, int]
    '''

    frame_after: int = None
    ''' Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_before: int = None
    ''' Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_end: int = None
    ''' End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    '''

    has_motion_paths: typing.Union[bool, typing.Any] = None
    ''' Are there any bone paths that will need updating (read-only)

    :type: typing.Union[bool, typing.Any]
    '''

    range: typing.Union[str, int] = None
    ''' Type of range to calculate for Motion Paths

    :type: typing.Union[str, int]
    '''

    show_frame_numbers: bool = None
    ''' Show frame numbers on Motion Paths

    :type: bool
    '''

    show_keyframe_action_all: bool = None
    ''' For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    '''

    show_keyframe_highlight: bool = None
    ''' Emphasize position of keyframes on Motion Paths

    :type: bool
    '''

    show_keyframe_numbers: bool = None
    ''' Show frame numbers of Keyframes on Motion Paths

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of range to show for Motion Paths

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AnyType(bpy_struct):
    ''' RNA type used for pointers to any possible data
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Area(bpy_struct):
    ''' Area in a subdivided screen, containing an editor
    '''

    height: int = None
    ''' Area height

    :type: int
    '''

    regions: bpy_prop_collection['Region'] = None
    ''' Regions this area is subdivided in

    :type: bpy_prop_collection['Region']
    '''

    show_menus: bool = None
    ''' Show menus in the header

    :type: bool
    '''

    spaces: 'AreaSpaces' = None
    ''' Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: 'AreaSpaces'
    '''

    type: typing.Union[str, int] = None
    ''' Current editor type for this area

    :type: typing.Union[str, int]
    '''

    ui_type: typing.Union[str, int] = None
    ''' Current editor type for this area

    :type: typing.Union[str, int]
    '''

    width: int = None
    ''' Area width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the area

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the area

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass

    def header_text_set(self, text: typing.Optional[str]):
        ''' Set the header status text

        :param text: Text, New string for the header, None clears the text
        :type text: typing.Optional[str]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetCatalogPath(bpy_struct):
    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetLibraryReference(bpy_struct):
    ''' Identifier to refer to the asset library
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetMetaData(bpy_struct):
    ''' Additional data stored for an asset data-block
    '''

    active_tag: int = None
    ''' Index of the tag set for editing

    :type: int
    '''

    author: typing.Union[str, typing.Any] = None
    ''' Name of the creator of the asset

    :type: typing.Union[str, typing.Any]
    '''

    catalog_id: typing.Union[str, typing.Any] = None
    ''' Identifier for the asset's catalog, used by Blender to look up the asset's catalog path. Must be a UUID according to RFC4122

    :type: typing.Union[str, typing.Any]
    '''

    catalog_simple_name: typing.Union[str, typing.Any] = None
    ''' Simple name of the asset's catalog, for debugging and data recovery purposes

    :type: typing.Union[str, typing.Any]
    '''

    copyright: typing.Union[str, typing.Any] = None
    ''' Copyright notice for this asset. An empty copyright notice does not necessarily indicate that this is copyright-free. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    '''

    description: typing.Union[str, typing.Any] = None
    ''' A description of the asset to be displayed for the user

    :type: typing.Union[str, typing.Any]
    '''

    license: typing.Union[str, typing.Any] = None
    ''' The type of license this asset is distributed under. An empty license name does not necessarily indicate that this is free of licensing terms. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    '''

    tags: 'AssetTags' = None
    ''' Custom tags (name tokens) for the asset, used for filtering and general asset management

    :type: 'AssetTags'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetRepresentation(bpy_struct):
    ''' Information about an entity that makes it possible for the asset system to deal with the entity as asset
    '''

    full_library_path: typing.Union[str, typing.Any] = None
    ''' Absolute path to the .blend file containing this asset

    :type: typing.Union[str, typing.Any]
    '''

    full_path: typing.Union[str, typing.Any] = None
    ''' Absolute path to the .blend file containing this asset extended with the path of the asset inside the file

    :type: typing.Union[str, typing.Any]
    '''

    id_type: typing.Union[str, int] = None
    ''' The type of the data-block, if the asset represents one ('NONE' otherwise)

    :type: typing.Union[str, int]
    '''

    local_id: 'ID' = None
    ''' The local data-block this asset represents; only valid if that is a data-block in this file

    :type: 'ID'
    '''

    metadata: 'AssetMetaData' = None
    ''' Additional information about the asset

    :type: 'AssetMetaData'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetShelf(bpy_struct):
    ''' Regions for quick access to assets
    '''

    asset_library_reference: typing.Union[str, int] = None
    ''' Choose the asset library to display assets from

    :type: typing.Union[str, int]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the asset gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_AST_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_AST_hello")

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this asset shelf type * ``NO_ASSET_DRAG`` No Asset Dragging -- Disable the default asset dragging on drag events. Useful for implementing custom dragging via custom key-map items.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the asset shelf is going to be used in

    :type: typing.Union[str, int]
    '''

    preview_size: int = None
    ''' Size of the asset preview thumbnails in pixels

    :type: int
    '''

    search_filter: typing.Union[str, typing.Any] = None
    ''' Filter assets by name

    :type: typing.Union[str, typing.Any]
    '''

    show_names: bool = None
    ''' Show the asset name together with the preview. Otherwise only the preview will be visible

    :type: bool
    '''

    @classmethod
    def poll(cls, context: typing.Optional['Context']) -> bool:
        ''' If this method returns a non-null output, the asset shelf will be visible

        :param context: 
        :type context: typing.Optional['Context']
        :rtype: bool
        '''
        pass

    @classmethod
    def asset_poll(cls, asset: typing.Optional['AssetRepresentation']) -> bool:
        ''' Determine if an asset should be visible in the asset shelf. If this method returns a non-null output, the asset will be visible

        :param asset: 
        :type asset: typing.Optional['AssetRepresentation']
        :rtype: bool
        '''
        pass

    @classmethod
    def draw_context_menu(cls, context: typing.Optional['Context'],
                          asset: typing.Optional['AssetRepresentation'],
                          layout: typing.Optional['UILayout']):
        ''' Draw UI elements into the context menu UI layout displayed on right click

        :param context: 
        :type context: typing.Optional['Context']
        :param asset: 
        :type asset: typing.Optional['AssetRepresentation']
        :param layout: 
        :type layout: typing.Optional['UILayout']
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class AssetTag(bpy_struct):
    ''' User defined tag (name token)
    '''

    name: typing.Union[str, typing.Any] = None
    ''' The identifier that makes up this tag

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Attribute(bpy_struct):
    ''' Geometry attribute
    '''

    data_type: typing.Union[str, int] = None
    ''' Type of data stored in attribute

    :type: typing.Union[str, int]
    '''

    domain: typing.Union[str, int] = None
    ''' Domain of the Attribute

    :type: typing.Union[str, int]
    '''

    is_internal: typing.Union[bool, typing.Any] = None
    ''' The attribute is meant for internal use by Blender

    :type: typing.Union[bool, typing.Any]
    '''

    is_required: typing.Union[bool, typing.Any] = None
    ''' Whether the attribute can be removed or renamed

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the Attribute

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BakeSettings(bpy_struct):
    ''' Bake data for a Scene data-block
    '''

    cage_extrusion: float = None
    ''' Inflate the active object by the specified distance for baking. This helps matching to points nearer to the outside of the selected object meshes

    :type: float
    '''

    cage_object: 'Object' = None
    ''' Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: 'Object'
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Image filepath to use when saving externally

    :type: typing.Union[str, typing.Any]
    '''

    height: int = None
    ''' Vertical dimension of the baking map

    :type: int
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    margin_type: typing.Union[str, int] = None
    ''' Algorithm to extend the baked result

    :type: typing.Union[str, int]
    '''

    max_ray_distance: float = None
    ''' The maximum ray distance for matching points between the active and selected objects. If zero, there is no limit

    :type: float
    '''

    normal_b: typing.Union[str, int] = None
    ''' Axis to bake in blue channel

    :type: typing.Union[str, int]
    '''

    normal_g: typing.Union[str, int] = None
    ''' Axis to bake in green channel

    :type: typing.Union[str, int]
    '''

    normal_r: typing.Union[str, int] = None
    ''' Axis to bake in red channel

    :type: typing.Union[str, int]
    '''

    normal_space: typing.Union[str, int] = None
    ''' Choose normal space for baking

    :type: typing.Union[str, int]
    '''

    pass_filter: typing.Any = None
    ''' Passes to include in the active baking pass

    :type: typing.Any
    '''

    save_mode: typing.Union[str, int] = None
    ''' Where to save baked image textures

    :type: typing.Union[str, int]
    '''

    target: typing.Union[str, int] = None
    ''' Where to output the baked map

    :type: typing.Union[str, int]
    '''

    use_automatic_name: bool = None
    ''' Automatically name the output file with the pass type (external only)

    :type: bool
    '''

    use_cage: bool = None
    ''' Cast rays to active object from a cage

    :type: bool
    '''

    use_clear: bool = None
    ''' Clear Images before baking (internal only)

    :type: bool
    '''

    use_pass_color: bool = None
    ''' Color the pass

    :type: bool
    '''

    use_pass_diffuse: bool = None
    ''' Add diffuse contribution

    :type: bool
    '''

    use_pass_direct: bool = None
    ''' Add direct lighting contribution

    :type: bool
    '''

    use_pass_emit: bool = None
    ''' Add emission contribution

    :type: bool
    '''

    use_pass_glossy: bool = None
    ''' Add glossy contribution

    :type: bool
    '''

    use_pass_indirect: bool = None
    ''' Add indirect lighting contribution

    :type: bool
    '''

    use_pass_transmission: bool = None
    ''' Add transmission contribution

    :type: bool
    '''

    use_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_split_materials: bool = None
    ''' Split external images per material (external only)

    :type: bool
    '''

    view_from: typing.Union[str, int] = None
    ''' Source of reflection ray directions * ``ABOVE_SURFACE`` Above Surface -- Cast rays from above the surface. * ``ACTIVE_CAMERA`` Active Camera -- Use the active camera's position to cast rays.

    :type: typing.Union[str, int]
    '''

    width: int = None
    ''' Horizontal dimension of the baking map

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BezierSplinePoint(bpy_struct):
    ''' Bezier curve point with two handles
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_left: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' Coordinates of the first handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    handle_right: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Vector'] = None
    ''' Coordinates of the second handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Handle 1 selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Handle 2 selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BlendData(bpy_struct):
    ''' Main data structure representing a .blend file and all its data-blocks
    '''

    actions: 'BlendDataActions' = None
    ''' Action data-blocks

    :type: 'BlendDataActions'
    '''

    armatures: 'BlendDataArmatures' = None
    ''' Armature data-blocks

    :type: 'BlendDataArmatures'
    '''

    brushes: 'BlendDataBrushes' = None
    ''' Brush data-blocks

    :type: 'BlendDataBrushes'
    '''

    cache_files: 'BlendDataCacheFiles' = None
    ''' Cache Files data-blocks

    :type: 'BlendDataCacheFiles'
    '''

    cameras: 'BlendDataCameras' = None
    ''' Camera data-blocks

    :type: 'BlendDataCameras'
    '''

    collections: 'BlendDataCollections' = None
    ''' Collection data-blocks

    :type: 'BlendDataCollections'
    '''

    curves: 'BlendDataCurves' = None
    ''' Curve data-blocks

    :type: 'BlendDataCurves'
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to the .blend file

    :type: typing.Union[str, typing.Any]
    '''

    fonts: 'BlendDataFonts' = None
    ''' Vector font data-blocks

    :type: 'BlendDataFonts'
    '''

    grease_pencils: 'BlendDataGreasePencils' = None
    ''' Grease Pencil data-blocks

    :type: 'BlendDataGreasePencils'
    '''

    hair_curves: 'BlendDataHairCurves' = None
    ''' Hair curve data-blocks

    :type: 'BlendDataHairCurves'
    '''

    images: 'BlendDataImages' = None
    ''' Image data-blocks

    :type: 'BlendDataImages'
    '''

    is_dirty: typing.Union[bool, typing.Any] = None
    ''' Have recent edits been saved to disk

    :type: typing.Union[bool, typing.Any]
    '''

    is_saved: typing.Union[bool, typing.Any] = None
    ''' Has the current session been saved to disk as a .blend file

    :type: typing.Union[bool, typing.Any]
    '''

    lattices: 'BlendDataLattices' = None
    ''' Lattice data-blocks

    :type: 'BlendDataLattices'
    '''

    libraries: 'BlendDataLibraries' = None
    ''' Library data-blocks

    :type: 'BlendDataLibraries'
    '''

    lightprobes: 'BlendDataProbes' = None
    ''' Light Probe data-blocks

    :type: 'BlendDataProbes'
    '''

    lights: 'BlendDataLights' = None
    ''' Light data-blocks

    :type: 'BlendDataLights'
    '''

    linestyles: 'BlendDataLineStyles' = None
    ''' Line Style data-blocks

    :type: 'BlendDataLineStyles'
    '''

    masks: 'BlendDataMasks' = None
    ''' Masks data-blocks

    :type: 'BlendDataMasks'
    '''

    materials: 'BlendDataMaterials' = None
    ''' Material data-blocks

    :type: 'BlendDataMaterials'
    '''

    meshes: 'BlendDataMeshes' = None
    ''' Mesh data-blocks

    :type: 'BlendDataMeshes'
    '''

    metaballs: 'BlendDataMetaBalls' = None
    ''' Metaball data-blocks

    :type: 'BlendDataMetaBalls'
    '''

    movieclips: 'BlendDataMovieClips' = None
    ''' Movie Clip data-blocks

    :type: 'BlendDataMovieClips'
    '''

    node_groups: 'BlendDataNodeTrees' = None
    ''' Node group data-blocks

    :type: 'BlendDataNodeTrees'
    '''

    objects: 'BlendDataObjects' = None
    ''' Object data-blocks

    :type: 'BlendDataObjects'
    '''

    paint_curves: 'BlendDataPaintCurves' = None
    ''' Paint Curves data-blocks

    :type: 'BlendDataPaintCurves'
    '''

    palettes: 'BlendDataPalettes' = None
    ''' Palette data-blocks

    :type: 'BlendDataPalettes'
    '''

    particles: 'BlendDataParticles' = None
    ''' Particle data-blocks

    :type: 'BlendDataParticles'
    '''

    pointclouds: 'BlendDataPointClouds' = None
    ''' Point cloud data-blocks

    :type: 'BlendDataPointClouds'
    '''

    scenes: 'BlendDataScenes' = None
    ''' Scene data-blocks

    :type: 'BlendDataScenes'
    '''

    screens: 'BlendDataScreens' = None
    ''' Screen data-blocks

    :type: 'BlendDataScreens'
    '''

    shape_keys: bpy_prop_collection['Key'] = None
    ''' Shape Key data-blocks

    :type: bpy_prop_collection['Key']
    '''

    sounds: 'BlendDataSounds' = None
    ''' Sound data-blocks

    :type: 'BlendDataSounds'
    '''

    speakers: 'BlendDataSpeakers' = None
    ''' Speaker data-blocks

    :type: 'BlendDataSpeakers'
    '''

    texts: 'BlendDataTexts' = None
    ''' Text data-blocks

    :type: 'BlendDataTexts'
    '''

    textures: 'BlendDataTextures' = None
    ''' Texture data-blocks

    :type: 'BlendDataTextures'
    '''

    use_autopack: bool = None
    ''' Automatically pack all external data into .blend file

    :type: bool
    '''

    version: bpy_prop_array[int] = None
    ''' File format version the .blend file was saved with

    :type: bpy_prop_array[int]
    '''

    volumes: 'BlendDataVolumes' = None
    ''' Volume data-blocks

    :type: 'BlendDataVolumes'
    '''

    window_managers: 'BlendDataWindowManagers' = None
    ''' Window manager data-blocks

    :type: 'BlendDataWindowManagers'
    '''

    workspaces: 'BlendDataWorkSpaces' = None
    ''' Workspace data-blocks

    :type: 'BlendDataWorkSpaces'
    '''

    worlds: 'BlendDataWorlds' = None
    ''' World data-blocks

    :type: 'BlendDataWorlds'
    '''

    def batch_remove(self, ids: typing.Optional[typing.Any]):
        ''' Remove (delete) several IDs at once. WARNING: Considered experimental feature currently. Note that this function is quicker than individual calls to :func:`remove()` (from `bpy.types.BlendData` ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes...).

        :param subset: 
        :type subset: typing.Optional[typing.Sequence]
        :param ids:  Iterables of IDs (types can be mixed).
        :type ids: typing.Optional[typing.Any]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    def orphans_purge(self):
        ''' Remove (delete) all IDs with no user.

        :param do_local_ids: Include unused local IDs in the deletion, defaults to True
        :type do_local_ids: typing.Optional[bool]
        :param do_linked_ids: Include unused linked IDs in the deletion, defaults to True
        :type do_linked_ids: typing.Optional[bool]
        :param do_recursive: Recursively check for unused IDs, ensuring no orphaned one remain after a single run of that function, defaults to False
        :type do_recursive: typing.Optional[bool]
        '''
        pass

    def temp_data(self,
                  filepath: typing.Optional[typing.Union[str, bytes]] = None
                  ) -> 'BlendData':
        ''' A context manager that temporarily creates blender file data.

        :param filepath: The file path for the newly temporary data. When None, the path of the currently open file is used.
        :type filepath: typing.Optional[typing.Union[str, bytes]]
        :rtype: 'BlendData'
        :return: Blend file data which is freed once the context exists.
        '''
        pass

    def user_map(self, subset: typing.Optional[typing.Sequence],
                 key_types: typing.Optional[typing.Set[str]],
                 value_types: typing.Optional[typing.Set[str]]) -> typing.Dict:
        ''' Returns a mapping of all ID data-blocks in current ``bpy.data`` to a set of all datablocks using them. For list of valid set members for key_types & value_types, see: `bpy.types.KeyingSetPath.id_type`.

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: typing.Optional[typing.Sequence]
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: typing.Optional[typing.Set[str]]
        :param value_types: Filter the values in the set by ID types.
        :type value_types: typing.Optional[typing.Set[str]]
        :rtype: typing.Dict
        :return: `bpy.types.ID` instances, with sets of ID's as their values.
        '''
        pass


class BlenderRNA(bpy_struct):
    ''' Blender RNA structure definitions
    '''

    structs: bpy_prop_collection['Struct'] = None
    ''' 

    :type: bpy_prop_collection['Struct']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoidRule(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' Boid rule name

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_in_air: bool = None
    ''' Use rule when boid is flying

    :type: bool
    '''

    use_on_land: bool = None
    ''' Use rule when boid is on land

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoidSettings(bpy_struct):
    ''' Settings for boid physics
    '''

    accuracy: float = None
    ''' Accuracy of attack

    :type: float
    '''

    active_boid_state: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_state_index: int = None
    ''' 

    :type: int
    '''

    aggression: float = None
    ''' Boid will fight this times stronger enemy

    :type: float
    '''

    air_acc_max: float = None
    ''' Maximum acceleration in air (relative to maximum speed)

    :type: float
    '''

    air_ave_max: float = None
    ''' Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    '''

    air_personal_space: float = None
    ''' Radius of boids personal space in air (% of particle size)

    :type: float
    '''

    air_speed_max: float = None
    ''' Maximum speed in air

    :type: float
    '''

    air_speed_min: float = None
    ''' Minimum speed in air (relative to maximum speed)

    :type: float
    '''

    bank: float = None
    ''' Amount of rotation around velocity vector on turns

    :type: float
    '''

    health: float = None
    ''' Initial boid health when born

    :type: float
    '''

    height: float = None
    ''' Boid height relative to particle size

    :type: float
    '''

    land_acc_max: float = None
    ''' Maximum acceleration on land (relative to maximum speed)

    :type: float
    '''

    land_ave_max: float = None
    ''' Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    '''

    land_jump_speed: float = None
    ''' Maximum speed for jumping

    :type: float
    '''

    land_personal_space: float = None
    ''' Radius of boids personal space on land (% of particle size)

    :type: float
    '''

    land_smooth: float = None
    ''' How smoothly the boids land

    :type: float
    '''

    land_speed_max: float = None
    ''' Maximum speed on land

    :type: float
    '''

    land_stick_force: float = None
    ''' How strong a force must be to start effecting a boid on land

    :type: float
    '''

    pitch: float = None
    ''' Amount of rotation around side vector

    :type: float
    '''

    range: float = None
    ''' Maximum distance from which a boid can attack

    :type: float
    '''

    states: bpy_prop_collection['BoidState'] = None
    ''' 

    :type: bpy_prop_collection['BoidState']
    '''

    strength: float = None
    ''' Maximum caused damage on attack per second

    :type: float
    '''

    use_climb: bool = None
    ''' Allow boids to climb goal objects

    :type: bool
    '''

    use_flight: bool = None
    ''' Allow boids to move in air

    :type: bool
    '''

    use_land: bool = None
    ''' Allow boids to move on land

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoidState(bpy_struct):
    ''' Boid state for boid physics
    '''

    active_boid_rule: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_rule_index: int = None
    ''' 

    :type: int
    '''

    falloff: float = None
    ''' 

    :type: float
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Boid state name

    :type: typing.Union[str, typing.Any]
    '''

    rule_fuzzy: float = None
    ''' 

    :type: float
    '''

    rules: bpy_prop_collection['BoidRule'] = None
    ''' 

    :type: bpy_prop_collection['BoidRule']
    '''

    ruleset_type: typing.Union[str, int] = None
    ''' How the rules in the list are evaluated * ``FUZZY`` Fuzzy -- Rules are gone through top to bottom (only the first rule which effect is above fuzziness threshold is evaluated). * ``RANDOM`` Random -- A random rule is selected for each boid. * ``AVERAGE`` Average -- All rules are averaged.

    :type: typing.Union[str, int]
    '''

    volume: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Bone(bpy_struct):
    ''' Bone in an Armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveinz: float = None
    ''' Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutz: float = None
    ''' Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'Bone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'Bone'
    '''

    bbone_custom_handle_start: 'Bone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'Bone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    ''' Selects how the end handle of the B-Bone is computed * ``AUTO`` Automatic -- Use connected parent and children to compute the handle. * ``ABSOLUTE`` Absolute -- Use the position of the specified bone to compute the handle. * ``RELATIVE`` Relative -- Use the offset of the specified bone from rest pose to compute the handle. * ``TANGENT`` Tangent -- Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    ''' Selects how the start handle of the B-Bone is computed * ``AUTO`` Automatic -- Use connected parent and children to compute the handle. * ``ABSOLUTE`` Absolute -- Use the position of the specified bone to compute the handle. * ``RELATIVE`` Relative -- Use the offset of the specified bone from rest pose to compute the handle. * ``TANGENT`` Tangent -- Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_use_ease_end: bool = None
    ''' Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    '''

    bbone_handle_use_ease_start: bool = None
    ''' Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    '''

    bbone_handle_use_scale_end: typing.List[bool] = None
    ''' Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    '''

    bbone_handle_use_scale_start: typing.List[bool] = None
    ''' Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    '''

    bbone_mapping_mode: typing.Union[str, int] = None
    ''' Selects how the vertices are mapped to B-Bone segments based on their position * ``STRAIGHT`` Straight -- Fast mapping that is good for most situations, but ignores the rest pose curvature of the B-Bone. * ``CURVED`` Curved -- Slower mapping that gives better deformation for B-Bones that are sharply curved in rest pose.

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bbone_scaleout: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Vector'] = None
    ''' Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    children: bpy_prop_collection['Bone'] = None
    ''' Bones which are children of this bone

    :type: bpy_prop_collection['Bone']
    '''

    collections: 'BoneCollectionMemberships' = None
    ''' Bone Collections that contain this bone

    :type: 'BoneCollectionMemberships'
    '''

    color: 'BoneColor' = None
    ''' 

    :type: 'BoneColor'
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of head end of the bone relative to its parent

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    head_local: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Vector'] = None
    ''' Location of head end of the bone relative to armature

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    ''' Specifies how the bone inherits scaling from the parent bone * ``FULL`` Full -- Inherit all effects of parent scaling. * ``FIX_SHEAR`` Fix Shear -- Inherit scaling, but remove shearing of the child in the rest orientation. * ``ALIGNED`` Aligned -- Rotate non-uniform parent scaling to align with the child, applying parent X scale to child X axis, and so forth. * ``AVERAGE`` Average -- Inherit uniform scaling representing the overall change in the volume of the parent. * ``NONE`` None -- Completely ignore parent scaling. * ``NONE_LEGACY`` None (Legacy) -- Ignore parent scaling without compensating for parent shear. Replicates the effect of disabling the original Inherit Scale checkbox.

    :type: typing.Union[str, int]
    '''

    length: float = None
    ''' Length of the bone

    :type: float
    '''

    matrix: typing.Union[typing.List[typing.List[float]], typing.
                         Tuple[typing.Tuple[float, float, float], typing.
                               Tuple[float, float, float], typing.
                               Tuple[float, float, float]],
                         'mathutils.Matrix'] = None
    ''' 3×3 bone matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], 'mathutils.Matrix']
    '''

    matrix_local: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 4×4 bone matrix relative to armature

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'Bone' = None
    ''' Parent bone (in same Armature)

    :type: 'Bone'
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of tail end of the bone relative to its parent

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tail_local: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Vector'] = None
    ''' Location of tail end of the bone relative to armature

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: typing.Union[bool, typing.Any] = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: typing.Union[bool, typing.Any]
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    use_scale_easing: bool = None
    ''' Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes ``O(len(bones)**2)`` time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(self, point: typing.Optional[
            typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector']]
                          ) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def convert_local_to_pose(
            self,
            matrix: typing.Optional[typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']],
            matrix_local: typing.Optional[typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']],
            parent_matrix: typing.Optional[typing.Any] = ((0.0, 0.0, 0.0, 0.0),
                                                          (0.0, 0.0, 0.0, 0.0),
                                                          (0.0, 0.0, 0.0,
                                                           0.0), (0.0, 0.0,
                                                                  0.0, 0.0)),
            parent_matrix_local: typing.Optional[typing.Any] = ((0.0, 0.0, 0.0,
                                                                 0.0),
                                                                (0.0, 0.0, 0.0,
                                                                 0.0),
                                                                (0.0, 0.0, 0.0,
                                                                 0.0),
                                                                (0.0, 0.0, 0.0,
                                                                 0.0)),
            invert: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> typing.Union[typing.List[typing.List[float]], typing.
                      Tuple[typing.Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float]],
                      'mathutils.Matrix']:
        ''' Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent. This method enables conversions between Local and Pose space for bones in the middle of updating the armature without having to update dependencies after each change, by manually carrying updated matrices in a recursive walk.

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']]
        :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local)
        :type matrix_local: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']]
        :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix)
        :type parent_matrix: typing.Optional[typing.Any]
        :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local)
        :type parent_matrix_local: typing.Optional[typing.Any]
        :param invert: Convert from Pose to Local space
        :type invert: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
        :return: The transformed matrix
        '''
        pass

    @classmethod
    def MatrixFromAxisRoll(
            cls, axis: typing.Any, roll: typing.Optional[float]
    ) -> typing.Union[typing.List[typing.List[float]], typing.
                      Tuple[typing.Tuple[float, float, float], typing.
                            Tuple[float, float, float], typing.
                            Tuple[float, float, float]], 'mathutils.Matrix']:
        ''' Convert the axis + roll representation to a matrix

        :param axis: The main axis of the bone (tail - head)
        :type axis: typing.Any
        :param roll: The roll of the bone
        :type roll: typing.Optional[float]
        :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], 'mathutils.Matrix']
        :return: The resulting orientation matrix
        '''
        pass

    @classmethod
    def AxisRollFromMatrix(cls,
                           matrix: typing.Any,
                           axis: typing.Optional[typing.Any] = (0.0, 0.0,
                                                                0.0)):
        ''' Convert a rotational matrix to the axis + roll representation. Note that the resulting value of the roll may not be as expected if the matrix has shear or negative determinant.

        :param matrix: The orientation matrix of the bone
        :type matrix: typing.Any
        :param axis: The optional override for the axis (finds closest approximation for the matrix)
        :type axis: typing.Optional[typing.Any]
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoneCollection(bpy_struct):
    ''' Bone collection in an Armature data-block
    '''

    bones: bpy_prop_collection['Bone'] = None
    ''' Bones assigned to this bone collection. In armature edit mode this will always return an empty list of bones, as the bone collection memberships are only synchronised when exiting edit mode

    :type: bpy_prop_collection['Bone']
    '''

    is_editable: typing.Union[bool, typing.Any] = None
    ''' This collection is owned by a local Armature, or was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    '''

    is_local_override: typing.Union[bool, typing.Any] = None
    ''' This collection was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    '''

    is_visible: bool = None
    ''' Bones in this collection will be visible in pose/object mode

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique within the Armature

    :type: typing.Union[str, typing.Any]
    '''

    def assign(self, bone: typing.Optional[typing.Any]) -> bool:
        ''' Assign the given bone to this collection

        :param bone: Bone to assign to this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Assigned, Whether the bone was actually assigned; will be false if the bone was already member of the collection
        '''
        pass

    def unassign(self, bone: typing.Optional[typing.Any]) -> bool:
        ''' Remove the given bone from this collection

        :param bone: Bone to remove from this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Unassigned, Whether the bone was actually removed; will be false if the bone was not a member of the collection to begin with
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoneColor(bpy_struct):
    ''' Theme color or custom color of a bone
    '''

    custom: 'ThemeBoneColorSet' = None
    ''' The custom bone colors, used when palette is 'CUSTOM'

    :type: 'ThemeBoneColorSet'
    '''

    is_custom: typing.Union[bool, typing.Any] = None
    ''' A color palette is user-defined, instead of using a theme-defined one

    :type: typing.Union[bool, typing.Any]
    '''

    palette: typing.Union[str, int] = None
    ''' Color palette to use

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BoolAttributeValue(bpy_struct):
    ''' Bool value in geometry attribute
    '''

    value: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilities(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_overlay: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_random_texture_angle: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_smooth_stroke: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_spacing: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesImagePaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_accumulate: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_color: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_radius: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_space_attenuation: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesSculpt(bpy_struct):
    ''' Read-only indications of which brush operations are supported by the current sculpt tool
    '''

    has_accumulate: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_auto_smooth: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_color: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_direction: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_gravity: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_height: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_jitter: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_normal_weight: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_persistence: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_pinch_factor: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_plane_offset: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_rake_factor: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_random_texture_angle: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_sculpt_plane: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_secondary_color: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_smooth_stroke: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_space_attenuation: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_strength_pressure: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_tilt: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_topology_rake: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesVertexPaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_color: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCapabilitiesWeightPaint(bpy_struct):
    ''' Read-only indications of supported operations
    '''

    has_weight: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushCurvesSculptSettings(bpy_struct):
    add_amount: int = None
    ''' Number of curves added by the Add brush

    :type: int
    '''

    curve_length: float = None
    ''' Length of newly added curves when it is not interpolated from other curves

    :type: float
    '''

    curve_parameter_falloff: 'CurveMapping' = None
    ''' Falloff that is applied from the tip to the root of each curve

    :type: 'CurveMapping'
    '''

    density_add_attempts: int = None
    ''' How many times the Density brush tries to add a new curve

    :type: int
    '''

    density_mode: typing.Union[str, int] = None
    ''' Determines whether the brush adds or removes curves * ``AUTO`` Auto -- Either add or remove curves depending on the minimum distance of the curves under the cursor. * ``ADD`` Add -- Add new curves between existing curves, taking the minimum distance into account. * ``REMOVE`` Remove -- Remove curves whose root points are too close.

    :type: typing.Union[str, int]
    '''

    interpolate_length: bool = None
    ''' Use length of the curves in close proximity

    :type: bool
    '''

    interpolate_point_count: bool = None
    ''' Use the number of points from the curves in close proximity

    :type: bool
    '''

    interpolate_shape: bool = None
    ''' Use shape of the curves in close proximity

    :type: bool
    '''

    minimum_distance: float = None
    ''' Goal distance between curve roots for the Density brush

    :type: float
    '''

    minimum_length: float = None
    ''' Avoid shrinking curves shorter than this length

    :type: float
    '''

    points_per_curve: int = None
    ''' Number of control points in a newly added curve

    :type: int
    '''

    scale_uniform: bool = None
    ''' Grow or shrink curves by changing their size uniformly instead of using trimming or extrapolation

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class BrushGpencilSettings(bpy_struct):
    ''' Settings for grease pencil brush
    '''

    active_smooth_factor: float = None
    ''' Amount of smoothing while drawing

    :type: float
    '''

    angle: float = None
    ''' Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    '''

    angle_factor: float = None
    ''' Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    '''

    aspect: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    brush_draw_mode: typing.Union[str, int] = None
    ''' Preselected mode when using this brush * ``ACTIVE`` Active -- Use current mode. * ``MATERIAL`` Material -- Use always material mode. * ``VERTEXCOLOR`` Vertex Color -- Use always Vertex Color mode.

    :type: typing.Union[str, int]
    '''

    caps_type: typing.Union[str, int] = None
    ''' The shape of the start and end of the stroke

    :type: typing.Union[str, int]
    '''

    curve_jitter: 'CurveMapping' = None
    ''' Curve used for the jitter effect

    :type: 'CurveMapping'
    '''

    curve_random_hue: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_pressure: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_saturation: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_strength: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_uv: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_random_value: 'CurveMapping' = None
    ''' Curve used for modulating effect

    :type: 'CurveMapping'
    '''

    curve_sensitivity: 'CurveMapping' = None
    ''' Curve used for the sensitivity

    :type: 'CurveMapping'
    '''

    curve_strength: 'CurveMapping' = None
    ''' Curve used for the strength

    :type: 'CurveMapping'
    '''

    dilate: int = None
    ''' Number of pixels to expand or contract fill area

    :type: int
    '''

    direction: typing.Union[str, int] = None
    ''' * ``ADD`` Add -- Add effect of brush. * ``SUBTRACT`` Subtract -- Subtract effect of brush.

    :type: typing.Union[str, int]
    '''

    eraser_mode: typing.Union[str, int] = None
    ''' Eraser Mode * ``SOFT`` Dissolve -- Erase strokes, fading their points strength and thickness. * ``HARD`` Point -- Erase stroke points. * ``STROKE`` Stroke -- Erase entire strokes.

    :type: typing.Union[str, int]
    '''

    eraser_strength_factor: float = None
    ''' Amount of erasing for strength

    :type: float
    '''

    eraser_thickness_factor: float = None
    ''' Amount of erasing for thickness

    :type: float
    '''

    extend_stroke_factor: float = None
    ''' Strokes end extension for closing gaps, use zero to disable

    :type: float
    '''

    fill_direction: typing.Union[str, int] = None
    ''' Direction of the fill * ``NORMAL`` Normal -- Fill internal area. * ``INVERT`` Inverted -- Fill inverted area.

    :type: typing.Union[str, int]
    '''

    fill_draw_mode: typing.Union[str, int] = None
    ''' Mode to draw boundary limits * ``BOTH`` All -- Use both visible strokes and edit lines as fill boundary limits. * ``STROKE`` Strokes -- Use visible strokes as fill boundary limits. * ``CONTROL`` Edit Lines -- Use edit lines as fill boundary limits.

    :type: typing.Union[str, int]
    '''

    fill_extend_mode: typing.Union[str, int] = None
    ''' Types of stroke extensions used for closing gaps * ``EXTEND`` Extend -- Extend strokes in straight lines. * ``RADIUS`` Radius -- Connect endpoints that are close together.

    :type: typing.Union[str, int]
    '''

    fill_factor: float = None
    ''' Factor for fill boundary accuracy, higher values are more accurate but slower

    :type: float
    '''

    fill_layer_mode: typing.Union[str, int] = None
    ''' Layers used as boundaries * ``VISIBLE`` Visible -- Visible layers. * ``ACTIVE`` Active -- Only active layer. * ``ABOVE`` Layer Above -- Layer above active. * ``BELOW`` Layer Below -- Layer below active. * ``ALL_ABOVE`` All Above -- All layers above active. * ``ALL_BELOW`` All Below -- All layers below active.

    :type: typing.Union[str, int]
    '''

    fill_simplify_level: int = None
    ''' Number of simplify steps (large values reduce fill accuracy)

    :type: int
    '''

    fill_threshold: float = None
    ''' Threshold to consider color transparent for filling

    :type: float
    '''

    gpencil_paint_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_sculpt_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_vertex_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gpencil_weight_icon: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    hardness: float = None
    ''' Gradient from the center of Dot and Box strokes (set to 1 for a solid stroke)

    :type: float
    '''

    input_samples: int = None
    ''' Generate intermediate points for very fast mouse movements. Set to 0 to disable

    :type: int
    '''

    material: 'Material' = None
    ''' Material used for strokes drawn using this brush

    :type: 'Material'
    '''

    material_alt: 'Material' = None
    ''' Material used for secondary uses for this brush

    :type: 'Material'
    '''

    outline_thickness_factor: float = None
    ''' Thickness of the outline stroke relative to current brush thickness

    :type: float
    '''

    pen_jitter: float = None
    ''' Jitter factor for new strokes

    :type: float
    '''

    pen_smooth_factor: float = None
    ''' Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise

    :type: float
    '''

    pen_smooth_steps: int = None
    ''' Number of times to smooth newly created strokes

    :type: int
    '''

    pen_strength: float = None
    ''' Color strength for new strokes (affect alpha factor of color)

    :type: float
    '''

    pen_subdivision_steps: int = None
    ''' Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    '''

    pin_draw_mode: bool = None
    ''' Pin the mode to the brush

    :type: bool
    '''

    random_hue_factor: float = None
    ''' Random factor to modify original hue

    :type: float
    '''

    random_pressure: float = None
    ''' Randomness factor for pressure in new strokes

    :type: float
    '''

    random_saturation_factor: float = None
    ''' Random factor to modify original saturation

    :type: float
    '''

    random_strength: float = None
    ''' Randomness factor strength in new strokes

    :type: float
    '''

    random_value_factor: float = None
    ''' Random factor to modify original value

    :type: float
    '''

    show_fill: bool = None
    ''' Show transparent lines to use as boundary for filling

    :type: bool
    '''

    show_fill_boundary: bool = None
    ''' Show help lines for filling to see boundaries

    :type: bool
    '''

    show_fill_extend: bool = None
    ''' Show help lines for stroke extension

    :type: bool
    '''

    show_lasso: bool = None
    ''' Do not display fill color while drawing the stroke

    :type: bool
    '''

    simplify_factor: float = None
    ''' Factor of Simplify using adaptive algorithm

    :type: float
    '''

    use_active_layer_only: bool = None
    ''' Only edit the active layer of the object

    :type: bool
    '''

    use_collide_strokes: bool = None
    ''' Check if extend lines collide with strokes

    :type: bool
    '''

    use_default_eraser: bool = None
    ''' Use this brush when enable eraser with fast switch key

    :type: bool
    '''

    use_edit_position: bool = None
    ''' The brush affects the position of the point

    :type: bool
    '''

    use_edit_strength: bool = None
    ''' The brush affects the color strength of the point

    :type: bool
    '''

    use_edit_thickness: bool = None
    ''' The brush affects the thickness of the point

    :type: bool
    '''

    use_edit_uv: bool = None
    ''' The brush affects the UV rotation of the point

    :type: bool
    '''

    use_fill_limit: bool = None
    ''' Fill only visible areas in viewport

    :type: bool
    '''

    use_jitter_pressure: bool = None
    ''' Use tablet pressure for jitter

    :type: bool
    '''

    use_keep_caps_eraser: bool = None
    ''' Keep the caps as they are and don't flatten them when erasing

    :type: bool
    '''

    use_material_pin: bool = None
    ''' Keep material assigned to brush

    :type: bool
    '''

    use_occlude_eraser: bool = None
    ''' Erase only strokes visible and not occluded

    :type: bool
    '''

    use_pressure: bool = None
    ''' Use tablet pressure

    :type: bool
    '''

    use_random_press_hue: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_radius: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_sat: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_strength: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_uv: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_random_press_val: bool = None
    ''' Use pressure to modulate randomness

    :type: bool
    '''

    use_settings_outline: bool = None
    ''' Convert stroke to perimeter

    :type: bool
    '''

    use_settings_postprocess: bool = None
    ''' Additional post processing options for new strokes

    :type: bool
    '''

    use_settings_random: bool = None
    ''' Random brush settings

    :type: bool
    '''

    use_settings_stabilizer: bool = None
    ''' Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing

    :type: bool
    '''

    use_strength_pressure: bool = None
    ''' Use tablet pressure for color strength

    :type: bool
    '''

    use_stroke_random_hue: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_radius: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_sat: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_strength: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_uv: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_stroke_random_val: bool = None
    ''' Use randomness at stroke level

    :type: bool
    '''

    use_trim: bool = None
    ''' Trim intersecting stroke ends

    :type: bool
    '''

    uv_random: float = None
    ''' Random factor for auto-generated UV rotation

    :type: float
    '''

    vertex_color_factor: float = None
    ''' Factor used to mix vertex color to get final color

    :type: float
    '''

    vertex_mode: typing.Union[str, int] = None
    ''' Defines how vertex color affect to the strokes * ``STROKE`` Stroke -- Vertex Color affects to Stroke only. * ``FILL`` Fill -- Vertex Color affects to Fill only. * ``BOTH`` Stroke & Fill -- Vertex Color affects to Stroke and Fill.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ByteColorAttributeValue(bpy_struct):
    ''' Color value in geometry attribute
    '''

    color: bpy_prop_array[float] = None
    ''' RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    '''

    color_srgb: bpy_prop_array[float] = None
    ''' RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ByteIntAttributeValue(bpy_struct):
    ''' 8-bit value in geometry attribute
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CacheFileLayer(bpy_struct):
    ''' Layer of the cache, used to load or override data from the first the first layer
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to the archive

    :type: typing.Union[str, typing.Any]
    '''

    hide_layer: bool = None
    ''' Do not load data from this layer

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CacheObjectPath(bpy_struct):
    ''' Path of an object inside of an Alembic archive
    '''

    path: typing.Union[str, typing.Any] = None
    ''' Object path

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CameraBackgroundImage(bpy_struct):
    ''' Image and settings for display in the 3D View background
    '''

    alpha: float = None
    ''' Image opacity to blend the image against the background color

    :type: float
    '''

    clip: 'MovieClip' = None
    ''' Movie clip displayed and edited in this space

    :type: 'MovieClip'
    '''

    clip_user: 'MovieClipUser' = None
    ''' Parameters defining which frame of the movie clip is displayed

    :type: 'MovieClipUser'
    '''

    display_depth: typing.Union[str, int] = None
    ''' Display under or over everything

    :type: typing.Union[str, int]
    '''

    frame_method: typing.Union[str, int] = None
    ''' How the image fits in the camera frame

    :type: typing.Union[str, int]
    '''

    image: 'Image' = None
    ''' Image displayed and edited in this space

    :type: 'Image'
    '''

    image_user: 'ImageUser' = None
    ''' Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    '''

    is_override_data: typing.Union[bool, typing.Any] = None
    ''' In a local override camera, whether this background image comes from the linked reference camera, or is local to the override

    :type: typing.Union[bool, typing.Any]
    '''

    offset: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    rotation: float = None
    ''' Rotation for the background image (ortho view only)

    :type: float
    '''

    scale: float = None
    ''' Scale the background image

    :type: float
    '''

    show_background_image: bool = None
    ''' Show this image as background

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show the details in the user interface

    :type: bool
    '''

    show_on_foreground: bool = None
    ''' Show this image in front of objects in viewport

    :type: bool
    '''

    source: typing.Union[str, int] = None
    ''' Data source used for background

    :type: typing.Union[str, int]
    '''

    use_camera_clip: bool = None
    ''' Use movie clip from active scene camera

    :type: bool
    '''

    use_flip_x: bool = None
    ''' Flip the background image horizontally

    :type: bool
    '''

    use_flip_y: bool = None
    ''' Flip the background image vertically

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CameraDOFSettings(bpy_struct):
    ''' Depth of Field settings
    '''

    aperture_blades: int = None
    ''' Number of blades in aperture for polygonal bokeh (at least 3)

    :type: int
    '''

    aperture_fstop: float = None
    ''' F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image)

    :type: float
    '''

    aperture_ratio: float = None
    ''' Distortion to simulate anamorphic lens bokeh

    :type: float
    '''

    aperture_rotation: float = None
    ''' Rotation of blades in aperture

    :type: float
    '''

    focus_distance: float = None
    ''' Distance to the focus point for depth of field

    :type: float
    '''

    focus_object: 'Object' = None
    ''' Use this object to define the depth of field focal point

    :type: 'Object'
    '''

    focus_subtarget: typing.Union[str, typing.Any] = None
    ''' Use this armature bone to define the depth of field focal point

    :type: typing.Union[str, typing.Any]
    '''

    use_dof: bool = None
    ''' Use Depth of Field

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CameraStereoData(bpy_struct):
    ''' Stereoscopy settings for a Camera data-block
    '''

    convergence_distance: float = None
    ''' The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    '''

    convergence_mode: typing.Union[str, int] = None
    ''' * ``OFFAXIS`` Off-Axis -- Off-axis frustums converging in a plane. * ``PARALLEL`` Parallel -- Parallel cameras with no convergence. * ``TOE`` Toe-in -- Rotated cameras, looking at the convergence distance.

    :type: typing.Union[str, int]
    '''

    interocular_distance: float = None
    ''' Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    '''

    pivot: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    pole_merge_angle_from: float = None
    ''' Angle at which interocular distance starts to fade to 0

    :type: float
    '''

    pole_merge_angle_to: float = None
    ''' Angle at which interocular distance is 0

    :type: float
    '''

    use_pole_merge: bool = None
    ''' Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    '''

    use_spherical_stereo: bool = None
    ''' Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ChildParticle(bpy_struct):
    ''' Child particle interpolated from simulated or edited particles
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ClothCollisionSettings(bpy_struct):
    ''' Cloth simulation settings for self collision and collision with other objects
    '''

    collection: 'Collection' = None
    ''' Limit colliders to this Collection

    :type: 'Collection'
    '''

    collision_quality: int = None
    ''' How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    '''

    damping: float = None
    ''' Amount of velocity lost on collision

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance between collision objects before collision response takes effect

    :type: float
    '''

    friction: float = None
    ''' Friction force if a collision happened (higher = less movement)

    :type: float
    '''

    impulse_clamp: float = None
    ''' Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    '''

    self_distance_min: float = None
    ''' Minimum distance between cloth faces before collision response takes effect

    :type: float
    '''

    self_friction: float = None
    ''' Friction with self contact

    :type: float
    '''

    self_impulse_clamp: float = None
    ''' Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    '''

    use_collision: bool = None
    ''' Enable collisions with other objects

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable self collisions

    :type: bool
    '''

    vertex_group_object_collisions: typing.Union[str, typing.Any] = None
    ''' Triangles with all vertices in this group are not used during object collisions

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_self_collisions: typing.Union[str, typing.Any] = None
    ''' Triangles with all vertices in this group are not used during self collisions

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ClothSettings(bpy_struct):
    ''' Cloth simulation settings for an object
    '''

    air_damping: float = None
    ''' Air has normally some thickness which slows falling things down

    :type: float
    '''

    bending_damping: float = None
    ''' Amount of damping in bending behavior

    :type: float
    '''

    bending_model: typing.Union[str, int] = None
    ''' Physical model for simulating bending forces * ``ANGULAR`` Angular -- Cloth model with angular bending springs. * ``LINEAR`` Linear -- Cloth model with linear bending springs (legacy).

    :type: typing.Union[str, int]
    '''

    bending_stiffness: float = None
    ''' How much the material resists bending

    :type: float
    '''

    bending_stiffness_max: float = None
    ''' Maximum bending stiffness value

    :type: float
    '''

    collider_friction: float = None
    ''' 

    :type: float
    '''

    compression_damping: float = None
    ''' Amount of damping in compression behavior

    :type: float
    '''

    compression_stiffness: float = None
    ''' How much the material resists compression

    :type: float
    '''

    compression_stiffness_max: float = None
    ''' Maximum compression stiffness value

    :type: float
    '''

    density_strength: float = None
    ''' Influence of target density on the simulation

    :type: float
    '''

    density_target: float = None
    ''' Maximum density of hair

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    fluid_density: float = None
    ''' Density (kg/l) of the fluid contained inside the object, used to create a hydrostatic pressure gradient simulating the weight of the internal fluid, or buoyancy from the surrounding fluid if negative

    :type: float
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: typing.Union[typing.List[float], typing.
                          Tuple[float, float, float],
                          'mathutils.Vector'] = None
    ''' Gravity or external force vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    internal_compression_stiffness: float = None
    ''' How much the material resists compression

    :type: float
    '''

    internal_compression_stiffness_max: float = None
    ''' Maximum compression stiffness value

    :type: float
    '''

    internal_friction: float = None
    ''' 

    :type: float
    '''

    internal_spring_max_diversion: float = None
    ''' How much the rays used to connect the internal points can diverge from the vertex normal

    :type: float
    '''

    internal_spring_max_length: float = None
    ''' The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit

    :type: float
    '''

    internal_spring_normal_check: bool = None
    ''' Require the points the internal springs connect to have opposite normal directions

    :type: bool
    '''

    internal_tension_stiffness: float = None
    ''' How much the material resists stretching

    :type: float
    '''

    internal_tension_stiffness_max: float = None
    ''' Maximum tension stiffness value

    :type: float
    '''

    mass: float = None
    ''' The mass of each vertex on the cloth material

    :type: float
    '''

    pin_stiffness: float = None
    ''' Pin (vertex target position) spring stiffness

    :type: float
    '''

    pressure_factor: float = None
    ''' Ambient pressure (kPa) that balances out between the inside and outside of the object when it has the target volume

    :type: float
    '''

    quality: int = None
    ''' Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    '''

    rest_shape_key: 'ShapeKey' = None
    ''' Shape key to use the rest spring lengths from

    :type: 'ShapeKey'
    '''

    sewing_force_max: float = None
    ''' Maximum sewing force

    :type: float
    '''

    shear_damping: float = None
    ''' Amount of damping in shearing behavior

    :type: float
    '''

    shear_stiffness: float = None
    ''' How much the material resists shearing

    :type: float
    '''

    shear_stiffness_max: float = None
    ''' Maximum shear scaling value

    :type: float
    '''

    shrink_max: float = None
    ''' Max amount to shrink cloth by

    :type: float
    '''

    shrink_min: float = None
    ''' Factor by which to shrink cloth

    :type: float
    '''

    target_volume: float = None
    ''' The mesh volume where the inner/outer pressure will be the same. If set to zero the change in volume will not affect pressure

    :type: float
    '''

    tension_damping: float = None
    ''' Amount of damping in stretching behavior

    :type: float
    '''

    tension_stiffness: float = None
    ''' How much the material resists stretching

    :type: float
    '''

    tension_stiffness_max: float = None
    ''' Maximum tension stiffness value

    :type: float
    '''

    time_scale: float = None
    ''' Cloth speed is multiplied by this value

    :type: float
    '''

    uniform_pressure_force: float = None
    ''' The uniform pressure that is constantly applied to the mesh, in units of Pressure Scale. Can be negative

    :type: float
    '''

    use_dynamic_mesh: bool = None
    ''' Make simulation respect deformations in the base mesh

    :type: bool
    '''

    use_internal_springs: bool = None
    ''' Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh

    :type: bool
    '''

    use_pressure: bool = None
    ''' Simulate pressure inside a closed cloth mesh

    :type: bool
    '''

    use_pressure_volume: bool = None
    ''' Use the Target Volume parameter as the initial volume, instead of calculating it from the mesh itself

    :type: bool
    '''

    use_sewing_springs: bool = None
    ''' Pulls loose edges together

    :type: bool
    '''

    vertex_group_bending: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over bending stiffness

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_intern: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over the internal spring stiffness

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_mass: typing.Union[str, typing.Any] = None
    ''' Vertex Group for pinning of vertices

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_pressure: typing.Union[str, typing.Any] = None
    ''' Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_shear_stiffness: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over shear stiffness

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_shrink: typing.Union[str, typing.Any] = None
    ''' Vertex Group for shrinking cloth

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_structural_stiffness: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over structural stiffness

    :type: typing.Union[str, typing.Any]
    '''

    voxel_cell_size: float = None
    ''' Size of the voxel grid cells for interaction effects

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ClothSolverResult(bpy_struct):
    ''' Result of cloth solver iteration
    '''

    avg_error: float = None
    ''' Average error during substeps

    :type: float
    '''

    avg_iterations: float = None
    ''' Average iterations during substeps

    :type: float
    '''

    max_error: float = None
    ''' Maximum error during substeps

    :type: float
    '''

    max_iterations: int = None
    ''' Maximum iterations during substeps

    :type: int
    '''

    min_error: float = None
    ''' Minimum error during substeps

    :type: float
    '''

    min_iterations: int = None
    ''' Minimum iterations during substeps

    :type: int
    '''

    status: typing.Any = None
    ''' Status of the solver iteration * ``SUCCESS`` Success -- Computation was successful. * ``NUMERICAL_ISSUE`` Numerical Issue -- The provided data did not satisfy the prerequisites. * ``NO_CONVERGENCE`` No Convergence -- Iterative procedure did not converge. * ``INVALID_INPUT`` Invalid Input -- The inputs are invalid, or the algorithm has been improperly called.

    :type: typing.Any
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CollectionChild(bpy_struct):
    ''' Child collection with its collection related settings
    '''

    light_linking: 'CollectionLightLinking' = None
    ''' Light linking settings of the collection object

    :type: 'CollectionLightLinking'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CollectionLightLinking(bpy_struct):
    ''' Light linking settings of objects and children collections of a collection
    '''

    link_state: typing.Union[str, int] = None
    ''' Light or shadow receiving state of the object or collection

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CollectionObject(bpy_struct):
    ''' Object of a collection with its collection related settings
    '''

    light_linking: 'CollectionLightLinking' = None
    ''' Light linking settings of the collection

    :type: 'CollectionLightLinking'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CollisionSettings(bpy_struct):
    ''' Collision settings for object in physics simulation
    '''

    absorption: float = None
    ''' How much of effector force gets lost during collision with this object (in percent)

    :type: float
    '''

    cloth_friction: float = None
    ''' Friction for cloth collisions

    :type: float
    '''

    damping: float = None
    ''' Amount of damping during collision

    :type: float
    '''

    damping_factor: float = None
    ''' Amount of damping during particle collision

    :type: float
    '''

    damping_random: float = None
    ''' Random variation of damping

    :type: float
    '''

    friction_factor: float = None
    ''' Amount of friction during particle collision

    :type: float
    '''

    friction_random: float = None
    ''' Random variation of friction

    :type: float
    '''

    permeability: float = None
    ''' Chance that the particle will pass through the mesh

    :type: float
    '''

    stickiness: float = None
    ''' Amount of stickiness to surface collision

    :type: float
    '''

    thickness_inner: float = None
    ''' Inner face thickness (only used by softbodies)

    :type: float
    '''

    thickness_outer: float = None
    ''' Outer face thickness

    :type: float
    '''

    use: bool = None
    ''' Enable this object as a collider for physics systems

    :type: bool
    '''

    use_culling: bool = None
    ''' Cloth collision acts with respect to the collider normals (improves penetration recovery)

    :type: bool
    '''

    use_normal: bool = None
    ''' Cloth collision impulses act in the direction of the collider normals (more reliable in some cases)

    :type: bool
    '''

    use_particle_kill: bool = None
    ''' Kill collided particles

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorManagedDisplaySettings(bpy_struct):
    ''' Color management specific to display device
    '''

    display_device: typing.Union[str, int] = None
    ''' Display device name

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorManagedInputColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    is_data: bool = None
    ''' Treat image as non-color data without color management, like normal or displacement maps

    :type: bool
    '''

    name: typing.Union[str, int] = None
    ''' Color space in the image file, to convert to and from when saving and loading the image

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorManagedSequencerColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    name: typing.Union[str, int] = None
    ''' Color space that the sequencer operates in

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorManagedViewSettings(bpy_struct):
    ''' Color management settings used for displaying images on the display
    '''

    curve_mapping: 'CurveMapping' = None
    ''' Color curve mapping applied before display transform

    :type: 'CurveMapping'
    '''

    exposure: float = None
    ''' Exposure (stops) applied before display transform

    :type: float
    '''

    gamma: float = None
    ''' Amount of gamma modification applied after display transform

    :type: float
    '''

    look: typing.Union[str, int] = None
    ''' Additional transform applied before view transform for artistic needs * ``NONE`` None -- Do not modify image in an artistic manner.

    :type: typing.Union[str, int]
    '''

    use_curve_mapping: bool = None
    ''' Use RGB curved for pre-display transformation

    :type: bool
    '''

    use_hdr_view: bool = None
    ''' Enable high dynamic range display in rendered viewport, uncapping display brightness. This requires a monitor with HDR support and a view transform designed for HDR. 'Filmic' and 'AgX' do not generate HDR colors

    :type: bool
    '''

    view_transform: typing.Union[str, int] = None
    ''' View used when converting image to a display space * ``NONE`` None -- Do not perform any color transform on display, use old non-color managed technique for display.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorMapping(bpy_struct):
    ''' Color mapping settings
    '''

    blend_color: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Blend color to mix with texture output color

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    blend_factor: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to mix with texture output color

    :type: typing.Union[str, int]
    '''

    brightness: float = None
    ''' Adjust the brightness of the texture

    :type: float
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    contrast: float = None
    ''' Adjust the contrast of the texture

    :type: float
    '''

    saturation: float = None
    ''' Adjust the saturation of colors in the texture

    :type: float
    '''

    use_color_ramp: bool = None
    ''' Toggle color ramp operations

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorRamp(bpy_struct):
    ''' Color ramp mapping a scalar value to a color
    '''

    color_mode: typing.Union[str, int] = None
    ''' Set color mode to use for interpolation

    :type: typing.Union[str, int]
    '''

    elements: 'ColorRampElements' = None
    ''' 

    :type: 'ColorRampElements'
    '''

    hue_interpolation: typing.Union[str, int] = None
    ''' Set color interpolation

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Set interpolation between color stops

    :type: typing.Union[str, int]
    '''

    def evaluate(self,
                 position: typing.Optional[float]) -> bpy_prop_array[float]:
        ''' Evaluate Color Ramp

        :param position: Position, Evaluate Color Ramp at position
        :type position: typing.Optional[float]
        :rtype: bpy_prop_array[float]
        :return: Color, Color at given position
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ColorRampElement(bpy_struct):
    ''' Element defining a color at a position in the color ramp
    '''

    alpha: float = None
    ''' Set alpha of selected color stop

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Set color of selected color stop

    :type: bpy_prop_array[float]
    '''

    position: float = None
    ''' Set position of selected color stop

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ConsoleLine(bpy_struct):
    ''' Input line for the interactive console
    '''

    body: typing.Union[str, typing.Any] = None
    ''' Text in the line

    :type: typing.Union[str, typing.Any]
    '''

    current_character: int = None
    ''' 

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Console line type when used in scrollback

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Constraint(bpy_struct):
    ''' Constraint modifying the transformation of objects and bones
    '''

    active: bool = None
    ''' Constraint is the one being edited

    :type: bool
    '''

    enabled: bool = None
    ''' Use the results of this constraint

    :type: bool
    '''

    error_location: float = None
    ''' Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    '''

    error_rotation: float = None
    ''' Amount of residual error in radians for constraints that work on orientation

    :type: float
    '''

    influence: float = None
    ''' Amount of influence constraint will have on the final solution

    :type: float
    '''

    is_override_data: typing.Union[bool, typing.Any] = None
    ''' In a local override object, whether this constraint comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Constraint has valid settings and can be evaluated

    :type: typing.Union[bool, typing.Any]
    '''

    mute: bool = None
    ''' Enable/Disable Constraint

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Constraint name

    :type: typing.Union[str, typing.Any]
    '''

    owner_space: typing.Union[str, int] = None
    ''' Space that owner is evaluated in * ``WORLD`` World Space -- The constraint is applied relative to the world coordinate system. * ``CUSTOM`` Custom Space -- The constraint is applied in local space of a custom object/bone/vertex group. * ``POSE`` Pose Space -- The constraint is applied in Pose Space, the object transformation is ignored. * ``LOCAL_WITH_PARENT`` Local With Parent -- The constraint is applied relative to the rest pose local coordinate system of the bone, thus including the parent-induced transformation. * ``LOCAL`` Local Space -- The constraint is applied relative to the local coordinate system of the object.

    :type: typing.Union[str, int]
    '''

    show_expanded: bool = None
    ''' Constraint's panel is expanded in UI

    :type: bool
    '''

    space_object: 'Object' = None
    ''' Object for Custom Space

    :type: 'Object'
    '''

    space_subtarget: typing.Union[str, typing.Any] = None
    ''' Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    '''

    target_space: typing.Union[str, int] = None
    ''' Space that target is evaluated in * ``WORLD`` World Space -- The transformation of the target is evaluated relative to the world coordinate system. * ``CUSTOM`` Custom Space -- The transformation of the target is evaluated relative to a custom object/bone/vertex group. * ``POSE`` Pose Space -- The transformation of the target is only evaluated in the Pose Space, the target armature object transformation is ignored. * ``LOCAL_WITH_PARENT`` Local With Parent -- The transformation of the target bone is evaluated relative to its rest pose local coordinate system, thus including the parent-induced transformation. * ``LOCAL`` Local Space -- The transformation of the target is evaluated relative to its local coordinate system. * ``LOCAL_OWNER_ORIENT`` Local Space (Owner Orientation) -- The transformation of the target bone is evaluated relative to its local coordinate system, followed by a correction for the difference in target and owner rest pose orientations. When applied as local transform to the owner produces the same global motion as the target if the parents are still in rest pose.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ConstraintTarget(bpy_struct):
    ''' Target object for multi-target constraints
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target object

    :type: 'Object'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ConstraintTargetBone(bpy_struct):
    ''' Target bone for multi-target constraints
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' Target armature bone

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target armature

    :type: 'Object'
    '''

    weight: float = None
    ''' Blending weight of this bone

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Context(bpy_struct):
    ''' Current windowmanager and data context
    '''

    area: 'Area' = None
    ''' 

    :type: 'Area'
    '''

    asset: 'AssetRepresentation' = None
    ''' 

    :type: 'AssetRepresentation'
    '''

    blend_data: 'BlendData' = None
    ''' 

    :type: 'BlendData'
    '''

    collection: 'Collection' = None
    ''' 

    :type: 'Collection'
    '''

    engine: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    gizmo_group: 'GizmoGroup' = None
    ''' 

    :type: 'GizmoGroup'
    '''

    layer_collection: 'LayerCollection' = None
    ''' 

    :type: 'LayerCollection'
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    preferences: 'Preferences' = None
    ''' 

    :type: 'Preferences'
    '''

    region: 'Region' = None
    ''' 

    :type: 'Region'
    '''

    region_data: 'RegionView3D' = None
    ''' 

    :type: 'RegionView3D'
    '''

    scene: 'Scene' = None
    ''' 

    :type: 'Scene'
    '''

    screen: 'Screen' = None
    ''' 

    :type: 'Screen'
    '''

    space_data: 'Space' = None
    ''' The current space, may be None in background-mode, when the cursor is outside the window or when using menu-search

    :type: 'Space'
    '''

    tool_settings: 'ToolSettings' = None
    ''' 

    :type: 'ToolSettings'
    '''

    view_layer: 'ViewLayer' = None
    ''' 

    :type: 'ViewLayer'
    '''

    window: 'Window' = None
    ''' 

    :type: 'Window'
    '''

    window_manager: 'WindowManager' = None
    ''' 

    :type: 'WindowManager'
    '''

    workspace: 'WorkSpace' = None
    ''' 

    :type: 'WorkSpace'
    '''

    texture_slot: 'TextureSlot' = None
    ''' 

    :type: 'TextureSlot'
    '''

    world: 'World' = None
    ''' 

    :type: 'World'
    '''

    object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    mesh: 'Mesh' = None
    ''' 

    :type: 'Mesh'
    '''

    armature: 'Armature' = None
    ''' 

    :type: 'Armature'
    '''

    lattice: 'Lattice' = None
    ''' 

    :type: 'Lattice'
    '''

    curve: 'Curve' = None
    ''' 

    :type: 'Curve'
    '''

    meta_ball: 'MetaBall' = None
    ''' 

    :type: 'MetaBall'
    '''

    light: 'Light' = None
    ''' 

    :type: 'Light'
    '''

    speaker: 'Speaker' = None
    ''' 

    :type: 'Speaker'
    '''

    lightprobe: 'LightProbe' = None
    ''' 

    :type: 'LightProbe'
    '''

    camera: 'Camera' = None
    ''' 

    :type: 'Camera'
    '''

    material: 'Material' = None
    ''' 

    :type: 'Material'
    '''

    material_slot: 'MaterialSlot' = None
    ''' 

    :type: 'MaterialSlot'
    '''

    texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    texture_user: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    texture_user_property: 'Property' = None
    ''' 

    :type: 'Property'
    '''

    bone: 'Bone' = None
    ''' 

    :type: 'Bone'
    '''

    edit_bone: 'EditBone' = None
    ''' 

    :type: 'EditBone'
    '''

    pose_bone: 'PoseBone' = None
    ''' 

    :type: 'PoseBone'
    '''

    particle_system: 'ParticleSystem' = None
    ''' 

    :type: 'ParticleSystem'
    '''

    particle_system_editable: 'ParticleSystem' = None
    ''' 

    :type: 'ParticleSystem'
    '''

    particle_settings: 'ParticleSettings' = None
    ''' 

    :type: 'ParticleSettings'
    '''

    cloth: 'ClothModifier' = None
    ''' 

    :type: 'ClothModifier'
    '''

    soft_body: 'SoftBodyModifier' = None
    ''' 

    :type: 'SoftBodyModifier'
    '''

    fluid: typing.Any = None
    ''' 

    :type: typing.Any
    '''

    collision: 'CollisionModifier' = None
    ''' 

    :type: 'CollisionModifier'
    '''

    brush: 'Brush' = None
    ''' 

    :type: 'Brush'
    '''

    dynamic_paint: 'DynamicPaintModifier' = None
    ''' 

    :type: 'DynamicPaintModifier'
    '''

    line_style: 'FreestyleLineStyle' = None
    ''' 

    :type: 'FreestyleLineStyle'
    '''

    gpencil: 'GreasePencil' = None
    ''' 

    :type: 'GreasePencil'
    '''

    grease_pencil: typing.Any = None
    ''' 

    :type: typing.Any
    '''

    curves: 'Curves' = None
    ''' 

    :type: 'Curves'
    '''

    volume: 'Volume' = None
    ''' 

    :type: 'Volume'
    '''

    edit_movieclip: 'MovieClip' = None
    ''' 

    :type: 'MovieClip'
    '''

    edit_mask: 'Mask' = None
    ''' 

    :type: 'Mask'
    '''

    active_file: 'FileSelectEntry' = None
    ''' 

    :type: 'FileSelectEntry'
    '''

    selected_files: typing.Iterable['FileSelectEntry'] = None
    ''' 

    :type: typing.Iterable['FileSelectEntry']
    '''

    asset_library_reference: 'AssetLibraryReference' = None
    ''' 

    :type: 'AssetLibraryReference'
    '''

    selected_assets: typing.Iterable['AssetRepresentation'] = None
    ''' 

    :type: typing.Iterable['AssetRepresentation']
    '''

    id: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    selected_ids: typing.Iterable['ID'] = None
    ''' 

    :type: typing.Iterable['ID']
    '''

    edit_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    selected_nodes: typing.Iterable['Node'] = None
    ''' 

    :type: typing.Iterable['Node']
    '''

    active_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    visible_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selectable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selected_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    editable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selected_editable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    objects_in_mode: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    objects_in_mode_unique_data: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    visible_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    editable_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    selected_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    selected_editable_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    visible_pose_bones: typing.Iterable['PoseBone'] = None
    ''' 

    :type: typing.Iterable['PoseBone']
    '''

    selected_pose_bones: typing.Iterable['PoseBone'] = None
    ''' 

    :type: typing.Iterable['PoseBone']
    '''

    selected_pose_bones_from_active_object: typing.Iterable['PoseBone'] = None
    ''' 

    :type: typing.Iterable['PoseBone']
    '''

    active_bone: 'EditBone' = None
    ''' 

    :type: 'EditBone'
    '''

    active_pose_bone: 'PoseBone' = None
    ''' 

    :type: 'PoseBone'
    '''

    active_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    edit_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    sculpt_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    vertex_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    weight_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    image_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    particle_edit_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    pose_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    active_sequence_strip: 'Sequence' = None
    ''' 

    :type: 'Sequence'
    '''

    sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    selected_sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    selected_editable_sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    active_nla_track: 'NlaTrack' = None
    ''' 

    :type: 'NlaTrack'
    '''

    active_nla_strip: 'NlaStrip' = None
    ''' 

    :type: 'NlaStrip'
    '''

    selected_nla_strips: typing.Iterable['NlaStrip'] = None
    ''' 

    :type: typing.Iterable['NlaStrip']
    '''

    selected_movieclip_tracks: typing.Iterable['MovieTrackingTrack'] = None
    ''' 

    :type: typing.Iterable['MovieTrackingTrack']
    '''

    gpencil_data: 'GreasePencil' = None
    ''' 

    :type: 'GreasePencil'
    '''

    gpencil_data_owner: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    annotation_data: 'GreasePencil' = None
    ''' 

    :type: 'GreasePencil'
    '''

    annotation_data_owner: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    visible_gpencil_layers: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    editable_gpencil_layers: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    editable_gpencil_strokes: typing.Iterable['GPencilStroke'] = None
    ''' 

    :type: typing.Iterable['GPencilStroke']
    '''

    active_gpencil_layer: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    active_gpencil_frame: typing.List = None
    ''' 

    :type: typing.List
    '''

    active_annotation_layer: 'GPencilLayer' = None
    ''' 

    :type: 'GPencilLayer'
    '''

    active_operator: 'Operator' = None
    ''' 

    :type: 'Operator'
    '''

    active_action: 'Action' = None
    ''' 

    :type: 'Action'
    '''

    selected_visible_actions: typing.Iterable['Action'] = None
    ''' 

    :type: typing.Iterable['Action']
    '''

    selected_editable_actions: typing.Iterable['Action'] = None
    ''' 

    :type: typing.Iterable['Action']
    '''

    visible_fcurves: typing.Iterable['FCurve'] = None
    ''' 

    :type: typing.Iterable['FCurve']
    '''

    editable_fcurves: typing.Iterable['FCurve'] = None
    ''' 

    :type: typing.Iterable['FCurve']
    '''

    selected_visible_fcurves: typing.Iterable['FCurve'] = None
    ''' 

    :type: typing.Iterable['FCurve']
    '''

    selected_editable_fcurves: typing.Iterable['FCurve'] = None
    ''' 

    :type: typing.Iterable['FCurve']
    '''

    active_editable_fcurve: 'FCurve' = None
    ''' 

    :type: 'FCurve'
    '''

    selected_editable_keyframes: typing.Iterable['Keyframe'] = None
    ''' 

    :type: typing.Iterable['Keyframe']
    '''

    ui_list: 'UIList' = None
    ''' 

    :type: 'UIList'
    '''

    property: typing.Union[str, int, 'ID'] = None
    ''' Get the property associated with a hovered button. Returns a tuple of the datablock, data path to the property, and array index.

    :type: typing.Union[str, int, 'ID']
    '''

    edit_text: 'Text' = None
    ''' 

    :type: 'Text'
    '''

    def evaluated_depsgraph_get(self) -> 'Depsgraph':
        ''' Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph.

        :rtype: 'Depsgraph'
        :return: Evaluated dependency graph
        '''
        pass

    def copy(self):
        ''' 

        '''
        pass

    def path_resolve(self,
                     path: typing.Optional[str],
                     coerce: typing.Optional[bool] = True):
        ''' Returns the property from the path, raise an exception when not found.

        :param path: patch which this property resolves.
        :type path: typing.Optional[str]
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: typing.Optional[bool]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    def temp_override(self, window: typing.Optional['Window'],
                      area: typing.Optional['Area'],
                      region: typing.Optional['Region'],
                      **keywords) -> 'bpy.context':
        ''' Context manager to temporarily override members in the context. Overriding the context can be used to temporarily activate another ``window`` / ``area`` & ``region``, as well as other members such as the ``active_object`` or ``bone``. Notes: - When overriding window, area and regions: the arguments must be consistent, so any region argument that's passed in must be contained by the current area or the area passed in. The same goes for the area needing to be contained in the current window. - Temporary context overrides may be nested, when this is done, members will be added to the existing overrides. - Context members are restored outside the scope of the context-manager. The only exception to this is when the data is no longer available. In the event windowing data was removed (for example), the state of the context is left as-is. While this isn't likely to happen, explicit window operation such as closing windows or loading a new file remove the windowing data that was set before the temporary context was created. Overriding the context can be useful to set the context after loading files (which would otherwise by None). For example: This example shows how it's possible to add an object to the scene in another window.

        :param window: Window override or None.
        :type window: typing.Optional['Window']
        :param area: Area override or None.
        :type area: typing.Optional['Area']
        :param region: Region override or None.
        :type region: typing.Optional['Region']
        :param keywords:  Additional keywords override context members.
        :type keywords: typing.Optional[typing.Any]
        :rtype: 'bpy.context'
        :return: The context manager .
        '''
        pass


class CryptomatteEntry(bpy_struct):
    encoded_hash: float = None
    ''' 

    :type: float
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveMap(bpy_struct):
    ''' Curve in a curve mapping
    '''

    points: 'CurveMapPoints' = None
    ''' 

    :type: 'CurveMapPoints'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveMapPoint(bpy_struct):
    ''' Point of a curve used for a curve mapping
    '''

    handle_type: typing.Union[str, int] = None
    ''' Curve interpolation at this point: Bezier or vector

    :type: typing.Union[str, int]
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float], 'mathutils.Vector'] = None
    ''' X/Y coordinates of the curve point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' Selection state of the curve point

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveMapping(bpy_struct):
    ''' Curve mapping to map color, vector and scalar values to other values using a user defined curve
    '''

    black_level: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' For RGB curves, the color that black is mapped to

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    clip_max_x: float = None
    ''' 

    :type: float
    '''

    clip_max_y: float = None
    ''' 

    :type: float
    '''

    clip_min_x: float = None
    ''' 

    :type: float
    '''

    clip_min_y: float = None
    ''' 

    :type: float
    '''

    curves: bpy_prop_collection['CurveMap'] = None
    ''' 

    :type: bpy_prop_collection['CurveMap']
    '''

    extend: typing.Union[str, int] = None
    ''' Extrapolate the curve or extend it horizontally

    :type: typing.Union[str, int]
    '''

    tone: typing.Union[str, int] = None
    ''' Tone of the curve

    :type: typing.Union[str, int]
    '''

    use_clip: bool = None
    ''' Force the curve view to fit a defined boundary

    :type: bool
    '''

    white_level: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' For RGB curves, the color that white is mapped to

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    def update(self):
        ''' Update curve mapping after making changes

        '''
        pass

    def reset_view(self):
        ''' Reset the curve mapping grid to its clipping size

        '''
        pass

    def initialize(self):
        ''' Initialize curve

        '''
        pass

    def evaluate(self, curve: 'CurveMap',
                 position: typing.Optional[float]) -> float:
        ''' Evaluate curve at given location

        :param curve: curve, Curve to evaluate
        :type curve: 'CurveMap'
        :param position: Position, Position to evaluate curve at
        :type position: typing.Optional[float]
        :rtype: float
        :return: Value, Value of curve at given location
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurvePaintSettings(bpy_struct):
    corner_angle: float = None
    ''' Angles above this are considered corners

    :type: float
    '''

    curve_type: typing.Union[str, int] = None
    ''' Type of curve to use for new strokes

    :type: typing.Union[str, int]
    '''

    depth_mode: typing.Union[str, int] = None
    ''' Method of projecting depth

    :type: typing.Union[str, int]
    '''

    error_threshold: int = None
    ''' Allow deviation for a smoother, less precise line

    :type: int
    '''

    fit_method: typing.Union[str, int] = None
    ''' Curve fitting method

    :type: typing.Union[str, int]
    '''

    radius_max: float = None
    ''' Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    '''

    radius_min: float = None
    ''' Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    '''

    radius_taper_end: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    radius_taper_start: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    surface_offset: float = None
    ''' Offset the stroke from the surface

    :type: float
    '''

    surface_plane: typing.Union[str, int] = None
    ''' Plane for projected stroke * ``NORMAL_VIEW`` Normal to Surface -- Draw in a plane perpendicular to the surface. * ``NORMAL_SURFACE`` Tangent to Surface -- Draw in the surface plane. * ``VIEW`` View -- Draw in a plane aligned to the viewport.

    :type: typing.Union[str, int]
    '''

    use_corners_detect: bool = None
    ''' Detect corners and use non-aligned handles

    :type: bool
    '''

    use_offset_absolute: bool = None
    ''' Apply a fixed offset (don't scale by the radius)

    :type: bool
    '''

    use_pressure_radius: bool = None
    ''' Map tablet pressure to curve radius

    :type: bool
    '''

    use_stroke_endpoints: bool = None
    ''' Use the start of the stroke for the depth

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurvePoint(bpy_struct):
    ''' Curve control point
    '''

    index: int = None
    ''' Index of this point

    :type: int
    '''

    position: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    radius: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveProfile(bpy_struct):
    ''' Profile Path editor used to build a profile path
    '''

    points: 'CurveProfilePoints' = None
    ''' Profile control points

    :type: 'CurveProfilePoints'
    '''

    preset: typing.Union[str, int] = None
    ''' * ``LINE`` Line -- Default. * ``SUPPORTS`` Support Loops -- Loops on each side of the profile. * ``CORNICE`` Cornice Molding. * ``CROWN`` Crown Molding. * ``STEPS`` Steps -- A number of steps defined by the segments.

    :type: typing.Union[str, int]
    '''

    segments: bpy_prop_collection['CurveProfilePoint'] = None
    ''' Segments sampled from control points

    :type: bpy_prop_collection['CurveProfilePoint']
    '''

    use_clip: bool = None
    ''' Force the path view to fit a defined boundary

    :type: bool
    '''

    use_sample_even_lengths: bool = None
    ''' Sample edges with even lengths

    :type: bool
    '''

    use_sample_straight_edges: bool = None
    ''' Sample edges with vector handles

    :type: bool
    '''

    def update(self):
        ''' Refresh internal data, remove doubles and clip points

        '''
        pass

    def reset_view(self):
        ''' Reset the curve profile grid to its clipping size

        '''
        pass

    def initialize(self, totsegments: typing.Any):
        ''' Set the number of display segments and fill tables

        :param totsegments: The number of segment values to initialize the segments table with
        :type totsegments: typing.Any
        '''
        pass

    def evaluate(self, length_portion: typing.Optional[float]
                 ) -> typing.Union[typing.List[float], typing.
                                   Tuple[float, float], 'mathutils.Vector']:
        ''' Evaluate the at the given portion of the path length

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation
        :type length_portion: typing.Optional[float]
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
        :return: Location, The location at the given portion of the profile
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveProfilePoint(bpy_struct):
    ''' Point of a path used to define a profile
    '''

    handle_type_1: typing.Union[str, int] = None
    ''' Path interpolation at this point

    :type: typing.Union[str, int]
    '''

    handle_type_2: typing.Union[str, int] = None
    ''' Path interpolation at this point

    :type: typing.Union[str, int]
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float], 'mathutils.Vector'] = None
    ''' X/Y coordinates of the path point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' Selection state of the path point

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class CurveSlice(bpy_struct):
    ''' A single curve from a curves data-block
    '''

    first_point_index: int = None
    ''' The index of this curve's first control point

    :type: int
    '''

    index: int = None
    ''' Index of this curve

    :type: int
    '''

    points: bpy_prop_collection['CurvePoint'] = None
    ''' Control points of the curve

    :type: bpy_prop_collection['CurvePoint']
    '''

    points_length: int = None
    ''' Number of control points in the curve

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DashGpencilModifierSegment(bpy_struct):
    ''' Configuration for a single dash segment
    '''

    dash: int = None
    ''' The number of consecutive points from the original stroke to include in this segment

    :type: int
    '''

    gap: int = None
    ''' The number of points skipped after this segment

    :type: int
    '''

    material_index: int = None
    ''' Use this index on generated segment. -1 means using the existing material

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the dash segment

    :type: typing.Union[str, typing.Any]
    '''

    opacity: float = None
    ''' The factor to apply to the original point's opacity for the new points

    :type: float
    '''

    radius: float = None
    ''' The factor to apply to the original point's radius for the new points

    :type: float
    '''

    use_cyclic: bool = None
    ''' Enable cyclic on individual stroke dashes

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Depsgraph(bpy_struct):
    ids: bpy_prop_collection['ID'] = None
    ''' All evaluated data-blocks

    :type: bpy_prop_collection['ID']
    '''

    mode: typing.Union[str, int] = None
    ''' Evaluation mode * ``VIEWPORT`` Viewport -- Viewport non-rendered mode. * ``RENDER`` Render -- Render.

    :type: typing.Union[str, int]
    '''

    object_instances: bpy_prop_collection['DepsgraphObjectInstance'] = None
    ''' All object instances to display or render (Warning: Only use this as an iterator, never as a sequence, and do not keep any references to its items)

    :type: bpy_prop_collection['DepsgraphObjectInstance']
    '''

    objects: bpy_prop_collection['Object'] = None
    ''' Evaluated objects in the dependency graph

    :type: bpy_prop_collection['Object']
    '''

    scene: 'Scene' = None
    ''' Original scene dependency graph is built for

    :type: 'Scene'
    '''

    scene_eval: 'Scene' = None
    ''' Scene at its evaluated state

    :type: 'Scene'
    '''

    updates: bpy_prop_collection['DepsgraphUpdate'] = None
    ''' Updates to data-blocks

    :type: bpy_prop_collection['DepsgraphUpdate']
    '''

    view_layer: 'ViewLayer' = None
    ''' Original view layer dependency graph is built for

    :type: 'ViewLayer'
    '''

    view_layer_eval: 'ViewLayer' = None
    ''' View layer at its evaluated state

    :type: 'ViewLayer'
    '''

    def debug_relations_graphviz(self,
                                 filepath: typing.Union[str, typing.Any]):
        ''' debug_relations_graphviz

        :param filepath: File Name, Output path for the graphviz debug file
        :type filepath: typing.Union[str, typing.Any]
        '''
        pass

    def debug_stats_gnuplot(self, filepath: typing.Union[str, typing.Any],
                            output_filepath: typing.Union[str, typing.Any]):
        ''' debug_stats_gnuplot

        :param filepath: File Name, Output path for the gnuplot debug file
        :type filepath: typing.Union[str, typing.Any]
        :param output_filepath: Output File Name, File name where gnuplot script will save the result
        :type output_filepath: typing.Union[str, typing.Any]
        '''
        pass

    def debug_tag_update(self):
        ''' debug_tag_update

        '''
        pass

    def debug_stats(self) -> typing.Union[str, typing.Any]:
        ''' Report the number of elements in the Dependency Graph

        :rtype: typing.Union[str, typing.Any]
        :return: result
        '''
        pass

    def update(self):
        ''' Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph.

        '''
        pass

    def id_eval_get(self, id: typing.Optional['ID']) -> 'ID':
        ''' id_eval_get

        :param id: Original ID to get evaluated complementary part for
        :type id: typing.Optional['ID']
        :rtype: 'ID'
        :return: Evaluated ID for the given original one
        '''
        pass

    def id_type_updated(
            self, id_type: typing.Optional[typing.Union[str, int]]) -> bool:
        ''' id_type_updated

        :param id_type: ID Type
        :type id_type: typing.Optional[typing.Union[str, int]]
        :rtype: bool
        :return: Updated, True if any datablock with this type was added, updated or removed
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DepsgraphObjectInstance(bpy_struct):
    ''' Extended information about dependency graph object iterator (Warning: All data here is 'evaluated' one, not original .blend IDs)
    '''

    instance_object: 'Object' = None
    ''' Evaluated object which is being instanced by this iterator

    :type: 'Object'
    '''

    is_instance: typing.Union[bool, typing.Any] = None
    ''' Denotes if the object is generated by another object

    :type: typing.Union[bool, typing.Any]
    '''

    matrix_world: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Generated transform matrix in world space

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    object: 'Object' = None
    ''' Evaluated object the iterator points to

    :type: 'Object'
    '''

    orco: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Generated coordinates in parent object space

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    parent: 'Object' = None
    ''' If the object is an instance, the parent object that generated it

    :type: 'Object'
    '''

    particle_system: 'ParticleSystem' = None
    ''' Evaluated particle system that this object was instanced from

    :type: 'ParticleSystem'
    '''

    persistent_id: bpy_prop_array[int] = None
    ''' Persistent identifier for inter-frame matching of objects with motion blur

    :type: bpy_prop_array[int]
    '''

    random_id: int = None
    ''' Random id for this instance, typically for randomized shading

    :type: int
    '''

    show_particles: typing.Union[bool, typing.Any] = None
    ''' Particles part of the object should be visible in the render

    :type: typing.Union[bool, typing.Any]
    '''

    show_self: typing.Union[bool, typing.Any] = None
    ''' The object geometry itself should be visible in the render

    :type: typing.Union[bool, typing.Any]
    '''

    uv: bpy_prop_array[float] = None
    ''' UV coordinates in parent object space

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DepsgraphUpdate(bpy_struct):
    ''' Information about ID that was updated
    '''

    id: 'ID' = None
    ''' Updated data-block

    :type: 'ID'
    '''

    is_updated_geometry: typing.Union[bool, typing.Any] = None
    ''' Object geometry is updated

    :type: typing.Union[bool, typing.Any]
    '''

    is_updated_shading: typing.Union[bool, typing.Any] = None
    ''' Object shading is updated

    :type: typing.Union[bool, typing.Any]
    '''

    is_updated_transform: typing.Union[bool, typing.Any] = None
    ''' Object transformation is updated

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DisplaySafeAreas(bpy_struct):
    ''' Safe areas used in 3D view and the sequencer
    '''

    action: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' Safe area for general elements

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    action_center: typing.Union[typing.List[float], typing.
                                Tuple[float, float], 'mathutils.Vector'] = None
    ''' Safe area for general elements in a different aspect ratio

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    title: typing.Union[typing.List[float], typing.
                        Tuple[float, float], 'mathutils.Vector'] = None
    ''' Safe area for text and graphics

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    title_center: typing.Union[typing.List[float], typing.
                               Tuple[float, float], 'mathutils.Vector'] = None
    ''' Safe area for text and graphics in a different aspect ratio

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DopeSheet(bpy_struct):
    ''' Settings for filtering the channels shown in animation editors
    '''

    filter_collection: 'Collection' = None
    ''' Collection that included object should be a member of

    :type: 'Collection'
    '''

    filter_fcurve_name: typing.Union[str, typing.Any] = None
    ''' F-Curve live filtering string

    :type: typing.Union[str, typing.Any]
    '''

    filter_text: typing.Union[str, typing.Any] = None
    ''' Live filtering string

    :type: typing.Union[str, typing.Any]
    '''

    show_armatures: bool = None
    ''' Include visualization of armature related animation data

    :type: bool
    '''

    show_cache_files: bool = None
    ''' Include visualization of cache file related animation data

    :type: bool
    '''

    show_cameras: bool = None
    ''' Include visualization of camera related animation data

    :type: bool
    '''

    show_curves: bool = None
    ''' Include visualization of curve related animation data

    :type: bool
    '''

    show_datablock_filters: bool = None
    ''' Show options for whether channels related to certain types of data are included

    :type: bool
    '''

    show_expanded_summary: bool = None
    ''' Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    '''

    show_gpencil: bool = None
    ''' Include visualization of Grease Pencil related animation data and frames

    :type: bool
    '''

    show_hair_curves: bool = None
    ''' Include visualization of hair related animation data

    :type: bool
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that are not visible

    :type: bool
    '''

    show_lattices: bool = None
    ''' Include visualization of lattice related animation data

    :type: bool
    '''

    show_lights: bool = None
    ''' Include visualization of light related animation data

    :type: bool
    '''

    show_linestyles: bool = None
    ''' Include visualization of Line Style related Animation data

    :type: bool
    '''

    show_materials: bool = None
    ''' Include visualization of material related animation data

    :type: bool
    '''

    show_meshes: bool = None
    ''' Include visualization of mesh related animation data

    :type: bool
    '''

    show_metaballs: bool = None
    ''' Include visualization of metaball related animation data

    :type: bool
    '''

    show_missing_nla: bool = None
    ''' Include animation data-blocks with no NLA data (NLA editor only)

    :type: bool
    '''

    show_modifiers: bool = None
    ''' Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    '''

    show_movieclips: bool = None
    ''' Include visualization of movie clip related animation data

    :type: bool
    '''

    show_nodes: bool = None
    ''' Include visualization of node related animation data

    :type: bool
    '''

    show_only_errors: bool = None
    ''' Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    show_particles: bool = None
    ''' Include visualization of particle related animation data

    :type: bool
    '''

    show_pointclouds: bool = None
    ''' Include visualization of point cloud related animation data

    :type: bool
    '''

    show_scenes: bool = None
    ''' Include visualization of scene related animation data

    :type: bool
    '''

    show_shapekeys: bool = None
    ''' Include visualization of shape key related animation data

    :type: bool
    '''

    show_speakers: bool = None
    ''' Include visualization of speaker related animation data

    :type: bool
    '''

    show_summary: bool = None
    ''' Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    '''

    show_textures: bool = None
    ''' Include visualization of texture related animation data

    :type: bool
    '''

    show_transforms: bool = None
    ''' Include visualization of object-level animation data (mostly transforms)

    :type: bool
    '''

    show_volumes: bool = None
    ''' Include visualization of volume related animation data

    :type: bool
    '''

    show_worlds: bool = None
    ''' Include visualization of world related animation data

    :type: bool
    '''

    source: 'ID' = None
    ''' ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: 'ID'
    '''

    use_datablock_sort: bool = None
    ''' Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    '''

    use_filter_invert: bool = None
    ''' Invert filter search

    :type: bool
    '''

    use_multi_word_filter: bool = None
    ''' Perform fuzzy/multi-word matching. Warning: May be slow

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Driver(bpy_struct):
    ''' Driver for the value of a setting based on an external value
    '''

    expression: typing.Union[str, typing.Any] = None
    ''' Expression to use for Scripted Expression

    :type: typing.Union[str, typing.Any]
    '''

    is_simple_expression: typing.Union[bool, typing.Any] = None
    ''' The scripted expression can be evaluated without using the full Python interpreter

    :type: typing.Union[bool, typing.Any]
    '''

    is_valid: bool = None
    ''' Driver could not be evaluated in past, so should be skipped

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Driver type

    :type: typing.Union[str, int]
    '''

    use_self: bool = None
    ''' Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    '''

    variables: 'ChannelDriverVariables' = None
    ''' Properties acting as inputs for this driver

    :type: 'ChannelDriverVariables'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DriverTarget(bpy_struct):
    ''' Source of input values for driver variables
    '''

    bone_target: typing.Union[str, typing.Any] = None
    ''' Name of PoseBone to use as target

    :type: typing.Union[str, typing.Any]
    '''

    context_property: typing.Union[str, int] = None
    ''' Type of a context-dependent data-block to access property from * ``ACTIVE_SCENE`` Active Scene -- Currently evaluating scene. * ``ACTIVE_VIEW_LAYER`` Active View Layer -- Currently evaluating view layer.

    :type: typing.Union[str, int]
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' RNA Path (from ID-block) to property used

    :type: typing.Union[str, typing.Any]
    '''

    id: 'ID' = None
    ''' ID-block that the specific property used can be found from (id_type property must be set first)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' Mode for calculating rotation channel values

    :type: typing.Union[str, int]
    '''

    transform_space: typing.Union[str, int] = None
    ''' Space in which transforms are used * ``WORLD_SPACE`` World Space -- Transforms include effects of parenting/restpose and constraints. * ``TRANSFORM_SPACE`` Transform Space -- Transforms don't include parenting/restpose or constraints. * ``LOCAL_SPACE`` Local Space -- Transforms include effects of constraints but not parenting/restpose.

    :type: typing.Union[str, int]
    '''

    transform_type: typing.Union[str, int] = None
    ''' Driver variable type

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DriverVariable(bpy_struct):
    ''' Variable from some source/target for driver relationship
    '''

    is_name_valid: typing.Union[bool, typing.Any] = None
    ''' Is this a valid name for a driver variable

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: typing.Union[str, typing.Any]
    '''

    targets: bpy_prop_collection['DriverTarget'] = None
    ''' Sources of input data for evaluating this variable

    :type: bpy_prop_collection['DriverTarget']
    '''

    type: typing.Union[str, int] = None
    ''' Driver variable type * ``SINGLE_PROP`` Single Property -- Use the value from some RNA property. * ``TRANSFORMS`` Transform Channel -- Final transformation value of object or bone. * ``ROTATION_DIFF`` Rotational Difference -- Use the angle between two bones. * ``LOC_DIFF`` Distance -- Distance between two bones or objects. * ``CONTEXT_PROP`` Context Property -- Use the value from some RNA property within the current evaluation context.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintBrushSettings(bpy_struct):
    ''' Brush settings
    '''

    invert_proximity: bool = None
    ''' Proximity falloff is applied inside the volume

    :type: bool
    '''

    paint_alpha: float = None
    ''' Paint alpha

    :type: float
    '''

    paint_color: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Color of the paint

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    paint_distance: float = None
    ''' Maximum distance from brush to mesh surface to affect paint

    :type: float
    '''

    paint_ramp: 'ColorRamp' = None
    ''' Color ramp used to define proximity falloff

    :type: 'ColorRamp'
    '''

    paint_source: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    paint_wetness: float = None
    ''' Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' The particle system to paint with

    :type: 'ParticleSystem'
    '''

    proximity_falloff: typing.Union[str, int] = None
    ''' Proximity falloff type

    :type: typing.Union[str, int]
    '''

    ray_direction: typing.Union[str, int] = None
    ''' Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[str, int]
    '''

    smooth_radius: float = None
    ''' Smooth falloff added after solid radius

    :type: float
    '''

    smudge_strength: float = None
    ''' Smudge effect strength

    :type: float
    '''

    solid_radius: float = None
    ''' Radius that will be painted solid

    :type: float
    '''

    use_absolute_alpha: bool = None
    ''' Only increase alpha value if paint alpha is higher than existing

    :type: bool
    '''

    use_negative_volume: bool = None
    ''' Negate influence inside the volume

    :type: bool
    '''

    use_paint_erase: bool = None
    ''' Erase / remove paint instead of adding it

    :type: bool
    '''

    use_particle_radius: bool = None
    ''' Use radius from particle settings

    :type: bool
    '''

    use_proximity_project: bool = None
    ''' Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    '''

    use_proximity_ramp_alpha: bool = None
    ''' Only read color ramp alpha

    :type: bool
    '''

    use_smudge: bool = None
    ''' Make this brush to smudge existing paint as it moves

    :type: bool
    '''

    use_velocity_alpha: bool = None
    ''' Multiply brush influence by velocity color ramp alpha

    :type: bool
    '''

    use_velocity_color: bool = None
    ''' Replace brush color by velocity color ramp

    :type: bool
    '''

    use_velocity_depth: bool = None
    ''' Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    '''

    velocity_max: float = None
    ''' Velocity considered as maximum influence (Blender units per frame)

    :type: float
    '''

    velocity_ramp: 'ColorRamp' = None
    ''' Color ramp used to define brush velocity effect

    :type: 'ColorRamp'
    '''

    wave_clamp: float = None
    ''' Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    '''

    wave_factor: float = None
    ''' Multiplier for wave influence of this brush

    :type: float
    '''

    wave_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintCanvasSettings(bpy_struct):
    ''' Dynamic Paint canvas settings
    '''

    canvas_surfaces: 'DynamicPaintSurfaces' = None
    ''' Paint surface list

    :type: 'DynamicPaintSurfaces'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class DynamicPaintSurface(bpy_struct):
    ''' A canvas surface layer
    '''

    brush_collection: 'Collection' = None
    ''' Only use brush objects from this collection

    :type: 'Collection'
    '''

    brush_influence_scale: float = None
    ''' Adjust influence brush objects have on this surface

    :type: float
    '''

    brush_radius_scale: float = None
    ''' Adjust radius of proximity brushes or particles for this surface

    :type: float
    '''

    color_dry_threshold: float = None
    ''' The wetness level when colors start to shift to the background

    :type: float
    '''

    color_spread_speed: float = None
    ''' How fast colors get mixed within wet paint

    :type: float
    '''

    depth_clamp: float = None
    ''' Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    '''

    displace_factor: float = None
    ''' Strength of displace when applied to the mesh

    :type: float
    '''

    displace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    dissolve_speed: int = None
    ''' Approximately in how many frames should dissolve happen

    :type: int
    '''

    drip_acceleration: float = None
    ''' How much surface acceleration affects dripping

    :type: float
    '''

    drip_velocity: float = None
    ''' How much surface velocity affects dripping

    :type: float
    '''

    dry_speed: int = None
    ''' Approximately in how many frames should drying happen

    :type: int
    '''

    effect_ui: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    frame_end: int = None
    ''' Simulation end frame

    :type: int
    '''

    frame_start: int = None
    ''' Simulation start frame

    :type: int
    '''

    frame_substeps: int = None
    ''' Do extra frames between scene frames to ensure smooth motion

    :type: int
    '''

    image_fileformat: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    image_output_path: typing.Union[str, typing.Any] = None
    ''' Directory to save the textures

    :type: typing.Union[str, typing.Any]
    '''

    image_resolution: int = None
    ''' Output image resolution

    :type: int
    '''

    init_color: bpy_prop_array[float] = None
    ''' Initial color of the surface

    :type: bpy_prop_array[float]
    '''

    init_color_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    init_layername: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    init_texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    is_active: bool = None
    ''' Toggle whether surface is processed or ignored

    :type: bool
    '''

    is_cache_user: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Surface name

    :type: typing.Union[str, typing.Any]
    '''

    output_name_a: typing.Union[str, typing.Any] = None
    ''' Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    '''

    output_name_b: typing.Union[str, typing.Any] = None
    ''' Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    shrink_speed: float = None
    ''' How fast shrink effect moves on the canvas surface

    :type: float
    '''

    spread_speed: float = None
    ''' How fast spread effect moves on the canvas surface

    :type: float
    '''

    surface_format: typing.Union[str, int] = None
    ''' Surface Format

    :type: typing.Union[str, int]
    '''

    surface_type: typing.Union[str, int] = None
    ''' Surface Type

    :type: typing.Union[str, int]
    '''

    use_antialiasing: bool = None
    ''' Use 5× multisampling to smooth paint edges

    :type: bool
    '''

    use_dissolve: bool = None
    ''' Enable to make surface changes disappear over time

    :type: bool
    '''

    use_dissolve_log: bool = None
    ''' Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    '''

    use_drip: bool = None
    ''' Process drip effect (drip wet paint to gravity direction)

    :type: bool
    '''

    use_dry_log: bool = None
    ''' Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    '''

    use_drying: bool = None
    ''' Enable to make surface wetness dry over time

    :type: bool
    '''

    use_incremental_displace: bool = None
    ''' New displace is added cumulatively on top of existing

    :type: bool
    '''

    use_output_a: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_output_b: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_premultiply: bool = None
    ''' Multiply color by alpha (recommended for Blender input)

    :type: bool
    '''

    use_shrink: bool = None
    ''' Process shrink effect (shrink paint areas)

    :type: bool
    '''

    use_spread: bool = None
    ''' Process spread effect (spread wet paint around surface)

    :type: bool
    '''

    use_wave_open_border: bool = None
    ''' Pass waves through mesh edges

    :type: bool
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' UV map name

    :type: typing.Union[str, typing.Any]
    '''

    wave_damping: float = None
    ''' Wave damping factor

    :type: float
    '''

    wave_smoothness: float = None
    ''' Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    '''

    wave_speed: float = None
    ''' Wave propagation speed

    :type: float
    '''

    wave_spring: float = None
    ''' Spring force that pulls water level back to zero

    :type: float
    '''

    wave_timescale: float = None
    ''' Wave time scaling factor

    :type: float
    '''

    def output_exists(self, object: 'Object',
                      index: typing.Optional[int]) -> bool:
        ''' Checks if surface output layer of given name exists

        :param object: 
        :type object: 'Object'
        :param index: Index
        :type index: typing.Optional[int]
        :rtype: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class EQCurveMappingData(bpy_struct):
    ''' EQCurveMappingData
    '''

    curve_mapping: 'CurveMapping' = None
    ''' 

    :type: 'CurveMapping'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class EditBone(bpy_struct):
    ''' Edit mode bone in an armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveinz: float = None
    ''' Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutz: float = None
    ''' Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'EditBone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'EditBone'
    '''

    bbone_custom_handle_start: 'EditBone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'EditBone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    ''' Selects how the end handle of the B-Bone is computed * ``AUTO`` Automatic -- Use connected parent and children to compute the handle. * ``ABSOLUTE`` Absolute -- Use the position of the specified bone to compute the handle. * ``RELATIVE`` Relative -- Use the offset of the specified bone from rest pose to compute the handle. * ``TANGENT`` Tangent -- Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    ''' Selects how the start handle of the B-Bone is computed * ``AUTO`` Automatic -- Use connected parent and children to compute the handle. * ``ABSOLUTE`` Absolute -- Use the position of the specified bone to compute the handle. * ``RELATIVE`` Relative -- Use the offset of the specified bone from rest pose to compute the handle. * ``TANGENT`` Tangent -- Use the orientation of the specified bone to compute the handle, ignoring the location.

    :type: typing.Union[str, int]
    '''

    bbone_handle_use_ease_end: bool = None
    ''' Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    '''

    bbone_handle_use_ease_start: bool = None
    ''' Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    '''

    bbone_handle_use_scale_end: typing.List[bool] = None
    ''' Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    '''

    bbone_handle_use_scale_start: typing.List[bool] = None
    ''' Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    '''

    bbone_mapping_mode: typing.Union[str, int] = None
    ''' Selects how the vertices are mapped to B-Bone segments based on their position * ``STRAIGHT`` Straight -- Fast mapping that is good for most situations, but ignores the rest pose curvature of the B-Bone. * ``CURVED`` Curved -- Slower mapping that gives better deformation for B-Bones that are sharply curved in rest pose.

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bbone_scaleout: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Vector'] = None
    ''' Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    collections: bpy_prop_collection['BoneCollection'] = None
    ''' Bone Collections that contain this bone

    :type: bpy_prop_collection['BoneCollection']
    '''

    color: 'BoneColor' = None
    ''' 

    :type: 'BoneColor'
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of head end of the bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when in Edit Mode

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    ''' Specifies how the bone inherits scaling from the parent bone * ``FULL`` Full -- Inherit all effects of parent scaling. * ``FIX_SHEAR`` Fix Shear -- Inherit scaling, but remove shearing of the child in the rest orientation. * ``ALIGNED`` Aligned -- Rotate non-uniform parent scaling to align with the child, applying parent X scale to child X axis, and so forth. * ``AVERAGE`` Average -- Inherit uniform scaling representing the overall change in the volume of the parent. * ``NONE`` None -- Completely ignore parent scaling. * ``NONE_LEGACY`` None (Legacy) -- Ignore parent scaling without compensating for parent shear. Replicates the effect of disabling the original Inherit Scale checkbox.

    :type: typing.Union[str, int]
    '''

    length: float = None
    ''' Length of the bone. Changing moves the tail end

    :type: float
    '''

    lock: bool = None
    ''' Bone is not able to be transformed when in Edit Mode

    :type: bool
    '''

    matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Matrix combining location and rotation of the bone (head position, direction and roll), in armature space (does not include/support bone's length/size)

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'EditBone' = None
    ''' Parent edit bone (in same Armature)

    :type: 'EditBone'
    '''

    roll: float = None
    ''' Bone rotation around head-tail axis

    :type: float
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of tail end of the bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: bool = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    use_scale_easing: bool = None
    ''' Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' A list of all the bones children. .. note:: Takes ``O(len(bones))`` time. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes ``O(len(bones)**2)`` time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def align_roll(self, vector: typing.Optional[
            typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector']]):
        ''' Align the bone to a local-space roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        '''
        pass

    def align_orientation(self, other):
        ''' Align this bone to another by moving its tail and settings its roll the length of the other bone is not used.

        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def transform(
            self,
            matrix: typing.Optional[
                typing.Union[typing.Sequence[float], 'mathutils.Matrix']],
            *,
            scale: typing.Optional[bool] = True,
            roll: typing.Optional[bool] = True):
        ''' Transform the the bones head, tail, roll and envelope (when the matrix has a scale component).

        :param matrix: 3x3 or 4x4 transformation matrix.
        :type matrix: typing.Optional[typing.Union[typing.Sequence[float], 'mathutils.Matrix']]
        :param scale: Scale the bone envelope by the matrix.
        :type scale: typing.Optional[bool]
        :param roll: Correct the roll to point in the same relative direction to the head and tail.
        :type roll: typing.Optional[bool]
        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class EffectorWeights(bpy_struct):
    ''' Effector weights for physics simulation
    '''

    all: float = None
    ''' All effector's weight

    :type: float
    '''

    apply_to_hair_growing: bool = None
    ''' Use force fields when growing hair

    :type: bool
    '''

    boid: float = None
    ''' Boid effector weight

    :type: float
    '''

    charge: float = None
    ''' Charge effector weight

    :type: float
    '''

    collection: 'Collection' = None
    ''' Limit effectors to this collection

    :type: 'Collection'
    '''

    curve_guide: float = None
    ''' Curve guide effector weight

    :type: float
    '''

    drag: float = None
    ''' Drag effector weight

    :type: float
    '''

    force: float = None
    ''' Force effector weight

    :type: float
    '''

    gravity: float = None
    ''' Global gravity weight

    :type: float
    '''

    harmonic: float = None
    ''' Harmonic effector weight

    :type: float
    '''

    lennardjones: float = None
    ''' Lennard-Jones effector weight

    :type: float
    '''

    magnetic: float = None
    ''' Magnetic effector weight

    :type: float
    '''

    smokeflow: float = None
    ''' Fluid Flow effector weight

    :type: float
    '''

    texture: float = None
    ''' Texture effector weight

    :type: float
    '''

    turbulence: float = None
    ''' Turbulence effector weight

    :type: float
    '''

    vortex: float = None
    ''' Vortex effector weight

    :type: float
    '''

    wind: float = None
    ''' Wind effector weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class EnumPropertyItem(bpy_struct):
    ''' Definition of a choice in an RNA enum property
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the item's purpose

    :type: typing.Union[str, typing.Any]
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    value: int = None
    ''' Value of the item

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Event(bpy_struct):
    ''' Window Manager Event
    '''

    alt: typing.Union[bool, typing.Any] = None
    ''' True when the Alt/Option key is held

    :type: typing.Union[bool, typing.Any]
    '''

    ascii: typing.Union[str, typing.Any] = None
    ''' Single ASCII character for this event

    :type: typing.Union[str, typing.Any]
    '''

    ctrl: typing.Union[bool, typing.Any] = None
    ''' True when the Ctrl key is held

    :type: typing.Union[bool, typing.Any]
    '''

    direction: typing.Union[str, int] = None
    ''' The direction (only applies to drag events)

    :type: typing.Union[str, int]
    '''

    is_consecutive: typing.Union[bool, typing.Any] = None
    ''' Part of a track-pad or NDOF motion, interrupted by cursor motion, button or key press events

    :type: typing.Union[bool, typing.Any]
    '''

    is_mouse_absolute: typing.Union[bool, typing.Any] = None
    ''' The last motion event was an absolute input

    :type: typing.Union[bool, typing.Any]
    '''

    is_repeat: typing.Union[bool, typing.Any] = None
    ''' The event is generated by holding a key down

    :type: typing.Union[bool, typing.Any]
    '''

    is_tablet: typing.Union[bool, typing.Any] = None
    ''' The event has tablet data

    :type: typing.Union[bool, typing.Any]
    '''

    mouse_prev_press_x: int = None
    ''' The window relative horizontal location of the last press event

    :type: int
    '''

    mouse_prev_press_y: int = None
    ''' The window relative vertical location of the last press event

    :type: int
    '''

    mouse_prev_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_prev_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    mouse_region_x: int = None
    ''' The region relative horizontal location of the mouse

    :type: int
    '''

    mouse_region_y: int = None
    ''' The region relative vertical location of the mouse

    :type: int
    '''

    mouse_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    oskey: typing.Union[bool, typing.Any] = None
    ''' True when the Cmd key is held

    :type: typing.Union[bool, typing.Any]
    '''

    pressure: float = None
    ''' The pressure of the tablet or 1.0 if no tablet present

    :type: float
    '''

    shift: typing.Union[bool, typing.Any] = None
    ''' True when the Shift key is held

    :type: typing.Union[bool, typing.Any]
    '''

    tilt: typing.Union[typing.List[float], typing.
                       Tuple[float, float], 'mathutils.Vector'] = None
    ''' The pressure of the tablet or zeroes if no tablet present

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    type_prev: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    unicode: typing.Union[str, typing.Any] = None
    ''' Single unicode character for this event

    :type: typing.Union[str, typing.Any]
    '''

    value: typing.Union[str, int] = None
    ''' The type of event, only applies to some

    :type: typing.Union[str, int]
    '''

    value_prev: typing.Union[str, int] = None
    ''' The type of event, only applies to some

    :type: typing.Union[str, int]
    '''

    xr: 'XrEventData' = None
    ''' XR event data

    :type: 'XrEventData'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FCurve(bpy_struct):
    ''' F-Curve defining values of a period of time
    '''

    array_index: int = None
    ''' Index to the specific property affected by F-Curve if applicable

    :type: int
    '''

    auto_smoothing: typing.Union[str, int] = None
    ''' Algorithm used to compute automatic handles

    :type: typing.Union[str, int]
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color of the F-Curve in the Graph Editor

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    color_mode: typing.Union[str, int] = None
    ''' Method used to determine color of F-Curve in Graph Editor * ``AUTO_RAINBOW`` Auto Rainbow -- Cycle through the rainbow, trying to give each curve a unique color. * ``AUTO_RGB`` Auto XYZ to RGB -- Use axis colors for transform and color properties, and auto-rainbow for the rest. * ``AUTO_YRGB`` Auto WXYZ to YRGB -- Use axis colors for XYZ parts of transform, and yellow for the 'W' channel. * ``CUSTOM`` User Defined -- Use custom hand-picked color for F-Curve.

    :type: typing.Union[str, int]
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' RNA Path to property affected by F-Curve

    :type: typing.Union[str, typing.Any]
    '''

    driver: 'Driver' = None
    ''' Channel Driver (only set for Driver F-Curves)

    :type: 'Driver'
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Method used for evaluating value of F-Curve outside first and last keyframes * ``CONSTANT`` Constant -- Hold values of endpoint keyframes. * ``LINEAR`` Linear -- Use slope of curve leading in/out of endpoint keyframes.

    :type: typing.Union[str, int]
    '''

    group: 'ActionGroup' = None
    ''' Action Group that this F-Curve belongs to

    :type: 'ActionGroup'
    '''

    hide: bool = None
    ''' F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    '''

    is_empty: typing.Union[bool, typing.Any] = None
    ''' True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted

    :type: typing.Union[bool, typing.Any]
    '''

    is_valid: bool = None
    ''' False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    '''

    keyframe_points: 'FCurveKeyframePoints' = None
    ''' User-editable keyframes

    :type: 'FCurveKeyframePoints'
    '''

    lock: bool = None
    ''' F-Curve's settings cannot be edited

    :type: bool
    '''

    modifiers: 'FCurveModifiers' = None
    ''' Modifiers affecting the shape of the F-Curve

    :type: 'FCurveModifiers'
    '''

    mute: bool = None
    ''' Disable F-Curve evaluation

    :type: bool
    '''

    sampled_points: bpy_prop_collection['FCurveSample'] = None
    ''' Sampled animation data

    :type: bpy_prop_collection['FCurveSample']
    '''

    select: bool = None
    ''' F-Curve is selected for editing

    :type: bool
    '''

    def evaluate(self, frame: typing.Optional[float]) -> float:
        ''' Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: typing.Optional[float]
        :rtype: float
        :return: Value, Value of F-Curve specific frame
        '''
        pass

    def update(self):
        ''' Ensure keyframes are sorted in chronological order and handles are set correctly

        '''
        pass

    def range(self) -> typing.Union[typing.List[float], typing.
                                    Tuple[float, float], 'mathutils.Vector']:
        ''' Get the time extents for F-Curve

        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
        :return: Range, Min/Max values
        '''
        pass

    def update_autoflags(self, data: typing.Any):
        ''' Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: typing.Any
        '''
        pass

    def convert_to_samples(self, start: typing.Optional[int],
                           end: typing.Optional[int]):
        ''' Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        '''
        pass

    def convert_to_keyframes(self, start: typing.Optional[int],
                             end: typing.Optional[int]):
        ''' Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FCurveSample(bpy_struct):
    ''' Sample point for F-Curve
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float], 'mathutils.Vector'] = None
    ''' Point coordinates

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FFmpegSettings(bpy_struct):
    ''' FFmpeg related settings for the scene
    '''

    audio_bitrate: int = None
    ''' Audio bitrate (kb/s)

    :type: int
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * ``MONO`` Mono -- Set audio channels to mono. * ``STEREO`` Stereo -- Set audio channels to stereo. * ``SURROUND4`` 4 Channels -- Set audio channels to 4 channels. * ``SURROUND51`` 5.1 Surround -- Set audio channels to 5.1 surround sound. * ``SURROUND71`` 7.1 Surround -- Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_codec: typing.Union[str, int] = None
    ''' FFmpeg audio codec to use * ``NONE`` No Audio -- Disables audio output, for video-only renders. * ``AAC`` AAC. * ``AC3`` AC3. * ``FLAC`` FLAC. * ``MP2`` MP2. * ``MP3`` MP3. * ``OPUS`` Opus. * ``PCM`` PCM. * ``VORBIS`` Vorbis.

    :type: typing.Union[str, int]
    '''

    audio_mixrate: int = None
    ''' Audio sample rate (samples/s)

    :type: int
    '''

    audio_volume: float = None
    ''' Audio volume

    :type: float
    '''

    buffersize: int = None
    ''' Rate control: buffer size (kb)

    :type: int
    '''

    codec: typing.Union[str, int] = None
    ''' FFmpeg codec to use for video output * ``NONE`` No Video -- Disables video output, for audio-only renders. * ``DNXHD`` DNxHD. * ``DV`` DV. * ``FFV1`` FFmpeg video codec #1. * ``FLASH`` Flash Video. * ``H264`` H.264. * ``HUFFYUV`` HuffYUV. * ``MPEG1`` MPEG-1. * ``MPEG2`` MPEG-2. * ``MPEG4`` MPEG-4 (divx). * ``PNG`` PNG. * ``QTRLE`` QT rle / QT Animation. * ``THEORA`` Theora. * ``WEBM`` WebM / VP9. * ``AV1`` AV1.

    :type: typing.Union[str, int]
    '''

    constant_rate_factor: typing.Union[str, int] = None
    ''' Constant Rate Factor (CRF); tradeoff between video quality and file size * ``NONE`` Constant Bitrate -- Configure constant bit rate, rather than constant output quality. * ``LOSSLESS`` Lossless. * ``PERC_LOSSLESS`` Perceptually Lossless. * ``HIGH`` High Quality. * ``MEDIUM`` Medium Quality. * ``LOW`` Low Quality. * ``VERYLOW`` Very Low Quality. * ``LOWEST`` Lowest Quality.

    :type: typing.Union[str, int]
    '''

    ffmpeg_preset: typing.Union[str, int] = None
    ''' Tradeoff between encoding speed and compression ratio * ``BEST`` Slowest -- Recommended if you have lots of time and want the best compression efficiency. * ``GOOD`` Good -- The default and recommended for most applications. * ``REALTIME`` Realtime -- Recommended for fast encoding.

    :type: typing.Union[str, int]
    '''

    format: typing.Union[str, int] = None
    ''' Output file container

    :type: typing.Union[str, int]
    '''

    gopsize: int = None
    ''' Distance between key frames, also known as GOP size; influences file size and seekability

    :type: int
    '''

    max_b_frames: int = None
    ''' Maximum number of B-frames between non-B-frames; influences file size and seekability

    :type: int
    '''

    maxrate: int = None
    ''' Rate control: max rate (kbit/s)

    :type: int
    '''

    minrate: int = None
    ''' Rate control: min rate (kbit/s)

    :type: int
    '''

    muxrate: int = None
    ''' Mux rate (bits/second)

    :type: int
    '''

    packetsize: int = None
    ''' Mux packet size (byte)

    :type: int
    '''

    use_autosplit: bool = None
    ''' Autosplit output at 2GB boundary

    :type: bool
    '''

    use_lossless_output: bool = None
    ''' Use lossless output for video streams

    :type: bool
    '''

    use_max_b_frames: bool = None
    ''' Set a maximum number of B-frames

    :type: bool
    '''

    video_bitrate: int = None
    ''' Video bitrate (kbit/s)

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FModifier(bpy_struct):
    ''' Modifier for values of F-Curve
    '''

    active: bool = None
    ''' F-Curve modifier will show settings in the editor

    :type: bool
    '''

    blend_in: float = None
    ''' Number of frames from start frame for influence to take effect

    :type: float
    '''

    blend_out: float = None
    ''' Number of frames from end frame for influence to fade out

    :type: float
    '''

    frame_end: float = None
    ''' Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    '''

    frame_start: float = None
    ''' Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    '''

    influence: float = None
    ''' Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' F-Curve Modifier has invalid settings and will not be evaluated

    :type: typing.Union[bool, typing.Any]
    '''

    mute: bool = None
    ''' Enable F-Curve modifier evaluation

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' F-Curve Modifier name

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' F-Curve Modifier's panel is expanded in UI

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' F-Curve Modifier Type

    :type: typing.Union[str, int]
    '''

    use_influence: bool = None
    ''' F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    '''

    use_restricted_range: bool = None
    ''' F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FModifierEnvelopeControlPoint(bpy_struct):
    ''' Control point for envelope F-Modifier
    '''

    frame: float = None
    ''' Frame this control-point occurs on

    :type: float
    '''

    max: float = None
    ''' Upper bound of envelope at this control-point

    :type: float
    '''

    min: float = None
    ''' Lower bound of envelope at this control-point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FieldSettings(bpy_struct):
    ''' Field settings for an object in physics simulation
    '''

    apply_to_location: bool = None
    ''' Affect particle's location

    :type: bool
    '''

    apply_to_rotation: bool = None
    ''' Affect particle's dynamic rotation

    :type: bool
    '''

    distance_max: float = None
    ''' Maximum distance for the field to work

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance for the field's falloff

    :type: float
    '''

    falloff_power: float = None
    ''' How quickly strength falls off with distance from the force field

    :type: float
    '''

    falloff_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    flow: float = None
    ''' Convert effector force into air flow velocity

    :type: float
    '''

    guide_clump_amount: float = None
    ''' Amount of clumping

    :type: float
    '''

    guide_clump_shape: float = None
    ''' Shape of clumping

    :type: float
    '''

    guide_free: float = None
    ''' Guide-free time from particle life's end

    :type: float
    '''

    guide_kink_amplitude: float = None
    ''' The amplitude of the offset

    :type: float
    '''

    guide_kink_axis: typing.Union[str, int] = None
    ''' Which axis to use for offset

    :type: typing.Union[str, int]
    '''

    guide_kink_frequency: float = None
    ''' The frequency of the offset (1/total length)

    :type: float
    '''

    guide_kink_shape: float = None
    ''' Adjust the offset to the beginning/end

    :type: float
    '''

    guide_kink_type: typing.Union[str, int] = None
    ''' Type of periodic offset on the curve

    :type: typing.Union[str, int]
    '''

    guide_minimum: float = None
    ''' The distance from which particles are affected fully

    :type: float
    '''

    harmonic_damping: float = None
    ''' Damping of the harmonic force

    :type: float
    '''

    inflow: float = None
    ''' Inwards component of the vortex force

    :type: float
    '''

    linear_drag: float = None
    ''' Drag component proportional to velocity

    :type: float
    '''

    noise: float = None
    ''' Amount of noise for the force strength

    :type: float
    '''

    quadratic_drag: float = None
    ''' Drag component proportional to the square of velocity

    :type: float
    '''

    radial_falloff: float = None
    ''' Radial falloff power (real gravitational falloff = 2)

    :type: float
    '''

    radial_max: float = None
    ''' Maximum radial distance for the field to work

    :type: float
    '''

    radial_min: float = None
    ''' Minimum radial distance for the field's falloff

    :type: float
    '''

    rest_length: float = None
    ''' Rest length of the harmonic force

    :type: float
    '''

    seed: int = None
    ''' Seed of the noise

    :type: int
    '''

    shape: typing.Union[str, int] = None
    ''' Which direction is used to calculate the effector force * ``POINT`` Point -- Field originates from the object center. * ``LINE`` Line -- Field originates from the local Z axis of the object. * ``PLANE`` Plane -- Field originates from the local XY plane of the object. * ``SURFACE`` Surface -- Field originates from the surface of the object. * ``POINTS`` Every Point -- Field originates from all of the vertices of the object.

    :type: typing.Union[str, int]
    '''

    size: float = None
    ''' Size of the turbulence

    :type: float
    '''

    source_object: 'Object' = None
    ''' Select domain object of the smoke simulation

    :type: 'Object'
    '''

    strength: float = None
    ''' Strength of force field

    :type: float
    '''

    texture: 'Texture' = None
    ''' Texture to use as force

    :type: 'Texture'
    '''

    texture_mode: typing.Union[str, int] = None
    ''' How the texture effect is calculated (RGB and Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[str, int]
    '''

    texture_nabla: float = None
    ''' Defines size of derivative offset used for calculating gradient and curl

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of field * ``NONE`` None. * ``BOID`` Boid -- Create a force that acts as a boid's predators or target. * ``CHARGE`` Charge -- Spherical forcefield based on the charge of particles, only influences other charge force fields. * ``GUIDE`` Curve Guide -- Create a force along a curve object. * ``DRAG`` Drag -- Create a force that dampens motion. * ``FLUID_FLOW`` Fluid Flow -- Create a force based on fluid simulation velocities. * ``FORCE`` Force -- Radial field toward the center of object. * ``HARMONIC`` Harmonic -- The source of this force field is the zero point of a harmonic oscillator. * ``LENNARDJ`` Lennard-Jones -- Forcefield based on the Lennard-Jones potential. * ``MAGNET`` Magnetic -- Forcefield depends on the speed of the particles. * ``TEXTURE`` Texture -- Force field based on a texture. * ``TURBULENCE`` Turbulence -- Create turbulence with a noise field. * ``VORTEX`` Vortex -- Spiraling force that twists the force object's local Z axis. * ``WIND`` Wind -- Constant force along the force object's local Z axis.

    :type: typing.Union[str, int]
    '''

    use_2d_force: bool = None
    ''' Apply force only in 2D

    :type: bool
    '''

    use_absorption: bool = None
    ''' Force gets absorbed by collision objects

    :type: bool
    '''

    use_global_coords: bool = None
    ''' Use effector/global coordinates for turbulence

    :type: bool
    '''

    use_gravity_falloff: bool = None
    ''' Multiply force by 1/distance²

    :type: bool
    '''

    use_guide_path_add: bool = None
    ''' Based on distance/falloff it adds a portion of the entire path

    :type: bool
    '''

    use_guide_path_weight: bool = None
    ''' Use curve weights to influence the particle influence along the curve

    :type: bool
    '''

    use_max_distance: bool = None
    ''' Use a maximum distance for the field to work

    :type: bool
    '''

    use_min_distance: bool = None
    ''' Use a minimum distance for the field's falloff

    :type: bool
    '''

    use_multiple_springs: bool = None
    ''' Every point is affected by multiple springs

    :type: bool
    '''

    use_object_coords: bool = None
    ''' Use object/global coordinates for texture

    :type: bool
    '''

    use_radial_max: bool = None
    ''' Use a maximum radial distance for the field to work

    :type: bool
    '''

    use_radial_min: bool = None
    ''' Use a minimum radial distance for the field's falloff

    :type: bool
    '''

    use_root_coords: bool = None
    ''' Texture coordinates from root particle locations

    :type: bool
    '''

    use_smoke_density: bool = None
    ''' Adjust force strength based on smoke density

    :type: bool
    '''

    wind_factor: float = None
    ''' How much the force is reduced when acting parallel to a surface, e.g. cloth

    :type: float
    '''

    z_direction: typing.Union[str, int] = None
    ''' Effect in full or only positive/negative Z direction

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FileAssetSelectIDFilter(bpy_struct):
    ''' Which asset types to show/hide, when browsing an asset library
    '''

    experimental_filter_armature: bool = None
    ''' Show Armature data-blocks

    :type: bool
    '''

    experimental_filter_brush: bool = None
    ''' Show Brushes data-blocks

    :type: bool
    '''

    experimental_filter_cachefile: bool = None
    ''' Show Cache File data-blocks

    :type: bool
    '''

    experimental_filter_camera: bool = None
    ''' Show Camera data-blocks

    :type: bool
    '''

    experimental_filter_curve: bool = None
    ''' Show Curve data-blocks

    :type: bool
    '''

    experimental_filter_curves: bool = None
    ''' Show/hide Curves data-blocks

    :type: bool
    '''

    experimental_filter_font: bool = None
    ''' Show Font data-blocks

    :type: bool
    '''

    experimental_filter_grease_pencil: bool = None
    ''' Show Grease pencil data-blocks

    :type: bool
    '''

    experimental_filter_image: bool = None
    ''' Show Image data-blocks

    :type: bool
    '''

    experimental_filter_lattice: bool = None
    ''' Show Lattice data-blocks

    :type: bool
    '''

    experimental_filter_light: bool = None
    ''' Show Light data-blocks

    :type: bool
    '''

    experimental_filter_light_probe: bool = None
    ''' Show Light Probe data-blocks

    :type: bool
    '''

    experimental_filter_linestyle: bool = None
    ''' Show Freestyle's Line Style data-blocks

    :type: bool
    '''

    experimental_filter_mask: bool = None
    ''' Show Mask data-blocks

    :type: bool
    '''

    experimental_filter_mesh: bool = None
    ''' Show Mesh data-blocks

    :type: bool
    '''

    experimental_filter_metaball: bool = None
    ''' Show Metaball data-blocks

    :type: bool
    '''

    experimental_filter_movie_clip: bool = None
    ''' Show Movie Clip data-blocks

    :type: bool
    '''

    experimental_filter_paint_curve: bool = None
    ''' Show Paint Curve data-blocks

    :type: bool
    '''

    experimental_filter_palette: bool = None
    ''' Show Palette data-blocks

    :type: bool
    '''

    experimental_filter_particle_settings: bool = None
    ''' Show Particle Settings data-blocks

    :type: bool
    '''

    experimental_filter_pointcloud: bool = None
    ''' Show/hide Point Cloud data-blocks

    :type: bool
    '''

    experimental_filter_scene: bool = None
    ''' Show Scene data-blocks

    :type: bool
    '''

    experimental_filter_sound: bool = None
    ''' Show Sound data-blocks

    :type: bool
    '''

    experimental_filter_speaker: bool = None
    ''' Show Speaker data-blocks

    :type: bool
    '''

    experimental_filter_text: bool = None
    ''' Show Text data-blocks

    :type: bool
    '''

    experimental_filter_texture: bool = None
    ''' Show Texture data-blocks

    :type: bool
    '''

    experimental_filter_volume: bool = None
    ''' Show/hide Volume data-blocks

    :type: bool
    '''

    experimental_filter_work_space: bool = None
    ''' Show workspace data-blocks

    :type: bool
    '''

    filter_action: bool = None
    ''' Show Action data-blocks

    :type: bool
    '''

    filter_group: bool = None
    ''' Show Collection data-blocks

    :type: bool
    '''

    filter_material: bool = None
    ''' Show Material data-blocks

    :type: bool
    '''

    filter_node_tree: bool = None
    ''' Show Node Tree data-blocks

    :type: bool
    '''

    filter_object: bool = None
    ''' Show Object data-blocks

    :type: bool
    '''

    filter_world: bool = None
    ''' Show World data-blocks

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FileBrowserFSMenuEntry(bpy_struct):
    ''' File Select Parameters
    '''

    icon: int = None
    ''' 

    :type: int
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Whether this path is currently reachable

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    path: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    use_save: typing.Union[bool, typing.Any] = None
    ''' Whether this path is saved in bookmarks, or generated from OS

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FileSelectEntry(bpy_struct):
    ''' A file viewable in the File Browser
    '''

    asset_data: 'AssetMetaData' = None
    ''' Asset data, valid if the file represents an asset

    :type: 'AssetMetaData'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    preview_icon_id: int = None
    ''' Unique integer identifying the preview of this file as an icon (zero means invalid)

    :type: int
    '''

    relative_path: typing.Union[str, typing.Any] = None
    ''' Path relative to the directory currently displayed in the File Browser (includes the file name)

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FileSelectIDFilter(bpy_struct):
    ''' Which ID types to show/hide, when browsing a library
    '''

    category_animation: bool = None
    ''' Show animation data

    :type: bool
    '''

    category_environment: bool = None
    ''' Show worlds, lights, cameras and speakers

    :type: bool
    '''

    category_geometry: bool = None
    ''' Show meshes, curves, lattice, armatures and metaballs data

    :type: bool
    '''

    category_image: bool = None
    ''' Show images, movie clips, sounds and masks

    :type: bool
    '''

    category_misc: bool = None
    ''' Show other data types

    :type: bool
    '''

    category_object: bool = None
    ''' Show objects and collections

    :type: bool
    '''

    category_scene: bool = None
    ''' Show scenes

    :type: bool
    '''

    category_shading: bool = None
    ''' Show materials, node-trees, textures and Freestyle's line-styles

    :type: bool
    '''

    filter_action: bool = None
    ''' Show Action data-blocks

    :type: bool
    '''

    filter_armature: bool = None
    ''' Show Armature data-blocks

    :type: bool
    '''

    filter_brush: bool = None
    ''' Show Brushes data-blocks

    :type: bool
    '''

    filter_cachefile: bool = None
    ''' Show Cache File data-blocks

    :type: bool
    '''

    filter_camera: bool = None
    ''' Show Camera data-blocks

    :type: bool
    '''

    filter_curve: bool = None
    ''' Show Curve data-blocks

    :type: bool
    '''

    filter_curves: bool = None
    ''' Show/hide Curves data-blocks

    :type: bool
    '''

    filter_font: bool = None
    ''' Show Font data-blocks

    :type: bool
    '''

    filter_grease_pencil: bool = None
    ''' Show Grease pencil data-blocks

    :type: bool
    '''

    filter_group: bool = None
    ''' Show Collection data-blocks

    :type: bool
    '''

    filter_image: bool = None
    ''' Show Image data-blocks

    :type: bool
    '''

    filter_lattice: bool = None
    ''' Show Lattice data-blocks

    :type: bool
    '''

    filter_light: bool = None
    ''' Show Light data-blocks

    :type: bool
    '''

    filter_light_probe: bool = None
    ''' Show Light Probe data-blocks

    :type: bool
    '''

    filter_linestyle: bool = None
    ''' Show Freestyle's Line Style data-blocks

    :type: bool
    '''

    filter_mask: bool = None
    ''' Show Mask data-blocks

    :type: bool
    '''

    filter_material: bool = None
    ''' Show Material data-blocks

    :type: bool
    '''

    filter_mesh: bool = None
    ''' Show Mesh data-blocks

    :type: bool
    '''

    filter_metaball: bool = None
    ''' Show Metaball data-blocks

    :type: bool
    '''

    filter_movie_clip: bool = None
    ''' Show Movie Clip data-blocks

    :type: bool
    '''

    filter_node_tree: bool = None
    ''' Show Node Tree data-blocks

    :type: bool
    '''

    filter_object: bool = None
    ''' Show Object data-blocks

    :type: bool
    '''

    filter_paint_curve: bool = None
    ''' Show Paint Curve data-blocks

    :type: bool
    '''

    filter_palette: bool = None
    ''' Show Palette data-blocks

    :type: bool
    '''

    filter_particle_settings: bool = None
    ''' Show Particle Settings data-blocks

    :type: bool
    '''

    filter_pointcloud: bool = None
    ''' Show/hide Point Cloud data-blocks

    :type: bool
    '''

    filter_scene: bool = None
    ''' Show Scene data-blocks

    :type: bool
    '''

    filter_sound: bool = None
    ''' Show Sound data-blocks

    :type: bool
    '''

    filter_speaker: bool = None
    ''' Show Speaker data-blocks

    :type: bool
    '''

    filter_text: bool = None
    ''' Show Text data-blocks

    :type: bool
    '''

    filter_texture: bool = None
    ''' Show Texture data-blocks

    :type: bool
    '''

    filter_volume: bool = None
    ''' Show/hide Volume data-blocks

    :type: bool
    '''

    filter_work_space: bool = None
    ''' Show workspace data-blocks

    :type: bool
    '''

    filter_world: bool = None
    ''' Show World data-blocks

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FileSelectParams(bpy_struct):
    ''' File Select Parameters
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Directory displayed in the file browser

    :type: typing.Union[str, typing.Any]
    '''

    display_size: int = None
    ''' Change the size of thumbnails

    :type: int
    '''

    display_size_discrete: typing.Union[str, int] = None
    ''' Change the size of thumbnails in discrete steps

    :type: typing.Union[str, int]
    '''

    display_type: typing.Union[str, int] = None
    ''' Display mode for the file list * ``LIST_VERTICAL`` Vertical List -- Display files as a vertical list. * ``LIST_HORIZONTAL`` Horizontal List -- Display files as a horizontal list. * ``THUMBNAIL`` Thumbnails -- Display files as thumbnails.

    :type: typing.Union[str, int]
    '''

    filename: typing.Union[str, typing.Any] = None
    ''' Active file in the file browser

    :type: typing.Union[str, typing.Any]
    '''

    filter_glob: typing.Union[str, typing.Any] = None
    ''' UNIX shell-like filename patterns matching, supports wildcards ('*') and list of patterns separated by ';'

    :type: typing.Union[str, typing.Any]
    '''

    filter_id: 'FileSelectIDFilter' = None
    ''' Which ID types to show/hide, when browsing a library

    :type: 'FileSelectIDFilter'
    '''

    filter_search: typing.Union[str, typing.Any] = None
    ''' Filter by name or tag, supports '*' wildcard

    :type: typing.Union[str, typing.Any]
    '''

    recursion_level: typing.Union[str, int] = None
    ''' Numbers of dirtree levels to show simultaneously * ``NONE`` None -- Only list current directory's content, with no recursion. * ``BLEND`` Blend File -- List .blend files' content. * ``ALL_1`` One Level -- List all sub-directories' content, one level of recursion. * ``ALL_2`` Two Levels -- List all sub-directories' content, two levels of recursion. * ``ALL_3`` Three Levels -- List all sub-directories' content, three levels of recursion.

    :type: typing.Union[str, int]
    '''

    show_details_datetime: bool = None
    ''' Show a column listing the date and time of modification for each file

    :type: bool
    '''

    show_details_size: bool = None
    ''' Show a column listing the size of each file

    :type: bool
    '''

    show_hidden: bool = None
    ''' Show hidden dot files

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    title: typing.Union[str, typing.Any] = None
    ''' Title for the file browser

    :type: typing.Union[str, typing.Any]
    '''

    use_filter: bool = None
    ''' Enable filtering of files

    :type: bool
    '''

    use_filter_asset_only: bool = None
    ''' Hide .blend files items that are not data-blocks with asset metadata

    :type: bool
    '''

    use_filter_backup: bool = None
    ''' Show .blend1, .blend2, etc. files

    :type: bool
    '''

    use_filter_blender: bool = None
    ''' Show .blend files

    :type: bool
    '''

    use_filter_blendid: bool = None
    ''' Show .blend files items (objects, materials, etc.)

    :type: bool
    '''

    use_filter_folder: bool = None
    ''' Show folders

    :type: bool
    '''

    use_filter_font: bool = None
    ''' Show font files

    :type: bool
    '''

    use_filter_image: bool = None
    ''' Show image files

    :type: bool
    '''

    use_filter_movie: bool = None
    ''' Show movie files

    :type: bool
    '''

    use_filter_script: bool = None
    ''' Show script files

    :type: bool
    '''

    use_filter_sound: bool = None
    ''' Show sound files

    :type: bool
    '''

    use_filter_text: bool = None
    ''' Show text files

    :type: bool
    '''

    use_filter_volume: bool = None
    ''' Show 3D volume files

    :type: bool
    '''

    use_library_browsing: typing.Union[bool, typing.Any] = None
    ''' Whether we may browse Blender files' content or not

    :type: typing.Union[bool, typing.Any]
    '''

    use_sort_invert: bool = None
    ''' Sort items descending, from highest value to lowest

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Float2AttributeValue(bpy_struct):
    ''' 2D Vector value in geometry attribute
    '''

    vector: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' 2D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FloatAttributeValue(bpy_struct):
    ''' Floating-point value in geometry attribute
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FloatColorAttributeValue(bpy_struct):
    ''' Color value in geometry attribute
    '''

    color: bpy_prop_array[float] = None
    ''' RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    '''

    color_srgb: bpy_prop_array[float] = None
    ''' RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FloatVectorAttributeValue(bpy_struct):
    ''' Vector value in geometry attribute
    '''

    vector: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 3D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FloatVectorValueReadOnly(bpy_struct):
    vector: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 3D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FluidDomainSettings(bpy_struct):
    ''' Fluid domain settings
    '''

    adapt_margin: int = None
    ''' Margin added around fluid to minimize boundary interference

    :type: int
    '''

    adapt_threshold: float = None
    ''' Minimum amount of fluid a cell can contain before it is considered empty

    :type: float
    '''

    additional_res: int = None
    ''' Maximum number of additional cells

    :type: int
    '''

    alpha: float = None
    ''' Buoyant force based on smoke density (higher value results in faster rising smoke)

    :type: float
    '''

    beta: float = None
    ''' Buoyant force based on smoke heat (higher value results in faster rising smoke)

    :type: float
    '''

    burning_rate: float = None
    ''' Speed of the burning reaction (higher value results in smaller flames)

    :type: float
    '''

    cache_data_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching volumetric data

    :type: typing.Union[str, int]
    '''

    cache_directory: typing.Union[str, typing.Any] = None
    ''' Directory that contains fluid cache files

    :type: typing.Union[str, typing.Any]
    '''

    cache_frame_end: int = None
    ''' Frame on which the simulation stops. This is the last frame that will be baked

    :type: int
    '''

    cache_frame_offset: int = None
    ''' Frame offset that is used when loading the simulation from the cache. It is not considered when baking the simulation, only when loading it

    :type: int
    '''

    cache_frame_pause_data: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_guide: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_mesh: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_noise: int = None
    ''' 

    :type: int
    '''

    cache_frame_pause_particles: int = None
    ''' 

    :type: int
    '''

    cache_frame_start: int = None
    ''' Frame on which the simulation starts. This is the first frame that will be baked

    :type: int
    '''

    cache_mesh_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching surface data

    :type: typing.Union[str, int]
    '''

    cache_noise_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching noise data

    :type: typing.Union[str, int]
    '''

    cache_particle_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching particle data

    :type: typing.Union[str, int]
    '''

    cache_resumable: bool = None
    ''' Additional data will be saved so that the bake jobs can be resumed after pausing. Because more data will be written to disk it is recommended to avoid enabling this option when baking at high resolutions

    :type: bool
    '''

    cache_type: typing.Union[str, int] = None
    ''' Change the cache type of the simulation * ``REPLAY`` Replay -- Use the timeline to bake the scene. * ``MODULAR`` Modular -- Bake every stage of the simulation separately. * ``ALL`` All -- Bake all simulation settings at once.

    :type: typing.Union[str, int]
    '''

    cell_size: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Vector'] = None
    ''' Cell Size

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    cfl_condition: float = None
    ''' Maximal velocity per cell (greater CFL numbers will minimize the number of simulation steps and the computation time.)

    :type: float
    '''

    clipping: float = None
    ''' Value under which voxels are considered empty space to optimize rendering

    :type: float
    '''

    color_grid: bpy_prop_array[float] = None
    ''' Smoke color grid

    :type: bpy_prop_array[float]
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    color_ramp_field: typing.Union[str, int] = None
    ''' Simulation field to color map

    :type: typing.Union[str, int]
    '''

    color_ramp_field_scale: float = None
    ''' Multiplier for scaling the selected field to color map

    :type: float
    '''

    delete_in_obstacle: bool = None
    ''' Delete fluid inside obstacles

    :type: bool
    '''

    density_grid: bpy_prop_array[float] = None
    ''' Smoke density grid

    :type: bpy_prop_array[float]
    '''

    display_interpolation: typing.Union[str, int] = None
    ''' Interpolation method to use for smoke/fire volumes in solid mode * ``LINEAR`` Linear -- Good smoothness and speed. * ``CUBIC`` Cubic -- Smoothed high quality interpolation, but slower. * ``CLOSEST`` Closest -- No interpolation.

    :type: typing.Union[str, int]
    '''

    display_thickness: float = None
    ''' Thickness of smoke display in the viewport

    :type: float
    '''

    dissolve_speed: int = None
    ''' Determine how quickly the smoke dissolves (lower value makes smoke disappear faster)

    :type: int
    '''

    domain_resolution: bpy_prop_array[int] = None
    ''' Smoke Grid Resolution

    :type: bpy_prop_array[int]
    '''

    domain_type: typing.Union[str, int] = None
    ''' Change domain type of the simulation * ``GAS`` Gas -- Create domain for gases. * ``LIQUID`` Liquid -- Create domain for liquids.

    :type: typing.Union[str, int]
    '''

    effector_group: 'Collection' = None
    ''' Limit effectors to this collection

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    export_manta_script: bool = None
    ''' Generate and export Mantaflow script from current domain settings during bake. This is only needed if you plan to analyze the cache (e.g. view grids, velocity vectors, particles) in Mantaflow directly (outside of Blender) after baking the simulation

    :type: bool
    '''

    flame_grid: bpy_prop_array[float] = None
    ''' Smoke flame grid

    :type: bpy_prop_array[float]
    '''

    flame_ignition: float = None
    ''' Minimum temperature of the flames (higher value results in faster rising flames)

    :type: float
    '''

    flame_max_temp: float = None
    ''' Maximum temperature of the flames (higher value results in faster rising flames)

    :type: float
    '''

    flame_smoke: float = None
    ''' Amount of smoke created by burning fuel

    :type: float
    '''

    flame_smoke_color: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Color of smoke emitted from burning fuel

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    flame_vorticity: float = None
    ''' Additional vorticity for the flames

    :type: float
    '''

    flip_ratio: float = None
    ''' PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes

    :type: float
    '''

    fluid_group: 'Collection' = None
    ''' Limit fluid objects to this collection

    :type: 'Collection'
    '''

    force_collection: 'Collection' = None
    ''' Limit forces to this collection

    :type: 'Collection'
    '''

    fractions_distance: float = None
    ''' Determines how far apart fluid and obstacle are (higher values will result in fluid being further away from obstacles, smaller values will let fluid move towards the inside of obstacles)

    :type: float
    '''

    fractions_threshold: float = None
    ''' Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect)

    :type: float
    '''

    gravity: typing.Union[typing.List[float], typing.
                          Tuple[float, float, float],
                          'mathutils.Vector'] = None
    ''' Gravity in X, Y and Z direction

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    gridlines_cell_filter: typing.Union[str, int] = None
    ''' Cell type to be highlighted * ``NONE`` None -- Highlight the cells regardless of their type. * ``FLUID`` Fluid -- Highlight only the cells of type Fluid. * ``OBSTACLE`` Obstacle -- Highlight only the cells of type Obstacle. * ``EMPTY`` Empty -- Highlight only the cells of type Empty. * ``INFLOW`` Inflow -- Highlight only the cells of type Inflow. * ``OUTFLOW`` Outflow -- Highlight only the cells of type Outflow.

    :type: typing.Union[str, int]
    '''

    gridlines_color_field: typing.Union[str, int] = None
    ''' Simulation field to color map onto gridlines * ``NONE`` None -- None. * ``FLAGS`` Flags -- Flag grid of the fluid domain. * ``RANGE`` Highlight Range -- Highlight the voxels with values of the color mapped field within the range.

    :type: typing.Union[str, int]
    '''

    gridlines_lower_bound: float = None
    ''' Lower bound of the highlighting range

    :type: float
    '''

    gridlines_range_color: bpy_prop_array[float] = None
    ''' Color used to highlight the range

    :type: bpy_prop_array[float]
    '''

    gridlines_upper_bound: float = None
    ''' Upper bound of the highlighting range

    :type: float
    '''

    guide_alpha: float = None
    ''' Guiding weight (higher value results in greater lag)

    :type: float
    '''

    guide_beta: int = None
    ''' Guiding size (higher value results in larger vortices)

    :type: int
    '''

    guide_parent: 'Object' = None
    ''' Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain))

    :type: 'Object'
    '''

    guide_source: typing.Union[str, int] = None
    ''' Choose where to get guiding velocities from * ``DOMAIN`` Domain -- Use a fluid domain for guiding (domain needs to be baked already so that velocities can be extracted). Guiding domain can be of any type (i.e. gas or liquid). * ``EFFECTOR`` Effector -- Use guiding (effector) objects to create fluid guiding (guiding objects should be animated and baked once set up completely).

    :type: typing.Union[str, int]
    '''

    guide_vel_factor: float = None
    ''' Guiding velocity factor (higher value results in greater guiding velocities)

    :type: float
    '''

    has_cache_baked_any: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_data: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_guide: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_mesh: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_noise: bool = None
    ''' 

    :type: bool
    '''

    has_cache_baked_particles: bool = None
    ''' 

    :type: bool
    '''

    heat_grid: bpy_prop_array[float] = None
    ''' Smoke heat grid

    :type: bpy_prop_array[float]
    '''

    highres_sampling: typing.Union[str, int] = None
    ''' Method for sampling the high resolution flow

    :type: typing.Union[str, int]
    '''

    is_cache_baking_any: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_data: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_guide: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_mesh: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_noise: bool = None
    ''' 

    :type: bool
    '''

    is_cache_baking_particles: bool = None
    ''' 

    :type: bool
    '''

    mesh_concave_lower: float = None
    ''' Lower mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    '''

    mesh_concave_upper: float = None
    ''' Upper mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    '''

    mesh_generator: typing.Union[str, int] = None
    ''' Which particle level set generator to use * ``IMPROVED`` Final -- Use improved particle level set (slower but more precise and with mesh smoothening options). * ``UNION`` Preview -- Use union particle level set (faster but lower quality).

    :type: typing.Union[str, int]
    '''

    mesh_particle_radius: float = None
    ''' Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale

    :type: float
    '''

    mesh_scale: int = None
    ''' The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value

    :type: int
    '''

    mesh_smoothen_neg: int = None
    ''' Negative mesh smoothening

    :type: int
    '''

    mesh_smoothen_pos: int = None
    ''' Positive mesh smoothening

    :type: int
    '''

    noise_pos_scale: float = None
    ''' Scale of noise (higher value results in larger vortices)

    :type: float
    '''

    noise_scale: int = None
    ''' The noise simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    '''

    noise_strength: float = None
    ''' Strength of noise

    :type: float
    '''

    noise_time_anim: float = None
    ''' Animation time of noise

    :type: float
    '''

    openvdb_cache_compress_type: typing.Union[str, int] = None
    ''' Compression method to be used * ``ZIP`` Zip -- Effective but slow compression. * ``BLOSC`` Blosc -- Multithreaded compression, similar in size and quality as 'Zip'. * ``NONE`` None -- Do not use any compression.

    :type: typing.Union[str, int]
    '''

    openvdb_data_depth: typing.Union[str, int] = None
    ''' Bit depth for fluid particles and grids (lower bit values reduce file size)

    :type: typing.Union[str, int]
    '''

    particle_band_width: float = None
    ''' Particle (narrow) band width (higher value results in thicker band and more particles)

    :type: float
    '''

    particle_max: int = None
    ''' Maximum number of particles per cell (ensures that each cell has at most this amount of particles)

    :type: int
    '''

    particle_min: int = None
    ''' Minimum number of particles per cell (ensures that each cell has at least this amount of particles)

    :type: int
    '''

    particle_number: int = None
    ''' Particle number factor (higher value results in more particles)

    :type: int
    '''

    particle_radius: float = None
    ''' Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume

    :type: float
    '''

    particle_randomness: float = None
    ''' Randomness factor for particle sampling

    :type: float
    '''

    particle_scale: int = None
    ''' The particle simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    '''

    resolution_max: int = None
    ''' Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically)

    :type: int
    '''

    show_gridlines: bool = None
    ''' Show gridlines

    :type: bool
    '''

    show_velocity: bool = None
    ''' Visualize vector fields

    :type: bool
    '''

    simulation_method: typing.Union[str, int] = None
    ''' Change the underlying simulation method * ``FLIP`` FLIP -- Use FLIP as the simulation method (more splashy behavior). * ``APIC`` APIC -- Use APIC as the simulation method (more energetic and stable behavior).

    :type: typing.Union[str, int]
    '''

    slice_axis: typing.Union[str, int] = None
    ''' * ``AUTO`` Auto -- Adjust slice direction according to the view direction. * ``X`` X -- Slice along the X axis. * ``Y`` Y -- Slice along the Y axis. * ``Z`` Z -- Slice along the Z axis.

    :type: typing.Union[str, int]
    '''

    slice_depth: float = None
    ''' Position of the slice

    :type: float
    '''

    slice_per_voxel: float = None
    ''' How many slices per voxel should be generated

    :type: float
    '''

    sndparticle_boundary: typing.Union[str, int] = None
    ''' How particles that left the domain are treated * ``DELETE`` Delete -- Delete secondary particles that are inside obstacles or left the domain. * ``PUSHOUT`` Push Out -- Push secondary particles that left the domain back into the domain.

    :type: typing.Union[str, int]
    '''

    sndparticle_bubble_buoyancy: float = None
    ''' Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards)

    :type: float
    '''

    sndparticle_bubble_drag: float = None
    ''' Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid)

    :type: float
    '''

    sndparticle_combined_export: typing.Union[str, int] = None
    ''' Determines which particle systems are created from secondary particles * ``OFF`` Off -- Create a separate particle system for every secondary particle type. * ``SPRAY_FOAM`` Spray + Foam -- Spray and foam particles are saved in the same particle system. * ``SPRAY_BUBBLES`` Spray + Bubbles -- Spray and bubble particles are saved in the same particle system. * ``FOAM_BUBBLES`` Foam + Bubbles -- Foam and bubbles particles are saved in the same particle system. * ``SPRAY_FOAM_BUBBLES`` Spray + Foam + Bubbles -- Create one particle system that contains all three secondary particle types.

    :type: typing.Union[str, int]
    '''

    sndparticle_life_max: float = None
    ''' Highest possible particle lifetime

    :type: float
    '''

    sndparticle_life_min: float = None
    ''' Lowest possible particle lifetime

    :type: float
    '''

    sndparticle_potential_max_energy: float = None
    ''' Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles)

    :type: float
    '''

    sndparticle_potential_max_trappedair: float = None
    ''' Upper clamping threshold for marking fluid cells where air is trapped (higher value results in less marked cells)

    :type: float
    '''

    sndparticle_potential_max_wavecrest: float = None
    ''' Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells)

    :type: float
    '''

    sndparticle_potential_min_energy: float = None
    ''' Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles)

    :type: float
    '''

    sndparticle_potential_min_trappedair: float = None
    ''' Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells)

    :type: float
    '''

    sndparticle_potential_min_wavecrest: float = None
    ''' Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells)

    :type: float
    '''

    sndparticle_potential_radius: int = None
    ''' Radius to compute potential for each cell (higher values are slower but create smoother potential grids)

    :type: int
    '''

    sndparticle_sampling_trappedair: int = None
    ''' Maximum number of particles generated per trapped air cell per frame

    :type: int
    '''

    sndparticle_sampling_wavecrest: int = None
    ''' Maximum number of particles generated per wave crest cell per frame

    :type: int
    '''

    sndparticle_update_radius: int = None
    ''' Radius to compute position update for each particle (higher values are slower but particles move less chaotic)

    :type: int
    '''

    start_point: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' Start point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    surface_tension: float = None
    ''' Surface tension of liquid (higher value results in greater hydrophobic behavior)

    :type: float
    '''

    sys_particle_maximum: int = None
    ''' Maximum number of fluid particles that are allowed in this simulation

    :type: int
    '''

    temperature_grid: bpy_prop_array[float] = None
    ''' Smoke temperature grid, range 0 to 1 represents 0 to 1000K

    :type: bpy_prop_array[float]
    '''

    time_scale: float = None
    ''' Adjust simulation speed

    :type: float
    '''

    timesteps_max: int = None
    ''' Maximum number of simulation steps to perform for one frame

    :type: int
    '''

    timesteps_min: int = None
    ''' Minimum number of simulation steps to perform for one frame

    :type: int
    '''

    use_adaptive_domain: bool = None
    ''' Adapt simulation resolution and size to fluid

    :type: bool
    '''

    use_adaptive_timesteps: bool = None
    ''' 

    :type: bool
    '''

    use_bubble_particles: bool = None
    ''' Create bubble particle system

    :type: bool
    '''

    use_collision_border_back: bool = None
    ''' Enable collisions with back domain border

    :type: bool
    '''

    use_collision_border_bottom: bool = None
    ''' Enable collisions with bottom domain border

    :type: bool
    '''

    use_collision_border_front: bool = None
    ''' Enable collisions with front domain border

    :type: bool
    '''

    use_collision_border_left: bool = None
    ''' Enable collisions with left domain border

    :type: bool
    '''

    use_collision_border_right: bool = None
    ''' Enable collisions with right domain border

    :type: bool
    '''

    use_collision_border_top: bool = None
    ''' Enable collisions with top domain border

    :type: bool
    '''

    use_color_ramp: bool = None
    ''' Render a simulation field while mapping its voxels values to the colors of a ramp or using a predefined color code

    :type: bool
    '''

    use_diffusion: bool = None
    ''' Enable fluid diffusion settings (e.g. viscosity, surface tension)

    :type: bool
    '''

    use_dissolve_smoke: bool = None
    ''' Let smoke disappear over time

    :type: bool
    '''

    use_dissolve_smoke_log: bool = None
    ''' Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer

    :type: bool
    '''

    use_flip_particles: bool = None
    ''' Create liquid particle system

    :type: bool
    '''

    use_foam_particles: bool = None
    ''' Create foam particle system

    :type: bool
    '''

    use_fractions: bool = None
    ''' Fractional obstacles improve and smoothen the fluid-obstacle boundary

    :type: bool
    '''

    use_guide: bool = None
    ''' Enable fluid guiding

    :type: bool
    '''

    use_mesh: bool = None
    ''' Enable fluid mesh (using amplification)

    :type: bool
    '''

    use_noise: bool = None
    ''' Enable fluid noise (using amplification)

    :type: bool
    '''

    use_slice: bool = None
    ''' Perform a single slice of the domain object

    :type: bool
    '''

    use_speed_vectors: bool = None
    ''' Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled

    :type: bool
    '''

    use_spray_particles: bool = None
    ''' Create spray particle system

    :type: bool
    '''

    use_tracer_particles: bool = None
    ''' Create tracer particle system

    :type: bool
    '''

    use_viscosity: bool = None
    ''' Enable fluid viscosity settings

    :type: bool
    '''

    vector_display_type: typing.Union[str, int] = None
    ''' * ``NEEDLE`` Needle -- Display vectors as needles. * ``STREAMLINE`` Streamlines -- Display vectors as streamlines. * ``MAC`` MAC Grid -- Display vector field as MAC grid.

    :type: typing.Union[str, int]
    '''

    vector_field: typing.Union[str, int] = None
    ''' Vector field to be represented by the display vectors * ``FLUID_VELOCITY`` Fluid Velocity -- Velocity field of the fluid domain. * ``GUIDE_VELOCITY`` Guide Velocity -- Guide velocity field of the fluid domain. * ``FORCE`` Force -- Force field of the fluid domain.

    :type: typing.Union[str, int]
    '''

    vector_scale: float = None
    ''' Multiplier for scaling the vectors

    :type: float
    '''

    vector_scale_with_magnitude: bool = None
    ''' Scale vectors with their magnitudes

    :type: bool
    '''

    vector_show_mac_x: bool = None
    ''' Show X-component of MAC Grid

    :type: bool
    '''

    vector_show_mac_y: bool = None
    ''' Show Y-component of MAC Grid

    :type: bool
    '''

    vector_show_mac_z: bool = None
    ''' Show Z-component of MAC Grid

    :type: bool
    '''

    velocity_grid: bpy_prop_array[float] = None
    ''' Smoke velocity grid

    :type: bpy_prop_array[float]
    '''

    velocity_scale: float = None
    ''' Factor to control the amount of motion blur

    :type: float
    '''

    viscosity_base: float = None
    ''' Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    '''

    viscosity_exponent: int = None
    ''' Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    '''

    viscosity_value: float = None
    ''' Viscosity of liquid (higher values result in more viscous fluids, a value of 0 will still apply some viscosity)

    :type: float
    '''

    vorticity: float = None
    ''' Amount of turbulence and rotation in smoke

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FluidEffectorSettings(bpy_struct):
    ''' Smoke collision settings
    '''

    effector_type: typing.Union[str, int] = None
    ''' Change type of effector in the simulation * ``COLLISION`` Collision -- Create collision object. * ``GUIDE`` Guide -- Create guide object.

    :type: typing.Union[str, int]
    '''

    guide_mode: typing.Union[str, int] = None
    ''' How to create guiding velocities * ``MAXIMUM`` Maximize -- Compare velocities from previous frame with new velocities from current frame and keep the maximum. * ``MINIMUM`` Minimize -- Compare velocities from previous frame with new velocities from current frame and keep the minimum. * ``OVERRIDE`` Override -- Always write new guide velocities for every frame (each frame only contains current velocities from guiding objects). * ``AVERAGED`` Averaged -- Take average of velocities from previous frame and new velocities from current frame.

    :type: typing.Union[str, int]
    '''

    subframes: int = None
    ''' Number of additional samples to take between frames to improve quality of fast moving effector objects

    :type: int
    '''

    surface_distance: float = None
    ''' Additional distance around mesh surface to consider as effector

    :type: float
    '''

    use_effector: bool = None
    ''' Control when to apply the effector

    :type: bool
    '''

    use_plane_init: bool = None
    ''' Treat this object as a planar, unclosed mesh

    :type: bool
    '''

    velocity_factor: float = None
    ''' Multiplier of obstacle velocity

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FluidFlowSettings(bpy_struct):
    ''' Fluid flow settings
    '''

    density: float = None
    ''' 

    :type: float
    '''

    density_vertex_group: typing.Union[str, typing.Any] = None
    ''' Name of vertex group which determines surface emission rate

    :type: typing.Union[str, typing.Any]
    '''

    flow_behavior: typing.Union[str, int] = None
    ''' Change flow behavior in the simulation * ``INFLOW`` Inflow -- Add fluid to simulation. * ``OUTFLOW`` Outflow -- Delete fluid from simulation. * ``GEOMETRY`` Geometry -- Only use given geometry for fluid.

    :type: typing.Union[str, int]
    '''

    flow_source: typing.Union[str, int] = None
    ''' Change how fluid is emitted

    :type: typing.Union[str, int]
    '''

    flow_type: typing.Union[str, int] = None
    ''' Change type of fluid in the simulation * ``SMOKE`` Smoke -- Add smoke. * ``BOTH`` Fire + Smoke -- Add fire and smoke. * ``FIRE`` Fire -- Add fire. * ``LIQUID`` Liquid -- Add liquid.

    :type: typing.Union[str, int]
    '''

    fuel_amount: float = None
    ''' 

    :type: float
    '''

    noise_texture: 'Texture' = None
    ''' Texture that controls emission strength

    :type: 'Texture'
    '''

    particle_size: float = None
    ''' Particle size in simulation cells

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' Particle systems emitted from the object

    :type: 'ParticleSystem'
    '''

    smoke_color: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Color of smoke

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    subframes: int = None
    ''' Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    '''

    surface_distance: float = None
    ''' Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface

    :type: float
    '''

    temperature: float = None
    ''' Temperature difference to ambient temperature

    :type: float
    '''

    texture_map_type: typing.Union[str, int] = None
    ''' Texture mapping type * ``AUTO`` Generated -- Generated coordinates centered to flow object. * ``UV`` UV -- Use UV layer for texture coordinates.

    :type: typing.Union[str, int]
    '''

    texture_offset: float = None
    ''' Z-offset of texture mapping

    :type: float
    '''

    texture_size: float = None
    ''' Size of texture mapping

    :type: float
    '''

    use_absolute: bool = None
    ''' Only allow given density value in emitter area and will not add up

    :type: bool
    '''

    use_inflow: bool = None
    ''' Control when to apply fluid flow

    :type: bool
    '''

    use_initial_velocity: bool = None
    ''' Fluid has some initial velocity when it is emitted

    :type: bool
    '''

    use_particle_size: bool = None
    ''' Set particle size in simulation cells or use nearest cell

    :type: bool
    '''

    use_plane_init: bool = None
    ''' Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value

    :type: bool
    '''

    use_texture: bool = None
    ''' Use a texture to control emission strength

    :type: bool
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' UV map name

    :type: typing.Union[str, typing.Any]
    '''

    velocity_coord: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Vector'] = None
    ''' Additional initial velocity in X, Y and Z direction (added to source velocity)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    velocity_factor: float = None
    ''' Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving)

    :type: float
    '''

    velocity_normal: float = None
    ''' Amount of normal directional velocity

    :type: float
    '''

    velocity_random: float = None
    ''' Amount of random velocity

    :type: float
    '''

    volume_density: float = None
    ''' Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh)

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FreestyleLineSet(bpy_struct):
    ''' Line set for associating lines and style parameters
    '''

    collection: 'Collection' = None
    ''' A collection of objects based on which feature edges are selected

    :type: 'Collection'
    '''

    collection_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges belonging to a collection of objects * ``INCLUSIVE`` Inclusive -- Select feature edges belonging to some object in the group. * ``EXCLUSIVE`` Exclusive -- Select feature edges not belonging to any object in the group.

    :type: typing.Union[str, int]
    '''

    edge_type_combination: typing.Union[str, int] = None
    ''' Specify a logical combination of selection conditions on feature edge types * ``OR`` Logical OR -- Select feature edges satisfying at least one of edge type conditions. * ``AND`` Logical AND -- Select feature edges satisfying all edge type conditions.

    :type: typing.Union[str, int]
    '''

    edge_type_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by edge types * ``INCLUSIVE`` Inclusive -- Select feature edges satisfying the given edge type conditions. * ``EXCLUSIVE`` Exclusive -- Select feature edges not satisfying the given edge type conditions.

    :type: typing.Union[str, int]
    '''

    exclude_border: bool = None
    ''' Exclude border edges

    :type: bool
    '''

    exclude_contour: bool = None
    ''' Exclude contours

    :type: bool
    '''

    exclude_crease: bool = None
    ''' Exclude crease edges

    :type: bool
    '''

    exclude_edge_mark: bool = None
    ''' Exclude edge marks

    :type: bool
    '''

    exclude_external_contour: bool = None
    ''' Exclude external contours

    :type: bool
    '''

    exclude_material_boundary: bool = None
    ''' Exclude edges at material boundaries

    :type: bool
    '''

    exclude_ridge_valley: bool = None
    ''' Exclude ridges and valleys

    :type: bool
    '''

    exclude_silhouette: bool = None
    ''' Exclude silhouette edges

    :type: bool
    '''

    exclude_suggestive_contour: bool = None
    ''' Exclude suggestive contours

    :type: bool
    '''

    face_mark_condition: typing.Union[str, int] = None
    ''' Specify a feature edge selection condition based on face marks * ``ONE`` One Face -- Select a feature edge if either of its adjacent faces is marked. * ``BOTH`` Both Faces -- Select a feature edge if both of its adjacent faces are marked.

    :type: typing.Union[str, int]
    '''

    face_mark_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by face marks * ``INCLUSIVE`` Inclusive -- Select feature edges satisfying the given face mark conditions. * ``EXCLUSIVE`` Exclusive -- Select feature edges not satisfying the given face mark conditions.

    :type: typing.Union[str, int]
    '''

    linestyle: 'FreestyleLineStyle' = None
    ''' Line style settings

    :type: 'FreestyleLineStyle'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Line set name

    :type: typing.Union[str, typing.Any]
    '''

    qi_end: int = None
    ''' Last QI value of the QI range

    :type: int
    '''

    qi_start: int = None
    ''' First QI value of the QI range

    :type: int
    '''

    select_border: bool = None
    ''' Select border edges (open mesh edges)

    :type: bool
    '''

    select_by_collection: bool = None
    ''' Select feature edges based on a collection of objects

    :type: bool
    '''

    select_by_edge_types: bool = None
    ''' Select feature edges based on edge types

    :type: bool
    '''

    select_by_face_marks: bool = None
    ''' Select feature edges by face marks

    :type: bool
    '''

    select_by_image_border: bool = None
    ''' Select feature edges by image border (less memory consumption)

    :type: bool
    '''

    select_by_visibility: bool = None
    ''' Select feature edges based on visibility

    :type: bool
    '''

    select_contour: bool = None
    ''' Select contours (outer silhouettes of each object)

    :type: bool
    '''

    select_crease: bool = None
    ''' Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    '''

    select_edge_mark: bool = None
    ''' Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    '''

    select_external_contour: bool = None
    ''' Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    '''

    select_material_boundary: bool = None
    ''' Select edges at material boundaries

    :type: bool
    '''

    select_ridge_valley: bool = None
    ''' Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    '''

    select_silhouette: bool = None
    ''' Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    '''

    select_suggestive_contour: bool = None
    ''' Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    '''

    show_render: bool = None
    ''' Enable or disable this line set during stroke rendering

    :type: bool
    '''

    visibility: typing.Union[str, int] = None
    ''' Determine how to use visibility for feature edge selection * ``VISIBLE`` Visible -- Select visible feature edges. * ``HIDDEN`` Hidden -- Select hidden feature edges. * ``RANGE`` Quantitative Invisibility -- Select feature edges within a range of quantitative invisibility (QI) values.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FreestyleModuleSettings(bpy_struct):
    ''' Style module configuration for specifying a style module
    '''

    script: 'Text' = None
    ''' Python script to define a style module

    :type: 'Text'
    '''

    use: bool = None
    ''' Enable or disable this style module during stroke rendering

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class FreestyleSettings(bpy_struct):
    ''' Freestyle settings for a ViewLayer data-block
    '''

    as_render_pass: bool = None
    ''' Renders Freestyle output to a separate pass instead of overlaying it on the Combined pass

    :type: bool
    '''

    crease_angle: float = None
    ''' Angular threshold for detecting crease edges

    :type: float
    '''

    kr_derivative_epsilon: float = None
    ''' Kr derivative epsilon for computing suggestive contours

    :type: float
    '''

    linesets: 'Linesets' = None
    ''' 

    :type: 'Linesets'
    '''

    mode: typing.Union[str, int] = None
    ''' Select the Freestyle control mode * ``SCRIPT`` Python Scripting -- Advanced mode for using style modules written in Python. * ``EDITOR`` Parameter Editor -- Basic mode for interactive style parameter editing.

    :type: typing.Union[str, int]
    '''

    modules: 'FreestyleModules' = None
    ''' A list of style modules (to be applied from top to bottom)

    :type: 'FreestyleModules'
    '''

    sphere_radius: float = None
    ''' Sphere radius for computing curvatures

    :type: float
    '''

    use_culling: bool = None
    ''' If enabled, out-of-view edges are ignored

    :type: bool
    '''

    use_material_boundaries: bool = None
    ''' Enable material boundaries

    :type: bool
    '''

    use_ridges_and_valleys: bool = None
    ''' Enable ridges and valleys

    :type: bool
    '''

    use_smoothness: bool = None
    ''' Take face smoothness into account in view map calculation

    :type: bool
    '''

    use_suggestive_contours: bool = None
    ''' Enable suggestive contours

    :type: bool
    '''

    use_view_map_cache: bool = None
    ''' Keep the computed view map and avoid recalculating it if mesh geometry is unchanged

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Function(bpy_struct):
    ''' RNA function definition
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the Function's purpose

    :type: typing.Union[str, typing.Any]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    is_registered: typing.Union[bool, typing.Any] = None
    ''' Function is registered as callback as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered_optional: typing.Union[bool, typing.Any] = None
    ''' Function is optionally registered as callback part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    parameters: bpy_prop_collection['Property'] = None
    ''' Parameters for the function

    :type: bpy_prop_collection['Property']
    '''

    use_self: typing.Union[bool, typing.Any] = None
    ''' Function does not pass itself as an argument (becomes a static method in Python)

    :type: typing.Union[bool, typing.Any]
    '''

    use_self_type: typing.Union[bool, typing.Any] = None
    ''' Function passes itself type as an argument (becomes a class method in Python if use_self is false)

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilEditCurve(bpy_struct):
    ''' Edition Curve
    '''

    curve_points: bpy_prop_collection['GPencilEditCurvePoint'] = None
    ''' Curve data points

    :type: bpy_prop_collection['GPencilEditCurvePoint']
    '''

    select: bool = None
    ''' Curve is selected for viewport editing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilEditCurvePoint(bpy_struct):
    ''' Bezier curve point with two handles
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_left: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' Coordinates of the first handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_right: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Vector'] = None
    ''' Coordinates of the second handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    point_index: int = None
    ''' Index of the corresponding grease pencil stroke point

    :type: int
    '''

    pressure: float = None
    ''' Pressure of the grease pencil stroke point

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Handle 1 selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Handle 2 selection status

    :type: bool
    '''

    strength: float = None
    ''' Color intensity (alpha factor) of the grease pencil stroke point

    :type: float
    '''

    uv_factor: float = None
    ''' Internal UV factor

    :type: float
    '''

    uv_rotation: float = None
    ''' Internal UV factor for dot mode

    :type: float
    '''

    vertex_color: bpy_prop_array[float] = None
    ''' Vertex color of the grease pencil stroke point

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilFrame(bpy_struct):
    ''' Collection of related sketches on a particular frame
    '''

    frame_number: int = None
    ''' The frame on which this sketch appears

    :type: int
    '''

    is_edited: bool = None
    ''' Frame is being edited (painted on)

    :type: bool
    '''

    keyframe_type: typing.Union[str, int] = None
    ''' Type of keyframe * ``KEYFRAME`` Keyframe -- Normal keyframe, e.g. for key poses. * ``BREAKDOWN`` Breakdown -- A breakdown pose, e.g. for transitions between key poses. * ``MOVING_HOLD`` Moving Hold -- A keyframe that is part of a moving hold. * ``EXTREME`` Extreme -- An 'extreme' pose, or some other purpose as needed. * ``JITTER`` Jitter -- A filler or baked keyframe for keying on ones, or some other purpose as needed.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Frame is selected for editing in the Dope Sheet

    :type: bool
    '''

    strokes: 'GPencilStrokes' = None
    ''' Freehand curves defining the sketch on this frame

    :type: 'GPencilStrokes'
    '''

    def clear(self):
        ''' Remove all the grease pencil frame data

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilInterpolateSettings(bpy_struct):
    ''' Settings for Grease Pencil interpolation tools
    '''

    interpolation_curve: 'CurveMapping' = None
    ''' Custom curve to control 'sequence' interpolation between Grease Pencil frames

    :type: 'CurveMapping'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilLayer(bpy_struct):
    ''' Collection of related sketches
    '''

    active_frame: 'GPencilFrame' = None
    ''' Frame currently being displayed for this layer

    :type: 'GPencilFrame'
    '''

    annotation_hide: bool = None
    ''' Set annotation Visibility

    :type: bool
    '''

    annotation_onion_after_color: typing.Union[typing.List[float], typing.
                                               Tuple[float, float, float],
                                               'mathutils.Color'] = None
    ''' Base color for ghosts after the active frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    annotation_onion_after_range: int = None
    ''' Maximum number of frames to show after current frame

    :type: int
    '''

    annotation_onion_before_color: typing.Union[typing.List[float], typing.
                                                Tuple[float, float, float],
                                                'mathutils.Color'] = None
    ''' Base color for ghosts before the active frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    annotation_onion_before_range: int = None
    ''' Maximum number of frames to show before current frame

    :type: int
    '''

    annotation_opacity: float = None
    ''' Annotation Layer Opacity

    :type: float
    '''

    blend_mode: typing.Union[str, int] = None
    ''' Blend mode

    :type: typing.Union[str, int]
    '''

    channel_color: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Custom color for animation channel in Dopesheet

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color for all strokes in this layer

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frames: 'GPencilFrames' = None
    ''' Sketches for this layer on different frames

    :type: 'GPencilFrames'
    '''

    hide: bool = None
    ''' Set layer Visibility

    :type: bool
    '''

    info: typing.Union[str, typing.Any] = None
    ''' Layer name

    :type: typing.Union[str, typing.Any]
    '''

    is_parented: typing.Union[bool, typing.Any] = None
    ''' True when the layer parent object is set

    :type: typing.Union[bool, typing.Any]
    '''

    is_ruler: typing.Union[bool, typing.Any] = None
    ''' This is a special ruler layer

    :type: typing.Union[bool, typing.Any]
    '''

    line_change: int = None
    ''' Thickness change to apply to current strokes (in pixels)

    :type: int
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' Values for change location

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    lock: bool = None
    ''' Protect layer from further editing and/or frame changes

    :type: bool
    '''

    lock_frame: bool = None
    ''' Lock current frame displayed by layer

    :type: bool
    '''

    lock_material: bool = None
    ''' Avoids editing locked materials in the layer

    :type: bool
    '''

    mask_layers: 'GreasePencilMaskLayers' = None
    ''' List of Masking Layers

    :type: 'GreasePencilMaskLayers'
    '''

    matrix_inverse: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Parent inverse transformation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_inverse_layer: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Local Layer transformation inverse matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_layer: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Local Layer transformation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    opacity: float = None
    ''' Layer Opacity

    :type: float
    '''

    parent: 'Object' = None
    ''' Parent object

    :type: 'Object'
    '''

    parent_bone: typing.Union[str, typing.Any] = None
    ''' Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    '''

    parent_type: typing.Union[str, int] = None
    ''' Type of parent relation * ``OBJECT`` Object -- The layer is parented to an object. * ``ARMATURE`` Armature. * ``BONE`` Bone -- The layer is parented to a bone.

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    ''' Index number for the "Layer Index" pass

    :type: int
    '''

    rotation: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Euler'] = None
    ''' Values for changes in rotation

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Euler']
    '''

    scale: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Values for changes in scale

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    show_in_front: bool = None
    ''' Make the layer display in front of objects

    :type: bool
    '''

    show_points: bool = None
    ''' Show the points which make up the strokes (for debugging purposes)

    :type: bool
    '''

    thickness: int = None
    ''' Thickness of annotation strokes

    :type: int
    '''

    tint_color: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' Color for tinting stroke colors

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tint_factor: float = None
    ''' Factor of tinting color

    :type: float
    '''

    use_annotation_onion_skinning: bool = None
    ''' Display annotation onion skins before and after the current frame

    :type: bool
    '''

    use_lights: bool = None
    ''' Enable the use of lights on stroke and fill materials

    :type: bool
    '''

    use_mask_layer: bool = None
    ''' The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    '''

    use_onion_skinning: bool = None
    ''' Display onion skins before and after the current frame

    :type: bool
    '''

    use_solo_mode: bool = None
    ''' In Draw Mode only display layers with keyframe in current frame

    :type: bool
    '''

    use_viewlayer_masks: bool = None
    ''' Include the mask layers when rendering the view-layer

    :type: bool
    '''

    vertex_paint_opacity: float = None
    ''' Vertex Paint mix factor

    :type: float
    '''

    viewlayer_render: typing.Union[str, typing.Any] = None
    ''' Only include Layer in this View Layer render output (leave blank to include always)

    :type: typing.Union[str, typing.Any]
    '''

    def clear(self):
        ''' Remove all the grease pencil layer data

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilLayerMask(bpy_struct):
    ''' List of Mask Layers
    '''

    hide: bool = None
    ''' Set mask Visibility

    :type: bool
    '''

    invert: bool = None
    ''' Invert mask

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Mask layer name

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilSculptGuide(bpy_struct):
    ''' Guides for drawing
    '''

    angle: float = None
    ''' Direction of lines

    :type: float
    '''

    angle_snap: float = None
    ''' Angle snapping

    :type: float
    '''

    location: bpy_prop_array[float] = None
    ''' Custom reference point for guides

    :type: bpy_prop_array[float]
    '''

    reference_object: 'Object' = None
    ''' Object used for reference point

    :type: 'Object'
    '''

    reference_point: typing.Union[str, int] = None
    ''' Type of speed guide * ``CURSOR`` Cursor -- Use cursor as reference point. * ``CUSTOM`` Custom -- Use custom reference point. * ``OBJECT`` Object -- Use object as reference point.

    :type: typing.Union[str, int]
    '''

    spacing: float = None
    ''' Guide spacing

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of speed guide * ``CIRCULAR`` Circular -- Use single point to create rings. * ``RADIAL`` Radial -- Use single point as direction. * ``PARALLEL`` Parallel -- Parallel lines. * ``GRID`` Grid -- Grid allows horizontal and vertical lines. * ``ISO`` Isometric -- Grid allows isometric and vertical lines.

    :type: typing.Union[str, int]
    '''

    use_guide: bool = None
    ''' Enable speed guides

    :type: bool
    '''

    use_snapping: bool = None
    ''' Enable snapping to guides angle or spacing options

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilSculptSettings(bpy_struct):
    ''' General properties for Grease Pencil stroke sculpting tools
    '''

    guide: 'GPencilSculptGuide' = None
    ''' 

    :type: 'GPencilSculptGuide'
    '''

    intersection_threshold: float = None
    ''' Threshold for stroke intersections

    :type: float
    '''

    lock_axis: typing.Union[str, int] = None
    ''' * ``VIEW`` View -- Align strokes to current view plane. * ``AXIS_Y`` Front (X-Z) -- Project strokes to plane locked to Y. * ``AXIS_X`` Side (Y-Z) -- Project strokes to plane locked to X. * ``AXIS_Z`` Top (X-Y) -- Project strokes to plane locked to Z. * ``CURSOR`` Cursor -- Align strokes to current 3D cursor orientation.

    :type: typing.Union[str, int]
    '''

    multiframe_falloff_curve: 'CurveMapping' = None
    ''' Custom curve to control falloff of brush effect by Grease Pencil frames

    :type: 'CurveMapping'
    '''

    thickness_primitive_curve: 'CurveMapping' = None
    ''' Custom curve to control primitive thickness

    :type: 'CurveMapping'
    '''

    use_automasking_layer_active: bool = None
    ''' Affect only the Active Layer

    :type: bool
    '''

    use_automasking_layer_stroke: bool = None
    ''' Affect only strokes below the cursor

    :type: bool
    '''

    use_automasking_material_active: bool = None
    ''' Affect only the Active Material

    :type: bool
    '''

    use_automasking_material_stroke: bool = None
    ''' Affect only strokes below the cursor

    :type: bool
    '''

    use_automasking_stroke: bool = None
    ''' Affect only strokes below the cursor

    :type: bool
    '''

    use_multiframe_falloff: bool = None
    ''' Use falloff effect when edit in multiframe mode to compute brush effect by frame

    :type: bool
    '''

    use_scale_thickness: bool = None
    ''' Scale the stroke thickness when transforming strokes

    :type: bool
    '''

    use_thickness_curve: bool = None
    ''' Use curve to define primitive stroke thickness

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilStroke(bpy_struct):
    ''' Freehand curve defining part of a sketch
    '''

    aspect: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    bound_box_max: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bound_box_min: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    display_mode: typing.Union[str, int] = None
    ''' Coordinate space that stroke is in * ``SCREEN`` Screen -- Stroke is in screen-space. * ``3DSPACE`` 3D Space -- Stroke is in 3D-space. * ``2DSPACE`` 2D Space -- Stroke is in 2D-space. * ``2DIMAGE`` 2D Image -- Stroke is in 2D-space (but with special 'image' scaling).

    :type: typing.Union[str, int]
    '''

    edit_curve: 'GPencilEditCurve' = None
    ''' Temporary data for Edit Curve

    :type: 'GPencilEditCurve'
    '''

    end_cap_mode: typing.Union[str, int] = None
    ''' Stroke end extreme cap style

    :type: typing.Union[str, int]
    '''

    hardness: float = None
    ''' Amount of gradient along section of stroke

    :type: float
    '''

    has_edit_curve: typing.Union[bool, typing.Any] = None
    ''' Stroke has Curve data to edit shape

    :type: typing.Union[bool, typing.Any]
    '''

    is_nofill_stroke: bool = None
    ''' Special stroke to use as boundary for filling areas

    :type: bool
    '''

    line_width: int = None
    ''' Thickness of stroke (in pixels)

    :type: int
    '''

    material_index: int = None
    ''' Material slot index of this stroke

    :type: int
    '''

    points: 'GPencilStrokePoints' = None
    ''' Stroke data points

    :type: 'GPencilStrokePoints'
    '''

    select: bool = None
    ''' Stroke is selected for viewport editing

    :type: bool
    '''

    select_index: int = None
    ''' Index of selection used for interpolation

    :type: int
    '''

    start_cap_mode: typing.Union[str, int] = None
    ''' Stroke start extreme cap style

    :type: typing.Union[str, int]
    '''

    time_start: float = None
    ''' Initial time of the stroke

    :type: float
    '''

    triangles: bpy_prop_collection['GPencilTriangle'] = None
    ''' Triangulation data for HQ fill

    :type: bpy_prop_collection['GPencilTriangle']
    '''

    use_cyclic: bool = None
    ''' Enable cyclic drawing, closing the stroke

    :type: bool
    '''

    uv_rotation: float = None
    ''' Rotation of the UV

    :type: float
    '''

    uv_scale: float = None
    ''' Scale of the UV

    :type: float
    '''

    uv_translation: typing.Union[typing.List[float], typing.
                                 Tuple[float, float],
                                 'mathutils.Vector'] = None
    ''' Translation of default UV position

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    vertex_color_fill: bpy_prop_array[float] = None
    ''' Color used to mix with fill color to get final color

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilStrokePoint(bpy_struct):
    ''' Data point for freehand stroke curve
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    pressure: float = None
    ''' Pressure of tablet at point when drawing it

    :type: float
    '''

    select: bool = None
    ''' Point is selected for viewport editing

    :type: bool
    '''

    strength: float = None
    ''' Color intensity (alpha factor)

    :type: float
    '''

    time: float = None
    ''' Time relative to stroke start

    :type: float
    '''

    uv_factor: float = None
    ''' Internal UV factor

    :type: float
    '''

    uv_fill: typing.Union[typing.List[float], typing.
                          Tuple[float, float], 'mathutils.Vector'] = None
    ''' Internal UV factor for filling

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    uv_rotation: float = None
    ''' Internal UV factor for dot mode

    :type: float
    '''

    vertex_color: bpy_prop_array[float] = None
    ''' Color used to mix with point color to get final color

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GPencilTriangle(bpy_struct):
    ''' Triangulation data for Grease Pencil fills
    '''

    v1: int = None
    ''' First triangle vertex index

    :type: int
    '''

    v2: int = None
    ''' Second triangle vertex index

    :type: int
    '''

    v3: int = None
    ''' Third triangle vertex index

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Gizmo(bpy_struct):
    ''' Collection of gizmos
    '''

    alpha: float = None
    ''' 

    :type: float
    '''

    alpha_highlight: float = None
    ''' 

    :type: float
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    color_highlight: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    group: 'GizmoGroup' = None
    ''' Gizmo group this gizmo is a member of

    :type: 'GizmoGroup'
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    hide_keymap: bool = None
    ''' Ignore the key-map for this gizmo

    :type: bool
    '''

    hide_select: bool = None
    ''' 

    :type: bool
    '''

    is_highlight: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_modal: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    line_width: float = None
    ''' 

    :type: float
    '''

    matrix_basis: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_offset: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_space: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_world: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    properties: 'GizmoProperties' = None
    ''' 

    :type: 'GizmoProperties'
    '''

    scale_basis: float = None
    ''' 

    :type: float
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_bias: float = None
    ''' Depth bias used for selection

    :type: float
    '''

    use_draw_hover: bool = None
    ''' 

    :type: bool
    '''

    use_draw_modal: bool = None
    ''' Show while dragging

    :type: bool
    '''

    use_draw_offset_scale: bool = None
    ''' Scale the offset matrix (use to apply screen-space offset)

    :type: bool
    '''

    use_draw_scale: bool = None
    ''' Use scale when calculating the matrix

    :type: bool
    '''

    use_draw_value: bool = None
    ''' Show an indicator for the current value while dragging

    :type: bool
    '''

    use_event_handle_all: bool = None
    ''' When highlighted, do not pass events through to be handled by other keymaps

    :type: bool
    '''

    use_grab_cursor: bool = None
    ''' 

    :type: bool
    '''

    use_operator_tool_properties: bool = None
    ''' Merge active tool properties on activation (does not overwrite existing)

    :type: bool
    '''

    use_select_background: bool = None
    ''' Don't write into the depth buffer

    :type: bool
    '''

    use_tooltip: bool = None
    ''' Use tooltips when hovering over this gizmo

    :type: bool
    '''

    def draw(self, context: 'Context'):
        ''' 

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_select(self,
                    context: 'Context',
                    select_id: typing.Optional[typing.Any] = 0):
        ''' 

        :param context: 
        :type context: 'Context'
        :param select_id: 
        :type select_id: typing.Optional[typing.Any]
        '''
        pass

    def test_select(self, context: 'Context', location: typing.Any) -> int:
        ''' 

        :param context: 
        :type context: 'Context'
        :param location: Location, Region coordinates
        :type location: typing.Any
        :rtype: int
        :return: Use -1 to skip this gizmo
        '''
        pass

    def modal(self, context: 'Context', event: 'Event', tweak: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]]
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' 

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :param tweak: Tweak
        :type tweak: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result
        '''
        pass

    def setup(self):
        ''' 

        '''
        pass

    def invoke(self, context: 'Context', event: 'Event'
               ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' 

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result
        '''
        pass

    def exit(self, context: 'Context', cancel: typing.Optional[bool]):
        ''' 

        :param context: 
        :type context: 'Context'
        :param cancel: Cancel, otherwise confirm
        :type cancel: typing.Optional[bool]
        '''
        pass

    def select_refresh(self):
        ''' 

        '''
        pass

    def draw_preset_box(
            self,
            matrix: typing.Optional[typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']],
            select_id: typing.Optional[typing.Any] = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        '''
        pass

    def draw_preset_arrow(
            self,
            matrix: typing.Optional[typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']],
            axis: typing.Optional[typing.Union[str, int]] = 'POS_Z',
            select_id: typing.Optional[typing.Any] = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Union[str, int]]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        '''
        pass

    def draw_preset_circle(
            self,
            matrix: typing.Optional[typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']],
            axis: typing.Optional[typing.Union[str, int]] = 'POS_Z',
            select_id: typing.Optional[typing.Any] = -1):
        ''' Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Union[str, int]]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        '''
        pass

    def target_set_prop(self,
                        target: typing.Union[str, typing.Any],
                        data: typing.Any,
                        property: typing.Union[str, typing.Any],
                        index: typing.Optional[typing.Any] = -1):
        ''' 

        :param target: Target property
        :type target: typing.Union[str, typing.Any]
        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param index: 
        :type index: typing.Optional[typing.Any]
        '''
        pass

    def target_set_operator(
            self,
            operator: typing.Union[str, typing.Any],
            index: typing.Optional[typing.Any] = 0) -> 'OperatorProperties':
        ''' Operator to run when activating the gizmo (overrides property targets)

        :param operator: Target operator
        :type operator: typing.Union[str, typing.Any]
        :param index: Part index
        :type index: typing.Optional[typing.Any]
        :rtype: 'OperatorProperties'
        :return: Operator properties to fill in
        '''
        pass

    def target_is_valid(self, property: typing.Union[str, typing.Any]) -> bool:
        ''' 

        :param property: Property identifier
        :type property: typing.Union[str, typing.Any]
        :rtype: bool
        '''
        pass

    def draw_custom_shape(
            self,
            shape: typing.Optional[typing.Any],
            *,
            matrix: typing.Optional[typing.Union[typing.Sequence[float],
                                                 'mathutils.Matrix']] = None,
            select_id: typing.Optional[typing.Any] = None):
        ''' Draw a shape created form `Gizmo.draw_custom_shape`.

        :param shape: The cached shape to draw.
        :type shape: typing.Optional[typing.Any]
        :param matrix: `Gizmo.matrix_world` is used.
        :type matrix: typing.Optional[typing.Union[typing.Sequence[float], 'mathutils.Matrix']]
        :param select_it: 
        :type select_it: typing.Optional[int]
        :param select_id:  The selection id. Only use when drawing within `Gizmo.draw_select`.
        :type select_id: typing.Optional[typing.Any]
        '''
        pass

    @staticmethod
    def new_custom_shape(type: typing.Optional[str],
                         verts: typing.Optional[typing.List]) -> typing.Any:
        ''' Create a new shape that can be passed to `Gizmo.draw_custom_shape`.

        :param type: The type of shape to create in (POINTS, LINES, TRIS, LINE_STRIP).
        :type type: typing.Optional[str]
        :param verts: Coordinates.
        :type verts: typing.Optional[typing.List]
        :param display_name: Optional callback that takes the full path, returns the name to display.
        :type display_name: typing.Optional[typing.Callable]
        :rtype: typing.Any
        :return: The newly created shape.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    def target_get_range(self,
                         target: typing.Optional[typing.Any]) -> typing.Tuple:
        ''' Get the range for this target property.

        :param target:  Target property name.
        :type target: typing.Optional[typing.Any]
        :rtype: typing.Tuple
        :return: The range of this property (min, max).
        '''
        pass

    def target_get_value(self, target: typing.Optional[str]) -> typing.List:
        ''' Get the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :rtype: typing.List
        :return: The value of the target property.
        '''
        pass

    def target_set_handler(self,
                           target: typing.Optional[str],
                           get: typing.Optional[typing.Callable],
                           set: typing.Optional[typing.Callable],
                           range: typing.Optional[typing.Callable] = None):
        ''' Assigns callbacks to a gizmos property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :param get: Function that returns the value for this property (single value or sequence).
        :type get: typing.Optional[typing.Callable]
        :param set: Function that takes a single value argument and applies it.
        :type set: typing.Optional[typing.Callable]
        :param range: Function that returns a (min, max) tuple for gizmos that use a range.
        :type range: typing.Optional[typing.Callable]
        '''
        pass

    def target_set_value(self, target: typing.Optional[str]):
        ''' Set the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        '''
        pass


class GizmoGroup(bpy_struct):
    ''' Storage of an operator being executed, or registered after execution
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * ``3D`` 3D -- Use in 3D viewport. * ``SCALE`` Scale -- Scale to respect zoom (otherwise zoom independent display size). * ``DEPTH_3D`` Depth 3D -- Supports culled depth by other objects in the view. * ``SELECT`` Select -- Supports selection. * ``PERSISTENT`` Persistent. * ``SHOW_MODAL_ALL`` Show Modal All -- Show all while interacting, as well as this group when another is being interacted with. * ``EXCLUDE_MODAL`` Exclude Modal -- Show all except this group while interacting. * ``TOOL_INIT`` Tool Init -- Postpone running until tool operator run (when used with a tool). * ``TOOL_FALLBACK_KEYMAP`` Use fallback tools keymap -- Add fallback tools keymap to this gizmo type. * ``VR_REDRAWS`` VR Redraws -- The gizmos are made for use with virtual reality sessions and require special redraw management.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_owner_id: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    gizmos: 'Gizmos' = None
    ''' List of gizmos in the Gizmo Map

    :type: 'Gizmos'
    '''

    has_reports: typing.Union[bool, typing.Any] = None
    ''' GizmoGroup has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Test if the gizmo group can be called or not

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    @classmethod
    def setup_keymap(cls, keyconfig: 'KeyConfig') -> 'KeyMap':
        ''' Initialize keymaps for this gizmo group, use fallback keymap when not present

        :param keyconfig: 
        :type keyconfig: 'KeyConfig'
        :rtype: 'KeyMap'
        '''
        pass

    def setup(self, context: 'Context'):
        ''' Create gizmos function for the gizmo group

        :param context: 
        :type context: 'Context'
        '''
        pass

    def refresh(self, context: 'Context'):
        ''' Refresh data (called on common state changes such as selection)

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_prepare(self, context: 'Context'):
        ''' Run before each redraw

        :param context: 
        :type context: 'Context'
        '''
        pass

    def invoke_prepare(self, context: 'Context', gizmo: 'Gizmo'):
        ''' Run before invoke

        :param context: 
        :type context: 'Context'
        :param gizmo: 
        :type gizmo: 'Gizmo'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GizmoGroupProperties(bpy_struct):
    ''' Input properties of a Gizmo Group
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GizmoProperties(bpy_struct):
    ''' Input properties of a Gizmo
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GpencilModifier(bpy_struct):
    ''' Modifier affecting the Grease Pencil object
    '''

    is_override_data: typing.Union[bool, typing.Any] = None
    ''' In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Modifier name

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Set modifier expanded in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display modifier in Edit mode

    :type: bool
    '''

    show_render: bool = None
    ''' Use modifier during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display modifier in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GpencilVertexGroupElement(bpy_struct):
    ''' Weight value of a vertex in a vertex group
    '''

    group: int = None
    ''' 

    :type: int
    '''

    weight: float = None
    ''' Vertex Weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class GreasePencilGrid(bpy_struct):
    ''' Settings for grid and canvas in 3D viewport
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color for grid lines

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    lines: int = None
    ''' Number of subdivisions in each side of symmetry line

    :type: int
    '''

    offset: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' Offset of the canvas

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    scale: typing.Union[typing.List[float], typing.
                        Tuple[float, float], 'mathutils.Vector'] = None
    ''' Grid scale

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Header(bpy_struct):
    ''' Editor header containing UI elements
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the panel; for example, if the class name is "OBJECT_HT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_HT_hello"

    :type: typing.Union[str, typing.Any]
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the header is going to be used in (defaults to header region)

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the header is going to be used in

    :type: typing.Union[str, int]
    '''

    layout: 'UILayout' = None
    ''' Structure of the header in the UI

    :type: 'UILayout'
    '''

    def draw(self, context: typing.Optional['Context']):
        ''' Draw UI elements into the header UI layout

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Histogram(bpy_struct):
    ''' Statistical view of the levels of color in an image
    '''

    mode: typing.Union[str, int] = None
    ''' Channels to display in the histogram * ``LUMA`` Luma -- Luma. * ``RGB`` RGB -- Red Green Blue. * ``R`` R -- Red. * ``G`` G -- Green. * ``B`` B -- Blue. * ``A`` A -- Alpha.

    :type: typing.Union[str, int]
    '''

    show_line: bool = None
    ''' Display lines rather than filled shapes

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ID(bpy_struct):
    ''' Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection
    '''

    asset_data: 'AssetMetaData' = None
    ''' Additional data for an asset data-block

    :type: 'AssetMetaData'
    '''

    is_embedded_data: typing.Union[bool, typing.Any] = None
    ''' This data-block is not an independent one, but is actually a sub-data of another ID (typical example: root node trees or master collections)

    :type: typing.Union[bool, typing.Any]
    '''

    is_evaluated: typing.Union[bool, typing.Any] = None
    ''' Whether this ID is runtime-only, evaluated data-block, or actual data from .blend file

    :type: typing.Union[bool, typing.Any]
    '''

    is_library_indirect: typing.Union[bool, typing.Any] = None
    ''' Is this ID block linked indirectly

    :type: typing.Union[bool, typing.Any]
    '''

    is_missing: typing.Union[bool, typing.Any] = None
    ''' This data-block is a place-holder for missing linked data (i.e. it is [an override of] a linked data that could not be found anymore)

    :type: typing.Union[bool, typing.Any]
    '''

    is_runtime_data: bool = None
    ''' This data-block is runtime data, i.e. it won't be saved in .blend file. Note that e.g. evaluated IDs are always runtime, so this value is only editable for data-blocks in Main data-base

    :type: bool
    '''

    library: 'Library' = None
    ''' Library file the data-block is linked from

    :type: 'Library'
    '''

    library_weak_reference: 'LibraryWeakReference' = None
    ''' Weak reference to a data-block in another library .blend file (used to re-use already appended data instead of appending new copies)

    :type: 'LibraryWeakReference'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique data-block ID name

    :type: typing.Union[str, typing.Any]
    '''

    name_full: typing.Union[str, typing.Any] = None
    ''' Unique data-block ID name, including library one is any

    :type: typing.Union[str, typing.Any]
    '''

    original: 'ID' = None
    ''' Actual data-block from .blend file (Main database) that generated that evaluated one

    :type: 'ID'
    '''

    override_library: 'IDOverrideLibrary' = None
    ''' Library override data

    :type: 'IDOverrideLibrary'
    '''

    preview: 'ImagePreview' = None
    ''' Preview image and icon of this data-block (always None if not supported for this type of data)

    :type: 'ImagePreview'
    '''

    tag: bool = None
    ''' Tools can use this to tag data for their own purposes (initial state is undefined)

    :type: bool
    '''

    use_extra_user: bool = None
    ''' Indicates whether an extra user is set or not (mainly for internal/debug usages)

    :type: bool
    '''

    use_fake_user: bool = None
    ''' Save this data-block even if it has no users

    :type: bool
    '''

    users: int = None
    ''' Number of times this data-block is referenced

    :type: int
    '''

    def evaluated_get(self, depsgraph: 'Depsgraph') -> 'ID':
        ''' Get corresponding evaluated ID from the given dependency graph

        :param depsgraph: Dependency graph to perform lookup in
        :type depsgraph: 'Depsgraph'
        :rtype: 'ID'
        :return: New copy of the ID
        '''
        pass

    def copy(self) -> 'ID':
        ''' Create a copy of this data-block (not supported for all data-blocks). The result is added to the Blend-File Data (Main database), with all references to other data-blocks ensured to be from within the same Blend-File Data

        :rtype: 'ID'
        :return: New copy of the ID
        '''
        pass

    def asset_mark(self):
        ''' Enable easier reuse of the data-block through the Asset Browser, with the help of customizable metadata (like previews, descriptions and tags)

        '''
        pass

    def asset_clear(self):
        ''' Delete all asset metadata and turn the asset data-block back into a normal data-block

        '''
        pass

    def asset_generate_preview(self):
        ''' Generate preview image (might be scheduled in a background thread)

        '''
        pass

    def override_create(self,
                        remap_local_usages: typing.Optional[
                            typing.Union[bool, typing.Any]] = False) -> 'ID':
        ''' Create an overridden local copy of this linked data-block (not supported for all data-blocks)

        :param remap_local_usages: Whether local usages of the linked ID should be remapped to the new library override of it
        :type remap_local_usages: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the ID
        '''
        pass

    def override_hierarchy_create(
            self,
            scene: 'Scene',
            view_layer: 'ViewLayer',
            reference: typing.Optional['ID'] = None,
            do_fully_editable: typing.Optional[
                typing.Union[bool, typing.Any]] = False) -> 'ID':
        ''' Create an overridden local copy of this linked data-block, and most of its dependencies when it is a Collection or and Object

        :param scene: In which scene the new overrides should be instantiated
        :type scene: 'Scene'
        :param view_layer: In which view layer the new overrides should be instantiated
        :type view_layer: 'ViewLayer'
        :param reference: Another ID (usually an Object or Collection) used as a hint to decide where to instantiate the new overrides
        :type reference: typing.Optional['ID']
        :param do_fully_editable: Make all library overrides generated by this call fully editable by the user (none will be 'system overrides')
        :type do_fully_editable: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the root ID
        '''
        pass

    def override_template_create(self):
        ''' Create an override template for this ID

        '''
        pass

    def user_clear(self):
        ''' Clear the user count of a data-block so its not saved, on reload the data will be removed This function is for advanced use only, misuse can crash blender since the user count is used to prevent data being removed when it is used.

        '''
        pass

    def user_remap(self, new_id: 'ID'):
        ''' Replace all usage in the .blend file of this ID by new given one

        :param new_id: New ID to use
        :type new_id: 'ID'
        '''
        pass

    def make_local(
            self,
            clear_proxy: typing.Optional[typing.Union[bool, typing.Any]] = True
    ) -> 'ID':
        ''' Make this datablock local, return local one (may be a copy of the original, in case it is also indirectly used)

        :param clear_proxy: Deprecated, has no effect
        :type clear_proxy: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: This ID, or the new ID if it was copied
        '''
        pass

    def user_of_id(self, id: 'ID') -> int:
        ''' Count the number of times that ID uses/references given one

        :param id: ID to count usages
        :type id: 'ID'
        :rtype: int
        :return: Number of usages/references of given id by current data-block
        '''
        pass

    def animation_data_create(self) -> 'AnimData':
        ''' Create animation data to this ID, note that not all ID types support this

        :rtype: 'AnimData'
        :return: New animation data or nullptr
        '''
        pass

    def animation_data_clear(self):
        ''' Clear animation on this ID

        '''
        pass

    def update_tag(self, refresh: typing.Optional[typing.Any] = {}):
        ''' Tag the ID to update its display data, e.g. when calling `bpy.types.Scene.update`

        :param refresh: Type of updates to perform
        :type refresh: typing.Optional[typing.Any]
        '''
        pass

    def preview_ensure(self) -> 'ImagePreview':
        ''' Ensure that this ID has preview data (if ID type supports it)

        :rtype: 'ImagePreview'
        :return: The existing or created preview
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibrary(bpy_struct):
    ''' Struct gathering all data needed by overridden linked IDs
    '''

    hierarchy_root: 'ID' = None
    ''' Library override ID used as root of the override hierarchy this ID is a member of

    :type: 'ID'
    '''

    is_in_hierarchy: bool = None
    ''' Whether this library override is defined as part of a library hierarchy, or as a single, isolated and autonomous override

    :type: bool
    '''

    is_system_override: bool = None
    ''' Whether this library override exists only for the override hierarchy, or if it is actually editable by the user

    :type: bool
    '''

    properties: 'IDOverrideLibraryProperties' = None
    ''' List of overridden properties

    :type: 'IDOverrideLibraryProperties'
    '''

    reference: 'ID' = None
    ''' Linked ID used as reference by this override

    :type: 'ID'
    '''

    def operations_update(self):
        ''' Update the library override operations based on the differences between this override ID and its reference

        '''
        pass

    def reset(self,
              do_hierarchy: typing.Optional[typing.Union[bool, typing.
                                                         Any]] = True,
              set_system_override: typing.Optional[typing.Union[bool, typing.
                                                                Any]] = False):
        ''' Reset this override to match again its linked reference ID

        :param do_hierarchy: Also reset all the dependencies of this override to match their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :param set_system_override: Reset all user-editable overrides as (non-editable) system overrides
        :type set_system_override: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def destroy(self,
                do_hierarchy: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = True):
        ''' Delete this override ID and remap its usages to its linked reference ID instead

        :param do_hierarchy: Also delete all the dependencies of this override and remap their usages to their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def resync(self,
               scene: 'Scene',
               view_layer: typing.Optional['ViewLayer'] = None,
               residual_storage: typing.Optional['Collection'] = None,
               do_hierarchy_enforce: typing.Optional[
                   typing.Union[bool, typing.Any]] = False,
               do_whole_hierarchy: typing.Optional[
                   typing.Union[bool, typing.Any]] = False) -> bool:
        ''' Resync the data-block and its sub-hierarchy, or the whole hierarchy if requested

        :param scene: The scene to operate in (for contextual things like keeping active object active, ensuring all overridden objects remain instantiated, etc.)
        :type scene: 'Scene'
        :param view_layer: The view layer to operate in (same usage as the `scene` data, in case it is not provided the scene's collection will be used instead)
        :type view_layer: typing.Optional['ViewLayer']
        :param residual_storage: Collection where to store objects that are instantiated in any other collection anymore (garbage collection, will be created if needed and none is provided)
        :type residual_storage: typing.Optional['Collection']
        :param do_hierarchy_enforce: if some ID pointers have been purposedly overridden, these will be reset to their default value)
        :type do_hierarchy_enforce: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_whole_hierarchy: Resync the whole hierarchy this data-block belongs to, not only its own sub-hierarchy
        :type do_whole_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bool
        :return: Success, Whether the resync process was successful or not
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryProperty(bpy_struct):
    ''' Description of an overridden property
    '''

    operations: 'IDOverrideLibraryPropertyOperations' = None
    ''' List of overriding operations for a property

    :type: 'IDOverrideLibraryPropertyOperations'
    '''

    rna_path: typing.Union[str, typing.Any] = None
    ''' RNA path leading to that property, from owning ID

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IDOverrideLibraryPropertyOperation(bpy_struct):
    ''' Description of an override operation over an overridden property
    '''

    flag: typing.Any = None
    ''' Status flags * ``MANDATORY`` Mandatory -- For templates, prevents the user from removing predefined operation (NOT USED). * ``LOCKED`` Locked -- Prevents the user from modifying that override operation (NOT USED). * ``IDPOINTER_MATCH_REFERENCE`` Match Reference -- The ID pointer overridden by this operation is expected to match the reference hierarchy. * ``IDPOINTER_ITEM_USE_ID`` ID Item Use ID Pointer -- RNA collections of IDs only, the reference to the item also uses the ID pointer itself, not only its name.

    :type: typing.Any
    '''

    operation: typing.Union[str, int] = None
    ''' What override operation is performed * ``NOOP`` No-Op -- Does nothing, prevents adding actual overrides (NOT USED). * ``REPLACE`` Replace -- Replace value of reference by overriding one. * ``DIFF_ADD`` Differential -- Stores and apply difference between reference and local value (NOT USED). * ``DIFF_SUB`` Differential -- Stores and apply difference between reference and local value (NOT USED). * ``FACT_MULTIPLY`` Factor -- Stores and apply multiplication factor between reference and local value (NOT USED). * ``INSERT_AFTER`` Insert After -- Insert a new item into collection after the one referenced in subitem_reference_name/_id or _index. * ``INSERT_BEFORE`` Insert Before -- Insert a new item into collection before the one referenced in subitem_reference_name/_id or _index (NOT USED).

    :type: typing.Union[str, int]
    '''

    subitem_local_id: 'ID' = None
    ''' Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    '''

    subitem_local_index: int = None
    ''' Used to handle changes into collection

    :type: int
    '''

    subitem_local_name: typing.Union[str, typing.Any] = None
    ''' Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    '''

    subitem_reference_id: 'ID' = None
    ''' Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    '''

    subitem_reference_index: int = None
    ''' Used to handle changes into collection

    :type: int
    '''

    subitem_reference_name: typing.Union[str, typing.Any] = None
    ''' Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IDPropertyWrapPtr(bpy_struct):
    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IKParam(bpy_struct):
    ''' Base type for IK solver parameters
    '''

    ik_solver: typing.Union[str, int] = None
    ''' IK solver for which these parameters are defined * ``LEGACY`` Standard -- Original IK solver. * ``ITASC`` iTaSC -- Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ImageFormatSettings(bpy_struct):
    ''' Settings for image formats
    '''

    cineon_black: int = None
    ''' Log conversion reference blackpoint

    :type: int
    '''

    cineon_gamma: float = None
    ''' Log conversion gamma

    :type: float
    '''

    cineon_white: int = None
    ''' Log conversion reference whitepoint

    :type: int
    '''

    color_depth: typing.Union[str, int] = None
    ''' Bit depth per channel

    :type: typing.Union[str, int]
    '''

    color_management: typing.Union[str, int] = None
    ''' Which color management settings to use for file saving

    :type: typing.Union[str, int]
    '''

    color_mode: typing.Union[str, int] = None
    ''' Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels

    :type: typing.Union[str, int]
    '''

    compression: int = None
    ''' Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output

    :type: int
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    ''' Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    '''

    exr_codec: typing.Union[str, int] = None
    ''' Codec settings for OpenEXR

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    ''' File format to save the rendered images as

    :type: typing.Union[str, int]
    '''

    has_linear_colorspace: typing.Union[bool, typing.Any] = None
    ''' File format expects linear color space

    :type: typing.Union[bool, typing.Any]
    '''

    jpeg2k_codec: typing.Union[str, int] = None
    ''' Codec settings for JPEG 2000

    :type: typing.Union[str, int]
    '''

    linear_colorspace_settings: 'ColorManagedInputColorspaceSettings' = None
    ''' Output color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    '''

    quality: int = None
    ''' Quality for image formats that support lossy compression

    :type: int
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    ''' Settings for stereo 3D

    :type: 'Stereo3dFormat'
    '''

    tiff_codec: typing.Union[str, int] = None
    ''' Compression mode for TIFF

    :type: typing.Union[str, int]
    '''

    use_cineon_log: bool = None
    ''' Convert to logarithmic color space

    :type: bool
    '''

    use_jpeg2k_cinema_48: bool = None
    ''' Use OpenJPEG Cinema Preset (48fps)

    :type: bool
    '''

    use_jpeg2k_cinema_preset: bool = None
    ''' Use OpenJPEG Cinema Preset

    :type: bool
    '''

    use_jpeg2k_ycc: bool = None
    ''' Save luminance-chrominance-chrominance channels instead of RGB colors

    :type: bool
    '''

    use_preview: bool = None
    ''' When rendering animations, save JPG preview images in same directory

    :type: bool
    '''

    view_settings: 'ColorManagedViewSettings' = None
    ''' Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    '''

    views_format: typing.Union[str, int] = None
    ''' Format of multiview media

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ImagePackedFile(bpy_struct):
    filepath: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    tile_number: int = None
    ''' 

    :type: int
    '''

    view: int = None
    ''' 

    :type: int
    '''

    def save(self):
        ''' Save the packed file to its filepath

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ImagePreview(bpy_struct):
    ''' Preview image and icon
    '''

    icon_id: int = None
    ''' Unique integer identifying this preview as an icon (zero means invalid)

    :type: int
    '''

    icon_pixels: int = None
    ''' Icon pixels, as bytes (always 32-bit RGBA)

    :type: int
    '''

    icon_pixels_float: float = None
    ''' Icon pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    icon_size: bpy_prop_array[int] = None
    ''' Width and height in pixels

    :type: bpy_prop_array[int]
    '''

    image_pixels: int = None
    ''' Image pixels, as bytes (always 32-bit RGBA)

    :type: int
    '''

    image_pixels_float: float = None
    ''' Image pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    image_size: bpy_prop_array[int] = None
    ''' Width and height in pixels

    :type: bpy_prop_array[int]
    '''

    is_icon_custom: bool = None
    ''' True if this preview icon has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    '''

    is_image_custom: bool = None
    ''' True if this preview image has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    '''

    def reload(self):
        ''' Reload the preview from its source path

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ImageUser(bpy_struct):
    ''' Parameters defining how an Image data-block is used by another data-block
    '''

    frame_current: int = None
    ''' Current frame number in image sequence or movie

    :type: int
    '''

    frame_duration: int = None
    ''' Number of images of a movie to use

    :type: int
    '''

    frame_offset: int = None
    ''' Offset the number of the frame to use in the animation

    :type: int
    '''

    frame_start: int = None
    ''' Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    '''

    multilayer_layer: int = None
    ''' Layer in multilayer image

    :type: int
    '''

    multilayer_pass: int = None
    ''' Pass in multilayer image

    :type: int
    '''

    multilayer_view: int = None
    ''' View in multilayer image

    :type: int
    '''

    tile: int = None
    ''' Tile in tiled image

    :type: int
    '''

    use_auto_refresh: bool = None
    ''' Always refresh image on frame changes

    :type: bool
    '''

    use_cyclic: bool = None
    ''' Cycle the images in the movie

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Int2AttributeValue(bpy_struct):
    ''' 2D value in geometry attribute
    '''

    value: bpy_prop_array[int] = None
    ''' 2D vector

    :type: bpy_prop_array[int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class IntAttributeValue(bpy_struct):
    ''' Integer value in geometry attribute
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyConfig(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    is_user_defined: typing.Union[bool, typing.Any] = None
    ''' Indicates that a keyconfig was defined by the user

    :type: typing.Union[bool, typing.Any]
    '''

    keymaps: 'KeyMaps' = None
    ''' Key maps configured as part of this configuration

    :type: 'KeyMaps'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the key configuration

    :type: typing.Union[str, typing.Any]
    '''

    preferences: 'KeyConfigPreferences' = None
    ''' 

    :type: 'KeyConfigPreferences'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyConfigPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyMap(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    bl_owner_id: typing.Union[str, typing.Any] = None
    ''' Internal owner

    :type: typing.Union[str, typing.Any]
    '''

    is_modal: typing.Union[bool, typing.Any] = None
    ''' Indicates that a keymap is used for translate modal events for an operator

    :type: typing.Union[bool, typing.Any]
    '''

    is_user_modified: bool = None
    ''' Keymap is defined by the user

    :type: bool
    '''

    keymap_items: 'KeyMapItems' = None
    ''' Items in the keymap, linking an operator to an input event

    :type: 'KeyMapItems'
    '''

    modal_event_values: bpy_prop_collection['EnumPropertyItem'] = None
    ''' Give access to the possible event values of this modal keymap's items (#KeyMapItem.propvalue), for API introspection

    :type: bpy_prop_collection['EnumPropertyItem']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the key map

    :type: typing.Union[str, typing.Any]
    '''

    region_type: typing.Union[str, int] = None
    ''' Optional region type keymap is associated with

    :type: typing.Union[str, int]
    '''

    show_expanded_children: bool = None
    ''' Children expanded in the user interface

    :type: bool
    '''

    show_expanded_items: bool = None
    ''' Expanded in the user interface

    :type: bool
    '''

    space_type: typing.Union[str, int] = None
    ''' Optional space type keymap is associated with

    :type: typing.Union[str, int]
    '''

    def active(self) -> 'KeyMap':
        ''' active

        :rtype: 'KeyMap'
        :return: Key Map, Active key map
        '''
        pass

    def restore_to_default(self):
        ''' restore_to_default

        '''
        pass

    def restore_item_to_default(self, item: 'KeyMapItem'):
        ''' restore_item_to_default

        :param item: Item
        :type item: 'KeyMapItem'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyMapItem(bpy_struct):
    ''' Item in a Key Map
    '''

    active: bool = None
    ''' Activate or deactivate item

    :type: bool
    '''

    alt: int = None
    ''' Alt key pressed, -1 for any state

    :type: int
    '''

    alt_ui: bool = None
    ''' Alt key pressed

    :type: bool
    '''

    any: bool = None
    ''' Any modifier keys pressed

    :type: bool
    '''

    ctrl: int = None
    ''' Control key pressed, -1 for any state

    :type: int
    '''

    ctrl_ui: bool = None
    ''' Control key pressed

    :type: bool
    '''

    direction: typing.Union[str, int] = None
    ''' The direction (only applies to drag events)

    :type: typing.Union[str, int]
    '''

    id: int = None
    ''' ID of the item

    :type: int
    '''

    idname: typing.Union[str, typing.Any] = None
    ''' Identifier of operator to call on input event

    :type: typing.Union[str, typing.Any]
    '''

    is_user_defined: typing.Union[bool, typing.Any] = None
    ''' Is this keymap item user defined (doesn't just replace a builtin item)

    :type: typing.Union[bool, typing.Any]
    '''

    is_user_modified: typing.Union[bool, typing.Any] = None
    ''' Is this keymap item modified by the user

    :type: typing.Union[bool, typing.Any]
    '''

    key_modifier: typing.Union[str, int] = None
    ''' Regular key pressed as a modifier

    :type: typing.Union[str, int]
    '''

    map_type: typing.Union[str, int] = None
    ''' Type of event mapping

    :type: typing.Union[str, int]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of operator (translated) to call on input event

    :type: typing.Union[str, typing.Any]
    '''

    oskey: int = None
    ''' Operating system key pressed, -1 for any state

    :type: int
    '''

    oskey_ui: bool = None
    ''' Operating system key pressed

    :type: bool
    '''

    properties: 'OperatorProperties' = None
    ''' Properties to set when the operator is called

    :type: 'OperatorProperties'
    '''

    propvalue: typing.Union[str, int] = None
    ''' The value this event translates to in a modal keymap

    :type: typing.Union[str, int]
    '''

    repeat: bool = None
    ''' Active on key-repeat events (when a key is held)

    :type: bool
    '''

    shift: int = None
    ''' Shift key pressed, -1 for any state

    :type: int
    '''

    shift_ui: bool = None
    ''' Shift key pressed

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show key map event and property details in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of event

    :type: typing.Union[str, int]
    '''

    value: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    def compare(self, item: typing.Optional['KeyMapItem']) -> bool:
        ''' compare

        :param item: Item
        :type item: typing.Optional['KeyMapItem']
        :rtype: bool
        :return: Comparison result
        '''
        pass

    def to_string(
            self,
            compact: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> typing.Union[str, typing.Any]:
        ''' to_string

        :param compact: Compact
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[str, typing.Any]
        :return: result
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Keyframe(bpy_struct):
    ''' Bezier curve point with two handles defining a Keyframe on an F-Curve
    '''

    amplitude: float = None
    ''' Amount to boost elastic bounces for 'elastic' easing

    :type: float
    '''

    back: float = None
    ''' Amount of overshoot for 'back' easing

    :type: float
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    co_ui: typing.Union[typing.List[float], typing.
                        Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the control point. Note: Changing this value also updates the handles similar to using the graph editor transform operator

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    easing: typing.Union[str, int] = None
    ''' Which ends of the segment between this and the next keyframe easing interpolation is applied to

    :type: typing.Union[str, int]
    '''

    handle_left: typing.Union[typing.List[float], typing.
                              Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the left handle (before the control point)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    handle_right: typing.Union[typing.List[float], typing.
                               Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the right handle (after the control point)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe

    :type: typing.Union[str, int]
    '''

    period: float = None
    ''' Time between bounces for elastic easing

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Left handle selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Right handle selection status

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of keyframe (for visual purposes only)

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyingSet(bpy_struct):
    ''' Settings that should be keyframed together
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' A short description of the keying set

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    is_path_absolute: typing.Union[bool, typing.Any] = None
    ''' Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info)

    :type: typing.Union[bool, typing.Any]
    '''

    paths: 'KeyingSetPaths' = None
    ''' Keying Set Paths to define settings that get keyframed together

    :type: 'KeyingSetPaths'
    '''

    type_info: 'KeyingSetInfo' = None
    ''' Callback function defines for built-in Keying Sets

    :type: 'KeyingSetInfo'
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''

    def refresh(self):
        ''' Refresh Keying Set to ensure that it is valid for the current context (call before each use of one)

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyingSetInfo(bpy_struct):
    ''' Callback function defines for builtin Keying Sets
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' A short description of the keying set

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Keying Set options to use when inserting keyframes

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    def poll(self, context: typing.Optional['Context']) -> bool:
        ''' Test if Keying Set can be used or not

        :param context: 
        :type context: typing.Optional['Context']
        :rtype: bool
        '''
        pass

    def iterator(self, context: typing.Optional['Context'],
                 ks: typing.Optional['KeyingSet']):
        ''' Call generate() on the structs which have properties to be keyframed

        :param context: 
        :type context: typing.Optional['Context']
        :param ks: 
        :type ks: typing.Optional['KeyingSet']
        '''
        pass

    def generate(self, context: typing.Optional['Context'],
                 ks: typing.Optional['KeyingSet'], data: typing.Any):
        ''' Add Paths to the Keying Set to keyframe the properties of the given data

        :param context: 
        :type context: typing.Optional['Context']
        :param ks: 
        :type ks: typing.Optional['KeyingSet']
        :param data: 
        :type data: typing.Any
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class KeyingSetPath(bpy_struct):
    ''' Path to a setting for use in a Keying Set
    '''

    array_index: int = None
    ''' Index to the specific setting if applicable

    :type: int
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' Path to property setting

    :type: typing.Union[str, typing.Any]
    '''

    group: typing.Union[str, typing.Any] = None
    ''' Name of Action Group to assign setting(s) for this path to

    :type: typing.Union[str, typing.Any]
    '''

    group_method: typing.Union[str, int] = None
    ''' Method used to define which Group-name to use

    :type: typing.Union[str, int]
    '''

    id: 'ID' = None
    ''' ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    use_entire_array: bool = None
    ''' When an 'array/vector' type is chosen (Location, Rotation, Color, etc.), entire array is to be used

    :type: bool
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class LatticePoint(bpy_struct):
    ''' Point in the lattice grid
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    co_deform: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    groups: bpy_prop_collection['VertexGroupElement'] = None
    ''' Weights for the vertex groups this point is member of

    :type: bpy_prop_collection['VertexGroupElement']
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class LayerCollection(bpy_struct):
    ''' Layer collection
    '''

    children: bpy_prop_collection['LayerCollection'] = None
    ''' Layer collection children

    :type: bpy_prop_collection['LayerCollection']
    '''

    collection: 'Collection' = None
    ''' Collection this layer collection is wrapping

    :type: 'Collection'
    '''

    exclude: bool = None
    ''' Exclude from view layer

    :type: bool
    '''

    hide_viewport: bool = None
    ''' Temporarily hide in viewport

    :type: bool
    '''

    holdout: bool = None
    ''' Mask out objects in collection from view layer

    :type: bool
    '''

    indirect_only: bool = None
    ''' Objects in collection only contribute indirectly (through shadows and reflections) in the view layer

    :type: bool
    '''

    is_visible: typing.Union[bool, typing.Any] = None
    ''' Whether this collection is visible for the view layer, take into account the collection parent

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of this layer collection (same as its collection one)

    :type: typing.Union[str, typing.Any]
    '''

    def visible_get(self) -> bool:
        ''' Whether this collection is visible, take into account the collection parent and the viewport

        :rtype: bool
        '''
        pass

    def has_objects(self) -> bool:
        ''' 

        :rtype: bool
        '''
        pass

    def has_selected_objects(self,
                             view_layer: typing.Optional['ViewLayer']) -> bool:
        ''' 

        :param view_layer: View layer the layer collection belongs to
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class LibraryWeakReference(bpy_struct):
    ''' Read-only external reference to a linked data-block and its library file
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to the library .blend file

    :type: typing.Union[str, typing.Any]
    '''

    id_name: typing.Union[str, typing.Any] = None
    ''' Full ID name in the library .blend file (including the two leading 'id type' chars)

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Lightgroup(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' Name of the Lightgroup

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class LineStyleModifier(bpy_struct):
    ''' Base type to define modifiers
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Macro(bpy_struct):
    ''' Storage of a macro operator being executed, or registered after execution
    '''

    bl_cursor_pending: typing.Union[str, int] = None
    ''' Cursor to use when waiting for the user to select a location to activate the operator (when ``bl_options`` has ``DEPENDS_ON_CURSOR`` set)

    :type: typing.Union[str, int]
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_undo_group: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    has_reports: typing.Union[bool, typing.Any] = None
    ''' Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaskLayer(bpy_struct):
    ''' Single layer used for masking pixels
    '''

    alpha: float = None
    ''' Render Opacity

    :type: float
    '''

    blend: typing.Union[str, int] = None
    ''' Method of blending mask layers

    :type: typing.Union[str, int]
    '''

    falloff: typing.Union[str, int] = None
    ''' Falloff type the feather

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Restrict visibility in the viewport

    :type: bool
    '''

    hide_render: bool = None
    ''' Restrict renderability

    :type: bool
    '''

    hide_select: bool = None
    ''' Restrict selection in the viewport

    :type: bool
    '''

    invert: bool = None
    ''' Invert the mask black/white

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of layer

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    splines: 'MaskSplines' = None
    ''' Collection of splines which defines this layer

    :type: 'MaskSplines'
    '''

    use_fill_holes: bool = None
    ''' Calculate holes when filling overlapping curves

    :type: bool
    '''

    use_fill_overlap: bool = None
    ''' Calculate self intersections and overlap before filling

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaskParent(bpy_struct):
    ''' Parenting settings for masking element
    '''

    id: 'ID' = None
    ''' ID-block to which masking element would be parented to or to its property

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    parent: typing.Union[str, typing.Any] = None
    ''' Name of parent object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    '''

    sub_parent: typing.Union[str, typing.Any] = None
    ''' Name of parent sub-object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Parent Type

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaskSpline(bpy_struct):
    ''' Single spline used for defining mask shape
    '''

    offset_mode: typing.Union[str, int] = None
    ''' The method used for calculating the feather offset * ``EVEN`` Even -- Calculate even feather offset. * ``SMOOTH`` Smooth -- Calculate feather offset as a second curve.

    :type: typing.Union[str, int]
    '''

    points: 'MaskSplinePoints' = None
    ''' Collection of points

    :type: 'MaskSplinePoints'
    '''

    use_cyclic: bool = None
    ''' Make this spline a closed loop

    :type: bool
    '''

    use_fill: bool = None
    ''' Make this spline filled

    :type: bool
    '''

    use_self_intersection_check: bool = None
    ''' Prevent feather from self-intersections

    :type: bool
    '''

    weight_interpolation: typing.Union[str, int] = None
    ''' The type of weight interpolation for spline

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaskSplinePoint(bpy_struct):
    ''' Single point in spline used for defining mask
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    feather_points: bpy_prop_collection['MaskSplinePointUW'] = None
    ''' Points defining feather

    :type: bpy_prop_collection['MaskSplinePointUW']
    '''

    handle_left: typing.Union[typing.List[float], typing.
                              Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the first handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_right: typing.Union[typing.List[float], typing.
                               Tuple[float, float], 'mathutils.Vector'] = None
    ''' Coordinates of the second handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    parent: 'MaskParent' = None
    ''' 

    :type: 'MaskParent'
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight: float = None
    ''' Weight of the point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaskSplinePointUW(bpy_struct):
    ''' Single point in spline segment defining feather
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    u: float = None
    ''' U coordinate of point along spline segment

    :type: float
    '''

    weight: float = None
    ''' Weight of feather point

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaterialGPencilStyle(bpy_struct):
    alignment_mode: typing.Union[str, int] = None
    ''' Defines how align Dots and Boxes with drawing path and object rotation * ``PATH`` Path -- Follow stroke drawing path and object rotation. * ``OBJECT`` Object -- Follow object rotation only. * ``FIXED`` Fixed -- Do not follow drawing path or object rotation and keeps aligned with viewport.

    :type: typing.Union[str, int]
    '''

    alignment_rotation: float = None
    ''' Additional rotation applied to dots and square texture of strokes. Only applies in texture shading mode

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    fill_color: bpy_prop_array[float] = None
    ''' Color for filling region bounded by each stroke

    :type: bpy_prop_array[float]
    '''

    fill_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    fill_style: typing.Union[str, int] = None
    ''' Select style used to fill strokes * ``SOLID`` Solid -- Fill area with solid color. * ``GRADIENT`` Gradient -- Fill area with gradient color. * ``TEXTURE`` Texture -- Fill area with image texture.

    :type: typing.Union[str, int]
    '''

    flip: bool = None
    ''' Flip filling colors

    :type: bool
    '''

    ghost: bool = None
    ''' Display strokes using this color when showing onion skins

    :type: bool
    '''

    gradient_type: typing.Union[str, int] = None
    ''' Select type of gradient used to fill strokes * ``LINEAR`` Linear -- Fill area with gradient color. * ``RADIAL`` Radial -- Fill area with radial gradient.

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Set color Visibility

    :type: bool
    '''

    is_fill_visible: typing.Union[bool, typing.Any] = None
    ''' True when opacity of fill is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    '''

    is_stroke_visible: typing.Union[bool, typing.Any] = None
    ''' True when opacity of stroke is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    '''

    lock: bool = None
    ''' Protect color from further editing and/or frame changes

    :type: bool
    '''

    mix_color: bpy_prop_array[float] = None
    ''' Color for mixing with primary filling color

    :type: bpy_prop_array[float]
    '''

    mix_factor: float = None
    ''' Mix Factor

    :type: float
    '''

    mix_stroke_factor: float = None
    ''' Mix Stroke Factor

    :type: float
    '''

    mode: typing.Union[str, int] = None
    ''' Select line type for strokes * ``LINE`` Line -- Draw strokes using a continuous line. * ``DOTS`` Dots -- Draw strokes using separated dots. * ``BOX`` Squares -- Draw strokes using separated squares.

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    ''' Index number for the "Color Index" pass

    :type: int
    '''

    pixel_size: float = None
    ''' Texture Pixel Size factor along the stroke

    :type: float
    '''

    show_fill: bool = None
    ''' Show stroke fills of this material

    :type: bool
    '''

    show_stroke: bool = None
    ''' Show stroke lines of this material

    :type: bool
    '''

    stroke_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    stroke_style: typing.Union[str, int] = None
    ''' Select style used to draw strokes * ``SOLID`` Solid -- Draw strokes with solid color. * ``TEXTURE`` Texture -- Draw strokes using texture.

    :type: typing.Union[str, int]
    '''

    texture_angle: float = None
    ''' Texture Orientation Angle

    :type: float
    '''

    texture_clamp: bool = None
    ''' Do not repeat texture and clamp to one instance only

    :type: bool
    '''

    texture_offset: typing.Union[typing.List[float], typing.
                                 Tuple[float, float],
                                 'mathutils.Vector'] = None
    ''' Shift Texture in 2d Space

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    texture_scale: typing.Union[typing.List[float], typing.
                                Tuple[float, float], 'mathutils.Vector'] = None
    ''' Scale Factor for Texture

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    use_fill_holdout: bool = None
    ''' Remove the color from underneath this stroke by using it as a mask

    :type: bool
    '''

    use_overlap_strokes: bool = None
    ''' Disable stencil and overlap self intersections with alpha materials

    :type: bool
    '''

    use_stroke_holdout: bool = None
    ''' Remove the color from underneath this stroke by using it as a mask

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaterialLineArt(bpy_struct):
    intersection_priority: int = None
    ''' The intersection line will be included into the object with the higher intersection priority value

    :type: int
    '''

    mat_occlusion: int = None
    ''' Faces with this material will behave as if it has set number of layers in occlusion

    :type: int
    '''

    use_intersection_priority_override: bool = None
    ''' Override object and collection intersection priority value

    :type: bool
    '''

    use_material_mask: bool = None
    ''' Use material masks to filter out occluded strokes

    :type: bool
    '''

    use_material_mask_bits: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MaterialSlot(bpy_struct):
    ''' Material slot in an object
    '''

    link: typing.Union[str, int] = None
    ''' Link material to object or the object's data

    :type: typing.Union[str, int]
    '''

    material: 'Material' = None
    ''' Material data-block used by this material slot

    :type: 'Material'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Material slot name

    :type: typing.Union[str, typing.Any]
    '''

    slot_index: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Menu(bpy_struct):
    ''' Editor menu containing buttons
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_MT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_MT_hello")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The menu label

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this menu type * ``SEARCH_ON_KEY_PRESS`` Search on Key Press -- Open a menu search when a key pressed while the menu is open.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_owner_id: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the menu in the UI

    :type: 'UILayout'
    '''

    @classmethod
    def poll(cls, context: typing.Optional['Context']) -> bool:
        ''' If this method returns a non-null output, then the menu can be drawn

        :param context: 
        :type context: typing.Optional['Context']
        :rtype: bool
        '''
        pass

    def draw(self, context: typing.Optional['Context']):
        ''' Draw UI elements into the menu UI layout

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass

    def draw_preset(self, _context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_add_operator (string) - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths: typing.Optional[typing.List[str]],
                  operator: typing.Optional[str],
                  *,
                  props_default: typing.Optional[typing.Dict] = None,
                  prop_filepath: typing.Optional[str] = 'filepath',
                  filter_ext: typing.Optional[typing.Callable] = None,
                  filter_path=None,
                  display_name: typing.Optional[typing.Callable] = None,
                  add_operator=None):
        ''' Populate a menu from a list of paths.

        :param searchpaths: Paths to scan.
        :type searchpaths: typing.Optional[typing.List[str]]
        :param operator: The operator id to use with each file.
        :type operator: typing.Optional[str]
        :param prop_filepath: Optional operator filepath property (defaults to "filepath").
        :type prop_filepath: typing.Optional[str]
        :param props_default: Properties to assign to each operator.
        :type props_default: typing.Optional[typing.Dict]
        :param filter_ext: Optional callback that takes the file extensions. Returning false excludes the file from the list.
        :type filter_ext: typing.Optional[typing.Callable]
        :param display_name: Optional callback that takes the full path, returns the name to display.
        :type display_name: typing.Optional[typing.Callable]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    @classmethod
    def append(cls, draw_func):
        ''' 

        '''
        pass

    @classmethod
    def prepend(cls, draw_func):
        ''' 

        '''
        pass

    @classmethod
    def remove(cls, draw_func):
        ''' 

        '''
        pass


class MeshEdge(bpy_struct):
    ''' Edge in a Mesh data-block
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this edge

    :type: int
    '''

    is_loose: typing.Union[bool, typing.Any] = None
    ''' Edge is not connected to any faces

    :type: typing.Union[bool, typing.Any]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_edge_sharp: bool = None
    ''' Sharp edge for shading

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Edge mark for Freestyle line rendering

    :type: bool
    '''

    use_seam: bool = None
    ''' Seam edge for UV unwrapping

    :type: bool
    '''

    vertices: bpy_prop_array[int] = None
    ''' Vertex indices

    :type: bpy_prop_array[int]
    '''

    key = None
    ''' (readonly)'''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshLoop(bpy_struct):
    ''' Loop in a Mesh data-block
    '''

    bitangent: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Vector'] = None
    ''' Bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, use it only if really needed, slower access than bitangent_sign)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bitangent_sign: float = None
    ''' Sign of the bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent))

    :type: float
    '''

    edge_index: int = None
    ''' Edge index

    :type: int
    '''

    index: int = None
    ''' Index of this loop

    :type: int
    '''

    normal: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Local space unit length split normal vector of this vertex for this face (must be computed beforehand using calc_normals_split or calc_tangents)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tangent: typing.Union[typing.List[float], typing.
                          Tuple[float, float, float],
                          'mathutils.Vector'] = None
    ''' Local space unit length tangent vector of this vertex for this face (must be computed beforehand using calc_tangents)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    vertex_index: int = None
    ''' Vertex index

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshLoopColor(bpy_struct):
    ''' Vertex loop colors in a Mesh
    '''

    color: bpy_prop_array[float] = None
    ''' Color in sRGB color space

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshLoopColorLayer(bpy_struct):
    ''' Layer of vertex colors in a Mesh data-block
    '''

    active: bool = None
    ''' Sets the layer as active for display and editing

    :type: bool
    '''

    active_render: bool = None
    ''' Sets the layer as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshLoopColor'] = None
    ''' 

    :type: bpy_prop_collection['MeshLoopColor']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of Vertex color layer

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshLoopTriangle(bpy_struct):
    ''' Tessellated triangle in a Mesh data-block
    '''

    area: float = None
    ''' Area of this triangle

    :type: float
    '''

    index: int = None
    ''' Index of this loop triangle

    :type: int
    '''

    loops: bpy_prop_array[int] = None
    ''' Indices of mesh loops that make up the triangle

    :type: bpy_prop_array[int]
    '''

    material_index: int = None
    ''' Material slot index of this triangle

    :type: int
    '''

    normal: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Local space unit length normal vector for this triangle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    polygon_index: int = None
    ''' Index of mesh face that the triangle is a part of

    :type: int
    '''

    split_normals: typing.Union[typing.List[typing.List[float]], typing.
                                Tuple[typing.Tuple[float, float, float], typing
                                      .Tuple[float, float, float], typing.
                                      Tuple[float, float, float]]] = None
    ''' Local space unit length split normals vectors of the vertices of this triangle (must be computed beforehand using calc_normals_split or calc_tangents)

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    '''

    use_smooth: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    vertices: bpy_prop_array[int] = None
    ''' Indices of triangle vertices

    :type: bpy_prop_array[int]
    '''

    center = None
    ''' The midpoint of the face. (readonly)'''

    edge_keys = None
    ''' (readonly)'''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshNormalValue(bpy_struct):
    ''' Vector in a mesh normal array
    '''

    vector: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 3D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshPaintMaskLayer(bpy_struct):
    ''' Per-vertex paint mask data
    '''

    data: bpy_prop_collection['MeshPaintMaskProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshPaintMaskProperty']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshPaintMaskProperty(bpy_struct):
    ''' Floating-point paint mask value
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshPolygon(bpy_struct):
    ''' Polygon in a Mesh data-block
    '''

    area: float = None
    ''' Read only area of this face

    :type: float
    '''

    center: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Center of this face

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this face

    :type: int
    '''

    loop_start: int = None
    ''' Index of the first loop of this face

    :type: int
    '''

    loop_total: int = None
    ''' Number of loops used by this face

    :type: int
    '''

    material_index: int = None
    ''' Material slot index of this face

    :type: int
    '''

    normal: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Local space unit length normal vector for this face

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Face mark for Freestyle line rendering

    :type: bool
    '''

    use_smooth: bool = None
    ''' 

    :type: bool
    '''

    vertices: bpy_prop_array[int] = None
    ''' Vertex indices

    :type: bpy_prop_array[int]
    '''

    edge_keys = None
    ''' (readonly)'''

    loop_indices = None
    ''' (readonly)'''

    def flip(self):
        ''' Invert winding of this face (flip its normal)

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshSkinVertex(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    radius: bpy_prop_array[float] = None
    ''' Radius of the skin

    :type: bpy_prop_array[float]
    '''

    use_loose: bool = None
    ''' If vertex has multiple adjacent edges, it is hulled to them directly

    :type: bool
    '''

    use_root: bool = None
    ''' Vertex is a root for rotation calculations and armature generation, setting this flag does not clear other roots in the same mesh island

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshSkinVertexLayer(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    data: bpy_prop_collection['MeshSkinVertex'] = None
    ''' 

    :type: bpy_prop_collection['MeshSkinVertex']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of skin layer

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshStatVis(bpy_struct):
    distort_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    distort_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    overhang_axis: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    overhang_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    overhang_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    sharp_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    sharp_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    thickness_max: float = None
    ''' Maximum for measuring thickness

    :type: float
    '''

    thickness_min: float = None
    ''' Minimum for measuring thickness

    :type: float
    '''

    thickness_samples: int = None
    ''' Number of samples to test per face

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of data to visualize/check

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshUVLoop(bpy_struct):
    ''' (Deprecated) Layer of UV coordinates in a Mesh data-block
    '''

    pin_uv: bool = None
    ''' 

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_edge: bool = None
    ''' 

    :type: bool
    '''

    uv: typing.Union[typing.List[float], typing.
                     Tuple[float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshUVLoopLayer(bpy_struct):
    active: bool = None
    ''' Set the map as active for display and editing

    :type: bool
    '''

    active_clone: bool = None
    ''' Set the map as active for cloning

    :type: bool
    '''

    active_render: bool = None
    ''' Set the UV map as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshUVLoop'] = None
    ''' Deprecated, use 'uv', 'vertex_select', 'edge_select' or 'pin' properties instead

    :type: bpy_prop_collection['MeshUVLoop']
    '''

    edge_selection: bpy_prop_collection['BoolAttributeValue'] = None
    ''' Selection state of the edge in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''

    pin: bpy_prop_collection['BoolAttributeValue'] = None
    ''' UV pinned state in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    '''

    uv: bpy_prop_collection['Float2AttributeValue'] = None
    ''' UV coordinates on face corners

    :type: bpy_prop_collection['Float2AttributeValue']
    '''

    vertex_selection: bpy_prop_collection['BoolAttributeValue'] = None
    ''' Selection state of the face corner the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MeshVertex(bpy_struct):
    ''' Vertex in a Mesh data-block
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    groups: bpy_prop_collection['VertexGroupElement'] = None
    ''' Weights for the vertex groups this vertex is member of

    :type: bpy_prop_collection['VertexGroupElement']
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this vertex

    :type: int
    '''

    normal: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Vertex Normal

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    undeformed_co: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MetaElement(bpy_struct):
    ''' Blobby element in a metaball data-block
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    hide: bool = None
    ''' Hide element

    :type: bool
    '''

    radius: float = None
    ''' 

    :type: float
    '''

    rotation: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float, float],
                           'mathutils.Quaternion'] = None
    ''' Normalized quaternion rotation

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    select: bool = None
    ''' Select element

    :type: bool
    '''

    size_x: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_y: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_z: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    stiffness: float = None
    ''' Stiffness defines how much of the element to fill

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Metaball type

    :type: typing.Union[str, int]
    '''

    use_negative: bool = None
    ''' Set metaball as negative one

    :type: bool
    '''

    use_scale_stiffness: bool = None
    ''' Scale stiffness instead of radius

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Modifier(bpy_struct):
    ''' Modifier affecting the geometry data of an object
    '''

    execution_time: float = None
    ''' Time in seconds that the modifier took to evaluate. This is only set on evaluated objects. If multiple modifiers run in parallel, execution time is not a reliable metric

    :type: float
    '''

    is_active: bool = None
    ''' The active modifier in the list

    :type: bool
    '''

    is_override_data: typing.Union[bool, typing.Any] = None
    ''' In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Modifier name

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Set modifier expanded in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display modifier in Edit mode

    :type: bool
    '''

    show_on_cage: bool = None
    ''' Adjust edit cage to modifier result

    :type: bool
    '''

    show_render: bool = None
    ''' Use modifier during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display modifier in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_apply_on_spline: bool = None
    ''' Apply this and all preceding deformation modifiers on splines' points rather than on filled curve/surface

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MotionPath(bpy_struct):
    ''' Cache of the world-space positions of an element over a frame range
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Custom color for motion path

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_end: int = None
    ''' End frame of the stored range

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of the stored range

    :type: int
    '''

    is_modified: bool = None
    ''' Path is being edited

    :type: bool
    '''

    length: int = None
    ''' Number of frames cached

    :type: int
    '''

    line_thickness: int = None
    ''' Line thickness for motion path

    :type: int
    '''

    lines: bool = None
    ''' Use straight lines between keyframe points

    :type: bool
    '''

    points: bpy_prop_collection['MotionPathVert'] = None
    ''' Cached positions per frame

    :type: bpy_prop_collection['MotionPathVert']
    '''

    use_bone_head: typing.Union[bool, typing.Any] = None
    ''' For PoseBone paths, use the bone head location when calculating this path

    :type: typing.Union[bool, typing.Any]
    '''

    use_custom_color: bool = None
    ''' Use custom color for this motion path

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MotionPathVert(bpy_struct):
    ''' Cached location on path
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    select: bool = None
    ''' Path point is selected for editing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieClipProxy(bpy_struct):
    ''' Proxy parameters for a movie clip
    '''

    build_100: bool = None
    ''' Build proxy resolution 100% of the original footage dimension

    :type: bool
    '''

    build_25: bool = None
    ''' Build proxy resolution 25% of the original footage dimension

    :type: bool
    '''

    build_50: bool = None
    ''' Build proxy resolution 50% of the original footage dimension

    :type: bool
    '''

    build_75: bool = None
    ''' Build proxy resolution 75% of the original footage dimension

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    build_undistorted_100: bool = None
    ''' Build proxy resolution 100% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_25: bool = None
    ''' Build proxy resolution 25% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_50: bool = None
    ''' Build proxy resolution 50% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_75: bool = None
    ''' Build proxy resolution 75% of the original undistorted footage dimension

    :type: bool
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    '''

    quality: int = None
    ''' JPEG quality of proxy images

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' * ``NONE`` None. * ``RECORD_RUN`` Record Run -- Use images in the order they are recorded. * ``FREE_RUN`` Free Run -- Use global timestamp written by recording device. * ``FREE_RUN_REC_DATE`` Free Run (rec date) -- Interpolate a global timestamp using the record date and time written by recording device. * ``FREE_RUN_NO_GAPS`` Free Run No Gaps -- Record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieClipScopes(bpy_struct):
    ''' Scopes for statistical view of a movie clip
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieClipUser(bpy_struct):
    ''' Parameters defining how a MovieClip data-block is used by another data-block
    '''

    frame_current: int = None
    ''' Current frame number in movie or image sequence

    :type: int
    '''

    proxy_render_size: typing.Union[str, int] = None
    ''' Display preview using full resolution or different proxy resolutions

    :type: typing.Union[str, int]
    '''

    use_render_undistorted: bool = None
    ''' Render preview using undistorted proxy

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieReconstructedCamera(bpy_struct):
    ''' Match-moving reconstructed camera data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Worldspace transformation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTracking(bpy_struct):
    ''' Match-moving data for tracking
    '''

    active_object_index: int = None
    ''' Index of active object

    :type: int
    '''

    camera: 'MovieTrackingCamera' = None
    ''' 

    :type: 'MovieTrackingCamera'
    '''

    dopesheet: 'MovieTrackingDopesheet' = None
    ''' 

    :type: 'MovieTrackingDopesheet'
    '''

    objects: 'MovieTrackingObjects' = None
    ''' Collection of objects in this tracking data object

    :type: 'MovieTrackingObjects'
    '''

    plane_tracks: 'MovieTrackingPlaneTracks' = None
    ''' Collection of plane tracks in this tracking data object. Deprecated, use objects[name].plane_tracks

    :type: 'MovieTrackingPlaneTracks'
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    settings: 'MovieTrackingSettings' = None
    ''' 

    :type: 'MovieTrackingSettings'
    '''

    stabilization: 'MovieTrackingStabilization' = None
    ''' 

    :type: 'MovieTrackingStabilization'
    '''

    tracks: 'MovieTrackingTracks' = None
    ''' Collection of tracks in this tracking data object. Deprecated, use objects[name].tracks

    :type: 'MovieTrackingTracks'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingCamera(bpy_struct):
    ''' Match-moving camera data for tracking
    '''

    brown_k1: float = None
    ''' First coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k2: float = None
    ''' Second coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k3: float = None
    ''' Third coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_k4: float = None
    ''' Fourth coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    '''

    brown_p1: float = None
    ''' First coefficient of second order Brown-Conrady tangential distortion

    :type: float
    '''

    brown_p2: float = None
    ''' Second coefficient of second order Brown-Conrady tangential distortion

    :type: float
    '''

    distortion_model: typing.Union[str, int] = None
    ''' Distortion model used for camera lenses * ``POLYNOMIAL`` Polynomial -- Radial distortion model which fits common cameras. * ``DIVISION`` Divisions -- Division distortion model which better represents wide-angle cameras. * ``NUKE`` Nuke -- Nuke distortion model. * ``BROWN`` Brown -- Brown-Conrady distortion model.

    :type: typing.Union[str, int]
    '''

    division_k1: float = None
    ''' First coefficient of second order division distortion

    :type: float
    '''

    division_k2: float = None
    ''' Second coefficient of second order division distortion

    :type: float
    '''

    focal_length: float = None
    ''' Camera's focal length

    :type: float
    '''

    focal_length_pixels: float = None
    ''' Camera's focal length

    :type: float
    '''

    k1: float = None
    ''' First coefficient of third order polynomial radial distortion

    :type: float
    '''

    k2: float = None
    ''' Second coefficient of third order polynomial radial distortion

    :type: float
    '''

    k3: float = None
    ''' Third coefficient of third order polynomial radial distortion

    :type: float
    '''

    nuke_k1: float = None
    ''' First coefficient of second order Nuke distortion

    :type: float
    '''

    nuke_k2: float = None
    ''' Second coefficient of second order Nuke distortion

    :type: float
    '''

    pixel_aspect: float = None
    ''' Pixel aspect ratio

    :type: float
    '''

    principal_point: bpy_prop_array[float] = None
    ''' Optical center of lens

    :type: bpy_prop_array[float]
    '''

    principal_point_pixels: bpy_prop_array[float] = None
    ''' Optical center of lens in pixels

    :type: bpy_prop_array[float]
    '''

    sensor_width: float = None
    ''' Width of CCD sensor in millimeters

    :type: float
    '''

    units: typing.Union[str, int] = None
    ''' Units used for camera focal length * ``PIXELS`` px -- Use pixels for units of focal length. * ``MILLIMETERS`` mm -- Use millimeters for units of focal length.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingDopesheet(bpy_struct):
    ''' Match-moving dopesheet data
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that are not visible

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' Method to be used to sort channels in dopesheet view * ``NAME`` Name -- Sort channels by their names. * ``LONGEST`` Longest -- Sort channels by longest tracked segment. * ``TOTAL`` Total -- Sort channels by overall amount of tracked segments. * ``AVERAGE_ERROR`` Average Error -- Sort channels by average reprojection error of tracks after solve. * ``START`` Start Frame -- Sort channels by first frame number. * ``END`` End Frame -- Sort channels by last frame number.

    :type: typing.Union[str, int]
    '''

    use_invert_sort: bool = None
    ''' Invert sort order of dopesheet channels

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingMarker(bpy_struct):
    ''' Match-moving marker data for tracking
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float], 'mathutils.Vector'] = None
    ''' Marker position at frame in normalized coordinates

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    is_keyed: bool = None
    ''' Whether the position of the marker is keyframed or tracked

    :type: bool
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''

    pattern_bound_box: typing.Union[typing.List[typing.List[float]], typing.
                                    Tuple[typing.Tuple[float, float], typing.
                                          Tuple[float, float]]] = None
    ''' Pattern area bounding box in normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float], typing.Tuple[float, float]]]
    '''

    pattern_corners: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]]] = None
    ''' Array of coordinates which represents pattern's corners in normalized coordinates relative to marker position

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    '''

    search_max: typing.Union[typing.List[float], typing.
                             Tuple[float, float], 'mathutils.Vector'] = None
    ''' Right-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    search_min: typing.Union[typing.List[float], typing.
                             Tuple[float, float], 'mathutils.Vector'] = None
    ''' Left-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingObject(bpy_struct):
    ''' Match-moving object tracking and reconstruction data
    '''

    is_camera: typing.Union[bool, typing.Any] = None
    ''' Object is used for camera tracking

    :type: typing.Union[bool, typing.Any]
    '''

    keyframe_a: int = None
    ''' First keyframe used for reconstruction initialization

    :type: int
    '''

    keyframe_b: int = None
    ''' Second keyframe used for reconstruction initialization

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of object

    :type: typing.Union[str, typing.Any]
    '''

    plane_tracks: 'MovieTrackingObjectPlaneTracks' = None
    ''' Collection of plane tracks in this tracking data object

    :type: 'MovieTrackingObjectPlaneTracks'
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    scale: float = None
    ''' Scale of object solution in camera space

    :type: float
    '''

    tracks: 'MovieTrackingObjectTracks' = None
    ''' Collection of tracks in this tracking data object

    :type: 'MovieTrackingObjectTracks'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneMarker(bpy_struct):
    ''' Match-moving plane marker data for tracking
    '''

    corners: typing.Union[typing.List[typing.List[float]], typing.
                          Tuple[typing.
                                Tuple[float, float, float, float], typing.
                                Tuple[float, float, float, float]]] = None
    ''' Array of coordinates which represents UI rectangle corners in frame normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingPlaneTrack(bpy_struct):
    ''' Match-moving plane track data for tracking
    '''

    image: 'Image' = None
    ''' Image displayed in the track during editing in clip editor

    :type: 'Image'
    '''

    image_opacity: float = None
    ''' Opacity of the image

    :type: float
    '''

    markers: 'MovieTrackingPlaneMarkers' = None
    ''' Collection of markers in track

    :type: 'MovieTrackingPlaneMarkers'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of track

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Plane track is selected

    :type: bool
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion when moving plane corners

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingReconstruction(bpy_struct):
    ''' Match-moving reconstruction data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    cameras: 'MovieTrackingReconstructedCameras' = None
    ''' Collection of solved cameras

    :type: 'MovieTrackingReconstructedCameras'
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Is tracking data contains valid reconstruction information

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingSettings(bpy_struct):
    ''' Match moving settings
    '''

    clean_action: typing.Union[str, int] = None
    ''' Cleanup action to execute * ``SELECT`` Select -- Select unclean tracks. * ``DELETE_TRACK`` Delete Track -- Delete unclean tracks. * ``DELETE_SEGMENTS`` Delete Segments -- Delete unclean segments of tracks.

    :type: typing.Union[str, int]
    '''

    clean_error: float = None
    ''' Effect on tracks which have a larger re-projection error

    :type: float
    '''

    clean_frames: int = None
    ''' Effect on tracks which are tracked less than the specified amount of frames

    :type: int
    '''

    default_correlation_min: float = None
    ''' Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    default_frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    default_margin: int = None
    ''' Default distance from image boundary at which marker stops tracking

    :type: int
    '''

    default_motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * ``Perspective`` Perspective -- Search for markers that are perspectively deformed (homography) between frames. * ``Affine`` Affine -- Search for markers that are affine-deformed (t, r, k, and skew) between frames. * ``LocRotScale`` Location, Rotation & Scale -- Search for markers that are translated, rotated, and scaled between frames. * ``LocScale`` Location & Scale -- Search for markers that are translated and scaled between frames. * ``LocRot`` Location & Rotation -- Search for markers that are translated and rotated between frames. * ``Loc`` Location -- Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    default_pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * ``KEYFRAME`` Keyframe -- Track pattern from keyframe to next frame. * ``PREV_FRAME`` Previous frame -- Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    default_pattern_size: int = None
    ''' Size of pattern area for newly created tracks

    :type: int
    '''

    default_search_size: int = None
    ''' Size of search area for newly created tracks

    :type: int
    '''

    default_weight: float = None
    ''' Influence of newly created track on a final solution

    :type: float
    '''

    distance: float = None
    ''' Distance between two bundles used for scene scaling

    :type: float
    '''

    object_distance: float = None
    ''' Distance between two bundles used for object scaling

    :type: float
    '''

    refine_intrinsics_focal_length: bool = None
    ''' Refine focal length during camera solving

    :type: bool
    '''

    refine_intrinsics_principal_point: bool = None
    ''' Refine principal point during camera solving

    :type: bool
    '''

    refine_intrinsics_radial_distortion: bool = None
    ''' Refine radial coefficients of distortion model during camera solving

    :type: bool
    '''

    refine_intrinsics_tangential_distortion: bool = None
    ''' Refine tangential coefficients of distortion model during camera solving

    :type: bool
    '''

    speed: typing.Union[str, int] = None
    ''' Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality) * ``FASTEST`` Fastest -- Track as fast as possible. * ``DOUBLE`` Double -- Track with double speed. * ``REALTIME`` Realtime -- Track with realtime speed. * ``HALF`` Half -- Track with half of realtime speed. * ``QUARTER`` Quarter -- Track with quarter of realtime speed.

    :type: typing.Union[str, int]
    '''

    use_default_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_default_brute: bool = None
    ''' Use a brute-force translation-only initialization when tracking

    :type: bool
    '''

    use_default_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_default_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_default_normalization: bool = None
    ''' Normalize light intensities while tracking (slower)

    :type: bool
    '''

    use_default_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    use_keyframe_selection: bool = None
    ''' Automatically select keyframes when solving camera/object motion

    :type: bool
    '''

    use_tripod_solver: bool = None
    ''' Use special solver to track a stable camera position, such as a tripod

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingStabilization(bpy_struct):
    ''' 2D stabilization based on tracking markers
    '''

    active_rotation_track_index: int = None
    ''' Index of active track in rotation stabilization tracks list

    :type: int
    '''

    active_track_index: int = None
    ''' Index of active track in translation stabilization tracks list

    :type: int
    '''

    anchor_frame: int = None
    ''' Reference point to anchor stabilization (other frames will be adjusted relative to this frame's position)

    :type: int
    '''

    filter_type: typing.Union[str, int] = None
    ''' Interpolation to use for sub-pixel shifts and rotations due to stabilization * ``NEAREST`` Nearest -- No interpolation, use nearest neighbor pixel. * ``BILINEAR`` Bilinear -- Simple interpolation between adjacent pixels. * ``BICUBIC`` Bicubic -- High quality pixel interpolation.

    :type: typing.Union[str, int]
    '''

    influence_location: float = None
    ''' Influence of stabilization algorithm on footage location

    :type: float
    '''

    influence_rotation: float = None
    ''' Influence of stabilization algorithm on footage rotation

    :type: float
    '''

    influence_scale: float = None
    ''' Influence of stabilization algorithm on footage scale

    :type: float
    '''

    rotation_tracks: bpy_prop_collection['MovieTrackingTrack'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    '''

    scale_max: float = None
    ''' Limit the amount of automatic scaling

    :type: float
    '''

    show_tracks_expanded: bool = None
    ''' Show UI list of tracks participating in stabilization

    :type: bool
    '''

    target_position: typing.Union[typing.List[float], typing.
                                  Tuple[float, float],
                                  'mathutils.Vector'] = None
    ''' Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    target_rotation: float = None
    ''' Rotation present on original shot, will be compensated (e.g. for deliberate tilting)

    :type: float
    '''

    target_scale: float = None
    ''' Explicitly scale resulting frame to compensate zoom of original shot

    :type: float
    '''

    tracks: bpy_prop_collection['MovieTrackingTrack'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    '''

    use_2d_stabilization: bool = None
    ''' Use 2D stabilization for footage

    :type: bool
    '''

    use_autoscale: bool = None
    ''' Automatically scale footage to cover unfilled areas when stabilizing

    :type: bool
    '''

    use_stabilize_rotation: bool = None
    ''' Stabilize detected rotation around center of frame

    :type: bool
    '''

    use_stabilize_scale: bool = None
    ''' Compensate any scale changes relative to center of rotation

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class MovieTrackingTrack(bpy_struct):
    ''' Match-moving track data for tracking
    '''

    average_error: float = None
    ''' Average error of re-projection

    :type: float
    '''

    bundle: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Position of bundle reconstructed from this track

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color of the track in the Movie Clip Editor and the 3D viewport after a solve

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    correlation_min: float = None
    ''' Minimal value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease pencil data for this track

    :type: 'GreasePencil'
    '''

    has_bundle: typing.Union[bool, typing.Any] = None
    ''' True if track has a valid bundle

    :type: typing.Union[bool, typing.Any]
    '''

    hide: bool = None
    ''' Track is hidden

    :type: bool
    '''

    lock: bool = None
    ''' Track is locked and all changes to it are disabled

    :type: bool
    '''

    margin: int = None
    ''' Distance from image boundary at which marker stops tracking

    :type: int
    '''

    markers: 'MovieTrackingMarkers' = None
    ''' Collection of markers in track

    :type: 'MovieTrackingMarkers'
    '''

    motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * ``Perspective`` Perspective -- Search for markers that are perspectively deformed (homography) between frames. * ``Affine`` Affine -- Search for markers that are affine-deformed (t, r, k, and skew) between frames. * ``LocRotScale`` Location, Rotation & Scale -- Search for markers that are translated, rotated, and scaled between frames. * ``LocScale`` Location & Scale -- Search for markers that are translated and scaled between frames. * ``LocRot`` Location & Rotation -- Search for markers that are translated and rotated between frames. * ``Loc`` Location -- Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of track

    :type: typing.Union[str, typing.Any]
    '''

    offset: typing.Union[typing.List[float], typing.
                         Tuple[float, float], 'mathutils.Vector'] = None
    ''' Offset of track from the parenting point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * ``KEYFRAME`` Keyframe -- Track pattern from keyframe to next frame. * ``PREV_FRAME`` Previous frame -- Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Track is selected

    :type: bool
    '''

    select_anchor: bool = None
    ''' Track's anchor point is selected

    :type: bool
    '''

    select_pattern: bool = None
    ''' Track's pattern area is selected

    :type: bool
    '''

    select_search: bool = None
    ''' Track's search area is selected

    :type: bool
    '''

    use_alpha_preview: bool = None
    ''' Apply track's mask on displaying preview

    :type: bool
    '''

    use_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_brute: bool = None
    ''' Use a brute-force translation only pre-track before refinement

    :type: bool
    '''

    use_custom_color: bool = None
    ''' Use custom color instead of theme-defined

    :type: bool
    '''

    use_grayscale_preview: bool = None
    ''' Display what the tracking algorithm sees in the preview

    :type: bool
    '''

    use_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_normalization: bool = None
    ''' Normalize light intensities while tracking. Slower

    :type: bool
    '''

    use_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    weight: float = None
    ''' Influence of this track on a final solution

    :type: float
    '''

    weight_stab: float = None
    ''' Influence of this track on 2D stabilization

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NlaStrip(bpy_struct):
    ''' A container referencing an existing Action
    '''

    action: 'Action' = None
    ''' Action referenced by this strip

    :type: 'Action'
    '''

    action_frame_end: float = None
    ''' Last frame from action to use

    :type: float
    '''

    action_frame_start: float = None
    ''' First frame from action to use

    :type: float
    '''

    active: typing.Union[bool, typing.Any] = None
    ''' NLA Strip is active

    :type: typing.Union[bool, typing.Any]
    '''

    blend_in: float = None
    ''' Number of frames at start of strip to fade in influence

    :type: float
    '''

    blend_out: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method used for combining strip's result with accumulated result * ``REPLACE`` Replace -- The strip values replace the accumulated results by amount specified by influence. * ``COMBINE`` Combine -- The strip values are combined with accumulated results by appropriately using addition, multiplication, or quaternion math, based on channel type. * ``ADD`` Add -- Weighted result of strip is added to the accumulated results. * ``SUBTRACT`` Subtract -- Weighted result of strip is removed from the accumulated results. * ``MULTIPLY`` Multiply -- Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the strip extents * ``NOTHING`` Nothing -- Strip has no influence past its extents. * ``HOLD`` Hold -- Hold the first frame if no previous strips in track, and always hold last frame. * ``HOLD_FORWARD`` Hold Forward -- Only hold last frame.

    :type: typing.Union[str, int]
    '''

    fcurves: 'NlaStripFCurves' = None
    ''' F-Curves for controlling the strip's influence and timing

    :type: 'NlaStripFCurves'
    '''

    frame_end: float = None
    ''' 

    :type: float
    '''

    frame_end_raw: float = None
    ''' Same as frame_end, except that any value can be set, including ones that create an invalid state

    :type: float
    '''

    frame_end_ui: float = None
    ''' End frame of the NLA strip. Note: changing this value also updates the value of the strip's repeats or its action's end frame. If only the end frame should be changed, see the "frame_end" property instead

    :type: float
    '''

    frame_start: float = None
    ''' 

    :type: float
    '''

    frame_start_raw: float = None
    ''' Same as frame_start, except that any value can be set, including ones that create an invalid state

    :type: float
    '''

    frame_start_ui: float = None
    ''' Start frame of the NLA strip. Note: changing this value also updates the value of the strip's end frame. If only the start frame should be changed, see the "frame_start" property instead

    :type: float
    '''

    influence: float = None
    ''' Amount the strip contributes to the current result

    :type: float
    '''

    modifiers: bpy_prop_collection['FModifier'] = None
    ''' Modifiers affecting all the F-Curves in the referenced Action

    :type: bpy_prop_collection['FModifier']
    '''

    mute: bool = None
    ''' Disable NLA Strip evaluation

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    repeat: float = None
    ''' Number of times to repeat the action range

    :type: float
    '''

    scale: float = None
    ''' Scaling factor for action

    :type: float
    '''

    select: bool = None
    ''' NLA Strip is selected

    :type: bool
    '''

    strip_time: float = None
    ''' Frame of referenced Action to evaluate

    :type: float
    '''

    strips: bpy_prop_collection['NlaStrip'] = None
    ''' NLA Strips that this strip acts as a container for (if it is of type Meta)

    :type: bpy_prop_collection['NlaStrip']
    '''

    type: typing.Union[str, int] = None
    ''' Type of NLA Strip * ``CLIP`` Action Clip -- NLA Strip references some Action. * ``TRANSITION`` Transition -- NLA Strip 'transitions' between adjacent strips. * ``META`` Meta -- NLA Strip acts as a container for adjacent strips. * ``SOUND`` Sound Clip -- NLA Strip representing a sound event for speakers.

    :type: typing.Union[str, int]
    '''

    use_animated_influence: bool = None
    ''' Influence setting is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time: bool = None
    ''' Strip time is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time_cyclic: bool = None
    ''' Cycle the animated time within the action start and end

    :type: bool
    '''

    use_auto_blend: bool = None
    ''' Number of frames for Blending In/Out is automatically determined from overlapping strips

    :type: bool
    '''

    use_reverse: bool = None
    ''' NLA Strip is played back in reverse order (only when timing is automatically determined)

    :type: bool
    '''

    use_sync_length: bool = None
    ''' Update range of frames referenced from action after tweaking strip and its keyframes

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NlaTrack(bpy_struct):
    ''' An animation layer containing Actions referenced as NLA strips
    '''

    active: typing.Union[bool, typing.Any] = None
    ''' NLA Track is active

    :type: typing.Union[bool, typing.Any]
    '''

    is_override_data: typing.Union[bool, typing.Any] = None
    ''' In a local override data, whether this NLA track comes from the linked reference data, or is local to the override

    :type: typing.Union[bool, typing.Any]
    '''

    is_solo: bool = None
    ''' NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled)

    :type: bool
    '''

    lock: bool = None
    ''' NLA Track is locked

    :type: bool
    '''

    mute: bool = None
    ''' Disable NLA Track evaluation

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' NLA Track is selected

    :type: bool
    '''

    strips: 'NlaStrips' = None
    ''' NLA Strips on this NLA-track

    :type: 'NlaStrips'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Node(bpy_struct):
    ''' Node in a node tree
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_height_default: float = None
    ''' 

    :type: float
    '''

    bl_height_max: float = None
    ''' 

    :type: float
    '''

    bl_height_min: float = None
    ''' 

    :type: float
    '''

    bl_icon: typing.Union[str, int] = None
    ''' The node icon

    :type: typing.Union[str, int]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The node label

    :type: typing.Union[str, typing.Any]
    '''

    bl_static_type: typing.Union[str, int] = None
    ''' Node type (deprecated, use with care) * ``CUSTOM`` Custom -- Custom Node.

    :type: typing.Union[str, int]
    '''

    bl_width_default: float = None
    ''' 

    :type: float
    '''

    bl_width_max: float = None
    ''' 

    :type: float
    '''

    bl_width_min: float = None
    ''' 

    :type: float
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Custom color of the node body

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    dimensions: typing.Union[typing.List[float], typing.
                             Tuple[float, float], 'mathutils.Vector'] = None
    ''' Absolute bounding box dimensions of the node

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    height: float = None
    ''' Height of the node

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    inputs: 'NodeInputs' = None
    ''' 

    :type: 'NodeInputs'
    '''

    internal_links: bpy_prop_collection['NodeLink'] = None
    ''' Internal input-to-output connections for muting

    :type: bpy_prop_collection['NodeLink']
    '''

    label: typing.Union[str, typing.Any] = None
    ''' Optional custom node label

    :type: typing.Union[str, typing.Any]
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
    '''

    mute: bool = None
    ''' 

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique node identifier

    :type: typing.Union[str, typing.Any]
    '''

    outputs: 'NodeOutputs' = None
    ''' 

    :type: 'NodeOutputs'
    '''

    parent: 'Node' = None
    ''' Parent this node is attached to

    :type: 'Node'
    '''

    select: bool = None
    ''' Node selection state

    :type: bool
    '''

    show_options: bool = None
    ''' 

    :type: bool
    '''

    show_preview: bool = None
    ''' 

    :type: bool
    '''

    show_texture: bool = None
    ''' Display node in viewport textured shading mode

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string) * ``CUSTOM`` Custom -- Custom Node.

    :type: typing.Union[str, int]
    '''

    use_custom_color: bool = None
    ''' Use custom color for the node

    :type: bool
    '''

    width: float = None
    ''' Width of the node

    :type: float
    '''

    def socket_value_update(self, context: 'Context'):
        ''' Update after property changes

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def is_registered_node_type(cls) -> bool:
        ''' True if a registered node type

        :rtype: bool
        :return: Result
        '''
        pass

    @classmethod
    def poll(cls, node_tree: typing.Optional['NodeTree']) -> bool:
        ''' If non-null output is returned, the node type can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        '''
        pass

    def poll_instance(self, node_tree: typing.Optional['NodeTree']) -> bool:
        ''' If non-null output is returned, the node can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        '''
        pass

    def update(self):
        ''' Update on node graph topology changes (adding or removing nodes and links)

        '''
        pass

    def insert_link(self, link: 'NodeLink'):
        ''' Handle creation of a link to or from the node

        :param link: Link, Node link that will be inserted
        :type link: 'NodeLink'
        '''
        pass

    def init(self, context: 'Context'):
        ''' Initialize a new instance of this node

        :param context: 
        :type context: 'Context'
        '''
        pass

    def copy(self, node: 'Node'):
        ''' Initialize a new instance of this node from an existing node

        :param node: Node, Existing node to copy
        :type node: 'Node'
        '''
        pass

    def free(self):
        ''' Clean up node on removal

        '''
        pass

    def draw_buttons(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_buttons_ext(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons in the sidebar

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_label(self) -> typing.Union[str, typing.Any]:
        ''' Returns a dynamic label string

        :rtype: typing.Union[str, typing.Any]
        :return: Label
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeInstanceHash(bpy_struct):
    ''' Hash table containing node instance data
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeInternalSocketTemplate(bpy_struct):
    ''' Type and default value of a node socket
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Identifier of the socket

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the socket

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the socket

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeLink(bpy_struct):
    ''' Link between nodes in a node tree
    '''

    from_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    from_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''

    is_hidden: typing.Union[bool, typing.Any] = None
    ''' Link is hidden due to invisible sockets

    :type: typing.Union[bool, typing.Any]
    '''

    is_muted: bool = None
    ''' Link is muted and can be ignored

    :type: bool
    '''

    is_valid: bool = None
    ''' Link is valid

    :type: bool
    '''

    to_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    to_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeOutputFileSlotFile(bpy_struct):
    ''' Single layer file slot of the file output node
    '''

    format: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    path: typing.Union[str, typing.Any] = None
    ''' Subpath used for this slot

    :type: typing.Union[str, typing.Any]
    '''

    save_as_render: bool = None
    ''' Apply render part of display transform when saving byte image

    :type: bool
    '''

    use_node_format: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeOutputFileSlotLayer(bpy_struct):
    ''' Multilayer slot of the file output node
    '''

    name: typing.Union[str, typing.Any] = None
    ''' OpenEXR layer name used for this slot

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeSocket(bpy_struct):
    ''' Input or output socket of a node
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' Label to display for the socket type in the UI

    :type: typing.Union[str, typing.Any]
    '''

    bl_subtype_label: typing.Union[str, typing.Any] = None
    ''' Label to display for the socket subtype in the UI

    :type: typing.Union[str, typing.Any]
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Socket tooltip

    :type: typing.Union[str, typing.Any]
    '''

    display_shape: typing.Union[str, int] = None
    ''' Socket shape

    :type: typing.Union[str, int]
    '''

    enabled: bool = None
    ''' Enable the socket

    :type: bool
    '''

    hide: bool = None
    ''' Hide the socket

    :type: bool
    '''

    hide_value: bool = None
    ''' Hide the socket input value

    :type: bool
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique identifier for mapping sockets

    :type: typing.Union[str, typing.Any]
    '''

    is_linked: typing.Union[bool, typing.Any] = None
    ''' True if the socket is connected

    :type: typing.Union[bool, typing.Any]
    '''

    is_multi_input: typing.Union[bool, typing.Any] = None
    ''' True if the socket can accept multiple ordered input links

    :type: typing.Union[bool, typing.Any]
    '''

    is_output: typing.Union[bool, typing.Any] = None
    ''' True if the socket is an output, otherwise input

    :type: typing.Union[bool, typing.Any]
    '''

    is_unavailable: typing.Union[bool, typing.Any] = None
    ''' True if the socket is unavailable

    :type: typing.Union[bool, typing.Any]
    '''

    label: typing.Union[str, typing.Any] = None
    ''' Custom dynamic defined socket label

    :type: typing.Union[str, typing.Any]
    '''

    link_limit: int = None
    ''' Max number of links allowed for this socket

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Socket name

    :type: typing.Union[str, typing.Any]
    '''

    node: 'Node' = None
    ''' Node owning this socket

    :type: 'Node'
    '''

    show_expanded: bool = None
    ''' Socket links are expanded in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Data type

    :type: typing.Union[str, int]
    '''

    links = None
    ''' List of node links from or to this socket. (readonly)'''

    def draw(self, context: 'Context', layout: 'UILayout', node: 'Node',
             text: typing.Union[str, typing.Any]):
        ''' Draw socket

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties
        :type text: typing.Union[str, typing.Any]
        '''
        pass

    def draw_color(self, context: 'Context',
                   node: 'Node') -> bpy_prop_array[float]:
        ''' Color of the socket icon

        :param context: 
        :type context: 'Context'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :rtype: bpy_prop_array[float]
        :return: Color
        '''
        pass

    @classmethod
    def draw_color_simple(cls) -> bpy_prop_array[float]:
        ''' Color of the socket icon. Used to draw sockets in places where the socket does not belong to a node, like the node interface panel. Also used to draw node sockets if draw_color is not defined

        :rtype: bpy_prop_array[float]
        :return: Color
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeTreeInterface(bpy_struct):
    ''' Declaration of sockets and ui panels of a node group
    '''

    active: 'NodeTreeInterfaceItem' = None
    ''' Active item

    :type: 'NodeTreeInterfaceItem'
    '''

    active_index: int = None
    ''' Index of the active item

    :type: int
    '''

    items_tree: bpy_prop_collection['NodeTreeInterfaceItem'] = None
    ''' Items in the node interface

    :type: bpy_prop_collection['NodeTreeInterfaceItem']
    '''

    def new_socket(self,
                   name: typing.Union[str, typing.Any],
                   description: typing.Union[str, typing.Any] = "",
                   in_out: typing.Optional[typing.Any] = 'INPUT',
                   socket_type: typing.Optional[typing.Union[str, int, typing.
                                                             Any]] = 'DEFAULT',
                   parent: typing.Optional['NodeTreeInterfacePanel'] = None
                   ) -> 'NodeTreeInterfaceSocket':
        ''' Add a new socket to the interface

        :param name: Name, Name of the socket
        :type name: typing.Union[str, typing.Any]
        :param description: Description, Description of the socket
        :type description: typing.Union[str, typing.Any]
        :param in_out: Input/Output Type, Create an input or output socket * ``INPUT`` Input -- Generate a input node socket. * ``OUTPUT`` Output -- Generate a output node socket.
        :type in_out: typing.Optional[typing.Any]
        :param socket_type: Socket Type, Type of socket generated on nodes
        :type socket_type: typing.Optional[typing.Union[str, int, typing.Any]]
        :param parent: Parent, Panel to add the socket in
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :rtype: 'NodeTreeInterfaceSocket'
        :return: Socket, New socket
        '''
        pass

    def new_panel(self,
                  name: typing.Union[str, typing.Any],
                  description: typing.Union[str, typing.Any] = "",
                  default_closed: typing.Optional[typing.Union[bool, typing.
                                                               Any]] = False,
                  parent: typing.Optional['NodeTreeInterfacePanel'] = None
                  ) -> 'NodeTreeInterfacePanel':
        ''' Add a new panel to the interface

        :param name: Name, Name of the new panel
        :type name: typing.Union[str, typing.Any]
        :param description: Description, Description of the panel
        :type description: typing.Union[str, typing.Any]
        :param default_closed: Default Closed, Panel is closed by default on new nodes
        :type default_closed: typing.Optional[typing.Union[bool, typing.Any]]
        :param parent: Parent, Add panel as a child of the parent panel
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :rtype: 'NodeTreeInterfacePanel'
        :return: Panel, New panel
        '''
        pass

    def copy(self, item: 'NodeTreeInterfaceItem') -> 'NodeTreeInterfaceItem':
        ''' Add a copy of an item to the interface

        :param item: Item, Item to copy
        :type item: 'NodeTreeInterfaceItem'
        :rtype: 'NodeTreeInterfaceItem'
        :return: Item Copy, Copy of the item
        '''
        pass

    def remove(self,
               item: 'NodeTreeInterfaceItem',
               move_content_to_parent: typing.Optional[
                   typing.Union[bool, typing.Any]] = True):
        ''' Remove an item from the interface

        :param item: Item, The item to remove
        :type item: 'NodeTreeInterfaceItem'
        :param move_content_to_parent: Move Content, If the item is a panel, move the contents to the parent instead of deleting it
        :type move_content_to_parent: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def clear(self):
        ''' Remove all items from the interface

        '''
        pass

    def move(self, item: 'NodeTreeInterfaceItem',
             to_position: typing.Optional[int]):
        ''' Move an item to another position

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param to_position: To Position, Target position for the item in its current panel
        :type to_position: typing.Optional[int]
        '''
        pass

    def move_to_parent(self, item: 'NodeTreeInterfaceItem',
                       parent: typing.Optional['NodeTreeInterfacePanel'],
                       to_position: typing.Optional[int]):
        ''' Move an item to a new panel and/or position.

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param parent: Parent, New parent of the item
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :param to_position: To Position, Target position for the item in the new parent panel
        :type to_position: typing.Optional[int]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeTreeInterfaceItem(bpy_struct):
    ''' Item in a node tree interface
    '''

    index: int = None
    ''' Global index of the item among all items in the interface

    :type: int
    '''

    item_type: typing.Union[str, int] = None
    ''' Type of interface item

    :type: typing.Union[str, int]
    '''

    parent: 'NodeTreeInterfacePanel' = None
    ''' Panel that contains the item

    :type: 'NodeTreeInterfacePanel'
    '''

    position: int = None
    ''' Position of the item in its parent panel

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodeTreePath(bpy_struct):
    ''' Element of the node space tree path
    '''

    node_tree: 'NodeTree' = None
    ''' Base node tree from context

    :type: 'NodeTree'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class NodesModifierBake(bpy_struct):
    directory: typing.Union[str, typing.Any] = None
    ''' Location on disk where the bake data is stored

    :type: typing.Union[str, typing.Any]
    '''

    frame_end: int = None
    ''' Frame where the baking ends

    :type: int
    '''

    frame_start: int = None
    ''' Frame where the baking starts

    :type: int
    '''

    use_custom_path: bool = None
    ''' Specify a path where the baked data should be stored manually

    :type: bool
    '''

    use_custom_simulation_frame_range: bool = None
    ''' Override the simulation frame range from the scene

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ObjectBase(bpy_struct):
    ''' An object instance in a render layer
    '''

    hide_viewport: bool = None
    ''' Temporarily hide in viewport

    :type: bool
    '''

    object: 'Object' = None
    ''' Object this base links to

    :type: 'Object'
    '''

    select: bool = None
    ''' Object base selection state

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ObjectDisplay(bpy_struct):
    ''' Object display settings for 3D viewport
    '''

    show_shadows: bool = None
    ''' Object cast shadows in the 3D viewport

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ObjectLightLinking(bpy_struct):
    blocker_collection: 'Collection' = None
    ''' Collection which defines objects which block light from this emitter

    :type: 'Collection'
    '''

    receiver_collection: 'Collection' = None
    ''' Collection which defines light linking relation of this emitter

    :type: 'Collection'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ObjectLineArt(bpy_struct):
    ''' Object line art settings
    '''

    crease_threshold: float = None
    ''' Angles smaller than this will be treated as creases

    :type: float
    '''

    intersection_priority: int = None
    ''' The intersection line will be included into the object with the higher intersection priority value

    :type: int
    '''

    usage: typing.Union[str, int] = None
    ''' How to use this object in line art calculation * ``INHERIT`` Inherit -- Use settings from the parent collection. * ``INCLUDE`` Include -- Generate feature lines for this object's data. * ``OCCLUSION_ONLY`` Occlusion Only -- Only use the object data to produce occlusion. * ``EXCLUDE`` Exclude -- Don't use this object for Line Art rendering. * ``INTERSECTION_ONLY`` Intersection Only -- Only generate intersection lines for this collection. * ``NO_INTERSECTION`` No Intersection -- Include this object but do not generate intersection lines. * ``FORCE_INTERSECTION`` Force Intersection -- Generate intersection lines even with objects that disabled intersection.

    :type: typing.Union[str, int]
    '''

    use_crease_override: bool = None
    ''' Use this object's crease setting to overwrite scene global

    :type: bool
    '''

    use_intersection_priority_override: bool = None
    ''' Use this object's intersection priority to override collection setting

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Operator(bpy_struct):
    ''' Storage of an operator being executed, or registered after execution
    '''

    bl_cursor_pending: typing.Union[str, int] = None
    ''' Cursor to use when waiting for the user to select a location to activate the operator (when ``bl_options`` has ``DEPENDS_ON_CURSOR`` set)

    :type: typing.Union[str, int]
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_undo_group: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    has_reports: typing.Union[bool, typing.Any] = None
    ''' Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''

    macros: bpy_prop_collection['Macro'] = None
    ''' 

    :type: bpy_prop_collection['Macro']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    options: 'OperatorOptions' = None
    ''' Runtime options

    :type: 'OperatorOptions'
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    bl_property: str = None
    ''' The name of a property to use as this operators primary property. Currently this is only used to select the default property when expanding an operator into a menu.

    :type: str
    '''

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    def is_repeat(self) -> bool:
        ''' is_repeat

        :rtype: bool
        :return: result
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def execute(self, context: 'Context'
                ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Execute the operator

        :param context: 
        :type context: 'Context'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result
        '''
        pass

    def check(self, context: 'Context') -> bool:
        ''' Check the operator settings, return True to signal a change to redraw

        :param context: 
        :type context: 'Context'
        :rtype: bool
        :return: result
        '''
        pass

    def invoke(self, context: 'Context', event: 'Event'
               ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Invoke the operator

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result
        '''
        pass

    def modal(self, context: 'Context', event: 'Event'
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Modal operator function

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass

    def cancel(self, context: 'Context'):
        ''' Called when the operator is canceled

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def description(cls, context: 'Context',
                    properties: 'OperatorProperties') -> str:
        ''' Compute a description string that depends on parameters

        :param context: 
        :type context: 'Context'
        :param properties: 
        :type properties: 'OperatorProperties'
        :rtype: str
        :return: result
        '''
        pass

    def as_keywords(self, *, ignore=()):
        ''' Return a copy of the properties as a dictionary

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    @classmethod
    def poll_message_set(cls, message: typing.Optional[str], *args):
        ''' Set the message to show in the tool-tip when poll fails. When message is callable, additional user defined positional arguments are passed to the message function.

        :param message: The message or a function that returns the message.
        :type message: typing.Optional[str]
        '''
        pass


class OperatorMacro(bpy_struct):
    ''' Storage of a sub operator in a macro after it has been added
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class OperatorOptions(bpy_struct):
    ''' Runtime options
    '''

    is_grab_cursor: typing.Union[bool, typing.Any] = None
    ''' True when the cursor is grabbed

    :type: typing.Union[bool, typing.Any]
    '''

    is_invoke: typing.Union[bool, typing.Any] = None
    ''' True when invoked (even if only the execute callbacks available)

    :type: typing.Union[bool, typing.Any]
    '''

    is_repeat: typing.Union[bool, typing.Any] = None
    ''' True when run from the 'Adjust Last Operation' panel

    :type: typing.Union[bool, typing.Any]
    '''

    is_repeat_last: typing.Union[bool, typing.Any] = None
    ''' True when run from the operator 'Repeat Last'

    :type: typing.Union[bool, typing.Any]
    '''

    use_cursor_region: bool = None
    ''' Enable to use the region under the cursor for modal execution

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class OperatorProperties(bpy_struct):
    ''' Input properties of an operator
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PackedFile(bpy_struct):
    ''' External file packed into the .blend file
    '''

    data: typing.Union[str, typing.Any] = None
    ''' Raw data (bytes, exact content of the embedded file)

    :type: typing.Union[str, typing.Any]
    '''

    size: int = None
    ''' Size of packed file in bytes

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Paint(bpy_struct):
    brush: 'Brush' = None
    ''' Active Brush

    :type: 'Brush'
    '''

    cavity_curve: 'CurveMapping' = None
    ''' Editable cavity curve

    :type: 'CurveMapping'
    '''

    input_samples: int = None
    ''' Average multiple input samples together to smooth the brush stroke

    :type: int
    '''

    palette: 'Palette' = None
    ''' Active Palette

    :type: 'Palette'
    '''

    show_brush: bool = None
    ''' 

    :type: bool
    '''

    show_brush_on_surface: bool = None
    ''' 

    :type: bool
    '''

    show_low_resolution: bool = None
    ''' For multires, show low resolution while navigating the view

    :type: bool
    '''

    tile_offset: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' Stride at which tiled strokes are copied

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tile_x: bool = None
    ''' Tile along X axis

    :type: bool
    '''

    tile_y: bool = None
    ''' Tile along Y axis

    :type: bool
    '''

    tile_z: bool = None
    ''' Tile along Z axis

    :type: bool
    '''

    tool_slots: bpy_prop_collection['PaintToolSlot'] = None
    ''' 

    :type: bpy_prop_collection['PaintToolSlot']
    '''

    use_cavity: bool = None
    ''' Mask painting according to mesh geometry cavity

    :type: bool
    '''

    use_sculpt_delay_updates: bool = None
    ''' Update the geometry when it enters the view, providing faster view navigation

    :type: bool
    '''

    use_symmetry_feather: bool = None
    ''' Reduce the strength of the brush where it overlaps symmetrical daubs

    :type: bool
    '''

    use_symmetry_x: bool = None
    ''' Mirror brush across the X axis

    :type: bool
    '''

    use_symmetry_y: bool = None
    ''' Mirror brush across the Y axis

    :type: bool
    '''

    use_symmetry_z: bool = None
    ''' Mirror brush across the Z axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PaintModeSettings(bpy_struct):
    ''' Properties of paint mode
    '''

    canvas_image: 'Image' = None
    ''' Image used as painting target

    :type: 'Image'
    '''

    canvas_source: typing.Union[str, int] = None
    ''' Source to select canvas from

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PaintToolSlot(bpy_struct):
    brush: 'Brush' = None
    ''' 

    :type: 'Brush'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PaletteColor(bpy_struct):
    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    strength: float = None
    ''' 

    :type: float
    '''

    weight: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Panel(bpy_struct):
    ''' Panel containing UI elements
    '''

    bl_category: typing.Union[str, typing.Any] = None
    ''' The category (tab) in which the panel will be displayed, when applicable

    :type: typing.Union[str, typing.Any]
    '''

    bl_context: typing.Union[str, typing.Any] = None
    ''' The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type)

    :type: typing.Union[str, typing.Any]
    '''

    bl_description: str = None
    ''' The panel tooltip

    :type: str
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is "OBJECT_PT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_PT_hello"

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The panel label, shows up in the panel header at the right of the triangle used to collapse the panel

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this panel type * ``DEFAULT_CLOSED`` Default Closed -- Defines if the panel has to be open or collapsed at the time of its creation. * ``HIDE_HEADER`` Hide Header -- If set to False, the panel shows a header, which contains a clickable arrow to collapse the panel and the label (see bl_label). * ``INSTANCED`` Instanced Panel -- Multiple panels with this type can be used as part of a list depending on data external to the UI. Used to create panels for the modifiers and other stacks. * ``HEADER_LAYOUT_EXPAND`` Expand Header Layout -- Allow buttons in the header to stretch and shrink to fill the entire layout width.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_order: int = None
    ''' Panels with lower numbers are default ordered before panels with higher numbers

    :type: int
    '''

    bl_owner_id: typing.Union[str, typing.Any] = None
    ''' The ID owning the data displayed in the panel, if any

    :type: typing.Union[str, typing.Any]
    '''

    bl_parent_id: typing.Union[str, typing.Any] = None
    ''' If this is set, the panel becomes a sub-panel

    :type: typing.Union[str, typing.Any]
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' Specific translation context, only define when the label needs to be disambiguated from others using the exact same label

    :type: typing.Union[str, typing.Any]
    '''

    bl_ui_units_x: int = None
    ''' When set, defines popup panel width

    :type: int
    '''

    custom_data: 'Constraint' = None
    ''' Panel data

    :type: 'Constraint'
    '''

    is_popover: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the panel in the UI

    :type: 'UILayout'
    '''

    text: typing.Union[str, typing.Any] = None
    ''' XXX todo

    :type: typing.Union[str, typing.Any]
    '''

    use_pin: bool = None
    ''' Show the panel on all tabs

    :type: bool
    '''

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' If this method returns a non-null output, then the panel can be drawn

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw UI elements into the panel UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_header(self, context: 'Context'):
        ''' Draw UI elements into the panel's header UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_header_preset(self, context: 'Context'):
        ''' Draw UI elements for presets in the panel's header

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Particle(bpy_struct):
    ''' Particle in a particle system
    '''

    alive_state: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    angular_velocity: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    birth_time: float = None
    ''' 

    :type: float
    '''

    die_time: float = None
    ''' 

    :type: float
    '''

    hair_keys: bpy_prop_collection['ParticleHairKey'] = None
    ''' 

    :type: bpy_prop_collection['ParticleHairKey']
    '''

    is_exist: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_visible: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    lifetime: float = None
    ''' 

    :type: float
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    particle_keys: bpy_prop_collection['ParticleKey'] = None
    ''' 

    :type: bpy_prop_collection['ParticleKey']
    '''

    prev_angular_velocity: typing.Union[typing.List[float], typing.
                                        Tuple[float, float, float],
                                        'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    prev_location: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    prev_rotation: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float, float],
                                'mathutils.Quaternion'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    prev_velocity: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    rotation: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float, float],
                           'mathutils.Quaternion'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    size: float = None
    ''' 

    :type: float
    '''

    velocity: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    def uv_on_emitter(
            self, modifier: 'ParticleSystemModifier'
    ) -> typing.Union[typing.List[float], typing.
                      Tuple[float, float], 'mathutils.Vector']:
        ''' Obtain UV coordinates for a particle on an evaluated mesh.

        :param modifier: Particle modifier from an evaluated object
        :type modifier: 'ParticleSystemModifier'
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
        :return: uv
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleBrush(bpy_struct):
    ''' Particle editing brush
    '''

    count: int = None
    ''' Particle count

    :type: int
    '''

    curve: 'CurveMapping' = None
    ''' 

    :type: 'CurveMapping'
    '''

    length_mode: typing.Union[str, int] = None
    ''' * ``GROW`` Grow -- Make hairs longer. * ``SHRINK`` Shrink -- Make hairs shorter.

    :type: typing.Union[str, int]
    '''

    puff_mode: typing.Union[str, int] = None
    ''' * ``ADD`` Add -- Make hairs more puffy. * ``SUB`` Sub -- Make hairs less puffy.

    :type: typing.Union[str, int]
    '''

    size: int = None
    ''' Radius of the brush in pixels

    :type: int
    '''

    steps: int = None
    ''' Brush steps

    :type: int
    '''

    strength: float = None
    ''' Brush strength

    :type: float
    '''

    use_puff_volume: bool = None
    ''' Apply puff to unselected end-points (helps maintain hair volume when puffing root)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleDupliWeight(bpy_struct):
    ''' Weight of a particle instance object in a collection
    '''

    count: int = None
    ''' The number of times this object is repeated with respect to other objects

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle instance object name

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleEdit(bpy_struct):
    ''' Properties of particle editing mode
    '''

    brush: 'ParticleBrush' = None
    ''' 

    :type: 'ParticleBrush'
    '''

    default_key_count: int = None
    ''' How many keys to make new particles with

    :type: int
    '''

    display_step: int = None
    ''' How many steps to display the path with

    :type: int
    '''

    emitter_distance: float = None
    ''' Distance to keep particles away from the emitter

    :type: float
    '''

    fade_frames: int = None
    ''' How many frames to fade

    :type: int
    '''

    is_editable: typing.Union[bool, typing.Any] = None
    ''' A valid edit mode exists

    :type: typing.Union[bool, typing.Any]
    '''

    is_hair: typing.Union[bool, typing.Any] = None
    ''' Editing hair

    :type: typing.Union[bool, typing.Any]
    '''

    object: 'Object' = None
    ''' The edited object

    :type: 'Object'
    '''

    select_mode: typing.Union[str, int] = None
    ''' Particle select and display mode * ``PATH`` Path -- Path edit mode. * ``POINT`` Point -- Point select mode. * ``TIP`` Tip -- Tip select mode.

    :type: typing.Union[str, int]
    '''

    shape_object: 'Object' = None
    ''' Outer shape to use for tools

    :type: 'Object'
    '''

    show_particles: bool = None
    ''' Display actual particles

    :type: bool
    '''

    tool: typing.Union[str, int] = None
    ''' * ``COMB`` Comb -- Comb hairs. * ``SMOOTH`` Smooth -- Smooth hairs. * ``ADD`` Add -- Add hairs. * ``LENGTH`` Length -- Make hairs longer or shorter. * ``PUFF`` Puff -- Make hairs stand up. * ``CUT`` Cut -- Cut hairs. * ``WEIGHT`` Weight -- Weight hair particles.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_auto_velocity: bool = None
    ''' Calculate point velocities automatically

    :type: bool
    '''

    use_default_interpolate: bool = None
    ''' Interpolate new particles from the existing ones

    :type: bool
    '''

    use_emitter_deflect: bool = None
    ''' Keep paths from intersecting the emitter

    :type: bool
    '''

    use_fade_time: bool = None
    ''' Fade paths and keys further away from current frame

    :type: bool
    '''

    use_preserve_length: bool = None
    ''' Keep path lengths constant

    :type: bool
    '''

    use_preserve_root: bool = None
    ''' Keep root keys unmodified

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleHairKey(bpy_struct):
    ''' Particle key for hair particle system
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of the hair key in object space

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    co_local: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' Location of the hair key in its local coordinate system, relative to the emitting face

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    time: float = None
    ''' Relative time of key over hair length

    :type: float
    '''

    weight: float = None
    ''' Weight for cloth simulation

    :type: float
    '''

    def co_object(
            self, object: 'Object', modifier: 'ParticleSystemModifier',
            particle: 'Particle'
    ) -> typing.Union[typing.List[float], typing.
                      Tuple[float, float, float], 'mathutils.Vector']:
        ''' Obtain hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
        :return: Co, Exported hairkey location
        '''
        pass

    def co_object_set(
            self, object: 'Object', modifier: 'ParticleSystemModifier',
            particle: 'Particle', co: typing.Optional[
                typing.Union[typing.List[float], typing.
                             Tuple[float, float, float], 'mathutils.Vector']]):
        ''' Set hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :param co: Co, Specified hairkey location
        :type co: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleKey(bpy_struct):
    ''' Key location for a particle over time
    '''

    angular_velocity: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Vector'] = None
    ''' Key angular velocity

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' Key location

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    rotation: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float, float],
                           'mathutils.Quaternion'] = None
    ''' Key rotation quaternion

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    time: float = None
    ''' Time of key over the simulation

    :type: float
    '''

    velocity: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' Key velocity

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleSystem(bpy_struct):
    ''' Particle system in an object
    '''

    active_particle_target: 'ParticleTarget' = None
    ''' 

    :type: 'ParticleTarget'
    '''

    active_particle_target_index: int = None
    ''' 

    :type: int
    '''

    child_particles: bpy_prop_collection['ChildParticle'] = None
    ''' Child particles generated by the particle system

    :type: bpy_prop_collection['ChildParticle']
    '''

    child_seed: int = None
    ''' Offset in the random number table for child particles, to get a different randomized result

    :type: int
    '''

    cloth: 'ClothModifier' = None
    ''' Cloth dynamics for hair

    :type: 'ClothModifier'
    '''

    dt_frac: float = None
    ''' The current simulation time step size, as a fraction of a frame

    :type: float
    '''

    has_multiple_caches: typing.Union[bool, typing.Any] = None
    ''' Particle system has multiple point caches

    :type: typing.Union[bool, typing.Any]
    '''

    invert_vertex_group_clump: bool = None
    ''' Negate the effect of the clump vertex group

    :type: bool
    '''

    invert_vertex_group_density: bool = None
    ''' Negate the effect of the density vertex group

    :type: bool
    '''

    invert_vertex_group_field: bool = None
    ''' Negate the effect of the field vertex group

    :type: bool
    '''

    invert_vertex_group_kink: bool = None
    ''' Negate the effect of the kink vertex group

    :type: bool
    '''

    invert_vertex_group_length: bool = None
    ''' Negate the effect of the length vertex group

    :type: bool
    '''

    invert_vertex_group_rotation: bool = None
    ''' Negate the effect of the rotation vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_1: bool = None
    ''' Negate the effect of the roughness 1 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_2: bool = None
    ''' Negate the effect of the roughness 2 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_end: bool = None
    ''' Negate the effect of the roughness end vertex group

    :type: bool
    '''

    invert_vertex_group_size: bool = None
    ''' Negate the effect of the size vertex group

    :type: bool
    '''

    invert_vertex_group_tangent: bool = None
    ''' Negate the effect of the tangent vertex group

    :type: bool
    '''

    invert_vertex_group_twist: bool = None
    ''' Negate the effect of the twist vertex group

    :type: bool
    '''

    invert_vertex_group_velocity: bool = None
    ''' Negate the effect of the velocity vertex group

    :type: bool
    '''

    is_editable: typing.Union[bool, typing.Any] = None
    ''' Particle system can be edited in particle mode

    :type: typing.Union[bool, typing.Any]
    '''

    is_edited: typing.Union[bool, typing.Any] = None
    ''' Particle system has been edited in particle mode

    :type: typing.Union[bool, typing.Any]
    '''

    is_global_hair: typing.Union[bool, typing.Any] = None
    ''' Hair keys are in global coordinate space

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle system name

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'Object' = None
    ''' Use this object's coordinate system instead of global coordinate system

    :type: 'Object'
    '''

    particles: bpy_prop_collection['Particle'] = None
    ''' Particles generated by the particle system

    :type: bpy_prop_collection['Particle']
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    reactor_target_object: 'Object' = None
    ''' For reactor systems, the object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    reactor_target_particle_system: int = None
    ''' For reactor systems, index of particle system on the target object

    :type: int
    '''

    seed: int = None
    ''' Offset in the random number table, to get a different randomized result

    :type: int
    '''

    settings: 'ParticleSettings' = None
    ''' Particle system settings

    :type: 'ParticleSettings'
    '''

    targets: bpy_prop_collection['ParticleTarget'] = None
    ''' Target particle systems

    :type: bpy_prop_collection['ParticleTarget']
    '''

    use_hair_dynamics: bool = None
    ''' Enable hair dynamics using cloth simulation

    :type: bool
    '''

    use_keyed_timing: bool = None
    ''' Use key times

    :type: bool
    '''

    vertex_group_clump: typing.Union[str, typing.Any] = None
    ''' Vertex group to control clump

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_density: typing.Union[str, typing.Any] = None
    ''' Vertex group to control density

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_field: typing.Union[str, typing.Any] = None
    ''' Vertex group to control field

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_kink: typing.Union[str, typing.Any] = None
    ''' Vertex group to control kink

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_length: typing.Union[str, typing.Any] = None
    ''' Vertex group to control length

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_rotation: typing.Union[str, typing.Any] = None
    ''' Vertex group to control rotation

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_1: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness 1

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_2: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness 2

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_end: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness end

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_size: typing.Union[str, typing.Any] = None
    ''' Vertex group to control size

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_tangent: typing.Union[str, typing.Any] = None
    ''' Vertex group to control tangent

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_twist: typing.Union[str, typing.Any] = None
    ''' Vertex group to control twist

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_velocity: typing.Union[str, typing.Any] = None
    ''' Vertex group to control velocity

    :type: typing.Union[str, typing.Any]
    '''

    def co_hair(
            self,
            object: 'Object',
            particle_no: typing.Optional[typing.Any] = 0,
            step: typing.Optional[typing.Any] = 0
    ) -> typing.Union[typing.List[float], typing.
                      Tuple[float, float, float], 'mathutils.Vector']:
        ''' Obtain cache hair data

        :param object: Object
        :type object: 'Object'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param step: step no
        :type step: typing.Optional[typing.Any]
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
        :return: Co, Exported hairkey location
        '''
        pass

    def uv_on_emitter(
            self,
            modifier: 'ParticleSystemModifier',
            particle: 'Particle',
            particle_no: typing.Optional[typing.Any] = 0,
            uv_no: typing.Optional[typing.Any] = 0
    ) -> typing.Union[typing.List[float], typing.
                      Tuple[float, float], 'mathutils.Vector']:
        ''' Obtain uv for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param uv_no: UV no
        :type uv_no: typing.Optional[typing.Any]
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], 'mathutils.Vector']
        :return: uv
        '''
        pass

    def mcol_on_emitter(
            self,
            modifier: 'ParticleSystemModifier',
            particle: 'Particle',
            particle_no: typing.Optional[typing.Any] = 0,
            vcol_no: typing.Optional[typing.Any] = 0
    ) -> typing.Union[typing.List[float], typing.
                      Tuple[float, float, float], 'mathutils.Color']:
        ''' Obtain mcol for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param vcol_no: vcol no
        :type vcol_no: typing.Optional[typing.Any]
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
        :return: mcol
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ParticleTarget(bpy_struct):
    ''' Target particle system
    '''

    alliance: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    duration: float = None
    ''' 

    :type: float
    '''

    is_valid: bool = None
    ''' Keyed particles target is valid

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle target name

    :type: typing.Union[str, typing.Any]
    '''

    object: 'Object' = None
    ''' The object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    system: int = None
    ''' The index of particle system on the target object

    :type: int
    '''

    time: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PathCompare(bpy_struct):
    ''' Match paths against this value
    '''

    path: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    use_glob: bool = None
    ''' Enable wildcard globbing

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Point(bpy_struct):
    ''' Point in a point cloud
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    index: int = None
    ''' Index of this point

    :type: int
    '''

    radius: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PointCache(bpy_struct):
    ''' Active point cache for physics simulations
    '''

    compression: typing.Union[str, int] = None
    ''' Compression method to be used * ``NO`` None -- No compression. * ``LIGHT`` Lite -- Fast but not so effective compression. * ``HEAVY`` Heavy -- Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Cache file path

    :type: typing.Union[str, typing.Any]
    '''

    frame_end: int = None
    ''' Frame on which the simulation stops

    :type: int
    '''

    frame_start: int = None
    ''' Frame on which the simulation starts

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between cached frames

    :type: int
    '''

    index: int = None
    ''' Index number of cache files

    :type: int
    '''

    info: typing.Union[str, typing.Any] = None
    ''' Info on current cache status

    :type: typing.Union[str, typing.Any]
    '''

    is_baked: typing.Union[bool, typing.Any] = None
    ''' The cache is baked

    :type: typing.Union[bool, typing.Any]
    '''

    is_baking: typing.Union[bool, typing.Any] = None
    ''' The cache is being baked

    :type: typing.Union[bool, typing.Any]
    '''

    is_frame_skip: typing.Union[bool, typing.Any] = None
    ''' Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    '''

    is_outdated: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Cache name

    :type: typing.Union[str, typing.Any]
    '''

    point_caches: 'PointCaches' = None
    ''' 

    :type: 'PointCaches'
    '''

    use_disk_cache: bool = None
    ''' Save cache files to disk (.blend file must be saved first)

    :type: bool
    '''

    use_external: bool = None
    ''' Read cache from an external location

    :type: bool
    '''

    use_library_path: bool = None
    ''' Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PointCacheItem(bpy_struct):
    ''' Point cache for physics simulations
    '''

    compression: typing.Union[str, int] = None
    ''' Compression method to be used * ``NO`` None -- No compression. * ``LIGHT`` Lite -- Fast but not so effective compression. * ``HEAVY`` Heavy -- Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Cache file path

    :type: typing.Union[str, typing.Any]
    '''

    frame_end: int = None
    ''' Frame on which the simulation stops

    :type: int
    '''

    frame_start: int = None
    ''' Frame on which the simulation starts

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between cached frames

    :type: int
    '''

    index: int = None
    ''' Index number of cache files

    :type: int
    '''

    info: typing.Union[str, typing.Any] = None
    ''' Info on current cache status

    :type: typing.Union[str, typing.Any]
    '''

    is_baked: typing.Union[bool, typing.Any] = None
    ''' The cache is baked

    :type: typing.Union[bool, typing.Any]
    '''

    is_baking: typing.Union[bool, typing.Any] = None
    ''' The cache is being baked

    :type: typing.Union[bool, typing.Any]
    '''

    is_frame_skip: typing.Union[bool, typing.Any] = None
    ''' Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    '''

    is_outdated: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Cache name

    :type: typing.Union[str, typing.Any]
    '''

    use_disk_cache: bool = None
    ''' Save cache files to disk (.blend file must be saved first)

    :type: bool
    '''

    use_external: bool = None
    ''' Read cache from an external location

    :type: bool
    '''

    use_library_path: bool = None
    ''' Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Pose(bpy_struct):
    ''' A collection of pose channels, including settings for animating bones
    '''

    animation_visualization: 'AnimViz' = None
    ''' Animation data for this data-block

    :type: 'AnimViz'
    '''

    bones: bpy_prop_collection['PoseBone'] = None
    ''' Individual pose bones for the armature

    :type: bpy_prop_collection['PoseBone']
    '''

    ik_param: 'IKParam' = None
    ''' Parameters for IK solver

    :type: 'IKParam'
    '''

    ik_solver: typing.Union[str, int] = None
    ''' Selection of IK solver for IK chain * ``LEGACY`` Standard -- Original IK solver. * ``ITASC`` iTaSC -- Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''

    use_auto_ik: bool = None
    ''' Add temporary IK constraints while grabbing bones in Pose Mode

    :type: bool
    '''

    use_mirror_relative: bool = None
    ''' Apply relative transformations in X-mirror mode (not supported with Auto IK)

    :type: bool
    '''

    use_mirror_x: bool = None
    ''' Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    '''

    @classmethod
    def apply_pose_from_action(
            cls,
            action: typing.Optional['Action'],
            evaluation_time: typing.Optional[typing.Any] = 0.0):
        ''' Apply the given action to this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        '''
        pass

    @classmethod
    def blend_pose_from_action(
            cls,
            action: typing.Optional['Action'],
            blend_factor: typing.Optional[typing.Any] = 1.0,
            evaluation_time: typing.Optional[typing.Any] = 0.0):
        ''' Blend the given action into this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param blend_factor: Blend Factor, How much the given Action affects the final pose
        :type blend_factor: typing.Optional[typing.Any]
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        '''
        pass

    @classmethod
    def backup_create(cls, action: typing.Optional['Action']):
        ''' Create a backup of the current pose. Only those bones that are animated in the Action are backed up. The object owns the backup, and each object can have only one backup at a time. When you no longer need it, it must be freed use `backup_clear()`

        :param action: Action, An Action with animation data for the bones. Only the animated bones will be included in the backup
        :type action: typing.Optional['Action']
        '''
        pass

    @classmethod
    def backup_restore(cls) -> bool:
        ''' Restore the previously made pose backup. This can be called multiple times. See `Pose.backup_create()` for more info

        :rtype: bool
        :return: `True` when the backup was restored, `False` if there was no backup to restore
        '''
        pass

    @classmethod
    def backup_clear(cls):
        ''' Free a previously made pose backup. See `Pose.backup_create()` for more info.

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PoseBone(bpy_struct):
    ''' Channel defining pose data for a bone in a Pose
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveinz: float = None
    ''' Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutz: float = None
    ''' Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'PoseBone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_custom_handle_start: 'PoseBone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_easein: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_easeout: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bbone_scaleout: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Vector'] = None
    ''' Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    bone: 'Bone' = None
    ''' Bone associated with this PoseBone

    :type: 'Bone'
    '''

    child: 'PoseBone' = None
    ''' Child of this pose bone

    :type: 'PoseBone'
    '''

    color: 'BoneColor' = None
    ''' 

    :type: 'BoneColor'
    '''

    constraints: 'PoseBoneConstraints' = None
    ''' Constraints that act on this pose channel

    :type: 'PoseBoneConstraints'
    '''

    custom_shape: 'Object' = None
    ''' Object that defines custom display shape for this bone

    :type: 'Object'
    '''

    custom_shape_rotation_euler: typing.Union[typing.List[float], typing.
                                              Tuple[float, float, float],
                                              'mathutils.Euler'] = None
    ''' Adjust the rotation of the custom shape

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Euler']
    '''

    custom_shape_scale_xyz: typing.Union[typing.List[float], typing.
                                         Tuple[float, float, float],
                                         'mathutils.Vector'] = None
    ''' Adjust the size of the custom shape

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    custom_shape_transform: 'PoseBone' = None
    ''' Bone that defines the display transform of this custom shape

    :type: 'PoseBone'
    '''

    custom_shape_translation: typing.Union[typing.List[float], typing.
                                           Tuple[float, float, float],
                                           'mathutils.Vector'] = None
    ''' Adjust the location of the custom shape

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    head: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of head of the channel's bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    ik_linear_weight: float = None
    ''' Weight of scale constraint for IK

    :type: float
    '''

    ik_max_x: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_y: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_z: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_min_x: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_y: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_z: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_rotation_weight: float = None
    ''' Weight of rotation constraint for IK

    :type: float
    '''

    ik_stiffness_x: float = None
    ''' IK stiffness around the X axis

    :type: float
    '''

    ik_stiffness_y: float = None
    ''' IK stiffness around the Y axis

    :type: float
    '''

    ik_stiffness_z: float = None
    ''' IK stiffness around the Z axis

    :type: float
    '''

    ik_stretch: float = None
    ''' Allow scaling of the bone for IK

    :type: float
    '''

    is_in_ik_chain: typing.Union[bool, typing.Any] = None
    ''' Is part of an IK chain

    :type: typing.Union[bool, typing.Any]
    '''

    length: float = None
    ''' Length of the bone

    :type: float
    '''

    location: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    lock_ik_x: bool = None
    ''' Disallow movement around the X axis

    :type: bool
    '''

    lock_ik_y: bool = None
    ''' Disallow movement around the Y axis

    :type: bool
    '''

    lock_ik_z: bool = None
    ''' Disallow movement around the Z axis

    :type: bool
    '''

    lock_location: typing.List[bool] = None
    ''' Lock editing of location when transforming

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    ''' Lock editing of rotation when transforming

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    ''' Lock editing of 'angle' component of four-component rotations when transforming

    :type: bool
    '''

    lock_rotations_4d: bool = None
    ''' Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    ''' Lock editing of scale when transforming

    :type: typing.List[bool]
    '''

    matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Final 4×4 matrix after constraints and drivers are applied, in the armature object space

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_basis: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Alternative access to location/scale/rotation relative to the parent and own rest bone

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    matrix_channel: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' 4×4 matrix of the bone's location/rotation/scale channels (including animation and drivers) and the effect of bone constraints

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    motion_path: 'MotionPath' = None
    ''' Motion Path for this element

    :type: 'MotionPath'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'PoseBone' = None
    ''' Parent of this pose bone

    :type: 'PoseBone'
    '''

    rotation_axis_angle: bpy_prop_array[float] = None
    ''' Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    '''

    rotation_euler: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Euler'] = None
    ''' Rotation in Eulers

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Euler']
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float, float],
                                      'mathutils.Quaternion'] = None
    ''' Rotation in Quaternions

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    scale: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    tail: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Location of tail of the channel's bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    use_custom_shape_bone_size: bool = None
    ''' Scale the custom object by the bone length

    :type: bool
    '''

    use_ik_limit_x: bool = None
    ''' Limit movement around the X axis

    :type: bool
    '''

    use_ik_limit_y: bool = None
    ''' Limit movement around the Y axis

    :type: bool
    '''

    use_ik_limit_z: bool = None
    ''' Limit movement around the Z axis

    :type: bool
    '''

    use_ik_linear_control: bool = None
    ''' Apply channel size as IK constraint if stretching is enabled

    :type: bool
    '''

    use_ik_rotation_control: bool = None
    ''' Apply channel rotation as IK constraint

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. .. note:: Takes ``O(len(bones)**2)`` time. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(self, point: typing.Optional[
            typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector']]
                          ) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def bbone_segment_index(self, point: typing.Optional[
            typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector']]):
        ''' Retrieve the index and blend factor of the B-Bone segments based on vertex position

        :param point: Point, Vertex position in armature pose space
        :type point: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        '''
        pass

    def bbone_segment_matrix(
            self,
            index: typing.Optional[int],
            rest: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> typing.Union[typing.List[typing.List[float]], typing.
                      Tuple[typing.Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float], typing.
                            Tuple[float, float, float, float]],
                      'mathutils.Matrix']:
        ''' Retrieve the matrix of the joint between B-Bone segments if available This example shows how to use B-Bone segment matrices to emulate deformation produced by the Armature modifier or constraint when assigned to the given bone (without Preserve Volume). The coordinates are processed in armature Pose space:

        :param index: Index of the segment endpoint
        :type index: typing.Optional[int]
        :param rest: Return the rest pose matrix
        :type rest: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
        :return: The resulting matrix in bone local space
        '''
        pass

    def compute_bbone_handles(
            self,
            rest: typing.Optional[typing.Union[bool, typing.Any]] = False,
            ease: typing.Optional[typing.Union[bool, typing.Any]] = False,
            offsets: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Retrieve the vectors and rolls coming from B-Bone custom handles

        :param rest: Return the rest pose state
        :type rest: typing.Optional[typing.Union[bool, typing.Any]]
        :param ease: Apply scale from ease values
        :type ease: typing.Optional[typing.Union[bool, typing.Any]]
        :param offsets: Apply roll and curve offsets from bone properties
        :type offsets: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Preferences(bpy_struct):
    ''' Global preferences
    '''

    active_section: typing.Union[str, int] = None
    ''' Active section of the preferences shown in the user interface

    :type: typing.Union[str, int]
    '''

    addons: 'Addons' = None
    ''' 

    :type: 'Addons'
    '''

    app_template: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    apps: 'PreferencesApps' = None
    ''' Preferences that work only for apps

    :type: 'PreferencesApps'
    '''

    autoexec_paths: 'PathCompareCollection' = None
    ''' 

    :type: 'PathCompareCollection'
    '''

    edit: 'PreferencesEdit' = None
    ''' Settings for interacting with Blender data

    :type: 'PreferencesEdit'
    '''

    experimental: 'PreferencesExperimental' = None
    ''' Settings for features that are still early in their development stage

    :type: 'PreferencesExperimental'
    '''

    filepaths: 'PreferencesFilePaths' = None
    ''' Default paths for external files

    :type: 'PreferencesFilePaths'
    '''

    inputs: 'PreferencesInput' = None
    ''' Settings for input devices

    :type: 'PreferencesInput'
    '''

    is_dirty: bool = None
    ''' Preferences have changed

    :type: bool
    '''

    keymap: 'PreferencesKeymap' = None
    ''' Shortcut setup for keyboards and other input devices

    :type: 'PreferencesKeymap'
    '''

    studio_lights: 'StudioLights' = None
    ''' 

    :type: 'StudioLights'
    '''

    system: 'PreferencesSystem' = None
    ''' Graphics driver and operating system settings

    :type: 'PreferencesSystem'
    '''

    themes: bpy_prop_collection['Theme'] = None
    ''' 

    :type: bpy_prop_collection['Theme']
    '''

    ui_styles: bpy_prop_collection['ThemeStyle'] = None
    ''' 

    :type: bpy_prop_collection['ThemeStyle']
    '''

    use_preferences_save: bool = None
    ''' Save preferences on exit when modified (unless factory settings have been loaded)

    :type: bool
    '''

    use_recent_searches: bool = None
    ''' Sort the recently searched items at the top

    :type: bool
    '''

    version: bpy_prop_array[int] = None
    ''' Version of Blender the userpref.blend was saved with

    :type: bpy_prop_array[int]
    '''

    view: 'PreferencesView' = None
    ''' Preferences related to viewing data

    :type: 'PreferencesView'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesApps(bpy_struct):
    ''' Preferences that work only for apps
    '''

    show_corner_split: bool = None
    ''' Split and join editors by dragging from corners

    :type: bool
    '''

    show_edge_resize: bool = None
    ''' Resize editors by dragging from the edges

    :type: bool
    '''

    show_regions_visibility_toggle: bool = None
    ''' Header and side bars visibility toggles

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesEdit(bpy_struct):
    ''' Settings for interacting with Blender data
    '''

    auto_keying_mode: typing.Union[str, int] = None
    ''' Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: typing.Union[str, int]
    '''

    collection_instance_empty_size: float = None
    ''' Display size of the empty when new collection instances are created

    :type: float
    '''

    fcurve_new_auto_smoothing: typing.Union[str, int] = None
    ''' Auto Handle Smoothing mode used for newly added F-Curves

    :type: typing.Union[str, int]
    '''

    fcurve_unselected_alpha: float = None
    ''' The opacity of unselected F-Curves against the background of the Graph Editor

    :type: float
    '''

    grease_pencil_default_color: bpy_prop_array[float] = None
    ''' Color of new annotation layers

    :type: bpy_prop_array[float]
    '''

    grease_pencil_eraser_radius: int = None
    ''' Radius of eraser 'brush'

    :type: int
    '''

    grease_pencil_euclidean_distance: int = None
    ''' Distance moved by mouse when drawing stroke to include

    :type: int
    '''

    grease_pencil_manhattan_distance: int = None
    ''' Pixels moved by mouse per axis when drawing stroke

    :type: int
    '''

    keyframe_new_handle_type: typing.Union[str, int] = None
    ''' Handle type for handles of new keyframes

    :type: typing.Union[str, int]
    '''

    keyframe_new_interpolation_type: typing.Union[str, int] = None
    ''' Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe)

    :type: typing.Union[str, int]
    '''

    material_link: typing.Union[str, int] = None
    ''' Toggle whether the material is linked to object data or the object block * ``OBDATA`` Object Data -- Toggle whether the material is linked to object data or the object block. * ``OBJECT`` Object -- Toggle whether the material is linked to object data or the object block.

    :type: typing.Union[str, int]
    '''

    node_margin: int = None
    ''' Minimum distance between nodes for Auto-offsetting nodes

    :type: int
    '''

    node_preview_resolution: int = None
    ''' Resolution used for Shader node previews (should be changed for performance convenience)

    :type: int
    '''

    node_use_insert_offset: bool = None
    ''' Automatically offset the following or previous nodes in a chain when inserting a new node

    :type: bool
    '''

    object_align: typing.Union[str, int] = None
    ''' The default alignment for objects added from a 3D viewport menu * ``WORLD`` World -- Align newly added objects to the world coordinate system. * ``VIEW`` View -- Align newly added objects to the active 3D view orientation. * ``CURSOR`` 3D Cursor -- Align newly added objects to the 3D Cursor's rotation.

    :type: typing.Union[str, int]
    '''

    sculpt_paint_overlay_color: typing.Union[typing.List[float], typing.
                                             Tuple[float, float, float],
                                             'mathutils.Color'] = None
    ''' Color of texture overlay

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    show_only_selected_curve_keyframes: bool = None
    ''' Only keyframes of selected F-Curves are visible and editable

    :type: bool
    '''

    undo_memory_limit: int = None
    ''' Maximum memory usage in megabytes (0 means unlimited)

    :type: int
    '''

    undo_steps: int = None
    ''' Number of undo steps available (smaller values conserve memory)

    :type: int
    '''

    use_anim_channel_group_colors: bool = None
    ''' Use animation channel group colors; generally this is used to show bone group colors

    :type: bool
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: bool
    '''

    use_auto_keying_warning: bool = None
    ''' Show warning indicators when transforming objects and bones if auto keying is enabled

    :type: bool
    '''

    use_cursor_lock_adjust: bool = None
    ''' Place the cursor without 'jumping' to the new location (when lock-to-cursor is used)

    :type: bool
    '''

    use_duplicate_action: bool = None
    ''' Causes actions to be duplicated with the data-blocks

    :type: bool
    '''

    use_duplicate_armature: bool = None
    ''' Causes armature data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_camera: bool = None
    ''' Causes camera data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_curve: bool = None
    ''' Causes curve data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_curves: bool = None
    ''' Causes curves data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_grease_pencil: bool = None
    ''' Causes grease pencil data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_lattice: bool = None
    ''' Causes lattice data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_light: bool = None
    ''' Causes light data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_lightprobe: bool = None
    ''' Causes light probe data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_material: bool = None
    ''' Causes material data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_mesh: bool = None
    ''' Causes mesh data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_metaball: bool = None
    ''' Causes metaball data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_node_tree: bool = None
    ''' Make copies of node groups when duplicating nodes in the node editor

    :type: bool
    '''

    use_duplicate_particle: bool = None
    ''' Causes particle systems to be duplicated with the object

    :type: bool
    '''

    use_duplicate_pointcloud: bool = None
    ''' Causes point cloud data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_speaker: bool = None
    ''' Causes speaker data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_surface: bool = None
    ''' Causes surface data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_text: bool = None
    ''' Causes text data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_volume: bool = None
    ''' Causes volume data to be duplicated with the object

    :type: bool
    '''

    use_enter_edit_mode: bool = None
    ''' Enter edit mode automatically after adding a new object

    :type: bool
    '''

    use_fcurve_high_quality_drawing: bool = None
    ''' Draw F-Curves using Anti-Aliasing (disable for better performance)

    :type: bool
    '''

    use_global_undo: bool = None
    ''' Global undo works by keeping a full copy of the file itself in memory, so takes extra memory

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis

    :type: bool
    '''

    use_keyframe_insert_available: bool = None
    ''' Automatic keyframe insertion in available F-Curves

    :type: bool
    '''

    use_keyframe_insert_needed: bool = None
    ''' Keyframe insertion only when keyframe needed

    :type: bool
    '''

    use_mouse_depth_cursor: bool = None
    ''' Use the surface depth for cursor placement

    :type: bool
    '''

    use_negative_frames: bool = None
    ''' Current frame number can be manually set to a negative value

    :type: bool
    '''

    use_text_edit_auto_close: bool = None
    ''' Automatically close relevant character pairs when typing in the text editor

    :type: bool
    '''

    use_visual_keying: bool = None
    ''' Use Visual keying automatically for constrained objects

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesExperimental(bpy_struct):
    ''' Experimental features
    '''

    enable_eevee_next: bool = None
    ''' Enable the new EEVEE codebase, requires restart

    :type: bool
    '''

    enable_overlay_next: bool = None
    ''' Enable the new Overlay codebase, requires restart

    :type: bool
    '''

    override_auto_resync: bool = None
    ''' Enable library overrides automatic resync detection and process on file load. Disable when dealing with older .blend files that need manual Resync (Enforce) handling

    :type: bool
    '''

    show_asset_debug_info: bool = None
    ''' Enable some extra fields in the Asset Browser to aid in debugging

    :type: bool
    '''

    use_all_linked_data_direct: bool = None
    ''' Forces all linked data to be considered as directly linked. Workaround for current issues/limitations in BAT (Blender studio pipeline tool)

    :type: bool
    '''

    use_asset_indexing: bool = None
    ''' Disabling the asset indexer forces every asset library refresh to completely reread assets from disk

    :type: bool
    '''

    use_cycles_debug: bool = None
    ''' Enable Cycles debugging options for developers

    :type: bool
    '''

    use_eevee_debug: bool = None
    ''' Enable EEVEE debugging options for developers

    :type: bool
    '''

    use_experimental_compositors: bool = None
    ''' Enable compositor full frame and realtime GPU execution mode options (no tiling, reduces execution time and memory usage)

    :type: bool
    '''

    use_extended_asset_browser: bool = None
    ''' Enable Asset Browser editor and operators to manage regular data-blocks as assets, not just poses

    :type: bool
    '''

    use_extension_repos: bool = None
    ''' Enables extension repositories, accessible from the "Extension Repositories" panel in the "File Paths" section of the preferences. These paths are exposed as add-ons, package management is not yet integrated

    :type: bool
    '''

    use_grease_pencil_version3: bool = None
    ''' Enable the new grease pencil 3.0 codebase

    :type: bool
    '''

    use_new_curves_tools: bool = None
    ''' Enable additional features for the new curves data block

    :type: bool
    '''

    use_new_point_cloud_type: bool = None
    ''' Enable the new point cloud type in the ui

    :type: bool
    '''

    use_new_volume_nodes: bool = None
    ''' Enables visibility of the new Volume nodes in the UI

    :type: bool
    '''

    use_override_templates: bool = None
    ''' Enable library override template in the Python API

    :type: bool
    '''

    use_sculpt_texture_paint: bool = None
    ''' Use texture painting in Sculpt Mode

    :type: bool
    '''

    use_sculpt_tools_tilt: bool = None
    ''' Support for pen tablet tilt events in Sculpt Mode

    :type: bool
    '''

    use_shader_node_previews: bool = None
    ''' Enables previews in the shader node editor

    :type: bool
    '''

    use_undo_legacy: bool = None
    ''' Use legacy undo (slower than the new default one, but may be more stable in some cases)

    :type: bool
    '''

    use_viewport_debug: bool = None
    ''' Enable viewport debugging options for developers in the overlays pop-over

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesFilePaths(bpy_struct):
    ''' Default paths for external files
    '''

    active_asset_library: int = None
    ''' Index of the asset library being edited in the Preferences UI

    :type: int
    '''

    active_extension_repo: int = None
    ''' Index of the extensions repository being edited in the Preferences UI

    :type: int
    '''

    animation_player: typing.Union[str, typing.Any] = None
    ''' Path to a custom animation/frame sequence player

    :type: typing.Union[str, typing.Any]
    '''

    animation_player_preset: typing.Union[str, int] = None
    ''' Preset configs for external animation players * ``INTERNAL`` Internal -- Built-in animation player. * ``DJV`` DJV -- Open source frame player. * ``FRAMECYCLER`` FrameCycler -- Frame player from IRIDAS. * ``RV`` RV -- Frame player from Tweak Software. * ``MPLAYER`` MPlayer -- Media player for video and PNG/JPEG/SGI image sequences. * ``CUSTOM`` Custom -- Custom animation player executable path.

    :type: typing.Union[str, int]
    '''

    asset_libraries: bpy_prop_collection['UserAssetLibrary'] = None
    ''' 

    :type: bpy_prop_collection['UserAssetLibrary']
    '''

    auto_save_time: int = None
    ''' The time (in minutes) to wait between automatic temporary saves

    :type: int
    '''

    extension_repos: 'UserExtensionRepoCollection' = None
    ''' 

    :type: 'UserExtensionRepoCollection'
    '''

    file_preview_type: typing.Union[str, int] = None
    ''' What type of blend preview to create * ``NONE`` None -- Do not create blend previews. * ``AUTO`` Auto -- Automatically select best preview type. * ``SCREENSHOT`` Screenshot -- Capture the entire window. * ``CAMERA`` Camera View -- Workbench render of scene.

    :type: typing.Union[str, int]
    '''

    font_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for loading fonts

    :type: typing.Union[str, typing.Any]
    '''

    i18n_branches_directory: typing.Union[str, typing.Any] = None
    ''' The path to the '/branches' directory of your local svn-translation copy, to allow translating from the UI

    :type: typing.Union[str, typing.Any]
    '''

    image_editor: typing.Union[str, typing.Any] = None
    ''' Path to an image editor

    :type: typing.Union[str, typing.Any]
    '''

    recent_files: int = None
    ''' Maximum number of recently opened files to remember

    :type: int
    '''

    render_cache_directory: typing.Union[str, typing.Any] = None
    ''' Where to cache raw render results

    :type: typing.Union[str, typing.Any]
    '''

    render_output_directory: typing.Union[str, typing.Any] = None
    ''' The default directory for rendering output, for new scenes

    :type: typing.Union[str, typing.Any]
    '''

    save_version: int = None
    ''' The number of old versions to maintain in the current directory, when manually saving

    :type: int
    '''

    script_directories: 'ScriptDirectoryCollection' = None
    ''' 

    :type: 'ScriptDirectoryCollection'
    '''

    show_hidden_files_datablocks: bool = None
    ''' Show files and data-blocks that are normally hidden

    :type: bool
    '''

    show_recent_locations: bool = None
    ''' Show Recent locations list in the File Browser

    :type: bool
    '''

    show_system_bookmarks: bool = None
    ''' Show System locations list in the File Browser

    :type: bool
    '''

    sound_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for sounds

    :type: typing.Union[str, typing.Any]
    '''

    temporary_directory: typing.Union[str, typing.Any] = None
    ''' The directory for storing temporary save files

    :type: typing.Union[str, typing.Any]
    '''

    text_editor: typing.Union[str, typing.Any] = None
    ''' Command to launch the text editor, either a full path or a command in $PATH. Use the internal editor when left blank

    :type: typing.Union[str, typing.Any]
    '''

    text_editor_args: typing.Union[str, typing.Any] = None
    ''' Defines the specific format of the arguments with which the text editor opens files. The supported expansions are as follows: $filepath The absolute path of the file. $line The line to open at (Optional). $column The column to open from the beginning of the line (Optional). $line0 & column0 start at zero. Example: -f $filepath -l $line -c $column

    :type: typing.Union[str, typing.Any]
    '''

    texture_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for textures

    :type: typing.Union[str, typing.Any]
    '''

    use_auto_save_temporary_files: bool = None
    ''' Automatic saving of temporary files in temp directory, uses process ID. Warning: Sculpt and edit mode data won't be saved

    :type: bool
    '''

    use_file_compression: bool = None
    ''' Enable file compression when saving .blend files

    :type: bool
    '''

    use_filter_files: bool = None
    ''' Enable filtering of files in the File Browser

    :type: bool
    '''

    use_load_ui: bool = None
    ''' Load user interface setup when loading .blend files

    :type: bool
    '''

    use_relative_paths: bool = None
    ''' Default relative path option for the file selector, when no path is defined yet

    :type: bool
    '''

    use_scripts_auto_execute: bool = None
    ''' Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source)

    :type: bool
    '''

    use_tabs_as_spaces: bool = None
    ''' Automatically convert all new tabs into spaces for new and loaded text files

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesInput(bpy_struct):
    ''' Settings for input devices
    '''

    drag_threshold: int = None
    ''' Number of pixels to drag before a drag event is triggered for keyboard and other non mouse/tablet input (otherwise click events are detected)

    :type: int
    '''

    drag_threshold_mouse: int = None
    ''' Number of pixels to drag before a drag event is triggered for mouse/track-pad input (otherwise click events are detected)

    :type: int
    '''

    drag_threshold_tablet: int = None
    ''' Number of pixels to drag before a drag event is triggered for tablet input (otherwise click events are detected)

    :type: int
    '''

    invert_mouse_zoom: bool = None
    ''' Invert the axis of mouse movement for zooming

    :type: bool
    '''

    invert_zoom_wheel: bool = None
    ''' Swap the Mouse Wheel zoom direction

    :type: bool
    '''

    mouse_double_click_time: int = None
    ''' Time/delay (in ms) for a double click

    :type: int
    '''

    mouse_emulate_3_button_modifier: typing.Union[str, int] = None
    ''' Hold this modifier to emulate the middle mouse button

    :type: typing.Union[str, int]
    '''

    move_threshold: int = None
    ''' Number of pixels to before the cursor is considered to have moved (used for cycling selected items on successive clicks)

    :type: int
    '''

    navigation_mode: typing.Union[str, int] = None
    ''' Which method to use for viewport navigation

    :type: typing.Union[str, int]
    '''

    ndof_deadzone: float = None
    ''' Threshold of initial movement needed from the device's rest position

    :type: float
    '''

    ndof_fly_helicopter: bool = None
    ''' Device up/down directly controls the Z position of the 3D viewport

    :type: bool
    '''

    ndof_lock_camera_pan_zoom: bool = None
    ''' Pan/zoom the camera view instead of leaving the camera view when orbiting

    :type: bool
    '''

    ndof_lock_horizon: bool = None
    ''' Keep horizon level while flying with 3D Mouse

    :type: bool
    '''

    ndof_orbit_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for orbiting

    :type: float
    '''

    ndof_pan_yz_swap_axis: bool = None
    ''' Pan using up/down on the device (otherwise forward/backward)

    :type: bool
    '''

    ndof_panx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_pany_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_panz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_roty_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for panning

    :type: float
    '''

    ndof_show_guide: bool = None
    ''' Display the center and axis during rotation

    :type: bool
    '''

    ndof_view_navigate_method: typing.Union[str, int] = None
    ''' Navigation style in the viewport * ``FREE`` Free -- Use full 6 degrees of freedom by default. * ``ORBIT`` Orbit -- Orbit about the view center by default.

    :type: typing.Union[str, int]
    '''

    ndof_view_rotate_method: typing.Union[str, int] = None
    ''' Rotation style in the viewport * ``TURNTABLE`` Turntable -- Use turntable style rotation in the viewport. * ``TRACKBALL`` Trackball -- Use trackball style rotation in the viewport.

    :type: typing.Union[str, int]
    '''

    ndof_zoom_invert: bool = None
    ''' Zoom using opposite direction

    :type: bool
    '''

    pressure_softness: float = None
    ''' Adjusts softness of the low pressure response onset using a gamma curve

    :type: float
    '''

    pressure_threshold_max: float = None
    ''' Raw input pressure value that is interpreted as 100% by Blender

    :type: float
    '''

    tablet_api: typing.Union[str, int] = None
    ''' Select the tablet API to use for pressure sensitivity (may require restarting Blender for changes to take effect) * ``AUTOMATIC`` Automatic -- Automatically choose Wintab or Windows Ink depending on the device. * ``WINDOWS_INK`` Windows Ink -- Use native Windows Ink API, for modern tablet and pen devices. Requires Windows 8 or newer. * ``WINTAB`` Wintab -- Use Wintab driver for older tablets and Windows versions.

    :type: typing.Union[str, int]
    '''

    use_auto_perspective: bool = None
    ''' Automatically switch between orthographic and perspective when changing from top/front/side views

    :type: bool
    '''

    use_drag_immediately: bool = None
    ''' Moving things with a mouse drag confirms when releasing the button

    :type: bool
    '''

    use_emulate_numpad: bool = None
    ''' Main 1 to 0 keys act as the numpad ones (useful for laptops)

    :type: bool
    '''

    use_mouse_continuous: bool = None
    ''' Let the mouse wrap around the view boundaries so mouse movements are not limited by the screen size (used by transform, dragging of UI controls, etc.)

    :type: bool
    '''

    use_mouse_depth_navigate: bool = None
    ''' Use the depth under the mouse to improve view pan/rotate/zoom functionality

    :type: bool
    '''

    use_mouse_emulate_3_button: bool = None
    ''' Emulate Middle Mouse with Alt+Left Mouse

    :type: bool
    '''

    use_multitouch_gestures: bool = None
    ''' Use multi-touch gestures for navigation with touchpad, instead of scroll wheel emulation

    :type: bool
    '''

    use_ndof: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    use_numeric_input_advanced: bool = None
    ''' When entering numbers while transforming, default to advanced mode for full math expression evaluation

    :type: bool
    '''

    use_rotate_around_active: bool = None
    ''' Use selection as the pivot point

    :type: bool
    '''

    use_zoom_to_mouse: bool = None
    ''' Zoom in towards the mouse pointer's position in the 3D view, rather than the 2D window center

    :type: bool
    '''

    view_rotate_method: typing.Union[str, int] = None
    ''' Orbit method in the viewport * ``TURNTABLE`` Turntable -- Turntable keeps the Z-axis upright while orbiting. * ``TRACKBALL`` Trackball -- Trackball allows you to tumble your view at any angle.

    :type: typing.Union[str, int]
    '''

    view_rotate_sensitivity_trackball: float = None
    ''' Scale trackball orbit sensitivity

    :type: float
    '''

    view_rotate_sensitivity_turntable: float = None
    ''' Rotation amount per pixel to control how fast the viewport orbits

    :type: float
    '''

    view_zoom_axis: typing.Union[str, int] = None
    ''' Axis of mouse movement to zoom in or out on * ``VERTICAL`` Vertical -- Zoom in and out based on vertical mouse movement. * ``HORIZONTAL`` Horizontal -- Zoom in and out based on horizontal mouse movement.

    :type: typing.Union[str, int]
    '''

    view_zoom_method: typing.Union[str, int] = None
    ''' Which style to use for viewport scaling * ``CONTINUE`` Continue -- Continuous zooming. The zoom direction and speed depends on how far along the set Zoom Axis the mouse has moved. * ``DOLLY`` Dolly -- Zoom in and out based on mouse movement along the set Zoom Axis. * ``SCALE`` Scale -- Zoom in and out as if you are scaling the view, mouse movements relative to center.

    :type: typing.Union[str, int]
    '''

    walk_navigation: 'WalkNavigation' = None
    ''' Settings for walk navigation mode

    :type: 'WalkNavigation'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesKeymap(bpy_struct):
    ''' Shortcut setup for keyboards and other input devices
    '''

    active_keyconfig: typing.Union[str, typing.Any] = None
    ''' The name of the active key configuration

    :type: typing.Union[str, typing.Any]
    '''

    show_ui_keyconfig: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesSystem(bpy_struct):
    ''' Graphics driver and operating system settings
    '''

    anisotropic_filter: typing.Union[str, int] = None
    ''' Quality of anisotropic filtering

    :type: typing.Union[str, int]
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * ``MONO`` Mono -- Set audio channels to mono. * ``STEREO`` Stereo -- Set audio channels to stereo. * ``SURROUND4`` 4 Channels -- Set audio channels to 4 channels. * ``SURROUND51`` 5.1 Surround -- Set audio channels to 5.1 surround sound. * ``SURROUND71`` 7.1 Surround -- Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_device: typing.Union[str, int] = None
    ''' Audio output device * ``None`` None -- No device - there will be no audio output.

    :type: typing.Union[str, int]
    '''

    audio_mixing_buffer: typing.Union[str, int] = None
    ''' Number of samples used by the audio mixing buffer * ``SAMPLES_256`` 256 Samples -- Set audio mixing buffer size to 256 samples. * ``SAMPLES_512`` 512 Samples -- Set audio mixing buffer size to 512 samples. * ``SAMPLES_1024`` 1024 Samples -- Set audio mixing buffer size to 1024 samples. * ``SAMPLES_2048`` 2048 Samples -- Set audio mixing buffer size to 2048 samples. * ``SAMPLES_4096`` 4096 Samples -- Set audio mixing buffer size to 4096 samples. * ``SAMPLES_8192`` 8192 Samples -- Set audio mixing buffer size to 8192 samples. * ``SAMPLES_16384`` 16384 Samples -- Set audio mixing buffer size to 16384 samples. * ``SAMPLES_32768`` 32768 Samples -- Set audio mixing buffer size to 32768 samples.

    :type: typing.Union[str, int]
    '''

    audio_sample_format: typing.Union[str, int] = None
    ''' Audio sample format * ``U8`` 8-bit Unsigned -- Set audio sample format to 8-bit unsigned integer. * ``S16`` 16-bit Signed -- Set audio sample format to 16-bit signed integer. * ``S24`` 24-bit Signed -- Set audio sample format to 24-bit signed integer. * ``S32`` 32-bit Signed -- Set audio sample format to 32-bit signed integer. * ``FLOAT`` 32-bit Float -- Set audio sample format to 32-bit float. * ``DOUBLE`` 64-bit Float -- Set audio sample format to 64-bit float.

    :type: typing.Union[str, int]
    '''

    audio_sample_rate: typing.Union[str, int] = None
    ''' Audio sample rate * ``RATE_44100`` 44.1 kHz -- Set audio sampling rate to 44100 samples per second. * ``RATE_48000`` 48 kHz -- Set audio sampling rate to 48000 samples per second. * ``RATE_96000`` 96 kHz -- Set audio sampling rate to 96000 samples per second. * ``RATE_192000`` 192 kHz -- Set audio sampling rate to 192000 samples per second.

    :type: typing.Union[str, int]
    '''

    dpi: int = None
    ''' 

    :type: int
    '''

    gl_clip_alpha: float = None
    ''' Clip alpha below this threshold in the 3D textured view

    :type: float
    '''

    gl_texture_limit: typing.Union[str, int] = None
    ''' Limit the texture size to save graphics memory

    :type: typing.Union[str, int]
    '''

    gpu_backend: typing.Union[str, int] = None
    ''' GPU backend to use (requires restarting Blender for changes to take effect) * ``OPENGL`` OpenGL -- Use OpenGL backend. * ``METAL`` Metal -- Use Metal backend. * ``VULKAN`` Vulkan -- Use Vulkan backend.

    :type: typing.Union[str, int]
    '''

    image_draw_method: typing.Union[str, int] = None
    ''' Method used for displaying images on the screen * ``AUTO`` Automatic -- Automatically choose method based on GPU and image. * ``2DTEXTURE`` 2D Texture -- Use CPU for display transform and display image with 2D texture. * ``GLSL`` GLSL -- Use GLSL shaders for display transform and display image with 2D texture.

    :type: typing.Union[str, int]
    '''

    is_microsoft_store_install: typing.Union[bool, typing.Any] = None
    ''' Whether this blender installation is a sandboxed Microsoft Store version

    :type: typing.Union[bool, typing.Any]
    '''

    legacy_compute_device_type: int = None
    ''' For backwards compatibility only

    :type: int
    '''

    light_ambient: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Color of the ambient light that uniformly lit the scene

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    memory_cache_limit: int = None
    ''' Memory cache limit (in megabytes)

    :type: int
    '''

    pixel_size: float = None
    ''' 

    :type: float
    '''

    register_all_users: bool = None
    ''' Make this Blender version open blend files for all users. Requires elevated privileges

    :type: bool
    '''

    scrollback: int = None
    ''' Maximum number of lines to store for the console buffer

    :type: int
    '''

    sequencer_disk_cache_compression: typing.Union[str, int] = None
    ''' Smaller compression will result in larger files, but less decoding overhead * ``NONE`` None -- Requires fast storage, but uses minimum CPU resources. * ``LOW`` Low -- Doesn't require fast storage and uses less CPU resources. * ``HIGH`` High -- Works on slower storage devices and uses most CPU resources.

    :type: typing.Union[str, int]
    '''

    sequencer_disk_cache_dir: typing.Union[str, typing.Any] = None
    ''' Override default directory

    :type: typing.Union[str, typing.Any]
    '''

    sequencer_disk_cache_size_limit: int = None
    ''' Disk cache limit (in gigabytes)

    :type: int
    '''

    sequencer_proxy_setup: typing.Union[str, int] = None
    ''' When and how proxies are created * ``MANUAL`` Manual -- Set up proxies manually. * ``AUTOMATIC`` Automatic -- Build proxies for added movie and image strips in each preview size.

    :type: typing.Union[str, int]
    '''

    solid_lights: bpy_prop_collection['UserSolidLight'] = None
    ''' Lights used to display objects in solid shading mode

    :type: bpy_prop_collection['UserSolidLight']
    '''

    texture_collection_rate: int = None
    ''' Number of seconds between each run of the GL texture garbage collector

    :type: int
    '''

    texture_time_out: int = None
    ''' Time since last access of a GL texture in seconds after which it is freed (set to 0 to keep textures allocated)

    :type: int
    '''

    ui_line_width: float = None
    ''' Suggested line thickness and point size in pixels, for add-ons displaying custom user interface elements, based on operating system settings and Blender UI scale

    :type: float
    '''

    ui_scale: float = None
    ''' Size multiplier to use when displaying custom user interface elements, so that they are scaled correctly on screens with different DPI. This value is based on operating system DPI settings and Blender display scale

    :type: float
    '''

    use_edit_mode_smooth_wire: bool = None
    ''' Enable edit mode edge smoothing, reducing aliasing (requires restart)

    :type: bool
    '''

    use_gpu_subdivision: bool = None
    ''' Enable GPU acceleration for evaluating the last subdivision surface modifiers in the stack

    :type: bool
    '''

    use_overlay_smooth_wire: bool = None
    ''' Enable overlay smooth wires, reducing aliasing

    :type: bool
    '''

    use_region_overlap: bool = None
    ''' Display tool/property regions over the main region

    :type: bool
    '''

    use_select_pick_depth: bool = None
    ''' When making a selection in 3D View, use the GPU depth buffer to ensure the frontmost object is selected first

    :type: bool
    '''

    use_sequencer_disk_cache: bool = None
    ''' Store cached images to disk

    :type: bool
    '''

    use_studio_light_edit: bool = None
    ''' View the result of the studio light editor in the viewport

    :type: bool
    '''

    vbo_collection_rate: int = None
    ''' Number of seconds between each run of the GL vertex buffer object garbage collector

    :type: int
    '''

    vbo_time_out: int = None
    ''' Time since last access of a GL vertex buffer object in seconds after which it is freed (set to 0 to keep VBO allocated)

    :type: int
    '''

    viewport_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing in 3d viewport * ``OFF`` No Anti-Aliasing -- Scene will be rendering without any anti-aliasing. * ``FXAA`` Single Pass Anti-Aliasing -- Scene will be rendered using a single pass anti-aliasing method (FXAA). * ``5`` 5 Samples -- Scene will be rendered using 5 anti-aliasing samples. * ``8`` 8 Samples -- Scene will be rendered using 8 anti-aliasing samples. * ``11`` 11 Samples -- Scene will be rendered using 11 anti-aliasing samples. * ``16`` 16 Samples -- Scene will be rendered using 16 anti-aliasing samples. * ``32`` 32 Samples -- Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PreferencesView(bpy_struct):
    ''' Preferences related to viewing data
    '''

    color_picker_type: typing.Union[str, int] = None
    ''' Different styles of displaying the color picker widget * ``CIRCLE_HSV`` Circle (HSV) -- A circular Hue/Saturation color wheel, with Value slider. * ``CIRCLE_HSL`` Circle (HSL) -- A circular Hue/Saturation color wheel, with Lightness slider. * ``SQUARE_SV`` Square (SV + H) -- A square showing Saturation/Value, with Hue slider. * ``SQUARE_HS`` Square (HS + V) -- A square showing Hue/Saturation, with Value slider. * ``SQUARE_HV`` Square (HV + S) -- A square showing Hue/Value, with Saturation slider.

    :type: typing.Union[str, int]
    '''

    factor_display_type: typing.Union[str, int] = None
    ''' How factor values are displayed * ``FACTOR`` Factor -- Display factors as values between 0 and 1. * ``PERCENTAGE`` Percentage -- Display factors as percentages.

    :type: typing.Union[str, int]
    '''

    filebrowser_display_type: typing.Union[str, int] = None
    ''' Default location where the File Editor will be displayed in * ``SCREEN`` Maximized Area -- Open the temporary editor in a maximized screen. * ``WINDOW`` New Window -- Open the temporary editor in a new window.

    :type: typing.Union[str, int]
    '''

    font_path_ui: typing.Union[str, typing.Any] = None
    ''' Path to interface font

    :type: typing.Union[str, typing.Any]
    '''

    font_path_ui_mono: typing.Union[str, typing.Any] = None
    ''' Path to interface monospaced Font

    :type: typing.Union[str, typing.Any]
    '''

    gizmo_size: int = None
    ''' Diameter of the gizmo

    :type: int
    '''

    gizmo_size_navigate_v3d: int = None
    ''' The Navigate Gizmo size

    :type: int
    '''

    header_align: typing.Union[str, int] = None
    ''' Default header position for new space-types * ``NONE`` Keep Existing -- Keep existing header alignment. * ``TOP`` Top -- Top aligned on load. * ``BOTTOM`` Bottom -- Bottom align on load (except for property editors).

    :type: typing.Union[str, int]
    '''

    language: typing.Union[str, int] = None
    ''' Language used for translation * ``DEFAULT`` Automatic (Automatic) -- Automatically choose system's defined language if available, or fall-back to English.

    :type: typing.Union[str, int]
    '''

    lookdev_sphere_size: int = None
    ''' Diameter of the HDRI preview spheres

    :type: int
    '''

    mini_axis_brightness: int = None
    ''' Brightness of the icon

    :type: int
    '''

    mini_axis_size: int = None
    ''' The axes icon's size

    :type: int
    '''

    mini_axis_type: typing.Union[str, int] = None
    ''' Show small rotating 3D axes in the top right corner of the 3D viewport

    :type: typing.Union[str, int]
    '''

    open_sublevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening sub level menus

    :type: int
    '''

    open_toplevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening top level menus

    :type: int
    '''

    pie_animation_timeout: int = None
    ''' Time needed to fully animate the pie to unfolded state (in 1/100ths of sec)

    :type: int
    '''

    pie_initial_timeout: int = None
    ''' Pie menus will use the initial mouse position as center for this amount of time (in 1/100ths of sec)

    :type: int
    '''

    pie_menu_confirm: int = None
    ''' Distance threshold after which selection is made (zero to disable)

    :type: int
    '''

    pie_menu_radius: int = None
    ''' Pie menu size in pixels

    :type: int
    '''

    pie_menu_threshold: int = None
    ''' Distance from center needed before a selection can be made

    :type: int
    '''

    pie_tap_timeout: int = None
    ''' Pie menu button held longer than this will dismiss menu on release (in 1/100ths of sec)

    :type: int
    '''

    playback_fps_samples: int = None
    ''' The number of frames to use for calculating FPS average. Zero to calculate this automatically, where the number of samples matches the target FPS

    :type: int
    '''

    render_display_type: typing.Union[str, int] = None
    ''' Default location where rendered images will be displayed in * ``NONE`` Keep User Interface -- Images are rendered without changing the user interface. * ``SCREEN`` Maximized Area -- Images are rendered in a maximized Image Editor. * ``AREA`` Image Editor -- Images are rendered in an Image Editor. * ``WINDOW`` New Window -- Images are rendered in a new window.

    :type: typing.Union[str, int]
    '''

    rotation_angle: float = None
    ''' Rotation step for numerical pad keys (2 4 6 8)

    :type: float
    '''

    show_addons_enabled_only: bool = None
    ''' Only show enabled add-ons. Un-check to see all installed add-ons

    :type: bool
    '''

    show_column_layout: bool = None
    ''' Use a column layout for toolbox

    :type: bool
    '''

    show_developer_ui: bool = None
    ''' Show options for developers (edit source in context menu, geometry indices)

    :type: bool
    '''

    show_gizmo: bool = None
    ''' Use transform gizmos by default

    :type: bool
    '''

    show_navigate_ui: bool = None
    ''' Show navigation controls in 2D and 3D views which do not have scroll bars

    :type: bool
    '''

    show_object_info: bool = None
    ''' Include the name of the active object and the current frame number in the text info overlay

    :type: bool
    '''

    show_playback_fps: bool = None
    ''' Include the number of frames displayed per second in the text info overlay while animation is played back

    :type: bool
    '''

    show_splash: bool = None
    ''' Display splash screen on startup

    :type: bool
    '''

    show_statusbar_memory: bool = None
    ''' Show Blender memory usage

    :type: bool
    '''

    show_statusbar_scene_duration: bool = None
    ''' Show scene duration

    :type: bool
    '''

    show_statusbar_stats: bool = None
    ''' Show scene statistics

    :type: bool
    '''

    show_statusbar_version: bool = None
    ''' Show Blender version string

    :type: bool
    '''

    show_statusbar_vram: bool = None
    ''' Show GPU video memory usage

    :type: bool
    '''

    show_tooltips: bool = None
    ''' Display tooltips (when disabled, hold Alt to force display)

    :type: bool
    '''

    show_tooltips_python: bool = None
    ''' Show Python references in tooltips

    :type: bool
    '''

    show_view_name: bool = None
    ''' Include the name of the view orientation in the text info overlay

    :type: bool
    '''

    smooth_view: int = None
    ''' Time to animate the view in milliseconds, zero to disable

    :type: int
    '''

    text_hinting: typing.Union[str, int] = None
    ''' Method for making user interface text render sharp

    :type: typing.Union[str, int]
    '''

    timecode_style: typing.Union[str, int] = None
    ''' Format of timecode displayed when not displaying timing in terms of frames * ``MINIMAL`` Minimal Info -- Most compact representation, uses '+' as separator for sub-second frame numbers, with left and right truncation of the timecode as necessary. * ``SMPTE`` SMPTE (Full) -- Full SMPTE timecode (format is HH:MM:SS:FF). * ``SMPTE_COMPACT`` SMPTE (Compact) -- SMPTE timecode showing minutes, seconds, and frames only - hours are also shown if necessary, but not by default. * ``MILLISECONDS`` Compact with Milliseconds -- Similar to SMPTE (Compact), except that instead of frames, milliseconds are shown instead. * ``SECONDS_ONLY`` Only Seconds -- Direct conversion of frame numbers to seconds.

    :type: typing.Union[str, int]
    '''

    ui_line_width: typing.Union[str, int] = None
    ''' Changes the thickness of widget outlines, lines and dots in the interface * ``THIN`` Thin -- Thinner lines than the default. * ``AUTO`` Default -- Automatic line width based on UI scale. * ``THICK`` Thick -- Thicker lines than the default.

    :type: typing.Union[str, int]
    '''

    ui_scale: float = None
    ''' Changes the size of the fonts and widgets in the interface

    :type: float
    '''

    use_fresnel_edit: bool = None
    ''' Enable a fresnel effect on edit mesh overlays. It improves shape readability of very dense meshes, but increases eye fatigue when modeling lower poly

    :type: bool
    '''

    use_mouse_over_open: bool = None
    ''' Open menu buttons and pulldowns automatically when the mouse is hovering

    :type: bool
    '''

    use_save_prompt: bool = None
    ''' Ask for confirmation when quitting with unsaved changes

    :type: bool
    '''

    use_text_antialiasing: bool = None
    ''' Smooth jagged edges of user interface text

    :type: bool
    '''

    use_text_render_subpixelaa: bool = None
    ''' Render text for optimal horizontal placement

    :type: bool
    '''

    use_translate_interface: bool = None
    ''' Translate all labels in menus, buttons and panels (note that this might make it hard to follow tutorials or the manual)

    :type: bool
    '''

    use_translate_new_dataname: bool = None
    ''' Translate the names of new data-blocks (objects, materials...)

    :type: bool
    '''

    use_translate_tooltips: bool = None
    ''' Translate the descriptions when hovering UI elements (recommended)

    :type: bool
    '''

    use_weight_color_range: bool = None
    ''' Enable color range used for weight visualization in weight painting mode

    :type: bool
    '''

    view2d_grid_spacing_min: int = None
    ''' Minimum number of pixels between each gridline in 2D Viewports

    :type: int
    '''

    view_frame_keyframes: int = None
    ''' Keyframes around cursor that we zoom around

    :type: int
    '''

    view_frame_seconds: float = None
    ''' Seconds around cursor that we zoom around

    :type: float
    '''

    view_frame_type: typing.Union[str, int] = None
    ''' How zooming to frame focuses around current frame

    :type: typing.Union[str, int]
    '''

    weight_color_range: 'ColorRamp' = None
    ''' Color range used for weight visualization in weight painting mode

    :type: 'ColorRamp'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PrimitiveBoolean(bpy_struct):
    ''' RNA wrapped boolean
    '''

    value: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PrimitiveFloat(bpy_struct):
    ''' RNA wrapped float
    '''

    value: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PrimitiveInt(bpy_struct):
    ''' RNA wrapped int
    '''

    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PrimitiveString(bpy_struct):
    ''' RNA wrapped string
    '''

    value: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Property(bpy_struct):
    ''' RNA property definition
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the property for tooltips

    :type: typing.Union[str, typing.Any]
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    is_animatable: typing.Union[bool, typing.Any] = None
    ''' Property is animatable through RNA

    :type: typing.Union[bool, typing.Any]
    '''

    is_argument_optional: typing.Union[bool, typing.Any] = None
    ''' True when the property is optional in a Python function implementing an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_enum_flag: typing.Union[bool, typing.Any] = None
    ''' True when multiple enums

    :type: typing.Union[bool, typing.Any]
    '''

    is_hidden: typing.Union[bool, typing.Any] = None
    ''' True when the property is hidden

    :type: typing.Union[bool, typing.Any]
    '''

    is_library_editable: typing.Union[bool, typing.Any] = None
    ''' Property is editable from linked instances (changes not saved)

    :type: typing.Union[bool, typing.Any]
    '''

    is_never_none: typing.Union[bool, typing.Any] = None
    ''' True when this value can't be set to None

    :type: typing.Union[bool, typing.Any]
    '''

    is_output: typing.Union[bool, typing.Any] = None
    ''' True when this property is an output value from an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_overridable: typing.Union[bool, typing.Any] = None
    ''' Property is overridable through RNA

    :type: typing.Union[bool, typing.Any]
    '''

    is_path_output: typing.Union[bool, typing.Any] = None
    ''' Property is a filename, filepath or directory output

    :type: typing.Union[bool, typing.Any]
    '''

    is_readonly: typing.Union[bool, typing.Any] = None
    ''' Property is editable through RNA

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered: typing.Union[bool, typing.Any] = None
    ''' Property is registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered_optional: typing.Union[bool, typing.Any] = None
    ''' Property is optionally registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_required: typing.Union[bool, typing.Any] = None
    ''' False when this property is an optional argument in an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_runtime: typing.Union[bool, typing.Any] = None
    ''' Property has been dynamically created at runtime

    :type: typing.Union[bool, typing.Any]
    '''

    is_skip_save: typing.Union[bool, typing.Any] = None
    ''' True when the property is not saved in presets

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    srna: 'Struct' = None
    ''' Struct definition used for properties assigned to this item

    :type: 'Struct'
    '''

    subtype: typing.Union[str, int] = None
    ''' Semantic interpretation of the property

    :type: typing.Union[str, int]
    '''

    tags: typing.Union[typing.Set[str], typing.Set[int], typing.Any] = None
    ''' Subset of tags (defined in parent struct) that are set for this property

    :type: typing.Union[typing.Set[str], typing.Set[int], typing.Any]
    '''

    translation_context: typing.Union[str, typing.Any] = None
    ''' Translation context of the property's name

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the property

    :type: typing.Union[str, int]
    '''

    unit: typing.Union[str, int] = None
    ''' Type of units for this property

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PropertyGroup(bpy_struct):
    ''' Group of ID properties
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class PropertyGroupItem(bpy_struct):
    ''' Property that stores arbitrary, user defined properties
    '''

    bool: bool = None
    ''' 

    :type: bool
    '''

    bool_array: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    collection: bpy_prop_collection['PropertyGroup'] = None
    ''' 

    :type: bpy_prop_collection['PropertyGroup']
    '''

    double: float = None
    ''' 

    :type: float
    '''

    double_array: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    float: float = None
    ''' 

    :type: float
    '''

    float_array: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    group: 'PropertyGroup' = None
    ''' 

    :type: 'PropertyGroup'
    '''

    id: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    idp_array: bpy_prop_collection['PropertyGroup'] = None
    ''' 

    :type: bpy_prop_collection['PropertyGroup']
    '''

    int: int = None
    ''' 

    :type: int
    '''

    int_array: bpy_prop_array[int] = None
    ''' 

    :type: bpy_prop_array[int]
    '''

    string: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class QuaternionAttributeValue(bpy_struct):
    ''' Rotation value in geometry attribute
    '''

    value: bpy_prop_array[float] = None
    ''' Quaternion

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RaytraceEEVEE(bpy_struct):
    denoise_bilateral: bool = None
    ''' Blur the resolved radiance using a bilateral filter

    :type: bool
    '''

    denoise_spatial: bool = None
    ''' Reuse neighbor pixels' rays

    :type: bool
    '''

    denoise_temporal: bool = None
    ''' Accumulate samples by reprojecting last tracing results

    :type: bool
    '''

    resolution_scale: typing.Union[str, int] = None
    ''' Number of rays per pixel * ``1`` 1 rpp -- 1 ray per pixel. * ``2`` 1/4 rpp -- 1 ray for every 4 pixels. * ``4`` 1/16 rpp -- 1 ray for every 16 pixels.

    :type: typing.Union[str, int]
    '''

    sample_clamp: float = None
    ''' Clamp ray intensity to reduce noise (0 to disable)

    :type: float
    '''

    screen_trace_quality: float = None
    ''' Precision of the screen space ray-tracing

    :type: float
    '''

    screen_trace_thickness: float = None
    ''' Surface thickness used to detect intersection when using screen-tracing

    :type: float
    '''

    use_denoise: bool = None
    ''' Enable noise reduction techniques for raytraced effects

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ReadOnlyInteger(bpy_struct):
    value: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Region(bpy_struct):
    ''' Region in a subdivided screen area
    '''

    alignment: typing.Union[str, int] = None
    ''' Alignment of the region within the area * ``NONE`` None -- Don't use any fixed alignment, fill available space. * ``TOP`` Top. * ``BOTTOM`` Bottom. * ``LEFT`` Left. * ``RIGHT`` Right. * ``HORIZONTAL_SPLIT`` Horizontal Split. * ``VERTICAL_SPLIT`` Vertical Split. * ``FLOAT`` Float -- Region floats on screen, doesn't use any fixed alignment. * ``QUAD_SPLIT`` Quad Split -- Region is split horizontally and vertically.

    :type: typing.Union[str, int]
    '''

    data: typing.Any = None
    ''' Region specific data (the type depends on the region type)

    :type: typing.Any
    '''

    height: int = None
    ''' Region height

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of this region

    :type: typing.Union[str, int]
    '''

    view2d: 'View2D' = None
    ''' 2D view of the region

    :type: 'View2D'
    '''

    width: int = None
    ''' Region width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the region

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the region

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RegionView3D(bpy_struct):
    ''' 3D View region data
    '''

    clip_planes: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float, float, float], typing.
              Tuple[float, float, float, float, float, float], typing.
              Tuple[float, float, float, float, float, float], typing.
              Tuple[float, float, float, float, float, float]]] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float]]]
    '''

    is_orthographic_side_view: bool = None
    ''' Whether the current view is aligned to an axis (does not check whether the view is orthographic, use "is_perspective" for that). Setting this will rotate the view to the closest axis

    :type: bool
    '''

    is_perspective: bool = None
    ''' 

    :type: bool
    '''

    lock_rotation: bool = None
    ''' Lock view rotation of side views to Top/Front/Right

    :type: bool
    '''

    perspective_matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Current perspective matrix (``window_matrix * view_matrix``)

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    show_sync_view: bool = None
    ''' Sync view position between side views

    :type: bool
    '''

    use_box_clip: bool = None
    ''' Clip view contents based on what is visible in other side views

    :type: bool
    '''

    use_clip_planes: bool = None
    ''' 

    :type: bool
    '''

    view_camera_offset: bpy_prop_array[float] = None
    ''' View shift in camera view

    :type: bpy_prop_array[float]
    '''

    view_camera_zoom: float = None
    ''' Zoom factor in camera view

    :type: float
    '''

    view_distance: float = None
    ''' Distance to the view location

    :type: float
    '''

    view_location: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Vector'] = None
    ''' View pivot location

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    view_matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Current view matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    view_perspective: typing.Union[str, int] = None
    ''' View Perspective

    :type: typing.Union[str, int]
    '''

    view_rotation: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float, float],
                                'mathutils.Quaternion'] = None
    ''' Rotation in quaternions (keep normalized)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Quaternion']
    '''

    window_matrix: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]], 'mathutils.Matrix'] = None
    ''' Current window matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
    '''

    def update(self):
        ''' Recalculate the view matrices

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderEngine(bpy_struct):
    ''' Render engine
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_use_alembic_procedural: bool = None
    ''' Support loading Alembic data at render time

    :type: bool
    '''

    bl_use_custom_freestyle: bool = None
    ''' Handles freestyle rendering on its own, instead of delegating it to EEVEE

    :type: bool
    '''

    bl_use_eevee_viewport: bool = None
    ''' Uses EEVEE for viewport shading in Material Preview shading mode

    :type: bool
    '''

    bl_use_gpu_context: bool = None
    ''' Enable OpenGL context for the render method, for engines that render using OpenGL

    :type: bool
    '''

    bl_use_image_save: bool = None
    ''' Save images/movie to disk while rendering an animation. Disabling image saving is only supported when bl_use_postprocess is also disabled

    :type: bool
    '''

    bl_use_materialx: bool = None
    ''' Use MaterialX for exporting materials to Hydra

    :type: bool
    '''

    bl_use_postprocess: bool = None
    ''' Apply compositing on render results

    :type: bool
    '''

    bl_use_preview: bool = None
    ''' Render engine supports being used for rendering previews of materials, lights and worlds

    :type: bool
    '''

    bl_use_shading_nodes_custom: bool = None
    ''' Don't expose Cycles and EEVEE shading nodes in the node editor user interface, so own nodes can be used instead

    :type: bool
    '''

    bl_use_spherical_stereo: bool = None
    ''' Support spherical stereo camera models

    :type: bool
    '''

    bl_use_stereo_viewport: bool = None
    ''' Support rendering stereo 3D viewport

    :type: bool
    '''

    camera_override: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    is_animation: bool = None
    ''' 

    :type: bool
    '''

    is_preview: bool = None
    ''' 

    :type: bool
    '''

    layer_override: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    render: 'RenderSettings' = None
    ''' :noindex:

    :type: 'RenderSettings'
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    temporary_directory: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    use_highlight_tiles: bool = None
    ''' 

    :type: bool
    '''

    def update(self,
               data: typing.Optional['BlendData'] = None,
               depsgraph: typing.Optional['Depsgraph'] = None):
        ''' Export scene data for render

        :param data: 
        :type data: typing.Optional['BlendData']
        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        '''
        pass

    def render(self, depsgraph: typing.Optional['Depsgraph']):
        ''' Render scene into an image

        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        '''
        pass

    def render_frame_finish(self):
        ''' Perform finishing operations after all view layers in a frame were rendered

        '''
        pass

    def draw(self, context: typing.Optional['Context'],
             depsgraph: typing.Optional['Depsgraph']):
        ''' Draw render image

        :param context: 
        :type context: typing.Optional['Context']
        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        '''
        pass

    def bake(self, depsgraph: typing.Optional['Depsgraph'],
             object: typing.Optional['Object'],
             pass_type: typing.Optional[typing.Union[str, int]],
             pass_filter: typing.Optional[int], width: typing.Optional[int],
             height: typing.Optional[int]):
        ''' Bake passes

        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        :param object: 
        :type object: typing.Optional['Object']
        :param pass_type: Pass, Pass to bake
        :type pass_type: typing.Optional[typing.Union[str, int]]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy and transmission passes
        :type pass_filter: typing.Optional[int]
        :param width: Width, Image width
        :type width: typing.Optional[int]
        :param height: Height, Image height
        :type height: typing.Optional[int]
        '''
        pass

    def view_update(self, context: typing.Optional['Context'],
                    depsgraph: typing.Optional['Depsgraph']):
        ''' Update on data changes for viewport render

        :param context: 
        :type context: typing.Optional['Context']
        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        '''
        pass

    def view_draw(self, context: typing.Optional['Context'],
                  depsgraph: typing.Optional['Depsgraph']):
        ''' Draw viewport render

        :param context: 
        :type context: typing.Optional['Context']
        :param depsgraph: 
        :type depsgraph: typing.Optional['Depsgraph']
        '''
        pass

    def update_script_node(self, node: typing.Optional['Node'] = None):
        ''' Compile shader script node

        :param node: 
        :type node: typing.Optional['Node']
        '''
        pass

    def update_render_passes(self,
                             scene: typing.Optional['Scene'] = None,
                             renderlayer: typing.Optional['ViewLayer'] = None):
        ''' Update the render passes that will be generated

        :param scene: 
        :type scene: typing.Optional['Scene']
        :param renderlayer: 
        :type renderlayer: typing.Optional['ViewLayer']
        '''
        pass

    def tag_redraw(self):
        ''' Request redraw for viewport rendering

        '''
        pass

    def tag_update(self):
        ''' Request update call for viewport rendering

        '''
        pass

    def begin_result(
            self,
            x: typing.Optional[int],
            y: typing.Optional[int],
            w: typing.Optional[int],
            h: typing.Optional[int],
            layer: typing.Union[str, typing.Any] = "",
            view: typing.Union[str, typing.Any] = "") -> 'RenderResult':
        ''' Create render result to write linear floating-point render layers and passes

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param w: Width
        :type w: typing.Optional[int]
        :param h: Height
        :type h: typing.Optional[int]
        :param layer: Layer, Single layer to get render result for
        :type layer: typing.Union[str, typing.Any]
        :param view: View, Single view to get render result for
        :type view: typing.Union[str, typing.Any]
        :rtype: 'RenderResult'
        :return: Result
        '''
        pass

    def update_result(self, result: typing.Optional['RenderResult']):
        ''' Signal that pixels have been updated and can be redrawn in the user interface

        :param result: Result
        :type result: typing.Optional['RenderResult']
        '''
        pass

    def end_result(
            self,
            result: typing.Optional['RenderResult'],
            cancel: typing.Optional[typing.Union[bool, typing.Any]] = False,
            highlight: typing.Optional[typing.Union[bool, typing.Any]] = False,
            do_merge_results: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' All pixels in the render result have been set and are final

        :param result: Result
        :type result: typing.Optional['RenderResult']
        :param cancel: Cancel, Don't mark tile as done, don't merge results unless forced
        :type cancel: typing.Optional[typing.Union[bool, typing.Any]]
        :param highlight: Highlight, Don't mark tile as done yet
        :type highlight: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_merge_results: Merge Results, Merge results even if cancel=true
        :type do_merge_results: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def add_pass(self,
                 name: typing.Union[str, typing.Any],
                 channels: typing.Optional[int],
                 chan_id: typing.Union[str, typing.Any],
                 layer: typing.Union[str, typing.Any] = ""):
        ''' Add a pass to the render layer

        :param name: Name, Name of the Pass, without view or channel tag
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chan_id: Channel IDs, Channel names, one character per channel
        :type chan_id: typing.Union[str, typing.Any]
        :param layer: Layer, Single layer to add render pass to
        :type layer: typing.Union[str, typing.Any]
        '''
        pass

    def get_result(self) -> 'RenderResult':
        ''' Get final result for non-pixel operations

        :rtype: 'RenderResult'
        :return: Result
        '''
        pass

    def test_break(self) -> bool:
        ''' Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness

        :rtype: bool
        :return: Break
        '''
        pass

    def pass_by_index_get(self, layer: typing.Union[str, typing.Any],
                          index: typing.Optional[int]) -> 'RenderPass':
        ''' pass_by_index_get

        :param layer: Layer, Name of render layer to get pass for
        :type layer: typing.Union[str, typing.Any]
        :param index: Index, Index of pass to get
        :type index: typing.Optional[int]
        :rtype: 'RenderPass'
        :return: Index, Index of pass to get
        '''
        pass

    def active_view_get(self) -> typing.Union[str, typing.Any]:
        ''' active_view_get

        :rtype: typing.Union[str, typing.Any]
        :return: View, Single view active
        '''
        pass

    def active_view_set(self, view: typing.Union[str, typing.Any]):
        ''' active_view_set

        :param view: View, Single view to set as active
        :type view: typing.Union[str, typing.Any]
        '''
        pass

    def camera_shift_x(self,
                       camera: typing.Optional['Object'],
                       use_spherical_stereo: typing.Optional[
                           typing.Union[bool, typing.Any]] = False) -> float:
        ''' camera_shift_x

        :param camera: 
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Shift X
        '''
        pass

    def camera_model_matrix(
            self,
            camera: typing.Optional['Object'],
            use_spherical_stereo: typing.
            Optional[typing.Union[bool, typing.Any]] = False) -> typing.Union[
                typing.List[typing.List[float]], typing.
                Tuple[typing.Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float], typing.
                      Tuple[float, float, float, float]], 'mathutils.Matrix']:
        ''' camera_model_matrix

        :param camera: 
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], 'mathutils.Matrix']
        :return: Model Matrix, Normalized camera model matrix
        '''
        pass

    def use_spherical_stereo(self, camera: typing.Optional['Object']) -> bool:
        ''' use_spherical_stereo

        :param camera: 
        :type camera: typing.Optional['Object']
        :rtype: bool
        :return: Spherical Stereo
        '''
        pass

    def update_stats(self, stats: typing.Union[str, typing.Any],
                     info: typing.Union[str, typing.Any]):
        ''' Update and signal to redraw render status text

        :param stats: Stats
        :type stats: typing.Union[str, typing.Any]
        :param info: Info
        :type info: typing.Union[str, typing.Any]
        '''
        pass

    def frame_set(self, frame: typing.Optional[int],
                  subframe: typing.Optional[float]):
        ''' Evaluate scene at a different frame (for motion blur)

        :param frame: Frame
        :type frame: typing.Optional[int]
        :param subframe: Subframe
        :type subframe: typing.Optional[float]
        '''
        pass

    def update_progress(self, progress: typing.Optional[float]):
        ''' Update progress percentage of render

        :param progress: Percentage of render that's done
        :type progress: typing.Optional[float]
        '''
        pass

    def update_memory_stats(self,
                            memory_used: typing.Optional[typing.Any] = 0.0,
                            memory_peak: typing.Optional[typing.Any] = 0.0):
        ''' Update memory usage statistics

        :param memory_used: Current memory usage in megabytes
        :type memory_used: typing.Optional[typing.Any]
        :param memory_peak: Peak memory usage in megabytes
        :type memory_peak: typing.Optional[typing.Any]
        '''
        pass

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' Report info, warning or error messages

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    def error_set(self, message: typing.Union[str, typing.Any]):
        ''' Set error message displaying after the render is finished

        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    def bind_display_space_shader(self, scene: typing.Optional['Scene']):
        ''' Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings

        :param scene: 
        :type scene: typing.Optional['Scene']
        '''
        pass

    def unbind_display_space_shader(self):
        ''' Unbind GLSL display space shader, must always be called after binding the shader

        '''
        pass

    def support_display_space_shader(self,
                                     scene: typing.Optional['Scene']) -> bool:
        ''' Test if GLSL display space shader is supported for the combination of graphics card and scene settings

        :param scene: 
        :type scene: typing.Optional['Scene']
        :rtype: bool
        :return: Supported
        '''
        pass

    def get_preview_pixel_size(self, scene: typing.Optional['Scene']) -> int:
        ''' Get the pixel size that should be used for preview rendering

        :param scene: 
        :type scene: typing.Optional['Scene']
        :rtype: int
        :return: Pixel Size
        '''
        pass

    def free_blender_memory(self):
        ''' Free Blender side memory of render engine

        '''
        pass

    def tile_highlight_set(
            self, x: typing.Optional[int], y: typing.Optional[int],
            width: typing.Optional[int], height: typing.Optional[int],
            highlight: typing.Optional[bool]):
        ''' Set highlighted state of the given tile

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param width: Width
        :type width: typing.Optional[int]
        :param height: Height
        :type height: typing.Optional[int]
        :param highlight: Highlight
        :type highlight: typing.Optional[bool]
        '''
        pass

    def tile_highlight_clear_all(self):
        ''' The temp directory used by Blender

        '''
        pass

    def register_pass(self, scene: typing.Optional['Scene'],
                      view_layer: typing.Optional['ViewLayer'],
                      name: typing.Union[str, typing.Any],
                      channels: typing.Optional[int],
                      chanid: typing.Union[str, typing.Any],
                      type: typing.Optional[typing.Union[str, int]]):
        ''' Register a render pass that will be part of the render with the current settings

        :param scene: 
        :type scene: typing.Optional['Scene']
        :param view_layer: 
        :type view_layer: typing.Optional['ViewLayer']
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chanid: Channel IDs
        :type chanid: typing.Union[str, typing.Any]
        :param type: Type
        :type type: typing.Optional[typing.Union[str, int]]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderLayer(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' View layer name

    :type: typing.Union[str, typing.Any]
    '''

    passes: 'RenderPasses' = None
    ''' 

    :type: 'RenderPasses'
    '''

    use_ao: typing.Union[bool, typing.Any] = None
    ''' Render Ambient Occlusion in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_motion_blur: typing.Union[bool, typing.Any] = None
    ''' Render motion blur in this Layer, if enabled in the scene

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_ambient_occlusion: typing.Union[bool, typing.Any] = None
    ''' Deliver Ambient Occlusion pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_combined: typing.Union[bool, typing.Any] = None
    ''' Deliver full combined RGBA buffer

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_color: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_emit: typing.Union[bool, typing.Any] = None
    ''' Deliver emission pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_environment: typing.Union[bool, typing.Any] = None
    ''' Deliver environment lighting pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_color: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_material_index: typing.Union[bool, typing.Any] = None
    ''' Deliver material index pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_mist: typing.Union[bool, typing.Any] = None
    ''' Deliver mist factor pass (0.0 to 1.0)

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_normal: typing.Union[bool, typing.Any] = None
    ''' Deliver normal pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_object_index: typing.Union[bool, typing.Any] = None
    ''' Deliver object index pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_position: typing.Union[bool, typing.Any] = None
    ''' Deliver position pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_shadow: typing.Union[bool, typing.Any] = None
    ''' Deliver shadow pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_color: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_color: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_uv: typing.Union[bool, typing.Any] = None
    ''' Deliver texture UV pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_vector: typing.Union[bool, typing.Any] = None
    ''' Deliver speed vector pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_z: typing.Union[bool, typing.Any] = None
    ''' Deliver Z values pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_sky: typing.Union[bool, typing.Any] = None
    ''' Render Sky in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_solid: typing.Union[bool, typing.Any] = None
    ''' Render Solid faces in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_strand: typing.Union[bool, typing.Any] = None
    ''' Render Strands in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_volumes: typing.Union[bool, typing.Any] = None
    ''' Render volumes in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    def load_from_file(self,
                       filepath: typing.Union[str, typing.Any],
                       x: typing.Optional[typing.Any] = 0,
                       y: typing.Optional[typing.Any] = 0):
        ''' Copies the pixels of this renderlayer from an image file

        :param filepath: File Path, File path to load into this render tile, must be no smaller than the renderlayer
        :type filepath: typing.Union[str, typing.Any]
        :param x: Offset X, Offset the position to copy from if the image is larger than the render layer
        :type x: typing.Optional[typing.Any]
        :param y: Offset Y, Offset the position to copy from if the image is larger than the render layer
        :type y: typing.Optional[typing.Any]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderPass(bpy_struct):
    channel_id: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    channels: int = None
    ''' 

    :type: int
    '''

    fullname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    rect: float = None
    ''' 

    :type: float
    '''

    view_id: int = None
    ''' 

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderResult(bpy_struct):
    ''' Result of rendering, including all layers and passes
    '''

    layers: bpy_prop_collection['RenderLayer'] = None
    ''' 

    :type: bpy_prop_collection['RenderLayer']
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    views: bpy_prop_collection['RenderView'] = None
    ''' 

    :type: bpy_prop_collection['RenderView']
    '''

    def load_from_file(self, filepath: typing.Union[str, typing.Any]):
        ''' Copies the pixels of this render result from an image file

        :param filepath: File Name, Filename to load into this render tile, must be no smaller than the render result
        :type filepath: typing.Union[str, typing.Any]
        '''
        pass

    def stamp_data_add_field(self, field: typing.Union[str, typing.Any],
                             value: typing.Union[str, typing.Any]):
        ''' Add engine-specific stamp data to the result

        :param field: Field, Name of the stamp field to add
        :type field: typing.Union[str, typing.Any]
        :param value: Value, Value of the stamp data
        :type value: typing.Union[str, typing.Any]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderSettings(bpy_struct):
    ''' Rendering settings for a Scene data-block
    '''

    bake: 'BakeSettings' = None
    ''' 

    :type: 'BakeSettings'
    '''

    bake_bias: float = None
    ''' Bias towards faces further away from the object (in Blender units)

    :type: float
    '''

    bake_margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    bake_margin_type: typing.Union[str, int] = None
    ''' Algorithm to generate the margin * ``ADJACENT_FACES`` Adjacent Faces -- Use pixels from adjacent faces across UV seams. * ``EXTEND`` Extend -- Extend border pixels outwards.

    :type: typing.Union[str, int]
    '''

    bake_samples: int = None
    ''' Number of samples used for ambient occlusion baking from multires

    :type: int
    '''

    bake_type: typing.Union[str, int] = None
    ''' Choose shading information to bake into the image * ``NORMALS`` Normals -- Bake normals. * ``DISPLACEMENT`` Displacement -- Bake displacement.

    :type: typing.Union[str, int]
    '''

    bake_user_scale: float = None
    ''' Instead of automatically normalizing to the range 0 to 1, apply a user scale to the derivative map

    :type: float
    '''

    border_max_x: float = None
    ''' Maximum X value for the render region

    :type: float
    '''

    border_max_y: float = None
    ''' Maximum Y value for the render region

    :type: float
    '''

    border_min_x: float = None
    ''' Minimum X value for the render region

    :type: float
    '''

    border_min_y: float = None
    ''' Minimum Y value for the render region

    :type: float
    '''

    dither_intensity: float = None
    ''' Amount of dithering noise added to the rendered image to break up banding

    :type: float
    '''

    engine: typing.Union[str, int] = None
    ''' Engine to use for rendering

    :type: typing.Union[str, int]
    '''

    ffmpeg: 'FFmpegSettings' = None
    ''' FFmpeg related settings for the scene

    :type: 'FFmpegSettings'
    '''

    file_extension: typing.Union[str, typing.Any] = None
    ''' The file extension used for saving renders

    :type: typing.Union[str, typing.Any]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Directory/name to save animations, # characters define the position and padding of frame numbers

    :type: typing.Union[str, typing.Any]
    '''

    film_transparent: bool = None
    ''' World background is transparent, for compositing the render over another background

    :type: bool
    '''

    filter_size: float = None
    ''' Width over which the reconstruction filter combines samples

    :type: float
    '''

    fps: int = None
    ''' Framerate, expressed in frames per second

    :type: int
    '''

    fps_base: float = None
    ''' Framerate base

    :type: float
    '''

    frame_map_new: int = None
    ''' How many frames the Map Old will last

    :type: int
    '''

    frame_map_old: int = None
    ''' Old mapping value in frames

    :type: int
    '''

    hair_subdiv: int = None
    ''' Additional subdivision along the curves

    :type: int
    '''

    hair_type: typing.Union[str, int] = None
    ''' Curves shape type

    :type: typing.Union[str, int]
    '''

    has_multiple_engines: typing.Union[bool, typing.Any] = None
    ''' More than one rendering engine is available

    :type: typing.Union[bool, typing.Any]
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    is_movie_format: typing.Union[bool, typing.Any] = None
    ''' When true the format is a movie

    :type: typing.Union[bool, typing.Any]
    '''

    line_thickness: float = None
    ''' Line thickness in pixels

    :type: float
    '''

    line_thickness_mode: typing.Union[str, int] = None
    ''' Line thickness mode for Freestyle line drawing * ``ABSOLUTE`` Absolute -- Specify unit line thickness in pixels. * ``RELATIVE`` Relative -- Unit line thickness is scaled by the proportion of the present vertical image resolution to 480 pixels.

    :type: typing.Union[str, int]
    '''

    metadata_input: typing.Union[str, int] = None
    ''' Where to take the metadata from * ``SCENE`` Scene -- Use metadata from the current scene. * ``STRIPS`` Sequencer Strips -- Use metadata from the strips in the sequencer.

    :type: typing.Union[str, int]
    '''

    motion_blur_shutter: float = None
    ''' Time taken in frames between shutter open and close

    :type: float
    '''

    motion_blur_shutter_curve: 'CurveMapping' = None
    ''' Curve defining the shutter's openness over time

    :type: 'CurveMapping'
    '''

    pixel_aspect_x: float = None
    ''' Horizontal aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    pixel_aspect_y: float = None
    ''' Vertical aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    preview_pixel_size: typing.Union[str, int] = None
    ''' Pixel size for viewport rendering * ``AUTO`` Automatic -- Automatic pixel size, depends on the user interface scale. * ``1`` 1× -- Render at full resolution. * ``2`` 2× -- Render at 50% resolution. * ``4`` 4× -- Render at 25% resolution. * ``8`` 8× -- Render at 12.5% resolution.

    :type: typing.Union[str, int]
    '''

    resolution_percentage: int = None
    ''' Percentage scale for render resolution

    :type: int
    '''

    resolution_x: int = None
    ''' Number of horizontal pixels in the rendered image

    :type: int
    '''

    resolution_y: int = None
    ''' Number of vertical pixels in the rendered image

    :type: int
    '''

    sequencer_gl_preview: typing.Union[str, int] = None
    ''' Display method used in the sequencer view

    :type: typing.Union[str, int]
    '''

    simplify_child_particles: float = None
    ''' Global child particles percentage

    :type: float
    '''

    simplify_child_particles_render: float = None
    ''' Global child particles percentage during rendering

    :type: float
    '''

    simplify_gpencil: bool = None
    ''' Simplify Grease Pencil drawing

    :type: bool
    '''

    simplify_gpencil_antialiasing: bool = None
    ''' Use Antialiasing to smooth stroke edges

    :type: bool
    '''

    simplify_gpencil_modifier: bool = None
    ''' Display modifiers

    :type: bool
    '''

    simplify_gpencil_onplay: bool = None
    ''' Simplify Grease Pencil only during animation playback

    :type: bool
    '''

    simplify_gpencil_shader_fx: bool = None
    ''' Display Shader Effects

    :type: bool
    '''

    simplify_gpencil_tint: bool = None
    ''' Display layer tint

    :type: bool
    '''

    simplify_gpencil_view_fill: bool = None
    ''' Display fill strokes in the viewport

    :type: bool
    '''

    simplify_shadows: float = None
    ''' Resolution percentage of shadows in viewport

    :type: float
    '''

    simplify_shadows_render: float = None
    ''' Resolution percentage of shadows in viewport

    :type: float
    '''

    simplify_subdivision: int = None
    ''' Global maximum subdivision level

    :type: int
    '''

    simplify_subdivision_render: int = None
    ''' Global maximum subdivision level during rendering

    :type: int
    '''

    simplify_volumes: float = None
    ''' Resolution percentage of volume objects in viewport

    :type: float
    '''

    stamp_background: bpy_prop_array[float] = None
    ''' Color to use behind stamp text

    :type: bpy_prop_array[float]
    '''

    stamp_font_size: int = None
    ''' Size of the font used when rendering stamp text

    :type: int
    '''

    stamp_foreground: bpy_prop_array[float] = None
    ''' Color to use for stamp text

    :type: bpy_prop_array[float]
    '''

    stamp_note_text: typing.Union[str, typing.Any] = None
    ''' Custom text to appear in the stamp note

    :type: typing.Union[str, typing.Any]
    '''

    stereo_views: bpy_prop_collection['SceneRenderView'] = None
    ''' 

    :type: bpy_prop_collection['SceneRenderView']
    '''

    threads: int = None
    ''' Maximum number of CPU cores to use simultaneously while rendering (for multi-core/CPU systems)

    :type: int
    '''

    threads_mode: typing.Union[str, int] = None
    ''' Determine the amount of render threads used * ``AUTO`` Auto-Detect -- Automatically determine the number of threads, based on CPUs. * ``FIXED`` Fixed -- Manually determine the number of threads.

    :type: typing.Union[str, int]
    '''

    use_bake_clear: bool = None
    ''' Clear Images before baking

    :type: bool
    '''

    use_bake_lores_mesh: bool = None
    ''' Calculate heights against unsubdivided low resolution mesh

    :type: bool
    '''

    use_bake_multires: bool = None
    ''' Bake directly from multires object

    :type: bool
    '''

    use_bake_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_bake_user_scale: bool = None
    ''' Use a user scale for the derivative map

    :type: bool
    '''

    use_border: bool = None
    ''' Render a user-defined render region, within the frame size

    :type: bool
    '''

    use_compositing: bool = None
    ''' Process the render result through the compositing pipeline, if compositing nodes are enabled

    :type: bool
    '''

    use_crop_to_border: bool = None
    ''' Crop the rendered frame to the defined render region size

    :type: bool
    '''

    use_file_extension: bool = None
    ''' Add the file format extensions to the rendered file name (eg: filename + .jpg)

    :type: bool
    '''

    use_freestyle: bool = None
    ''' Draw stylized strokes using Freestyle

    :type: bool
    '''

    use_high_quality_normals: bool = None
    ''' Use high quality tangent space at the cost of lower performance

    :type: bool
    '''

    use_lock_interface: bool = None
    ''' Lock interface during rendering in favor of giving more memory to the renderer

    :type: bool
    '''

    use_motion_blur: bool = None
    ''' Use multi-sampled 3D scene motion blur

    :type: bool
    '''

    use_multiview: bool = None
    ''' Use multiple views in the scene

    :type: bool
    '''

    use_overwrite: bool = None
    ''' Overwrite existing files while rendering

    :type: bool
    '''

    use_persistent_data: bool = None
    ''' Keep render data around for faster re-renders and animation renders, at the cost of increased memory usage

    :type: bool
    '''

    use_placeholder: bool = None
    ''' Create empty placeholder files while rendering frames (similar to Unix 'touch')

    :type: bool
    '''

    use_render_cache: bool = None
    ''' Save render cache to EXR files (useful for heavy compositing, Note: affects indirectly rendered scenes)

    :type: bool
    '''

    use_sequencer: bool = None
    ''' Process the render (and composited) result through the video sequence editor pipeline, if sequencer strips exist

    :type: bool
    '''

    use_sequencer_override_scene_strip: bool = None
    ''' Use workbench render settings from the sequencer scene, instead of each individual scene used in the strip

    :type: bool
    '''

    use_simplify: bool = None
    ''' Enable simplification of scene for quicker preview renders

    :type: bool
    '''

    use_single_layer: bool = None
    ''' Only render the active layer. Only affects rendering from the interface, ignored for rendering from command line

    :type: bool
    '''

    use_spherical_stereo: typing.Union[bool, typing.Any] = None
    ''' Active render engine supports spherical stereo rendering

    :type: typing.Union[bool, typing.Any]
    '''

    use_stamp: bool = None
    ''' Render the stamp info text in the rendered image

    :type: bool
    '''

    use_stamp_camera: bool = None
    ''' Include the name of the active camera in image metadata

    :type: bool
    '''

    use_stamp_date: bool = None
    ''' Include the current date in image/video metadata

    :type: bool
    '''

    use_stamp_filename: bool = None
    ''' Include the .blend filename in image/video metadata

    :type: bool
    '''

    use_stamp_frame: bool = None
    ''' Include the frame number in image metadata

    :type: bool
    '''

    use_stamp_frame_range: bool = None
    ''' Include the rendered frame range in image/video metadata

    :type: bool
    '''

    use_stamp_hostname: bool = None
    ''' Include the hostname of the machine that rendered the frame

    :type: bool
    '''

    use_stamp_labels: bool = None
    ''' Display stamp labels ("Camera" in front of camera name, etc.)

    :type: bool
    '''

    use_stamp_lens: bool = None
    ''' Include the active camera's lens in image metadata

    :type: bool
    '''

    use_stamp_marker: bool = None
    ''' Include the name of the last marker in image metadata

    :type: bool
    '''

    use_stamp_memory: bool = None
    ''' Include the peak memory usage in image metadata

    :type: bool
    '''

    use_stamp_note: bool = None
    ''' Include a custom note in image/video metadata

    :type: bool
    '''

    use_stamp_render_time: bool = None
    ''' Include the render time in image metadata

    :type: bool
    '''

    use_stamp_scene: bool = None
    ''' Include the name of the active scene in image/video metadata

    :type: bool
    '''

    use_stamp_sequencer_strip: bool = None
    ''' Include the name of the foreground sequence strip in image metadata

    :type: bool
    '''

    use_stamp_time: bool = None
    ''' Include the rendered frame timecode as HH:MM:SS.FF in image metadata

    :type: bool
    '''

    views: 'RenderViews' = None
    ''' 

    :type: 'RenderViews'
    '''

    views_format: typing.Union[str, int] = None
    ''' * ``STEREO_3D`` Stereo 3D -- Single stereo camera system, adjust the stereo settings in the camera panel. * ``MULTIVIEW`` Multi-View -- Multi camera system, adjust the cameras individually.

    :type: typing.Union[str, int]
    '''

    def frame_path(
            self,
            frame: typing.Optional[typing.Any] = -2147483648,
            preview: typing.Optional[typing.Union[bool, typing.Any]] = False,
            view: typing.Union[str, typing.Any] = ""
    ) -> typing.Union[str, typing.Any]:
        ''' Return the absolute path to the filename to be written for a given frame

        :param frame: Frame number to use, if unset the current frame will be used
        :type frame: typing.Optional[typing.Any]
        :param preview: Preview, Use preview range
        :type preview: typing.Optional[typing.Union[bool, typing.Any]]
        :param view: View, The name of the view to use to replace the "%" chars
        :type view: typing.Union[str, typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: File Path, The resulting filepath from the scenes render settings
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderSlot(bpy_struct):
    ''' Parameters defining the render slot
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render slot name

    :type: typing.Union[str, typing.Any]
    '''

    def clear(self, iuser: typing.Optional['ImageUser']):
        ''' Clear the render slot

        :param iuser: ImageUser
        :type iuser: typing.Optional['ImageUser']
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RenderView(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RepeatItem(bpy_struct):
    color: bpy_prop_array[float] = None
    ''' Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    socket_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RetimingKey(bpy_struct):
    ''' Key mapped to particular frame that can be moved to change playback speed
    '''

    timeline_frame: int = None
    ''' Position of retiming key in timeline

    :type: int
    '''

    def remove(self):
        ''' Remove retiming key

        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RigidBodyConstraint(bpy_struct):
    ''' Constraint influencing Objects inside Rigid Body Simulation
    '''

    breaking_threshold: float = None
    ''' Impulse threshold that must be reached for the constraint to break

    :type: float
    '''

    disable_collisions: bool = None
    ''' Disable collisions between constrained rigid bodies

    :type: bool
    '''

    enabled: bool = None
    ''' Enable this constraint

    :type: bool
    '''

    limit_ang_x_lower: float = None
    ''' Lower limit of X axis rotation

    :type: float
    '''

    limit_ang_x_upper: float = None
    ''' Upper limit of X axis rotation

    :type: float
    '''

    limit_ang_y_lower: float = None
    ''' Lower limit of Y axis rotation

    :type: float
    '''

    limit_ang_y_upper: float = None
    ''' Upper limit of Y axis rotation

    :type: float
    '''

    limit_ang_z_lower: float = None
    ''' Lower limit of Z axis rotation

    :type: float
    '''

    limit_ang_z_upper: float = None
    ''' Upper limit of Z axis rotation

    :type: float
    '''

    limit_lin_x_lower: float = None
    ''' Lower limit of X axis translation

    :type: float
    '''

    limit_lin_x_upper: float = None
    ''' Upper limit of X axis translation

    :type: float
    '''

    limit_lin_y_lower: float = None
    ''' Lower limit of Y axis translation

    :type: float
    '''

    limit_lin_y_upper: float = None
    ''' Upper limit of Y axis translation

    :type: float
    '''

    limit_lin_z_lower: float = None
    ''' Lower limit of Z axis translation

    :type: float
    '''

    limit_lin_z_upper: float = None
    ''' Upper limit of Z axis translation

    :type: float
    '''

    motor_ang_max_impulse: float = None
    ''' Maximum angular motor impulse

    :type: float
    '''

    motor_ang_target_velocity: float = None
    ''' Target angular motor velocity

    :type: float
    '''

    motor_lin_max_impulse: float = None
    ''' Maximum linear motor impulse

    :type: float
    '''

    motor_lin_target_velocity: float = None
    ''' Target linear motor velocity

    :type: float
    '''

    object1: 'Object' = None
    ''' First Rigid Body Object to be constrained

    :type: 'Object'
    '''

    object2: 'Object' = None
    ''' Second Rigid Body Object to be constrained

    :type: 'Object'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    spring_damping_ang_x: float = None
    ''' Damping on the X rotational axis

    :type: float
    '''

    spring_damping_ang_y: float = None
    ''' Damping on the Y rotational axis

    :type: float
    '''

    spring_damping_ang_z: float = None
    ''' Damping on the Z rotational axis

    :type: float
    '''

    spring_damping_x: float = None
    ''' Damping on the X axis

    :type: float
    '''

    spring_damping_y: float = None
    ''' Damping on the Y axis

    :type: float
    '''

    spring_damping_z: float = None
    ''' Damping on the Z axis

    :type: float
    '''

    spring_stiffness_ang_x: float = None
    ''' Stiffness on the X rotational axis

    :type: float
    '''

    spring_stiffness_ang_y: float = None
    ''' Stiffness on the Y rotational axis

    :type: float
    '''

    spring_stiffness_ang_z: float = None
    ''' Stiffness on the Z rotational axis

    :type: float
    '''

    spring_stiffness_x: float = None
    ''' Stiffness on the X axis

    :type: float
    '''

    spring_stiffness_y: float = None
    ''' Stiffness on the Y axis

    :type: float
    '''

    spring_stiffness_z: float = None
    ''' Stiffness on the Z axis

    :type: float
    '''

    spring_type: typing.Union[str, int] = None
    ''' Which implementation of spring to use * ``SPRING1`` Blender 2.7 -- Spring implementation used in Blender 2.7. Damping is capped at 1.0. * ``SPRING2`` Blender 2.8 -- New implementation available since 2.8.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' Type of Rigid Body Constraint

    :type: typing.Union[str, int]
    '''

    use_breaking: bool = None
    ''' Constraint can be broken if it receives an impulse above the threshold

    :type: bool
    '''

    use_limit_ang_x: bool = None
    ''' Limit rotation around X axis

    :type: bool
    '''

    use_limit_ang_y: bool = None
    ''' Limit rotation around Y axis

    :type: bool
    '''

    use_limit_ang_z: bool = None
    ''' Limit rotation around Z axis

    :type: bool
    '''

    use_limit_lin_x: bool = None
    ''' Limit translation on X axis

    :type: bool
    '''

    use_limit_lin_y: bool = None
    ''' Limit translation on Y axis

    :type: bool
    '''

    use_limit_lin_z: bool = None
    ''' Limit translation on Z axis

    :type: bool
    '''

    use_motor_ang: bool = None
    ''' Enable angular motor

    :type: bool
    '''

    use_motor_lin: bool = None
    ''' Enable linear motor

    :type: bool
    '''

    use_override_solver_iterations: bool = None
    ''' Override the number of solver iterations for this constraint

    :type: bool
    '''

    use_spring_ang_x: bool = None
    ''' Enable spring on X rotational axis

    :type: bool
    '''

    use_spring_ang_y: bool = None
    ''' Enable spring on Y rotational axis

    :type: bool
    '''

    use_spring_ang_z: bool = None
    ''' Enable spring on Z rotational axis

    :type: bool
    '''

    use_spring_x: bool = None
    ''' Enable spring on X axis

    :type: bool
    '''

    use_spring_y: bool = None
    ''' Enable spring on Y axis

    :type: bool
    '''

    use_spring_z: bool = None
    ''' Enable spring on Z axis

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RigidBodyObject(bpy_struct):
    ''' Settings for object participating in Rigid Body Simulation
    '''

    angular_damping: float = None
    ''' Amount of angular velocity that is lost over time

    :type: float
    '''

    collision_collections: typing.List[bool] = None
    ''' Collision collections rigid body belongs to

    :type: typing.List[bool]
    '''

    collision_margin: float = None
    ''' Threshold of distance near surface where collisions are still considered (best results when non-zero)

    :type: float
    '''

    collision_shape: typing.Union[str, int] = None
    ''' Collision Shape of object in Rigid Body Simulations

    :type: typing.Union[str, int]
    '''

    deactivate_angular_velocity: float = None
    ''' Angular Velocity below which simulation stops simulating object

    :type: float
    '''

    deactivate_linear_velocity: float = None
    ''' Linear Velocity below which simulation stops simulating object

    :type: float
    '''

    enabled: bool = None
    ''' Rigid Body actively participates to the simulation

    :type: bool
    '''

    friction: float = None
    ''' Resistance of object to movement

    :type: float
    '''

    kinematic: bool = None
    ''' Allow rigid body to be controlled by the animation system

    :type: bool
    '''

    linear_damping: float = None
    ''' Amount of linear velocity that is lost over time

    :type: float
    '''

    mass: float = None
    ''' How much the object 'weighs' irrespective of gravity

    :type: float
    '''

    mesh_source: typing.Union[str, int] = None
    ''' Source of the mesh used to create collision shape * ``BASE`` Base -- Base mesh. * ``DEFORM`` Deform -- Deformations (shape keys, deform modifiers). * ``FINAL`` Final -- All modifiers.

    :type: typing.Union[str, int]
    '''

    restitution: float = None
    ''' Tendency of object to bounce after colliding with another (0 = stays still, 1 = perfectly elastic)

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Role of object in Rigid Body Simulations

    :type: typing.Union[str, int]
    '''

    use_deactivation: bool = None
    ''' Enable deactivation of resting rigid bodies (increases performance and stability but can cause glitches)

    :type: bool
    '''

    use_deform: bool = None
    ''' Rigid body deforms during simulation

    :type: bool
    '''

    use_margin: bool = None
    ''' Use custom collision margin (some shapes will have a visible gap around them)

    :type: bool
    '''

    use_start_deactivated: bool = None
    ''' Deactivate rigid body at the start of the simulation

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class RigidBodyWorld(bpy_struct):
    ''' Self-contained rigid body simulation environment and settings
    '''

    collection: 'Collection' = None
    ''' Collection containing objects participating in this simulation

    :type: 'Collection'
    '''

    constraints: 'Collection' = None
    ''' Collection containing rigid body constraint objects

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    enabled: bool = None
    ''' Simulation will be evaluated

    :type: bool
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    substeps_per_frame: int = None
    ''' Number of simulation steps taken per frame (higher values are more accurate but slower)

    :type: int
    '''

    time_scale: float = None
    ''' Change the speed of the simulation

    :type: float
    '''

    use_split_impulse: bool = None
    ''' Reduce extra velocity that can build up when objects collide (lowers simulation stability a little so use only when necessary)

    :type: bool
    '''

    def convex_sweep_test(
            self, object: 'Object', start: typing.Optional[
                typing.Union[typing.List[float], typing.
                             Tuple[float, float, float], 'mathutils.Vector']],
            end: typing.Optional[
                typing.Union[typing.List[float], typing.
                             Tuple[float, float, float], 'mathutils.Vector']]):
        ''' Sweep test convex rigidbody against the current rigidbody world

        :param object: Rigidbody object with a convex collision shape
        :type object: 'Object'
        :param start: 
        :type start: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        :param end: 
        :type end: typing.Optional[typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']]
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SPHFluidSettings(bpy_struct):
    ''' Settings for particle fluids physics
    '''

    buoyancy: float = None
    ''' Artificial buoyancy force in negative gravity direction based on pressure differences inside the fluid

    :type: float
    '''

    fluid_radius: float = None
    ''' Fluid interaction radius

    :type: float
    '''

    linear_viscosity: float = None
    ''' Linear viscosity

    :type: float
    '''

    plasticity: float = None
    ''' How much the spring rest length can change after the elastic limit is crossed

    :type: float
    '''

    repulsion: float = None
    ''' How strongly the fluid tries to keep from clustering (factor of stiffness)

    :type: float
    '''

    rest_density: float = None
    ''' Fluid rest density

    :type: float
    '''

    rest_length: float = None
    ''' Spring rest length (factor of particle radius)

    :type: float
    '''

    solver: typing.Union[str, int] = None
    ''' The code used to calculate internal forces on particles * ``DDR`` Double-Density -- An artistic solver with strong surface tension effects (original). * ``CLASSICAL`` Classical -- A more physically-accurate solver.

    :type: typing.Union[str, int]
    '''

    spring_force: float = None
    ''' Spring force

    :type: float
    '''

    spring_frames: int = None
    ''' Create springs for this number of frames since particles birth (0 is always)

    :type: int
    '''

    stiff_viscosity: float = None
    ''' Creates viscosity for expanding fluid

    :type: float
    '''

    stiffness: float = None
    ''' How incompressible the fluid is (speed of sound)

    :type: float
    '''

    use_factor_density: bool = None
    ''' Density is calculated as a factor of default density (depends on particle size)

    :type: bool
    '''

    use_factor_radius: bool = None
    ''' Interaction radius is a factor of 4 * particle size

    :type: bool
    '''

    use_factor_repulsion: bool = None
    ''' Repulsion is a factor of stiffness

    :type: bool
    '''

    use_factor_rest_length: bool = None
    ''' Spring rest length is a factor of 2 * particle size

    :type: bool
    '''

    use_factor_stiff_viscosity: bool = None
    ''' Stiff viscosity is a factor of normal viscosity

    :type: bool
    '''

    use_initial_rest_length: bool = None
    ''' Use the initial length as spring rest length instead of 2 * particle size

    :type: bool
    '''

    use_viscoelastic_springs: bool = None
    ''' Use viscoelastic springs instead of Hooke's springs

    :type: bool
    '''

    yield_ratio: float = None
    ''' How much the spring has to be stretched/compressed in order to change its rest length

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SceneDisplay(bpy_struct):
    ''' Scene display settings for 3D viewport
    '''

    light_direction: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Vector'] = None
    ''' Direction of the light for shadows and highlights

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    matcap_ssao_attenuation: float = None
    ''' Attenuation constant

    :type: float
    '''

    matcap_ssao_distance: float = None
    ''' Distance of object that contribute to the Cavity/Edge effect

    :type: float
    '''

    matcap_ssao_samples: int = None
    ''' Number of samples

    :type: int
    '''

    render_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing when rendering final image * ``OFF`` No Anti-Aliasing -- Scene will be rendering without any anti-aliasing. * ``FXAA`` Single Pass Anti-Aliasing -- Scene will be rendered using a single pass anti-aliasing method (FXAA). * ``5`` 5 Samples -- Scene will be rendered using 5 anti-aliasing samples. * ``8`` 8 Samples -- Scene will be rendered using 8 anti-aliasing samples. * ``11`` 11 Samples -- Scene will be rendered using 11 anti-aliasing samples. * ``16`` 16 Samples -- Scene will be rendered using 16 anti-aliasing samples. * ``32`` 32 Samples -- Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    shading: 'View3DShading' = None
    ''' Shading settings for OpenGL render engine

    :type: 'View3DShading'
    '''

    shadow_focus: float = None
    ''' Shadow factor hardness

    :type: float
    '''

    shadow_shift: float = None
    ''' Shadow termination angle

    :type: float
    '''

    viewport_aa: typing.Union[str, int] = None
    ''' Method of anti-aliasing when rendering 3d viewport * ``OFF`` No Anti-Aliasing -- Scene will be rendering without any anti-aliasing. * ``FXAA`` Single Pass Anti-Aliasing -- Scene will be rendered using a single pass anti-aliasing method (FXAA). * ``5`` 5 Samples -- Scene will be rendered using 5 anti-aliasing samples. * ``8`` 8 Samples -- Scene will be rendered using 8 anti-aliasing samples. * ``11`` 11 Samples -- Scene will be rendered using 11 anti-aliasing samples. * ``16`` 16 Samples -- Scene will be rendered using 16 anti-aliasing samples. * ``32`` 32 Samples -- Scene will be rendered using 32 anti-aliasing samples.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SceneEEVEE(bpy_struct):
    ''' Scene display settings for 3D viewport
    '''

    bloom_clamp: float = None
    ''' Maximum intensity a bloom pixel can have (0 to disable)

    :type: float
    '''

    bloom_color: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Color applied to the bloom effect

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    bloom_intensity: float = None
    ''' Blend factor

    :type: float
    '''

    bloom_knee: float = None
    ''' Makes transition between under/over-threshold gradual

    :type: float
    '''

    bloom_radius: float = None
    ''' Bloom spread distance

    :type: float
    '''

    bloom_threshold: float = None
    ''' Filters out pixels under this level of brightness

    :type: float
    '''

    bokeh_denoise_fac: float = None
    ''' Amount of flicker removal applied to bokeh highlights

    :type: float
    '''

    bokeh_max_size: float = None
    ''' Max size of the bokeh shape for the depth of field (lower is faster)

    :type: float
    '''

    bokeh_neighbor_max: float = None
    ''' Maximum brightness to consider when rejecting bokeh sprites based on neighborhood (lower is faster)

    :type: float
    '''

    bokeh_overblur: float = None
    ''' Apply blur to each jittered sample to reduce under-sampling artifacts

    :type: float
    '''

    bokeh_threshold: float = None
    ''' Brightness threshold for using sprite base depth of field

    :type: float
    '''

    diffuse_options: 'RaytraceEEVEE' = None
    ''' EEVEE settings for tracing diffuse reflections

    :type: 'RaytraceEEVEE'
    '''

    gi_auto_bake: bool = None
    ''' Auto bake indirect lighting when editing probes

    :type: bool
    '''

    gi_cache_info: typing.Union[str, typing.Any] = None
    ''' Info on current cache status

    :type: typing.Union[str, typing.Any]
    '''

    gi_cubemap_display_size: float = None
    ''' Size of the cubemap spheres to debug captured light

    :type: float
    '''

    gi_cubemap_resolution: typing.Union[str, int] = None
    ''' Size of every cubemaps

    :type: typing.Union[str, int]
    '''

    gi_diffuse_bounces: int = None
    ''' Number of times the light is reinjected inside light grids, 0 disable indirect diffuse light

    :type: int
    '''

    gi_filter_quality: float = None
    ''' Take more samples during cubemap filtering to remove artifacts

    :type: float
    '''

    gi_glossy_clamp: float = None
    ''' Clamp pixel intensity to reduce noise inside glossy reflections from reflection cubemaps (0 to disable)

    :type: float
    '''

    gi_irradiance_display_size: float = None
    ''' Size of the irradiance sample spheres to debug captured light

    :type: float
    '''

    gi_irradiance_pool_size: typing.Union[str, int] = None
    ''' Size of the irradiance pool, a bigger pool size allows for more irradiance grid in the scene but might not fit into GPU memory and decrease performance

    :type: typing.Union[str, int]
    '''

    gi_irradiance_smoothing: float = None
    ''' Smoother irradiance interpolation but introduce light bleeding

    :type: float
    '''

    gi_show_cubemaps: bool = None
    ''' Display captured cubemaps in the viewport

    :type: bool
    '''

    gi_show_irradiance: bool = None
    ''' Display irradiance samples in the viewport

    :type: bool
    '''

    gi_visibility_resolution: typing.Union[str, int] = None
    ''' Size of the shadow map applied to each irradiance sample

    :type: typing.Union[str, int]
    '''

    gtao_distance: float = None
    ''' Distance of object that contribute to the ambient occlusion effect

    :type: float
    '''

    gtao_factor: float = None
    ''' Factor for ambient occlusion blending

    :type: float
    '''

    gtao_quality: float = None
    ''' Precision of the horizon search

    :type: float
    '''

    light_threshold: float = None
    ''' Minimum light intensity for a light to contribute to the lighting

    :type: float
    '''

    motion_blur_depth_scale: float = None
    ''' Lower values will reduce background bleeding onto foreground elements

    :type: float
    '''

    motion_blur_max: int = None
    ''' Maximum blur distance a pixel can spread over

    :type: int
    '''

    motion_blur_position: typing.Union[str, int] = None
    ''' Offset for the shutter's time interval, allows to change the motion blur trails * ``START`` Start on Frame -- The shutter opens at the current frame. * ``CENTER`` Center on Frame -- The shutter is open during the current frame. * ``END`` End on Frame -- The shutter closes at the current frame.

    :type: typing.Union[str, int]
    '''

    motion_blur_shutter: float = None
    ''' Time taken in frames between shutter open and close

    :type: float
    '''

    motion_blur_steps: int = None
    ''' Controls accuracy of motion blur, more steps means longer render time

    :type: int
    '''

    overscan_size: float = None
    ''' Percentage of render size to add as overscan to the internal render buffers

    :type: float
    '''

    ray_split_settings: typing.Union[str, int] = None
    ''' Split settings per ray type * ``UNIFIED`` Unified -- All ray types use the same settings. * ``SPLIT`` Split -- Settings are individual to each ray type.

    :type: typing.Union[str, int]
    '''

    ray_tracing_method: typing.Union[str, int] = None
    ''' Select the tracing method used to find scene-ray intersections * ``NONE`` None -- No intersection with scene geometry. * ``SCREEN`` Screen-Trace -- Raytrace against the depth buffer.

    :type: typing.Union[str, int]
    '''

    reflection_options: 'RaytraceEEVEE' = None
    ''' EEVEE settings for tracing reflections

    :type: 'RaytraceEEVEE'
    '''

    refraction_options: 'RaytraceEEVEE' = None
    ''' EEVEE settings for tracing refractions

    :type: 'RaytraceEEVEE'
    '''

    shadow_cascade_size: typing.Union[str, int] = None
    ''' Size of sun light shadow maps

    :type: typing.Union[str, int]
    '''

    shadow_cube_size: typing.Union[str, int] = None
    ''' Size of point and area light shadow maps

    :type: typing.Union[str, int]
    '''

    shadow_normal_bias: float = None
    ''' Move along their normal

    :type: float
    '''

    shadow_pool_size: typing.Union[str, int] = None
    ''' Size of the shadow pool, a bigger pool size allows for more shadows in the scene but might not fit into GPU memory

    :type: typing.Union[str, int]
    '''

    shadow_ray_count: int = None
    ''' Amount of shadow ray to trace for each light

    :type: int
    '''

    shadow_step_count: int = None
    ''' Amount of shadow map sample per shadow ray

    :type: int
    '''

    ssr_border_fade: float = None
    ''' Screen percentage used to fade the SSR

    :type: float
    '''

    ssr_firefly_fac: float = None
    ''' Clamp pixel intensity to remove noise (0 to disable)

    :type: float
    '''

    ssr_max_roughness: float = None
    ''' Do not raytrace reflections for roughness above this value

    :type: float
    '''

    ssr_quality: float = None
    ''' Precision of the screen space ray-tracing

    :type: float
    '''

    ssr_thickness: float = None
    ''' Pixel thickness used to detect intersection

    :type: float
    '''

    sss_jitter_threshold: float = None
    ''' Rotate samples that are below this threshold

    :type: float
    '''

    sss_samples: int = None
    ''' Number of samples to compute the scattering effect

    :type: int
    '''

    taa_render_samples: int = None
    ''' Number of samples per pixel for rendering

    :type: int
    '''

    taa_samples: int = None
    ''' Number of samples, unlimited if 0

    :type: int
    '''

    use_bloom: bool = None
    ''' High brightness pixels generate a glowing effect

    :type: bool
    '''

    use_bokeh_high_quality_slight_defocus: bool = None
    ''' Sample all pixels in almost in-focus regions to eliminate noise

    :type: bool
    '''

    use_bokeh_jittered: bool = None
    ''' Jitter camera position to create accurate blurring using render samples

    :type: bool
    '''

    use_gtao: bool = None
    ''' Enable ambient occlusion to simulate medium scale indirect shadowing

    :type: bool
    '''

    use_gtao_bent_normals: bool = None
    ''' Compute main non occluded direction to sample the environment

    :type: bool
    '''

    use_gtao_bounce: bool = None
    ''' An approximation to simulate light bounces giving less occlusion on brighter objects

    :type: bool
    '''

    use_motion_blur: bool = None
    ''' Enable motion blur effect (only in camera view)

    :type: bool
    '''

    use_overscan: bool = None
    ''' Internally render past the image border to avoid screen-space effects disappearing

    :type: bool
    '''

    use_shadow_high_bitdepth: bool = None
    ''' Use 32-bit shadows

    :type: bool
    '''

    use_shadows: bool = None
    ''' Enable shadow casting from lights

    :type: bool
    '''

    use_soft_shadows: bool = None
    ''' Randomize shadowmaps origin to create soft shadows

    :type: bool
    '''

    use_ssr: bool = None
    ''' Enable screen space reflection

    :type: bool
    '''

    use_ssr_halfres: bool = None
    ''' Raytrace at a lower resolution

    :type: bool
    '''

    use_ssr_refraction: bool = None
    ''' Enable screen space Refractions

    :type: bool
    '''

    use_taa_reprojection: bool = None
    ''' Denoise image using temporal reprojection (can leave some ghosting)

    :type: bool
    '''

    use_volumetric_lights: bool = None
    ''' Enable scene light interactions with volumetrics

    :type: bool
    '''

    use_volumetric_shadows: bool = None
    ''' Generate shadows from volumetric material (Very expensive)

    :type: bool
    '''

    volumetric_end: float = None
    ''' End distance of the volumetric effect

    :type: float
    '''

    volumetric_light_clamp: float = None
    ''' Maximum light contribution, reducing noise

    :type: float
    '''

    volumetric_sample_distribution: float = None
    ''' Distribute more samples closer to the camera

    :type: float
    '''

    volumetric_samples: int = None
    ''' Number of samples to compute volumetric effects

    :type: int
    '''

    volumetric_shadow_samples: int = None
    ''' Number of samples to compute volumetric shadowing

    :type: int
    '''

    volumetric_start: float = None
    ''' Start distance of the volumetric effect

    :type: float
    '''

    volumetric_tile_size: typing.Union[str, int] = None
    ''' Control the quality of the volumetric effects (lower size increase vram usage and quality)

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SceneGpencil(bpy_struct):
    ''' Render settings
    '''

    antialias_threshold: float = None
    ''' Threshold for edge detection algorithm (higher values might over-blur some part of the image)

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SceneHydra(bpy_struct):
    ''' Scene Hydra render engine settings
    '''

    export_method: typing.Union[str, int] = None
    ''' How to export the Blender scene to the Hydra render engine * ``HYDRA`` Hydra -- Fast interactive editing through native Hydra integration. * ``USD`` USD -- Export scene through USD file, for accurate comparison with USD file export.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SceneRenderView(bpy_struct):
    ''' Render viewpoint for 3D stereo and multiview rendering
    '''

    camera_suffix: typing.Union[str, typing.Any] = None
    ''' Suffix to identify the cameras to use, and added to the render images for this view

    :type: typing.Union[str, typing.Any]
    '''

    file_suffix: typing.Union[str, typing.Any] = None
    ''' Suffix added to the render images for this view

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render view name

    :type: typing.Union[str, typing.Any]
    '''

    use: bool = None
    ''' Disable or enable the render view

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Scopes(bpy_struct):
    ''' Scopes for statistical view of an image
    '''

    accuracy: float = None
    ''' Proportion of original image source pixel lines to sample

    :type: float
    '''

    histogram: 'Histogram' = None
    ''' Histogram for viewing image statistics

    :type: 'Histogram'
    '''

    use_full_resolution: bool = None
    ''' Sample every pixel of the image

    :type: bool
    '''

    vectorscope_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ScriptDirectory(bpy_struct):
    directory: typing.Union[str, typing.Any] = None
    ''' Alternate script path, matching the default layout with sub-directories: startup, add-ons, modules, and presets (requires restart)

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Identifier for the Python scripts directory

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Sequence(bpy_struct):
    ''' Sequence strip in the sequence editor
    '''

    blend_alpha: float = None
    ''' Percentage of how much the strip's colors affect other strips

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method for controlling how the strip combines with other strips

    :type: typing.Union[str, int]
    '''

    channel: int = None
    ''' Y position of the sequence strip

    :type: int
    '''

    color_tag: typing.Union[str, int] = None
    ''' Color tag for a strip

    :type: typing.Union[str, int]
    '''

    effect_fader: float = None
    ''' Custom fade value

    :type: float
    '''

    frame_duration: int = None
    ''' The length of the contents of this strip before the handles are applied

    :type: int
    '''

    frame_final_duration: int = None
    ''' The length of the contents of this strip after the handles are applied

    :type: int
    '''

    frame_final_end: int = None
    ''' End frame displayed in the sequence editor after offsets are applied

    :type: int
    '''

    frame_final_start: int = None
    ''' Start frame displayed in the sequence editor after offsets are applied, setting this is equivalent to moving the handle, not the actual start frame

    :type: int
    '''

    frame_offset_end: float = None
    ''' 

    :type: float
    '''

    frame_offset_start: float = None
    ''' 

    :type: float
    '''

    frame_start: float = None
    ''' X position where the strip begins

    :type: float
    '''

    lock: bool = None
    ''' Lock strip so that it cannot be transformed

    :type: bool
    '''

    modifiers: 'SequenceModifiers' = None
    ''' Modifiers affecting this strip

    :type: 'SequenceModifiers'
    '''

    mute: bool = None
    ''' Disable strip so that it cannot be viewed in the output

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    override_cache_settings: bool = None
    ''' Override global cache settings

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_left_handle: bool = None
    ''' 

    :type: bool
    '''

    select_right_handle: bool = None
    ''' 

    :type: bool
    '''

    show_retiming_keys: bool = None
    ''' Show retiming keys, so they can be moved

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_cache_composite: bool = None
    ''' Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    ''' Cache preprocessed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    '''

    use_cache_raw: bool = None
    ''' Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    '''

    use_default_fade: bool = None
    ''' Fade effect using the built-in default (usually make transition as long as effect strip)

    :type: bool
    '''

    use_linear_modifiers: bool = None
    ''' Calculate modifiers in linear space instead of sequencer's space

    :type: bool
    '''

    def strip_elem_from_frame(
            self, frame: typing.Optional[int]) -> 'SequenceElement':
        ''' Return the strip element from a given frame or None

        :param frame: Frame, The frame to get the strip element from
        :type frame: typing.Optional[int]
        :rtype: 'SequenceElement'
        :return: strip element of the current frame
        '''
        pass

    def swap(self, other: 'Sequence'):
        ''' swap

        :param other: Other
        :type other: 'Sequence'
        '''
        pass

    def move_to_meta(self, meta_sequence: 'Sequence'):
        ''' move_to_meta

        :param meta_sequence: Destination Meta Sequence, Meta to move the strip into
        :type meta_sequence: 'Sequence'
        '''
        pass

    def parent_meta(self) -> 'Sequence':
        ''' Parent meta

        :rtype: 'Sequence'
        :return: Parent Meta
        '''
        pass

    def invalidate_cache(self, type: typing.Any):
        ''' Invalidate cached images for strip and all dependent strips

        :param type: Type, Cache Type
        :type type: typing.Any
        '''
        pass

    def split(self, frame: typing.Optional[int],
              split_method: typing.Any) -> 'Sequence':
        ''' Split Sequence

        :param frame: Frame where to split the strip
        :type frame: typing.Optional[int]
        :param split_method: 
        :type split_method: typing.Any
        :rtype: 'Sequence'
        :return: Right side Sequence
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceColorBalanceData(bpy_struct):
    ''' Color balance parameters for a sequence strip and its modifiers
    '''

    correction_method: typing.Union[str, int] = None
    ''' * ``LIFT_GAMMA_GAIN`` Lift/Gamma/Gain. * ``OFFSET_POWER_SLOPE`` Offset/Power/Slope (ASC-CDL) -- ASC-CDL standard color correction.

    :type: typing.Union[str, int]
    '''

    gain: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color balance gain (highlights)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    gamma: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color balance gamma (midtones)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    invert_gain: bool = None
    ''' Invert the gain color

    :type: bool
    '''

    invert_gamma: bool = None
    ''' Invert the gamma color

    :type: bool
    '''

    invert_lift: bool = None
    ''' Invert the lift color

    :type: bool
    '''

    invert_offset: bool = None
    ''' Invert the offset color

    :type: bool
    '''

    invert_power: bool = None
    ''' Invert the power color

    :type: bool
    '''

    invert_slope: bool = None
    ''' Invert the slope color

    :type: bool
    '''

    lift: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color balance lift (shadows)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    offset: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Correction for entire tonal range

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    power: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Correction for midtones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    slope: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Correction for highlights

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceCrop(bpy_struct):
    ''' Cropping parameters for a sequence strip
    '''

    max_x: int = None
    ''' Number of pixels to crop from the right side

    :type: int
    '''

    max_y: int = None
    ''' Number of pixels to crop from the top

    :type: int
    '''

    min_x: int = None
    ''' Number of pixels to crop from the left side

    :type: int
    '''

    min_y: int = None
    ''' Number of pixels to crop from the bottom

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceEditor(bpy_struct):
    ''' Sequence editing data for a Scene data-block
    '''

    active_strip: 'Sequence' = None
    ''' Sequencer's active strip

    :type: 'Sequence'
    '''

    channels: bpy_prop_collection['SequenceTimelineChannel'] = None
    ''' 

    :type: bpy_prop_collection['SequenceTimelineChannel']
    '''

    meta_stack: bpy_prop_collection['Sequence'] = None
    ''' Meta strip stack, last is currently edited meta strip

    :type: bpy_prop_collection['Sequence']
    '''

    overlay_frame: int = None
    ''' Number of frames to offset

    :type: int
    '''

    proxy_dir: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    proxy_storage: typing.Union[str, int] = None
    ''' How to store proxies for this project * ``PER_STRIP`` Per Strip -- Store proxies using per strip settings. * ``PROJECT`` Project -- Store proxies using project directory.

    :type: typing.Union[str, int]
    '''

    selected_retiming_keys: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    sequences: 'SequencesTopLevel' = None
    ''' Top-level strips only

    :type: 'SequencesTopLevel'
    '''

    sequences_all: bpy_prop_collection['Sequence'] = None
    ''' All strips, recursively including those inside metastrips

    :type: bpy_prop_collection['Sequence']
    '''

    show_cache: bool = None
    ''' Visualize cached images on the timeline

    :type: bool
    '''

    show_cache_composite: bool = None
    ''' Visualize cached composite images

    :type: bool
    '''

    show_cache_final_out: bool = None
    ''' Visualize cached complete frames

    :type: bool
    '''

    show_cache_preprocessed: bool = None
    ''' Visualize cached pre-processed images

    :type: bool
    '''

    show_cache_raw: bool = None
    ''' Visualize cached raw images

    :type: bool
    '''

    show_overlay_frame: bool = None
    ''' Partial overlay on top of the sequencer with a frame offset

    :type: bool
    '''

    use_cache_composite: bool = None
    ''' Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    '''

    use_cache_final: bool = None
    ''' Cache final image for each frame

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    ''' Cache preprocessed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    '''

    use_cache_raw: bool = None
    ''' Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    '''

    use_overlay_frame_lock: bool = None
    ''' 

    :type: bool
    '''

    use_prefetch: bool = None
    ''' Render frames ahead of current frame in the background for faster playback

    :type: bool
    '''

    def display_stack(self, meta_sequence: typing.Optional['Sequence']):
        ''' Display sequences stack

        :param meta_sequence: Meta Sequence, Meta to display its stack
        :type meta_sequence: typing.Optional['Sequence']
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceElement(bpy_struct):
    ''' Sequence strip data for a single frame
    '''

    filename: typing.Union[str, typing.Any] = None
    ''' Name of the source file

    :type: typing.Union[str, typing.Any]
    '''

    orig_fps: float = None
    ''' Original frames per second

    :type: float
    '''

    orig_height: int = None
    ''' Original image height

    :type: int
    '''

    orig_width: int = None
    ''' Original image width

    :type: int
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceModifier(bpy_struct):
    ''' Modifier for sequence strip
    '''

    input_mask_id: 'Mask' = None
    ''' Mask ID used as mask input for the modifier

    :type: 'Mask'
    '''

    input_mask_strip: 'Sequence' = None
    ''' Strip used as mask input for the modifier

    :type: 'Sequence'
    '''

    input_mask_type: typing.Union[str, int] = None
    ''' Type of input data used for mask * ``STRIP`` Strip -- Use sequencer strip as mask input. * ``ID`` Mask -- Use mask ID as mask input.

    :type: typing.Union[str, int]
    '''

    mask_time: typing.Union[str, int] = None
    ''' Time to use for the Mask animation * ``RELATIVE`` Relative -- Mask animation is offset to start of strip. * ``ABSOLUTE`` Absolute -- Mask animation is in sync with scene frame.

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Mute this modifier

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Mute expanded settings for the modifier

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceProxy(bpy_struct):
    ''' Proxy parameters for a sequence strip
    '''

    build_100: bool = None
    ''' Build 100% proxy resolution

    :type: bool
    '''

    build_25: bool = None
    ''' Build 25% proxy resolution

    :type: bool
    '''

    build_50: bool = None
    ''' Build 50% proxy resolution

    :type: bool
    '''

    build_75: bool = None
    ''' Build 75% proxy resolution

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Location of custom proxy file

    :type: typing.Union[str, typing.Any]
    '''

    quality: int = None
    ''' Quality of proxies to build

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' Method for reading the inputs timecode * ``NONE`` None. * ``RECORD_RUN`` Record Run -- Use images in the order as they are recorded. * ``FREE_RUN`` Free Run -- Use global timestamp written by recording device. * ``FREE_RUN_REC_DATE`` Free Run (rec date) -- Interpolate a global timestamp using the record date and time written by recording device. * ``RECORD_RUN_NO_GAPS`` Record Run No Gaps -- Like record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''

    use_overwrite: bool = None
    ''' Overwrite existing proxy files when building

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    ''' Use a custom directory to store data

    :type: bool
    '''

    use_proxy_custom_file: bool = None
    ''' Use a custom file to read proxy data from

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceTimelineChannel(bpy_struct):
    lock: bool = None
    ''' 

    :type: bool
    '''

    mute: bool = None
    ''' 

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequenceTransform(bpy_struct):
    ''' Transform parameters for a sequence strip
    '''

    filter: typing.Union[str, int] = None
    ''' Type of filter to use for image transformation * ``NEAREST`` Nearest. * ``BILINEAR`` Bilinear. * ``SUBSAMPLING_3x3`` Subsampling (3×3) -- Use nearest with 3×3 subsamples during rendering.

    :type: typing.Union[str, int]
    '''

    offset_x: float = None
    ''' Move along X axis

    :type: float
    '''

    offset_y: float = None
    ''' Move along Y axis

    :type: float
    '''

    origin: bpy_prop_array[float] = None
    ''' Origin of image for transformation

    :type: bpy_prop_array[float]
    '''

    rotation: float = None
    ''' Rotate around image center

    :type: float
    '''

    scale_x: float = None
    ''' Scale along X axis

    :type: float
    '''

    scale_y: float = None
    ''' Scale along Y axis

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequencerPreviewOverlay(bpy_struct):
    show_annotation: bool = None
    ''' Show annotations for this view

    :type: bool
    '''

    show_cursor: bool = None
    ''' 

    :type: bool
    '''

    show_image_outline: bool = None
    ''' 

    :type: bool
    '''

    show_metadata: bool = None
    ''' Show metadata of first visible strip

    :type: bool
    '''

    show_safe_areas: bool = None
    ''' Show TV title safe and action safe areas in preview

    :type: bool
    '''

    show_safe_center: bool = None
    ''' Show safe areas to fit content in a different aspect ratio

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequencerTimelineOverlay(bpy_struct):
    show_fcurves: bool = None
    ''' Display strip opacity/volume curve

    :type: bool
    '''

    show_grid: bool = None
    ''' Show vertical grid lines

    :type: bool
    '''

    show_strip_duration: bool = None
    ''' 

    :type: bool
    '''

    show_strip_name: bool = None
    ''' 

    :type: bool
    '''

    show_strip_offset: bool = None
    ''' Display strip in/out offsets

    :type: bool
    '''

    show_strip_retiming: bool = None
    ''' Display retiming keys on top of strips

    :type: bool
    '''

    show_strip_source: bool = None
    ''' Display path to source file, or name of source datablock

    :type: bool
    '''

    show_strip_tag_color: bool = None
    ''' Display the strip color tags in the sequencer

    :type: bool
    '''

    show_thumbnails: bool = None
    ''' Show strip thumbnails

    :type: bool
    '''

    waveform_display_type: typing.Union[str, int] = None
    ''' How Waveforms are displayed * ``NO_WAVEFORMS`` Waveforms Off -- Don't display waveforms for any sound strips. * ``ALL_WAVEFORMS`` Waveforms On -- Display waveforms for all sound strips. * ``DEFAULT_WAVEFORMS`` Use Strip Option -- Display waveforms depending on strip setting.

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SequencerToolSettings(bpy_struct):
    fit_method: typing.Union[str, int] = None
    ''' Scale fit method * ``FIT`` Scale to Fit -- Scale image to fit within the canvas. * ``FILL`` Scale to Fill -- Scale image to completely fill the canvas. * ``STRETCH`` Stretch to Fill -- Stretch image to fill the canvas. * ``ORIGINAL`` Use Original Size -- Keep image at its original size.

    :type: typing.Union[str, int]
    '''

    overlap_mode: typing.Union[str, int] = None
    ''' How to resolve overlap after transformation * ``EXPAND`` Expand -- Move strips so transformed strips fit. * ``OVERWRITE`` Overwrite -- Trim or split strips to resolve overlap. * ``SHUFFLE`` Shuffle -- Move transformed strips to nearest free space to resolve overlap.

    :type: typing.Union[str, int]
    '''

    pivot_point: typing.Union[str, int] = None
    ''' Rotation or scaling pivot point * ``CENTER`` Bounding Box Center. * ``MEDIAN`` Median Point. * ``CURSOR`` 2D Cursor -- Pivot around the 2D cursor. * ``INDIVIDUAL_ORIGINS`` Individual Origins -- Pivot around each selected island's own median point.

    :type: typing.Union[str, int]
    '''

    snap_distance: int = None
    ''' Maximum distance for snapping in pixels

    :type: int
    '''

    snap_ignore_muted: bool = None
    ''' Don't snap to hidden strips

    :type: bool
    '''

    snap_ignore_sound: bool = None
    ''' Don't snap to sound strips

    :type: bool
    '''

    snap_to_current_frame: bool = None
    ''' Snap to current frame

    :type: bool
    '''

    snap_to_hold_offset: bool = None
    ''' Snap to strip hold offsets

    :type: bool
    '''

    use_snap_current_frame_to_strips: bool = None
    ''' Snap current frame to strip start or end

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ShaderFx(bpy_struct):
    ''' Effect affecting the grease pencil object
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Effect name

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Set effect expansion in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display effect in Edit mode

    :type: bool
    '''

    show_render: bool = None
    ''' Use effect during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display effect in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ShapeKey(bpy_struct):
    ''' Shape key in a shape keys data-block
    '''

    data: bpy_prop_collection['UnknownType'] = None
    ''' 

    :type: bpy_prop_collection['UnknownType']
    '''

    frame: float = None
    ''' Frame for absolute keys

    :type: float
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation type for absolute shape keys

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Toggle this shape key

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of Shape Key

    :type: typing.Union[str, typing.Any]
    '''

    relative_key: 'ShapeKey' = None
    ''' Shape used as a relative key

    :type: 'ShapeKey'
    '''

    slider_max: float = None
    ''' Maximum for slider

    :type: float
    '''

    slider_min: float = None
    ''' Minimum for slider

    :type: float
    '''

    value: float = None
    ''' Value of shape key at the current frame

    :type: float
    '''

    vertex_group: typing.Union[str, typing.Any] = None
    ''' Vertex weight group, to blend with basis shape

    :type: typing.Union[str, typing.Any]
    '''

    def normals_vertex_get(self) -> float:
        ''' Compute local space vertices' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_polygon_get(self) -> float:
        ''' Compute local space faces' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_split_get(self) -> float:
        ''' Compute local space face corners' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyBezierPoint(bpy_struct):
    ''' Point in a shape key for Bezier curves
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_left: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    handle_right: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyCurvePoint(bpy_struct):
    ''' Point in a shape key for curves
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ShapeKeyPoint(bpy_struct):
    ''' Point in a shape key
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SimulationStateItem(bpy_struct):
    attribute_domain: typing.Union[str, int] = None
    ''' Attribute domain where the attribute is stored in the simulation state

    :type: typing.Union[str, int]
    '''

    color: bpy_prop_array[float] = None
    ''' Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    socket_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SoftBodySettings(bpy_struct):
    ''' Soft body simulation settings for an object
    '''

    aero: int = None
    ''' Make edges 'sail'

    :type: int
    '''

    aerodynamics_type: typing.Union[str, int] = None
    ''' Method of calculating aerodynamic interaction * ``SIMPLE`` Simple -- Edges receive a drag force from surrounding media. * ``LIFT_FORCE`` Lift Force -- Edges receive a lift force when passing through surrounding media.

    :type: typing.Union[str, int]
    '''

    ball_damp: float = None
    ''' Blending to inelastic collision

    :type: float
    '''

    ball_size: float = None
    ''' Absolute ball size or factor if not manually adjusted

    :type: float
    '''

    ball_stiff: float = None
    ''' Ball inflating pressure

    :type: float
    '''

    bend: float = None
    ''' Bending Stiffness

    :type: float
    '''

    choke: int = None
    ''' 'Viscosity' inside collision target

    :type: int
    '''

    collision_collection: 'Collection' = None
    ''' Limit colliders to this collection

    :type: 'Collection'
    '''

    collision_type: typing.Union[str, int] = None
    ''' Choose Collision Type * ``MANUAL`` Manual -- Manual adjust. * ``AVERAGE`` Average -- Average Spring length \* Ball Size. * ``MINIMAL`` Minimal -- Minimal Spring length \* Ball Size. * ``MAXIMAL`` Maximal -- Maximal Spring length \* Ball Size. * ``MINMAX`` AvMinMax -- (Min+Max)/2 \* Ball Size.

    :type: typing.Union[str, int]
    '''

    damping: float = None
    ''' Edge spring friction

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    error_threshold: float = None
    ''' The Runge-Kutta ODE solver error limit, low value gives more precision, high values speed

    :type: float
    '''

    friction: float = None
    ''' General media friction for point movements

    :type: float
    '''

    fuzzy: int = None
    ''' Fuzziness while on collision, high values make collision handling faster but less stable

    :type: int
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: float = None
    ''' Apply gravitation to point movement

    :type: float
    '''

    location_mass_center: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Vector'] = None
    ''' Location of center of mass

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    mass: float = None
    ''' General Mass value

    :type: float
    '''

    plastic: int = None
    ''' Permanent deform

    :type: int
    '''

    pull: float = None
    ''' Edge spring stiffness when longer than rest length

    :type: float
    '''

    push: float = None
    ''' Edge spring stiffness when shorter than rest length

    :type: float
    '''

    rotation_estimate: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float], typing.
              Tuple[float, float, float], typing.
              Tuple[float, float, float]], 'mathutils.Matrix'] = None
    ''' Estimated rotation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], 'mathutils.Matrix']
    '''

    scale_estimate: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float], typing.
              Tuple[float, float, float], typing.
              Tuple[float, float, float]], 'mathutils.Matrix'] = None
    ''' Estimated scale matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], 'mathutils.Matrix']
    '''

    shear: float = None
    ''' Shear Stiffness

    :type: float
    '''

    speed: float = None
    ''' Tweak timing for physics to control frequency and speed

    :type: float
    '''

    spring_length: int = None
    ''' Alter spring length to shrink/blow up (unit %) 0 to disable

    :type: int
    '''

    step_max: int = None
    ''' Maximal # solver steps/frame

    :type: int
    '''

    step_min: int = None
    ''' Minimal # solver steps/frame

    :type: int
    '''

    use_auto_step: bool = None
    ''' Use velocities for automagic step sizes

    :type: bool
    '''

    use_diagnose: bool = None
    ''' Turn on SB diagnose console prints

    :type: bool
    '''

    use_edge_collision: bool = None
    ''' Edges collide too

    :type: bool
    '''

    use_edges: bool = None
    ''' Use Edges as springs

    :type: bool
    '''

    use_estimate_matrix: bool = None
    ''' Store the estimated transforms in the soft body settings

    :type: bool
    '''

    use_face_collision: bool = None
    ''' Faces collide too, can be very slow

    :type: bool
    '''

    use_goal: bool = None
    ''' Define forces for vertices to stick to animated position

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable naive vertex ball self collision

    :type: bool
    '''

    use_stiff_quads: bool = None
    ''' Add diagonal springs on 4-gons

    :type: bool
    '''

    vertex_group_goal: typing.Union[str, typing.Any] = None
    ''' Control point weight values

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_mass: typing.Union[str, typing.Any] = None
    ''' Control point mass values

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_spring: typing.Union[str, typing.Any] = None
    ''' Control point spring strength values

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Space(bpy_struct):
    ''' Space data for a screen area
    '''

    show_locked_time: bool = None
    ''' Synchronize the visible timeline range with other time-based editors

    :type: bool
    '''

    show_region_header: bool = None
    ''' 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Space data type

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass

    @classmethod
    def draw_handler_add(cls, callback: typing.Optional[typing.Any],
                         args: typing.Optional[typing.Tuple],
                         region_type: typing.Optional[str],
                         draw_type: typing.Optional[str]) -> typing.Any:
        ''' Add a new draw handler to this space type. It will be called every time the specified region in the space type will be drawn. Note: All arguments are positional only for now.

        :param callback: A function that will be called when the region is drawn. It gets the specified arguments as input.
        :type callback: typing.Optional[typing.Any]
        :param args: Arguments that will be passed to the callback.
        :type args: typing.Optional[typing.Tuple]
        :param region_type: `bpy.types.Region.type`)
        :type region_type: typing.Optional[str]
        :param draw_type: Usually ``POST_PIXEL`` for 2D drawing and ``POST_VIEW`` for 3D drawing. In some cases ``PRE_VIEW`` can be used. ``BACKDROP`` can be used for backdrops in the node editor.
        :type draw_type: typing.Optional[str]
        :rtype: typing.Any
        :return: Handler that can be removed later on.
        '''
        pass

    @classmethod
    def draw_handler_remove(cls, handler: typing.Optional[typing.Any],
                            region_type: typing.Optional[str]):
        ''' Remove a draw handler that was added previously.

        :param handler: The draw handler that should be removed.
        :type handler: typing.Optional[typing.Any]
        :param region_type: Region type the callback was added to.
        :type region_type: typing.Optional[str]
        '''
        pass


class SpaceImageOverlay(bpy_struct):
    ''' Settings for display of overlays in the UV/Image editor
    '''

    show_grid_background: bool = None
    ''' Show the grid background and borders

    :type: bool
    '''

    show_overlays: bool = None
    ''' Display overlays like UV Maps and Metadata

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SpaceNodeOverlay(bpy_struct):
    ''' Settings for display of overlays in the Node Editor
    '''

    preview_shape: typing.Union[str, int] = None
    ''' Preview shape used by the node previews * ``FLAT`` Flat -- Use the default flat previews. * ``3D`` 3D -- Use the material preview scene for the node previews.

    :type: typing.Union[str, int]
    '''

    show_context_path: bool = None
    ''' Display breadcrumbs for the editor's context

    :type: bool
    '''

    show_named_attributes: bool = None
    ''' Show when nodes are using named attributes

    :type: bool
    '''

    show_overlays: bool = None
    ''' Display overlays like colored or dashed wires

    :type: bool
    '''

    show_previews: bool = None
    ''' Display each node's preview if node is toggled

    :type: bool
    '''

    show_timing: bool = None
    ''' Display each node's last execution time

    :type: bool
    '''

    show_wire_color: bool = None
    ''' Color node links based on their connected sockets

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SpaceUVEditor(bpy_struct):
    ''' UV editor data for the image editor space
    '''

    custom_grid_subdivisions: bpy_prop_array[int] = None
    ''' Number of grid units in UV space that make one UV Unit

    :type: bpy_prop_array[int]
    '''

    display_stretch_type: typing.Union[str, int] = None
    ''' Type of stretch to display * ``ANGLE`` Angle -- Angular distortion between UV and 3D angles. * ``AREA`` Area -- Area distortion between UV and 3D faces.

    :type: typing.Union[str, int]
    '''

    edge_display_type: typing.Union[str, int] = None
    ''' Display style for UV edges * ``OUTLINE`` Outline -- Display white edges with black outline. * ``DASH`` Dash -- Display dashed black-white edges. * ``BLACK`` Black -- Display black edges. * ``WHITE`` White -- Display white edges.

    :type: typing.Union[str, int]
    '''

    grid_shape_source: typing.Union[str, int] = None
    ''' Specify source for the grid shape * ``DYNAMIC`` Dynamic -- Dynamic grid. * ``FIXED`` Fixed -- Manually set grid divisions. * ``PIXEL`` Pixel -- Grid aligns with pixels from image.

    :type: typing.Union[str, int]
    '''

    lock_bounds: bool = None
    ''' Constraint to stay within the image bounds while editing

    :type: bool
    '''

    pixel_round_mode: typing.Union[str, int] = None
    ''' Round UVs to pixels while editing * ``DISABLED`` Disabled -- Don't round to pixels. * ``CORNER`` Corner -- Round to pixel corners. * ``CENTER`` Center -- Round to pixel centers.

    :type: typing.Union[str, int]
    '''

    show_faces: bool = None
    ''' Display faces over the image

    :type: bool
    '''

    show_grid_over_image: bool = None
    ''' Show the grid over the image

    :type: bool
    '''

    show_metadata: bool = None
    ''' Display metadata properties of the image

    :type: bool
    '''

    show_modified_edges: bool = None
    ''' Display edges after modifiers are applied

    :type: bool
    '''

    show_pixel_coords: bool = None
    ''' Display UV coordinates in pixels rather than from 0.0 to 1.0

    :type: bool
    '''

    show_stretch: bool = None
    ''' Display faces colored according to the difference in shape between UVs and their 3D coordinates (blue for low distortion, red for high distortion)

    :type: bool
    '''

    show_texpaint: bool = None
    ''' Display overlay of texture paint UV layer

    :type: bool
    '''

    tile_grid_shape: bpy_prop_array[int] = None
    ''' How many tiles will be shown in the background

    :type: bpy_prop_array[int]
    '''

    use_live_unwrap: bool = None
    ''' Continuously unwrap the selected UV island while transforming pinned vertices

    :type: bool
    '''

    uv_opacity: float = None
    ''' Opacity of UV overlays

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Spline(bpy_struct):
    ''' Element of a curve, either NURBS, Bezier or Polyline or a character with text objects
    '''

    bezier_points: 'SplineBezierPoints' = None
    ''' Collection of points for Bezier curves only

    :type: 'SplineBezierPoints'
    '''

    character_index: int = None
    ''' Location of this character in the text data (only for text curves)

    :type: int
    '''

    hide: bool = None
    ''' Hide this curve in Edit mode

    :type: bool
    '''

    material_index: int = None
    ''' Material slot index of this curve

    :type: int
    '''

    order_u: int = None
    ''' NURBS order in the U direction. Higher values make each point influence a greater area, but have worse performance

    :type: int
    '''

    order_v: int = None
    ''' NURBS order in the V direction. Higher values make each point influence a greater area, but have worse performance

    :type: int
    '''

    point_count_u: int = None
    ''' Total number points for the curve or surface in the U direction

    :type: int
    '''

    point_count_v: int = None
    ''' Total number points for the surface on the V direction

    :type: int
    '''

    points: 'SplinePoints' = None
    ''' Collection of points that make up this poly or nurbs spline

    :type: 'SplinePoints'
    '''

    radius_interpolation: typing.Union[str, int] = None
    ''' The type of radius interpolation for Bezier curves

    :type: typing.Union[str, int]
    '''

    resolution_u: int = None
    ''' Curve or Surface subdivisions per segment

    :type: int
    '''

    resolution_v: int = None
    ''' Surface subdivisions per segment

    :type: int
    '''

    tilt_interpolation: typing.Union[str, int] = None
    ''' The type of tilt interpolation for 3D, Bezier curves

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' The interpolation type for this curve element

    :type: typing.Union[str, int]
    '''

    use_bezier_u: bool = None
    ''' Make this nurbs curve or surface act like a Bezier spline in the U direction

    :type: bool
    '''

    use_bezier_v: bool = None
    ''' Make this nurbs surface act like a Bezier spline in the V direction

    :type: bool
    '''

    use_cyclic_u: bool = None
    ''' Make this curve or surface a closed loop in the U direction

    :type: bool
    '''

    use_cyclic_v: bool = None
    ''' Make this surface a closed loop in the V direction

    :type: bool
    '''

    use_endpoint_u: bool = None
    ''' Make this nurbs curve or surface meet the endpoints in the U direction

    :type: bool
    '''

    use_endpoint_v: bool = None
    ''' Make this nurbs surface meet the endpoints in the V direction

    :type: bool
    '''

    use_smooth: bool = None
    ''' Smooth the normals of the surface or beveled curve

    :type: bool
    '''

    def calc_length(self,
                    resolution: typing.Optional[typing.Any] = 0) -> float:
        ''' Calculate spline length

        :param resolution: Resolution, Spline resolution to be used, 0 defaults to the resolution_u
        :type resolution: typing.Optional[typing.Any]
        :rtype: float
        :return: Length, Length of the polygonaly approximated spline
        '''
        pass

    def valid_message(self, direction: typing.Optional[int]) -> str:
        ''' Return the message

        :param direction: Direction, The direction where 0-1 maps to U-V
        :type direction: typing.Optional[int]
        :rtype: str
        :return: Return value, The message or an empty string when there is no error
        '''
        pass

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SplinePoint(bpy_struct):
    ''' Spline point without handles
    '''

    co: typing.Union[typing.List[float], typing.
                     Tuple[float, float, float, float],
                     'mathutils.Vector'] = None
    ''' Point coordinates

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float, float], 'mathutils.Vector']
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight: float = None
    ''' NURBS weight

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SpreadsheetColumn(bpy_struct):
    ''' Persistent data associated with a spreadsheet column
    '''

    data_type: typing.Union[str, int] = None
    ''' The data type of the corresponding column visible in the spreadsheet

    :type: typing.Union[str, int]
    '''

    id: 'SpreadsheetColumnID' = None
    ''' Data used to identify the corresponding data from the data source

    :type: 'SpreadsheetColumnID'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SpreadsheetColumnID(bpy_struct):
    ''' Data used to identify a spreadsheet column
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class SpreadsheetRowFilter(bpy_struct):
    column_name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    enabled: bool = None
    ''' 

    :type: bool
    '''

    operation: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    show_expanded: bool = None
    ''' 

    :type: bool
    '''

    threshold: float = None
    ''' How close float values need to be to be equal

    :type: float
    '''

    value_boolean: bool = None
    ''' 

    :type: bool
    '''

    value_color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    value_float: float = None
    ''' 

    :type: float
    '''

    value_float2: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    value_float3: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    value_int: int = None
    ''' 

    :type: int
    '''

    value_int2: bpy_prop_array[int] = None
    ''' 

    :type: bpy_prop_array[int]
    '''

    value_int8: int = None
    ''' 

    :type: int
    '''

    value_string: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Stereo3dDisplay(bpy_struct):
    ''' Settings for stereo 3D display
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice versa

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Stereo3dFormat(bpy_struct):
    ''' Settings for stereo output
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' * ``ANAGLYPH`` Anaglyph -- Render views for left and right eyes as two differently filtered colors in a single image (anaglyph glasses are required). * ``INTERLACE`` Interlace -- Render views for left and right eyes interlaced in a single image (3D-ready monitor is required). * ``SIDEBYSIDE`` Side-by-Side -- Render views for left and right eyes side-by-side. * ``TOPBOTTOM`` Top-Bottom -- Render views for left and right eyes one above another.

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice versa

    :type: bool
    '''

    use_squeezed_frame: bool = None
    ''' Combine both views in a squeezed image

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class StringAttributeValue(bpy_struct):
    ''' String value in geometry attribute
    '''

    value: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Struct(bpy_struct):
    ''' RNA structure definition
    '''

    base: 'Struct' = None
    ''' Struct definition this is derived from

    :type: 'Struct'
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the Struct's purpose

    :type: typing.Union[str, typing.Any]
    '''

    functions: bpy_prop_collection['Function'] = None
    ''' 

    :type: bpy_prop_collection['Function']
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    name_property: 'StringProperty' = None
    ''' Property that gives the name of the struct

    :type: 'StringProperty'
    '''

    nested: 'Struct' = None
    ''' Struct in which this struct is always nested, and to which it logically belongs

    :type: 'Struct'
    '''

    properties: bpy_prop_collection['Property'] = None
    ''' Properties in the struct

    :type: bpy_prop_collection['Property']
    '''

    property_tags: bpy_prop_collection['EnumPropertyItem'] = None
    ''' Tags that properties can use to influence behavior

    :type: bpy_prop_collection['EnumPropertyItem']
    '''

    translation_context: typing.Union[str, typing.Any] = None
    ''' Translation context of the struct's name

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class StudioLight(bpy_struct):
    ''' Studio light
    '''

    has_specular_highlight_pass: typing.Union[bool, typing.Any] = None
    ''' Studio light image file has separate "diffuse" and "specular" passes

    :type: typing.Union[bool, typing.Any]
    '''

    index: int = None
    ''' 

    :type: int
    '''

    is_user_defined: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    light_ambient: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Color of the ambient light that uniformly lit the scene

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    path: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    path_irr_cache: typing.Union[str, typing.Any] = None
    ''' Path where the irradiance cache is stored

    :type: typing.Union[str, typing.Any]
    '''

    path_sh_cache: typing.Union[str, typing.Any] = None
    ''' Path where the spherical harmonics cache is stored

    :type: typing.Union[str, typing.Any]
    '''

    solid_lights: bpy_prop_collection['UserSolidLight'] = None
    ''' Lights user to display objects in solid draw mode

    :type: bpy_prop_collection['UserSolidLight']
    '''

    spherical_harmonics_coefficients: typing.Union[
        typing.List[typing.List[float]], typing.
        Tuple[typing.Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float], typing.
              Tuple[float, float, float, float]]] = None
    ''' 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TexMapping(bpy_struct):
    ''' Texture coordinate mapping settings
    '''

    mapping: typing.Union[str, int] = None
    ''' * ``FLAT`` Flat -- Map X and Y coordinates directly. * ``CUBE`` Cube -- Map using the normal vector. * ``TUBE`` Tube -- Map with Z as central axis. * ``SPHERE`` Sphere -- Map with Z as central axis.

    :type: typing.Union[str, int]
    '''

    mapping_x: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_y: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_z: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    max: typing.Union[typing.List[float], typing.
                      Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Maximum value for clipping

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    min: typing.Union[typing.List[float], typing.
                      Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Minimum value for clipping

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    rotation: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Euler'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Euler']
    '''

    scale: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    translation: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Vector'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    use_max: bool = None
    ''' Whether to use maximum clipping value

    :type: bool
    '''

    use_min: bool = None
    ''' Whether to use minimum clipping value

    :type: bool
    '''

    vector_type: typing.Union[str, int] = None
    ''' Type of vector that the mapping transforms

    :type: typing.Union[str, int]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TexPaintSlot(bpy_struct):
    ''' Slot that contains information about texture painting
    '''

    icon_value: int = None
    ''' Paint slot icon

    :type: int
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Slot has a valid image and UV map

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the slot

    :type: typing.Union[str, typing.Any]
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TextBox(bpy_struct):
    ''' Text bounding box for layout
    '''

    height: float = None
    ''' 

    :type: float
    '''

    width: float = None
    ''' 

    :type: float
    '''

    x: float = None
    ''' 

    :type: float
    '''

    y: float = None
    ''' 

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TextCharacterFormat(bpy_struct):
    ''' Text character formatting settings
    '''

    kerning: float = None
    ''' Spacing between characters

    :type: float
    '''

    material_index: int = None
    ''' Material slot index of this character

    :type: int
    '''

    use_bold: bool = None
    ''' 

    :type: bool
    '''

    use_italic: bool = None
    ''' 

    :type: bool
    '''

    use_small_caps: bool = None
    ''' 

    :type: bool
    '''

    use_underline: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TextLine(bpy_struct):
    ''' Line of text in a Text data-block
    '''

    body: typing.Union[str, typing.Any] = None
    ''' Text in the line

    :type: typing.Union[str, typing.Any]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class TextureSlot(bpy_struct):
    ''' Texture slot defining the mapping and influence of a texture
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to apply the texture

    :type: typing.Union[str, int]
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Default color for textures that don't return RGB or when RGB to intensity is enabled

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    default_value: float = None
    ''' Value to use for Ref, Spec, Amb, Emit, Alpha, RayMir, TransLu and Hard

    :type: float
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Texture slot name

    :type: typing.Union[str, typing.Any]
    '''

    offset: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Fine tune of the texture mapping X, Y and Z locations

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    output_node: typing.Union[str, int] = None
    ''' Which output node to use, for node-based textures

    :type: typing.Union[str, int]
    '''

    scale: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Vector'] = None
    ''' Set scaling for the texture's X, Y and Z sizes

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Vector']
    '''

    texture: 'Texture' = None
    ''' Texture data-block used by this texture slot

    :type: 'Texture'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class Theme(bpy_struct):
    ''' User interface styling and color settings
    '''

    bone_color_sets: bpy_prop_collection['ThemeBoneColorSet'] = None
    ''' 

    :type: bpy_prop_collection['ThemeBoneColorSet']
    '''

    clip_editor: 'ThemeClipEditor' = None
    ''' 

    :type: 'ThemeClipEditor'
    '''

    collection_color: bpy_prop_collection['ThemeCollectionColor'] = None
    ''' 

    :type: bpy_prop_collection['ThemeCollectionColor']
    '''

    console: 'ThemeConsole' = None
    ''' 

    :type: 'ThemeConsole'
    '''

    dopesheet_editor: 'ThemeDopeSheet' = None
    ''' 

    :type: 'ThemeDopeSheet'
    '''

    file_browser: 'ThemeFileBrowser' = None
    ''' 

    :type: 'ThemeFileBrowser'
    '''

    graph_editor: 'ThemeGraphEditor' = None
    ''' 

    :type: 'ThemeGraphEditor'
    '''

    image_editor: 'ThemeImageEditor' = None
    ''' 

    :type: 'ThemeImageEditor'
    '''

    info: 'ThemeInfo' = None
    ''' 

    :type: 'ThemeInfo'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the theme

    :type: typing.Union[str, typing.Any]
    '''

    nla_editor: 'ThemeNLAEditor' = None
    ''' 

    :type: 'ThemeNLAEditor'
    '''

    node_editor: 'ThemeNodeEditor' = None
    ''' 

    :type: 'ThemeNodeEditor'
    '''

    outliner: 'ThemeOutliner' = None
    ''' 

    :type: 'ThemeOutliner'
    '''

    preferences: 'ThemePreferences' = None
    ''' 

    :type: 'ThemePreferences'
    '''

    properties: 'ThemeProperties' = None
    ''' 

    :type: 'ThemeProperties'
    '''

    sequence_editor: 'ThemeSequenceEditor' = None
    ''' 

    :type: 'ThemeSequenceEditor'
    '''

    spreadsheet: 'ThemeSpreadsheet' = None
    ''' 

    :type: 'ThemeSpreadsheet'
    '''

    statusbar: 'ThemeStatusBar' = None
    ''' 

    :type: 'ThemeStatusBar'
    '''

    strip_color: bpy_prop_collection['ThemeStripColor'] = None
    ''' 

    :type: bpy_prop_collection['ThemeStripColor']
    '''

    text_editor: 'ThemeTextEditor' = None
    ''' 

    :type: 'ThemeTextEditor'
    '''

    theme_area: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    topbar: 'ThemeTopBar' = None
    ''' 

    :type: 'ThemeTopBar'
    '''

    user_interface: 'ThemeUserInterface' = None
    ''' 

    :type: 'ThemeUserInterface'
    '''

    view_3d: 'ThemeView3D' = None
    ''' 

    :type: 'ThemeView3D'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeAssetShelf(bpy_struct):
    ''' Theme settings for asset shelves
    '''

    back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeBoneColorSet(bpy_struct):
    ''' Theme settings for bone color sets
    '''

    active: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color used for active bones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    normal: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color used for the surface of bones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    select: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color used for selected bones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    show_colored_constraints: bool = None
    ''' Allow the use of colors indicating constraints/keyed status

    :type: bool
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeClipEditor(bpy_struct):
    ''' Theme settings for the Movie Clip Editor
    '''

    active_marker: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Color of active marker

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    disabled_marker: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Color of disabled marker

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_align: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto_clamped: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_free: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_align: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto_clamped: typing.Union[typing.List[float], typing.
                                          Tuple[float, float, float],
                                          'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_free: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_select: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    locked_marker: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Color of locked marker

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    marker: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color of marker

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    marker_outline: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' Color of marker's outline

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    metadatabg: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    metadatatext: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    path_after: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' Color of path after current frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    path_before: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Color of path before current frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    path_keyframe_after: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' Color of path after current frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    path_keyframe_before: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' Color of path before current frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    selected_marker: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Color of selected marker

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    strips_selected: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    time_marker_line: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_marker_line_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_scrub_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeCollectionColor(bpy_struct):
    ''' Theme settings for collection colors
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Collection Color Tag

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeConsole(bpy_struct):
    ''' Theme settings for the Console
    '''

    cursor: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    line_error: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    line_info: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    line_input: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    line_output: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeDopeSheet(bpy_struct):
    ''' Theme settings for the Dope Sheet
    '''

    active_channels_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channel_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channels: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channels_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_channel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_subchannel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    interpolation_line: bpy_prop_array[float] = None
    ''' Color of lines showing non-bezier interpolation modes

    :type: bpy_prop_array[float]
    '''

    keyframe: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Color'] = None
    ''' Color of Keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_border: bpy_prop_array[float] = None
    ''' Color of keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_border_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_breakdown: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' Color of breakdown keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_breakdown_selected: typing.Union[typing.List[float], typing.
                                              Tuple[float, float, float],
                                              'mathutils.Color'] = None
    ''' Color of selected breakdown keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_extreme: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Color'] = None
    ''' Color of extreme keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_extreme_selected: typing.Union[typing.List[float], typing.
                                            Tuple[float, float, float],
                                            'mathutils.Color'] = None
    ''' Color of selected extreme keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_jitter: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Color of jitter keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_jitter_selected: typing.Union[typing.List[float], typing.
                                           Tuple[float, float, float],
                                           'mathutils.Color'] = None
    ''' Color of selected jitter keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_movehold: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Color of moving hold keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_movehold_selected: typing.Union[typing.List[float], typing.
                                             Tuple[float, float, float],
                                             'mathutils.Color'] = None
    ''' Color of selected moving hold keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_scale_factor: float = None
    ''' Scale factor for adjusting the height of keyframes

    :type: float
    '''

    keyframe_selected: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Color of selected keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    long_key: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    long_key_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_range: bpy_prop_array[float] = None
    ''' Color of preview range overlay

    :type: bpy_prop_array[float]
    '''

    simulated_frames: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    summary: bpy_prop_array[float] = None
    ''' Color of summary channel

    :type: bpy_prop_array[float]
    '''

    time_marker_line: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_marker_line_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_scrub_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    value_sliders: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    view_sliders: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeFileBrowser(bpy_struct):
    ''' Theme settings for the File Browser
    '''

    row_alternate: bpy_prop_array[float] = None
    ''' Overlay color on every other row

    :type: bpy_prop_array[float]
    '''

    selected_file: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeFontStyle(bpy_struct):
    ''' Theme settings for Font
    '''

    points: float = None
    ''' Font size in points

    :type: float
    '''

    shadow: int = None
    ''' Shadow size (0, 3 and 5 supported)

    :type: int
    '''

    shadow_alpha: float = None
    ''' 

    :type: float
    '''

    shadow_offset_x: int = None
    ''' Shadow offset in pixels

    :type: int
    '''

    shadow_offset_y: int = None
    ''' Shadow offset in pixels

    :type: int
    '''

    shadow_value: float = None
    ''' Shadow color in gray value

    :type: float
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeGradientColors(bpy_struct):
    ''' Theme settings for background colors and gradient
    '''

    background_type: typing.Union[str, int] = None
    ''' Type of background in the 3D viewport * ``SINGLE_COLOR`` Single Color -- Use a solid color as viewport background. * ``LINEAR`` Linear Gradient -- Use a screen space vertical linear gradient as viewport background. * ``RADIAL`` Vignette -- Use a radial gradient as viewport background.

    :type: typing.Union[str, int]
    '''

    gradient: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    high_gradient: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeGraphEditor(bpy_struct):
    ''' Theme settings for the graph editor
    '''

    active_channels_group: typing.Union[typing.List[float], typing.
                                        Tuple[float, float, float],
                                        'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    channel_group: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    channels_region: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    dopesheet_channel: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    dopesheet_subchannel: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_align: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto_clamped: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_free: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_align: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto_clamped: typing.Union[typing.List[float], typing.
                                          Tuple[float, float, float],
                                          'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_free: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_vect: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vect: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_select: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    lastsel_point: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    preview_range: bpy_prop_array[float] = None
    ''' Color of preview range overlay

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    time_marker_line: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_marker_line_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_scrub_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_active: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_bevel: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_select: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_size: int = None
    ''' 

    :type: int
    '''

    vertex_unreferenced: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    window_sliders: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeImageEditor(bpy_struct):
    ''' Theme settings for the Image Editor
    '''

    edge_select: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    edge_width: int = None
    ''' 

    :type: int
    '''

    editmesh_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_dot: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    face_front: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_retopology: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    facedot_size: int = None
    ''' 

    :type: int
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    freestyle_face_mark: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_align: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_auto_clamped: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_free: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_align: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_auto_clamped: typing.Union[typing.List[float], typing.
                                          Tuple[float, float, float],
                                          'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_sel_free: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_select: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    metadatabg: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    metadatatext: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    paint_curve_handle: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    paint_curve_pivot: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_edge: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_face: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_stitchable: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_unstitchable: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_vert: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    scope_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    uv_shadow: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_active: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_bevel: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_select: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vertex_size: int = None
    ''' 

    :type: int
    '''

    vertex_unreferenced: typing.Union[typing.List[float], typing.
                                      Tuple[float, float, float],
                                      'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    wire_edit: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeInfo(bpy_struct):
    ''' Theme settings for Info
    '''

    info_debug: bpy_prop_array[float] = None
    ''' Background color of Debug icon

    :type: bpy_prop_array[float]
    '''

    info_debug_text: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Foreground color of Debug icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_error: bpy_prop_array[float] = None
    ''' Background color of Error icon

    :type: bpy_prop_array[float]
    '''

    info_error_text: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Foreground color of Error icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_info: bpy_prop_array[float] = None
    ''' Background color of Info icon

    :type: bpy_prop_array[float]
    '''

    info_info_text: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' Foreground color of Info icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_operator: bpy_prop_array[float] = None
    ''' Background color of Operator icon

    :type: bpy_prop_array[float]
    '''

    info_operator_text: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' Foreground color of Operator icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_property: bpy_prop_array[float] = None
    ''' Background color of Property icon

    :type: bpy_prop_array[float]
    '''

    info_property_text: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' Foreground color of Property icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_selected: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' Background color of selected line

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_selected_text: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' Text color of selected line

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    info_warning: bpy_prop_array[float] = None
    ''' Background color of Warning icon

    :type: bpy_prop_array[float]
    '''

    info_warning_text: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Foreground color of Warning icon

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeNLAEditor(bpy_struct):
    ''' Theme settings for the NLA Editor
    '''

    active_action: bpy_prop_array[float] = None
    ''' Animation data-block has active action

    :type: bpy_prop_array[float]
    '''

    active_action_unset: bpy_prop_array[float] = None
    ''' Animation data-block doesn't have active action

    :type: bpy_prop_array[float]
    '''

    dopesheet_channel: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Nonlinear Animation Channel

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    dopesheet_subchannel: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_border: bpy_prop_array[float] = None
    ''' Color of keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_border_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe border

    :type: bpy_prop_array[float]
    '''

    meta_strips: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' Unselected Meta Strip (for grouping related strips)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    meta_strips_selected: typing.Union[typing.List[float], typing.
                                       Tuple[float, float, float],
                                       'mathutils.Color'] = None
    ''' Selected Meta Strip (for grouping related strips)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    nla_track: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Color'] = None
    ''' Nonlinear Animation Track

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    preview_range: bpy_prop_array[float] = None
    ''' Color of preview range overlay

    :type: bpy_prop_array[float]
    '''

    sound_strips: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' Unselected Sound Strip (for timing speaker sounds)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    sound_strips_selected: typing.Union[typing.List[float], typing.
                                        Tuple[float, float, float],
                                        'mathutils.Color'] = None
    ''' Selected Sound Strip (for timing speaker sounds)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Unselected Action-Clip Strip

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    strips_selected: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Selected Action-Clip Strip

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    time_marker_line: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_marker_line_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_scrub_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    transition_strips: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Unselected Transition Strip

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    transition_strips_selected: typing.Union[typing.List[float], typing.
                                             Tuple[float, float, float],
                                             'mathutils.Color'] = None
    ''' Selected Transition Strip

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tweak: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Color for strip/action being "tweaked" or edited

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tweak_duplicate: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' Warning/error indicator color for strips referencing the strip being tweaked

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    view_sliders: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeNodeEditor(bpy_struct):
    ''' Theme settings for the Node Editor
    '''

    attribute_node: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    color_node: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    converter_node: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    dash_alpha: float = None
    ''' Opacity for the dashed lines in wires

    :type: float
    '''

    distor_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    filter_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    geometry_node: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid_levels: int = None
    ''' Number of subdivisions for the dot grid displayed in the background

    :type: int
    '''

    group_node: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    group_socket_node: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    input_node: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    layout_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    matte_node: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    node_active: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    node_backdrop: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    node_selected: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    noodle_curving: int = None
    ''' Curving of the noodle

    :type: int
    '''

    output_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    pattern_node: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    repeat_zone: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    script_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    selected_text: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    shader_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    simulation_zone: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    texture_node: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    vector_node: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    wire: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire_inner: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    wire_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeOutliner(bpy_struct):
    ''' Theme settings for the Outliner
    '''

    active: typing.Union[typing.List[float], typing.
                         Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    active_object: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    edited_object: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    match: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    row_alternate: bpy_prop_array[float] = None
    ''' Overlay color on every other row

    :type: bpy_prop_array[float]
    '''

    selected_highlight: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    selected_object: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemePanelColors(bpy_struct):
    ''' Theme settings for panel colors
    '''

    back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    sub_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemePreferences(bpy_struct):
    ''' Theme settings for the Blender Preferences
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeProperties(bpy_struct):
    ''' Theme settings for the Properties
    '''

    active_modifier: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    match: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeSequenceEditor(bpy_struct):
    ''' Theme settings for the Sequence Editor
    '''

    active_strip: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    audio_strip: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    color_strip: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    draw_action: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    effect_strip: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    frame_current: typing.Union[typing.List[float], typing.
                                Tuple[float, float, float],
                                'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    grid: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    image_strip: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe: typing.Union[typing.List[float], typing.
                           Tuple[float, float, float],
                           'mathutils.Color'] = None
    ''' Color of Keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_border: bpy_prop_array[float] = None
    ''' Color of keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_border_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_breakdown: typing.Union[typing.List[float], typing.
                                     Tuple[float, float, float],
                                     'mathutils.Color'] = None
    ''' Color of breakdown keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_breakdown_selected: typing.Union[typing.List[float], typing.
                                              Tuple[float, float, float],
                                              'mathutils.Color'] = None
    ''' Color of selected breakdown keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_movehold: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Color of moving hold keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_movehold_selected: typing.Union[typing.List[float], typing.
                                             Tuple[float, float, float],
                                             'mathutils.Color'] = None
    ''' Color of selected moving hold keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    keyframe_selected: typing.Union[typing.List[float], typing.
                                    Tuple[float, float, float],
                                    'mathutils.Color'] = None
    ''' Color of selected keyframe

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    mask_strip: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    meta_strip: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    metadatabg: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    metadatatext: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    movie_strip: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    movieclip_strip: typing.Union[typing.List[float], typing.
                                  Tuple[float, float, float],
                                  'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    preview_back: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    preview_range: bpy_prop_array[float] = None
    ''' Color of preview range overlay

    :type: bpy_prop_array[float]
    '''

    row_alternate: bpy_prop_array[float] = None
    ''' Overlay color on every other row

    :type: bpy_prop_array[float]
    '''

    scene_strip: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    selected_strip: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    text_strip: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    time_marker_line: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_marker_line_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    time_scrub_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    transition_strip: typing.Union[typing.List[float], typing.
                                   Tuple[float, float, float],
                                   'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    window_sliders: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeSpaceGeneric(bpy_struct):
    back: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    button: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    button_text_hi: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    button_title: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    execution_buts: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    header_text_hi: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    navigation_bar: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    ''' 

    :type: 'ThemePanelColors'
    '''

    tab_active: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tab_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_inactive: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tab_outline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    text_hi: typing.Union[typing.List[float], typing.
                          Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    title: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeSpaceGradient(bpy_struct):
    button: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    button_text_hi: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    button_title: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    execution_buts: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gradients: 'ThemeGradientColors' = None
    ''' 

    :type: 'ThemeGradientColors'
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text: typing.Union[typing.List[float], typing.
                              Tuple[float, float, float],
                              'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    header_text_hi: typing.Union[typing.List[float], typing.
                                 Tuple[float, float, float],
                                 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    navigation_bar: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    ''' 

    :type: 'ThemePanelColors'
    '''

    tab_active: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tab_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_inactive: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    tab_outline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    text_hi: typing.Union[typing.List[float], typing.
                          Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    title: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeSpaceListGeneric(bpy_struct):
    list: typing.Union[typing.List[float], typing.
                       Tuple[float, float, float], 'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    list_text: typing.Union[typing.List[float], typing.
                            Tuple[float, float, float],
                            'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    list_text_hi: typing.Union[typing.List[float], typing.
                               Tuple[float, float, float],
                               'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    list_title: typing.Union[typing.List[float], typing.
                             Tuple[float, float, float],
                             'mathutils.Color'] = None
    ''' 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeSpreadsheet(bpy_struct):
    ''' Theme settings for the Spreadsheet
    '''

    row_alternate: bpy_prop_array[float] = None
    ''' Overlay color on every other row

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeStatusBar(bpy_struct):
    ''' Theme settings for the Status Bar
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeStripColor(bpy_struct):
    ''' Theme settings for strip colors
    '''

    color: typing.Union[typing.List[float], typing.
                        Tuple[float, float, float], 'mathutils.Color'] = None
    ''' Strip Color

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], 'mathutils.Color']
    '''

    @classmethod
    def bl_rna_get_subclass(cls, id: typing.Optional[str],
                            default=None) -> 'Struct':
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        '''
        pass

    @classmethod
    def bl_rna_get_subclass_py(cls, id: typing.Optional[str],
                               default=None) -> typing.Any:
        ''' 

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :rtype: typing.Any
        :return: The class or default when not found.
        '''
        pass


class ThemeStyle(bpy_struct):
    ''' Theme settings for style sets
    '''

    panel_title: 'ThemeFontStyle' = None
    ''' 

    :type: 'ThemeFontStyle'
    '''

    widget: 'ThemeFontStyle' = None
    ''' 

    :type: 'ThemeFontStyle'
    '''

    widget_label: 'ThemeFontStyle' = None
    ''' 

    :type: '