from elliottlib import brew, constants, errata, Runtime
from elliottlib.cli.common import cli

import click
import json
import koji
import requests
import textwrap
pass_runtime = click.make_pass_decorator(Runtime)


@cli.command("validate-rhsa", short_help="Validate RHSA with Product Security checks")
@click.argument('advisory', type=int)
@pass_runtime
def validate_rhsa_cli(runtime, advisory):
    """
    Validates an RHSA by returning the 'alerts' generated by Product Security's central SFM2 server.

    Usage:
\b
    $ elliott validate-rhsa ID
"""
    session = requests.Session()
    url = constants.SFM2_ERRATA_ALERTS_URL.format(id=advisory)
    print(url)
    print("Validating..")
    print()
    resp = session.get(url)

    # Will fail if id invalid, not an RHSA or RHSA has embargoed data
    if resp.status_code != 200:
        print(f"HTTP {resp.status_code}: Could not validate rhsa {advisory} (is it an RHSA? without embargo?)")
        exit(1)
        return
    alerts = resp.json()

    if alerts:
        for a in alerts:
            print("E: {text}".format(text=a.get("text")))
            howto = a.get("how_to_resolve")
            if howto:
                print(textwrap.indent(howto, "  > "))
            print()
        exit(2)
    else:
        print("No issues found")
