"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class CfnInclude extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param template The template to adopt.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.CfnInclude = CfnInclude;
//# sourceMappingURL=data:application/json;base64,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