"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RemovalPolicy;
(function (RemovalPolicy) {
    /**
     * This is the default removal policy. It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    RemovalPolicy["DESTROY"] = "destroy";
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained
     * in the account, but orphaned from the stack.
     */
    RemovalPolicy["RETAIN"] = "retain";
})(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVtb3ZhbC1wb2xpY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZW1vdmFsLXBvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLElBQVksYUFZWDtBQVpELFdBQVksYUFBYTtJQUN2Qjs7O09BR0c7SUFDSCxvQ0FBbUIsQ0FBQTtJQUVuQjs7O09BR0c7SUFDSCxrQ0FBaUIsQ0FBQTtBQUNuQixDQUFDLEVBWlcsYUFBYSxHQUFiLHFCQUFhLEtBQWIscUJBQWEsUUFZeEIiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZW51bSBSZW1vdmFsUG9saWN5IHtcbiAgLyoqXG4gICAqIFRoaXMgaXMgdGhlIGRlZmF1bHQgcmVtb3ZhbCBwb2xpY3kuIEl0IG1lYW5zIHRoYXQgd2hlbiB0aGUgcmVzb3VyY2UgaXNcbiAgICogcmVtb3ZlZCBmcm9tIHRoZSBhcHAsIGl0IHdpbGwgYmUgcGh5c2ljYWxseSBkZXN0cm95ZWQuXG4gICAqL1xuICBERVNUUk9ZID0gJ2Rlc3Ryb3knLFxuXG4gIC8qKlxuICAgKiBUaGlzIHVzZXMgdGhlICdSZXRhaW4nIERlbGV0aW9uUG9saWN5LCB3aGljaCB3aWxsIGNhdXNlIHRoZSByZXNvdXJjZSB0byBiZSByZXRhaW5lZFxuICAgKiBpbiB0aGUgYWNjb3VudCwgYnV0IG9ycGhhbmVkIGZyb20gdGhlIHN0YWNrLlxuICAgKi9cbiAgUkVUQUlOID0gJ3JldGFpbicsXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVtb3ZhbFBvbGljeU9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGRlZmF1bHQgcG9saWN5IHRvIGFwcGx5IGluIGNhc2UgdGhlIHJlbW92YWwgcG9saWN5IGlzIG5vdCBkZWZpbmVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBSZW1vdmFsUG9saWN5LlJldGFpblxuICAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdD86IFJlbW92YWxQb2xpY3k7XG5cbiAgLyoqXG4gICAqIEFwcGx5IHRoZSBzYW1lIGRlbGV0aW9uIHBvbGljeSB0byB0aGUgcmVzb3VyY2UncyBcIlVwZGF0ZVJlcGxhY2VQb2xpY3lcIlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBhcHBseVRvVXBkYXRlUmVwbGFjZVBvbGljeT86IGJvb2xlYW47XG59XG4iXX0=