from pokete.classes.asset_service.resources import MapTrainersDict

trainers: dict[str, MapTrainersDict] = {
    "cave_1": {
        "trainers": [
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Hahaha!", "Looooser!"],
                    "name": "Monica",
                    "texts": ["Hello, noble traveler",
                              "Are you willing to fight me?"],
                    "win_texts": ["Congratulations!", "Have a great day!"],
                    "x": 23,
                    "y": 10,
                },
                "pokes": [{"name": "hornita", "xp": 128}],
            }
        ]
    },
    "playmap_1": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": [
                        "That was already quite " "good!",
                        "You'll be better next " "time!",
                    ],
                    "name": "Franz",
                    "texts": [
                        "Hey there",
                        "I guess you're a quite new " "Pokete trainer",
                        "So let's have a fight",
                    ],
                    "win_texts": ["You're already a very " "good trainer!"],
                    "x": 30,
                    "y": 10,
                },
                "pokes": [{"name": "vogli", "xp": 40}],
            }
        ]
    },
    "playmap_11": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Those years of training " "were worth it"],
                    "name": "Fisherman's Friend",
                    "texts": ["G'day, young trainer",
                              "I've lived here for years"],
                    "win_texts": ["I haven't trained my " "Pokete in years!"],
                    "x": 42,
                    "y": 7,
                },
                "pokes": [{"name": "clampi", "xp": 450}],
            }
        ]
    },
    "playmap_12": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Brother Justin",
                    "texts": ["Hey, my brother and I want " "to fight!"],
                    "win_texts": ["Damn!"],
                    "x": 26,
                    "y": 10,
                },
                "pokes": [{"name": "blub", "xp": 600}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Brother Justus",
                    "texts": ["Now it's my turn!"],
                    "win_texts": ["Damn!"],
                    "x": 27,
                    "y": 10,
                },
                "pokes": [{"name": "poundi", "xp": 600}],
            },
        ]
    },
    "playmap_13": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Citizen",
                    "texts": [
                        "Hello, fellow stranger!",
                        "This town is known for its " "bird Poketes",
                    ],
                    "win_texts": ["Damn!"],
                    "x": 5,
                    "y": 31,
                },
                "pokes": [{"name": "vogli", "xp": 600}],
            }
        ]
    },
    "playmap_14": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "First Trainer",
                    "texts": [
                        "Welcome to the Deepest " "Forest Pokete Arena",
                        "I'm your first enemy!",
                    ],
                    "win_texts": ["Good luck!"],
                    "x": 17,
                    "y": 10,
                },
                "pokes": [{"name": "owol", "xp": 650}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Second Trainer",
                    "texts": ["Now it's my turn!"],
                    "win_texts": ["Good luck with the next " "trainer!"],
                    "x": 22,
                    "y": 10,
                },
                "pokes": [{"name": "voglo", "xp": 700}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Third Trainer",
                    "texts": ["Let's see what other Poketes " "you have!"],
                    "win_texts": ["Good luck with the last " "trainer!"],
                    "x": 22,
                    "y": 5,
                },
                "pokes": [{"name": "treenator", "xp": 750}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Last Trainer",
                    "texts": ["I'm your last enemy!"],
                    "win_texts": [
                        "Oh!",
                        "You were able to defeat " "me?",
                        "You can now leave " "Deepest Forest",
                    ],
                    "x": 17,
                    "y": 5,
                },
                "pokes": [{"name": "ostri", "xp": 780}],
            },
        ]
    },
    "playmap_15": {
        "trainers": [
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You see, it's " "effective"],
                    "name": "Samantha",
                    "texts": [
                        "Hey, you!",
                        "My Pokete is very effective " "against bird Poketes",
                    ],
                    "win_texts": [
                        "Oh no",
                        "I guess yours is even " "more effective than " "mine!",
                    ],
                    "x": 43,
                    "y": 17,
                },
                "pokes": [{"name": "clampi", "xp": 650}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Haha, you're a loser!"],
                    "name": "Jessica",
                    "texts": ["Hey you!"],
                    "win_texts": ["Oh no"],
                    "x": 31,
                    "y": 6,
                },
                "pokes": [{"name": "angrilo", "xp": 650}],
            },
        ]
    },
    "playmap_18": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Haha, you're bad!"],
                    "name": "Bert",
                    "texts": [
                        "Hey!",
                        "This region is full of stone " "and ground Poketes",
                    ],
                    "win_texts": ["Oh, I lost!"],
                    "x": 6,
                    "y": 4,
                },
                "pokes": [{"name": "poundi", "xp": 700}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Go home, little " "zoomer."],
                    "name": "Karen",
                    "texts": [
                        "I don't think you can walk " "here",
                        "I demand a fight with you!",
                    ],
                    "win_texts": ["I want to talk to your " "manager!"],
                    "x": 56,
                    "y": 11,
                },
                "pokes": [{"name": "clampi", "xp": 700}],
            },
        ]
    },
    "playmap_19": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Oooooh!", "You're a loooser!"],
                    "name": "Brian",
                    "texts": ["Hello fellow cave diver!"],
                    "win_texts": ["Oh!", "You were lucky!"],
                    "x": 16,
                    "y": 15,
                },
                "pokes": [{"name": "choka", "xp": 850}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Simon",
                    "texts": ["Yoooo!", "What's up?"],
                    "win_texts": ["Duck!"],
                    "x": 15,
                    "y": 7,
                },
                "pokes": [{"name": "wolfiro", "xp": 850}],
            },
        ]
    },
    "playmap_2": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": [
                        "It is stronger than you " "might have expected"],
                    "name": "Wanderer Murrad",
                    "texts": [
                        "Isn't it a great day?",
                        "I traveled here from a " "distant country",
                        "Do you want to fight against " "my rare Pokete?",
                    ],
                    "win_texts": [
                        "Oh, I didn't think you " "could defeat my Pokete!",
                        "You are a very good " "trainer!",
                    ],
                    "x": 32,
                    "y": 12,
                },
                "pokes": [{"name": "ostri", "xp": 160}],
            }
        ]
    },
    "playmap_21": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": [
                        "If I'm a problem for "
                        "you, you might not be "
                        "able to fight the other "
                        "trainers."
                    ],
                    "name": "Rock-hard Rick",
                    "texts": [
                        "Hello trainer!",
                        "Welcome to Rock-ville, the "
                        "highest place in the Pokete "
                        "world and home of all stone "
                        "Poketes.",
                        "When leaving this town "
                        "through the 'Cave of Doom' "
                        "you have to fight against "
                        "the best trainers of this "
                        "town.",
                        "But first, you have to fight " "me!",
                    ],
                    "win_texts": [
                        "Oh",
                        "I guess you will be a " "challenge for our " "trainers!",
                    ],
                    "x": 12,
                    "y": 23,
                },
                "pokes": [{"name": "bigstone", "xp": 900}],
            }
        ]
    },
    "playmap_27": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Bertold",
                    "texts": ["We are the elite of " "Rock-ville!"],
                    "win_texts": ["You were lucky!"],
                    "x": 6,
                    "y": 6,
                },
                "pokes": [{"name": "bigstone", "xp": 900}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Gerard",
                    "texts": ["My Steini will rip out your " "Pokete's heart!"],
                    "win_texts": ["The other trainers wont " "be as easy!"],
                    "x": 11,
                    "y": 10,
                },
                "pokes": [{"name": "steini", "xp": 900}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Jessica the fighter",
                    "texts": ["You wont be ready for my " "Treenator!"],
                    "win_texts": [
                        "Our best trainer will " "defeat you though!"],
                    "x": 16,
                    "y": 6,
                },
                "pokes": [
                    {"name": "treenator", "xp": 950},
                    {"name": "lilstone", "xp": 950},
                ],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "First Trainer of Rock-ville",
                    "texts": ["Let's have a fair fight!"],
                    "win_texts": [
                        "I wish you the best luck " "on your journey!"],
                    "x": 22,
                    "y": 10,
                },
                "pokes": [
                    {"name": "poundi", "xp": 1000},
                    {"name": "steini", "xp": 1000},
                    {"name": "diamondos", "xp": 1000},
                ],
            },
        ]
    },
    "playmap_28": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Steven the Big",
                    "texts": ["I don't think you ever met " "an Electrode!"],
                    "win_texts": ["Hmph!",
                                  "It's not as great as I " "thought!"],
                    "x": 36,
                    "y": 47,
                },
                "pokes": [{"name": "electrode", "xp": 950}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Laurena",
                    "texts": [
                        "I trained my Steini for " "years to get to this level",
                        "I will win!",
                    ],
                    "win_texts": ["Ohhh nooo!", "NOT MY STEINI!!!1!!1"],
                    "x": 114,
                    "y": 37,
                },
                "pokes": [{"name": "steini", "xp": 850}],
            },
            {
                "args": {
                    "gender": "They",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Laurin",
                    "texts": [
                        "Poisopla is one of the " "strongest local Poketes!",
                        "And it will kill your lame " "Pokete!",
                    ],
                    "win_texts": ["It won't be as easy in " "'Flowy Town'!"],
                    "x": 141,
                    "y": 23,
                },
                "pokes": [{"name": "poisopla", "xp": 950}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Fucking badass looking dude in " "the woods",
                    "texts": [
                        "You have to beat my Pokete " "to enter 'Flowy Town'",
                        "I guess it'll confuse you!",
                    ],
                    "win_texts": [
                        "I wish you the best of " "luck in 'Flowy Town'!"],
                    "x": 190,
                    "y": 8,
                },
                "pokes": [{"name": "confuso", "xp": 900}],
            },
        ]
    },
    "playmap_3": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Hahaha!", "Hahaha!", "You're a loser!"],
                    "name": "Markus",
                    "texts": [
                        "Hey!",
                        "Welcome to Sunnydale!",
                        "But first, we must fight!",
                    ],
                    "win_texts": ["Damn, I lost!"],
                    "x": 11,
                    "y": 5,
                },
                "pokes": [{"name": "hornita", "xp": 200}],
            }
        ]
    },
    "playmap_30": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Guy at the Entrance",
                    "texts": [
                        "Welcome to 'Flowy Town', " "home of the flowers."],
                    "win_texts": [
                        "I wish you the best of "
                        "luck fighting against "
                        "our best trainers!"
                    ],
                    "x": 5,
                    "y": 18,
                },
                "pokes": [{"name": "poisopla", "xp": 950}],
            }
        ]
    },
    "playmap_31": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Luther",
                    "texts": ["Welcome to the 'Flowy Town' " "Arena!"],
                    "win_texts": ["You were lucky!"],
                    "x": 22,
                    "y": 10,
                },
                "pokes": [{"name": "diamondos", "xp": 1000}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Your journey came to a " "fast end!"],
                    "name": "Heavy Hans",
                    "texts": [
                        "I don't think your Pokete is " "better than mine!"],
                    "win_texts": ["The other trainers wont " "be as easy!"],
                    "x": 25,
                    "y": 8,
                },
                "pokes": [{"name": "poisopla", "xp": 1000}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Aurelia",
                    "texts": ["You wont be ready for my " "Treenator!"],
                    "win_texts": [
                        "Our best trainer will " "defeat you though!"],
                    "x": 28,
                    "y": 6,
                },
                "pokes": [{"name": "treenator", "xp": 1000}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Master of the Flowers",
                    "texts": [
                        "I'm the Master of the plants "
                        "and I have one of the rarest "
                        "plant Poketes!"
                    ],
                    "win_texts": ["This was unfortunate!"],
                    "x": 31,
                    "y": 4,
                },
                "pokes": [{"name": "rosi", "xp": 1200}],
            },
        ]
    },
    "playmap_33": {
        "trainers": [
            {
                "args": {
                    "gender": "They",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Cowsay",
                    "texts": ["This apt has " "supercow-powers!"],
                    "win_texts": ["I hope you'll also catch " "one!!"],
                    "x": 59,
                    "y": 23,
                },
                "pokes": [{"name": "mowcow", "xp": 1200}],
            }
        ]
    },
    "playmap_35": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["I don't think you'll " "ever get there!"],
                    "name": "Farmer Gert",
                    "texts": [
                        "Welcome to the fields of " "Agrawos!",
                        "This is the farming part of " "the city of Agrawos!",
                        "You have to pass my field to " "reach Agrawos!",
                    ],
                    "win_texts": ["Have fun in Agrawos!"],
                    "x": 6,
                    "y": 17,
                },
                "pokes": [{"name": "mowcow", "xp": 1200}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["It's cool, innit?!"],
                    "name": "Farmer Doora",
                    "texts": ["This is a cool Pokete I " "found on my field!"],
                    "win_texts": ["I guess have still have " "to train it. :("],
                    "x": 74,
                    "y": 33,
                },
                "pokes": [{"name": "dicki", "xp": 1250}],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["HAHAHA, IM BETTER THAN " "YOU!"],
                    "name": "Farmer Ralf",
                    "texts": ["DIE!"],
                    "win_texts": [
                        "NOOOOOO; WHYYY ARE YOU " "BETTER ??!!!1!!!111"],
                    "x": 69,
                    "y": 61,
                },
                "pokes": [{"name": "wolfiro", "xp": 1300}],
            },
        ]
    },
    "playmap_39": {
        "trainers": [
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Gardener Angela",
                    "texts": [
                        "Have you already fought our " "lead trainer?",
                        "If so, look at this cool " "Pokete!",
                    ],
                    "win_texts": ["Cool, huh?"],
                    "x": 8,
                    "y": 37,
                },
                "pokes": [{"name": "megapois", "xp": 2000}],
            }
        ]
    },
    "playmap_4": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Yeaaah!", "My Pokete is sooo sick!"],
                    "name": "Kevin",
                    "texts": ["Yo!", "Whaddup?",
                              "Wanna see my sick-ass " "Pokete?"],
                    "win_texts": [
                        "Daaaamn",
                        "Your Pokete is nooot from " "this planet!",
                    ],
                    "x": 32,
                    "y": 31,
                },
                "pokes": [{"name": "karpi", "xp": 340}],
            }
        ]
    },
    "playmap_40": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You're a loooser!"],
                    "name": "Angler Gustav",
                    "texts": ["My Pokete will blow you " "away!"],
                    "win_texts": ["Cool, huh?"],
                    "x": 58,
                    "y": 12,
                },
                "pokes": [{"name": "rustacean", "xp": 1800}],
            }
        ]
    },
    "playmap_41": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["Uhhh yeah!", "The good stuff...!"],
                    "name": "Farmer Daniel",
                    "texts": [
                        "Howdy, partner!",
                        "How ya doin?",
                        "My Pokete is one of a kind",
                        "The good stuff!",
                    ],
                    "win_texts": ["I guess it's not the " "good stuff"],
                    "x": 17,
                    "y": 4,
                },
                "pokes": [{"name": "wheeto", "xp": 2000}],
            }
        ]
    },
    "playmap_46": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You'll do better next " "time."],
                    "name": "Farmer Martin",
                    "texts": ["Howdy, partner!",
                              "I will be your first " "challenger!"],
                    "win_texts": ["I wish you the best of " "luck"],
                    "x": 19,
                    "y": 7,
                },
                "pokes": [{"name": "wheeto", "xp": 2000}],
            },
            {
                "args": {
                    "gender": "They",
                    "lose_texts": ["You'll do better next " "time."],
                    "name": "The Undetermined",
                    "texts": ["I see you're not as bad as " "we thought!"],
                    "win_texts": ["I wish you the best of " "luck"],
                    "x": 16,
                    "y": 7,
                },
                "pokes": [{"name": "dicko", "xp": 2100}],
            },
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["You'll do better next " "time."],
                    "name": "Gardener Daniela",
                    "texts": ["Look at my newest creation!"],
                    "win_texts": ["I wish you the best of " "luck"],
                    "x": 13,
                    "y": 7,
                },
                "pokes": [
                    {"name": "megapois", "xp": 2200},
                    {"name": "bushy", "xp": 2200},
                ],
            },
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["You'll do better next " "time."],
                    "name": "Leader Sebastian",
                    "texts": [
                        "So, I'll be your last " "opponent.",
                        "Let's have a fair fight!",
                    ],
                    "win_texts": [
                        "You're quite a good " "trainer.",
                        "Hopefully you can beat "
                        "all other trainers with "
                        "whom you may cross "
                        "paths!",
                    ],
                    "x": 10,
                    "y": 7,
                },
                "pokes": [
                    {"name": "mowcow", "xp": 2300},
                    {"name": "treenator", "xp": 2300},
                    {"name": "wheeto", "xp": 2300},
                ],
            },
        ]
    },
    "playmap_5": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": [
                        "Oh!",
                        "My Pokete is not just " "rare",
                        "It's also strong",
                    ],
                    "name": "Caveman Marc",
                    "texts": [
                        "Oh!",
                        "I haven't seen anyone down " "here for a while",
                        "Can I show you my rare Pokete "
                        "which can only be found in "
                        "this cave?",
                    ],
                    "win_texts": [
                        "Congratulations!",
                        "I hope you can also catch " "one!",
                    ],
                    "x": 23,
                    "y": 12,
                },
                "pokes": [{"name": "bator", "xp": 350}],
            }
        ]
    },
    "playmap_6": {
        "trainers": [
            {
                "args": {
                    "gender": "She",
                    "lose_texts": ["Loser"],
                    "name": "Eva",
                    "texts": ["Hi!", "Fight?"],
                    "win_texts": ["I lost!"],
                    "x": 47,
                    "y": 43,
                },
                "pokes": [{"name": "treenator", "xp": 400}],
            }
        ]
    },
    "playmap_7": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["My Steini is old but " "classy"],
                    "name": "Caveman Dieter",
                    "texts": ["Oh!", "I didn't see you coming"],
                    "win_texts": ["You're a great trainer!"],
                    "x": 18,
                    "y": 7,
                },
                "pokes": [{"name": "steini", "xp": 400}],
            }
        ]
    },
    "playmap_8": {
        "trainers": [
            {
                "args": {
                    "gender": "He",
                    "lose_texts": ["It's pretty cool huh?!"],
                    "name": "Woodsman Bert",
                    "texts": [
                        "Do you see this abandoned " "house?",
                        "I caught this Pokete in " "there!",
                    ],
                    "win_texts": ["Oh, yours is better than " "mine!"],
                    "x": 39,
                    "y": 6,
                },
                "pokes": [{"name": "gobost", "xp": 400}],
            }
        ]
    },
}

if __name__ == "__main__":
    print("\033[31;1mDo not execute this!\033[0m")
