// Contains library to play mp3 files

package main

import (
	"C"
	"fmt"
	"os"
	"time"

	"github.com/hajimehoshi/go-mp3"
	"github.com/hajimehoshi/oto/v2"
)

//export playsound
func playsound(file *C.char, volume int) {
	f, err := os.Open(C.GoString(file))
	if err != nil {
		panic(err)
	}
	defer f.Close()

	d, err := mp3.NewDecoder(f)
	if err != nil {
		fmt.Println(err)
		panic(err)
	}

	c, ready, err := oto.NewContext(d.SampleRate(), 2, 2)
	if err != nil {
		fmt.Println(err)
		panic(err)
	}
	<-ready

	p := c.NewPlayer(d)
	defer p.Close()
	p.SetVolume(float64(volume) / float64(100))
	p.Play()

	for {
		time.Sleep(time.Second)
		if !p.IsPlaying() {
			break
		}
	}
}

func main() {
}
