"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessKey = exports.AccessKeyStatus = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const iam_generated_1 = require("./iam.generated");
/**
 * Valid statuses for an IAM Access Key.
 */
var AccessKeyStatus;
(function (AccessKeyStatus) {
    /**
     * An active access key. An active key can be used to make API calls.
     */
    AccessKeyStatus["ACTIVE"] = "Active";
    /**
     * An inactive access key. An inactive key cannot be used to make API calls.
     */
    AccessKeyStatus["INACTIVE"] = "Inactive";
})(AccessKeyStatus = exports.AccessKeyStatus || (exports.AccessKeyStatus = {}));
/**
 * Define a new IAM Access Key.
 */
class AccessKey extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_AccessKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const accessKey = new iam_generated_1.CfnAccessKey(this, 'Resource', {
            userName: props.user.userName,
            serial: props.serial,
            status: props.status,
        });
        this.accessKeyId = accessKey.ref;
        this.secretAccessKey = core_1.SecretValue.resourceAttribute(accessKey.attrSecretAccessKey);
    }
}
exports.AccessKey = AccessKey;
_a = JSII_RTTI_SYMBOL_1;
AccessKey[_a] = { fqn: "@aws-cdk/aws-iam.AccessKey", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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