/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Explicitly limits external functions that use the integration to reference one or more HTTPS proxy service endpoints and resources within those proxies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_allowed_prefixes ApiIntegration#api_allowed_prefixes}
    */
    readonly apiAllowedPrefixes: string[];
    /**
    * ARN of a cloud platform role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_aws_role_arn ApiIntegration#api_aws_role_arn}
    */
    readonly apiAwsRoleArn?: string;
    /**
    * Lists the endpoints and resources in the HTTPS proxy service that are not allowed to be called from Snowflake.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_blocked_prefixes ApiIntegration#api_blocked_prefixes}
    */
    readonly apiBlockedPrefixes?: string[];
    /**
    * The service account used for communication with the Google API Gateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_gcp_service_account ApiIntegration#api_gcp_service_account}
    */
    readonly apiGcpServiceAccount?: string;
    /**
    * The API key (also called a “subscription key”).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_key ApiIntegration#api_key}
    */
    readonly apiKey?: string;
    /**
    * Specifies the HTTPS proxy service type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#api_provider ApiIntegration#api_provider}
    */
    readonly apiProvider: string;
    /**
    * The 'Application (client) id' of the Azure AD app for your remote service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#azure_ad_application_id ApiIntegration#azure_ad_application_id}
    */
    readonly azureAdApplicationId?: string;
    /**
    * Specifies the ID for your Office 365 tenant that all Azure API Management instances belong to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#azure_tenant_id ApiIntegration#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#comment ApiIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this API integration is enabled or disabled. If the API integration is disabled, any external function that relies on it will not work.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#enabled ApiIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The audience claim when generating the JWT (JSON Web Token) to authenticate to the Google API Gateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#google_audience ApiIntegration#google_audience}
    */
    readonly googleAudience?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#id ApiIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the API integration. This name follows the rules for Object Identifiers. The name should be unique among api integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#name ApiIntegration#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration snowflake_api_integration}
*/
export declare class ApiIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_api_integration";
    /**
    * Generates CDKTF code for importing a ApiIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiIntegration to import
    * @param importFromId The id of the existing ApiIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/api_integration snowflake_api_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ApiIntegrationConfig);
    private _apiAllowedPrefixes?;
    get apiAllowedPrefixes(): string[];
    set apiAllowedPrefixes(value: string[]);
    get apiAllowedPrefixesInput(): string[] | undefined;
    get apiAwsExternalId(): string;
    get apiAwsIamUserArn(): string;
    private _apiAwsRoleArn?;
    get apiAwsRoleArn(): string;
    set apiAwsRoleArn(value: string);
    resetApiAwsRoleArn(): void;
    get apiAwsRoleArnInput(): string | undefined;
    private _apiBlockedPrefixes?;
    get apiBlockedPrefixes(): string[];
    set apiBlockedPrefixes(value: string[]);
    resetApiBlockedPrefixes(): void;
    get apiBlockedPrefixesInput(): string[] | undefined;
    private _apiGcpServiceAccount?;
    get apiGcpServiceAccount(): string;
    set apiGcpServiceAccount(value: string);
    resetApiGcpServiceAccount(): void;
    get apiGcpServiceAccountInput(): string | undefined;
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _apiProvider?;
    get apiProvider(): string;
    set apiProvider(value: string);
    get apiProviderInput(): string | undefined;
    private _azureAdApplicationId?;
    get azureAdApplicationId(): string;
    set azureAdApplicationId(value: string);
    resetAzureAdApplicationId(): void;
    get azureAdApplicationIdInput(): string | undefined;
    get azureConsentUrl(): string;
    get azureMultiTenantAppName(): string;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _googleAudience?;
    get googleAudience(): string;
    set googleAudience(value: string);
    resetGoogleAudience(): void;
    get googleAudienceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
