/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeFailoverGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/data-sources/failover_groups#id DataSnowflakeFailoverGroups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/data-sources/failover_groups#in_account DataSnowflakeFailoverGroups#in_account}
    */
    readonly inAccount?: string;
}
export interface DataSnowflakeFailoverGroupsFailoverGroups {
}
export declare function dataSnowflakeFailoverGroupsFailoverGroupsToTerraform(struct?: DataSnowflakeFailoverGroupsFailoverGroups): any;
export declare function dataSnowflakeFailoverGroupsFailoverGroupsToHclTerraform(struct?: DataSnowflakeFailoverGroupsFailoverGroups): any;
export declare class DataSnowflakeFailoverGroupsFailoverGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeFailoverGroupsFailoverGroups | undefined;
    set internalValue(value: DataSnowflakeFailoverGroupsFailoverGroups | undefined);
    get accountLocator(): string;
    get accountName(): string;
    get allowedAccounts(): string[];
    get allowedIntegrationTypes(): string[];
    get comment(): string;
    get createdOn(): string;
    get isPrimary(): cdktf.IResolvable;
    get nextScheduledRefresh(): string;
    get objectTypes(): string[];
    get organizationName(): string;
    get owner(): string;
    get primary(): string;
    get regionGroup(): string;
    get replicationSchedule(): string;
    get secondaryState(): string;
    get snowflakeRegion(): string;
    get type(): string;
}
export declare class DataSnowflakeFailoverGroupsFailoverGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeFailoverGroupsFailoverGroupsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/data-sources/failover_groups snowflake_failover_groups}
*/
export declare class DataSnowflakeFailoverGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_failover_groups";
    /**
    * Generates CDKTF code for importing a DataSnowflakeFailoverGroups resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeFailoverGroups to import
    * @param importFromId The id of the existing DataSnowflakeFailoverGroups that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/data-sources/failover_groups#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeFailoverGroups to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/data-sources/failover_groups snowflake_failover_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeFailoverGroupsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeFailoverGroupsConfig);
    private _failoverGroups;
    get failoverGroups(): DataSnowflakeFailoverGroupsFailoverGroupsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inAccount?;
    get inAccount(): string;
    set inAccount(value: string);
    resetInAccount(): void;
    get inAccountInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
