/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalOauthIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the list of roles that the client can set as the primary role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#allowed_roles ExternalOauthIntegration#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#any_role_mode ExternalOauthIntegration#any_role_mode}
    */
    readonly anyRoleMode?: string;
    /**
    * Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#audience_urls ExternalOauthIntegration#audience_urls}
    */
    readonly audienceUrls?: string[];
    /**
    * Specifies the list of roles that a client cannot set as the primary role. Do not include ACCOUNTADMIN, ORGADMIN or SECURITYADMIN as they are already implicitly enforced and will cause in-place updates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#blocked_roles ExternalOauthIntegration#blocked_roles}
    */
    readonly blockedRoles?: string[];
    /**
    * Specifies a comment for the OAuth integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#comment ExternalOauthIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether to initiate operation of the integration or suspend it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#enabled ExternalOauthIntegration#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#id ExternalOauthIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the URL to define the OAuth 2.0 authorization server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#issuer ExternalOauthIntegration#issuer}
    */
    readonly issuer: string;
    /**
    * Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#jws_keys_urls ExternalOauthIntegration#jws_keys_urls}
    */
    readonly jwsKeysUrls?: string[];
    /**
    * Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#name ExternalOauthIntegration#name}
    */
    readonly name: string;
    /**
    * Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#rsa_public_key ExternalOauthIntegration#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#rsa_public_key_2 ExternalOauthIntegration#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
    /**
    * Specifies the scope delimiter in the authorization token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#scope_delimiter ExternalOauthIntegration#scope_delimiter}
    */
    readonly scopeDelimiter?: string;
    /**
    * Specifies the access token claim to map the access token to an account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#scope_mapping_attribute ExternalOauthIntegration#scope_mapping_attribute}
    */
    readonly scopeMappingAttribute?: string;
    /**
    * Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#snowflake_user_mapping_attribute ExternalOauthIntegration#snowflake_user_mapping_attribute}
    */
    readonly snowflakeUserMappingAttribute: string;
    /**
    * Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#token_user_mapping_claims ExternalOauthIntegration#token_user_mapping_claims}
    */
    readonly tokenUserMappingClaims: string[];
    /**
    * Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#type ExternalOauthIntegration#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration snowflake_external_oauth_integration}
*/
export declare class ExternalOauthIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_external_oauth_integration";
    /**
    * Generates CDKTF code for importing a ExternalOauthIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalOauthIntegration to import
    * @param importFromId The id of the existing ExternalOauthIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalOauthIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/external_oauth_integration snowflake_external_oauth_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalOauthIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ExternalOauthIntegrationConfig);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _anyRoleMode?;
    get anyRoleMode(): string;
    set anyRoleMode(value: string);
    resetAnyRoleMode(): void;
    get anyRoleModeInput(): string | undefined;
    private _audienceUrls?;
    get audienceUrls(): string[];
    set audienceUrls(value: string[]);
    resetAudienceUrls(): void;
    get audienceUrlsInput(): string[] | undefined;
    private _blockedRoles?;
    get blockedRoles(): string[];
    set blockedRoles(value: string[]);
    resetBlockedRoles(): void;
    get blockedRolesInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _jwsKeysUrls?;
    get jwsKeysUrls(): string[];
    set jwsKeysUrls(value: string[]);
    resetJwsKeysUrls(): void;
    get jwsKeysUrlsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    private _scopeDelimiter?;
    get scopeDelimiter(): string;
    set scopeDelimiter(value: string);
    resetScopeDelimiter(): void;
    get scopeDelimiterInput(): string | undefined;
    private _scopeMappingAttribute?;
    get scopeMappingAttribute(): string;
    set scopeMappingAttribute(value: string);
    resetScopeMappingAttribute(): void;
    get scopeMappingAttributeInput(): string | undefined;
    private _snowflakeUserMappingAttribute?;
    get snowflakeUserMappingAttribute(): string;
    set snowflakeUserMappingAttribute(value: string);
    get snowflakeUserMappingAttributeInput(): string | undefined;
    private _tokenUserMappingClaims?;
    get tokenUserMappingClaims(): string[];
    set tokenUserMappingClaims(value: string[]);
    get tokenUserMappingClaimsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
