/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form <org_name>.<target_account_name>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#allowed_accounts FailoverGroup#allowed_accounts}
    */
    readonly allowedAccounts?: string[];
    /**
    * Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#allowed_databases FailoverGroup#allowed_databases}
    */
    readonly allowedDatabases?: string[];
    /**
    * Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#allowed_integration_types FailoverGroup#allowed_integration_types}
    */
    readonly allowedIntegrationTypes?: string[];
    /**
    * Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#allowed_shares FailoverGroup#allowed_shares}
    */
    readonly allowedShares?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#id FailoverGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Allows replicating objects to accounts on lower editions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#ignore_edition_check FailoverGroup#ignore_edition_check}
    */
    readonly ignoreEditionCheck?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#name FailoverGroup#name}
    */
    readonly name: string;
    /**
    * Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#object_types FailoverGroup#object_types}
    */
    readonly objectTypes?: string[];
    /**
    * from_replica block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#from_replica FailoverGroup#from_replica}
    */
    readonly fromReplica?: FailoverGroupFromReplica;
    /**
    * replication_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#replication_schedule FailoverGroup#replication_schedule}
    */
    readonly replicationSchedule?: FailoverGroupReplicationSchedule;
}
export interface FailoverGroupFromReplica {
    /**
    * Identifier for the primary failover group in the source account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#name FailoverGroup#name}
    */
    readonly name: string;
    /**
    * Name of your Snowflake organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#organization_name FailoverGroup#organization_name}
    */
    readonly organizationName: string;
    /**
    * Source account from which you are enabling replication and failover of the specified objects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#source_account_name FailoverGroup#source_account_name}
    */
    readonly sourceAccountName: string;
}
export declare function failoverGroupFromReplicaToTerraform(struct?: FailoverGroupFromReplicaOutputReference | FailoverGroupFromReplica): any;
export declare function failoverGroupFromReplicaToHclTerraform(struct?: FailoverGroupFromReplicaOutputReference | FailoverGroupFromReplica): any;
export declare class FailoverGroupFromReplicaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FailoverGroupFromReplica | undefined;
    set internalValue(value: FailoverGroupFromReplica | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organizationName?;
    get organizationName(): string;
    set organizationName(value: string);
    get organizationNameInput(): string | undefined;
    private _sourceAccountName?;
    get sourceAccountName(): string;
    set sourceAccountName(value: string);
    get sourceAccountNameInput(): string | undefined;
}
export interface FailoverGroupReplicationScheduleCron {
    /**
    * Specifies the cron expression for the replication schedule. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#expression FailoverGroup#expression}
    */
    readonly expression: string;
    /**
    * Specifies the time zone for secondary group refresh.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#time_zone FailoverGroup#time_zone}
    */
    readonly timeZone: string;
}
export declare function failoverGroupReplicationScheduleCronToTerraform(struct?: FailoverGroupReplicationScheduleCronOutputReference | FailoverGroupReplicationScheduleCron): any;
export declare function failoverGroupReplicationScheduleCronToHclTerraform(struct?: FailoverGroupReplicationScheduleCronOutputReference | FailoverGroupReplicationScheduleCron): any;
export declare class FailoverGroupReplicationScheduleCronOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FailoverGroupReplicationScheduleCron | undefined;
    set internalValue(value: FailoverGroupReplicationScheduleCron | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
}
export interface FailoverGroupReplicationSchedule {
    /**
    * Specifies the interval in minutes for the replication schedule. The interval must be greater than 0 and less than 1440 (24 hours).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#interval FailoverGroup#interval}
    */
    readonly interval?: number;
    /**
    * cron block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#cron FailoverGroup#cron}
    */
    readonly cron?: FailoverGroupReplicationScheduleCron;
}
export declare function failoverGroupReplicationScheduleToTerraform(struct?: FailoverGroupReplicationScheduleOutputReference | FailoverGroupReplicationSchedule): any;
export declare function failoverGroupReplicationScheduleToHclTerraform(struct?: FailoverGroupReplicationScheduleOutputReference | FailoverGroupReplicationSchedule): any;
export declare class FailoverGroupReplicationScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FailoverGroupReplicationSchedule | undefined;
    set internalValue(value: FailoverGroupReplicationSchedule | undefined);
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _cron;
    get cron(): FailoverGroupReplicationScheduleCronOutputReference;
    putCron(value: FailoverGroupReplicationScheduleCron): void;
    resetCron(): void;
    get cronInput(): FailoverGroupReplicationScheduleCron | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group snowflake_failover_group}
*/
export declare class FailoverGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_failover_group";
    /**
    * Generates CDKTF code for importing a FailoverGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FailoverGroup to import
    * @param importFromId The id of the existing FailoverGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FailoverGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/failover_group snowflake_failover_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FailoverGroupConfig
    */
    constructor(scope: Construct, id: string, config: FailoverGroupConfig);
    private _allowedAccounts?;
    get allowedAccounts(): string[];
    set allowedAccounts(value: string[]);
    resetAllowedAccounts(): void;
    get allowedAccountsInput(): string[] | undefined;
    private _allowedDatabases?;
    get allowedDatabases(): string[];
    set allowedDatabases(value: string[]);
    resetAllowedDatabases(): void;
    get allowedDatabasesInput(): string[] | undefined;
    private _allowedIntegrationTypes?;
    get allowedIntegrationTypes(): string[];
    set allowedIntegrationTypes(value: string[]);
    resetAllowedIntegrationTypes(): void;
    get allowedIntegrationTypesInput(): string[] | undefined;
    private _allowedShares?;
    get allowedShares(): string[];
    set allowedShares(value: string[]);
    resetAllowedShares(): void;
    get allowedSharesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreEditionCheck?;
    get ignoreEditionCheck(): boolean | cdktf.IResolvable;
    set ignoreEditionCheck(value: boolean | cdktf.IResolvable);
    resetIgnoreEditionCheck(): void;
    get ignoreEditionCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _objectTypes?;
    get objectTypes(): string[];
    set objectTypes(value: string[]);
    resetObjectTypes(): void;
    get objectTypesInput(): string[] | undefined;
    private _fromReplica;
    get fromReplica(): FailoverGroupFromReplicaOutputReference;
    putFromReplica(value: FailoverGroupFromReplica): void;
    resetFromReplica(): void;
    get fromReplicaInput(): FailoverGroupFromReplica | undefined;
    private _replicationSchedule;
    get replicationSchedule(): FailoverGroupReplicationScheduleOutputReference;
    putReplicationSchedule(value: FailoverGroupReplicationSchedule): void;
    resetReplicationSchedule(): void;
    get replicationScheduleInput(): FailoverGroupReplicationSchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
