/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantAccountRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role#id GrantAccountRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified name of the parent role which will create a parent-child relationship between the roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role#parent_role_name GrantAccountRole#parent_role_name}
    */
    readonly parentRoleName?: string;
    /**
    * The fully qualified name of the role which will be granted to the user or parent role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role#role_name GrantAccountRole#role_name}
    */
    readonly roleName: string;
    /**
    * The fully qualified name of the user on which specified role will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role#user_name GrantAccountRole#user_name}
    */
    readonly userName?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role snowflake_grant_account_role}
*/
export declare class GrantAccountRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_account_role";
    /**
    * Generates CDKTF code for importing a GrantAccountRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantAccountRole to import
    * @param importFromId The id of the existing GrantAccountRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantAccountRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_account_role snowflake_grant_account_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantAccountRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantAccountRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parentRoleName?;
    get parentRoleName(): string;
    set parentRoleName(value: string);
    resetParentRoleName(): void;
    get parentRoleNameInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
