/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantDatabaseRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The fully qualified name of the database role which will be granted to share or parent role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#database_role_name GrantDatabaseRole#database_role_name}
    */
    readonly databaseRoleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#id GrantDatabaseRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified name of the parent database role which will create a parent-child relationship between the roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#parent_database_role_name GrantDatabaseRole#parent_database_role_name}
    */
    readonly parentDatabaseRoleName?: string;
    /**
    * The fully qualified name of the parent account role which will create a parent-child relationship between the roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#parent_role_name GrantDatabaseRole#parent_role_name}
    */
    readonly parentRoleName?: string;
    /**
    * The fully qualified name of the share on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#share_name GrantDatabaseRole#share_name}
    */
    readonly shareName?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role snowflake_grant_database_role}
*/
export declare class GrantDatabaseRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_database_role";
    /**
    * Generates CDKTF code for importing a GrantDatabaseRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantDatabaseRole to import
    * @param importFromId The id of the existing GrantDatabaseRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantDatabaseRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/grant_database_role snowflake_grant_database_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantDatabaseRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantDatabaseRoleConfig);
    private _databaseRoleName?;
    get databaseRoleName(): string;
    set databaseRoleName(value: string);
    get databaseRoleNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parentDatabaseRoleName?;
    get parentDatabaseRoleName(): string;
    set parentDatabaseRoleName(value: string);
    resetParentDatabaseRoleName(): void;
    get parentDatabaseRoleNameInput(): string | undefined;
    private _parentRoleName?;
    get parentRoleName(): string;
    set parentRoleName(value: string);
    resetParentRoleName(): void;
    get parentRoleNameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    resetShareName(): void;
    get shareNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
