/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier, as well as login name, for the initial user in the managed account. This user serves as the account administrator for the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#admin_name ManagedAccount#admin_name}
    */
    readonly adminName: string;
    /**
    * Password for the initial user in the managed account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#admin_password ManagedAccount#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Specifies a comment for the managed account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#comment ManagedAccount#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#id ManagedAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the managed account; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#name ManagedAccount#name}
    */
    readonly name: string;
    /**
    * Specifies the type of managed account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#type ManagedAccount#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account snowflake_managed_account}
*/
export declare class ManagedAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_managed_account";
    /**
    * Generates CDKTF code for importing a ManagedAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedAccount to import
    * @param importFromId The id of the existing ManagedAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/managed_account snowflake_managed_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedAccountConfig
    */
    constructor(scope: Construct, id: string, config: ManagedAccountConfig);
    private _adminName?;
    get adminName(): string;
    set adminName(value: string);
    get adminNameInput(): string | undefined;
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    get cloud(): string;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get locator(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get region(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
