/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a auto_ingest param for the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#auto_ingest Pipe#auto_ingest}
    */
    readonly autoIngest?: boolean | cdktf.IResolvable;
    /**
    * Specifies the Amazon Resource Name (ARN) for the SNS topic for your S3 bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#aws_sns_topic_arn Pipe#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn?: string;
    /**
    * Specifies a comment for the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#comment Pipe#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the copy statement for the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#copy_statement Pipe#copy_statement}
    */
    readonly copyStatement: string;
    /**
    * The database in which to create the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#database Pipe#database}
    */
    readonly database: string;
    /**
    * Specifies the name of the notification integration used for error notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#error_integration Pipe#error_integration}
    */
    readonly errorIntegration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#id Pipe#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies an integration for the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#integration Pipe#integration}
    */
    readonly integration?: string;
    /**
    * Specifies the identifier for the pipe; must be unique for the database and schema in which the pipe is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#name Pipe#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the pipe.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#schema Pipe#schema}
    */
    readonly schema: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe snowflake_pipe}
*/
export declare class Pipe extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_pipe";
    /**
    * Generates CDKTF code for importing a Pipe resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Pipe to import
    * @param importFromId The id of the existing Pipe that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Pipe to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/pipe snowflake_pipe} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipeConfig
    */
    constructor(scope: Construct, id: string, config: PipeConfig);
    private _autoIngest?;
    get autoIngest(): boolean | cdktf.IResolvable;
    set autoIngest(value: boolean | cdktf.IResolvable);
    resetAutoIngest(): void;
    get autoIngestInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    resetAwsSnsTopicArn(): void;
    get awsSnsTopicArnInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyStatement?;
    get copyStatement(): string;
    set copyStatement(value: string);
    get copyStatementInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _errorIntegration?;
    get errorIntegration(): string;
    set errorIntegration(value: string);
    resetErrorIntegration(): void;
    get errorIntegrationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integration?;
    get integration(): string;
    set integration(value: string);
    resetIntegration(): void;
    get integrationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notificationChannel(): string;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
