/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of credits allocated monthly to the resource monitor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#credit_quota ResourceMonitor#credit_quota}
    */
    readonly creditQuota?: number;
    /**
    * The date and time when the resource monitor suspends the assigned warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#end_timestamp ResourceMonitor#end_timestamp}
    */
    readonly endTimestamp?: string;
    /**
    * The frequency interval at which the credit usage resets to 0. If you set a frequency for a resource monitor, you must also set START_TIMESTAMP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#frequency ResourceMonitor#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#id ResourceMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the resource monitor; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#name ResourceMonitor#name}
    */
    readonly name: string;
    /**
    * A list of percentage thresholds at which to send an alert to subscribed users.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#notify_triggers ResourceMonitor#notify_triggers}
    */
    readonly notifyTriggers?: number[];
    /**
    * Specifies the list of users to receive email notifications on resource monitors.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#notify_users ResourceMonitor#notify_users}
    */
    readonly notifyUsers?: string[];
    /**
    * Specifies whether the resource monitor should be applied globally to your Snowflake account (defaults to false).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#set_for_account ResourceMonitor#set_for_account}
    */
    readonly setForAccount?: boolean | cdktf.IResolvable;
    /**
    * The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#start_timestamp ResourceMonitor#start_timestamp}
    */
    readonly startTimestamp?: string;
    /**
    * The number that represents the percentage threshold at which to immediately suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#suspend_immediate_trigger ResourceMonitor#suspend_immediate_trigger}
    */
    readonly suspendImmediateTrigger?: number;
    /**
    * A list of percentage thresholds at which to suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#suspend_immediate_triggers ResourceMonitor#suspend_immediate_triggers}
    */
    readonly suspendImmediateTriggers?: number[];
    /**
    * The number that represents the percentage threshold at which to suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#suspend_trigger ResourceMonitor#suspend_trigger}
    */
    readonly suspendTrigger?: number;
    /**
    * A list of percentage thresholds at which to suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#suspend_triggers ResourceMonitor#suspend_triggers}
    */
    readonly suspendTriggers?: number[];
    /**
    * A list of warehouses to apply the resource monitor to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#warehouses ResourceMonitor#warehouses}
    */
    readonly warehouses?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor snowflake_resource_monitor}
*/
export declare class ResourceMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_resource_monitor";
    /**
    * Generates CDKTF code for importing a ResourceMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceMonitor to import
    * @param importFromId The id of the existing ResourceMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/resource_monitor snowflake_resource_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorConfig
    */
    constructor(scope: Construct, id: string, config: ResourceMonitorConfig);
    private _creditQuota?;
    get creditQuota(): number;
    set creditQuota(value: number);
    resetCreditQuota(): void;
    get creditQuotaInput(): number | undefined;
    private _endTimestamp?;
    get endTimestamp(): string;
    set endTimestamp(value: string);
    resetEndTimestamp(): void;
    get endTimestampInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifyTriggers?;
    get notifyTriggers(): number[];
    set notifyTriggers(value: number[]);
    resetNotifyTriggers(): void;
    get notifyTriggersInput(): number[] | undefined;
    private _notifyUsers?;
    get notifyUsers(): string[];
    set notifyUsers(value: string[]);
    resetNotifyUsers(): void;
    get notifyUsersInput(): string[] | undefined;
    private _setForAccount?;
    get setForAccount(): boolean | cdktf.IResolvable;
    set setForAccount(value: boolean | cdktf.IResolvable);
    resetSetForAccount(): void;
    get setForAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _startTimestamp?;
    get startTimestamp(): string;
    set startTimestamp(value: string);
    resetStartTimestamp(): void;
    get startTimestampInput(): string | undefined;
    private _suspendImmediateTrigger?;
    get suspendImmediateTrigger(): number;
    set suspendImmediateTrigger(value: number);
    resetSuspendImmediateTrigger(): void;
    get suspendImmediateTriggerInput(): number | undefined;
    private _suspendImmediateTriggers?;
    get suspendImmediateTriggers(): number[];
    set suspendImmediateTriggers(value: number[]);
    resetSuspendImmediateTriggers(): void;
    get suspendImmediateTriggersInput(): number[] | undefined;
    private _suspendTrigger?;
    get suspendTrigger(): number;
    set suspendTrigger(value: number);
    resetSuspendTrigger(): void;
    get suspendTriggerInput(): number | undefined;
    private _suspendTriggers?;
    get suspendTriggers(): number[];
    set suspendTriggers(value: number[]);
    resetSuspendTriggers(): void;
    get suspendTriggersInput(): number[] | undefined;
    private _warehouses?;
    get warehouses(): string[];
    set warehouses(value: string[]);
    resetWarehouses(): void;
    get warehousesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
