/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchemaGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database containing the schema on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#database_name SchemaGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#enable_multiple_grants SchemaGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#id SchemaGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When this is set to true, apply this grant on all schemas in the given database. The schema_name and shares fields must be unset in order to use on_all. Cannot be used together with on_future.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#on_all SchemaGrant#on_all}
    */
    readonly onAll?: boolean | cdktf.IResolvable;
    /**
    * When this is set to true, apply this grant on all future schemas in the given database. The schema_name and shares fields must be unset in order to use on_future. Cannot be used together with on_all.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#on_future SchemaGrant#on_future}
    */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the current or future schema. Note that if "OWNERSHIP" is specified, ensure that the role that terraform is using is granted access. To grant all privileges, use the value `ALL PRIVILEGES`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#privilege SchemaGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * The name of the role to revert ownership to on destroy. Has no effect unless `privilege` is set to `OWNERSHIP`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#revert_ownership_to_role_name SchemaGrant#revert_ownership_to_role_name}
    */
    readonly revertOwnershipToRoleName?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#roles SchemaGrant#roles}
    */
    readonly roles?: string[];
    /**
    * The name of the schema on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#schema_name SchemaGrant#schema_name}
    */
    readonly schemaName?: string;
    /**
    * Grants privilege to these shares (only valid if on_future and on_all are unset).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#shares SchemaGrant#shares}
    */
    readonly shares?: string[];
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#with_grant_option SchemaGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant snowflake_schema_grant}
*/
export declare class SchemaGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_schema_grant";
    /**
    * Generates CDKTF code for importing a SchemaGrant resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SchemaGrant to import
    * @param importFromId The id of the existing SchemaGrant that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SchemaGrant to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/schema_grant snowflake_schema_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchemaGrantConfig
    */
    constructor(scope: Construct, id: string, config: SchemaGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onAll?;
    get onAll(): boolean | cdktf.IResolvable;
    set onAll(value: boolean | cdktf.IResolvable);
    resetOnAll(): void;
    get onAllInput(): boolean | cdktf.IResolvable | undefined;
    private _onFuture?;
    get onFuture(): boolean | cdktf.IResolvable;
    set onFuture(value: boolean | cdktf.IResolvable);
    resetOnFuture(): void;
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _revertOwnershipToRoleName?;
    get revertOwnershipToRoleName(): string;
    set revertOwnershipToRoleName(value: string);
    resetRevertOwnershipToRoleName(): void;
    get revertOwnershipToRoleNameInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
    private _shares?;
    get shares(): string[];
    set shares(value: string[]);
    resetShares(): void;
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
