/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ScimIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#id ScimIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the SCIM integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#name ScimIntegration#name}
    */
    readonly name: string;
    /**
    * Specifies an existing network policy active for your account. The network policy restricts the list of user IP addresses when exchanging an authorization code for an access or refresh token and when using a refresh token to obtain a new access token. If this parameter is not set, the network policy for the account (if any) is used instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#network_policy ScimIntegration#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#provisioner_role ScimIntegration#provisioner_role}
    */
    readonly provisionerRole: string;
    /**
    * Specifies the client type for the scim integration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#scim_client ScimIntegration#scim_client}
    */
    readonly scimClient: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration snowflake_scim_integration}
*/
export declare class ScimIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_scim_integration";
    /**
    * Generates CDKTF code for importing a ScimIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ScimIntegration to import
    * @param importFromId The id of the existing ScimIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ScimIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/scim_integration snowflake_scim_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ScimIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ScimIntegrationConfig);
    get createdOn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _provisionerRole?;
    get provisionerRole(): string;
    set provisionerRole(value: string);
    get provisionerRoleInput(): string | undefined;
    private _scimClient?;
    get scimClient(): string;
    set scimClient(value: string);
    get scimClientInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
