/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#comment User#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the namespace (database only or database and schema) that is active by default for the user’s session upon login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#default_namespace User#default_namespace}
    */
    readonly defaultNamespace?: string;
    /**
    * Specifies the role that is active by default for the user’s session upon login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#default_role User#default_role}
    */
    readonly defaultRole?: string;
    /**
    * Specifies the set of secondary roles that are active for the user’s session upon login. Currently only ["ALL"] value is supported - more information can be found in [doc](https://docs.snowflake.com/en/sql-reference/sql/create-user#optional-object-properties-objectproperties)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#default_secondary_roles User#default_secondary_roles}
    */
    readonly defaultSecondaryRoles?: string[];
    /**
    * Specifies the virtual warehouse that is active by default for the user’s session upon login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#default_warehouse User#default_warehouse}
    */
    readonly defaultWarehouse?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#disabled User#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Name displayed for the user in the Snowflake web interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#display_name User#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#email User#email}
    */
    readonly email?: string;
    /**
    * First name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#first_name User#first_name}
    */
    readonly firstName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Last name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#last_name User#last_name}
    */
    readonly lastName?: string;
    /**
    * The name users use to log in. If not supplied, snowflake will use name instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#login_name User#login_name}
    */
    readonly loginName?: string;
    /**
    * Specifies whether the user is forced to change their password on next login (including their first/initial login) into the system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#must_change_password User#must_change_password}
    */
    readonly mustChangePassword?: boolean | cdktf.IResolvable;
    /**
    * Name of the user. Note that if you do not supply login_name this will be used as login_name. [doc](https://docs.snowflake.net/manuals/sql-reference/sql/create-user.html#required-parameters)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#name User#name}
    */
    readonly name: string;
    /**
    * **WARNING:** this will put the password in the terraform state file. Use carefully.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#password User#password}
    */
    readonly password?: string;
    /**
    * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#rsa_public_key User#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies the user’s second RSA public key; used to rotate the public and private keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#rsa_public_key_2 User#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user snowflake_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_user";
    /**
    * Generates CDKTF code for importing a User resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the User to import
    * @param importFromId The id of the existing User that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the User to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/user snowflake_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _defaultNamespace?;
    get defaultNamespace(): string;
    set defaultNamespace(value: string);
    resetDefaultNamespace(): void;
    get defaultNamespaceInput(): string | undefined;
    private _defaultRole?;
    get defaultRole(): string;
    set defaultRole(value: string);
    resetDefaultRole(): void;
    get defaultRoleInput(): string | undefined;
    private _defaultSecondaryRoles?;
    get defaultSecondaryRoles(): string[];
    set defaultSecondaryRoles(value: string[]);
    resetDefaultSecondaryRoles(): void;
    get defaultSecondaryRolesInput(): string[] | undefined;
    private _defaultWarehouse?;
    get defaultWarehouse(): string;
    set defaultWarehouse(value: string);
    resetDefaultWarehouse(): void;
    get defaultWarehouseInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    resetFirstName(): void;
    get firstNameInput(): string | undefined;
    get hasRsaPublicKey(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    resetLastName(): void;
    get lastNameInput(): string | undefined;
    private _loginName?;
    get loginName(): string;
    set loginName(value: string);
    resetLoginName(): void;
    get loginNameInput(): string | undefined;
    private _mustChangePassword?;
    get mustChangePassword(): boolean | cdktf.IResolvable;
    set mustChangePassword(value: boolean | cdktf.IResolvable);
    resetMustChangePassword(): void;
    get mustChangePasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
