"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Warehouse = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/warehouse snowflake_warehouse}
*/
class Warehouse extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a Warehouse resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Warehouse to import
    * @param importFromId The id of the existing Warehouse that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/warehouse#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Warehouse to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_warehouse", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.84.0/docs/resources/warehouse snowflake_warehouse} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WarehouseConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_warehouse',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.84.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._autoResume = config.autoResume;
        this._autoSuspend = config.autoSuspend;
        this._comment = config.comment;
        this._enableQueryAcceleration = config.enableQueryAcceleration;
        this._id = config.id;
        this._initiallySuspended = config.initiallySuspended;
        this._maxClusterCount = config.maxClusterCount;
        this._maxConcurrencyLevel = config.maxConcurrencyLevel;
        this._minClusterCount = config.minClusterCount;
        this._name = config.name;
        this._queryAccelerationMaxScaleFactor = config.queryAccelerationMaxScaleFactor;
        this._resourceMonitor = config.resourceMonitor;
        this._scalingPolicy = config.scalingPolicy;
        this._statementQueuedTimeoutInSeconds = config.statementQueuedTimeoutInSeconds;
        this._statementTimeoutInSeconds = config.statementTimeoutInSeconds;
        this._waitForProvisioning = config.waitForProvisioning;
        this._warehouseSize = config.warehouseSize;
        this._warehouseType = config.warehouseType;
    }
    get autoResume() {
        return this.getBooleanAttribute('auto_resume');
    }
    set autoResume(value) {
        this._autoResume = value;
    }
    resetAutoResume() {
        this._autoResume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoResumeInput() {
        return this._autoResume;
    }
    get autoSuspend() {
        return this.getNumberAttribute('auto_suspend');
    }
    set autoSuspend(value) {
        this._autoSuspend = value;
    }
    resetAutoSuspend() {
        this._autoSuspend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoSuspendInput() {
        return this._autoSuspend;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get enableQueryAcceleration() {
        return this.getBooleanAttribute('enable_query_acceleration');
    }
    set enableQueryAcceleration(value) {
        this._enableQueryAcceleration = value;
    }
    resetEnableQueryAcceleration() {
        this._enableQueryAcceleration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableQueryAccelerationInput() {
        return this._enableQueryAcceleration;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get initiallySuspended() {
        return this.getBooleanAttribute('initially_suspended');
    }
    set initiallySuspended(value) {
        this._initiallySuspended = value;
    }
    resetInitiallySuspended() {
        this._initiallySuspended = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initiallySuspendedInput() {
        return this._initiallySuspended;
    }
    get maxClusterCount() {
        return this.getNumberAttribute('max_cluster_count');
    }
    set maxClusterCount(value) {
        this._maxClusterCount = value;
    }
    resetMaxClusterCount() {
        this._maxClusterCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxClusterCountInput() {
        return this._maxClusterCount;
    }
    get maxConcurrencyLevel() {
        return this.getNumberAttribute('max_concurrency_level');
    }
    set maxConcurrencyLevel(value) {
        this._maxConcurrencyLevel = value;
    }
    resetMaxConcurrencyLevel() {
        this._maxConcurrencyLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxConcurrencyLevelInput() {
        return this._maxConcurrencyLevel;
    }
    get minClusterCount() {
        return this.getNumberAttribute('min_cluster_count');
    }
    set minClusterCount(value) {
        this._minClusterCount = value;
    }
    resetMinClusterCount() {
        this._minClusterCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minClusterCountInput() {
        return this._minClusterCount;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get queryAccelerationMaxScaleFactor() {
        return this.getNumberAttribute('query_acceleration_max_scale_factor');
    }
    set queryAccelerationMaxScaleFactor(value) {
        this._queryAccelerationMaxScaleFactor = value;
    }
    resetQueryAccelerationMaxScaleFactor() {
        this._queryAccelerationMaxScaleFactor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get queryAccelerationMaxScaleFactorInput() {
        return this._queryAccelerationMaxScaleFactor;
    }
    get resourceMonitor() {
        return this.getStringAttribute('resource_monitor');
    }
    set resourceMonitor(value) {
        this._resourceMonitor = value;
    }
    resetResourceMonitor() {
        this._resourceMonitor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceMonitorInput() {
        return this._resourceMonitor;
    }
    get scalingPolicy() {
        return this.getStringAttribute('scaling_policy');
    }
    set scalingPolicy(value) {
        this._scalingPolicy = value;
    }
    resetScalingPolicy() {
        this._scalingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scalingPolicyInput() {
        return this._scalingPolicy;
    }
    get statementQueuedTimeoutInSeconds() {
        return this.getNumberAttribute('statement_queued_timeout_in_seconds');
    }
    set statementQueuedTimeoutInSeconds(value) {
        this._statementQueuedTimeoutInSeconds = value;
    }
    resetStatementQueuedTimeoutInSeconds() {
        this._statementQueuedTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statementQueuedTimeoutInSecondsInput() {
        return this._statementQueuedTimeoutInSeconds;
    }
    get statementTimeoutInSeconds() {
        return this.getNumberAttribute('statement_timeout_in_seconds');
    }
    set statementTimeoutInSeconds(value) {
        this._statementTimeoutInSeconds = value;
    }
    resetStatementTimeoutInSeconds() {
        this._statementTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statementTimeoutInSecondsInput() {
        return this._statementTimeoutInSeconds;
    }
    get waitForProvisioning() {
        return this.getBooleanAttribute('wait_for_provisioning');
    }
    set waitForProvisioning(value) {
        this._waitForProvisioning = value;
    }
    resetWaitForProvisioning() {
        this._waitForProvisioning = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get waitForProvisioningInput() {
        return this._waitForProvisioning;
    }
    get warehouseSize() {
        return this.getStringAttribute('warehouse_size');
    }
    set warehouseSize(value) {
        this._warehouseSize = value;
    }
    resetWarehouseSize() {
        this._warehouseSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseSizeInput() {
        return this._warehouseSize;
    }
    get warehouseType() {
        return this.getStringAttribute('warehouse_type');
    }
    set warehouseType(value) {
        this._warehouseType = value;
    }
    resetWarehouseType() {
        this._warehouseType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseTypeInput() {
        return this._warehouseType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_resume: cdktf.booleanToTerraform(this._autoResume),
            auto_suspend: cdktf.numberToTerraform(this._autoSuspend),
            comment: cdktf.stringToTerraform(this._comment),
            enable_query_acceleration: cdktf.booleanToTerraform(this._enableQueryAcceleration),
            id: cdktf.stringToTerraform(this._id),
            initially_suspended: cdktf.booleanToTerraform(this._initiallySuspended),
            max_cluster_count: cdktf.numberToTerraform(this._maxClusterCount),
            max_concurrency_level: cdktf.numberToTerraform(this._maxConcurrencyLevel),
            min_cluster_count: cdktf.numberToTerraform(this._minClusterCount),
            name: cdktf.stringToTerraform(this._name),
            query_acceleration_max_scale_factor: cdktf.numberToTerraform(this._queryAccelerationMaxScaleFactor),
            resource_monitor: cdktf.stringToTerraform(this._resourceMonitor),
            scaling_policy: cdktf.stringToTerraform(this._scalingPolicy),
            statement_queued_timeout_in_seconds: cdktf.numberToTerraform(this._statementQueuedTimeoutInSeconds),
            statement_timeout_in_seconds: cdktf.numberToTerraform(this._statementTimeoutInSeconds),
            wait_for_provisioning: cdktf.booleanToTerraform(this._waitForProvisioning),
            warehouse_size: cdktf.stringToTerraform(this._warehouseSize),
            warehouse_type: cdktf.stringToTerraform(this._warehouseType),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            auto_resume: {
                value: cdktf.booleanToHclTerraform(this._autoResume),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            auto_suspend: {
                value: cdktf.numberToHclTerraform(this._autoSuspend),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            comment: {
                value: cdktf.stringToHclTerraform(this._comment),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            enable_query_acceleration: {
                value: cdktf.booleanToHclTerraform(this._enableQueryAcceleration),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            initially_suspended: {
                value: cdktf.booleanToHclTerraform(this._initiallySuspended),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            max_cluster_count: {
                value: cdktf.numberToHclTerraform(this._maxClusterCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            max_concurrency_level: {
                value: cdktf.numberToHclTerraform(this._maxConcurrencyLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            min_cluster_count: {
                value: cdktf.numberToHclTerraform(this._minClusterCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            query_acceleration_max_scale_factor: {
                value: cdktf.numberToHclTerraform(this._queryAccelerationMaxScaleFactor),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            resource_monitor: {
                value: cdktf.stringToHclTerraform(this._resourceMonitor),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            scaling_policy: {
                value: cdktf.stringToHclTerraform(this._scalingPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            statement_queued_timeout_in_seconds: {
                value: cdktf.numberToHclTerraform(this._statementQueuedTimeoutInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            statement_timeout_in_seconds: {
                value: cdktf.numberToHclTerraform(this._statementTimeoutInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            wait_for_provisioning: {
                value: cdktf.booleanToHclTerraform(this._waitForProvisioning),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            warehouse_size: {
                value: cdktf.stringToHclTerraform(this._warehouseSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            warehouse_type: {
                value: cdktf.stringToHclTerraform(this._warehouseType),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.Warehouse = Warehouse;
_a = JSII_RTTI_SYMBOL_1;
Warehouse[_a] = { fqn: "@cdktf/provider-snowflake.warehouse.Warehouse", version: "11.0.2" };
// =================
// STATIC PROPERTIES
// =================
Warehouse.tfResourceType = "snowflake_warehouse";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvd2FyZWhvdXNlL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBU0EsK0JBQStCO0FBa0gvQjs7RUFFRTtBQUNGLE1BQWEsU0FBVSxTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPcEQsaUJBQWlCO0lBQ2pCLGlCQUFpQjtJQUNqQixpQkFBaUI7SUFDakI7Ozs7OztNQU1FO0lBQ0ssTUFBTSxDQUFDLHVCQUF1QixDQUFDLEtBQWdCLEVBQUUsVUFBa0IsRUFBRSxZQUFvQixFQUFFLFFBQWtDO1FBQzlILE9BQU8sSUFBSSxLQUFLLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxFQUFFLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFFBQVEsRUFBRSxZQUFZLEVBQUUsUUFBUSxFQUFFLENBQUMsQ0FBQztJQUM3SSxDQUFDO0lBRUwsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBdUI7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxxQkFBcUI7WUFDNUMsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxXQUFXO2dCQUN6QixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsVUFBVTthQUN0QztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsd0JBQXdCLEdBQUcsTUFBTSxDQUFDLHVCQUF1QixDQUFDO1FBQy9ELElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxNQUFNLENBQUMsK0JBQStCLENBQUM7UUFDL0UsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxNQUFNLENBQUMsK0JBQStCLENBQUM7UUFDL0UsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7SUFDN0MsQ0FBQztJQVFELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBa0M7UUFDdEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNNLGVBQWU7UUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFhO1FBQzlCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUMvRCxDQUFDO0lBQ0QsSUFBVyx1QkFBdUIsQ0FBQyxLQUFrQztRQUNuRSxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBYTtRQUN6QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNuQixDQUFDO0lBQ00sT0FBTztRQUNaLElBQUksQ0FBQyxHQUFHLEdBQUcsU0FBUyxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBSUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFrQztRQUM5RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLCtCQUErQjtRQUN4QyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO0lBQ3hFLENBQUM7SUFDRCxJQUFXLCtCQUErQixDQUFDLEtBQWE7UUFDdEQsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLEtBQUssQ0FBQztJQUNoRCxDQUFDO0lBQ00sb0NBQW9DO1FBQ3pDLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxTQUFTLENBQUM7SUFDcEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9DQUFvQztRQUM3QyxPQUFPLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQztJQUMvQyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWE7UUFDcEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN4RSxDQUFDO0lBQ0QsSUFBVywrQkFBK0IsQ0FBQyxLQUFhO1FBQ3RELElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxLQUFLLENBQUM7SUFDaEQsQ0FBQztJQUNNLG9DQUFvQztRQUN6QyxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsU0FBUyxDQUFDO0lBQ3BELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQ0FBb0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsZ0NBQWdDLENBQUM7SUFDL0MsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakUsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBYTtRQUNoRCxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWtDO1FBQy9ELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNNLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsU0FBUyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsV0FBVyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3ZELFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN4RCxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDL0MseUJBQXlCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztZQUNsRixFQUFFLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDckMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztZQUN2RSxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1lBQ2pFLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDekUsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNqRSxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsbUNBQW1DLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQztZQUNuRyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1lBQ2hFLGNBQWMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQztZQUM1RCxtQ0FBbUMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGdDQUFnQyxDQUFDO1lBQ25HLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDdEYscUJBQXFCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztZQUMxRSxjQUFjLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDNUQsY0FBYyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1NBQzdELENBQUM7SUFDSixDQUFDO0lBRVMsdUJBQXVCO1FBQy9CLE1BQU0sS0FBSyxHQUFHO1lBQ1osV0FBVyxFQUFFO2dCQUNYLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztnQkFDcEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7Z0JBQ3BELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO2dCQUNoRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QseUJBQXlCLEVBQUU7Z0JBQ3pCLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDO2dCQUNqRSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsRUFBRSxFQUFFO2dCQUNGLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztnQkFDM0MsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELG1CQUFtQixFQUFFO2dCQUNuQixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztnQkFDNUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELGlCQUFpQixFQUFFO2dCQUNqQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDeEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztnQkFDNUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGlCQUFpQixFQUFFO2dCQUNqQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDeEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELElBQUksRUFBRTtnQkFDSixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7Z0JBQzdDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxtQ0FBbUMsRUFBRTtnQkFDbkMsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZ0NBQWdDLENBQUM7Z0JBQ3hFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxnQkFBZ0IsRUFBRTtnQkFDaEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7Z0JBQ3hELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxjQUFjLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO2dCQUN0RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsbUNBQW1DLEVBQUU7Z0JBQ25DLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGdDQUFnQyxDQUFDO2dCQUN4RSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsNEJBQTRCLEVBQUU7Z0JBQzVCLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDO2dCQUNsRSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QscUJBQXFCLEVBQUU7Z0JBQ3JCLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO2dCQUM3RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsY0FBYyxFQUFFO2dCQUNkLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQztnQkFDdEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGNBQWMsRUFBRTtnQkFDZCxLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7Z0JBQ3RELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7U0FDRixDQUFDO1FBRUYsOEJBQThCO1FBQzlCLE9BQU8sTUFBTSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsQ0FBQyxLQUFLLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssU0FBUyxDQUFFLENBQUMsQ0FBQTtJQUM1SCxDQUFDOztBQWxmSCw4QkFtZkM7OztBQWpmQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLHdCQUFjLEdBQUcscUJBQXFCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmMuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuICovXG5cbi8vIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZVxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIFdhcmVob3VzZUNvbmZpZyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICAvKipcbiAgKiBTcGVjaWZpZXMgd2hldGhlciB0byBhdXRvbWF0aWNhbGx5IHJlc3VtZSBhIHdhcmVob3VzZSB3aGVuIGEgU1FMIHN0YXRlbWVudCAoZS5nLiBxdWVyeSkgaXMgc3VibWl0dGVkIHRvIGl0LlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2UjYXV0b19yZXN1bWUgV2FyZWhvdXNlI2F1dG9fcmVzdW1lfVxuICAqL1xuICByZWFkb25seSBhdXRvUmVzdW1lPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIG51bWJlciBvZiBzZWNvbmRzIG9mIGluYWN0aXZpdHkgYWZ0ZXIgd2hpY2ggYSB3YXJlaG91c2UgaXMgYXV0b21hdGljYWxseSBzdXNwZW5kZWQuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSNhdXRvX3N1c3BlbmQgV2FyZWhvdXNlI2F1dG9fc3VzcGVuZH1cbiAgKi9cbiAgcmVhZG9ubHkgYXV0b1N1c3BlbmQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI2NvbW1lbnQgV2FyZWhvdXNlI2NvbW1lbnR9XG4gICovXG4gIHJlYWRvbmx5IGNvbW1lbnQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSB0aGUgcXVlcnkgYWNjZWxlcmF0aW9uIHNlcnZpY2UgZm9yIHF1ZXJpZXMgdGhhdCByZWx5IG9uIHRoaXMgd2FyZWhvdXNlIGZvciBjb21wdXRlIHJlc291cmNlcy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI2VuYWJsZV9xdWVyeV9hY2NlbGVyYXRpb24gV2FyZWhvdXNlI2VuYWJsZV9xdWVyeV9hY2NlbGVyYXRpb259XG4gICovXG4gIHJlYWRvbmx5IGVuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSNpZCBXYXJlaG91c2UjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB3aGV0aGVyIHRoZSB3YXJlaG91c2UgaXMgY3JlYXRlZCBpbml0aWFsbHkgaW4gdGhlIOKAmFN1c3BlbmRlZOKAmSBzdGF0ZS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI2luaXRpYWxseV9zdXNwZW5kZWQgV2FyZWhvdXNlI2luaXRpYWxseV9zdXNwZW5kZWR9XG4gICovXG4gIHJlYWRvbmx5IGluaXRpYWxseVN1c3BlbmRlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBtYXhpbXVtIG51bWJlciBvZiBzZXJ2ZXIgY2x1c3RlcnMgZm9yIHRoZSB3YXJlaG91c2UuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSNtYXhfY2x1c3Rlcl9jb3VudCBXYXJlaG91c2UjbWF4X2NsdXN0ZXJfY291bnR9XG4gICovXG4gIHJlYWRvbmx5IG1heENsdXN0ZXJDb3VudD86IG51bWJlcjtcbiAgLyoqXG4gICogT2JqZWN0IHBhcmFtZXRlciB0aGF0IHNwZWNpZmllcyB0aGUgY29uY3VycmVuY3kgbGV2ZWwgZm9yIFNRTCBzdGF0ZW1lbnRzIChpLmUuIHF1ZXJpZXMgYW5kIERNTCkgZXhlY3V0ZWQgYnkgYSB3YXJlaG91c2UuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSNtYXhfY29uY3VycmVuY3lfbGV2ZWwgV2FyZWhvdXNlI21heF9jb25jdXJyZW5jeV9sZXZlbH1cbiAgKi9cbiAgcmVhZG9ubHkgbWF4Q29uY3VycmVuY3lMZXZlbD86IG51bWJlcjtcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBtaW5pbXVtIG51bWJlciBvZiBzZXJ2ZXIgY2x1c3RlcnMgZm9yIHRoZSB3YXJlaG91c2UgKG9ubHkgYXBwbGllcyB0byBtdWx0aS1jbHVzdGVyIHdhcmVob3VzZXMpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2UjbWluX2NsdXN0ZXJfY291bnQgV2FyZWhvdXNlI21pbl9jbHVzdGVyX2NvdW50fVxuICAqL1xuICByZWFkb25seSBtaW5DbHVzdGVyQ291bnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIElkZW50aWZpZXIgZm9yIHRoZSB2aXJ0dWFsIHdhcmVob3VzZTsgbXVzdCBiZSB1bmlxdWUgZm9yIHlvdXIgYWNjb3VudC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI25hbWUgV2FyZWhvdXNlI25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBtYXhpbXVtIHNjYWxlIGZhY3RvciBmb3IgbGVhc2luZyBjb21wdXRlIHJlc291cmNlcyBmb3IgcXVlcnkgYWNjZWxlcmF0aW9uLiBUaGUgc2NhbGUgZmFjdG9yIGlzIHVzZWQgYXMgYSBtdWx0aXBsaWVyIGJhc2VkIG9uIHdhcmVob3VzZSBzaXplLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2UjcXVlcnlfYWNjZWxlcmF0aW9uX21heF9zY2FsZV9mYWN0b3IgV2FyZWhvdXNlI3F1ZXJ5X2FjY2VsZXJhdGlvbl9tYXhfc2NhbGVfZmFjdG9yfVxuICAqL1xuICByZWFkb25seSBxdWVyeUFjY2VsZXJhdGlvbk1heFNjYWxlRmFjdG9yPzogbnVtYmVyO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIG5hbWUgb2YgYSByZXNvdXJjZSBtb25pdG9yIHRoYXQgaXMgZXhwbGljaXRseSBhc3NpZ25lZCB0byB0aGUgd2FyZWhvdXNlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2UjcmVzb3VyY2VfbW9uaXRvciBXYXJlaG91c2UjcmVzb3VyY2VfbW9uaXRvcn1cbiAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VNb25pdG9yPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIHBvbGljeSBmb3IgYXV0b21hdGljYWxseSBzdGFydGluZyBhbmQgc2h1dHRpbmcgZG93biBjbHVzdGVycyBpbiBhIG11bHRpLWNsdXN0ZXIgd2FyZWhvdXNlIHJ1bm5pbmcgaW4gQXV0by1zY2FsZSBtb2RlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2Ujc2NhbGluZ19wb2xpY3kgV2FyZWhvdXNlI3NjYWxpbmdfcG9saWN5fVxuICAqL1xuICByZWFkb25seSBzY2FsaW5nUG9saWN5Pzogc3RyaW5nO1xuICAvKipcbiAgKiBPYmplY3QgcGFyYW1ldGVyIHRoYXQgc3BlY2lmaWVzIHRoZSB0aW1lLCBpbiBzZWNvbmRzLCBhIFNRTCBzdGF0ZW1lbnQgKHF1ZXJ5LCBEREwsIERNTCwgZXRjLikgY2FuIGJlIHF1ZXVlZCBvbiBhIHdhcmVob3VzZSBiZWZvcmUgaXQgaXMgY2FuY2VsZWQgYnkgdGhlIHN5c3RlbS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI3N0YXRlbWVudF9xdWV1ZWRfdGltZW91dF9pbl9zZWNvbmRzIFdhcmVob3VzZSNzdGF0ZW1lbnRfcXVldWVkX3RpbWVvdXRfaW5fc2Vjb25kc31cbiAgKi9cbiAgcmVhZG9ubHkgc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcz86IG51bWJlcjtcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSB0aW1lLCBpbiBzZWNvbmRzLCBhZnRlciB3aGljaCBhIHJ1bm5pbmcgU1FMIHN0YXRlbWVudCAocXVlcnksIERETCwgRE1MLCBldGMuKSBpcyBjYW5jZWxlZCBieSB0aGUgc3lzdGVtXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSNzdGF0ZW1lbnRfdGltZW91dF9pbl9zZWNvbmRzIFdhcmVob3VzZSNzdGF0ZW1lbnRfdGltZW91dF9pbl9zZWNvbmRzfVxuICAqL1xuICByZWFkb25seSBzdGF0ZW1lbnRUaW1lb3V0SW5TZWNvbmRzPzogbnVtYmVyO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgd2FyZWhvdXNlLCBhZnRlciBiZWluZyByZXNpemVkLCB3YWl0cyBmb3IgYWxsIHRoZSBzZXJ2ZXJzIHRvIHByb3Zpc2lvbiBiZWZvcmUgZXhlY3V0aW5nIGFueSBxdWV1ZWQgb3IgbmV3IHF1ZXJpZXMuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSN3YWl0X2Zvcl9wcm92aXNpb25pbmcgV2FyZWhvdXNlI3dhaXRfZm9yX3Byb3Zpc2lvbmluZ31cbiAgKi9cbiAgcmVhZG9ubHkgd2FpdEZvclByb3Zpc2lvbmluZz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBzaXplIG9mIHRoZSB2aXJ0dWFsIHdhcmVob3VzZS4gTGFyZ2VyIHdhcmVob3VzZSBzaXplcyA1WC1MYXJnZSBhbmQgNlgtTGFyZ2UgYXJlIGN1cnJlbnRseSBpbiBwcmV2aWV3IGFuZCBvbmx5IGF2YWlsYWJsZSBvbiBBbWF6b24gV2ViIFNlcnZpY2VzIChBV1MpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuODQuMC9kb2NzL3Jlc291cmNlcy93YXJlaG91c2Ujd2FyZWhvdXNlX3NpemUgV2FyZWhvdXNlI3dhcmVob3VzZV9zaXplfVxuICAqL1xuICByZWFkb25seSB3YXJlaG91c2VTaXplPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgYSBTVEFOREFSRCBvciBTTk9XUEFSSy1PUFRJTUlaRUQgd2FyZWhvdXNlXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSN3YXJlaG91c2VfdHlwZSBXYXJlaG91c2Ujd2FyZWhvdXNlX3R5cGV9XG4gICovXG4gIHJlYWRvbmx5IHdhcmVob3VzZVR5cGU/OiBzdHJpbmc7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC44NC4wL2RvY3MvcmVzb3VyY2VzL3dhcmVob3VzZSBzbm93Zmxha2Vfd2FyZWhvdXNlfVxuKi9cbmV4cG9ydCBjbGFzcyBXYXJlaG91c2UgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwic25vd2ZsYWtlX3dhcmVob3VzZVwiO1xuXG4gIC8vID09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBNZXRob2RzXG4gIC8vID09PT09PT09PT09PT09XG4gIC8qKlxuICAqIEdlbmVyYXRlcyBDREtURiBjb2RlIGZvciBpbXBvcnRpbmcgYSBXYXJlaG91c2UgcmVzb3VyY2UgdXBvbiBydW5uaW5nIFwiY2RrdGYgcGxhbiA8c3RhY2stbmFtZT5cIlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGltcG9ydFRvSWQgVGhlIGNvbnN0cnVjdCBpZCB1c2VkIGluIHRoZSBnZW5lcmF0ZWQgY29uZmlnIGZvciB0aGUgV2FyZWhvdXNlIHRvIGltcG9ydFxuICAqIEBwYXJhbSBpbXBvcnRGcm9tSWQgVGhlIGlkIG9mIHRoZSBleGlzdGluZyBXYXJlaG91c2UgdGhhdCBzaG91bGQgYmUgaW1wb3J0ZWQuIFJlZmVyIHRvIHRoZSB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlI2ltcG9ydCBpbXBvcnQgc2VjdGlvbn0gaW4gdGhlIGRvY3VtZW50YXRpb24gb2YgdGhpcyByZXNvdXJjZSBmb3IgdGhlIGlkIHRvIHVzZVxuICAqIEBwYXJhbSBwcm92aWRlcj8gT3B0aW9uYWwgaW5zdGFuY2Ugb2YgdGhlIHByb3ZpZGVyIHdoZXJlIHRoZSBXYXJlaG91c2UgdG8gaW1wb3J0IGlzIGZvdW5kXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgZ2VuZXJhdGVDb25maWdGb3JJbXBvcnQoc2NvcGU6IENvbnN0cnVjdCwgaW1wb3J0VG9JZDogc3RyaW5nLCBpbXBvcnRGcm9tSWQ6IHN0cmluZywgcHJvdmlkZXI/OiBjZGt0Zi5UZXJyYWZvcm1Qcm92aWRlcikge1xuICAgICAgICByZXR1cm4gbmV3IGNka3RmLkltcG9ydGFibGVSZXNvdXJjZShzY29wZSwgaW1wb3J0VG9JZCwgeyB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6IFwic25vd2ZsYWtlX3dhcmVob3VzZVwiLCBpbXBvcnRJZDogaW1wb3J0RnJvbUlkLCBwcm92aWRlciB9KTtcbiAgICAgIH1cblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjg0LjAvZG9jcy9yZXNvdXJjZXMvd2FyZWhvdXNlIHNub3dmbGFrZV93YXJlaG91c2V9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIFdhcmVob3VzZUNvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBXYXJlaG91c2VDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ3Nub3dmbGFrZV93YXJlaG91c2UnLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnc25vd2ZsYWtlJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnMC44NC4wJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJyB+PiAwLjQwJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlLFxuICAgICAgcHJvdmlzaW9uZXJzOiBjb25maWcucHJvdmlzaW9uZXJzLFxuICAgICAgY29ubmVjdGlvbjogY29uZmlnLmNvbm5lY3Rpb24sXG4gICAgICBmb3JFYWNoOiBjb25maWcuZm9yRWFjaFxuICAgIH0pO1xuICAgIHRoaXMuX2F1dG9SZXN1bWUgPSBjb25maWcuYXV0b1Jlc3VtZTtcbiAgICB0aGlzLl9hdXRvU3VzcGVuZCA9IGNvbmZpZy5hdXRvU3VzcGVuZDtcbiAgICB0aGlzLl9jb21tZW50ID0gY29uZmlnLmNvbW1lbnQ7XG4gICAgdGhpcy5fZW5hYmxlUXVlcnlBY2NlbGVyYXRpb24gPSBjb25maWcuZW5hYmxlUXVlcnlBY2NlbGVyYXRpb247XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5faW5pdGlhbGx5U3VzcGVuZGVkID0gY29uZmlnLmluaXRpYWxseVN1c3BlbmRlZDtcbiAgICB0aGlzLl9tYXhDbHVzdGVyQ291bnQgPSBjb25maWcubWF4Q2x1c3RlckNvdW50O1xuICAgIHRoaXMuX21heENvbmN1cnJlbmN5TGV2ZWwgPSBjb25maWcubWF4Q29uY3VycmVuY3lMZXZlbDtcbiAgICB0aGlzLl9taW5DbHVzdGVyQ291bnQgPSBjb25maWcubWluQ2x1c3RlckNvdW50O1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9xdWVyeUFjY2VsZXJhdGlvbk1heFNjYWxlRmFjdG9yID0gY29uZmlnLnF1ZXJ5QWNjZWxlcmF0aW9uTWF4U2NhbGVGYWN0b3I7XG4gICAgdGhpcy5fcmVzb3VyY2VNb25pdG9yID0gY29uZmlnLnJlc291cmNlTW9uaXRvcjtcbiAgICB0aGlzLl9zY2FsaW5nUG9saWN5ID0gY29uZmlnLnNjYWxpbmdQb2xpY3k7XG4gICAgdGhpcy5fc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcyA9IGNvbmZpZy5zdGF0ZW1lbnRRdWV1ZWRUaW1lb3V0SW5TZWNvbmRzO1xuICAgIHRoaXMuX3N0YXRlbWVudFRpbWVvdXRJblNlY29uZHMgPSBjb25maWcuc3RhdGVtZW50VGltZW91dEluU2Vjb25kcztcbiAgICB0aGlzLl93YWl0Rm9yUHJvdmlzaW9uaW5nID0gY29uZmlnLndhaXRGb3JQcm92aXNpb25pbmc7XG4gICAgdGhpcy5fd2FyZWhvdXNlU2l6ZSA9IGNvbmZpZy53YXJlaG91c2VTaXplO1xuICAgIHRoaXMuX3dhcmVob3VzZVR5cGUgPSBjb25maWcud2FyZWhvdXNlVHlwZTtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYXV0b19yZXN1bWUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRvUmVzdW1lPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBhdXRvUmVzdW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2F1dG9fcmVzdW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBhdXRvUmVzdW1lKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9hdXRvUmVzdW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXV0b1Jlc3VtZSgpIHtcbiAgICB0aGlzLl9hdXRvUmVzdW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhdXRvUmVzdW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F1dG9SZXN1bWU7XG4gIH1cblxuICAvLyBhdXRvX3N1c3BlbmQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRvU3VzcGVuZD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgYXV0b1N1c3BlbmQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdhdXRvX3N1c3BlbmQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGF1dG9TdXNwZW5kKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9hdXRvU3VzcGVuZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEF1dG9TdXNwZW5kKCkge1xuICAgIHRoaXMuX2F1dG9TdXNwZW5kID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhdXRvU3VzcGVuZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hdXRvU3VzcGVuZDtcbiAgfVxuXG4gIC8vIGNvbW1lbnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY29tbWVudD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY29tbWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NvbW1lbnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbW1lbnQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NvbW1lbnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDb21tZW50KCkge1xuICAgIHRoaXMuX2NvbW1lbnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvbW1lbnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29tbWVudDtcbiAgfVxuXG4gIC8vIGVuYWJsZV9xdWVyeV9hY2NlbGVyYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5hYmxlUXVlcnlBY2NlbGVyYXRpb24/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGVuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9xdWVyeV9hY2NlbGVyYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9lbmFibGVRdWVyeUFjY2VsZXJhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uKCkge1xuICAgIHRoaXMuX2VuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbmFibGVRdWVyeUFjY2VsZXJhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVRdWVyeUFjY2VsZXJhdGlvbjtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElkKCkge1xuICAgIHRoaXMuX2lkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pZDtcbiAgfVxuXG4gIC8vIGluaXRpYWxseV9zdXNwZW5kZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5pdGlhbGx5U3VzcGVuZGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBpbml0aWFsbHlTdXNwZW5kZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnaW5pdGlhbGx5X3N1c3BlbmRlZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaW5pdGlhbGx5U3VzcGVuZGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9pbml0aWFsbHlTdXNwZW5kZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJbml0aWFsbHlTdXNwZW5kZWQoKSB7XG4gICAgdGhpcy5faW5pdGlhbGx5U3VzcGVuZGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpbml0aWFsbHlTdXNwZW5kZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faW5pdGlhbGx5U3VzcGVuZGVkO1xuICB9XG5cbiAgLy8gbWF4X2NsdXN0ZXJfY291bnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYXhDbHVzdGVyQ291bnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1heENsdXN0ZXJDb3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21heF9jbHVzdGVyX2NvdW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtYXhDbHVzdGVyQ291bnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX21heENsdXN0ZXJDb3VudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1heENsdXN0ZXJDb3VudCgpIHtcbiAgICB0aGlzLl9tYXhDbHVzdGVyQ291bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1heENsdXN0ZXJDb3VudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXhDbHVzdGVyQ291bnQ7XG4gIH1cblxuICAvLyBtYXhfY29uY3VycmVuY3lfbGV2ZWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWF4Q29uY3VycmVuY3lMZXZlbD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbWF4Q29uY3VycmVuY3lMZXZlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21heF9jb25jdXJyZW5jeV9sZXZlbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWF4Q29uY3VycmVuY3lMZXZlbCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWF4Q29uY3VycmVuY3lMZXZlbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1heENvbmN1cnJlbmN5TGV2ZWwoKSB7XG4gICAgdGhpcy5fbWF4Q29uY3VycmVuY3lMZXZlbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWF4Q29uY3VycmVuY3lMZXZlbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXhDb25jdXJyZW5jeUxldmVsO1xuICB9XG5cbiAgLy8gbWluX2NsdXN0ZXJfY291bnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9taW5DbHVzdGVyQ291bnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1pbkNsdXN0ZXJDb3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21pbl9jbHVzdGVyX2NvdW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtaW5DbHVzdGVyQ291bnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX21pbkNsdXN0ZXJDb3VudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1pbkNsdXN0ZXJDb3VudCgpIHtcbiAgICB0aGlzLl9taW5DbHVzdGVyQ291bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1pbkNsdXN0ZXJDb3VudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9taW5DbHVzdGVyQ291bnQ7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmFtZTtcbiAgfVxuXG4gIC8vIHF1ZXJ5X2FjY2VsZXJhdGlvbl9tYXhfc2NhbGVfZmFjdG9yIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3F1ZXJ5QWNjZWxlcmF0aW9uTWF4U2NhbGVGYWN0b3I/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHF1ZXJ5QWNjZWxlcmF0aW9uTWF4U2NhbGVGYWN0b3IoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdxdWVyeV9hY2NlbGVyYXRpb25fbWF4X3NjYWxlX2ZhY3RvcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcXVlcnlBY2NlbGVyYXRpb25NYXhTY2FsZUZhY3Rvcih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcXVlcnlBY2NlbGVyYXRpb25NYXhTY2FsZUZhY3RvciA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFF1ZXJ5QWNjZWxlcmF0aW9uTWF4U2NhbGVGYWN0b3IoKSB7XG4gICAgdGhpcy5fcXVlcnlBY2NlbGVyYXRpb25NYXhTY2FsZUZhY3RvciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcXVlcnlBY2NlbGVyYXRpb25NYXhTY2FsZUZhY3RvcklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9xdWVyeUFjY2VsZXJhdGlvbk1heFNjYWxlRmFjdG9yO1xuICB9XG5cbiAgLy8gcmVzb3VyY2VfbW9uaXRvciAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Jlc291cmNlTW9uaXRvcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcmVzb3VyY2VNb25pdG9yKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVzb3VyY2VfbW9uaXRvcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVzb3VyY2VNb25pdG9yKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNvdXJjZU1vbml0b3IgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXNvdXJjZU1vbml0b3IoKSB7XG4gICAgdGhpcy5fcmVzb3VyY2VNb25pdG9yID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNvdXJjZU1vbml0b3JJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2VNb25pdG9yO1xuICB9XG5cbiAgLy8gc2NhbGluZ19wb2xpY3kgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zY2FsaW5nUG9saWN5Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzY2FsaW5nUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc2NhbGluZ19wb2xpY3knKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNjYWxpbmdQb2xpY3kodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3NjYWxpbmdQb2xpY3kgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTY2FsaW5nUG9saWN5KCkge1xuICAgIHRoaXMuX3NjYWxpbmdQb2xpY3kgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNjYWxpbmdQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2NhbGluZ1BvbGljeTtcbiAgfVxuXG4gIC8vIHN0YXRlbWVudF9xdWV1ZWRfdGltZW91dF9pbl9zZWNvbmRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0YXRlbWVudFF1ZXVlZFRpbWVvdXRJblNlY29uZHM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHN0YXRlbWVudFF1ZXVlZFRpbWVvdXRJblNlY29uZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdzdGF0ZW1lbnRfcXVldWVkX3RpbWVvdXRfaW5fc2Vjb25kcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN0YXRlbWVudFF1ZXVlZFRpbWVvdXRJblNlY29uZHMoKSB7XG4gICAgdGhpcy5fc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdGF0ZW1lbnRRdWV1ZWRUaW1lb3V0SW5TZWNvbmRzO1xuICB9XG5cbiAgLy8gc3RhdGVtZW50X3RpbWVvdXRfaW5fc2Vjb25kcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zdGF0ZW1lbnRUaW1lb3V0SW5TZWNvbmRzPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBzdGF0ZW1lbnRUaW1lb3V0SW5TZWNvbmRzKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnc3RhdGVtZW50X3RpbWVvdXRfaW5fc2Vjb25kcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RhdGVtZW50VGltZW91dEluU2Vjb25kcyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fc3RhdGVtZW50VGltZW91dEluU2Vjb25kcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN0YXRlbWVudFRpbWVvdXRJblNlY29uZHMoKSB7XG4gICAgdGhpcy5fc3RhdGVtZW50VGltZW91dEluU2Vjb25kcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RhdGVtZW50VGltZW91dEluU2Vjb25kc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdGF0ZW1lbnRUaW1lb3V0SW5TZWNvbmRzO1xuICB9XG5cbiAgLy8gd2FpdF9mb3JfcHJvdmlzaW9uaW5nIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3dhaXRGb3JQcm92aXNpb25pbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHdhaXRGb3JQcm92aXNpb25pbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnd2FpdF9mb3JfcHJvdmlzaW9uaW5nJyk7XG4gIH1cbiAgcHVibGljIHNldCB3YWl0Rm9yUHJvdmlzaW9uaW5nKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl93YWl0Rm9yUHJvdmlzaW9uaW5nID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0V2FpdEZvclByb3Zpc2lvbmluZygpIHtcbiAgICB0aGlzLl93YWl0Rm9yUHJvdmlzaW9uaW5nID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB3YWl0Rm9yUHJvdmlzaW9uaW5nSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3dhaXRGb3JQcm92aXNpb25pbmc7XG4gIH1cblxuICAvLyB3YXJlaG91c2Vfc2l6ZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3dhcmVob3VzZVNpemU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHdhcmVob3VzZVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd3YXJlaG91c2Vfc2l6ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgd2FyZWhvdXNlU2l6ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fd2FyZWhvdXNlU2l6ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFdhcmVob3VzZVNpemUoKSB7XG4gICAgdGhpcy5fd2FyZWhvdXNlU2l6ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgd2FyZWhvdXNlU2l6ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl93YXJlaG91c2VTaXplO1xuICB9XG5cbiAgLy8gd2FyZWhvdXNlX3R5cGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfd2FyZWhvdXNlVHlwZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgd2FyZWhvdXNlVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3dhcmVob3VzZV90eXBlJyk7XG4gIH1cbiAgcHVibGljIHNldCB3YXJlaG91c2VUeXBlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl93YXJlaG91c2VUeXBlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0V2FyZWhvdXNlVHlwZSgpIHtcbiAgICB0aGlzLl93YXJlaG91c2VUeXBlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB3YXJlaG91c2VUeXBlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3dhcmVob3VzZVR5cGU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGF1dG9fcmVzdW1lOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fYXV0b1Jlc3VtZSksXG4gICAgICBhdXRvX3N1c3BlbmQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX2F1dG9TdXNwZW5kKSxcbiAgICAgIGNvbW1lbnQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NvbW1lbnQpLFxuICAgICAgZW5hYmxlX3F1ZXJ5X2FjY2VsZXJhdGlvbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2VuYWJsZVF1ZXJ5QWNjZWxlcmF0aW9uKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBpbml0aWFsbHlfc3VzcGVuZGVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5faW5pdGlhbGx5U3VzcGVuZGVkKSxcbiAgICAgIG1heF9jbHVzdGVyX2NvdW50OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9tYXhDbHVzdGVyQ291bnQpLFxuICAgICAgbWF4X2NvbmN1cnJlbmN5X2xldmVsOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9tYXhDb25jdXJyZW5jeUxldmVsKSxcbiAgICAgIG1pbl9jbHVzdGVyX2NvdW50OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9taW5DbHVzdGVyQ291bnQpLFxuICAgICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICBxdWVyeV9hY2NlbGVyYXRpb25fbWF4X3NjYWxlX2ZhY3RvcjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fcXVlcnlBY2NlbGVyYXRpb25NYXhTY2FsZUZhY3RvciksXG4gICAgICByZXNvdXJjZV9tb25pdG9yOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9yZXNvdXJjZU1vbml0b3IpLFxuICAgICAgc2NhbGluZ19wb2xpY3k6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3NjYWxpbmdQb2xpY3kpLFxuICAgICAgc3RhdGVtZW50X3F1ZXVlZF90aW1lb3V0X2luX3NlY29uZHM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3N0YXRlbWVudFF1ZXVlZFRpbWVvdXRJblNlY29uZHMpLFxuICAgICAgc3RhdGVtZW50X3RpbWVvdXRfaW5fc2Vjb25kczogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fc3RhdGVtZW50VGltZW91dEluU2Vjb25kcyksXG4gICAgICB3YWl0X2Zvcl9wcm92aXNpb25pbmc6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl93YWl0Rm9yUHJvdmlzaW9uaW5nKSxcbiAgICAgIHdhcmVob3VzZV9zaXplOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl93YXJlaG91c2VTaXplKSxcbiAgICAgIHdhcmVob3VzZV90eXBlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl93YXJlaG91c2VUeXBlKSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVIY2xBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBjb25zdCBhdHRycyA9IHtcbiAgICAgIGF1dG9fcmVzdW1lOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fYXV0b1Jlc3VtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBhdXRvX3N1c3BlbmQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX2F1dG9TdXNwZW5kKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgY29tbWVudDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fY29tbWVudCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIGVuYWJsZV9xdWVyeV9hY2NlbGVyYXRpb246IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9lbmFibGVRdWVyeUFjY2VsZXJhdGlvbiksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBpZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBpbml0aWFsbHlfc3VzcGVuZGVkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5faW5pdGlhbGx5U3VzcGVuZGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIG1heF9jbHVzdGVyX2NvdW50OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9tYXhDbHVzdGVyQ291bnQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBtYXhfY29uY3VycmVuY3lfbGV2ZWw6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX21heENvbmN1cnJlbmN5TGV2ZWwpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBtaW5fY2x1c3Rlcl9jb3VudDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fbWluQ2x1c3RlckNvdW50KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgbmFtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHF1ZXJ5X2FjY2VsZXJhdGlvbl9tYXhfc2NhbGVfZmFjdG9yOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9xdWVyeUFjY2VsZXJhdGlvbk1heFNjYWxlRmFjdG9yKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgcmVzb3VyY2VfbW9uaXRvcjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fcmVzb3VyY2VNb25pdG9yKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgc2NhbGluZ19wb2xpY3k6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3NjYWxpbmdQb2xpY3kpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBzdGF0ZW1lbnRfcXVldWVkX3RpbWVvdXRfaW5fc2Vjb25kczoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fc3RhdGVtZW50UXVldWVkVGltZW91dEluU2Vjb25kcyksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcIm51bWJlclwiLFxuICAgICAgfSxcbiAgICAgIHN0YXRlbWVudF90aW1lb3V0X2luX3NlY29uZHM6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX3N0YXRlbWVudFRpbWVvdXRJblNlY29uZHMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICB3YWl0X2Zvcl9wcm92aXNpb25pbmc6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl93YWl0Rm9yUHJvdmlzaW9uaW5nKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHdhcmVob3VzZV9zaXplOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl93YXJlaG91c2VTaXplKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgd2FyZWhvdXNlX3R5cGU6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3dhcmVob3VzZVR5cGUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIC8vIHJlbW92ZSB1bmRlZmluZWQgYXR0cmlidXRlc1xuICAgIHJldHVybiBPYmplY3QuZnJvbUVudHJpZXMoT2JqZWN0LmVudHJpZXMoYXR0cnMpLmZpbHRlcigoW18sIHZhbHVlXSkgPT4gdmFsdWUgIT09IHVuZGVmaW5lZCAmJiB2YWx1ZS52YWx1ZSAhPT0gdW5kZWZpbmVkICkpXG4gIH1cbn1cbiJdfQ==