module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = __webpack_require__(1);
const codeCommit = new aws_sdk_1.CodeCommit();
exports.handler = async (event) => {
    const { region, detail } = event;
    const shouldUpdateApprovalState = process.env.UPDATE_APPROVAL_STATE === 'TRUE';
    const shouldPostComment = process.env.POST_COMMENT === 'TRUE';
    const { pullRequestId, revisionId, repositoryName, beforeCommitId, afterCommitId } = getPullRequestProps(detail);
    const s3Prefix = region === 'us-east-1' ? 's3' : `s3-${region}`;
    switch (detail['build-status']) {
        case CodeBuildState.IN_PROGRESS:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'REVOKE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content: `** Build started at ${'time'} **`,
                })
                    .promise();
            }
            break;
        case CodeBuildState.FAILED:
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/failing.svg`;
                const content = `![Failing](${badge} "Failing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.SUCCEEDED:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'APPROVE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/passing.svg`;
                const content = `![Passing](${badge} "Passing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.STOPPED:
            console.log('Build stopped!');
            break;
        default:
            throw new Error(`Invalid build status: ${detail['build-status']}`);
    }
};
const getPullRequestProps = (detail) => {
    let repositoryName = '';
    let pullRequestId = '';
    let beforeCommitId = '';
    let afterCommitId = '';
    let revisionId = '';
    detail['additional-information'].environment['environment-variables'].forEach(({ name, value }) => {
        switch (name) {
            case 'pullRequestId':
                pullRequestId = value;
                break;
            case 'repositoryName':
                repositoryName = value;
                break;
            case 'sourceCommit':
                beforeCommitId = value;
                break;
            case 'destinationCommit':
                afterCommitId = value;
                break;
            case 'revisionId':
                revisionId = value;
                break;
            default:
                throw new Error(`Unknown environment variable: ${name}`);
        }
    });
    return {
        repositoryName,
        pullRequestId,
        beforeCommitId,
        afterCommitId,
        revisionId,
    };
};
var CodeBuildState;
(function (CodeBuildState) {
    CodeBuildState["IN_PROGRESS"] = "IN_PROGRESS";
    CodeBuildState["SUCCEEDED"] = "SUCCEEDED";
    CodeBuildState["FAILED"] = "FAILED";
    CodeBuildState["STOPPED"] = "STOPPED";
})(CodeBuildState || (CodeBuildState = {}));


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = require("aws-sdk");

/***/ })
/******/ ]);
//# sourceMappingURL=index.js.map