# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class ApiStatusGet200Response(BaseModel):
    """
    ApiStatusGet200Response
    """
    var_date: datetime = Field(default=..., alias="date")
    message: StrictStr = Field(...)
    email_configured: Optional[StrictBool] = Field(default=None, alias="emailConfigured")
    invite_only_signup: Optional[StrictBool] = Field(default=None, alias="inviteOnlySignup")
    redis_configured: Optional[StrictBool] = Field(default=None, alias="redisConfigured")
    secret_scanning_configured: Optional[StrictBool] = Field(default=None, alias="secretScanningConfigured")
    saml_default_org_slug: Optional[StrictStr] = Field(default=None, alias="samlDefaultOrgSlug")
    __properties = ["date", "message", "emailConfigured", "inviteOnlySignup", "redisConfigured", "secretScanningConfigured", "samlDefaultOrgSlug"]

    @validator('message')
    def message_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Ok'):
            raise ValueError("must be one of enum values ('Ok')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiStatusGet200Response:
        """Create an instance of ApiStatusGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiStatusGet200Response:
        """Create an instance of ApiStatusGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiStatusGet200Response.parse_obj(obj)

        _obj = ApiStatusGet200Response.parse_obj({
            "var_date": obj.get("date"),
            "message": obj.get("message"),
            "email_configured": obj.get("emailConfigured"),
            "invite_only_signup": obj.get("inviteOnlySignup"),
            "redis_configured": obj.get("redisConfigured"),
            "secret_scanning_configured": obj.get("secretScanningConfigured"),
            "saml_default_org_slug": obj.get("samlDefaultOrgSlug")
        })
        return _obj


