# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ApiV1AccessApprovalsRequestsPost200ResponseApproval(BaseModel):
    """
    ApiV1AccessApprovalsRequestsPost200ResponseApproval
    """
    id: StrictStr = Field(...)
    policy_id: StrictStr = Field(default=..., alias="policyId")
    privilege_id: Optional[StrictStr] = Field(default=None, alias="privilegeId")
    requested_by: StrictStr = Field(default=..., alias="requestedBy")
    is_temporary: StrictBool = Field(default=..., alias="isTemporary")
    temporary_range: Optional[StrictStr] = Field(default=None, alias="temporaryRange")
    permissions: Optional[Any] = None
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    __properties = ["id", "policyId", "privilegeId", "requestedBy", "isTemporary", "temporaryRange", "permissions", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AccessApprovalsRequestsPost200ResponseApproval:
        """Create an instance of ApiV1AccessApprovalsRequestsPost200ResponseApproval from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if privilege_id (nullable) is None
        # and __fields_set__ contains the field
        if self.privilege_id is None and "privilege_id" in self.__fields_set__:
            _dict['privilegeId'] = None

        # set to None if temporary_range (nullable) is None
        # and __fields_set__ contains the field
        if self.temporary_range is None and "temporary_range" in self.__fields_set__:
            _dict['temporaryRange'] = None

        # set to None if permissions (nullable) is None
        # and __fields_set__ contains the field
        if self.permissions is None and "permissions" in self.__fields_set__:
            _dict['permissions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AccessApprovalsRequestsPost200ResponseApproval:
        """Create an instance of ApiV1AccessApprovalsRequestsPost200ResponseApproval from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AccessApprovalsRequestsPost200ResponseApproval.parse_obj(obj)

        _obj = ApiV1AccessApprovalsRequestsPost200ResponseApproval.parse_obj({
            "id": obj.get("id"),
            "policy_id": obj.get("policyId"),
            "privilege_id": obj.get("privilegeId"),
            "requested_by": obj.get("requestedBy"),
            "is_temporary": obj.get("isTemporary"),
            "temporary_range": obj.get("temporaryRange"),
            "permissions": obj.get("permissions"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


