# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, constr
from infisicalapi_client.models.api_v1_additional_privilege_identity_patch_request_privilege_details import ApiV1AdditionalPrivilegeIdentityPatchRequestPrivilegeDetails

class ApiV1AdditionalPrivilegeIdentityPatchRequest(BaseModel):
    """
    ApiV1AdditionalPrivilegeIdentityPatchRequest
    """
    privilege_slug: constr(strict=True, min_length=1) = Field(default=..., alias="privilegeSlug", description="The slug of the privilege to update.")
    identity_id: constr(strict=True, min_length=1) = Field(default=..., alias="identityId", description="The ID of the identity to update.")
    project_slug: constr(strict=True, min_length=1) = Field(default=..., alias="projectSlug", description="The slug of the project of the identity in.")
    privilege_details: ApiV1AdditionalPrivilegeIdentityPatchRequestPrivilegeDetails = Field(default=..., alias="privilegeDetails")
    __properties = ["privilegeSlug", "identityId", "projectSlug", "privilegeDetails"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AdditionalPrivilegeIdentityPatchRequest:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of privilege_details
        if self.privilege_details:
            _dict['privilegeDetails'] = self.privilege_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AdditionalPrivilegeIdentityPatchRequest:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AdditionalPrivilegeIdentityPatchRequest.parse_obj(obj)

        _obj = ApiV1AdditionalPrivilegeIdentityPatchRequest.parse_obj({
            "privilege_slug": obj.get("privilegeSlug"),
            "identity_id": obj.get("identityId"),
            "project_slug": obj.get("projectSlug"),
            "privilege_details": ApiV1AdditionalPrivilegeIdentityPatchRequestPrivilegeDetails.from_dict(obj.get("privilegeDetails")) if obj.get("privilegeDetails") is not None else None
        })
        return _obj


